/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers;

import java.util.HashMap;
import java.util.Map;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.DataTransport;
import org.opengts.db.EventDataProviderAdapter;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.db.tables.StatusCode;
import org.opengts.db.tables.Transport;
import org.opengts.dbtools.DBException;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class GPSEvent
extends EventDataProviderAdapter
implements GeoPointProvider {
    private static final boolean USE_EVENTDATA_SETVALUE = true;
    private static final boolean USE_ALTERNATE_FIELD_MAP = false;
    private DCServerConfig server = null;
    private RTProperties fieldValues = null;
    private HashMap<String, Object> otherValues = null;
    private Device device = null;
    private DataTransport dataXPort = null;
    private int eventTotalCount = 0;
    private int eventIndex = -1;
    private boolean isLastEventInList = false;

    public GPSEvent(DCServerConfig server, String ipAddress, int clientPort, Device device) {
        this.server = server;
        this.fieldValues = new RTProperties();
        this._setDevice(device, ipAddress, clientPort);
    }

    public GPSEvent(DCServerConfig server, String ipAddress, int clientPort, String modemID) {
        this.server = server;
        this.fieldValues = new RTProperties();
        Device device = this.loadDevice(modemID);
        this._setDevice(device, ipAddress, clientPort);
    }

    public GPSEvent(DCServerConfig server, String ipAddress, int clientPort, String acctID, String devID) {
        this.server = server;
        this.fieldValues = new RTProperties();
        Device device = this.loadDevice(acctID, devID);
        this._setDevice(device, ipAddress, clientPort);
    }

    protected String getDeviceCode() {
        return this.server != null ? this.server.getName() : "unknown";
    }

    protected Device loadDevice(String modemID) {
        if (this.server != null) {
            return this.server.loadDeviceUniqueID(modemID);
        }
        return DCServerFactory._loadDeviceByPrefixedModemID(null, modemID);
    }

    protected Device loadDevice(String acctID, String devID) {
        if (StringTools.isBlank(acctID)) {
            return this.loadDevice(devID);
        }
        try {
            Account account = Account.getAccount(acctID);
            if (account == null) {
                Print.logError("Account-ID not found: " + acctID, new Object[0]);
                return null;
            }
            Device dev = Transport.loadDeviceByTransportID(account, devID);
            return dev;
        }
        catch (DBException dbe) {
            Print.logError("Error getting Device: " + acctID + "/" + devID + " [" + dbe + "]", new Object[0]);
            return null;
        }
    }

    protected boolean _setDevice(Device device, String ipAddress, int clientPort) {
        if (device == null) {
            return false;
        }
        DataTransport dataXPort = device.getDataTransport();
        if (ipAddress != null && !dataXPort.isValidIPAddress(ipAddress)) {
            Print.logError("Invalid IPAddr: " + device.getAccountID() + "/" + device.getDeviceID() + " Found=" + ipAddress + " Expect=" + dataXPort.getIpAddressValid(), new Object[0]);
            return false;
        }
        this.device = device;
        this.dataXPort = dataXPort;
        this.dataXPort.setIpAddressCurrent(ipAddress);
        this.dataXPort.setRemotePortCurrent(clientPort);
        this.dataXPort.setDeviceCode(this.getDeviceCode());
        this.device.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
        return true;
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public Device getDevice() {
        return this.device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateDevice() {
        if (this.device != null) {
            try {
                this.device.updateChangedEventFields();
                boolean bl = true;
                return bl;
            }
            catch (DBException dbe) {
                Print.logException("Unable to update Device: " + this.getAccountID() + "/" + this.getDeviceID(), dbe);
            }
        }
        return false;
    }

    public boolean insertEventData(long fixtime, int statusCode) {
        return this.insertEventData(fixtime, statusCode, null);
    }

    public boolean insertEventData(long fixtime, int statusCode, Geozone zone) {
        this.setTimestamp(fixtime);
        this.setStatusCode(statusCode);
        this.setGeozone(zone);
        return this.insertEventData();
    }

    public boolean insertEventData() {
        Object fldv;
        if (this.device == null) {
            return false;
        }
        if (RTConfig.isDebugMode()) {
            Print.logDebug("Inserting EventData ...\n" + this.toString(), new Object[0]);
        }
        String acctID = this.device.getAccountID();
        String devID = this.device.getDeviceID();
        long fixtime = this.getTimestamp();
        int statusCode = this.getStatusCode();
        EventData.Key evKey = new EventData.Key(acctID, devID, fixtime, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        for (Object obj : this.fieldValues.getPropertyKeys()) {
            if (obj.equals("timestamp") || obj.equals("statusCode") || (fldv = this.fieldValues.getProperty(obj, null)) == null) continue;
            evdb.setValue((String)obj, fldv);
        }
        if (this.otherValues != null) {
            for (String string : this.otherValues.keySet()) {
                if (string.equals("timestamp") || string.equals("statusCode") || (fldv = this.otherValues.get(string)) == null) continue;
                evdb.setValue(string, fldv);
            }
        }
        Print.logInfo("Event     : [0x" + StringTools.toHexString(statusCode, 16) + "] " + StatusCodes.GetDescription(statusCode, null), new Object[0]);
        this.device.insertEventData(evdb);
        ++this.eventTotalCount;
        return true;
    }

    public String getUniqueID() {
        return this.device != null ? this.device.getUniqueID() : "";
    }

    @Override
    public String getAccountID() {
        return this.device != null ? this.device.getAccountID() : "";
    }

    @Override
    public String getDeviceID() {
        return this.device != null ? this.device.getDeviceID() : "";
    }

    @Override
    public String getDeviceDescription() {
        return this.device != null ? this.device.getDescription() : "";
    }

    @Override
    public String getDeviceVIN() {
        return this.device != null ? this.device.getDeviceVIN() : "";
    }

    @Override
    public String getStatusCodeDescription(BasicPrivateLabel bpl) {
        Device dev = this.getDevice();
        int code = this.getStatusCode();
        return StatusCode.getDescription(dev, code, bpl, null);
    }

    @Override
    public int getPushpinIconIndex(String iconSelector, OrderedSet<String> iconKeys, boolean isFleet, BasicPrivateLabel bpl) {
        return 2;
    }

    public RTProperties getProperties() {
        return this.fieldValues;
    }

    public Map<String, Object> getAlternateFieldMap() {
        if (this.otherValues == null) {
            this.otherValues = new HashMap();
        }
        return this.otherValues;
    }

    public void setTimestamp(long timestamp) {
        this.fieldValues.setLong("timestamp", timestamp);
    }

    public boolean hasTimestamp() {
        return this.fieldValues.hasProperty("timestamp");
    }

    @Override
    public long getTimestamp() {
        return this.fieldValues.getLong("timestamp", 0L);
    }

    public void setStatusCode(int code) {
        this.fieldValues.setInt("statusCode", code);
    }

    public boolean hasStatusCode() {
        return this.fieldValues.hasProperty("statusCode");
    }

    @Override
    public int getStatusCode() {
        return this.fieldValues.getInt("statusCode", 61472);
    }

    public void setLatitude(double lat) {
        this.fieldValues.setDouble("latitude", lat);
    }

    public boolean hasLatitude() {
        return this.fieldValues.hasProperty("latitude");
    }

    @Override
    public double getLatitude() {
        return this.fieldValues.getDouble("latitude", 0.0);
    }

    public void setLongitude(double lon) {
        this.fieldValues.setDouble("longitude", lon);
    }

    public boolean hasLongitude() {
        return this.fieldValues.hasProperty("longitude");
    }

    @Override
    public double getLongitude() {
        return this.fieldValues.getDouble("longitude", 0.0);
    }

    public void setGeoPoint(GeoPoint gp) {
        if (gp == null || !gp.isValid()) {
            this.setLatitude(0.0);
            this.setLongitude(0.0);
        } else {
            this.setLatitude(gp.getLatitude());
            this.setLongitude(gp.getLongitude());
        }
    }

    @Override
    public GeoPoint getGeoPoint() {
        return new GeoPoint(this.getLatitude(), this.getLongitude());
    }

    @Override
    public boolean isValidGeoPoint() {
        return GeoPoint.isValid(this.getLatitude(), this.getLongitude());
    }

    public void setHorzAccuracy(double acc) {
        this.fieldValues.setDouble("horzAccuracy", acc);
    }

    public boolean hasHorzAccuracy() {
        return this.fieldValues.hasProperty("horzAccuracy");
    }

    @Override
    public double getHorzAccuracy() {
        return this.fieldValues.getDouble("horzAccuracy", 0.0);
    }

    @Override
    public GeoPoint getBestGeoPoint() {
        return this.getGeoPoint();
    }

    @Override
    public double getBestAccuracy() {
        return this.getHorzAccuracy();
    }

    public void setGpsAge(long ageSec) {
        this.fieldValues.setLong("gpsAge", ageSec);
    }

    public boolean hasGpsAge() {
        return this.fieldValues.hasProperty("gpsAge");
    }

    @Override
    public long getGpsAge() {
        return this.fieldValues.getLong("gpsAge", 0L);
    }

    public void setHDOP(double hdop) {
        this.fieldValues.setDouble("HDOP", hdop);
    }

    public boolean hasHDOP() {
        return this.fieldValues.hasProperty("HDOP");
    }

    public double getHDOP() {
        return this.fieldValues.getDouble("HDOP", 0.0);
    }

    public void setSatelliteCount(int count) {
        this.fieldValues.setInt("satelliteCount", count);
    }

    public boolean hasSatelliteCount() {
        return this.fieldValues.hasProperty("satelliteCount");
    }

    @Override
    public int getSatelliteCount() {
        return this.fieldValues.getInt("satelliteCount", -1);
    }

    public void setBatteryLevel(double level) {
        this.fieldValues.setDouble("batteryLevel", level);
    }

    public boolean hasBatteryLevel() {
        return this.fieldValues.hasProperty("batteryLevel");
    }

    @Override
    public double getBatteryLevel() {
        return this.fieldValues.getDouble("batteryLevel", 0.0);
    }

    public void setSignalStrength(double rssi) {
        this.fieldValues.setDouble("signalStrength", rssi);
    }

    public boolean hasSignalStrength() {
        return this.fieldValues.hasProperty("signalStrength");
    }

    public double getSignalStrength() {
        return this.fieldValues.getDouble("signalStrength", 0.0);
    }

    public void setSpeedKPH(double kph) {
        this.fieldValues.setDouble("speedKPH", kph);
    }

    public boolean hasSpeedKPH() {
        return this.fieldValues.hasProperty("speedKPH");
    }

    @Override
    public double getSpeedKPH() {
        return this.fieldValues.getDouble("speedKPH", 0.0);
    }

    public void setHeading(double heading) {
        this.fieldValues.setDouble("heading", heading);
    }

    public boolean hasHeading() {
        return this.fieldValues.hasProperty("heading");
    }

    @Override
    public double getHeading() {
        return this.fieldValues.getDouble("heading", 0.0);
    }

    public void setAltitude(double altM) {
        this.fieldValues.setDouble("altitude", altM);
    }

    public boolean hasAltitude() {
        return this.fieldValues.hasProperty("altitude");
    }

    @Override
    public double getAltitude() {
        return this.fieldValues.getDouble("altitude", 0.0);
    }

    public void setOdometerKM(double km) {
        this.fieldValues.setDouble("odometerKM", km);
    }

    public boolean hasOdometerKM() {
        return this.fieldValues.hasProperty("odometerKM");
    }

    @Override
    public double getOdometerKM() {
        return this.fieldValues.getDouble("odometerKM", 0.0);
    }

    public void setGeozoneID(String gzid) {
        if (!StringTools.isBlank(gzid)) {
            this.fieldValues.setString("geozoneID", gzid);
        } else {
            this.fieldValues.removeProperty("geozoneID");
        }
    }

    public void setGeozone(Geozone zone) {
        this.setGeozoneID(zone != null ? zone.getGeozoneID() : "");
    }

    public boolean hasGeozoneID() {
        return this.fieldValues.hasProperty("geozoneID");
    }

    @Override
    public String getGeozoneID() {
        return this.fieldValues.getString("geozoneID", "");
    }

    public boolean hasAddress() {
        return this.fieldValues.hasProperty("address");
    }

    @Override
    public String getAddress() {
        return "";
    }

    public void setInputMask(long mask) {
        this.fieldValues.setLong("inputMask", mask);
    }

    public boolean hasInputMask() {
        return this.fieldValues.hasProperty("inputMask");
    }

    @Override
    public long getInputMask() {
        return this.fieldValues.getLong("inputMask", 0L);
    }

    public void setEngineHours(double hours) {
        this.fieldValues.setDouble("engineHours", hours);
    }

    public boolean hasEngineHours() {
        return this.fieldValues.hasProperty("engineHours");
    }

    public double getEngineHours() {
        return this.fieldValues.getDouble("engineHours", 0.0);
    }

    public void setPtoHours(double hours) {
        this.fieldValues.setDouble("ptoHours", hours);
    }

    public boolean hasPtoHours() {
        return this.fieldValues.hasProperty("ptoHours");
    }

    public double getPtoHours() {
        return this.fieldValues.getDouble("ptoHours", 0.0);
    }

    public void setFuelTotal(double fuel) {
        this.fieldValues.setDouble("fuelTotal", fuel);
    }

    public boolean hasFuelTotal() {
        return this.fieldValues.hasProperty("fuelTotal");
    }

    public double getFuelTotal() {
        return this.fieldValues.getDouble("fuelTotal", 0.0);
    }

    @Override
    public void setEventIndex(int ndx) {
        this.eventIndex = ndx;
    }

    @Override
    public int getEventIndex() {
        return this.eventIndex;
    }

    @Override
    public boolean getIsFirstEvent() {
        return this.getEventIndex() == 0;
    }

    @Override
    public void setIsLastEvent(boolean isLast) {
        this.isLastEventInList = isLast;
    }

    @Override
    public boolean getIsLastEvent() {
        return this.isLastEventInList;
    }

    public Object getFieldValue(String fldName) {
        if (this.otherValues != null && this.otherValues.containsKey(fldName)) {
            return this.otherValues.get(fldName);
        }
        return this.fieldValues.getProperty(fldName, null);
    }

    public void setFieldValue(String fldName, Object fldVal) {
        if (!StringTools.isBlank(fldName) && fldVal != null) {
            this.fieldValues.setProperty((Object)fldName, fldVal);
        }
    }

    public void setFieldValue(String fldName, boolean fldVal) {
        this.setFieldValue(fldName, new Boolean(fldVal));
    }

    public void setFieldValue(String fldName, int fldVal) {
        this.setFieldValue(fldName, new Integer(fldVal));
    }

    public void setFieldValue(String fldName, long fldVal) {
        this.setFieldValue(fldName, new Long(fldVal));
    }

    public void setFieldValue(String fldName, double fldVal) {
        this.setFieldValue(fldName, new Double(fldVal));
    }

    public void setFieldValue(String fldName, String fldVal) {
        this.setFieldValue(fldName, (Object)fldVal);
    }

    public double ajustaVelocidad(String description, double actualSpeed) {
        double newSpeed = 0.0;
        boolean esMTC = description.endsWith("CONTROL");
        if (esMTC) {
            if (actualSpeed >= 88.0) {
                double x = Math.random() * 2.0;
                newSpeed = 88.0 + x;
                System.out.println("Control!: " + actualSpeed + " --> " + newSpeed);
            } else {
                newSpeed = actualSpeed;
            }
        } else {
            newSpeed = actualSpeed;
        }
        return newSpeed;
    }

    public String toString() {
        Object v;
        StringBuffer sb = new StringBuffer();
        int sc = this.getStatusCode();
        sb.append("Event values:\n");
        sb.append("  DeviceID  : " + this.getAccountID() + "/" + this.getDeviceID() + "\n");
        sb.append("  UniqueID  : " + this.getUniqueID() + "\n");
        sb.append("  Fixtime   : " + this.getTimestamp() + " [" + new DateTime(this.getTimestamp()) + "]\n");
        sb.append("  StatusCode: [" + StatusCodes.GetHex(sc) + "] " + StatusCodes.GetDescription(sc, null) + "\n");
        sb.append("  GPS       : " + this.getGeoPoint() + " [age " + this.getGpsAge() + " sec]\n");
        sb.append("  SpeedKPH  : " + StringTools.format(this.getSpeedKPH(), "0.0") + " [" + this.getHeading() + "]\n");
        OrderedSet fldn = new OrderedSet(this.fieldValues.getPropertyKeys());
        fldn.remove("timestamp");
        fldn.remove("statusCode");
        fldn.remove("latitude");
        fldn.remove("longitude");
        fldn.remove("gpsAge");
        fldn.remove("speedKPH");
        fldn.remove("heading");
        for (Object obj : fldn) {
            v = this.fieldValues.getProperty(obj, "?");
            sb.append("  ");
            sb.append(StringTools.leftAlign(obj.toString(), 10)).append(": ");
            sb.append(v.toString()).append("\n");
        }
        if (this.otherValues != null) {
            for (String string : this.otherValues.keySet()) {
                v = StringTools.trim(this.otherValues.get(string));
                sb.append("  ");
                sb.append(StringTools.leftAlign(string, 10)).append(": ");
                sb.append((String)v).append("\n");
            }
        }
        return sb.toString();
    }
}

