/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.sipgear;

import java.net.InetAddress;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DataTransport;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.dbtypes.DTIPAddrList;
import org.opengts.servers.sipgear.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static String[] UNIQUEID_PREFIX = null;
    public static double MINIMUM_SPEED_KPH = 3.0;
    public static boolean ESTIMATE_ODOMETER = true;
    public static double MINIMUM_MOVED_METERS = 0.0;
    public static boolean PACKET_LEN_END_OF_STREAM = false;
    public static final double KILOMETERS_PER_KNOT = 1.852;
    private String ipAddress = null;
    private int clientPort = 0;
    private int eventTotalCount = 0;

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.ipAddress = inetAddr != null ? inetAddr.getHostAddress() : null;
        this.clientPort = this.getSessionInfo().getRemotePort();
        this.eventTotalCount = 0;
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        if (PACKET_LEN_END_OF_STREAM) {
            return -2;
        }
        return -1;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (ListTools.isEmpty(pktBytes)) {
            Print.logWarn("Ignoring empty/null packet", new Object[0]);
        } else if (pktBytes.length < 11) {
            Print.logError("Unexpected packet length: " + pktBytes.length, new Object[0]);
        } else {
            Print.logInfo("Receive: " + StringTools.toStringValue(pktBytes, '.'), new Object[0]);
            String s = StringTools.toStringValue(pktBytes).trim();
            Print.logInfo("Parsing: " + s, new Object[0]);
            if (s.startsWith("##")) {
                Print.logError("Unexpected Packet prefix - TK103 packet? (use 'tk10x' DCS)", new Object[0]);
                return null;
            }
            if (s.startsWith("imei:")) {
                Print.logError("Unexpected Packet prefix - TK103 packet? (use 'tk10x' DCS)", new Object[0]);
                return null;
            }
            this.parseInsertRecord_TK102(s);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseInsertRecord_TK102(String s) {
        int gpx;
        if (s == null) {
            Print.logError("String is null", new Object[0]);
            return false;
        }
        Print.logInfo("Parsing(TK102): " + s, new Object[0]);
        String[] fld = StringTools.parseStringArray(s, ',');
        if (fld == null) {
            Print.logWarn("Fields are null", new Object[0]);
            return false;
        }
        if (fld.length < 15) {
            Print.logWarn("Invalid number of fields", new Object[0]);
            return false;
        }
        String mobileID = null;
        int imeiNdx = -1;
        for (int f = 0; f < fld.length; ++f) {
            if (!fld[f].startsWith("imei:")) continue;
            mobileID = fld[f].substring("imei:".length()).trim();
            imeiNdx = f;
            break;
        }
        if (StringTools.isBlank(mobileID)) {
            Print.logError("'imei:' value is missing", new Object[0]);
            return false;
        }
        for (gpx = 0; gpx < fld.length && !fld[gpx].equalsIgnoreCase("GPRMC"); ++gpx) {
        }
        if (gpx >= fld.length) {
            Print.logError("'GPRMC' not found", new Object[0]);
            return false;
        }
        if (gpx + 12 >= fld.length) {
            Print.logError("Insufficient 'GPRMC' fields", new Object[0]);
            return false;
        }
        long hms = StringTools.parseLong(fld[gpx + 1], 0L);
        long dmy = StringTools.parseLong(fld[gpx + 9], 0L);
        long fixtime = this._getUTCSeconds_DMY_HMS(dmy, hms);
        boolean validGPS = fld[gpx + 2].equalsIgnoreCase("A");
        double latitude = validGPS ? this._parseLatitude(fld[gpx + 3], fld[gpx + 4]) : 0.0;
        double longitude = validGPS ? this._parseLongitude(fld[gpx + 5], fld[gpx + 6]) : 0.0;
        double knots = validGPS ? StringTools.parseDouble(fld[gpx + 7], -1.0) : 0.0;
        double headingDeg = validGPS ? StringTools.parseDouble(fld[gpx + 8], -1.0) : 0.0;
        double speedKPH = knots >= 0.0 ? knots * 1.852 : -1.0;
        double altitudeM = 0.0;
        double odomKM = 0.0;
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date: " + fld[gpx + 9] + "/" + fld[gpx + 1], new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
        }
        String eventCode = gpx + 14 < fld.length ? StringTools.trim(fld[gpx + 14]) : "";
        int statusCode = 61472;
        if (validGPS && !GeoPoint.isValid(latitude, longitude)) {
            Print.logWarn("Invalid GPRMC lat/lon: " + latitude + "/" + longitude, new Object[0]);
            latitude = 0.0;
            longitude = 0.0;
            validGPS = false;
        }
        GeoPoint geoPoint = new GeoPoint(latitude, longitude);
        if (speedKPH < MINIMUM_SPEED_KPH) {
            speedKPH = 0.0;
            headingDeg = 0.0;
        } else if (headingDeg < 0.0) {
            headingDeg = 0.0;
        }
        Print.logInfo("IMEI     : " + mobileID, new Object[0]);
        Print.logInfo("Timestamp: " + fixtime + " [" + new DateTime(fixtime) + "]", new Object[0]);
        Print.logInfo("GPS      : " + geoPoint, new Object[0]);
        Print.logInfo("Speed    : " + StringTools.format(speedKPH, "#0.0") + " kph " + headingDeg, new Object[0]);
        Device device = DCServerConfig.loadDeviceUniqueID(Main.getServerConfig(), mobileID);
        if (device == null) {
            return false;
        }
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        String uniqueID = device.getUniqueID();
        Print.logInfo("UniqueID  : " + uniqueID, new Object[0]);
        Print.logInfo("DeviceID  : " + accountID + "/" + deviceID, new Object[0]);
        DataTransport dataXPort = device.getDataTransport();
        if (this.ipAddress != null && !dataXPort.isValidIPAddress(this.ipAddress)) {
            DTIPAddrList validIPAddr = dataXPort.getIpAddressValid();
            Print.logError("Invalid IP Address from device: " + this.ipAddress + " [expecting " + validIPAddr + "]", new Object[0]);
            return false;
        }
        dataXPort.setIpAddressCurrent(this.ipAddress);
        dataXPort.setRemotePortCurrent(this.clientPort);
        dataXPort.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
        if (!dataXPort.getDeviceCode().equalsIgnoreCase(Main.getServerName())) {
            dataXPort.setDeviceCode(Main.getServerName());
        }
        odomKM = odomKM <= 0.0 ? (ESTIMATE_ODOMETER && validGPS ? device.getNextOdometerKM(geoPoint) : device.getLastOdometerKM()) : device.adjustOdometerKM(odomKM);
        Print.logInfo("OdometerKM: " + odomKM, new Object[0]);
        if (statusCode >= 0 && statusCode != -1 && (statusCode != 61472 || this.eventTotalCount <= 0)) {
            if (statusCode != 61472) {
                this.insertEventRecord(device, fixtime, statusCode, null, geoPoint, 0L, 0.0, 0, speedKPH, headingDeg, altitudeM, odomKM);
            } else if (validGPS && !device.isNearLastValidLocation(geoPoint, MINIMUM_MOVED_METERS)) {
                this.insertEventRecord(device, fixtime, statusCode, null, geoPoint, 0L, 0.0, 0, speedKPH, headingDeg, altitudeM, odomKM);
            }
        }
        try {
            device.updateChangedEventFields();
        }
        catch (DBException dbe) {
            Print.logException("Unable to update Device: " + accountID + "/" + deviceID, dbe);
        }
        return true;
    }

    private long _getUTCSeconds_DMY_HMS(long dmy, long hms) {
        long DAY;
        int HH = (int)(hms / 10000L % 100L);
        int MM = (int)(hms / 100L % 100L);
        int SS = (int)(hms % 100L);
        long TOD = (long)HH * 3600L + (long)MM * 60L + (long)SS;
        if (dmy > 0L) {
            int yy = (int)(dmy % 100L) + 2000;
            int mm = (int)(dmy / 100L % 100L);
            int dd = (int)(dmy / 10000L % 100L);
            long yr = (long)yy * 1000L + (long)((mm - 3) * 1000 / 12);
            DAY = (367L * yr + 625L) / 1000L - 2L * (yr / 1000L) + yr / 4000L - yr / 100000L + yr / 400000L + (long)dd - 719469L;
        } else {
            long dif;
            long utc = DateTime.getCurrentTimeSec();
            long tod = utc % DateTime.DaySeconds(1L);
            DAY = utc / DateTime.DaySeconds(1L);
            long l = dif = tod >= TOD ? tod - TOD : TOD - tod;
            if (dif > DateTime.HourSeconds(12L)) {
                DAY = tod > TOD ? ++DAY : --DAY;
            }
        }
        long sec = DateTime.DaySeconds(DAY) + TOD;
        return sec;
    }

    private double _parseLatitude(String s, String d) {
        double _lat = StringTools.parseDouble(s, 99999.0);
        if (_lat < 99999.0) {
            double lat = (long)_lat / 100L;
            lat += (_lat - lat * 100.0) / 60.0;
            return d.equals("S") ? -lat : lat;
        }
        return 90.0;
    }

    private double _parseLongitude(String s, String d) {
        double _lon = StringTools.parseDouble(s, 99999.0);
        if (_lon < 99999.0) {
            double lon = (long)_lon / 100L;
            lon += (_lon - lon * 100.0) / 60.0;
            return d.equals("W") ? -lon : lon;
        }
        return 180.0;
    }

    private EventData createEventRecord(Device device, long gpsTime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, double speedKPH, double heading, double altitude, double odomKM) {
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        EventData.Key evKey = new EventData.Key(accountID, deviceID, gpsTime, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setGeozone(geozone);
        evdb.setGeoPoint(geoPoint);
        evdb.setGpsAge(gpsAge);
        evdb.setHDOP(HDOP);
        evdb.setSatelliteCount(numSats);
        evdb.setSpeedKPH(speedKPH);
        evdb.setHeading(heading);
        evdb.setAltitude(altitude);
        evdb.setOdometerKM(odomKM);
        return evdb;
    }

    private void insertEventRecord(Device device, long gpsTime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, double speedKPH, double heading, double altitude, double odomKM) {
        EventData evdb = this.createEventRecord(device, gpsTime, statusCode, geozone, geoPoint, gpsAge, HDOP, numSats, speedKPH, heading, altitude, odomKM);
        Print.logInfo("Event     : [0x" + StringTools.toHexString(statusCode, 16) + "] " + StatusCodes.GetDescription(statusCode, null), new Object[0]);
        device.insertEventData(evdb);
        ++this.eventTotalCount;
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig();
        if (dcsc != null) {
            UNIQUEID_PREFIX = dcsc.getUniquePrefix();
            MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
            ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
            MINIMUM_MOVED_METERS = dcsc.getMinimumMovedMeters(MINIMUM_MOVED_METERS);
            PACKET_LEN_END_OF_STREAM = dcsc.getBooleanProperty("sipgear.packetLenEndOfStream", PACKET_LEN_END_OF_STREAM);
        }
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        TrackClientPacketHandler tcph = new TrackClientPacketHandler();
    }
}

