/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config.views;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import org.opengts.opt.config.GTSConfig;
import org.opengts.opt.config.GTSProperties;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VFiller;
import org.opengts.opt.ui.VLabel;
import org.opengts.opt.ui.VSeparator;
import org.opengts.opt.ui.VShell;
import org.opengts.opt.ui.VTextArea;
import org.opengts.util.HTMLTools;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;

public class CheckInstall
extends GTSConfig.GTSBox {
    public static final String SUPPORT_CENTER = "Support Center";
    private static final boolean RUN_CHECKINSTALL_SH = false;
    private VShell execShell = null;
    private VTextArea textOutput = null;
    private Print.RedirectStream textOutputStream = null;
    private VButton emailBtn = null;
    private VButton clipboardBtn = null;
    private int checkInstallRunning = 0;

    public CheckInstall(GTSConfig gtsConfig) {
        super(gtsConfig);
        VBox labelBox = new VBox(null, null, false);
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.0, 0, 1);
        this.add((Component)labelBox, this.getDefaultGBC());
        labelBox.setGBCX(0.5, 0, 1);
        labelBox.setGBCY(0.0, 0, 1);
        labelBox.add((Component)new VFiller(), (Object)labelBox.getDefaultGBC());
        VLabel label = new VLabel();
        GridBagConstraints labelGBC = VBox.NewGBC();
        VBox.SetGBCX((GridBagConstraints)labelGBC, (double)0.5, (int)1, (int)1);
        VBox.SetGBCY((GridBagConstraints)labelGBC, (double)0.0, (int)0, (int)1);
        labelGBC.fill = 2;
        labelGBC.anchor = 10;
        labelBox.add((Component)label, (Object)labelGBC);
        label.setText("\"CheckInstall\" verifies that the components are property configured.\nClick \"Run CheckInstall\" below to run and display the CheckInstall logs.");
        labelBox.setGBCX(0.5, 2, 1);
        labelBox.setGBCY(0.0, 0, 1);
        labelBox.add((Component)new VFiller(), (Object)labelBox.getDefaultGBC());
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.0, 1, 1);
        this.add((Component)new VSeparator(), this.getDefaultGBC());
        boolean USE_SHELL = true;
        if (USE_SHELL) {
            this.execShell = new VShell();
            this.execShell.combineOutput(true);
            this.execShell.setStdinHidden(true);
            this.execShell.setLineWrap(false);
            this.setGBCX(0.5, 0, 1);
            this.setGBCY(0.5, 2, 1);
            this.add((Component)this.execShell, this.getDefaultGBC());
            this.textOutput = this.execShell.getStdoutTextArea();
        } else {
            this.textOutput = new VTextArea(null, null, false);
            this.textOutput.setReadOnly(true);
            this.textOutput.setTextFont(VBox.FONT_MONOSPACED_PLAIN);
            this.textOutput.setLineWrap(false);
            this.setGBCX(0.5, 0, 1);
            this.setGBCY(0.5, 2, 1);
            this.add((Component)this.textOutput, this.getDefaultGBC());
        }
        this.textOutputStream = new Print.RedirectStream(){

            @Override
            public void print(String s) {
                CheckInstall.this.textPrint(s);
            }
        };
        this.clipboardBtn = new VButton("Copy to Clipboard");
        this.clipboardBtn.setEnabled(false);
        this.clipboardBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CheckInstall.this.textOutput.copyToClipboard();
                GTSConfig.showInfoDialog("The CheckInstall log has been copied to the clipboard", "CheckInstall Clipboard");
            }
        });
        this.emailBtn = new VButton("EMail to Support Center");
        this.emailBtn.setEnabled(false);
        this.emailBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CheckInstall.this.emailCheckInstall();
            }
        });
        VButton updateBtn = new VButton("Run CheckInstall");
        updateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CheckInstall.this.runCheckInstall();
            }
        });
        VBox buttonBox = new VBox(null, null, false);
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.0, 3, 1);
        this.add((Component)buttonBox, this.getDefaultGBC());
        buttonBox.setGBCX(0.5, 0, 1);
        buttonBox.setGBCY(0.0, 0, 1);
        buttonBox.add((Component)new VFiller(), (Object)buttonBox.getDefaultGBC());
        buttonBox.setGBCX(0.0, 1, 1);
        buttonBox.setGBCY(0.0, 0, 1);
        buttonBox.add((Component)updateBtn, (Object)buttonBox.getDefaultGBC());
        buttonBox.setGBCX(0.0, 2, 1, 20, 0);
        buttonBox.setGBCY(0.0, 0, 1);
        buttonBox.add((Component)this.clipboardBtn, (Object)buttonBox.getDefaultGBC());
        buttonBox.setGBCX(0.0, 3, 1, 20, 0);
        buttonBox.setGBCY(0.0, 0, 1);
        buttonBox.add((Component)this.emailBtn, (Object)buttonBox.getDefaultGBC());
        buttonBox.setGBCX(0.5, 4, 1);
        buttonBox.setGBCY(0.0, 0, 1);
        buttonBox.add((Component)new VFiller(), (Object)buttonBox.getDefaultGBC());
    }

    @Override
    protected void _refresh() {
    }

    private void textPrintln(String s) {
        s = StringTools.replace(s, "\\", "/");
        this.textOutput.appendText(s + "\n", true);
    }

    private void textPrint(String s) {
        s = StringTools.replace(s, "\\", "/");
        this.textOutput.appendText(s, true);
    }

    private void runCheckInstall() {
        if (this.checkInstallRunning == 0) {
            ++this.checkInstallRunning;
            this.textOutput.setText("");
            this.textPrintln(StringTools.replicateString("=", 80));
            this.textPrintln("CheckInstall log output [" + GTSProperties.getServiceAccountID() + "]");
            new Thread(){

                @Override
                public void run() {
                    int execRtn = -1;
                    String binDir = GTSProperties.GTS_HOME + File.separator + "bin" + File.separator;
                    if (GTSProperties.isUnixOrMac()) {
                        String cmd = binDir + "checkInstall.sh -full";
                        CheckInstall.this.textPrintln("% " + cmd);
                        CheckInstall.this.textPrintln("");
                        try {
                            execRtn = CheckInstall.this.execShell.execCommand(cmd);
                        }
                        catch (InterruptedException ie) {}
                    } else if (GTSProperties.isWindows()) {
                        String cmd = binDir + "checkInstall.bat -full";
                        cmd = StringTools.replace(cmd, "\\", "/");
                        CheckInstall.this.textPrintln("> " + cmd);
                        CheckInstall.this.textPrintln("");
                        try {
                            execRtn = CheckInstall.this.execShell.execCommand(cmd);
                        }
                        catch (InterruptedException ie) {}
                    } else {
                        String ciClass = StringTools.className(org.opengts.tools.CheckInstall.class);
                        String[] args = RTConfig.getCommandLineProperties().toStringArray(true);
                        String[] cmd = OSTools.createJavaCommand(GTSProperties.CLASSPATH, ciClass, args);
                        CheckInstall.this.textPrint(GTSConfig.getFormattedCommandDisplay(cmd));
                        try {
                            execRtn = CheckInstall.this.execShell.execCommand(cmd);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    if (execRtn < 0) {
                        CheckInstall.this.textPrintln("");
                        CheckInstall.this.textPrintln("*** Command failed ***");
                        CheckInstall.this.textPrintln("");
                    }
                    CheckInstall.this.checkInstallRunning--;
                }
            }.start();
            this.clipboardBtn.setEnabled(true);
            this.emailBtn.setEnabled(true);
        }
    }

    private void emailCheckInstall() {
        String serviceAcct = GTSProperties.getServiceAccountID();
        String serviceName = GTSProperties.getServiceAccountName();
        String fromAddr = GTSProperties.getString("smtp.user.emailAddress", null);
        if (StringTools.isBlank(fromAddr) || StringTools.endsWithIgnoreCase(fromAddr, "example.com")) {
            fromAddr = GTSProperties.getString("Domain.EMailAddress", null);
        }
        if (StringTools.isBlank(fromAddr) || StringTools.endsWithIgnoreCase(fromAddr, "example.com")) {
            GTSConfig.showErrorDialog("The 'From' EMail address has not yet been defined, skipping email", "CheckInstall EMail");
            return;
        }
        String toAddr = GTSProperties.getString("ServiceProvider.email", "");
        if ((toAddr = GTSConfig.showTextInputDialog("Send CheckInstall log to", "Confirm CheckInstall EMail", toAddr)) == null) {
            return;
        }
        if (StringTools.isBlank(toAddr)) {
            GTSConfig.showErrorDialog("No 'To' EMail address has been specified.\nNo email will be sent.", "CheckInstall EMail");
            return;
        }
        if (!SendMail.validateAddresses(toAddr)) {
            GTSConfig.showErrorDialog("One of the specified 'To' EMail addresses is invalid.\nNo email will be sent.", "CheckInstall EMail");
            return;
        }
        String attachName = "checkInstall.out";
        String subject = "[" + serviceAcct + "] " + serviceName + " - " + attachName;
        String body = "Attached:\n" + attachName;
        byte[] ciOut = this.textOutput.getTextInterface().getText().getBytes();
        SendMail.Attachment attach = new SendMail.Attachment(ciOut, attachName, HTMLTools.MIME_PLAIN());
        SendMail.SetThreadModel("current");
        Print.logInfo("Sending CheckInstall log EMail", new Object[0]);
        Print.logInfo("From: " + fromAddr, new Object[0]);
        Print.logInfo("To  : " + toAddr, new Object[0]);
        SendMail.SmtpProperties smtpProps = null;
        boolean sent = SendMail.send(fromAddr, toAddr, subject, body, attach, smtpProps);
        if (sent) {
            GTSConfig.showInfoDialog("CheckInstall Log EMail Sent to\n" + toAddr, "CheckInstall EMail");
        } else {
            GTSConfig.showErrorDialog("Unable to send CheckInstall Log", "CheckInstall EMail");
        }
    }
}

