/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.opengts.opt.ui.VTextArea;
import org.opengts.opt.ui.WinTools;
import org.opengts.util.MethodAction;
import org.opengts.util.Print;

public class TailOutput
extends VTextArea {
    private static final long MAX_TAIL_SIZE = 250000L;
    private Thread tailLogThread = null;
    private File tailOutFile = null;
    private long tailMaxSize = 250000L;
    private long tailModTime = 0L;
    private long tailPointer = 0L;

    public TailOutput() {
        super("", null, true);
        this.setTextFont(FONT_MONOSPACED_PLAIN);
        this.setReadOnly(true);
        this.setLineWrap(false);
    }

    public void setTailFile(File tailFile, long maxLogSize) {
        this.setMaxLogSize(maxLogSize);
        this.setTailFile(tailFile);
    }

    public void setMaxLogSize(long maxLogSize) {
        this.tailMaxSize = maxLogSize > 0L ? maxLogSize : 250000L;
    }

    public long getMaxLogSize() {
        return this.tailMaxSize;
    }

    public void setTailFile(File tailFile) {
        this.setText("");
        this.tailOutFile = tailFile;
        this.tailModTime = 0L;
        this.tailPointer = 0L;
        this.setTitle("Tail:  " + this.tailOutFile);
    }

    public File getTailFile() {
        return this.tailOutFile;
    }

    public void appendText(String text, boolean moveCaret) {
        super.appendText(text, moveCaret);
        this.setTextLength((int)this.tailMaxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _updateLogOutput() throws IOException {
        FileInputStream fis = null;
        try {
            int ch;
            if (this.tailOutFile == null || !this.tailOutFile.isFile()) {
                return;
            }
            if (this.tailModTime <= 0L) {
                fis = new FileInputStream(this.tailOutFile);
                if (this.tailMaxSize > 0L && this.tailOutFile.length() > this.tailMaxSize) {
                    this.tailPointer = this.tailOutFile.length() - this.tailMaxSize;
                    try {
                        int ch2;
                        fis.getChannel().position(this.tailPointer);
                        while ((ch2 = fis.read()) != 10) {
                        }
                        this.setText("...\n");
                    }
                    catch (IllegalArgumentException iae) {
                        Print.logError("Invalid file position specified: " + this.tailPointer, new Object[0]);
                    }
                } else {
                    this.tailPointer = 0L;
                }
            } else {
                if (this.tailOutFile.lastModified() <= this.tailModTime) return;
                fis = new FileInputStream(this.tailOutFile);
                try {
                    fis.getChannel().position(this.tailPointer);
                }
                catch (IllegalArgumentException iae) {
                    Print.logError("Invalid file position specified: " + this.tailPointer, new Object[0]);
                }
            }
            StringBuffer sb = new StringBuffer();
            while ((ch = fis.read()) >= 0) {
                if (ch == 13) continue;
                sb.append((char)ch);
            }
            this.appendText(sb.toString(), true);
            this.tailPointer = this.tailOutFile.length();
            this.tailModTime = this.tailOutFile.lastModified();
            return;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable th) {}
            }
        }
    }

    public void refresh() {
        if (this.tailLogThread == null) {
            final Runnable updateOutput = new Runnable(){

                @Override
                public void run() {
                    try {
                        TailOutput.this._updateLogOutput();
                    }
                    catch (Throwable th) {
                        Print.logException("Error", th);
                    }
                }
            };
            this.tailLogThread = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        if (WinTools.getParentWindow((Component)((Object)TailOutput.this)) != null) {
                            try {
                                MethodAction.invokeAndWait(updateOutput);
                            }
                            catch (Throwable th) {
                                // empty catch block
                            }
                        }
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
            };
            this.tailLogThread.start();
        }
        this.setCursorPosition(-1);
    }
}

