/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import org.opengts.opt.config.GTSProperties;
import org.opengts.opt.config.PropertyGroup;
import org.opengts.opt.config.PropertyItem;
import org.opengts.util.FileTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyItemLoader {
    public static final String TAG_GTSConfig = "GTSConfig";
    public static final String TAG_Welcome = "Welcome";
    public static final String TAG_ConfigProperties = "ConfigProperties";
    public static final String TAG_Property = "Property";
    public static final String TAG_Completion = "Completion";
    public static final String TAG_PropertyGroup = "PropertyGroup";
    public static final String TAG_PropertyItem = "PropertyItem";
    public static final String TAG_Description = "Description";
    public static final String TAG_Label = "Label";
    public static final String TAG_Help = "Help";
    public static final String TAG_Separator = "Separator";
    public static final String TAG_FieldLength = "FieldLength";
    public static final String TAG_DefaultValue = "DefaultValue";
    public static final String TAG_Selection = "Selection";
    public static final String TAG_SelectionItem = "SelectionItem";
    public static final String TAG_ReadOnly = "ReadOnly";
    public static final String TAG_ToolTip = "ToolTip";
    public static final String ATTR_name = "name";
    public static final String ATTR_class = "class";
    public static final String ATTR_key = "key";
    public static final String ATTR_type = "type";
    public static final String ATTR_readOnly = "readOnly";
    public static final String ATTR_hidden = "hidden";
    public static final String ATTR_blankOk = "blankOk";
    public static final String ATTR_default = "default";
    public static final String ATTR_unless = "unless";
    private String welcome = null;
    private Map<String, PropertyGroup> propGroupMap = null;
    private String completion = null;

    public PropertyItemLoader(File configXMLFile) {
        this.loadXML(configXMLFile);
    }

    public String getWelcome() {
        return StringTools.trim(this.welcome);
    }

    public Map<String, PropertyGroup> getPropertyGroupMap() {
        if (this.propGroupMap == null) {
            this.propGroupMap = new OrderedMap<String, PropertyGroup>();
        }
        return this.propGroupMap;
    }

    public String getCompletion() {
        return StringTools.trim(this.completion);
    }

    protected boolean loadXML(File configXMLFile) {
        Document xmlDoc;
        if (configXMLFile == null) {
            Print.logError("Specified GTSConfig XML file is null", new Object[0]);
            return false;
        }
        File realCfgFile = FileTools.getRealFile(configXMLFile);
        if (realCfgFile == null) {
            Print.logError("Unable to resolve GTSConfig file: " + configXMLFile, new Object[0]);
            return false;
        }
        configXMLFile = realCfgFile;
        Print.logInfo("Loading GTSConfig xml file: " + configXMLFile, new Object[0]);
        Document document = xmlDoc = configXMLFile != null ? XMLTools.getDocument(configXMLFile) : null;
        if (xmlDoc == null) {
            Print.logError("Unable to create XML Document from file: " + configXMLFile, new Object[0]);
            return false;
        }
        Element gtsConfig = xmlDoc.getDocumentElement();
        if (!gtsConfig.getTagName().equalsIgnoreCase(TAG_GTSConfig)) {
            Print.logError("Missing 'GTSConfig' tag", new Object[0]);
            return false;
        }
        this.propGroupMap = new OrderedMap<String, PropertyGroup>();
        HashSet<String> piSet = new HashSet<String>();
        NodeList gtsConfigNodeList = gtsConfig.getChildNodes();
        for (int n = 0; n < gtsConfigNodeList.getLength(); ++n) {
            Node configNode = gtsConfigNodeList.item(n);
            if (!(configNode instanceof Element)) continue;
            Element configNodeElem = (Element)configNode;
            String configNodeName = configNode.getNodeName();
            if (configNodeName.equalsIgnoreCase(TAG_ConfigProperties)) {
                NodeList propertyList = configNodeElem.getChildNodes();
                for (int p = 0; p < propertyList.getLength(); ++p) {
                    Node propertyNode = propertyList.item(p);
                    if (!(propertyNode instanceof Element)) continue;
                    Element propertyElem = (Element)propertyNode;
                    String propNodeName = propertyNode.getNodeName();
                    if (!propNodeName.equalsIgnoreCase(TAG_Property)) continue;
                    String propKey = XMLTools.getAttribute(propertyElem, ATTR_key, "", false);
                    String propVal = XMLTools.getNodeText(propertyElem, " ", true).trim();
                    if (StringTools.isBlank(propKey) || GTSProperties.hasProperty(propKey)) continue;
                    GTSProperties.setString(propKey, propVal);
                }
                continue;
            }
            if (configNodeName.equalsIgnoreCase(TAG_Welcome)) {
                this.welcome = XMLTools.getNodeText(configNodeElem, "\n", true);
                continue;
            }
            if (configNodeName.equalsIgnoreCase(TAG_PropertyGroup)) {
                String pgName = XMLTools.getAttribute(configNodeElem, ATTR_name, "", false);
                String pgClas = XMLTools.getAttribute(configNodeElem, ATTR_class, "", false);
                String pgDesc = null;
                OrderedMap<String, PropertyItem> piMap = new OrderedMap<String, PropertyItem>();
                NodeList groupNodeList = configNodeElem.getChildNodes();
                for (int e = 0; e < groupNodeList.getLength(); ++e) {
                    Node groupNode = groupNodeList.item(e);
                    if (!(groupNode instanceof Element)) continue;
                    Element groupNodeElem = (Element)groupNode;
                    String groupNodeName = groupNode.getNodeName();
                    if (groupNodeName.equalsIgnoreCase(TAG_PropertyItem)) {
                        PropertyItem pi = this.parseTag_PropertyItem(piMap, groupNodeElem);
                        if (pi == null) continue;
                        if (piSet.contains(pi.getKey())) {
                            Print.logError("PropertyItem key already defined: " + pgName + "/" + pi.getKey(), new Object[0]);
                            return false;
                        }
                        piSet.add(pi.getKey());
                        piMap.put(pi.getKey(), pi);
                        continue;
                    }
                    if (groupNodeName.equalsIgnoreCase(TAG_Separator)) {
                        piMap.put("sep_" + piMap.size(), new PropertyItem());
                        continue;
                    }
                    if (!groupNodeName.equalsIgnoreCase(TAG_Description)) continue;
                    pgDesc = XMLTools.getNodeText(groupNodeElem, "\n", true).trim();
                }
                this.propGroupMap.put(pgName, PropertyGroup.createPropertyGroup(pgClas, pgName, pgDesc, piMap));
                continue;
            }
            if (!configNodeName.equalsIgnoreCase(TAG_Completion)) continue;
            this.completion = XMLTools.getNodeText(configNodeElem, "\n", true);
        }
        return true;
    }

    protected PropertyItem parseTag_PropertyItem(Map<String, PropertyItem> piMap, Element propertyItem) {
        String propValue;
        String key = XMLTools.getAttribute(propertyItem, ATTR_key, null, false);
        String type = XMLTools.getAttribute(propertyItem, ATTR_type, null, false);
        boolean hidden = XMLTools.getAttributeBoolean(propertyItem, ATTR_hidden, false, false);
        boolean blankOk = XMLTools.getAttributeBoolean(propertyItem, ATTR_blankOk, true, false);
        String desc = null;
        String label = null;
        String help = null;
        String tooltip = null;
        String dftValue = null;
        int fldLen = -1;
        OrderedMap<String, String> selection = null;
        if (StringTools.isBlank(key)) {
            Print.logError("Missing 'key' attribute", new Object[0]);
            return null;
        }
        if (key.equalsIgnoreCase("none")) {
            return null;
        }
        if (key.equalsIgnoreCase("separator")) {
            return new PropertyItem();
        }
        boolean readOnly = XMLTools.getAttributeBoolean(propertyItem, ATTR_readOnly, false, false);
        PropertyItem readOnlyUnlessProp = null;
        String readOnlyUnlessVal = null;
        int typeEnum = 1;
        if (StringTools.isBlank(type)) {
            Print.logError("Missing 'type' attribute", new Object[0]);
            return null;
        }
        if (type.equalsIgnoreCase("none")) {
            typeEnum = 0;
        } else if (type.equalsIgnoreCase("boolean")) {
            typeEnum = 4;
        } else if (type.equalsIgnoreCase("long")) {
            typeEnum = 5;
        } else if (type.equalsIgnoreCase("double")) {
            typeEnum = 6;
        } else if (type.equalsIgnoreCase("password")) {
            typeEnum = 2;
        } else if (type.equalsIgnoreCase("string")) {
            typeEnum = 1;
        } else if (type.equalsIgnoreCase("list")) {
            typeEnum = 3;
        } else if (type.equalsIgnoreCase("color")) {
            typeEnum = 7;
        } else {
            Print.logError("Unrecognized 'type' attribute: " + type, new Object[0]);
            return null;
        }
        NodeList tagList = propertyItem.getChildNodes();
        for (int c = 0; c < tagList.getLength(); ++c) {
            Node tagNode = tagList.item(c);
            if (!(tagNode instanceof Element)) continue;
            String tagName = tagNode.getNodeName();
            Element tagElem = (Element)tagNode;
            if (tagName.equalsIgnoreCase(TAG_Description)) {
                desc = XMLTools.getNodeText(tagElem, "\n", true).trim();
                if (desc.indexOf("\n") < 0 || StringTools.startsWithIgnoreCase(desc, "<html")) continue;
                desc = "<html>" + StringTools.htmlFilterText(desc) + "</html>";
                continue;
            }
            if (tagName.equalsIgnoreCase(TAG_Label)) {
                label = XMLTools.getNodeText(tagElem, "\n", true);
                continue;
            }
            if (tagName.equalsIgnoreCase(TAG_Help)) {
                help = XMLTools.getNodeText(tagElem, "\n", true);
                continue;
            }
            if (tagName.equalsIgnoreCase(TAG_ToolTip)) {
                tooltip = XMLTools.getNodeText(tagElem, " ", true);
                continue;
            }
            if (tagName.equalsIgnoreCase(TAG_FieldLength)) {
                String lenStr = XMLTools.getNodeText(tagElem, " ", false);
                if (StringTools.isBlank(lenStr)) {
                    fldLen = -1;
                    continue;
                }
                if (StringTools.isLong(lenStr, true)) {
                    fldLen = (int)StringTools.parseLong(lenStr, 0L);
                    continue;
                }
                Print.logError("Unrecognized 'FieldLength' tag value: " + lenStr, new Object[0]);
                return null;
            }
            if (tagName.equalsIgnoreCase(TAG_DefaultValue)) {
                dftValue = XMLTools.getNodeText(tagElem, " ", true);
                continue;
            }
            if (tagName.equalsIgnoreCase(TAG_ReadOnly)) {
                String unlessKey = XMLTools.getAttribute(tagElem, ATTR_unless, null, false);
                String roValue = XMLTools.getNodeText(tagElem, " ", false);
                readOnly = XMLTools.getAttributeBoolean(tagElem, ATTR_readOnly, readOnly, false);
                if (!StringTools.isBlank(unlessKey)) {
                    PropertyItem unlessProp = piMap.get(unlessKey);
                    if (unlessProp != null) {
                        readOnlyUnlessProp = unlessProp;
                        readOnlyUnlessVal = roValue;
                        continue;
                    }
                    Print.logError("'ReadOnly' tag 'unless' property key not found: " + unlessKey, new Object[0]);
                    return null;
                }
                readOnly = StringTools.parseBoolean(roValue, readOnly);
                readOnlyUnlessProp = null;
                readOnlyUnlessVal = null;
                continue;
            }
            if (!tagName.equalsIgnoreCase(TAG_Selection)) continue;
            selection = new OrderedMap<String, String>();
            NodeList selList = XMLTools.getChildElements(tagElem, TAG_SelectionItem);
            for (int s = 0; s < selList.getLength(); ++s) {
                Element selItem = (Element)selList.item(s);
                String selKey = XMLTools.getAttribute(selItem, ATTR_key, null, false);
                boolean selDft = XMLTools.getAttributeBoolean(selItem, ATTR_default, false, false);
                if (!StringTools.isBlank(selKey)) {
                    String selDesc = StringTools.blankDefault(XMLTools.getNodeText(selItem, " ", false), selKey);
                    if (!selection.containsKey(selDesc)) {
                        if (StringTools.isBlank(selDesc)) {
                            Print.logWarn("[" + key + "] Selection description is blank, key=" + selKey, new Object[0]);
                        }
                        selection.put(selDesc, selKey);
                        if (!selDft || !StringTools.isBlank(dftValue)) continue;
                        dftValue = selKey;
                        continue;
                    }
                    Print.logError("[" + key + "] Selection already contains description '" + selDesc + "', key=" + selKey, new Object[0]);
                    continue;
                }
                Print.logError("[" + key + "] Missing SelectionItem '" + ATTR_key + "' attribute", new Object[0]);
                return null;
            }
            if (selection.size() > 0) continue;
            Print.logError("[" + key + "] Selection tag with no items", new Object[0]);
            return null;
        }
        String string = propValue = GTSProperties.hasProperty(key) ? GTSProperties.getString(key, dftValue) : dftValue;
        if (selection != null) {
            boolean foundDefault = StringTools.isBlank(dftValue);
            boolean foundValue = StringTools.isBlank(propValue);
            if (!foundDefault || !foundValue) {
                for (String selKey : selection.keySet()) {
                    String selVal = (String)selection.get(selKey);
                    if (!foundDefault && selVal.equals(dftValue)) {
                        foundDefault = true;
                    }
                    if (!foundValue && selVal.equals(propValue)) {
                        foundValue = true;
                    }
                    if (!foundDefault || !foundValue) continue;
                    break;
                }
            }
            if (!foundDefault) {
                Print.logError("'DefaultValue' not found in 'Selection' list: " + dftValue, new Object[0]);
                return null;
            }
            if (!foundValue) {
                Print.logWarn("Property value not found in 'Selection' list: " + propValue, new Object[0]);
                propValue = dftValue;
            }
        }
        PropertyItem pi = new PropertyItem(key, desc, typeEnum, fldLen);
        pi.setHidden(hidden);
        pi.setBlankOK(blankOk);
        pi.setReadOnly(readOnly, readOnlyUnlessProp, readOnlyUnlessVal);
        pi.setSelection((Map<String, String>)selection);
        pi.setDefaultValue(propValue);
        pi.setValue(propValue);
        pi.setLabel(label);
        pi.setHelp(help);
        pi.setToolTip(tooltip);
        return pi;
    }
}

