/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config;

import java.util.Map;
import org.opengts.opt.config.PropertyItem;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class PropertyGroup {
    private String name = null;
    private String description = null;
    private Map<String, PropertyItem> propertyList = null;

    public static PropertyGroup createPropertyGroup(String pgClassName, String name, String desc, Map<String, PropertyItem> propList) {
        if (!StringTools.isBlank(pgClassName)) {
            try {
                Class<?> pgClass = Class.forName(pgClassName);
                MethodAction ma = new MethodAction(pgClass, String.class, String.class, Map.class);
                return (PropertyGroup)ma.invoke(name, desc, propList);
            }
            catch (ClassNotFoundException cnfe) {
                Print.logError("PropertyGroup class not found: " + pgClassName, new Object[0]);
            }
            catch (Throwable t) {
                Print.logError("PropertyGroup creation error: " + pgClassName + " [" + t, new Object[0]);
            }
        }
        return new PropertyGroup(name, desc, propList);
    }

    public PropertyGroup(String name, String desc, Map<String, PropertyItem> propList) {
        this.name = StringTools.trim(name);
        this.description = StringTools.trim(desc);
        this.propertyList = propList != null ? propList : new OrderedMap();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, PropertyItem> getPropertyList() {
        return this.propertyList;
    }

    public String getValue(String key) {
        if (StringTools.isBlank(key)) {
            return null;
        }
        PropertyItem pi = this.propertyList.get(key);
        if (pi == null) {
            Print.logError("PropertyItem not found: " + key, new Object[0]);
            return null;
        }
        String val = pi.getValue();
        return val;
    }

    public boolean hasChanged() {
        for (PropertyItem pi : this.propertyList.values()) {
            if (!pi.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void clearChanged() {
        for (PropertyItem pi : this.propertyList.values()) {
            pi.clearChanged();
        }
    }

    public boolean isValid() {
        return true;
    }
}

