/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.opengts.Version;
import org.opengts.opt.config.PropertyGroup;
import org.opengts.opt.config.PropertyGroupValidator;
import org.opengts.opt.config.PropertyItem;
import org.opengts.opt.config.PropertyItemLoader;
import org.opengts.util.ColorTools;
import org.opengts.util.FileTools;
import org.opengts.util.IPTools;
import org.opengts.util.ListTools;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class GTSProperties {
    private static final boolean COMMENT_DEFAULT_VALUES = false;
    public static final String APP_VERSION = "1.2.2";
    public static final String APP_COPYRIGHT = "Copyright 2007-2013, GeoTelematic Solutions, Inc.";
    public static final String APP_URL = "http://www.geotelematic.com";
    public static final String GTS_COMPILED_VERSION = "E2.5.3-B05";
    public static final String GTS_LIBRARY_VERSION = Version.getVersion();
    public static boolean CONFIG_MODE = false;
    public static String GTS_HOME = ".";
    public static String CATALINA_HOME = ".";
    public static String[] CLASSPATH = null;
    public static String ANT_HOME = "";
    public static String ANT_EXEC = "";
    public static final String ANT_COMMAND_SH = "ant";
    public static final String ANT_COMMAND_BAT = "ant.bat";
    public static final String GROUP_SERVICE_ACCOUNT = "ServiceAccount";
    public static final String GROUP_HOST_ADDRESS = "HostAddress";
    public static final String GROUP_SMTP = "SMTP";
    public static final String PROP_ServiceAccount_ID = "ServiceAccount.ID";
    public static final String PROP_ServiceAccount_Name = "ServiceAccount.Name";
    public static final String PROP_PROVIDER_EMAIL = "ServiceProvider.email";
    public static final String PROP_DOMAIN_EMAIL = "Domain.EMailAddress";
    public static final String PROP_HOST_IP = "Host.IP";
    public static final String PROP_HOST_NAME = "Host.Name";
    public static final String[] ARG_CONFIG_XML = new String[]{"configXML"};
    public static final String[] ARG_CONFIG_CONF = new String[]{"configConf"};
    public static final String[] ARG_LIST_CONFIG = new String[]{"listConfig"};
    public static final String[] ARG_EDIT_CONFIG = new String[]{"editConfig"};
    public static final String[] ARG_LOAD_CONFIG = new String[]{"loadConfig", "config", "listConfig", "editConfig"};
    public static final String[] ARG_LOG = new String[]{"log", "logLevel"};
    public static final String[] ARG_VERSION = new String[]{"v", "version"};
    public static final String[] ARG_HOST = new String[]{"host"};
    public static final String[] ARG_LOGFILE = new String[]{"logFile", "installLog"};
    public static final String[] ARG_UNIX = new String[]{"unix", "linux"};
    public static final String[] ARG_WINDOWS = new String[]{"windows"};
    public static final String[] ARG_GTS_HOME = new String[]{"GTS_HOME"};
    public static final String[] ARG_ANT_HOME = new String[]{"ANT_HOME"};
    public static final String[] ARG_CATALINA_HOME = new String[]{"CATALINA_HOME"};
    public static final String[] ARG_WARSERVLETS = new String[]{"servlets", "wars"};
    public static final String FILE_CONFIG_XML = "./config/config.xml";
    public static final String FILE_CONFIG_CONF = "./config.conf";
    private static GTSProperties SingletonInstance = null;
    private RTProperties privateConf = null;
    private File privateConfFile = null;
    private PropertyItemLoader propItemLoader = null;
    private Map<String, PropertyGroup> propGroupMap = null;

    public static boolean isUnixOrMac() {
        return RTConfig.getBoolean(ARG_UNIX, false) || OSTools.isLinux() || OSTools.isMacOSX();
    }

    public static boolean isWindows() {
        return RTConfig.getBoolean(ARG_WINDOWS, false) || OSTools.isWindows();
    }

    public static boolean hasProperty(String key) {
        return RTConfig.hasProperty(key);
    }

    public static void setString(String key, String value) {
        GTSProperties gtsp = GTSProperties.getInstance();
        if (gtsp.getPrivateConf() != null) {
            gtsp.getPrivateConf().setString(key, value);
        }
    }

    public static String getString(String key, String dft) {
        return RTConfig.getString(key, dft);
    }

    public static String getServiceAccountID() {
        return GTSProperties.getString(PROP_ServiceAccount_ID, "");
    }

    public static String getServiceAccountName() {
        return GTSProperties.getString(PROP_ServiceAccount_Name, "");
    }

    public static GTSProperties getInstance() {
        if (SingletonInstance == null) {
            new GTSProperties();
        }
        return SingletonInstance;
    }

    public GTSProperties() {
        SingletonInstance = this;
        this.initConfig();
    }

    private void initConfig() {
        GTS_HOME = RTConfig.getString(ARG_GTS_HOME, GTS_HOME);
        CATALINA_HOME = RTConfig.getString(ARG_CATALINA_HOME, CATALINA_HOME);
        CONFIG_MODE = RTConfig.getBoolean(ARG_LOAD_CONFIG, false);
        String ANT_HOME = RTConfig.getString(ARG_ANT_HOME, "");
        if (!StringTools.isBlank(ANT_HOME)) {
            StringBuffer sb = new StringBuffer();
            sb.append(ANT_HOME);
            sb.append(File.separator);
            sb.append("bin");
            sb.append(File.separator);
            if (GTSProperties.isWindows()) {
                sb.append(ANT_COMMAND_BAT);
            } else {
                sb.append(ANT_COMMAND_SH);
            }
            ANT_EXEC = sb.toString();
        } else {
            ANT_EXEC = !GTSProperties.isWindows() && new File("/usr/bin/ant").exists() ? "/usr/bin/ant" : (GTSProperties.isWindows() ? ANT_COMMAND_BAT : ANT_COMMAND_SH);
            GTSProperties.ANT_HOME = "";
        }
        String gtsBuild = GTS_HOME + File.separator + "build" + File.separator;
        String gtsLibDir = gtsBuild + "lib" + File.separator;
        String gtsTrack = gtsBuild + "track" + File.separator + "WEB-INF" + File.separator + "classes" + File.separator;
        String tomcatDir = CATALINA_HOME + File.separator + "common" + File.separator + "lib" + File.separator;
        CLASSPATH = new String[]{gtsLibDir + "tools.jar", gtsLibDir + "gtsdb.jar", gtsLibDir + "gtsutils.jar", gtsLibDir + "optdb.jar", gtsLibDir + "opttrack.jar", gtsLibDir + "ruledb.jar", gtsLibDir + "ruletrack.jar", gtsLibDir + "wartools.jar", gtsLibDir + "warmaps.jar", tomcatDir + "servlet-api.jar", gtsTrack};
        this.privateConfFile = RTConfig.getFile(ARG_CONFIG_CONF, new File(FILE_CONFIG_CONF));
        try {
            File file;
            this.privateConfFile = file = this.privateConfFile.getCanonicalFile();
        }
        catch (Throwable th) {
            // empty catch block
        }
        Print.logInfo("Loading conf: " + this.privateConfFile, new Object[0]);
        this.privateConf = new RTProperties(this.privateConfFile);
        RTConfig._setServletContextProperties(this.privateConf);
        this.propItemLoader = new PropertyItemLoader(RTConfig.getFile(ARG_CONFIG_XML, new File(FILE_CONFIG_XML)));
        this.propGroupMap = this.getPropertyItemLoader().getPropertyGroupMap();
        this.initPropertyGroupValidators();
        for (PropertyGroup pg : this.propGroupMap.values()) {
            for (PropertyItem pi : pg.getPropertyList().values()) {
                String cfVal;
                if (pi.isHidden()) continue;
                String piKey = pi.getKey();
                String piVal = pi.getValue();
                if (this.privateConf.hasProperty(piKey)) {
                    cfVal = this.privateConf.getString(piKey, piVal);
                    pi.setValue(cfVal);
                    pi.setChanged(false);
                    continue;
                }
                cfVal = RTConfig.getString(piKey, piVal);
                this.privateConf.setString(piKey, cfVal);
                pi.setValue(cfVal);
                pi.setChanged(true);
                if (piVal.equals(cfVal)) continue;
                Print.logInfo("Property change on load: " + piKey + " [default='" + piVal + "', new='" + cfVal + "']", new Object[0]);
            }
        }
    }

    public RTProperties getPrivateConf() {
        return this.privateConf;
    }

    public File getPrivateConfFile() {
        return this.privateConfFile;
    }

    public PropertyItemLoader getPropertyItemLoader() {
        return this.propItemLoader;
    }

    public Map<String, PropertyGroup> getPropertyGroup() {
        return this.propGroupMap;
    }

    protected void initPropertyGroupValidators() {
        PropertyGroupValidator.SetDefaultValidator(new PropertyGroupValidator(){

            @Override
            public String getValidateMessage(PropertyGroup pg, String piName) {
                if (pg == null) {
                    return null;
                }
                String pgName = pg.getName();
                if (pgName.equals(GTSProperties.GROUP_SERVICE_ACCOUNT)) {
                    String sid = pg.getValue(GTSProperties.PROP_ServiceAccount_ID);
                    if ((StringTools.isBlank(piName) || piName.equals(GTSProperties.PROP_ServiceAccount_ID)) && StringTools.isBlank(sid)) {
                        return "Please enter a valid Service Account ID";
                    }
                    return null;
                }
                if (pgName.equals(GTSProperties.GROUP_HOST_ADDRESS)) {
                    String hostIP = pg.getValue(GTSProperties.PROP_HOST_IP);
                    String hostName = pg.getValue(GTSProperties.PROP_HOST_NAME);
                    if ((StringTools.isBlank(piName) || piName.equals(GTSProperties.PROP_HOST_IP)) && !IPTools.isValidIPAddress(hostIP)) {
                        return "Please enter a valid Gateway IP address";
                    }
                    return null;
                }
                if (pgName.equals(GTSProperties.GROUP_SMTP)) {
                    String smtpHost = pg.getValue("smtp.host");
                    int smtpPort = StringTools.parseInt(pg.getValue("smtp.port"), 0);
                    boolean smtpSSL = StringTools.parseBoolean(pg.getValue("smtp.enableSSL"), false);
                    String smtpUser = pg.getValue("smtp.user");
                    String smtpPass = pg.getValue("smtp.password");
                    String smtpEmail = pg.getValue("smtp.user.emailAddress");
                    if ((StringTools.isBlank(piName) || piName.equals("smtp.host")) && StringTools.isBlank(smtpHost)) {
                        return "Please enter a valid SMTP host";
                    }
                    if ((StringTools.isBlank(piName) || piName.equals("smtp.port")) && smtpPort <= 0) {
                        return "Please enter a valid SMTP port";
                    }
                    if ((StringTools.isBlank(piName) || piName.equals("smtp.user.emailAddress")) && StringTools.isBlank(smtpEmail)) {
                        return "Please enter a valid Notification 'From' Email address";
                    }
                    return null;
                }
                return null;
            }
        });
    }

    public void listConfig() {
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("# --------------------------------------------------", new Object[0]);
        Print.sysPrintln("# Listing Config Property settings", new Object[0]);
        Print.sysPrintln("# --------------------------------------------------", new Object[0]);
        for (PropertyGroup pg : this.getPropertyGroup().values()) {
            Print.sysPrintln("", new Object[0]);
            Print.sysPrintln("# --- %s: %s", pg.getName(), pg.getDescription());
            for (PropertyItem pi : pg.getPropertyList().values()) {
                if (pi.isHidden()) continue;
                String piKey = pi.getKey();
                String piVal = pi.getValue();
                Print.sysPrintln("%s=%s", piKey, piVal);
            }
        }
        Print.sysPrintln("", new Object[0]);
    }

    public void editConfig() {
        Print.sysPrintln("", new Object[0]);
        try {
            int groupNdx = 0;
            block20: for (PropertyGroup pg : this.getPropertyGroup().values()) {
                String groupName = pg.getName();
                PropertyGroupValidator groupValidator = PropertyGroupValidator.GetValidator(groupName);
                Print.sysPrintln("", new Object[0]);
                Print.sysPrintln("-------------------------------------------------------", new Object[0]);
                Print.sysPrintln("%d] [%s] %s", ++groupNdx, groupName, pg.getDescription());
                Print.sysPrintln("-------------------------------------------------------", new Object[0]);
                int itemNdx = 0;
                String lastTitle = "";
                block21: for (PropertyItem pi : pg.getPropertyList().values()) {
                    int piType = pi.getType();
                    String piTitl = GTSProperties._trimTags(pi.getTitle());
                    if (!StringTools.isBlank(piTitl)) {
                        lastTitle = piTitl;
                    } else {
                        piTitl = lastTitle;
                    }
                    if (pi.isHidden() || piType == 0) continue;
                    ++itemNdx;
                    String piKey = pi.getKey();
                    String piVal = pi.getValue();
                    String piLabl = GTSProperties._trimTags(pi.getLabel());
                    String piHelp = GTSProperties._trimTags(pi.getHelp());
                    String desc = StringTools.trim(piTitl + "\n" + piLabl);
                    Print.sysPrintln("", new Object[0]);
                    Print.sysPrintln("%d.%d] %s", groupNdx, itemNdx, desc);
                    while (true) {
                        Print.sysPrintln(">  %s=%s", piKey, piVal);
                        switch (piType) {
                            case 1: {
                                Print.sysPrint("Enter new value [String] : ", new Object[0]);
                                break;
                            }
                            case 2: {
                                Print.sysPrint("Enter new value [Password] : ", new Object[0]);
                                break;
                            }
                            case 3: {
                                Map<String, String> list = pi.getSelection();
                                int ndx = 1;
                                for (String item : list.keySet()) {
                                    Print.sysPrintln("  %d) [%s] %s", ndx++, list.get(item), item);
                                }
                                Print.sysPrint("Enter new value [Select] : ", new Object[0]);
                                break;
                            }
                            case 4: {
                                Print.sysPrint("Enter new value [Boolean] : ", new Object[0]);
                                break;
                            }
                            case 5: {
                                Print.sysPrint("Enter new value [Long] : ", new Object[0]);
                                break;
                            }
                            case 6: {
                                Print.sysPrint("Enter new value [Double] : ", new Object[0]);
                                break;
                            }
                            case 7: {
                                Print.sysPrint("Enter new value [Color] : ", new Object[0]);
                                break;
                            }
                            default: {
                                Print.sysPrint("Enter new value [unknown] : ", new Object[0]);
                            }
                        }
                        String line = FileTools.readLine_stdin().trim();
                        if (StringTools.isBlank(line)) {
                            String valMsg = groupValidator.getValidateMessage(pg, piKey);
                            if (StringTools.isBlank(valMsg)) continue block21;
                            Print.sysPrintln("ERROR: " + valMsg, new Object[0]);
                            continue;
                        }
                        if (line.equalsIgnoreCase("exit")) break block20;
                        switch (piType) {
                            case 1: {
                                piVal = line;
                                break;
                            }
                            case 2: {
                                piVal = line;
                                break;
                            }
                            case 3: {
                                if (StringTools.isInt(line, true)) {
                                    int sel = StringTools.parseInt(line, -1);
                                    Map<String, String> list = pi.getSelection();
                                    int ndx = 1;
                                    for (String item : list.keySet()) {
                                        if (sel != ndx++) continue;
                                        piVal = list.get(item);
                                        break;
                                    }
                                    if (ndx < list.size()) break;
                                    Print.sysPrintln("Invalid List selection", new Object[0]);
                                    break;
                                }
                                Print.sysPrintln("Invalid List selection", new Object[0]);
                                break;
                            }
                            case 4: {
                                if (line.equalsIgnoreCase("T") || line.equalsIgnoreCase("Y")) {
                                    piVal = "true";
                                    break;
                                }
                                if (line.equalsIgnoreCase("F") || line.equalsIgnoreCase("N")) {
                                    piVal = "false";
                                    break;
                                }
                                if (StringTools.isBoolean(line, true)) {
                                    piVal = StringTools.parseBoolean(line, false) ? "true" : "false";
                                    break;
                                }
                                Print.sysPrintln("Invalid Boolean entry", new Object[0]);
                                break;
                            }
                            case 5: {
                                if (StringTools.isLong(line, true)) {
                                    piVal = line;
                                    break;
                                }
                                Print.sysPrintln("Invalid Long entry", new Object[0]);
                                break;
                            }
                            case 6: {
                                if (StringTools.isDouble(line, true)) {
                                    piVal = line;
                                    break;
                                }
                                Print.sysPrintln("Invalid Double entry", new Object[0]);
                                break;
                            }
                            case 7: {
                                if (ColorTools.isColor(line)) {
                                    piVal = line;
                                    break;
                                }
                                Print.sysPrintln("Invalid Color entry", new Object[0]);
                                break;
                            }
                            default: {
                                piVal = line;
                            }
                        }
                        if (piVal.equals(pi.getValue())) continue;
                        pi.setValue(piVal);
                        pi.setChanged(true);
                    }
                }
            }
            Print.sysPrintln("", new Object[0]);
            Print.sysPrintln("-------------------------------------------------------", new Object[0]);
            if (this.hasChanged()) {
                String line;
                do {
                    Print.sysPrintln("Configuration has Changed.  Save? [yes|no] ", new Object[0]);
                    line = FileTools.readLine_stdin().trim();
                    if (!line.equalsIgnoreCase("yes")) continue;
                    String[] saveErrMsg = this.save();
                    if (saveErrMsg != null) {
                        String pageID = saveErrMsg[0];
                        String errMsg = saveErrMsg[1] != null ? saveErrMsg[1] : "An error occurred while attempting to save the Configuration.";
                        Print.sysPrintln("ERROR: " + errMsg, new Object[0]);
                    }
                    break;
                } while (!line.equalsIgnoreCase("no"));
            } else {
                Print.sysPrintln("No changes have been made", new Object[0]);
            }
            Print.sysPrintln("", new Object[0]);
            System.exit(0);
        }
        catch (IOException ioe) {
            Print.logException("Error on STDIN", ioe);
            System.exit(99);
        }
    }

    private static String _trimTags(String s) {
        char[] ch = StringTools.trim(s).toCharArray();
        StringBuffer sb = new StringBuffer();
        int inTag = 0;
        for (int i = 0; i < ch.length; ++i) {
            if (inTag == 0 && ch[i] == '&' && i + 3 < ch.length && ch[i + 1] == '#') {
                int c;
                String v = "";
                for (c = i + 2; c < i + 5 && c < ch.length && ch[c] != ';'; ++c) {
                    v = v + ch[c];
                }
                int X = StringTools.parseInt(v, 0);
                if (X > 0) {
                    sb.append((char)X);
                    i = c;
                    continue;
                }
            }
            if (ch[i] == '<') {
                ++inTag;
                if (i + 2 < ch.length && Character.toUpperCase(ch[i + 1]) == 'B' && Character.toUpperCase(ch[i + 2]) == 'R') {
                    sb.append("\n");
                    continue;
                }
                sb.append(" ");
                continue;
            }
            if (ch[i] == '>') {
                if (--inTag >= 0) continue;
                inTag = 0;
                continue;
            }
            if (inTag != 0) continue;
            sb.append(ch[i]);
        }
        return sb.toString().trim();
    }

    public boolean hasChanged() {
        for (PropertyGroup pg : GTSProperties.getInstance().getPropertyGroup().values()) {
            if (!pg.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void clearChanged() {
        for (PropertyGroup pg : GTSProperties.getInstance().getPropertyGroup().values()) {
            pg.clearChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] save() {
        String[] error;
        String[] pc;
        block12: {
            pc = StringTools.split(StringTools.toStringValue(FileTools.readFile(this.getPrivateConfFile())), '\n');
            if (ListTools.isEmpty(pc)) {
                Print.logError("New file: " + this.getPrivateConfFile(), new Object[0]);
                pc = new String[]{};
            }
            error = null;
            int cfgViewCnt = 0;
            boolean addedNewProps = false;
            for (PropertyGroup pg : this.getPropertyGroup().values()) {
                String pageNumber = String.valueOf(cfgViewCnt++);
                for (PropertyItem pi : pg.getPropertyList().values()) {
                    if (pi.isHidden() || pi.getType() == 0) continue;
                    String key = pi.getKey();
                    String key_ = key + "=";
                    String _key_ = "#" + key_;
                    String val = StringTools.trim(pi.getValue(true));
                    String rcd = key_ + val;
                    if (StringTools.isBlank(val) && !pi.getBlankOK()) {
                        error = new String[]{pageNumber, "The following configuration property must must not be blank: \n\"" + pi.getTitle() + "\""};
                        break block12;
                    }
                    boolean found = false;
                    for (int i = 0; i < pc.length; ++i) {
                        if (!pc[i].startsWith(key_) && !pc[i].startsWith(_key_)) continue;
                        pc[i] = rcd;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    pc = ListTools.add(pc, rcd);
                    addedNewProps = true;
                }
                if (!addedNewProps) continue;
                pc = ListTools.add(pc, "");
            }
        }
        if (error != null) {
            return error;
        }
        if (this.getPrivateConfFile().exists() && this.getPrivateConfFile().isFile()) {
            File bakFile = new File(this.getPrivateConfFile().toString() + ".bak");
            if (bakFile.exists() && bakFile.isFile()) {
                bakFile.delete();
            }
            this.getPrivateConfFile().renameTo(bakFile);
        }
        byte[] pcb = StringTools.join(pc, "\n").getBytes();
        try {
            FileTools.writeFile(pcb, this.getPrivateConfFile());
            Print.logInfo("File saved: %s", this.getPrivateConfFile());
            this.clearChanged();
            return null;
        }
        catch (IOException ioe) {
            String fileName = StringTools.trim(this.getPrivateConfFile());
            String errorMsg = "Unable to save file: " + fileName;
            Print.logException(errorMsg, ioe);
            return new String[]{null, errorMsg};
        }
    }
}

