/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.opt.config.AboutDialog;
import org.opengts.opt.config.GTSProperties;
import org.opengts.opt.config.PropertyGroup;
import org.opengts.opt.config.views.CheckInstall;
import org.opengts.opt.config.views.ConfigComplete;
import org.opengts.opt.config.views.ConfigProperties;
import org.opengts.opt.config.views.DCServerMonitor;
import org.opengts.opt.config.views.LogFile;
import org.opengts.opt.config.views.Tomcat;
import org.opengts.opt.config.views.TrackWar;
import org.opengts.opt.config.views.UpdateTables;
import org.opengts.opt.config.views.Welcome;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VFrame;
import org.opengts.opt.ui.VList;
import org.opengts.opt.ui.VListItem;
import org.opengts.opt.ui.VListViewer;
import org.opengts.opt.ui.VMenu;
import org.opengts.opt.ui.VMenuItem;
import org.opengts.opt.ui.VOptionPane;
import org.opengts.opt.ui.VScrollPane;
import org.opengts.util.FileTools;
import org.opengts.util.HTMLTools;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class GTSConfig
extends VFrame {
    private static final String PROP_APPLE_MENUBAR = "apple.laf.useScreenMenuBar";
    private static final String PROP_APPLE_ABOUT_NAME = "com.apple.mrj.application.apple.menu.about.name";
    private static final String PROP_APPLE_GROWBOX_INTRUDE = "com.apple.mrj.application.growbox.intrudes";
    private static final String PROP_APPLE_LIVE_RESIZE = "com.apple.mrj.application.live-resize";
    private static final String PROP_APPLE_SMALL_TABS = "com.apple.macos.smallTabs";
    private static final String PAGE_WELCOME = "welcome";
    private static final String PAGE_CONFIG_ = "config_";
    private static final String PAGE_SAVE = "save";
    private static final String PAGE_INSTALLOG = "installLog";
    private static final String PAGE_UPDATETABLES = "updateTables";
    private static final String PAGE_CHECKINSTALL = "checkinstall";
    private static final String PAGE_TOMCATSTATUS = "tomcat";
    private static final String PAGE_WAR_ = "war_";
    private static final String PAGE_TRACKWAR = "war_track";
    private static final String PAGE_LOGFILE = "logFile";
    private static final String PAGE_DCSERVER = "dcserver";
    public static final String PROP_SAMPLE_OPTION = "gtsConfig.option";
    public static final Color COLOR_BACKGROUND = new Color(238, 238, 238);
    private static GTSConfig SingletonInstance = null;
    private GTSListViewer listViewer = null;
    private VMenu contextMenu = null;
    private VMenuItem sysAdminMenuItem = null;
    private Vector<ConfigProperties> configPropViewList = null;
    private static AboutDialog aboutDialog = null;
    private static Runnable showAbout = null;

    public static void showInfoDialog(String msg, String title) {
        VOptionPane.showInfoDialog((Component)GTSConfig.getViewContainer(), (Object)msg, (String)title);
    }

    public static void showErrorDialog(String msg, String title) {
        VOptionPane.showErrorDialog((Component)GTSConfig.getViewContainer(), (Object)msg, (String)title);
    }

    public static boolean showConfirmDialog(String msg, String title) {
        return VOptionPane.showYesNoDialog((Component)GTSConfig.getViewContainer(), (Object)msg, (String)title);
    }

    public static boolean showOkCancelDialog(String msg, String title) {
        return VOptionPane.showOkCancelDialog((Component)GTSConfig.getViewContainer(), (Object)msg, (String)title);
    }

    public static String showPasswordConfirmInputDialog(String msg, String title) {
        return VOptionPane.showPasswordConfirmInputDialog((Component)GTSConfig.getViewContainer(), (Object)msg, (String)title);
    }

    public static String showTextInputDialog(String msg, String title) {
        return VOptionPane.showTextInputDialog((Component)GTSConfig.getViewContainer(), (Object)msg, (String)title);
    }

    public static String showTextInputDialog(String msg, String title, String dftText) {
        return VOptionPane.showTextInputDialog((Component)GTSConfig.getViewContainer(), (Object)msg, (String)title, (String)dftText);
    }

    public static String getFormattedCommandDisplay(String[] cmd) {
        StringBuffer sb = new StringBuffer();
        sb.append("% " + cmd[0] + "\n");
        for (int i = 1; i < cmd.length; ++i) {
            sb.append("      " + cmd[i] + "\n");
            if (!cmd[i].equals("-classpath")) continue;
            String[] cp = StringTools.split(cmd[++i], File.pathSeparatorChar);
            for (int p = 0; p < cp.length; ++p) {
                sb.append("          " + cp[p] + "\n");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public static GTSConfig getInstance() {
        if (SingletonInstance == null) {
            new GTSConfig();
        }
        return SingletonInstance;
    }

    private GTSConfig() {
        super("");
        SingletonInstance = this;
        GTSProperties.getInstance();
        this.setBackground(COLOR_BACKGROUND);
        super.setTitle("GTS Configuration v1.2.2 [" + GTSProperties.GTS_HOME + "]");
        this.initMenuBar();
        VBox content = this.getContentBox();
        content.setGBCX(0.5, 0, 1);
        content.setGBCY(0.5, 0, 1);
        this.listViewer = new GTSListViewer();
        content.add((Component)((Object)this.listViewer), (Object)content.getDefaultGBC());
        this.initListViewer();
        this.setActionOnClose(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GTSConfig.this.exit();
            }
        }, "close");
        this.centerOnScreen(950, 700);
    }

    protected VListItem addListItem(List<VListItem> itemList, String key, String title, boolean clickSelectEnabled, boolean allowPrev, boolean allowNext, Component customView) {
        String _title = title;
        VListItem item = new VListItem(key, (Object)_title, customView);
        item.setEnabled(clickSelectEnabled);
        item.setAllowSelectNext(allowNext);
        item.setAllowSelectPrevous(allowPrev);
        itemList.add(item);
        return item;
    }

    protected void initListViewer() {
        File installLogFile;
        Vector<VListItem> itemList = new Vector<VListItem>();
        if (GTSProperties.CONFIG_MODE) {
            this.addListItem(itemList, PAGE_WELCOME, "Welcome (Start Here)", true, true, true, (Component)((Object)new Welcome(this, GTSProperties.getInstance().getPropertyItemLoader().getWelcome())));
            this.addListItem(itemList, null, null, false, true, true, null);
            int cfgViewCnt = 1;
            this.configPropViewList = new Vector();
            for (PropertyGroup pg : GTSProperties.getInstance().getPropertyGroup().values()) {
                String desc = cfgViewCnt + ") " + pg.getDescription();
                if (cfgViewCnt < 10) {
                    desc = "  " + desc;
                }
                ConfigProperties cfgView = new ConfigProperties(this, pg, GTSProperties.getInstance().getPrivateConf());
                this.addListItem(itemList, PAGE_CONFIG_ + cfgViewCnt, desc, false, true, true, (Component)((Object)cfgView));
                this.configPropViewList.add(cfgView);
                ++cfgViewCnt;
            }
            this.addListItem(itemList, PAGE_SAVE, "Save Configuration", false, true, false, (Component)((Object)new ConfigComplete(this, GTSProperties.getInstance().getPropertyItemLoader().getCompletion())));
            this.addListItem(itemList, null, null, false, true, true, null);
            this.addListItem(itemList, null, null, false, true, true, null);
        }
        if ((installLogFile = RTConfig.getFile(GTSProperties.ARG_LOGFILE, null)) != null && installLogFile.isFile()) {
            this.addListItem(itemList, PAGE_INSTALLOG, "Installation Log", true, true, true, (Component)((Object)new LogFile(this, installLogFile, -1L)));
        }
        this.addListItem(itemList, PAGE_UPDATETABLES, "UpdateTables", true, false, true, (Component)((Object)new UpdateTables(this)));
        this.addListItem(itemList, PAGE_CHECKINSTALL, "CheckInstall", true, true, true, (Component)((Object)new CheckInstall(this)));
        if (!GTSProperties.isWindows()) {
            this.addListItem(itemList, PAGE_TOMCATSTATUS, "Tomcat Status", true, true, true, (Component)((Object)new Tomcat(this)));
        }
        if (!GTSProperties.isWindows()) {
            this.addListItem(itemList, PAGE_TRACKWAR, "Servlet Deployment", true, true, true, (Component)((Object)new TrackWar(this, this.getServletWarNames())));
        }
        this.addListItem(itemList, null, null, false, true, true, null);
        String trackWarLog = GTSProperties.GTS_HOME + File.separator + "logs" + File.separator + "TrackWar.log";
        File trackWarLogFile = new File(trackWarLog);
        this.addListItem(itemList, PAGE_LOGFILE, "LogFile Monitor", true, true, true, (Component)((Object)new LogFile(this, trackWarLogFile, 80000L)));
        this.addListItem(itemList, PAGE_DCSERVER, "DCServer Monitor", true, true, true, (Component)((Object)new DCServerMonitor(this)));
        this.listViewer.setListItems(itemList);
    }

    protected OrderedSet<String> getServletWarNames() {
        File warDir = FileTools.toFile(new String[]{GTSProperties.GTS_HOME, "build"});
        File[] warList = FileTools.getFiles(warDir, new String[]{"war"}, false);
        OrderedSet<String> warSet = new OrderedSet<String>(true);
        if (warList != null) {
            String[] warNames = new String[warList.length];
            for (int f = 0; f < warList.length; ++f) {
                String n = warList[f].getName();
                if (!StringTools.endsWithIgnoreCase(n, ".war")) continue;
                warNames[f] = n.substring(0, n.length() - ".war".length());
            }
            ListTools.toSet(ListTools.sort(warNames, null), warSet);
        }
        if (!warSet.contains("track")) {
            warSet.add(0, "track");
        }
        warSet.addAll(RTConfig.getStringArray(GTSProperties.ARG_WARSERVLETS, null));
        return warSet;
    }

    protected void initMenuBar() {
        String sysAdminMenuTitle;
        boolean macMenuBar = RTConfig.getBoolean(PROP_APPLE_MENUBAR, false);
        if (GTSProperties.CONFIG_MODE || !macMenuBar) {
            VMenu file = new VMenu("File", 70);
            this.addMenu((JMenu)file);
            if (GTSProperties.CONFIG_MODE) {
                file.add((JMenuItem)new VMenuItem("Save", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        GTSConfig.this.save();
                    }
                }, 83));
            }
            if (!macMenuBar) {
                if (GTSProperties.CONFIG_MODE) {
                    file.addSeparator();
                }
                file.add((JMenuItem)new VMenuItem("Exit", new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        GTSConfig.this.exit();
                    }
                }, 120).setShortcut(81));
            }
        }
        if (!StringTools.isBlank(sysAdminMenuTitle = this.getSysAdminMenuTitle())) {
            VMenu utils = new VMenu("Utilities", 85);
            this.addMenu((JMenu)utils);
            this.sysAdminMenuItem = new VMenuItem(sysAdminMenuTitle, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GTSConfig.this.changeSysAdminPassword();
                }
            }, 83);
            utils.add((JMenuItem)this.sysAdminMenuItem);
        }
        VMenu help = new VMenu("Help", 72);
        this.addMenu((JMenu)help);
        help.add((JMenuItem)new VMenuItem("About ...", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GTSConfig.showAbout();
            }
        }, 97));
    }

    public static Container getViewContainer() {
        return GTSConfig.getInstance().listViewer.getCustomContainer();
    }

    public GTSListViewer getList() {
        return this.listViewer;
    }

    public VListItem getSelectedItem() {
        return this.getList().getSelectedItem();
    }

    public void refreshSelectedItem() {
        VListItem selItem = this.getSelectedItem();
        if (selItem != null) {
            Component comp = selItem.getCustomView();
            if (comp instanceof VScrollPane) {
                comp = ((VScrollPane)comp).getViewportView();
            }
            if (comp instanceof VBox) {
                ((VBox)comp).refresh();
            }
        }
    }

    private String getSysAdminMenuTitle() {
        try {
            if (AccountRecord.getSystemAdminAccount() == null) {
                return "Create SystemAdmin Account";
            }
            return "Change SystemAdmin Password";
        }
        catch (DBException dbe) {
            return null;
        }
    }

    private void changeSysAdminPassword() {
        String password;
        boolean createSysAdmin;
        Account sysAdminAccount;
        block14: {
            boolean okContinue;
            sysAdminAccount = null;
            try {
                sysAdminAccount = AccountRecord.getSystemAdminAccount();
            }
            catch (DBException dbe) {
                GTSConfig.showErrorDialog("Database error occurred while attempting to read 'SystemAdmin' Account:\n" + dbe.getMessage(), "Error Reading SystemAdmin Account");
                return;
            }
            createSysAdmin = sysAdminAccount == null;
            password = null;
            do {
                if ((password = createSysAdmin ? GTSConfig.showPasswordConfirmInputDialog("Creating New SystemAdmin Account\nPlease enter a password:", "Enter SystemAdmin password") : GTSConfig.showPasswordConfirmInputDialog("Changing SystemAdmin Password\nPlease enter a new password:", "Enter SystemAdmin password")) == null) {
                    return;
                }
                if (!StringTools.isBlank(password)) break block14;
            } while (okContinue = GTSConfig.showOkCancelDialog("The SystemAdmin password must not be blank.\nPlease re-enter the password", "Enter New SystemAdmin Password"));
            return;
        }
        password = StringTools.trim(password);
        if (createSysAdmin) {
            try {
                AccountRecord.createSystemAdminAccount(password);
                if (this.sysAdminMenuItem != null) {
                    this.sysAdminMenuItem.setText(this.getSysAdminMenuTitle());
                }
            }
            catch (DBException dbe) {
                GTSConfig.showErrorDialog("Unable to create SystemAdmin account", "Error Creating SystemAdmin Account");
                return;
            }
            GTSConfig.showInfoDialog("New SystemAdmin account created: '" + AccountRecord.getSystemAdminAccountID() + "'", "Changed Password");
        } else {
            try {
                sysAdminAccount.setDecodedPassword(null, password);
                sysAdminAccount.update("password");
                Print.logInfo("Updated SysAdmin Account password", new Object[0]);
            }
            catch (DBException dbe) {
                GTSConfig.showErrorDialog("Error saving SystemAdmin account:\n" + dbe.getMessage(), "Error Saving SystemAdmin Account");
                return;
            }
            try {
                User adminUser = User.getUser(sysAdminAccount, User.getAdminUserID());
                if (adminUser != null) {
                    adminUser.setDecodedPassword(null, password);
                    adminUser.update("password");
                    Print.logInfo("Updated SysAdmin Account 'admin' User password", new Object[0]);
                }
            }
            catch (DBException dbe) {
                GTSConfig.showErrorDialog("Error saving password for SystemAdmin '" + User.getAdminUserID() + "' user:\n" + dbe.getMessage(), "Error Saving Password");
                return;
            }
            GTSConfig.showInfoDialog("Password changed for account: '" + AccountRecord.getSystemAdminAccountID() + "'", "Changed Password");
        }
    }

    public static void showAbout() {
        if (aboutDialog == null) {
            aboutDialog = new AboutDialog((Frame)((Object)GTSConfig.getInstance()));
            showAbout = new Runnable(){

                @Override
                public void run() {
                    aboutDialog.setVisible(true);
                }
            };
        }
        try {
            if (MethodAction.isDispatchThread()) {
                showAbout.run();
            } else {
                MethodAction.invokeLater(showAbout);
            }
        }
        catch (Throwable th) {
            Print.logError("Unable to display 'About' panel: " + th, new Object[0]);
        }
    }

    public void save() {
        String[] savedErrMsg = GTSProperties.getInstance().save();
        if (savedErrMsg != null) {
            String pageNumber = savedErrMsg[0];
            if (pageNumber != null) {
                this.listViewer.setSelectedItem(PAGE_CONFIG_ + pageNumber);
            }
            String errMsg = savedErrMsg[1] != null ? savedErrMsg[1] : "An error occurred while attempting to save the Configuration.";
            GTSConfig.showErrorDialog(errMsg, "Error Saving Configuration");
            return;
        }
        RTConfig.reload();
        String tomcatResetMsg = "";
        boolean didResetTomcat = false;
        try {
            String host = "localhost";
            byte[] b = HTMLTools.readPage_GET("http://" + host + ":8080/track/Track?page=RELOAD:XML&page_cmd=short", 5000);
            String s = !ListTools.isEmpty(b) && b.length < 30 ? StringTools.trim(StringTools.toStringValue(b)) : "?";
            tomcatResetMsg = "(Web-interface reinitialized: " + s + ")";
            didResetTomcat = true;
        }
        catch (ConnectException ce) {
            tomcatResetMsg = "(Tomcat does not appear to be running)";
            didResetTomcat = false;
        }
        catch (Throwable th) {
            Print.logException("(Unable to reinitialize web-interface)", th);
            tomcatResetMsg = "(Unable to reinitialize web-interface: " + th.getMessage() + ")";
            didResetTomcat = false;
        }
        GTSConfig.showInfoDialog("The Configuration has been successfully saved to file:\n   " + GTSProperties.getInstance().getPrivateConfFile() + "\n" + "\n" + tomcatResetMsg, "Save Configuration");
        this.listViewer.getVList().setSelectedIndex(0);
    }

    public void cancel() {
        this.listViewer.getVList().setSelectedIndex(0);
    }

    public static void exitApp() {
        if (MethodAction.isDispatchThread()) {
            GTSConfig.getInstance().exit();
        } else {
            try {
                MethodAction.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        GTSConfig.getInstance().exit();
                    }
                });
            }
            catch (Throwable th) {
                System.exit(0);
            }
        }
    }

    public void exit() {
        boolean changed = GTSProperties.getInstance().hasChanged();
        boolean ok = false;
        ok = changed ? VOptionPane.showYesNoDialog((Component)((Object)this), (Object)"All changes will be lost!\nAre you sure you want to exit this application?", (String)"Confirm Exit") : VOptionPane.showYesNoDialog((Component)((Object)this), (Object)"Are you sure you want to exit this application?", (String)"Confirm Exit");
        if (!ok) {
            return;
        }
        System.exit(0);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        if (argv.length > 0 && argv[0].startsWith("-" + GTSProperties.ARG_VERSION[0])) {
            System.out.println("1.2.2");
            System.exit(0);
        } else if (RTConfig.getBoolean(GTSProperties.ARG_VERSION, false)) {
            System.out.println("1.2.2");
            System.exit(0);
        }
        int logLevel = Print.parseLogLevel(RTConfig.getString(GTSProperties.ARG_LOG, null), 4);
        Print.setLogLevel(logLevel);
        Print.setLogHeaderLevel(logLevel);
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            RTConfig.setString("HostName", hostname);
            InetAddress hostip = InetAddress.getByName(hostname);
            RTConfig.setString("HostAddress", hostip.getHostAddress());
            InetAddress[] ipAddr = InetAddress.getAllByName(RTConfig.getString(GTSProperties.ARG_HOST, hostname));
        }
        catch (UnknownHostException uhe) {
            Print.logException("Error obtaining local host name (name not specified in '/etc/hosts'?)", uhe);
        }
        GTSProperties.getInstance();
        if (RTConfig.getBoolean(GTSProperties.ARG_LIST_CONFIG, false)) {
            GTSProperties.getInstance().listConfig();
            System.exit(0);
        }
        if (RTConfig.getBoolean(GTSProperties.ARG_EDIT_CONFIG, false)) {
            GTSProperties.getInstance().editConfig();
            System.exit(0);
        }
        String laf = VFrame.setLookAndFeel((String)RTConfig.getString("laf", null));
        Print.logInfo("Set LookAndFeel: " + laf, new Object[0]);
        if (OSTools.isMacOSX()) {
            System.setProperty(PROP_APPLE_MENUBAR, "true");
            System.setProperty(PROP_APPLE_ABOUT_NAME, "GTSConfig");
            try {
                String malClz = "org.opengts.extra.macosx.MacAppListener";
                new MethodAction((Object)malClz, ActionListener.class).invoke(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        if ("quit".equals(ae.getActionCommand())) {
                            GTSConfig.exitApp();
                            return;
                        }
                        if ("about".equals(ae.getActionCommand())) {
                            GTSConfig.showAbout();
                            return;
                        }
                    }
                });
            }
            catch (Throwable th) {
                Print.logError("Unable to initialize Mac ApplicationListener: " + th, new Object[0]);
            }
        }
        try {
            GTSConfig gtsConfig = GTSConfig.getInstance();
            gtsConfig.setVisible(true);
            gtsConfig.listViewer.getVList().setSelectedIndex(0);
            GTSConfig.showAbout();
        }
        catch (HeadlessException he) {
            Print.logException("ERROR: GTSConfig must be run from the computer console", he);
            System.exit(1);
        }
        catch (Throwable th) {
            Print.logException("ERROR", th);
            System.exit(2);
        }
    }

    private class GTSListViewer
    extends VListViewer {
        public GTSListViewer() {
            super("Configuration Checklist", null, true);
            this.addSelectionListener(new VList.VListSelectionListener(){

                public void selectionChanged(VList list) {
                    VListItem selItem = list.getSelectedItem();
                }
            });
            this.setPreferredListWidth(200);
        }

        public VList createVList(String listTitle) {
            VList list = super.createVList(listTitle);
            return list;
        }
    }

    public static class GTSBox
    extends VBox {
        private String viewName = null;
        private GTSConfig gtsConfig = null;

        public GTSBox(GTSConfig gtsConfig) {
            super(null, null, false);
            this.gtsConfig = gtsConfig;
        }

        public GTSConfig getGTSConfig() {
            return this.gtsConfig;
        }

        public String getViewName() {
            if (this.viewName == null) {
                String clzName = StringTools.className((Object)this);
                int p = clzName.lastIndexOf(".");
                this.viewName = clzName.substring(p + 1);
            }
            return this.viewName;
        }

        public void refresh() {
            super.refresh();
            try {
                this._refresh();
            }
            catch (Throwable th) {
                Print.logException("Refresh error [" + this.getViewName() + "]", th);
                GTSConfig.showErrorDialog("'" + this.getViewName() + "' Screen update error\n" + th.toString() + "\n" + "(See log file for details)", "Internal Error");
            }
        }

        protected void _refresh() {
        }
    }
}

