/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rulewar.track.page;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.StatusCode;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.rule.tables.Rule;
import org.opengts.rule.tables.RuleList;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.tools.AttributeTools;
import org.opengts.war.tools.ComboMap;
import org.opengts.war.tools.ComboOption;
import org.opengts.war.tools.CommonServlet;
import org.opengts.war.tools.HTMLOutput;
import org.opengts.war.tools.JavaScriptTools;
import org.opengts.war.tools.MenuBar;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPageAdaptor;
import org.opengts.war.track.Constants;
import org.opengts.war.track.EMail;

public class RuleInfo
extends WebPageAdaptor
implements Constants {
    private static final boolean SYSRULES_ONLY = false;
    private static final boolean INCLUDE_PREFERRED_DEVICE = true;
    public static final String RULETAG_ = "ruleTag.";
    public static final String RULETAG_1MIN = "1min";
    public static final String RULETAG_5MIN = "5min";
    public static final String RULETAG_15MIN = "15min";
    public static final String RULETAG_30MIN = "30min";
    public static final String RULETAG_HOURLY = "hourly";
    public static final String RULETAG_DAILY = "daily";
    public static final String RULETAG_WEEKLY = "weekly";
    public static final String RULETAG_MONTHLY = "monthly";
    public static final String FORM_RULE_SELECT = "RuleInfoSelect";
    public static final String FORM_RULE_NEW = "RuleInfoNew";
    public static final String FORM_RULE_EDIT = "RuleInfoEdit";
    public static final String COMMAND_INFO_UPDATE = "update";
    public static final String COMMAND_INFO_SELECT = "select";
    public static final String COMMAND_INFO_NEW = "new";
    public static final String PARM_SUBMIT_EDIT = "r_subedit";
    public static final String PARM_SUBMIT_VIEW = "r_subview";
    public static final String PARM_SUBMIT_CHG = "r_subchg";
    public static final String PARM_SUBMIT_DEL = "r_subdel";
    public static final String PARM_SUBMIT_NEW = "r_subnew";
    public static final String PARM_BUTTON_CANCEL = "r_btncan";
    public static final String PARM_BUTTON_BACK = "r_btnbak";
    public static final String PARM_NEW_RULE = "r_newrule";
    public static final String PARM_RULE_SELECT = "r_rule";
    public static final String PARM_RULE_SYSRULE = "r_sysrule";
    public static final String PARM_RULE_DESC = "r_desc";
    public static final String PARM_RULE_SELECTOR = "r_selector";
    public static final String PARM_RULE_ACTIVE = "r_active";
    public static final String PARM_RULE_ISCRON = "r_cron";
    public static final String PARM_RULE_ACT_EMAIL = "ra_email";
    public static final String PARM_RULE_ACT_EMAIL_A = "ra_emailA";
    public static final String PARM_RULE_ACT_EMAIL_D = "ra_emailD";
    public static final String PARM_RULE_ACT_EMAIL_R = "ra_emailR";
    public static final String PARM_RULE_ACT_QUEUE = "ra_queue";
    public static final String PARM_RULE_ACT_LISTENER = "ra_lstnr";
    public static final String PARM_RULE_ACT_SAVE = "ra_save";
    public static final String PARM_MIN_TRIGGER_TIME = "r_trigtime";
    public static final String PARM_CANNED_ACTIONS = "r_cra";
    public static final String PARM_RULE_EMAIL_ADDR = "r_addr";
    public static final String PARM_RULE_EMAIL_SUBJ = "r_subj";
    public static final String PARM_RULE_EMAIL_TEXT = "r_text";
    public static final String PARM_RULE_EMAIL_WRAP = "r_wrap";
    public static final String PARM_RULE_SMS_TEXT = "r_sms";
    public static final String PARM_RULE_DEVICE = "r_devid";
    public static final String PARM_RULE_GROUP = "r_grpid";
    public static final String PARM_RULE_STATUS_COD = "r_code";

    private static boolean IncludeDeviceSelection() {
        return true;
    }

    private static boolean IncludeDeviceGroupRules() {
        return RuleList.IncludeDeviceGroupRules();
    }

    public RuleInfo() {
        this.setBaseURI(RequestProperties.TRACK_BASE_URI());
        this.setPageName("rule.info");
        this.setPageNavigation(new String[]{"login", "menu.top"});
        this.setLoginRequired(true);
    }

    public boolean getIsEnabled() {
        boolean hasRule = DBConfig.hasRulePackage();
        if (!hasRule) {
            Print.logWarn((String)"RuleInfo present, but Rules Engine not found", (Object[])new Object[0]);
        }
        return hasRule;
    }

    public String getMenuName(RequestProperties reqState) {
        return "menu.admin";
    }

    public String getMenuDescription(RequestProperties reqState, String parentMenuName) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(RuleInfo.class);
        return super._getMenuDescription(reqState, i18n.getString("RuleInfo.editMenuDesc", "View/Edit Rule Information"));
    }

    public String getMenuHelp(RequestProperties reqState, String parentMenuName) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(RuleInfo.class);
        return super._getMenuHelp(reqState, i18n.getString("RuleInfo.editMenuHelp", "View and Edit Rule information"));
    }

    public String getNavigationDescription(RequestProperties reqState) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(RuleInfo.class);
        return super._getNavigationDescription(reqState, i18n.getString("RuleInfo.navDesc", "Rule"));
    }

    public String getNavigationTab(RequestProperties reqState) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(RuleInfo.class);
        return i18n.getString("RuleInfo.navTab", "Rule Admin");
    }

    private String getRuleTagDescription(PrivateLabel privLabel, Locale locale, String ruleTag) {
        if (StringTools.isBlank((String)ruleTag)) {
            return ComboOption.getYesNoText((Locale)locale, (boolean)true);
        }
        String key = RULETAG_ + ruleTag;
        String desc = privLabel.getI18NTextString(key, null);
        if (!StringTools.isBlank((String)desc)) {
            return desc;
        }
        I18N i18n = I18N.getI18N(RuleInfo.class, (Locale)locale);
        if (ruleTag.equals(RULETAG_1MIN)) {
            return i18n.getString("RuleInfo.cron.1min", "1 Minute");
        }
        if (ruleTag.equals(RULETAG_5MIN)) {
            return i18n.getString("RuleInfo.cron.5min", "5 Minute");
        }
        if (ruleTag.equals(RULETAG_15MIN)) {
            return i18n.getString("RuleInfo.cron.15min", "15 Minute");
        }
        if (ruleTag.equals(RULETAG_30MIN)) {
            return i18n.getString("RuleInfo.cron.30min", "30 Minute");
        }
        if (ruleTag.equals(RULETAG_HOURLY)) {
            return i18n.getString("RuleInfo.cron.hourly", "Hourly");
        }
        if (ruleTag.equals(RULETAG_DAILY)) {
            return i18n.getString("RuleInfo.cron.daily", "Daily");
        }
        if (ruleTag.equals(RULETAG_WEEKLY)) {
            return i18n.getString("RuleInfo.cron.weekly", "Weekly");
        }
        if (ruleTag.equals(RULETAG_MONTHLY)) {
            return i18n.getString("RuleInfo.cron.monthly", "Monthly");
        }
        return ruleTag;
    }

    private List<ComboOption> getRuleTagComboOptions(PrivateLabel privLabel, Locale locale) {
        I18N i18n = I18N.getI18N(RuleInfo.class, (Locale)locale);
        Vector<ComboOption> tagOptList = new Vector<ComboOption>();
        String tags = privLabel.getStringProperty("ruleInfo.ruleTagList", null);
        if (!StringTools.isBlank((String)tags)) {
            for (String tag : StringTools.split((String)tags, (char)',')) {
                if (StringTools.isBlank((String)tag)) continue;
                String desc = this.getRuleTagDescription(privLabel, locale, tag);
                tagOptList.add(new ComboOption(tag, desc));
            }
        }
        return tagOptList;
    }

    private ComboMap getRuleTagComboMap(PrivateLabel privLabel, Locale locale, boolean isCronRule, String ruleTag) {
        I18N i18n = I18N.getI18N(RuleInfo.class, (Locale)locale);
        ComboMap tagMap = new ComboMap();
        String NO = "0";
        String YES = "1";
        tagMap.add(NO, ComboOption.getYesNoText((Locale)locale, (boolean)false));
        tagMap.add(YES, ComboOption.getYesNoText((Locale)locale, (boolean)true));
        tagMap.setDefaultSelection(isCronRule ? new ComboOption(YES, ComboOption.getYesNoText((Locale)locale, (boolean)true)) : new ComboOption(NO, ComboOption.getYesNoText((Locale)locale, (boolean)false)));
        for (ComboOption tagOpt : this.getRuleTagComboOptions(privLabel, locale)) {
            String tag = tagOpt.getKey();
            tagMap.add(tag, tagOpt.getDescription());
            if (!tag.equalsIgnoreCase(ruleTag)) continue;
            tagMap.setDefaultSelection(tagOpt);
        }
        return tagMap;
    }

    private ComboMap getStatusCodeComboMap(PrivateLabel privLabel, Locale locale, String accountID) {
        I18N i18n = I18N.getI18N(RuleInfo.class, (Locale)locale);
        OrderedSet _scList = privLabel.getStatusCodeList();
        try {
            int[] customCodes;
            boolean sortCodes = false;
            for (int cc : customCodes = StatusCode.getStatusCodes((String)accountID, null)) {
                Integer cci = new Integer(cc);
                if (_scList.contains((Object)cci)) continue;
                _scList.add((Object)cci);
                sortCodes = true;
            }
            if (sortCodes) {
                ListTools.sort((List)_scList, (Comparator)new ListTools.NumberComparator());
            }
        }
        catch (DBException dbe) {
            Print.logWarn((String)"Error reading StatusCodes", (Object[])new Object[]{dbe});
        }
        ComboMap codeMap = new ComboMap();
        for (Integer sc : _scList) {
            int code = sc;
            String codeStr = "0x" + StringTools.toHexString((long)code, (int)16);
            if (code == 0) {
                codeMap.add(codeStr, i18n.getString("RuleInfo.allCodes", "All Codes"));
                continue;
            }
            String dftd = "";
            String desc = StatusCode.getDescription((String)accountID, (int)code, (BasicPrivateLabel)privLabel, (String)dftd);
            String scd = "[" + StatusCodes.GetHex((int)code) + "] " + desc;
            codeMap.add(codeStr, scd);
        }
        return codeMap;
    }

    private String filter(String s) {
        if (StringTools.isBlank((String)s)) {
            return "&nbsp;";
        }
        return s;
    }

    private String[] getAccountRuleIDs(String currAcctID) {
        try {
            Collection ruleIDs = Rule.getRuleIDs((String)currAcctID, (boolean)false, (boolean)true, (boolean)false);
            return ruleIDs.toArray(new String[ruleIDs.size()]);
        }
        catch (DBException dbe) {
            Print.logError((String)("Error getting list of Rules: " + (Object)((Object)dbe)), (Object[])new Object[0]);
            return new String[0];
        }
    }

    public void writePage(final RequestProperties reqState, String pageMsg) throws IOException {
        boolean viewRule;
        boolean editRule;
        boolean listRules;
        boolean allowView;
        boolean allowEdit;
        boolean allowDelete;
        boolean allowNew;
        int showCannedActions;
        int showTriggerActions;
        int showSysRules;
        boolean showRuleList;
        Rule selRule;
        boolean showCronRules;
        boolean isSystemRuleID;
        boolean isSystemAcctID;
        Object selRuleID;
        Object[] ruleList;
        boolean error;
        String m;
        String pageName;
        String currAcctID;
        Account currAcct;
        String[] devTitles;
        String[] grpTitles;
        Locale locale;
        I18N i18n;
        PrivateLabel privLabel;
        HttpServletRequest request;
        block106: {
            request = reqState.getHttpServletRequest();
            privLabel = reqState.getPrivateLabel();
            i18n = privLabel.getI18N(RuleInfo.class);
            locale = reqState.getLocale();
            grpTitles = reqState.getDeviceGroupTitles();
            devTitles = reqState.getDeviceTitles();
            currAcct = reqState.getCurrentAccount();
            currAcctID = currAcct.getAccountID();
            User currUser = reqState.getCurrentUser();
            pageName = this.getPageName();
            boolean hasRuleFac = Device.hasRuleFactory();
            m = pageMsg;
            error = false;
            ruleList = this.getAccountRuleIDs(currAcctID);
            selRuleID = AttributeTools.getRequestString((ServletRequest)reqState.getHttpServletRequest(), (String)PARM_RULE_SELECT, null);
            if (StringTools.isBlank((String)selRuleID)) {
                selRuleID = ruleList.length > 0 ? ruleList[0] : "";
            }
            if (ruleList.length == 0) {
                ruleList = new String[]{selRuleID};
            }
            isSystemRuleID = !(isSystemAcctID = currAcct.isSystemAdmin()) && Rule.isSystemAdminRuleID((String)selRuleID);
            showCronRules = isSystemAcctID || privLabel.getBooleanProperty("ruleInfo.showCronRules", true);
            selRule = null;
            try {
                selRule = isSystemRuleID ? Rule.getRule((Account)currAcct, (String)selRuleID) : Rule.getRule((Account)currAcct, (String)selRuleID);
            }
            catch (DBException dbe) {
                selRule = null;
            }
            if (selRule != null) {
                selRule.setSystemRuleSettings();
            }
            boolean bl = showRuleList = !isSystemAcctID || currAcct.getDeviceCount() > 0L;
            if (isSystemAcctID) {
                showSysRules = 0;
            } else {
                String ssro = privLabel.getStringProperty("ruleInfo.showSysRulesOnly", "yes");
                showSysRules = (ssro = privLabel.getStringProperty("ruleInfo.showSysRules", ssro)).equalsIgnoreCase("no") || ssro.equalsIgnoreCase("false") || ssro.equals("0") ? 0 : (ssro.equalsIgnoreCase("only") ? 1 : 2);
            }
            String sa = privLabel.getStringProperty("ruleInfo.showTriggerActions", "");
            showTriggerActions = StringTools.isBlank((String)sa) || sa.equalsIgnoreCase("true") || sa.equalsIgnoreCase("yes") || sa.equalsIgnoreCase("1") ? 1 : (sa.equalsIgnoreCase("email") || sa.equalsIgnoreCase("2") ? 2 : 0);
            String pda = privLabel.getStringProperty("ruleInfo.showPredefinedActions", "");
            showCannedActions = StringTools.isBlank((String)pda) || pda.equalsIgnoreCase("false") || pda.equalsIgnoreCase("no") || pda.equalsIgnoreCase("0") ? 0 : (pda.equalsIgnoreCase("true") || pda.equalsIgnoreCase("yes") || pda.equalsIgnoreCase("1") || pda.equalsIgnoreCase("text") ? 2 : (pda.equalsIgnoreCase(COMMAND_INFO_SELECT) || pda.equalsIgnoreCase("pulldown") ? 1 : 0));
            allowDelete = allowNew = !isSystemRuleID && privLabel.hasAllAccess(currUser, this.getAclName());
            allowEdit = allowNew || privLabel.hasWriteAccess(currUser, this.getAclName());
            allowView = allowEdit || privLabel.hasReadAccess(currUser, this.getAclName());
            String ruleCmd = reqState.getCommandName();
            listRules = false;
            boolean updateRule = ruleCmd.equals(COMMAND_INFO_UPDATE);
            boolean selectRule = ruleCmd.equals(COMMAND_INFO_SELECT);
            boolean newRule = ruleCmd.equals(COMMAND_INFO_NEW);
            boolean deleteRule = false;
            editRule = false;
            viewRule = false;
            String submitEdit = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_SUBMIT_EDIT, (String)"");
            String submitView = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_SUBMIT_VIEW, (String)"");
            String submitChange = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_SUBMIT_CHG, (String)"");
            String submitNew = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_SUBMIT_NEW, (String)"");
            String submitDelete = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_SUBMIT_DEL, (String)"");
            String newRuleID = null;
            if (newRule) {
                if (!allowNew) {
                    newRule = false;
                } else {
                    HttpServletRequest httpReq = reqState.getHttpServletRequest();
                    newRuleID = AttributeTools.getRequestString((ServletRequest)httpReq, (String)PARM_NEW_RULE, (String)"").trim();
                    if (StringTools.isBlank((String)(newRuleID = newRuleID.toLowerCase()))) {
                        m = i18n.getString("RuleInfo.enterNewRule", "Please enter a new Rule ID.");
                        error = true;
                        newRule = false;
                    } else if (!StringTools.isBlank((String)"") && newRuleID.startsWith("")) {
                        if (!isSystemAcctID) {
                            m = i18n.getString("RuleInfo.invalidIDChar", "ID contains invalid characters");
                            error = true;
                            newRule = false;
                        } else if (!WebPageAdaptor.isValidID((RequestProperties)reqState, (String)newRuleID.substring("".length()))) {
                            m = i18n.getString("RuleInfo.invalidIDChar", "ID contains invalid characters");
                            error = true;
                            newRule = false;
                        }
                    } else if (!WebPageAdaptor.isValidID((RequestProperties)reqState, (String)newRuleID)) {
                        m = i18n.getString("RuleInfo.invalidIDChar", "ID contains invalid characters");
                        error = true;
                        newRule = false;
                    }
                }
            } else if (updateRule) {
                if (!allowEdit) {
                    updateRule = false;
                } else if (!this.SubmitMatch(submitChange, i18n.getString("RuleInfo.change", "Change"))) {
                    updateRule = false;
                } else if (selRule == null) {
                    m = i18n.getString("RuleInfo.ruleNotFound", "Rule ID does not exist: " + (String)selRuleID);
                    error = true;
                    updateRule = false;
                }
            } else if (selectRule) {
                if (this.SubmitMatch(submitDelete, i18n.getString("RuleInfo.delete", "Delete"))) {
                    if (allowDelete) {
                        deleteRule = true;
                    }
                } else if (this.SubmitMatch(submitEdit, i18n.getString("RuleInfo.edit", "Edit"))) {
                    if (allowEdit) {
                        if (selRule == null) {
                            m = i18n.getString("RuleInfo.pleaseSelectRule", "Please select a Rule");
                            error = true;
                            listRules = true;
                        } else {
                            editRule = true;
                            viewRule = true;
                        }
                    }
                } else if (this.SubmitMatch(submitView, i18n.getString("RuleInfo.view", "View"))) {
                    if (allowView) {
                        if (selRule == null) {
                            m = i18n.getString("RuleInfo.pleaseSelectRule", "Please select a Rule");
                            error = true;
                            listRules = true;
                        } else {
                            viewRule = true;
                        }
                    }
                } else {
                    listRules = true;
                }
            } else {
                listRules = true;
            }
            if (deleteRule) {
                block105: {
                    if (selRule == null) {
                        m = i18n.getString("RuleInfo.pleaseSelectRule", "Please select a Rule");
                        error = true;
                    } else {
                        try {
                            Rule.Key ruleKey = (Rule.Key)selRule.getRecordKey();
                            Print.logWarn((String)("Deleting Rule: " + ruleKey), (Object[])new Object[0]);
                            ruleKey.delete(true);
                            selRuleID = "";
                            selRule = null;
                            ruleList = this.getAccountRuleIDs(currAcctID);
                            if (ListTools.isEmpty((Object[])ruleList)) break block105;
                            selRuleID = ruleList[0];
                            try {
                                selRule = Rule.getRule((Account)currAcct, (String)selRuleID);
                                if (selRule != null) {
                                    selRule.setSystemRuleSettings();
                                }
                            }
                            catch (DBException dbe) {}
                        }
                        catch (DBException dbe) {
                            Print.logException((String)"Deleting Rule", (Throwable)dbe);
                            m = i18n.getString("RuleInfo.errorDelete", "Internal error deleting Rule");
                            error = true;
                        }
                    }
                }
                listRules = true;
            }
            if (newRule) {
                boolean createRuleOK = true;
                for (int u = 0; u < ruleList.length; ++u) {
                    if (!ruleList[u].equalsIgnoreCase(newRuleID)) continue;
                    m = i18n.getString("RuleInfo.alreadyExists", "This Rule already exists");
                    error = true;
                    createRuleOK = false;
                    break;
                }
                if (createRuleOK) {
                    try {
                        Rule rule = Rule.createNewRule((Account)currAcct, (String)newRuleID);
                        ruleList = this.getAccountRuleIDs(currAcctID);
                        selRule = rule;
                        selRuleID = rule.getRuleID();
                        m = i18n.getString("RuleInfo.createdRule", "New Rule has been created");
                    }
                    catch (DBException dbe) {
                        Print.logException((String)"Creating Rule", (Throwable)dbe);
                        m = i18n.getString("RuleInfo.errorCreate", "Internal error creating Rule");
                        error = true;
                    }
                }
                listRules = true;
            }
            if (updateRule) {
                String sysRuleID = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_SYSRULE, (String)"");
                String ruleDesc = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_DESC, (String)"");
                String ruleActive = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_ACTIVE, (String)"");
                String ruleIsCron = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_ISCRON, (String)"");
                String ruleSel = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_SELECTOR, (String)"false");
                String ruleSubj = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_EMAIL_SUBJ, (String)"");
                String ruleText = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_EMAIL_TEXT, (String)"");
                String ruleSms = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_SMS_TEXT, (String)"");
                String cannedAct = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_CANNED_ACTIONS, (String)"");
                String emailWrap = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_EMAIL_WRAP, (String)"");
                String notifyEmail = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_EMAIL_ADDR, (String)"");
                String deviceID = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_DEVICE, (String)"");
                String groupID = RuleInfo.IncludeDeviceGroupRules() ? AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_GROUP, (String)"") : null;
                String statCode = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_RULE_STATUS_COD, (String)"");
                long minTrigTime = AttributeTools.getRequestLong((ServletRequest)request, (String)PARM_MIN_TRIGGER_TIME, (long)0L);
                int ruleMask = -1;
                if (showTriggerActions > 0) {
                    ruleMask = 0;
                    if (showTriggerActions == 1) {
                        boolean actEmail = AttributeTools.getRequestCheckbox((ServletRequest)request, (String)PARM_RULE_ACT_EMAIL);
                        if (actEmail) {
                            ruleMask |= 0x107;
                        }
                    } else {
                        boolean actEmail_A = AttributeTools.getRequestCheckbox((ServletRequest)request, (String)PARM_RULE_ACT_EMAIL_A);
                        boolean actEmail_D = AttributeTools.getRequestCheckbox((ServletRequest)request, (String)PARM_RULE_ACT_EMAIL_D);
                        boolean actEmail_R = AttributeTools.getRequestCheckbox((ServletRequest)request, (String)PARM_RULE_ACT_EMAIL_R);
                        if (actEmail_A) {
                            ruleMask |= 0x101;
                        }
                        if (actEmail_D) {
                            ruleMask |= 0x102;
                        }
                        if (actEmail_R) {
                            ruleMask |= 0x104;
                        }
                    }
                    boolean actQueue = AttributeTools.getRequestCheckbox((ServletRequest)request, (String)PARM_RULE_ACT_QUEUE);
                    boolean actListnr = AttributeTools.getRequestCheckbox((ServletRequest)request, (String)PARM_RULE_ACT_LISTENER);
                    boolean actSave = AttributeTools.getRequestCheckbox((ServletRequest)request, (String)PARM_RULE_ACT_SAVE);
                    if (actQueue) {
                        ruleMask |= 0x200;
                    }
                    if (actListnr) {
                        ruleMask |= 0x400;
                    }
                    if (actSave) {
                        ruleMask |= 0x10000;
                    }
                } else {
                    ruleMask = 0;
                }
                listRules = true;
                if (selRule != null) {
                    try {
                        if (!isSystemRuleID) {
                            boolean saveOK = true;
                            if (!StringTools.isBlank((String)sysRuleID)) {
                                try {
                                    String sysAdminID = Account.getSystemAdminAccountID();
                                    Rule sysRule = Rule.getRule((String)sysAdminID, (String)sysRuleID);
                                    if (sysRule != null) {
                                        ruleDesc = sysRule.getDescription();
                                        ruleActive = sysRule.getIsActive() ? "true" : "false";
                                        ruleIsCron = sysRule.getIsCronRule() ? StringTools.blankDefault((String)sysRule.getRuleTag(), (String)"true") : "false";
                                        ruleSel = "$SYSRULE(\"" + sysRule.getRuleID() + "\")";
                                        ruleSubj = sysRule.getEmailSubject();
                                        ruleText = sysRule.getEmailText();
                                        ruleSms = sysRule.getSmsText();
                                        ruleMask = sysRule.getActionMask();
                                        cannedAct = sysRule.getCannedActions();
                                        emailWrap = String.valueOf(sysRule.getUseEmailWrapper());
                                    }
                                }
                                catch (DBException dbe) {
                                    Print.logException((String)("Getting SysAdmin Rule: " + sysRuleID), (Throwable)dbe);
                                }
                            }
                            if (!StringTools.isBlank((String)ruleDesc)) {
                                selRule.setDescription(ruleDesc);
                            }
                            boolean ruleActv = ComboOption.parseYesNoText((Locale)locale, (String)ruleActive, (boolean)true);
                            if (selRule.getIsActive() != ruleActv) {
                                selRule.setIsActive(ruleActv);
                            }
                            if (!StringTools.isBlank((String)ruleIsCron)) {
                                if (ruleIsCron.equals("false") || ruleIsCron.equals("0")) {
                                    selRule.setIsCronRule(false);
                                    selRule.setRuleTag(null);
                                } else if (ruleIsCron.equals("true") || ruleIsCron.equals("1")) {
                                    selRule.setIsCronRule(true);
                                    selRule.setRuleTag(null);
                                } else {
                                    Print.logInfo((String)("CronRule? " + ruleIsCron), (Object[])new Object[0]);
                                    selRule.setIsCronRule(true);
                                    selRule.setRuleTag(ruleIsCron);
                                }
                            }
                            selRule.setSelector(StringTools.blankDefault((String)ruleSel, (String)"(false)"));
                            if (ruleMask >= 0) {
                                selRule.setActionMask(ruleMask);
                            }
                            selRule.setMinNotifyAge(minTrigTime);
                            if (showCannedActions > 0 && !selRule.getCannedActions().equals(cannedAct)) {
                                selRule.setCannedActions(cannedAct);
                            }
                            if (StringTools.isBlank((String)notifyEmail)) {
                                if (!selRule.getNotifyEmail().equals(notifyEmail)) {
                                    selRule.setNotifyEmail(notifyEmail);
                                }
                            } else if (EMail.validateAddresses((String)notifyEmail, (boolean)true)) {
                                if (!selRule.getNotifyEmail().equals(notifyEmail)) {
                                    selRule.setNotifyEmail(notifyEmail);
                                }
                            } else {
                                m = i18n.getString("RuleInfo.enterEMail", "Please enter a valid notification email/sms address");
                                saveOK = false;
                            }
                            if (StringTools.isBlank((String)ruleSubj) && privLabel.getEventNotificationDefault()) {
                                String s = StringTools.trim((String)privLabel.getEventNotificationSubject());
                                ruleSubj = StringTools.encodeNewline((String)s).replace('\"', '\'');
                            }
                            selRule.setEmailSubject(ruleSubj);
                            if (StringTools.isBlank((String)ruleText) && privLabel.getEventNotificationDefault()) {
                                String b = StringTools.trim((String)privLabel.getEventNotificationBody());
                                ruleText = StringTools.encodeNewline((String)b).replace('\"', '\'');
                            }
                            selRule.setEmailText(ruleText);
                            boolean wrapEmail = false;
                            wrapEmail = !StringTools.isBlank((String)emailWrap) ? ComboOption.parseYesNoText((Locale)locale, (String)emailWrap, (boolean)false) : false;
                            if (selRule.getUseEmailWrapper() != wrapEmail) {
                                selRule.setUseEmailWrapper(wrapEmail);
                            }
                            selRule.setSmsText(ruleSms);
                            if (saveOK) {
                                selRule.save();
                                selRule.clearRuleListEntries();
                                if (!StringTools.isBlank((String)statCode)) {
                                    int sc = StringTools.parseInt((String)statCode, (int)0);
                                    if (!StringTools.isBlank((String)deviceID) && !deviceID.equalsIgnoreCase("-")) {
                                        selRule.setSingleDeviceRuleListEntry(deviceID, sc);
                                    } else if (!StringTools.isBlank((String)groupID) && !groupID.equalsIgnoreCase("-")) {
                                        selRule.setSingleGroupRuleListEntry(groupID, sc);
                                    } else {
                                        selRule.setSingleDeviceRuleListEntry("-", sc);
                                    }
                                }
                                m = i18n.getString("RuleInfo.ruleUpdated", "Rule information updated");
                            } else {
                                editRule = true;
                            }
                            break block106;
                        }
                        RuleList.clearRuleListEntries((String)currAcctID, (String)selRuleID);
                        if (!StringTools.isBlank((String)statCode)) {
                            int sc = StringTools.parseInt((String)statCode, (int)0);
                            if (!StringTools.isBlank((String)deviceID) && !deviceID.equalsIgnoreCase("-")) {
                                RuleList.setSingleDeviceRuleListEntry((String)currAcctID, (String)selRuleID, (String)deviceID, (int)sc);
                            } else if (!StringTools.isBlank((String)groupID) && !groupID.equalsIgnoreCase("-")) {
                                RuleList.setSingleGroupRuleListEntry((String)currAcctID, (String)selRuleID, (String)groupID, (int)sc);
                            } else {
                                RuleList.setSingleDeviceRuleListEntry((String)currAcctID, (String)selRuleID, (String)"-", (int)sc);
                            }
                        }
                        m = i18n.getString("RuleInfo.ruleUpdated", "Rule information updated");
                    }
                    catch (Throwable t) {
                        Print.logException((String)"Error Updating Rule", (Throwable)t);
                        m = i18n.getString("RuleInfo.errorUpdate", "Internal error updating Rule");
                        error = true;
                    }
                } else {
                    m = i18n.getString("RuleInfo.noRules", "There are currently no defined Rules for this account.");
                }
            }
        }
        HTMLOutput HTML_CSS = new HTMLOutput(){

            public void write(PrintWriter out) throws IOException {
            }
        };
        HTMLOutput HTML_JS = new HTMLOutput(){

            public void write(PrintWriter out) throws IOException {
                MenuBar.writeJavaScript((PrintWriter)out, (String)pageName, (RequestProperties)reqState);
                JavaScriptTools.writeJSInclude((PrintWriter)out, (String)JavaScriptTools.qualifyJSFileRef((String)"sorttable/sorttable.js"), (HttpServletRequest)request);
                JavaScriptTools.writeStartJavaScript((PrintWriter)out);
                String sysRuleDef = i18n.getString("RuleInfo.sysRuleWillDefine", "(The System Rule will define this value)").replace('\"', '\'');
                String dftEmailSubj = "";
                String dftEmailBody = "";
                String dftSmsText = "";
                if (privLabel.getEventNotificationDefault()) {
                    dftEmailSubj = StringTools.encodeNewline((String)privLabel.getEventNotificationSubject()).replace('\"', '\'');
                    dftEmailBody = StringTools.encodeNewline((String)privLabel.getEventNotificationBody()).replace('\"', '\'');
                }
                out.write("// Onload \n");
                out.write("function ruleOnLoad() {\n");
                out.write("    ruleDeviceGroupChange();\n");
                out.write("}\n");
                out.write("// System rule changed\n");
                out.write("var DEFAULT_EMAIL_SUBJECT = \"" + dftEmailSubj + "\";\n");
                out.write("var DEFAULT_EMAIL_BODY    = \"" + dftEmailBody + "\";\n");
                out.write("var DEFAULT_SMS_TEXT      = \"" + dftSmsText + "\";\n");
                out.write("function ruleSysRuleChange() {\n");
                out.write("   var index = document.RuleInfoEdit.r_sysrule.selectedIndex;\n");
                out.write("   var value = document.RuleInfoEdit.r_sysrule.value;\n");
                out.write("   var title = document.RuleInfoEdit.r_sysrule.options[index].text;\n");
                out.write("   if (value != '') {\n");
                out.write("      document.RuleInfoEdit.r_active.disabled=true;\n");
                out.write("      document.RuleInfoEdit.r_desc.className='textReadOnly';\n");
                out.write("      document.RuleInfoEdit.r_desc.readOnly=true;\n");
                out.write("      document.RuleInfoEdit.r_desc.value=title;\n");
                out.write("      document.RuleInfoEdit.r_selector.className='textReadOnly';\n");
                out.write("      document.RuleInfoEdit.r_selector.readOnly=true;\n");
                out.write("      document.RuleInfoEdit.r_selector.value='$SYSRULE(\"' + value + '\")';\n");
                out.write("      document.RuleInfoEdit.r_subj.className='textReadOnly';\n");
                out.write("      document.RuleInfoEdit.r_subj.readOnly=true;\n");
                out.write("      document.RuleInfoEdit.r_subj.value=\"" + sysRuleDef + "\";\n");
                out.write("      document.RuleInfoEdit.r_text.className='textAreaReadOnly';\n");
                out.write("      document.RuleInfoEdit.r_text.readOnly=true;\n");
                out.write("      document.RuleInfoEdit.r_text.value=\"" + sysRuleDef + "\";\n");
                out.write("      document.RuleInfoEdit.r_sms.className='textAreaReadOnly';\n");
                out.write("      document.RuleInfoEdit.r_sms.readOnly=true;\n");
                out.write("      document.RuleInfoEdit.r_sms.value=\"" + sysRuleDef + "\";\n");
                if (showTriggerActions > 0) {
                    if (showTriggerActions == 1) {
                        out.write("      document.RuleInfoEdit.ra_email.disabled=true;\n");
                    } else {
                        out.write("      document.RuleInfoEdit.ra_emailA.disabled=true;\n");
                        out.write("      document.RuleInfoEdit.ra_emailD.disabled=true;\n");
                        out.write("      document.RuleInfoEdit.ra_emailR.disabled=true;\n");
                    }
                    out.write("      document.RuleInfoEdit.ra_lstnr.disabled=true;\n");
                    out.write("      document.RuleInfoEdit.ra_save.disabled=true;\n");
                    out.write("      document.RuleInfoEdit.ra_queue.disabled=true;\n");
                }
                if (showCannedActions > 0) {
                    out.write("      document.RuleInfoEdit.r_cra.className='textReadOnly';\n");
                    out.write("      document.RuleInfoEdit.r_cra.readOnly=true;\n");
                }
                out.write("      document.RuleInfoEdit.r_cron.disabled=true;\n");
                out.write("   } else {\n");
                out.write("      document.RuleInfoEdit.r_active.disabled=false;\n");
                out.write("      document.RuleInfoEdit.r_desc.className='textInput';\n");
                out.write("      document.RuleInfoEdit.r_desc.readOnly=false;\n");
                out.write("      document.RuleInfoEdit.r_desc.value='';\n");
                out.write("      document.RuleInfoEdit.r_selector.className='textInput';\n");
                out.write("      document.RuleInfoEdit.r_selector.readOnly=false;\n");
                out.write("      document.RuleInfoEdit.r_selector.value='';\n");
                out.write("      document.RuleInfoEdit.r_subj.className='textInput';\n");
                out.write("      document.RuleInfoEdit.r_subj.readOnly=false;\n");
                out.write("      document.RuleInfoEdit.r_subj.value=DEFAULT_EMAIL_SUBJECT;\n");
                out.write("      document.RuleInfoEdit.r_text.className='textAreaInput';\n");
                out.write("      document.RuleInfoEdit.r_text.readOnly=false;\n");
                out.write("      document.RuleInfoEdit.r_text.value=DEFAULT_EMAIL_BODY;\n");
                out.write("      document.RuleInfoEdit.r_sms.className='textAreaInput';\n");
                out.write("      document.RuleInfoEdit.r_sms.readOnly=false;\n");
                out.write("      document.RuleInfoEdit.r_sms.value=DEFAULT_SMS_TEXT;\n");
                if (showTriggerActions > 0) {
                    if (showTriggerActions == 1) {
                        out.write("      document.RuleInfoEdit.ra_email.disabled=false;\n");
                    } else {
                        out.write("      document.RuleInfoEdit.ra_emailA.disabled=false;\n");
                        out.write("      document.RuleInfoEdit.ra_emailD.disabled=false;\n");
                        out.write("      document.RuleInfoEdit.ra_emailR.disabled=false;\n");
                    }
                    out.write("      document.RuleInfoEdit.ra_lstnr.disabled=false;\n");
                    out.write("      document.RuleInfoEdit.ra_save.disabled=false;\n");
                    out.write("      document.RuleInfoEdit.ra_queue.disabled=false;\n");
                }
                if (showCannedActions > 0) {
                    out.write("      document.RuleInfoEdit.r_cra.className='textInput';\n");
                    out.write("      document.RuleInfoEdit.r_cra.readOnly=false;\n");
                }
                out.write("      document.RuleInfoEdit.r_cron.disabled=false;\n");
                out.write("   }\n");
                out.write("}\n");
                out.write("// Device/Group selection changed\n");
                out.write("function ruleDeviceGroupChange() {\n");
                out.write("   var devCB  = document.getElementById('r_devid');\n");
                out.write("   var grpCB  = document.getElementById('r_grpid');\n");
                out.write("   var devVal = devCB? devCB.value : null;\n");
                out.write("   var grpVal = grpCB? grpCB.value : null;\n");
                out.write("   if ((devVal != null) && (grpVal != null)) {\n");
                out.write("      if (devVal == '-') {\n");
                out.write("          grpCB.disabled = false\n");
                out.write("          if (grpVal == '-') {\n");
                out.write("             devCB.disabled = false;\n");
                out.write("          } else {\n");
                out.write("             devCB.disabled = true;\n");
                out.write("             devCB.value = '-';\n");
                out.write("             devVal = '-';\n");
                out.write("          }\n");
                out.write("      } else {\n");
                out.write("          devCB.disabled = false;\n");
                out.write("          grpCB.disabled = true;\n");
                out.write("          grpCB.value = '-';\n");
                out.write("          grpVal = '-';\n");
                out.write("      }\n");
                out.write("      var codCB = document.getElementById('r_code');\n");
                out.write("      if (codCB) {\n");
                out.write("         if ((devVal == '-') && (grpVal == '-')) {\n");
                out.write("             codCB.disabled = true;\n");
                out.write("             codCB.value = '0x0000';\n");
                out.write("         } else {\n");
                out.write("             codCB.disabled = false;\n");
                out.write("         }\n");
                out.write("      }\n");
                out.write("   }\n");
                out.write("}\n");
                JavaScriptTools.writeEndJavaScript((PrintWriter)out);
            }
        };
        String _selRuleID = selRuleID;
        Rule _selRule = selRule;
        Object[] _ruleList = ruleList;
        final boolean _allowEdit = allowEdit;
        boolean _allowView = allowView;
        boolean _allowNew = allowNew;
        boolean _allowDelete = allowDelete;
        boolean _editRule = _allowEdit && editRule && !isSystemRuleID;
        boolean _editStatSel = _allowEdit && editRule;
        boolean _viewRule = _editRule || viewRule;
        final boolean _listRules = listRules || !_editRule && !_viewRule;
        HTMLOutput HTML_CONTENT = new HTMLOutput(CommonServlet.CSS_CONTENT_FRAME, m, (String[])_ruleList, currAcct, _selRuleID, locale, _allowView, _allowDelete, _allowNew, currAcctID, _selRule, isSystemAcctID, _editRule, showSysRules, showCronRules, showTriggerActions, showCannedActions, showRuleList, devTitles, _editStatSel, grpTitles){
            final /* synthetic */ String[] val$_ruleList;
            final /* synthetic */ Account val$currAcct;
            final /* synthetic */ String val$_selRuleID;
            final /* synthetic */ Locale val$locale;
            final /* synthetic */ boolean val$_allowView;
            final /* synthetic */ boolean val$_allowDelete;
            final /* synthetic */ boolean val$_allowNew;
            final /* synthetic */ String val$currAcctID;
            final /* synthetic */ Rule val$_selRule;
            final /* synthetic */ boolean val$isSystemAcctID;
            final /* synthetic */ boolean val$_editRule;
            final /* synthetic */ int val$showSysRules;
            final /* synthetic */ boolean val$showCronRules;
            final /* synthetic */ int val$showTriggerActions;
            final /* synthetic */ int val$showCannedActions;
            final /* synthetic */ boolean val$showRuleList;
            final /* synthetic */ String[] val$devTitles;
            final /* synthetic */ boolean val$_editStatSel;
            final /* synthetic */ String[] val$grpTitles;
            {
                this.val$_ruleList = stringArray;
                this.val$currAcct = account;
                this.val$_selRuleID = string;
                this.val$locale = locale;
                this.val$_allowView = bl3;
                this.val$_allowDelete = bl4;
                this.val$_allowNew = bl5;
                this.val$currAcctID = string2;
                this.val$_selRule = rule;
                this.val$isSystemAcctID = bl6;
                this.val$_editRule = bl7;
                this.val$showSysRules = n;
                this.val$showCronRules = bl8;
                this.val$showTriggerActions = n2;
                this.val$showCannedActions = n3;
                this.val$showRuleList = bl9;
                this.val$devTitles = stringArray2;
                this.val$_editStatSel = bl10;
                this.val$grpTitles = stringArray3;
                super(x0, x1);
            }

            public void write(PrintWriter out) throws IOException {
                String pageName = RuleInfo.this.getPageName();
                String menuURL = privLabel.getWebPageURL(reqState, "menu.top");
                String editURL = RuleInfo.this.encodePageURL(reqState);
                String selectURL = RuleInfo.this.encodePageURL(reqState);
                String newURL = RuleInfo.this.encodePageURL(reqState);
                String frameTitle = _allowEdit ? i18n.getString("RuleInfo.viewEditRule", "View/Edit Rule Info") : i18n.getString("RuleInfo.viewRule", "View Rule Info");
                out.write("<span class='menuTitle'>" + frameTitle + "</span><br/>\n");
                out.write("<hr>\n");
                if (_listRules) {
                    out.write("<h1 class='adminSelectTitle'>" + i18n.getString("RuleInfo.selectRule", "Select a Rule") + ":</h1>\n");
                    out.write("<div style='margin-left:25px;'>\n");
                    out.write("<form name='RuleInfoSelect' method='post' action='" + selectURL + "' target='_self'>");
                    out.write("<input type='hidden' name='page_cmd' value='select'/>");
                    out.write("<table class='adminSelectTable_sortable' cellspacing=0 cellpadding=0 border=0>\n");
                    out.write(" <thead>\n");
                    out.write("  <tr class='adminTableHeaderRow'>\n");
                    out.write("   <th class='adminTableHeaderCol_nosort' nowrap>" + i18n.getString("RuleInfo.select", "Select") + "</th>\n");
                    out.write("   <th class='adminTableHeaderCol_sort' nowrap>" + i18n.getString("RuleInfo.ruleID", "Rule ID") + "</th>\n");
                    out.write("   <th class='adminTableHeaderCol_sort' nowrap>" + i18n.getString("RuleInfo.description", "Description") + "</th>\n");
                    out.write("   <th class='adminTableHeaderCol_sort' nowrap>" + i18n.getString("RuleInfo.selector", "Selector") + "</th>\n");
                    out.write("   <th class='adminTableHeaderCol_sort' nowrap>" + i18n.getString("RuleInfo.cron", "Cron\nRule") + "</th>\n");
                    out.write("   <th class='adminTableHeaderCol_sort' nowrap>" + i18n.getString("RuleInfo.active", "Active") + "</th>\n");
                    out.write("  </tr>\n");
                    out.write(" </thead>\n");
                    out.write(" <tbody>\n");
                    for (int u = 0; u < this.val$_ruleList.length; ++u) {
                        if ((u & 1) == 0) {
                            out.write("  <tr class='adminTableBodyRowOdd'>\n");
                        } else {
                            out.write("  <tr class='adminTableBodyRowEven'>\n");
                        }
                        try {
                            Rule rule = Rule.getRule((Account)this.val$currAcct, (String)this.val$_ruleList[u]);
                            if (rule != null) {
                                rule.setSystemRuleSettings();
                                String checked = this.val$_selRuleID.equalsIgnoreCase(rule.getRuleID()) ? " checked" : "";
                                String ruleID = rule.getRuleID();
                                String ruleDesc = RuleInfo.this.filter(rule.getDescription());
                                String rsel = rule.getSelector();
                                String ruleSel = RuleInfo.this.filter(rsel.length() > 40 ? rsel.substring(0, 40) + " ..." : rsel);
                                String ruleActv = RuleInfo.this.filter(ComboOption.getYesNoText((Locale)this.val$locale, (boolean)rule.getIsActive()));
                                String ruleTag = rule.getRuleTag();
                                String ruleCron = !rule.getIsCronRule() ? RuleInfo.this.filter("--") : (StringTools.isBlank((String)ruleTag) ? RuleInfo.this.filter(ComboOption.getYesNoText((Locale)this.val$locale, (boolean)true)) : RuleInfo.this.filter(RuleInfo.this.getRuleTagDescription(privLabel, this.val$locale, ruleTag)));
                                String ruleSelStyle = "";
                                if (!Device.CheckSelectorSyntax((String)rsel)) {
                                    ruleSelStyle = " style='color:red;'";
                                }
                                out.write("   <td class='adminTableBodyCol' sorttable_customkey='" + u + "'><input type='radio' name='" + RuleInfo.PARM_RULE_SELECT + "' id='" + ruleID + "' value='" + ruleID + "' " + checked + "></td>\n");
                                out.write("   <td class='adminTableBodyCol' nowrap><label for='" + ruleID + "'>" + ruleID + "</label></td>\n");
                                out.write("   <td class='adminTableBodyCol' nowrap>" + ruleDesc + "</td>\n");
                                out.write("   <td class='adminTableBodyCol' nowrap align='left' " + ruleSelStyle + ">" + ruleSel + "</td>\n");
                                out.write("   <td class='adminTableBodyCol' nowrap align='center'>" + ruleCron + "</td>\n");
                                out.write("   <td class='adminTableBodyCol' nowrap align='center'>" + ruleActv + "</td>\n");
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                        out.write("  </tr>\n");
                    }
                    out.write(" </tbody>\n");
                    out.write("</table>\n");
                    out.write("<table cellpadding='0' cellspacing='0' border='0' style='width:95%; margin-top:5px; margin-left:5px; margin-bottom:5px;'>\n");
                    out.write("<tr>\n");
                    if (this.val$_allowView) {
                        out.write("<td style='padding-left:5px;'>");
                        out.write("<input type='submit' name='r_subview' value='" + i18n.getString("RuleInfo.view", "View") + "'>");
                        out.write("</td>\n");
                    }
                    if (_allowEdit) {
                        out.write("<td style='padding-left:5px;'>");
                        out.write("<input type='submit' name='r_subedit' value='" + i18n.getString("RuleInfo.edit", "Edit") + "'>");
                        out.write("</td>\n");
                    }
                    out.write("<td style='width:100%; text-align:right; padding-right:10px;'>");
                    if (this.val$_allowDelete) {
                        out.write("<input type='submit' name='r_subdel' value='" + i18n.getString("RuleInfo.delete", "Delete") + "' " + RuleInfo.Onclick_ConfirmDelete((Locale)this.val$locale) + ">");
                    } else {
                        out.write("&nbsp;");
                    }
                    out.write("</td>\n");
                    out.write("</tr>\n");
                    out.write("</table>\n");
                    out.write("</form>\n");
                    out.write("</div>\n");
                    out.write("<hr>\n");
                    if (this.val$_allowNew) {
                        out.write("<h1 class='adminSelectTitle'>" + i18n.getString("RuleInfo.createNewRule", "Create a new Rule") + ":</h1>\n");
                        out.write("<div style='margin-top:5px; margin-left:5px; margin-bottom:5px;'>\n");
                        out.write("<form name='RuleInfoNew' method='post' action='" + newURL + "' target='_self'>");
                        out.write(" <input type='hidden' name='page_cmd' value='new'/>");
                        out.write(i18n.getString("RuleInfo.ruleID", "Rule ID") + ": <input type='text' class='" + "textInput" + "' name='" + RuleInfo.PARM_NEW_RULE + "' value='' size='32' maxlength='32'><br>\n");
                        out.write(" <input type='submit' name='r_subnew' value='" + i18n.getString("RuleInfo.new", "New") + "' style='margin-top:5px; margin-left:10px;'>\n");
                        out.write("</form>\n");
                        out.write("</div>\n");
                        out.write("<hr>\n");
                    }
                } else {
                    String craSel;
                    boolean isCronRule;
                    boolean _editSel;
                    boolean showUseWrapper;
                    String emailText;
                    int codeSelInt;
                    String grpSel;
                    String devSel;
                    ComboMap codeMap;
                    block53: {
                        out.write("<form name='RuleInfoEdit' method='post' action='" + editURL + "' target='_self'>\n");
                        out.write("  <input type='hidden' name='page_cmd' value='update'/>\n");
                        codeMap = RuleInfo.this.getStatusCodeComboMap(privLabel, this.val$locale, this.val$currAcctID);
                        devSel = "*";
                        grpSel = "-";
                        codeSelInt = 0;
                        if (RuleInfo.IncludeDeviceSelection() || RuleInfo.IncludeDeviceGroupRules()) {
                            try {
                                Collection ruleList = RuleList.getRuleList((String)this.val$currAcctID, (String)this.val$_selRuleID, (long)1L);
                                if (!ListTools.isEmpty((Collection)ruleList)) {
                                    RuleList ruleListItem0 = (RuleList)ListTools.itemAt((Collection)ruleList, (int)0, null);
                                    devSel = ruleListItem0.getDeviceID();
                                    grpSel = ruleListItem0.getGroupID();
                                    codeSelInt = ruleListItem0.getStatusCode();
                                    if (StringTools.isBlank((String)devSel)) {
                                        devSel = "-";
                                    }
                                    if (StringTools.isBlank((String)grpSel)) {
                                        grpSel = "-";
                                    }
                                    if (!devSel.equals("-") && !grpSel.equals("-")) {
                                        Print.logWarn((String)"Neither deviceID/groupID are NO_DEVICES/NO_GROUPS", (Object[])new Object[0]);
                                        grpSel = "-";
                                    }
                                    break block53;
                                }
                                devSel = "-";
                                grpSel = "-";
                            }
                            catch (DBException dbe) {
                                Print.logException((String)("Getting RuleList for Rule " + this.val$_selRule), (Throwable)dbe);
                            }
                        } else {
                            try {
                                int[] codes = RuleList.getStatusCodesForDeviceID((Rule)this.val$_selRule, (String)"*", (boolean)false);
                                codeSelInt = !ListTools.isEmpty((int[])codes) ? codes[0] : 0;
                            }
                            catch (DBException dbe) {
                                Print.logException((String)("Getting StatusCodes for Rule " + this.val$_selRule), (Throwable)dbe);
                            }
                        }
                    }
                    String codeSel = "0x" + StringTools.toHexString((long)codeSelInt, (int)16);
                    String emailSubj = this.val$_selRule != null ? this.val$_selRule.getEmailSubject() : "";
                    String string = emailText = this.val$_selRule != null ? this.val$_selRule.getEmailText() : "";
                    if (!privLabel.hasEventNotificationEMail()) {
                        showUseWrapper = false;
                    } else if (privLabel.getEventNotificationDefault()) {
                        showUseWrapper = false;
                        if (StringTools.isBlank((String)emailSubj)) {
                            emailSubj = privLabel.getEventNotificationSubject();
                        }
                        if (StringTools.isBlank((String)emailText)) {
                            emailText = privLabel.getEventNotificationBody();
                        }
                    } else {
                        showUseWrapper = privLabel.getBooleanProperty("ruleInfo.showEMailWrapper", false);
                    }
                    String smsText = this.val$_selRule != null ? this.val$_selRule.getSmsText() : "";
                    String ruleID = this.val$_selRuleID;
                    String ruleDesc = this.val$_selRule != null ? this.val$_selRule.getDescription() : "";
                    String ruleSelector = this.val$_selRule != null ? this.val$_selRule.getSelector() : "";
                    String ntfyEmail = this.val$_selRule != null ? this.val$_selRule.getNotifyEmail() : "";
                    String emailTextNL = StringTools.decodeNewline((String)emailText);
                    int emailBodyRows = 12;
                    String smsTextNL = StringTools.decodeNewline((String)smsText);
                    int smsTextRows = 3;
                    out.println("<table class='adminViewTable' cellspacing='0' callpadding='0' border='0'>");
                    out.println(WebPageAdaptor.FormRow_TextField((String)RuleInfo.PARM_RULE_SELECT, (boolean)false, (String)(i18n.getString("RuleInfo.ruleID", "Rule ID") + ":"), (String)ruleID, (int)20, (int)32));
                    if (!this.val$isSystemAcctID) {
                        out.println(WebPageAdaptor.FormRow_TextField((String)RuleInfo.PARM_RULE_EMAIL_ADDR, (boolean)this.val$_editRule, (String)(i18n.getString("RuleInfo.notifyAddress", "Notification EMail") + ":"), (String)ntfyEmail, (int)95, (int)125));
                    }
                    boolean bl = _editSel = this.val$_editRule && this.val$showSysRules != 1;
                    if (this.val$showSysRules > 0) {
                        Map ruleIDMap = null;
                        try {
                            ruleIDMap = Rule.getSystemAdminRuleIDMap((boolean)this.val$showCronRules);
                        }
                        catch (DBException dbe) {
                            Print.logException((String)"Getting RuleID/Description Map", (Throwable)dbe);
                            ruleIDMap = null;
                        }
                        if (!ListTools.isEmpty((Map)ruleIDMap)) {
                            String sysRuleID = StringTools.trim((String)Rule.GetSysRuleIDFromSelector((String)ruleSelector));
                            if (_editSel && !StringTools.isBlank((String)sysRuleID)) {
                                _editSel = false;
                            }
                            ComboMap sysRuleList = new ComboMap(ruleIDMap);
                            sysRuleList.insert("", i18n.getString("RuleInfo.noSysRule", "n/a"));
                            out.println(WebPageAdaptor.FormRow_ComboBox((String)RuleInfo.PARM_RULE_SYSRULE, (boolean)this.val$_editRule, (String)(i18n.getString("RuleInfo.systemRule", "System Rule") + ":"), (String)sysRuleID, (ComboMap)sysRuleList, (String)"javascript:ruleSysRuleChange()", (int)50));
                        }
                    }
                    ComboOption ruleActive = ComboOption.getYesNoOption((Locale)this.val$locale, (this.val$_selRule != null && this.val$_selRule.isActive() ? 1 : 0) != 0);
                    out.println(WebPageAdaptor.FormRow_ComboBox((String)RuleInfo.PARM_RULE_ACTIVE, (boolean)_editSel, (String)(i18n.getString("RuleInfo.active", "Active") + ":"), (ComboOption)ruleActive, (ComboMap)ComboMap.getYesNoMap((Locale)this.val$locale), (String)"", (int)-1));
                    boolean bl2 = isCronRule = this.val$_selRule != null && this.val$_selRule.getIsCronRule();
                    if (this.val$showCronRules || isCronRule) {
                        String ruleTag = this.val$_selRule != null ? this.val$_selRule.getRuleTag() : null;
                        ComboMap ruleCronMap = RuleInfo.this.getRuleTagComboMap(privLabel, this.val$locale, isCronRule, ruleTag);
                        ComboOption ruleCronOpt = ruleCronMap.getDefaultSelection();
                        out.println(WebPageAdaptor.FormRow_ComboBox((String)RuleInfo.PARM_RULE_ISCRON, (boolean)_editSel, (String)(i18n.getString("RuleInfo.isCronRule", "Cron Rule") + ":"), (ComboOption)ruleCronOpt, (ComboMap)ruleCronMap, (String)"", (int)-1, (String)i18n.getString("RuleInfo.usedForPeriodicRuleTriggering", "(Used for periodic Rule triggering)")));
                    }
                    out.println(WebPageAdaptor.FormRow_TextField((String)RuleInfo.PARM_RULE_DESC, (boolean)_editSel, (String)(i18n.getString("RuleInfo.description", "Description") + ":"), (String)ruleDesc, (int)50, (int)80));
                    out.println(WebPageAdaptor.FormRow_Separator());
                    out.println(WebPageAdaptor.FormRow_TextField((String)RuleInfo.PARM_RULE_SELECTOR, (boolean)_editSel, (String)(i18n.getString("RuleInfo.ruleSelector", "Rule Selector") + ":"), (String)ruleSelector, (int)95, (int)500));
                    if (this.val$showTriggerActions > 0) {
                        int ruleMask = this.val$_selRule != null ? this.val$_selRule.getActionMask() : 0;
                        boolean actEmail = (ruleMask & 0x100) != 0;
                        boolean actEmail_A = (ruleMask & 1) != 0 && actEmail;
                        boolean actEmail_D = (ruleMask & 2) != 0 && actEmail;
                        boolean actEmail_R = (ruleMask & 4) != 0 && actEmail;
                        boolean actQueue = (ruleMask & 0x200) != 0;
                        boolean actListener = (ruleMask & 0x400) != 0;
                        boolean actSave = (ruleMask & 0x10000) != 0;
                        out.print("<tr>");
                        out.print("<td class='adminViewTableHeader' nowrap>" + i18n.getString("RuleInfo.triggerAction", "Trigger Action") + ":</td>");
                        out.print("<td class='adminViewTableData'>");
                        if (this.val$showTriggerActions == 1) {
                            out.print(" &nbsp;&nbsp;" + i18n.getString("RuleInfo.actionEmail", "EMail:") + " ");
                            out.print(WebPageAdaptor.Form_CheckBox((String)RuleInfo.PARM_RULE_ACT_EMAIL, (String)RuleInfo.PARM_RULE_ACT_EMAIL, (boolean)_editSel, (boolean)actEmail, null, null));
                        } else {
                            out.print(" &nbsp;&nbsp;" + i18n.getString("RuleInfo.actionEmail", "EMail:") + "[");
                            out.print(i18n.getString("RuleInfo.actionEmailAccount", "Account:"));
                            out.print(WebPageAdaptor.Form_CheckBox((String)RuleInfo.PARM_RULE_ACT_EMAIL_A, (String)RuleInfo.PARM_RULE_ACT_EMAIL_A, (boolean)_editSel, (boolean)actEmail_A, null, null));
                            out.print("&nbsp;");
                            out.print(i18n.getString("RuleInfo.actionEmailDevice", "Device:"));
                            out.print(WebPageAdaptor.Form_CheckBox((String)RuleInfo.PARM_RULE_ACT_EMAIL_D, (String)RuleInfo.PARM_RULE_ACT_EMAIL_D, (boolean)_editSel, (boolean)actEmail_D, null, null));
                            out.print("&nbsp;");
                            out.print(i18n.getString("RuleInfo.actionEmailRule", "Rule:"));
                            out.print(WebPageAdaptor.Form_CheckBox((String)RuleInfo.PARM_RULE_ACT_EMAIL_R, (String)RuleInfo.PARM_RULE_ACT_EMAIL_R, (boolean)_editSel, (boolean)actEmail_R, null, null));
                            out.print("&nbsp;");
                            out.print("]");
                        }
                        out.print(" &nbsp;&nbsp;" + i18n.getString("RuleInfo.actionAlert", "Save/Alert:") + " ");
                        out.print(WebPageAdaptor.Form_CheckBox((String)RuleInfo.PARM_RULE_ACT_SAVE, (String)RuleInfo.PARM_RULE_ACT_SAVE, (boolean)_editSel, (boolean)actSave, null, null));
                        out.print(" &nbsp;&nbsp;" + i18n.getString("RuleInfo.actionQueue", "Queue:") + " ");
                        out.print(WebPageAdaptor.Form_CheckBox((String)RuleInfo.PARM_RULE_ACT_QUEUE, (String)RuleInfo.PARM_RULE_ACT_QUEUE, (boolean)_editSel, (boolean)actQueue, null, null));
                        out.print(" &nbsp;&nbsp;" + i18n.getString("RuleInfo.actionListener", "Listener:") + " ");
                        out.print(WebPageAdaptor.Form_CheckBox((String)RuleInfo.PARM_RULE_ACT_LISTENER, (String)RuleInfo.PARM_RULE_ACT_LISTENER, (boolean)_editSel, (boolean)actListener, null, null));
                        out.print("</td>");
                        out.print("</tr>\n");
                    }
                    String minTrigStr = String.valueOf(this.val$_selRule != null ? this.val$_selRule.getMinNotifyAge() : 0L);
                    out.println(WebPageAdaptor.FormRow_TextField((String)RuleInfo.PARM_MIN_TRIGGER_TIME, (boolean)_editSel, (String)(i18n.getString("RuleInfo.minTriggerInterval", "Minimum Interval") + ":"), (String)minTrigStr, (int)10, (int)10, (String)i18n.getString("RuleInfo.triggerSeconds", "(seconds)")));
                    if (this.val$showCannedActions == 1) {
                        craSel = this.val$_selRule != null ? this.val$_selRule.getCannedActions() : "";
                        ComboMap craMap = new ComboMap();
                        craMap.insert("", i18n.getString("RuleInfo.craNone", "None"));
                        craMap.insert("resetMaint:0", i18n.getString("RuleInfo.craResetMaint0", "Reset Maintenance #0"));
                        craMap.insert("resetMaint:1", i18n.getString("RuleInfo.craResetMaint1", "Reset Maintenance #1"));
                        craMap.insert("resetPingCount", i18n.getString("RuleInfo.craResetPingCount", "Reset Device Locates"));
                        craMap.insert("sendCommand:OutputOn", i18n.getString("RuleInfo.craSendOutputOn", "Send Output On"));
                        craMap.insert("sendCommand:OutputOff", i18n.getString("RuleInfo.craSendOutputOff", "Send Output Off"));
                        out.println(WebPageAdaptor.FormRow_ComboBox((String)RuleInfo.PARM_CANNED_ACTIONS, (boolean)_editSel, (String)(i18n.getString("RuleInfo.cannedActions", "Prefedined Actions") + ":"), (String)craSel, (ComboMap)craMap, (String)"", (int)-1));
                    } else if (this.val$showCannedActions == 2) {
                        craSel = this.val$_selRule != null ? this.val$_selRule.getCannedActions() : "";
                        out.println(WebPageAdaptor.FormRow_TextField((String)RuleInfo.PARM_CANNED_ACTIONS, (boolean)_editSel, (String)(i18n.getString("RuleInfo.cannedActions", "Prefedined Actions") + ":"), (String)craSel, (int)80, (int)80));
                    }
                    out.println(WebPageAdaptor.FormRow_Separator());
                    out.println(WebPageAdaptor.FormRow_TextField((String)RuleInfo.PARM_RULE_EMAIL_SUBJ, (boolean)_editSel, (String)(i18n.getString("RuleInfo.emailSubject", "EMail Subject") + ":"), (String)emailSubj, (int)60, (int)100));
                    out.println(WebPageAdaptor.FormRow_TextArea((String)RuleInfo.PARM_RULE_EMAIL_TEXT, (boolean)_editSel, (String)(i18n.getString("RuleInfo.emailMessage", "EMail Message") + ":"), (String)emailTextNL, (int)emailBodyRows, (int)70));
                    if (showUseWrapper) {
                        ComboOption wrapEmail = ComboOption.getYesNoOption((Locale)this.val$locale, (this.val$_selRule != null && this.val$_selRule.getUseEmailWrapper() ? 1 : 0) != 0);
                        out.println(WebPageAdaptor.FormRow_ComboBox((String)RuleInfo.PARM_RULE_EMAIL_WRAP, (boolean)_editSel, (String)(i18n.getString("RuleInfo.emailWrapper", "Use EMail Wrapper") + ":"), (ComboOption)wrapEmail, (ComboMap)ComboMap.getYesNoMap((Locale)this.val$locale), (String)"", (int)-1, (String)i18n.getString("RuleInfo.seeEventNotificationEMail", "(See 'EventNotificationEMail' tag in 'private.xml')")));
                    }
                    out.println(WebPageAdaptor.FormRow_TextArea((String)RuleInfo.PARM_RULE_SMS_TEXT, (boolean)_editSel, (String)(i18n.getString("RuleInfo.smsMessage", "SMS Message") + ":"), (String)smsTextNL, (int)smsTextRows, (int)80));
                    out.println("</table>");
                    if (this.val$showRuleList) {
                        String rlTitle = i18n.getString("RuleInfo.deviceStatusCodeSelection", "{0}/StatusCode Selection", (Object[])this.val$devTitles) + ": ";
                        if (this.val$isSystemAcctID) {
                            rlTitle = rlTitle + i18n.getString("RuleInfo.localAccountOnly", "(applicable to local account only)");
                        }
                        out.write("<hr style='margin: 5px 0px 5px 0px;'>\n");
                        out.write("<span class='menuTitle'>" + rlTitle + "</span>\n");
                        out.println("<table class='adminViewTable' cellspacing='0' callpadding='0' border='0'>");
                        if (RuleInfo.IncludeDeviceSelection() && !RuleInfo.IncludeDeviceGroupRules()) {
                            ComboMap devMap = new ComboMap((Map)reqState.createDeviceDescriptionMap(true));
                            devMap.insert("*", i18n.getString("RuleInfo.allDevices", "All {1}", (Object[])this.val$devTitles));
                            devMap.insert("-", i18n.getString("RuleInfo.noDevices", "No {1}", (Object[])this.val$devTitles));
                            out.println(WebPageAdaptor.FormRow_ComboBox((String)RuleInfo.PARM_RULE_DEVICE, (boolean)this.val$_editStatSel, (String)(i18n.getString("RuleInfo.deviceID", "{0} ID", (Object[])this.val$devTitles) + ":"), (String)devSel, (ComboMap)devMap, (String)"", (int)-1));
                        } else if (!RuleInfo.IncludeDeviceSelection() && RuleInfo.IncludeDeviceGroupRules()) {
                            ComboMap grpMap = new ComboMap((Map)reqState.createGroupDescriptionMap(true, true));
                            grpMap.insert("*", i18n.getString("RuleInfo.allGroups", "All {1}", (Object[])this.val$grpTitles));
                            grpMap.insert("-", i18n.getString("RuleInfo.noGroups", "No {1}", (Object[])this.val$grpTitles));
                            out.println(WebPageAdaptor.FormRow_ComboBox((String)RuleInfo.PARM_RULE_GROUP, (boolean)this.val$_editStatSel, (String)(i18n.getString("RuleInfo.groupID", "{0} ID", (Object[])this.val$grpTitles) + ":"), (String)grpSel, (ComboMap)grpMap, (String)"", (int)-1));
                        } else if (RuleInfo.IncludeDeviceSelection() && RuleInfo.IncludeDeviceGroupRules()) {
                            String onchange = "javascript:ruleDeviceGroupChange()";
                            ComboMap devMap = new ComboMap((Map)reqState.createDeviceDescriptionMap(true));
                            devMap.insert("*", i18n.getString("RuleInfo.allDevices", "All {1}", (Object[])this.val$devTitles));
                            devMap.insert("-", i18n.getString("RuleInfo.noDevicesSel", "No {1} (select by {2})", (Object)this.val$devTitles[0], (Object)this.val$devTitles[1], (Object)this.val$grpTitles[0], (Object)this.val$grpTitles[1]));
                            out.println(WebPageAdaptor.FormRow_ComboBox((String)RuleInfo.PARM_RULE_DEVICE, (String)RuleInfo.PARM_RULE_DEVICE, (boolean)this.val$_editStatSel, (String)(i18n.getString("RuleInfo.byDeviceID", "By {0} ID", (Object[])this.val$devTitles) + ":"), (String)devSel, (ComboMap)devMap, (String)onchange, (int)-1, (String)""));
                            ComboMap grpMap = new ComboMap((Map)reqState.createGroupDescriptionMap(true, true));
                            grpMap.insert("*", i18n.getString("RuleInfo.allGroups", "All {1}", (Object[])this.val$grpTitles));
                            grpMap.insert("-", i18n.getString("RuleInfo.noGroupsSel", "No {1} (select by {2}}", (Object)this.val$grpTitles[0], (Object)this.val$grpTitles[1], (Object)this.val$devTitles[0], (Object)this.val$devTitles[1]));
                            out.println(WebPageAdaptor.FormRow_ComboBox((String)RuleInfo.PARM_RULE_GROUP, (String)RuleInfo.PARM_RULE_GROUP, (boolean)this.val$_editStatSel, (String)(i18n.getString("RuleInfo.byGroupID", "By {0} ID", (Object[])this.val$grpTitles) + ":"), (String)grpSel, (ComboMap)grpMap, (String)onchange, (int)-1, (String)""));
                        }
                        out.println(WebPageAdaptor.FormRow_ComboBox((String)RuleInfo.PARM_RULE_STATUS_COD, (String)RuleInfo.PARM_RULE_STATUS_COD, (boolean)this.val$_editStatSel, (String)(i18n.getString("RuleInfo.statusCode", "Status Code") + ":"), (String)codeSel, (ComboMap)codeMap, (String)"", (int)-1, (String)""));
                        out.println("</table>");
                        out.println("<span style='padding-bottom:5px'>&nbsp;</span>");
                    }
                    out.write("<hr style='margin-bottom:5px;'>\n");
                    out.write("<span style='padding-left:10px'>&nbsp;</span>\n");
                    if (this.val$_editStatSel) {
                        out.write("<input type='submit' name='r_subchg' value='" + i18n.getString("RuleInfo.change", "Change") + "'>\n");
                        out.write("<span style='padding-left:10px'>&nbsp;</span>\n");
                        out.write("<input type='button' name='r_btncan' value='" + i18n.getString("RuleInfo.cancel", "Cancel") + "' onclick=\"javascript:openURL('" + editURL + "','_top');\">\n");
                    } else {
                        out.write("<input type='button' name='r_btnbak' value='" + i18n.getString("RuleInfo.back", "Back") + "' onclick=\"javascript:openURL('" + editURL + "','_top');\">\n");
                    }
                    out.write("</form>\n");
                }
            }
        };
        String ruleOnLoad = "javascript:ruleOnLoad();";
        String onload = error && !StringTools.isBlank((String)m) ? ruleOnLoad + RuleInfo.JS_alert((boolean)false, (String)m) : ruleOnLoad;
        CommonServlet.writePageFrame((RequestProperties)reqState, (String)onload, null, (HTMLOutput)HTML_CSS, (HTMLOutput)HTML_JS, null, (HTMLOutput)HTML_CONTENT);
    }
}

