/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rulewar.track.page;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Geozone;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.geocoder.GeocodeProvider;
import org.opengts.rule.tables.GeoCorridor;
import org.opengts.util.ColorTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;
import org.opengts.war.tools.AttributeTools;
import org.opengts.war.tools.CommonServlet;
import org.opengts.war.tools.HTMLOutput;
import org.opengts.war.tools.JavaScriptTools;
import org.opengts.war.tools.MapDimension;
import org.opengts.war.tools.MapProvider;
import org.opengts.war.tools.MapProviderAdapter;
import org.opengts.war.tools.MenuBar;
import org.opengts.war.tools.PrivateLabel;
import org.opengts.war.tools.RequestProperties;
import org.opengts.war.tools.WebPageAdaptor;
import org.opengts.war.track.Constants;

public class CorridorInfo
extends WebPageAdaptor
implements Constants {
    private static final String[] CONTROLS_ON_LEFT = new String[]{"left", "true"};
    private static final double MIN_RADIUS_METERS = 5.0;
    private static final double MAX_RADIUS_METERS = 3000.0;
    private static final double DEFAULT_ZONE_RADIUS = 20000.0;
    public static final String CSS_LATLON_INPUT = "latlonInput";
    public static final String FORM_ZONE_SELECT = "CorridorInfoSelect";
    public static final String FORM_ZONE_EDIT = "CorridorInfoEdit";
    public static final String FORM_ZONE_NEW = "CorridorInfoNew";
    public static final String COMMAND_INFO_UPDATE = "update";
    public static final String COMMAND_INFO_SELECT = "select";
    public static final String COMMAND_INFO_NEW = "new";
    public static final String PARM_SUBMIT_EDIT = "z_subedit";
    public static final String PARM_SUBMIT_VIEW = "z_subview";
    public static final String PARM_SUBMIT_CHG = "z_subchg";
    public static final String PARM_SUBMIT_DEL = "z_subdel";
    public static final String PARM_SUBMIT_NEW = "z_subnew";
    public static final String PARM_BUTTON_CANCEL = "u_btncan";
    public static final String PARM_BUTTON_BACK = "u_btnbak";
    public static final String PARM_NEW_ID = "z_newid";
    public static final String PARM_ZONE_SELECT = "z_zone";
    public static final String PARM_ZONE_DESC = "z_desc";
    public static final String PARM_ZONE_RADIUS = "z_radius";
    public static final String PARM_ZONE_INDEX = "z_index";
    private static final int CORRIDOR_POINT_COUNT = 15;
    public static final String PARM_ZONE_LATITUDE_ = "z_lat";
    public static final String PARM_ZONE_LONGITUDE_ = "z_lon";
    private static final int DEFAULT_POINT_INDEX = 0;

    private static String PARM_ZONE_LATITUDE(int ndx) {
        return PARM_ZONE_LATITUDE_ + ndx;
    }

    public static final String PARM_ZONE_LONGITUDE(int ndx) {
        return PARM_ZONE_LONGITUDE_ + ndx;
    }

    public CorridorInfo() {
        this.setBaseURI(RequestProperties.TRACK_BASE_URI());
        this.setPageName("corridor.info");
        this.setPageNavigation(new String[]{"login", "menu.top"});
        this.setLoginRequired(true);
    }

    public boolean getIsEnabled() {
        boolean hasRule = DBConfig.hasRulePackage();
        if (!hasRule) {
            Print.logWarn((String)"CorridorInfo present, but Rules Engine not found", (Object[])new Object[0]);
        }
        return hasRule;
    }

    public String getMenuName(RequestProperties reqState) {
        return "menu.admin";
    }

    public String getMenuDescription(RequestProperties reqState, String parentMenuName) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(CorridorInfo.class);
        return super._getMenuDescription(reqState, i18n.getString("CorridorInfo.editMenuDesc", "View/Edit GeoCorridor Information"));
    }

    public String getMenuHelp(RequestProperties reqState, String parentMenuName) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(CorridorInfo.class);
        return super._getMenuHelp(reqState, i18n.getString("CorridorInfo.editMenuHelp", "View and Edit GeoCorridor information"));
    }

    public String getNavigationDescription(RequestProperties reqState) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(CorridorInfo.class);
        return super._getNavigationDescription(reqState, i18n.getString("CorridorInfo.navDesc", "GeoCorridor"));
    }

    public String getNavigationTab(RequestProperties reqState) {
        PrivateLabel privLabel = reqState.getPrivateLabel();
        I18N i18n = privLabel.getI18N(CorridorInfo.class);
        return super._getNavigationTab(reqState, i18n.getString("CorridorInfo.navTab", "GeoCorridor Admin"));
    }

    private static List<GeoPoint> GetCorridorPoints(GeoCorridor corr) {
        List gpList = null;
        try {
            gpList = corr != null ? corr.getGeoPoints() : null;
        }
        catch (DBException dbe) {
            gpList = null;
        }
        return gpList != null ? gpList : new Vector();
    }

    public void writePage(final RequestProperties reqState, String pageMsg) throws IOException {
        boolean allowNew;
        final HttpServletRequest request = reqState.getHttpServletRequest();
        final PrivateLabel privLabel = reqState.getPrivateLabel();
        final I18N i18n = privLabel.getI18N(CorridorInfo.class);
        final Locale locale = reqState.getLocale();
        final Account currAcct = reqState.getCurrentAccount();
        User currUser = reqState.getCurrentUser();
        final String pageName = this.getPageName();
        String m = pageMsg;
        boolean error = false;
        String[] zoneList = null;
        try {
            zoneList = GeoCorridor.getCorridorIDsForAccount((String)currAcct.getAccountID());
        }
        catch (DBException dbe) {
            zoneList = new String[]{};
        }
        String selZoneID = AttributeTools.getRequestString((ServletRequest)reqState.getHttpServletRequest(), (String)PARM_ZONE_SELECT, (String)"");
        if (StringTools.isBlank((String)selZoneID)) {
            selZoneID = zoneList.length > 0 && zoneList[0] != null ? zoneList[0] : "";
        }
        if (zoneList.length == 0) {
            zoneList = new String[]{selZoneID};
        }
        GeoCorridor selZone = null;
        try {
            selZone = !selZoneID.equals("") ? GeoCorridor.getGeoCorridor((Account)currAcct, (String)selZoneID, (boolean)false) : null;
        }
        catch (DBException dbe) {
            // empty catch block
        }
        boolean allowDelete = allowNew = privLabel.hasAllAccess(currUser, this.getAclName());
        boolean allowEdit = allowNew || privLabel.hasWriteAccess(currUser, this.getAclName());
        boolean allowView = allowEdit || privLabel.hasReadAccess(currUser, this.getAclName());
        String zoneCmd = reqState.getCommandName();
        boolean listZones = false;
        boolean updateZone = zoneCmd.equals(COMMAND_INFO_UPDATE);
        boolean selectZone = zoneCmd.equals(COMMAND_INFO_SELECT);
        boolean newZone = zoneCmd.equals(COMMAND_INFO_NEW);
        boolean deleteZone = false;
        boolean editZone = false;
        boolean viewZone = false;
        String submitEdit = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_SUBMIT_EDIT, (String)"");
        String submitView = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_SUBMIT_VIEW, (String)"");
        String submitChange = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_SUBMIT_CHG, (String)"");
        String submitNew = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_SUBMIT_NEW, (String)"");
        String submitDelete = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_SUBMIT_DEL, (String)"");
        final MapProvider mapProvider = reqState.getMapProvider();
        final boolean mapSupportsCursorLocation = mapProvider != null && mapProvider.isFeatureSupported(2L);
        final boolean mapSupportsDistanceRuler = mapProvider != null && mapProvider.isFeatureSupported(4L);
        final boolean mapSupportsCorridors = mapProvider != null && mapProvider.isFeatureSupported(128L);
        String newZoneID = null;
        if (newZone) {
            if (!allowNew) {
                Print.logInfo((String)"Not authorized to create a new GeoCorridor ...", (Object[])new Object[0]);
                newZone = false;
            } else {
                HttpServletRequest httpReq = reqState.getHttpServletRequest();
                newZoneID = AttributeTools.getRequestString((ServletRequest)httpReq, (String)PARM_NEW_ID, (String)"").trim().toLowerCase();
                if (StringTools.isBlank((String)newZoneID)) {
                    m = i18n.getString("CorridorInfo.enterNewZone", "Please enter a new GeoCorridor name.");
                    error = true;
                    newZone = false;
                } else if (!WebPageAdaptor.isValidID((RequestProperties)reqState, (String)newZoneID)) {
                    m = i18n.getString("CorridorInfo.invalidIDChar", "ID contains invalid characters");
                    error = true;
                    newZone = false;
                }
            }
        } else if (updateZone) {
            if (!allowEdit) {
                updateZone = false;
            } else if (!this.SubmitMatch(submitChange, i18n.getString("CorridorInfo.change", "Change"))) {
                updateZone = false;
            }
        } else if (selectZone) {
            if (this.SubmitMatch(submitDelete, i18n.getString("CorridorInfo.delete", "Delete"))) {
                if (allowDelete) {
                    deleteZone = true;
                }
            } else if (this.SubmitMatch(submitEdit, i18n.getString("CorridorInfo.edit", "Edit"))) {
                if (allowEdit) {
                    if (selZone == null) {
                        m = i18n.getString("CorridorInfo.pleaseSelectCorridor", "Please select a GeoCorridor");
                        error = true;
                        listZones = true;
                    } else {
                        editZone = true;
                        viewZone = true;
                    }
                }
            } else if (this.SubmitMatch(submitView, i18n.getString("CorridorInfo.view", "View"))) {
                if (allowView) {
                    if (selZone == null) {
                        m = i18n.getString("CorridorInfo.pleaseSelectCorridor", "Please select a GeoCorridor");
                        error = true;
                        listZones = true;
                    } else {
                        viewZone = true;
                    }
                }
            } else {
                listZones = true;
            }
        } else {
            listZones = true;
        }
        if (deleteZone) {
            if (selZone == null) {
                m = i18n.getString("CorridorInfo.pleaseSelectCorridor", "Please select a GeoCorridor");
                error = true;
            } else {
                try {
                    GeoCorridor.Key zoneKey = (GeoCorridor.Key)selZone.getRecordKey();
                    Print.logWarn((String)("Deleting GeoCorridor: " + zoneKey), (Object[])new Object[0]);
                    zoneKey.delete(true);
                    selZoneID = "";
                    selZone = null;
                    zoneList = GeoCorridor.getCorridorIDsForAccount((String)currAcct.getAccountID());
                    if (zoneList != null && zoneList.length > 0) {
                        selZoneID = zoneList[0];
                        try {
                            selZone = !selZoneID.equals("") ? GeoCorridor.getGeoCorridor((Account)currAcct, (String)selZoneID, (boolean)false) : null;
                        }
                        catch (DBException dbe) {}
                    }
                }
                catch (DBException dbe) {
                    Print.logException((String)"Deleting GeoCorridor", (Throwable)dbe);
                    m = i18n.getString("CorridorInfo.errorDelete", "Internal error deleting GeoCorridor");
                    error = true;
                }
            }
            listZones = true;
        }
        if (newZone) {
            boolean createZoneOK = true;
            for (int u = 0; u < zoneList.length; ++u) {
                if (!newZoneID.equalsIgnoreCase(zoneList[u])) continue;
                m = i18n.getString("CorridorInfo.alreadyExists", "This GeoCorridor already exists");
                error = true;
                createZoneOK = false;
                break;
            }
            if (createZoneOK) {
                try {
                    GeoCorridor zone = GeoCorridor.getGeoCorridor((Account)currAcct, (String)newZoneID, (boolean)true);
                    zone.setRadius(1000);
                    zone.save();
                    zoneList = GeoCorridor.getCorridorIDsForAccount((String)currAcct.getAccountID());
                    selZone = zone;
                    selZoneID = selZone.getCorridorID();
                    m = i18n.getString("CorridorInfo.createdZone", "New GeoCorridor has been created");
                }
                catch (DBException dbe) {
                    Print.logException((String)"Error Creating GeoCorridor", (Throwable)dbe);
                    m = i18n.getString("CorridorInfo.errorCreate", "Internal error creating GeoCorridor");
                    error = true;
                }
            }
            listZones = true;
        }
        if (updateZone) {
            long zoneRadius = StringTools.parseLong((String)AttributeTools.getRequestString((ServletRequest)request, (String)PARM_ZONE_RADIUS, null), (long)100L);
            String zoneDesc = AttributeTools.getRequestString((ServletRequest)request, (String)PARM_ZONE_DESC, (String)"");
            try {
                if (selZone != null) {
                    boolean saveOK = true;
                    if (zoneRadius > 0L) {
                        selZone.setRadius((int)zoneRadius);
                    }
                    selZone.clearGeoPoints();
                    int pointCount = privLabel.getIntProperty("corridorInfo.pointCount", 15);
                    Vector<GeoPoint> gpList = new Vector<GeoPoint>();
                    boolean p = false;
                    for (int z = 0; z < pointCount; ++z) {
                        double zoneLon;
                        double zoneLat = StringTools.parseDouble((String)AttributeTools.getRequestString((ServletRequest)request, (String)CorridorInfo.PARM_ZONE_LATITUDE(z), null), (double)0.0);
                        if (!GeoPoint.isValid((double)zoneLat, (double)(zoneLon = StringTools.parseDouble((String)AttributeTools.getRequestString((ServletRequest)request, (String)CorridorInfo.PARM_ZONE_LONGITUDE(z), null), (double)0.0)))) continue;
                        gpList.add(new GeoPoint(zoneLat, zoneLon));
                    }
                    selZone.setGeoPoints(gpList);
                    if (!StringTools.isBlank((String)zoneDesc)) {
                        selZone.setDescription(zoneDesc);
                    }
                    if (saveOK) {
                        selZone.save();
                        m = i18n.getString("CorridorInfo.corridorUpdated", "GeoCorridor information updated");
                    } else {
                        editZone = true;
                    }
                } else {
                    m = i18n.getString("CorridorInfo.noCorridors", "There are currently no defined GeoCorridors for this Account.");
                }
            }
            catch (Throwable t) {
                Print.logException((String)"Updating GeoCorridor", (Throwable)t);
                m = i18n.getString("CorridorInfo.errorUpdate", "Internal error updating GeoCorridor");
                error = true;
            }
            listZones = true;
        }
        final String _selZoneID = selZoneID;
        final GeoCorridor _selZone = selZone;
        final String[] _zoneList = zoneList;
        final boolean _allowEdit = allowEdit;
        final boolean _allowView = allowView;
        final boolean _allowNew = allowNew;
        final boolean _allowDelete = allowDelete;
        final boolean _editZone = _allowEdit && editZone;
        boolean _viewZone = _editZone || viewZone;
        final boolean _listZones = listZones || !_editZone && !_viewZone;
        HTMLOutput HTML_CSS = new HTMLOutput(){

            public void write(PrintWriter out) throws IOException {
                String cssDir = CorridorInfo.this.getCssDirectory();
                WebPageAdaptor.writeCssLink((PrintWriter)out, (RequestProperties)reqState, (String)"ZoneInfo.css", (String)cssDir);
                WebPageAdaptor.writeCssLink((PrintWriter)out, (RequestProperties)reqState, (String)"CorridorInfo.css", (String)cssDir);
            }
        };
        HTMLOutput HTML_JS = new HTMLOutput(){

            public void write(PrintWriter out) throws IOException {
                MenuBar.writeJavaScript((PrintWriter)out, (String)pageName, (RequestProperties)reqState);
                JavaScriptTools.writeJSInclude((PrintWriter)out, (String)JavaScriptTools.qualifyJSFileRef((String)"sorttable/sorttable.js"), (HttpServletRequest)request);
                if (!_listZones && mapSupportsCorridors) {
                    if (mapProvider != null) {
                        mapProvider.writeJavaScript(out, reqState);
                    }
                    JavaScriptTools.writeStartJavaScript((PrintWriter)out);
                    double radiusMeters = 20000.0;
                    String zoneColor = ColorTools.GREEN.toString(true);
                    if (_selZone != null) {
                        radiusMeters = _selZone.getRadiusMeters(5.0, 3000.0);
                    }
                    MapDimension mapDim = mapProvider != null ? mapProvider.getZoneDimension() : new MapDimension(0, 0);
                    out.println("// GeoCorridor vars");
                    out.println("jsvGeozoneMode = true;");
                    out.println("MAP_WIDTH  = " + mapDim.getWidth() + ";");
                    out.println("MAP_HEIGHT = " + mapDim.getHeight() + ";");
                    JavaScriptTools.writeJSVar((PrintWriter)out, (String)"DEFAULT_ZONE_RADIUS", (Object)20000.0);
                    JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvZoneEditable", (Object)_editZone);
                    JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvShowVertices", (Object)true);
                    JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvZoneType", (Object)Geozone.GeozoneType.SWEPT_POINT_RADIUS.getIntValue());
                    JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvZoneRadiusMeters", (Object)radiusMeters);
                    JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvZoneColor", (Object)zoneColor);
                    int pointCount = privLabel.getIntProperty("corridorInfo.pointCount", 15);
                    List gpList = CorridorInfo.GetCorridorPoints(_selZone);
                    out.write("// GeoCorridor points\n");
                    JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvZoneCount", (Object)pointCount);
                    JavaScriptTools.writeJSVar((PrintWriter)out, (String)"jsvZoneIndex", (Object)0);
                    out.write("var jsvZoneList = new Array(\n");
                    for (int z = 0; z < pointCount; ++z) {
                        GeoPoint gp;
                        GeoPoint geoPoint = gp = gpList != null && z < gpList.size() ? (GeoPoint)gpList.get(z) : null;
                        if (gp == null) {
                            gp = GeoPoint.INVALID_GEOPOINT;
                        }
                        out.write("    { lat:" + gp.getLatitude() + ", lon:" + gp.getLongitude() + " }");
                        if (z + 1 < pointCount) {
                            out.write(",");
                        }
                        out.write("\n");
                    }
                    out.write("    );\n");
                    JavaScriptTools.writeEndJavaScript((PrintWriter)out);
                    JavaScriptTools.writeJSInclude((PrintWriter)out, (String)JavaScriptTools.qualifyJSFileRef((String)"Geozone.js"), (HttpServletRequest)request);
                }
            }
        };
        final boolean mapControlsOnLeft = ListTools.containsIgnoreCase((String[])CONTROLS_ON_LEFT, (String)privLabel.getStringProperty("corridorInfo.mapControlLocation", ""));
        HTMLOutput HTML_CONTENT = new HTMLOutput(CommonServlet.CSS_CONTENT_FRAME, m){

            public void write(PrintWriter out) throws IOException {
                String pageName = CorridorInfo.this.getPageName();
                String menuURL = privLabel.getWebPageURL(reqState, "menu.top");
                String editURL = CorridorInfo.this.encodePageURL(reqState);
                String selectURL = CorridorInfo.this.encodePageURL(reqState);
                String newURL = CorridorInfo.this.encodePageURL(reqState);
                if (_listZones) {
                    String frameTitle = _allowEdit ? i18n.getString("CorridorInfo.list.viewEditZone", "View/Edit GeoCorridor Information") : i18n.getString("CorridorInfo.list.viewZone", "View GeoCorridor Information");
                    out.write("<span class='menuTitle'>" + frameTitle + "</span><br/>\n");
                    out.write("<hr>\n");
                    out.write("<h1 class='adminSelectTitle'>" + WebPageAdaptor.FilterText((String)i18n.getString("CorridorInfo.list.selectZone", "Select a GeoCorridor")) + ":</h1>\n");
                    out.write("<div style='margin-left:25px;'>\n");
                    out.write("<form name='CorridorInfoSelect' method='post' action='" + selectURL + "' target='_self'>");
                    out.write("<input type='hidden' name='page_cmd' value='select'/>");
                    out.write("<table class='adminSelectTable_sortable' cellspacing=0 cellpadding=0 border=0>\n");
                    out.write(" <thead>\n");
                    out.write("  <tr class='adminTableHeaderRow'>\n");
                    out.write("   <th class='adminTableHeaderCol_nosort'>" + WebPageAdaptor.FilterText((String)i18n.getString("CorridorInfo.list.select", "Select")) + "</th>\n");
                    out.write("   <th class='adminTableHeaderCol_sort'>" + WebPageAdaptor.FilterText((String)i18n.getString("CorridorInfo.list.zoneID", "GeoCorridor ID")) + "</th>\n");
                    out.write("   <th class='adminTableHeaderCol_sort'>" + WebPageAdaptor.FilterText((String)i18n.getString("CorridorInfo.list.description", "Description")) + "</th>\n");
                    out.write("   <th class='adminTableHeaderCol_sort'>" + WebPageAdaptor.FilterText((String)i18n.getString("CorridorInfo.list.radiusMeters", "Radius\n(meters)")) + "</th>\n");
                    out.write("   <th class='adminTableHeaderCol_sort'>" + WebPageAdaptor.FilterText((String)i18n.getString("CorridorInfo.list.startPoint", "Starting\nLatitude/Longitude")) + "</th>\n");
                    out.write("  </tr>\n");
                    out.write(" </thead>\n");
                    out.write(" <tbody>\n");
                    int r = 0;
                    for (int z = 0; z < _zoneList.length; ++z) {
                        GeoPoint firstPt;
                        GeoCorridor zone = null;
                        try {
                            zone = GeoCorridor.getGeoCorridor((Account)currAcct, (String)_zoneList[z], (boolean)false);
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                        if (zone == null) continue;
                        List gpList = CorridorInfo.GetCorridorPoints(zone);
                        String zoneID = WebPageAdaptor.FilterText((String)zone.getCorridorID());
                        String zoneDesc = WebPageAdaptor.FilterText((String)zone.getDescription());
                        String zoneRadius = String.valueOf(zone.getRadius());
                        GeoPoint geoPoint = firstPt = !ListTools.isEmpty((Collection)gpList) ? (GeoPoint)gpList.get(0) : null;
                        if (firstPt == null) {
                            firstPt = new GeoPoint(0.0, 0.0);
                        }
                        String zoneCenter = firstPt.getLatitudeString("5", null) + " " + "/" + " " + firstPt.getLongitudeString("5", null);
                        String checked = _selZoneID.equals(zone.getCorridorID()) ? "checked" : "";
                        String styleClass = (r++ & 1) == 0 ? "adminTableBodyRowOdd" : "adminTableBodyRowEven";
                        out.write("  <tr class='" + styleClass + "'>\n");
                        out.write("   <td class='adminTableBodyCol' sorttable_customkey='" + z + "'>");
                        out.write("<input type='radio' name='z_zone' id='" + zoneID + "' value='" + zoneID + "' " + checked + ">");
                        out.write("</td>\n");
                        out.write("   <td class='adminTableBodyCol' nowrap><label for='" + zoneID + "'>" + zoneID + "</label></td>\n");
                        out.write("   <td class='adminTableBodyCol' nowrap>" + zoneDesc + "</td>\n");
                        out.write("   <td class='adminTableBodyCol' nowrap>" + zoneRadius + "</td>\n");
                        out.write("   <td class='adminTableBodyCol' nowrap>" + zoneCenter + "</td>\n");
                        out.write("  </tr>\n");
                    }
                    out.write(" </tbody>\n");
                    out.write("</table>\n");
                    out.write("<table cellpadding='0' cellspacing='0' border='0' style='width:95%; margin-top:5px; margin-left:5px; margin-bottom:5px;'>\n");
                    out.write("<tr>\n");
                    if (_allowView) {
                        out.write("<td style='padding-left:5px;'>");
                        out.write("<input type='submit' name='z_subview' value='" + i18n.getString("CorridorInfo.list.view", "View") + "'>");
                        out.write("</td>\n");
                    }
                    if (_allowEdit) {
                        out.write("<td style='padding-left:5px;'>");
                        out.write("<input type='submit' name='z_subedit' value='" + i18n.getString("CorridorInfo.list.edit", "Edit") + "'>");
                        out.write("</td>\n");
                    }
                    out.write("<td style='width:100%; text-align:right; padding-right:10px;'>");
                    if (_allowDelete) {
                        out.write("<input type='submit' name='z_subdel' value='" + i18n.getString("CorridorInfo.list.delete", "Delete") + "' " + CorridorInfo.Onclick_ConfirmDelete((Locale)locale) + ">");
                    } else {
                        out.write("&nbsp;");
                    }
                    out.write("</td>\n");
                    out.write("</tr>\n");
                    out.write("</table>\n");
                    out.write("</form>\n");
                    out.write("</div>\n");
                    out.write("<hr>\n");
                    if (_allowNew) {
                        out.write("<h1 class='adminSelectTitle'>" + WebPageAdaptor.FilterText((String)i18n.getString("CorridorInfo.list.createNewZone", "Create a new GeoCorridor")) + ":</h1>\n");
                        out.write("<div style='margin-top:5px; margin-left:5px; margin-bottom:5px;'>\n");
                        out.write("<form name='CorridorInfoNew' method='post' action='" + newURL + "' target='_self'>");
                        out.write(" <input type='hidden' name='page_cmd' value='new'/>");
                        out.write(WebPageAdaptor.FilterText((String)i18n.getString("CorridorInfo.list.zoneID", "GeoCorridor ID")) + ": <input type='text' class='" + "textInput" + "' name='" + CorridorInfo.PARM_NEW_ID + "' value='' size='32' maxlength='32'>");
                        out.write("<br>\n");
                        out.write(" <input type='submit' name='z_subnew' value='" + i18n.getString("CorridorInfo.list.new", "New") + "' style='margin-top:5px; margin-left:10px;'>\n");
                        out.write("</form>\n");
                        out.write("</div>\n");
                        out.write("<hr>\n");
                    }
                } else {
                    String[] instr;
                    MapDimension mapDim;
                    out.println("<form name='CorridorInfoEdit' method='post' action='" + editURL + "' target='_self'>");
                    out.write("<table cellspacing='0' cellpadding='0' border='0'><tr>\n");
                    out.write("<td nowrap>");
                    String frameTitle = _editZone ? i18n.getString("CorridorInfo.map.editZone", "Edit GeoCorridor") : i18n.getString("CorridorInfo.map.viewZone", "View GeoCorridor");
                    out.print("<span style='font-size:9pt; font-weight:bold;'>" + frameTitle + " &nbsp;</span>");
                    out.print(WebPageAdaptor.Form_TextField((String)CorridorInfo.PARM_ZONE_SELECT, (boolean)false, (String)_selZoneID, (int)16, (int)20));
                    out.write("</td>");
                    out.write("<td nowrap style=\"width:100%; text-align:right;\">");
                    String i18nAddressTooltip = i18n.getString("CorridorInfo.map.description.tooltip", "This description is used for custom reverse-geocoding");
                    out.print("<span class='zoneDescription' style='width:100%;' title=\"" + i18nAddressTooltip + "\">");
                    out.print("<b>" + i18n.getString("CorridorInfo.map.description", "Description") + "</b>:&nbsp;");
                    out.print(WebPageAdaptor.Form_TextField((String)CorridorInfo.PARM_ZONE_DESC, (boolean)_editZone, (String)(_selZone != null ? _selZone.getDescription() : ""), (int)30, (int)64));
                    out.println("</span>");
                    out.write("</td>");
                    out.write("</tr></table>");
                    out.println("<input type='hidden' name='page_cmd' value='update'/>");
                    out.println("<table border='0' cellpadding='0' cellspacing='0' style='padding-top:3px'>");
                    out.println("<tr>");
                    MapDimension mapDimension = mapDim = mapProvider != null ? mapProvider.getZoneDimension() : new MapDimension(0, 0);
                    if (!mapControlsOnLeft) {
                        if (mapSupportsCorridors) {
                            out.println("<td style='width:" + mapDim.getWidth() + "px; height:" + mapDim.getHeight() + "px; padding-right:5px;'>");
                            out.println("<!-- Begin Map -->");
                            mapProvider.writeMapCell(out, reqState, mapDim);
                            out.println("<!-- End Map -->");
                            out.println("</td>");
                        } else {
                            out.println("<td style='width:" + mapDim.getWidth() + "px; height:" + mapDim.getHeight() + "px; padding-right:5px; border: 1px solid black;'>");
                            out.println("<!-- GeoCorridors not yet supported for this MapProvider -->");
                            out.println("<center>");
                            out.println("<span style='font-size:12pt;'>");
                            out.println(i18n.getString("CorridorInfo.map.notSupported", "GeoCorridor map not yet supported for this MapProvider"));
                            out.println("&nbsp;</span>");
                            out.println("</center>");
                            out.println("</td>");
                        }
                    }
                    out.println("<td valign='top' style='border-top: solid #CCCCCC 1px;'>");
                    out.println("<hr>");
                    if (_editZone && mapSupportsCorridors) {
                        out.println("<div class='zoneNotesBasic'>");
                        out.println("<i>" + i18n.getString("CorridorInfo.map.notes.basic", "GeoCorridor attributes:") + "</i>");
                        out.println("</div>");
                    }
                    String i18nRadiusTooltip = i18n.getString("CorridorInfo.map.radius.tooltip", "Radius may be between {0} and {1} meters", (Object)String.valueOf(5L), (Object)String.valueOf(3000L));
                    out.println("<div class='zoneRadius' title=\"" + i18nRadiusTooltip + "\">");
                    out.print("<b>" + i18n.getString("CorridorInfo.map.radiusMeters", "Radius (meters)") + ":</b>&nbsp;");
                    out.println(WebPageAdaptor.Form_TextField((String)"trackMapZoneRadiusM", (String)CorridorInfo.PARM_ZONE_RADIUS, (boolean)_editZone, (String)(_selZone != null ? String.valueOf(_selZone.getRadius()) : ""), (int)7, (int)7));
                    out.println("</div>");
                    out.println("<div class='zoneLatLon'>");
                    out.println("<b>" + i18n.getString("CorridorInfo.map.latLon", "Lat/Lon") + "</b>:&nbsp;&nbsp;");
                    if (_editZone && mapSupportsCorridors) {
                        String i18nResetBtn = i18n.getString("CorridorInfo.map.reset", "Reset Map");
                        String i18nResetTooltip = i18n.getString("CorridorInfo.map.reset.tooltip", "Click to update the map with the specified radius/latitude/longitude");
                        out.print("<input class='formButton' type='button' name='reset' value='" + i18nResetBtn + "' title=\"" + i18nResetTooltip + "\" onclick=\"javascript:_zoneReset();\">");
                    }
                    out.println("<br>");
                    out.println("<div style='height:200px; overflow-y:auto;'>");
                    int pointCount = privLabel.getIntProperty("corridorInfo.pointCount", 15);
                    List gpList = CorridorInfo.GetCorridorPoints(_selZone);
                    for (int z = 0; z < pointCount; ++z) {
                        String lonStr;
                        GeoPoint gp = gpList != null && z < gpList.size() ? (GeoPoint)gpList.get(z) : GeoPoint.INVALID_GEOPOINT;
                        String latStr = _selZone != null ? String.valueOf(gp.getLatitude()) : "";
                        String string = lonStr = _selZone != null ? String.valueOf(gp.getLongitude()) : "";
                        if (pointCount > 1) {
                            String chk = z == 0 ? " checked" : "";
                            out.println("<input type='radio'  name='z_index' value='" + z + "' " + chk + " onchange=\"javascript:_zonePointSelectionChanged(" + z + ")\"/>");
                        } else {
                            out.println("<input type='hidden' name='z_index' value='" + z + "'/>");
                        }
                        out.println(WebPageAdaptor.Form_TextField((String)MapProviderAdapter.ID_ZONE_LATITUDE((int)z), (String)CorridorInfo.PARM_ZONE_LATITUDE(z), (boolean)_editZone, (String)latStr, null, (int)9, (int)9, (String)CorridorInfo.CSS_LATLON_INPUT));
                        out.println(WebPageAdaptor.Form_TextField((String)MapProviderAdapter.ID_ZONE_LONGITUDE((int)z), (String)CorridorInfo.PARM_ZONE_LONGITUDE(z), (boolean)_editZone, (String)lonStr, null, (int)10, (int)10, (String)CorridorInfo.CSS_LATLON_INPUT));
                        if (z + 1 >= pointCount) continue;
                        out.println("<br>");
                    }
                    out.println("</div>");
                    if (_editZone && mapSupportsCorridors && privLabel.getBooleanProperty("corridorInfo.enableGeocode", false)) {
                        GeocodeProvider gcp = privLabel.getGeocodeProvider();
                        String dftCountryCode = privLabel.getStringProperty("corridorInfo.enableGeocode.country", "US");
                        String i18nZipBtn = "";
                        i18nZipBtn = gcp == null || gcp.getName().startsWith("geonames") ? i18n.getString("CorridorInfo.map.geocodeZip", "Center On City/ZipCode") : i18n.getString("CorridorInfo.map.geocodeAddress", "Center On Address", (Object)gcp.getName());
                        String i18nZipTooltip = i18n.getString("CorridorInfo.map.geocode.tooltip", "Click to reset GeoCorridor to spcified Address/ZipCode");
                        String rgZipCode_text = "rgZipCode";
                        out.print("<hr>\n");
                        out.print("<input class='formButton' type='button' name='tozip' value='" + i18nZipBtn + "' title=\"" + i18nZipTooltip + "\" onclick=\"javascript:_zoneGotoAddr(jsmGetIDValue('" + rgZipCode_text + "'),'" + dftCountryCode + "');\">");
                        out.print("<br>");
                        out.println(WebPageAdaptor.Form_TextField((String)rgZipCode_text, (String)rgZipCode_text, (boolean)_editZone, (String)"", (int)27, (int)60));
                    }
                    out.println("</div>");
                    out.println("<hr>");
                    out.println("<div class='zoneInstructions'>");
                    out.println("<b>" + i18n.getString("CorridorInfo.map.notes.header", "GeoCorridor Notes/Instructions") + ":</b><br>");
                    if (_editZone && mapSupportsCorridors && (instr = mapProvider.getCorridorInstructions(locale)) != null && instr.length > 0) {
                        for (int i = 0; i < instr.length; ++i) {
                            if (StringTools.isBlank((String)instr[i])) continue;
                            out.println("- " + WebPageAdaptor.FilterText((String)instr[i]) + "<br>");
                        }
                    }
                    out.println("- " + i18n.getString("CorridorInfo.map.notes.lengthInMeters", "Distances are always in meters.") + "<br>");
                    out.println("<hr>");
                    if (mapSupportsCursorLocation || mapSupportsDistanceRuler) {
                        if (mapSupportsCursorLocation) {
                            out.println("<b>" + i18n.getString("CorridorInfo.map.cursorLoc", "Cursor") + "</b>:");
                            out.println("<span id='trackMapLatLonDisplay' style='margin-left:6px; margin-bottom:3px;'>0.00000, 0.00000</span>");
                        }
                        if (mapSupportsDistanceRuler) {
                            out.println("<b>" + i18n.getString("CorridorInfo.map.distanceRuler", "Distance") + "</b>:");
                            out.println("<span id='trackMapDistanceDisplay' style='margin-left:6px;'>0 " + GeoPoint.DistanceUnits.METERS.toString(locale) + "</span>");
                        }
                        out.println("<hr>");
                    }
                    out.println("</div>");
                    out.write("<div width='100%'>\n");
                    out.write("<span style='padding-left:10px'>&nbsp;</span>\n");
                    if (_editZone) {
                        out.write("<input type='submit' name='z_subchg' value='" + i18n.getString("CorridorInfo.map.change", "Change") + "'>\n");
                        out.write("<span style='padding-left:10px'>&nbsp;</span>\n");
                        out.write("<input type='button' name='u_btncan' value='" + i18n.getString("CorridorInfo.map.cancel", "Cancel") + "' onclick=\"javascript:openURL('" + editURL + "','_self');\">\n");
                    } else {
                        out.write("<input type='button' name='u_btnbak' value='" + i18n.getString("CorridorInfo.map.back", "Back") + "' onclick=\"javascript:openURL('" + editURL + "','_self');\">\n");
                    }
                    out.write("</div>\n");
                    out.println("<div width='100%' height='100%'>");
                    out.println("&nbsp;");
                    out.println("</div>");
                    out.println("</td>");
                    if (mapControlsOnLeft) {
                        if (mapSupportsCorridors) {
                            out.println("<td style='width:" + mapDim.getWidth() + "px; height:" + mapDim.getHeight() + "px; padding-left:5px;'>");
                            out.println("<!-- Begin Map -->");
                            mapProvider.writeMapCell(out, reqState, mapDim);
                            out.println("<!-- End Map -->");
                            out.println("</td>");
                        } else {
                            out.println("<td style='width:" + mapDim.getWidth() + "px; height:" + mapDim.getHeight() + "px; padding-left:5px; border: 1px solid black;'>");
                            out.println("<!-- GeoCorridors not yet supported for this MapProvider -->");
                            out.println("<center>");
                            out.println("<span style='font-size:12pt;'>");
                            out.println(i18n.getString("CorridorInfo.map.notSupported", "GeoCorridor map not yet supported for this MapProvider"));
                            out.println("&nbsp;</span>");
                            out.println("</center>");
                            out.println("</td>");
                        }
                    }
                    out.println("</tr>");
                    out.println("</table>");
                    out.println("</form>");
                }
            }
        };
        String mapOnLoad = _listZones ? "" : "javascript:_zoneMapOnLoad();";
        String mapOnUnload = _listZones ? "" : "javascript:_zoneMapOnUnload();";
        String onload = error ? mapOnLoad + CorridorInfo.JS_alert((boolean)false, (String)m) : mapOnLoad;
        CommonServlet.writePageFrame((RequestProperties)reqState, (String)onload, (String)mapOnUnload, (HTMLOutput)HTML_CSS, (HTMLOutput)HTML_JS, null, (HTMLOutput)HTML_CONTENT);
    }
}

