/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.tk10x;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DataTransport;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.dbtypes.DTIPAddrList;
import org.opengts.servers.tk10x.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Nmea0183;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static boolean DEBUG_MODE = false;
    public static String[] UNIQUEID_PREFIX = null;
    public static double MINIMUM_SPEED_KPH = 3.0;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = false;
    public static long SIMEVENT_DIGITAL_INPUTS = 255L;
    public static boolean XLATE_LOCATON_INMOTION = true;
    public static double MINIMUM_MOVED_METERS = 0.0;
    public static boolean PACKET_LEN_END_OF_STREAM = false;
    public static final double KILOMETERS_PER_KNOT = 1.852;
    private static final int[] InputStatusCodes_ON = new int[]{62496, 62497, 62498, 62499, 62500, 62501, 62502, 62503, 62504, 62505, 62506, 62507, 62508, 62509, 62510, 62511};
    private static final int[] InputStatusCodes_OFF = new int[]{62528, 62529, 62530, 62531, 62532, 62533, 62534, 62535, 62536, 62537, 62538, 62539, 62540, 62541, 62542, 62543};
    private static final TimeZone gmtTimezone = DateTime.getGMTTimeZone();
    private TKDeviceType tkDeviceType = TKDeviceType.UNKNOWN;
    private String tkModemID = null;
    private Device tkDevice = null;
    public static long TKNANO_GPIO_ACC = 1L;
    public static long TKNANO_GPIO_ENGINE = 2L;
    public static long TKNANO_GPIO_ON_BATTERY = 8L;
    public static long TKNANO_GPIO_SENSOR_1 = 16L;
    public static long TKNANO_GPIO_SENSOR_2 = 32L;

    private static boolean IsDeviceTypeUnknown(TKDeviceType dt) {
        return dt == null || dt.isUnknown();
    }

    private static boolean IsDeviceTypeTK102(TKDeviceType dt) {
        return dt != null && dt.isTK102();
    }

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.clearSavedEventCount();
        this.tkDeviceType = TKDeviceType.UNKNOWN;
        this.tkModemID = null;
        this.tkDevice = null;
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        byte b;
        int minBytes = 1;
        if (packetLen < minBytes) {
            return minBytes | 0x1000000;
        }
        if (packet[0] == 40) {
            this.tkDeviceType = TKDeviceType.TK103_3;
            if (packetLen > 1 && packet[packetLen - 1] == 41) {
                return packetLen;
            }
            return packetLen + 1 | 0x1000000;
        }
        if (packet[0] == 42) {
            this.tkDeviceType = TKDeviceType.TKnano_1;
            if (packetLen > 1 && packet[packetLen - 1] == 35) {
                return packetLen;
            }
            return packetLen + 1 | 0x1000000;
        }
        if (packet[0] == 36) {
            this.tkDeviceType = TKDeviceType.TKnano_2;
            return 32;
        }
        if (packet[0] == 35) {
            this.tkDeviceType = TKDeviceType.TK103_2;
            if (PACKET_LEN_END_OF_STREAM) {
                return -2;
            }
            return -1;
        }
        if (packet[0] == 105 || packet[0] == 73) {
            this.tkDeviceType = TKDeviceType.TK103_2;
            if (PACKET_LEN_END_OF_STREAM) {
                return -2;
            }
            return -1;
        }
        if (packetLen == 1 && (b = packet[0]) <= 32) {
            return 1;
        }
        this.tkDeviceType = TKDeviceType.TK102;
        if (PACKET_LEN_END_OF_STREAM) {
            return -2;
        }
        return -1;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        String s;
        if (ListTools.isEmpty(pktBytes)) {
            Print.logWarn("Ignoring empty/null packet", new Object[0]);
            return null;
        }
        if (pktBytes.length < 11) {
            if (pktBytes.length != 1 || TrackClientPacketHandler.IsDeviceTypeUnknown(this.tkDeviceType)) {
                Print.logError("Unexpected packet length (" + (Object)((Object)this.tkDeviceType) + "): " + pktBytes.length, new Object[0]);
            }
            return null;
        }
        this.clearSavedEventCount();
        Print.logInfo("Recv: " + StringTools.toStringValue(pktBytes, '.'), new Object[0]);
        if (!StringTools.isPrintableASCII(pktBytes)) {
            Print.logInfo("Hex : 0x" + StringTools.toHexString(pktBytes), new Object[0]);
        }
        if ((s = StringTools.toStringValue(pktBytes).trim()).startsWith("##")) {
            Print.logInfo("TK103-2 Header: " + s, new Object[0]);
            return "LOAD".getBytes();
        }
        if (s.startsWith("imei:")) {
            return this.parseInsertRecord_TK103_2(s);
        }
        if (s.startsWith("(")) {
            return this.parseInsertRecord_TK103_3(s);
        }
        if (s.startsWith("*")) {
            byte[] nanoACK = null;
            nanoACK = this.parseInsertRecord_TKnano_1(s);
            return nanoACK;
        }
        if (s.startsWith("$")) {
            byte[] nanoACK = null;
            nanoACK = this.parseInsertRecord_TKnano_2(pktBytes);
            return nanoACK;
        }
        if (s.length() == 15 && StringTools.isNumeric(s)) {
            if (TrackClientPacketHandler.IsDeviceTypeUnknown(this.tkDeviceType) || TrackClientPacketHandler.IsDeviceTypeTK102(this.tkDeviceType)) {
                this.tkDeviceType = TKDeviceType.TK103_1;
            }
            Print.logInfo("Sending TK103-1 IMEI# response 'ON' ...", new Object[0]);
            return "ON".getBytes();
        }
        return this.parseInsertRecord_TK102(s);
    }

    private byte[] parseInsertRecord_TK103_2(String s) {
        boolean validGPS;
        long gmtHMS;
        Print.logInfo("Parsing: TK103-2 (" + (Object)((Object)this.tkDeviceType) + ") ...", new Object[0]);
        if (s == null) {
            Print.logError("String is null", new Object[0]);
            return null;
        }
        String[] fld = StringTools.parseStringArray(s, ',');
        if (fld == null) {
            Print.logWarn("Fields are null", new Object[0]);
            return null;
        }
        if (fld.length < 12) {
            Print.logWarn("Invalid number of fields: " + fld.length, new Object[0]);
            return null;
        }
        if (fld[0].startsWith("imei:")) {
            this.tkModemID = fld[0].substring("imei:".length()).trim();
        }
        if (StringTools.isBlank(this.tkModemID)) {
            Print.logError("'imei:' value is missing", new Object[0]);
            return null;
        }
        long locYMDhm = fld[2].length() >= 10 ? StringTools.parseLong(fld[2].substring(0, 10), 0L) : 0L;
        long fixtime = this._getUTCSeconds_YMDhms_HMS(locYMDhm * 100L, gmtHMS = StringTools.parseLong(fld[5], 0L));
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date: " + fld[2] + "/" + fld[5], new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
        }
        double latitude = (validGPS = fld[6].equalsIgnoreCase("A")) ? this._parseLatitude(fld[7], fld[8]) : 0.0;
        double longitude = validGPS ? this._parseLongitude(fld[9], fld[10]) : 0.0;
        double knots = validGPS && fld.length > 11 ? StringTools.parseDouble(fld[11], -1.0) : -1.0;
        double headingDeg = validGPS && fld.length > 12 ? StringTools.parseDouble(fld[12], -1.0) : -1.0;
        double speedKPH = knots >= 0.0 ? knots * 1.852 : -1.0;
        double altitudeM = 0.0;
        double odomKM = 0.0;
        double batteryV = 0.0;
        long gpsAge = 0L;
        double HDOP = 0.0;
        int numSats = 0;
        long gpioInput = -1L;
        String eventCode = StringTools.trim(fld[1]);
        if (eventCode.endsWith("!")) {
            eventCode = eventCode.substring(0, eventCode.length() - 1);
        }
        if (validGPS && !GeoPoint.isValid(latitude, longitude)) {
            Print.logWarn("Invalid GPRMC lat/lon: " + latitude + "/" + longitude, new Object[0]);
            latitude = 0.0;
            longitude = 0.0;
            validGPS = false;
        }
        GeoPoint geoPoint = new GeoPoint(latitude, longitude);
        if (speedKPH < MINIMUM_SPEED_KPH) {
            Print.logInfo("Actual Speed: " + speedKPH, new Object[0]);
            speedKPH = 0.0;
            headingDeg = 0.0;
        } else if (headingDeg < 0.0) {
            // empty if block
        }
        int statusCode = 61472;
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null && !StringTools.isBlank(eventCode)) {
            int code = dcs.translateStatusCode(eventCode, -9999);
            if (code == -9999) {
                if (eventCode.equalsIgnoreCase("tracker")) {
                    statusCode = 61472;
                } else if (eventCode.equalsIgnoreCase("ac alarm")) {
                    statusCode = 63553;
                } else if (eventCode.equalsIgnoreCase("moving") || eventCode.equalsIgnoreCase("move")) {
                    statusCode = 61724;
                } else if (eventCode.equalsIgnoreCase("battery")) {
                    statusCode = 64787;
                } else if (eventCode.equalsIgnoreCase("low batt") || eventCode.equalsIgnoreCase("low battery")) {
                    statusCode = 64784;
                } else if (eventCode.equalsIgnoreCase("help me") || eventCode.equalsIgnoreCase("helpme")) {
                    statusCode = 63553;
                } else if (eventCode.equalsIgnoreCase("stockade")) {
                    statusCode = 62032;
                } else if (eventCode.equalsIgnoreCase("speed")) {
                    statusCode = 61722;
                } else if (eventCode.equalsIgnoreCase("trigger")) {
                    statusCode = 63559;
                } else if (eventCode.equalsIgnoreCase("fortify")) {
                    // empty if block
                }
            } else {
                statusCode = code;
            }
        }
        this.handleCommon(this.tkModemID, fixtime, statusCode, null, geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
        return null;
    }

    private byte[] parseInsertRecord_TK103_3(String s) {
        int G;
        Print.logInfo("Parsing: TK103-3 (" + (Object)((Object)this.tkDeviceType) + ") ...", new Object[0]);
        if (s == null) {
            Print.logError("String is null", new Object[0]);
            return null;
        }
        if (!s.startsWith("(")) {
            Print.logError("Does not start with '('", new Object[0]);
            return null;
        }
        int RP = s.endsWith(")") ? 1 : 0;
        String runNumStr = s.substring(1, 13);
        String msgType = s.substring(13, 17);
        String eventCode = "";
        boolean rtnACK = false;
        String ack = "(" + runNumStr + "AP01HSO)";
        byte[] ackB = ack.getBytes();
        if (msgType.equals("BP05")) {
            this.tkModemID = s.substring(17, 32);
            G = 32;
        } else if (msgType.equals("BR00") || msgType.equals("BR02") || msgType.equals("BP04")) {
            if (StringTools.isBlank(this.tkModemID)) {
                Print.logWarn("No ModemID provided by previous BP05 record.", new Object[0]);
            }
            G = 17;
        } else {
            if (msgType.equals("BP00")) {
                Print.logWarn("Returning ACK: " + ack, new Object[0]);
                return ackB;
            }
            if (msgType.equals("BO01")) {
                if (StringTools.isBlank(this.tkModemID)) {
                    Print.logWarn("No ModemID provided by previous BP05 record.", new Object[0]);
                }
                eventCode = s.substring(17, 18);
                G = 18;
            } else {
                Print.logWarn("Unsupported message type: " + msgType, new Object[0]);
                return (byte[])(rtnACK ? ackB : null);
            }
        }
        int expectedLen = G + 62 + RP;
        if (s.length() < expectedLen) {
            Print.logError("Unexpected packet length: " + s.length() + " [expected " + expectedLen + "]", new Object[0]);
            return (byte[])(rtnACK ? ackB : null);
        }
        String dateStr = s.substring(G + 0, G + 6);
        boolean validGPS = s.substring(G + 6, G + 7).equalsIgnoreCase("A");
        double latitude = this._parseLatitude(s.substring(G + 7, G + 16), s.substring(G + 16, G + 17));
        double longitude = this._parseLongitude(s.substring(G + 17, G + 27), s.substring(G + 27, G + 28));
        double speedKPH = StringTools.parseDouble(s.substring(G + 28, G + 33), 0.0);
        String timeStr = s.substring(G + 33, G + 39);
        long fixtime = this._getUTCSeconds_YMD_HMS(dateStr, timeStr);
        double headingDeg = StringTools.parseDouble(s.substring(G + 39, G + 45), 0.0);
        String gpioStr = s.substring(G + 45, G + 53);
        String odomUnits = s.substring(G + 53, G + 54);
        long odomVal = StringTools.parseHexLong(s.substring(G + 54, G + 62), 0L);
        double altitudeM = 0.0;
        GeoPoint geoPoint = new GeoPoint(latitude, longitude);
        double batteryV = 0.0;
        long gpsAge = 0L;
        double HDOP = 0.0;
        int numSats = 0;
        if (validGPS && !geoPoint.isValid()) {
            validGPS = false;
        }
        long gpioInput = -1L;
        if (gpioStr.length() >= 8) {
            gpioInput = 0L;
            for (int i = 0; i <= 7; ++i) {
                char B = gpioStr.charAt(7 - i);
                if (B == '0') continue;
                gpioInput |= 1L << i;
            }
        }
        double odomKM = 0.0;
        if (odomUnits.equalsIgnoreCase("L")) {
            odomKM = (double)odomVal / 1000.0;
        }
        if (speedKPH < MINIMUM_SPEED_KPH) {
            Print.logInfo("Actual Speed: " + speedKPH, new Object[0]);
            speedKPH = 0.0;
            headingDeg = 0.0;
        } else if (headingDeg < 0.0) {
            headingDeg = 0.0;
        }
        int statusCode = 61472;
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null && !StringTools.isBlank(eventCode)) {
            int code = dcs.translateStatusCode(eventCode, -9999);
            if (code == -9999) {
                switch (eventCode.charAt(0)) {
                    case '0': {
                        statusCode = 64791;
                        break;
                    }
                    case '1': {
                        statusCode = 62112;
                        break;
                    }
                    case '2': {
                        statusCode = 63553;
                        break;
                    }
                    case '3': {
                        statusCode = 63617;
                        break;
                    }
                    case '4': {
                        statusCode = 61472;
                        break;
                    }
                    case '5': {
                        statusCode = 61722;
                        break;
                    }
                    case '6': {
                        statusCode = 62128;
                    }
                }
            } else {
                statusCode = code;
            }
        }
        this.handleCommon(this.tkModemID, fixtime, statusCode, null, geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
        return (byte[])(rtnACK ? ackB : null);
    }

    private byte[] parseInsertRecord_TKnano_1(String s) {
        int code;
        Print.logInfo("Parsing: TKnano-1 (" + (Object)((Object)this.tkDeviceType) + ") ...", new Object[0]);
        if (s == null) {
            Print.logError("String is null", new Object[0]);
            return null;
        }
        if (!s.startsWith("*")) {
            Print.logError("Does not start with '*'", new Object[0]);
            return null;
        }
        String[] fld = StringTools.parseStringArray(s, ',');
        if (fld == null) {
            Print.logWarn("Fields are null", new Object[0]);
            return null;
        }
        if (fld.length < 13) {
            Print.logWarn("Invalid number of fields: " + fld.length, new Object[0]);
            return null;
        }
        this.tkModemID = fld[1];
        String eventCode = StringTools.trim(fld[2]);
        long hhmmss = StringTools.parseLong(fld[3], 0L);
        long ddmmyy = StringTools.parseLong(fld[11], 0L);
        long fixtime = this._parseDate_ddmmyy_hhmmss(ddmmyy, hhmmss);
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date: " + fld[3] + "/" + fld[11], new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
        }
        boolean validGPS = fld[4].equalsIgnoreCase("A");
        double latitude = Nmea0183.ParseLatitude(fld[5], fld[6], 0.0);
        double longitude = Nmea0183.ParseLongitude(fld[7], fld[8], 0.0);
        GeoPoint geoPoint = validGPS ? new GeoPoint(latitude, longitude) : GeoPoint.INVALID_GEOPOINT;
        long gpsAge = 0L;
        double HDOP = 0.0;
        int numSats = 0;
        double altitudeM = 0.0;
        double speedKPH = StringTools.parseDouble(fld[9], 0.0) * 1.852;
        double headingDeg = StringTools.parseDouble(fld[10], 0.0);
        if (speedKPH < MINIMUM_SPEED_KPH) {
            Print.logInfo("Actual Speed: " + speedKPH, new Object[0]);
            speedKPH = 0.0;
            headingDeg = 0.0;
        } else if (headingDeg < 0.0) {
            headingDeg = 0.0;
        }
        long vehStatusNeg = StringTools.parseHexLong(fld[12], 0L);
        double batteryV = 0.0;
        double odomKM = 0.0;
        long gpioInput = -1L;
        int statusCode = 61472;
        HashSet<Integer> statCodeSet = null;
        statCodeSet = new HashSet<Integer>();
        gpioInput = TrackClientPacketHandler._parseTKnanoVehicleStatus(vehStatusNeg, statCodeSet, gpioInput);
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null && !StringTools.isBlank(eventCode) && (code = dcs.translateStatusCode(eventCode, -9999)) != -9999) {
            statusCode = code;
        }
        this.handleCommon(this.tkModemID, fixtime, statusCode, statCodeSet, geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
        return null;
    }

    private byte[] parseInsertRecord_TKnano_2(byte[] pktBytes) {
        int code;
        GeoPoint geoPoint;
        boolean validGPS;
        Print.logInfo("Parsing: TKnano-2 (" + (Object)((Object)this.tkDeviceType) + ") ...", new Object[0]);
        if (pktBytes == null || pktBytes.length < 32 || pktBytes[0] != 36) {
            Print.logError("Invalid binary '$' packet", new Object[0]);
            return null;
        }
        Payload p = new Payload(pktBytes);
        p.readSkip(1);
        String mobileID = StringTools.toHexString(p.readBytes(5));
        int F = mobileID.indexOf("F");
        if (F >= 0) {
            mobileID = mobileID.substring(0, F);
        }
        this.tkModemID = mobileID;
        String eventCode = "";
        long hhmmss = StringTools.parseLong(StringTools.toHexString(p.readBytes(3)), 0L);
        long ddmmyy = StringTools.parseLong(StringTools.toHexString(p.readBytes(3)), 0L);
        long fixtime = this._parseDate_ddmmyy_hhmmss(ddmmyy, hhmmss);
        byte[] latB = p.readBytes(4);
        p.readSkip(1);
        byte[] lonB = p.readBytes(4);
        int llAttr = p.readInt(1, 0);
        boolean bl = validGPS = (llAttr & 2) != 0;
        if (validGPS) {
            String latStr = StringTools.toHexString(latB);
            long latVal = StringTools.parseLong(latStr, 0L);
            double latDeg = latVal / 1000000L;
            double latMin = (double)(latVal % 1000000L) / 10000.0;
            double lat = latDeg + latMin / 60.0;
            if ((llAttr & 4) == 0) {
                lat = -lat;
            }
            String lonStr = StringTools.toHexString(lonB);
            long lonVal = StringTools.parseLong(lonStr, 0L);
            double lonDeg = lonVal / 100000L;
            double lonMin = (double)(lonVal % 100000L) / 1000.0;
            double lon = lonDeg + lonMin / 60.0;
            if ((llAttr & 8) == 0) {
                lon = -lon;
            }
            geoPoint = GeoPoint.isValid(lat, lon) ? new GeoPoint(lat, lon) : GeoPoint.INVALID_GEOPOINT;
        } else {
            geoPoint = GeoPoint.INVALID_GEOPOINT;
        }
        long gpsAge = 0L;
        double HDOP = 0.0;
        int numSats = 0;
        double altitudeM = 0.0;
        long speedDir = StringTools.parseLong(StringTools.toHexString(p.readBytes(3)), 0L);
        double speedKPH = (double)(speedDir / 1000L) * 1.852;
        double headingDeg = speedDir % 1000L;
        long vehStatusNeg = p.readULong(4, 0L);
        int alarmStat = p.readUInt(1, 0);
        p.readSkip(1);
        int sequence = p.readUInt(1, 0);
        double batteryV = 0.0;
        double odomKM = 0.0;
        long gpioInput = -1L;
        int statusCode = 61472;
        HashSet<Integer> statCodeSet = null;
        statCodeSet = new HashSet<Integer>();
        gpioInput = TrackClientPacketHandler._parseTKnanoVehicleStatus(vehStatusNeg, statCodeSet, gpioInput);
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null && !StringTools.isBlank(eventCode) && (code = dcs.translateStatusCode(eventCode, -9999)) != -9999) {
            statusCode = code;
        }
        this.handleCommon(this.tkModemID, fixtime, statusCode, statCodeSet, geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
        return null;
    }

    private static long _parseTKnanoVehicleStatus(long vehStatusNeg, Set<Integer> statCodeSet, long gpioInput) {
        int vehStat_4;
        int vehStat_3;
        int vehStat_2;
        int vehStat_1;
        if (gpioInput < 0L) {
            gpioInput = 0L;
        }
        if (((vehStat_1 = (int)(vehStatusNeg >> 24 & 0xFFL)) & 4) == 0) {
            statCodeSet.add(new Integer(64817));
        }
        if ((vehStat_1 & 0x10) == 0) {
            statCodeSet.add(new Integer(64787));
        }
        if ((vehStat_1 & 0x20) == 0) {
            gpioInput |= TKNANO_GPIO_SENSOR_1;
        }
        if ((vehStat_1 & 0x40) == 0) {
            gpioInput |= TKNANO_GPIO_SENSOR_2;
        }
        if (((vehStat_2 = (int)(vehStatusNeg >> 16 & 0xFFL)) & 1) == 0) {
            statCodeSet.add(new Integer(64802));
        }
        if ((vehStat_2 & 8) == 0) {
            gpioInput |= TKNANO_GPIO_ON_BATTERY;
        }
        if ((vehStat_2 & 0x10) == 0) {
            statCodeSet.add(new Integer(64787));
        }
        if ((vehStat_2 & 0x20) == 0) {
            statCodeSet.add(new Integer(64803));
        }
        if ((vehStat_2 & 0x40) == 0) {
            statCodeSet.add(new Integer(64804));
        }
        if (((vehStat_3 = (int)(vehStatusNeg >> 8 & 0xFFL)) & 4) != 0) {
            gpioInput |= TKNANO_GPIO_ACC;
        }
        if ((vehStat_3 & 0x20) == 0) {
            gpioInput |= TKNANO_GPIO_ENGINE;
        }
        if ((vehStat_3 & 0x40) == 0) {
            statCodeSet.add(new Integer(63559));
        }
        if ((vehStat_3 & 0x80) == 0) {
            statCodeSet.add(new Integer(61722));
        }
        if (((vehStat_4 = (int)(vehStatusNeg >> 0 & 0xFFL)) & 4) == 0) {
            statCodeSet.add(new Integer(61722));
        }
        if ((vehStat_4 & 0x10) == 0) {
            statCodeSet.add(new Integer(62064));
        }
        if ((vehStat_4 & 0x20) == 0) {
            statCodeSet.add(new Integer(64803));
        }
        if ((vehStat_4 & 0x40) == 0) {
            statCodeSet.add(new Integer(64804));
        }
        if ((vehStat_4 & 0x80) == 0) {
            statCodeSet.add(new Integer(62080));
        }
        return gpioInput;
    }

    private byte[] parseInsertRecord_TK102(String s) {
        String eventCode;
        int gpx;
        Print.logInfo("Parsing: TK102 (" + (Object)((Object)this.tkDeviceType) + ") ...", new Object[0]);
        if (s == null) {
            Print.logError("String is null", new Object[0]);
            return null;
        }
        String[] fld = StringTools.parseStringArray(s, ',');
        if (fld == null) {
            Print.logWarn("Fields are null", new Object[0]);
            return null;
        }
        if (fld.length < 15) {
            Print.logWarn("Invalid number of fields: " + fld.length, new Object[0]);
            return null;
        }
        int imeiNdx = -1;
        for (int f = 0; f < fld.length; ++f) {
            if (!fld[f].startsWith("imei:")) continue;
            this.tkModemID = fld[f].substring("imei:".length()).trim();
            imeiNdx = f;
            break;
        }
        if (StringTools.isBlank(this.tkModemID)) {
            Print.logError("'imei:' value is missing", new Object[0]);
            return null;
        }
        for (gpx = 0; gpx < fld.length && !fld[gpx].equalsIgnoreCase("GPRMC"); ++gpx) {
        }
        if (gpx >= fld.length) {
            Print.logError("'GPRMC' not found", new Object[0]);
            return null;
        }
        if (gpx + 12 >= fld.length) {
            Print.logError("Insufficient 'GPRMC' fields", new Object[0]);
            return null;
        }
        long hms = StringTools.parseLong(fld[gpx + 1], 0L);
        long dmy = StringTools.parseLong(fld[gpx + 9], 0L);
        long fixtime = this._getUTCSeconds_DMY_HMS(dmy, hms);
        boolean validGPS = fld[gpx + 2].equalsIgnoreCase("A");
        double latitude = validGPS ? this._parseLatitude(fld[gpx + 3], fld[gpx + 4]) : 0.0;
        double longitude = validGPS ? this._parseLongitude(fld[gpx + 5], fld[gpx + 6]) : 0.0;
        double knots = validGPS ? StringTools.parseDouble(fld[gpx + 7], -1.0) : 0.0;
        double headingDeg = validGPS ? StringTools.parseDouble(fld[gpx + 8], -1.0) : 0.0;
        double speedKPH = knots >= 0.0 ? knots * 1.852 : -1.0;
        double odomKM = 0.0;
        long gpsAge = 0L;
        double HDOP = 0.0;
        int numSats = 0;
        long gpioInput = -1L;
        String altMStr = fld.length > imeiNdx + 2 ? fld[imeiNdx + 2] : "";
        double altitudeM = StringTools.parseDouble(altMStr, 0.0);
        String battVStr = fld.length > imeiNdx + 3 ? fld[imeiNdx + 3] : "";
        double batteryV = 0.0;
        if (battVStr.startsWith("F:") || battVStr.startsWith("L:")) {
            batteryV = StringTools.parseDouble(battVStr.substring(2), 0.0);
        }
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date: " + fld[gpx + 9] + "/" + fld[gpx + 1], new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
        }
        String string = eventCode = gpx + 14 < fld.length ? StringTools.trim(fld[gpx + 14]) : "";
        if (validGPS && !GeoPoint.isValid(latitude, longitude)) {
            Print.logWarn("Invalid GPRMC lat/lon: " + latitude + "/" + longitude, new Object[0]);
            latitude = 0.0;
            longitude = 0.0;
            validGPS = false;
        }
        GeoPoint geoPoint = new GeoPoint(latitude, longitude);
        if (speedKPH < MINIMUM_SPEED_KPH) {
            Print.logInfo("Actual Speed: " + speedKPH, new Object[0]);
            speedKPH = 0.0;
            headingDeg = 0.0;
        } else if (headingDeg < 0.0) {
            headingDeg = 0.0;
        }
        int statusCode = 61472;
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null && !StringTools.isBlank(eventCode)) {
            int code = dcs.translateStatusCode(eventCode, -9999);
            if (code == -9999) {
                if (eventCode.equalsIgnoreCase("CutWatch")) {
                    statusCode = 63625;
                } else if (eventCode.equalsIgnoreCase("Low batt")) {
                    statusCode = 64784;
                } else if (eventCode.equalsIgnoreCase("moving")) {
                    statusCode = 61724;
                } else if (!eventCode.equalsIgnoreCase("battery") && (eventCode.equalsIgnoreCase("help me") || eventCode.equalsIgnoreCase("helpme"))) {
                    statusCode = 63553;
                }
            } else {
                statusCode = code;
            }
        }
        this.handleCommon(this.tkModemID, fixtime, statusCode, null, geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
        return null;
    }

    private long _getUTCSeconds_YMD_HMS(String yymmdd, String hhmmss) {
        if (yymmdd.length() < 6 || hhmmss.length() < 6) {
            return 0L;
        }
        int YY = StringTools.parseInt(yymmdd.substring(0, 2), -1);
        int MM = StringTools.parseInt(yymmdd.substring(2, 4), -1);
        int DD = StringTools.parseInt(yymmdd.substring(4, 6), -1);
        int hh = StringTools.parseInt(hhmmss.substring(0, 2), -1);
        int mm = StringTools.parseInt(hhmmss.substring(2, 4), -1);
        int ss = StringTools.parseInt(hhmmss.substring(4, 6), -1);
        if (YY < 0 || MM < 1 || MM > 12 || DD < 1 || DD > 31 || hh < 0 || mm < 0 || ss < 0) {
            return 0L;
        }
        long fixtime = new DateTime(gmtTimezone, YY + 2000, MM, DD, hh, mm, ss).getTimeSec();
        return fixtime;
    }

    private long _getUTCSeconds_DMY_HMS(long dmy, long hms) {
        long DAY;
        int HH = (int)(hms / 10000L % 100L);
        int MM = (int)(hms / 100L % 100L);
        int SS = (int)(hms % 100L);
        long TOD = (long)HH * 3600L + (long)MM * 60L + (long)SS;
        if (dmy > 0L) {
            int yy = (int)(dmy % 100L) + 2000;
            int mm = (int)(dmy / 100L % 100L);
            int dd = (int)(dmy / 10000L % 100L);
            long yr = (long)yy * 1000L + (long)((mm - 3) * 1000 / 12);
            DAY = (367L * yr + 625L) / 1000L - 2L * (yr / 1000L) + yr / 4000L - yr / 100000L + yr / 400000L + (long)dd - 719469L;
        } else {
            long dif;
            long utc = DateTime.getCurrentTimeSec();
            long tod = utc % DateTime.DaySeconds(1L);
            DAY = utc / DateTime.DaySeconds(1L);
            long l = dif = tod >= TOD ? tod - TOD : TOD - tod;
            if (dif > DateTime.HourSeconds(12L)) {
                DAY = tod > TOD ? ++DAY : --DAY;
            }
        }
        long sec = DateTime.DaySeconds(DAY) + TOD;
        return sec;
    }

    private long _getUTCSeconds_YMDhms_HMS(long locYMDhms, long gmtHMS) {
        long DAY;
        int gmtHH = (int)(gmtHMS / 10000L % 100L);
        int gmtMM = (int)(gmtHMS / 100L % 100L);
        int gmtSS = (int)(gmtHMS % 100L);
        long gmtTOD = (long)gmtHH * 3600L + (long)gmtMM * 60L + (long)gmtSS;
        int locHH = (int)(locYMDhms / 10000L % 100L);
        int locMM = (int)(locYMDhms / 100L % 100L);
        int locSS = (int)(locYMDhms % 100L);
        long locTOD = (long)locHH * 3600L + (long)locMM * 60L + (long)locSS;
        long ymd = locYMDhms / 1000000L;
        if (ymd > 0L) {
            long dif;
            int dd = (int)(ymd % 100L);
            int mm = (int)(ymd / 100L % 100L);
            int yy = (int)(ymd / 10000L % 100L) + 2000;
            long yr = (long)yy * 1000L + (long)((mm - 3) * 1000 / 12);
            DAY = (367L * yr + 625L) / 1000L - 2L * (yr / 1000L) + yr / 4000L - yr / 100000L + yr / 400000L + (long)dd - 719469L;
            long l = dif = locTOD >= gmtTOD ? locTOD - gmtTOD : gmtTOD - locTOD;
            if (dif > DateTime.HourSeconds(12L)) {
                DAY = locTOD > gmtTOD ? ++DAY : --DAY;
            }
        } else {
            long dif;
            long utc = DateTime.getCurrentTimeSec();
            long tod = utc % DateTime.DaySeconds(1L);
            DAY = utc / DateTime.DaySeconds(1L);
            long l = dif = tod >= gmtTOD ? tod - gmtTOD : gmtTOD - tod;
            if (dif > DateTime.HourSeconds(12L)) {
                DAY = tod > gmtTOD ? ++DAY : --DAY;
            }
        }
        long sec = DateTime.DaySeconds(DAY) + gmtTOD;
        return sec;
    }

    private long _parseDate_ddmmyy_hhmmss(long ddmmyy, long hhmmss) {
        if (ddmmyy <= 0L || hhmmss < 0L) {
            return 0L;
        }
        int DD = (int)(ddmmyy / 10000L % 100L);
        int MM = (int)(ddmmyy / 100L % 100L);
        int YY = (int)(ddmmyy / 1L % 100L);
        int hh = (int)(hhmmss / 10000L % 100L);
        int mm = (int)(hhmmss / 100L % 100L);
        int ss = (int)(hhmmss / 1L % 100L);
        DateTime dt = new DateTime(gmtTimezone, YY + 2000, MM, DD, hh, mm, ss);
        return dt.getTimeSec();
    }

    private double _parseLatitude(String s, String d) {
        double _lat = StringTools.parseDouble(s, 99999.0);
        if (_lat < 99999.0) {
            double lat = (long)_lat / 100L;
            lat += (_lat - lat * 100.0) / 60.0;
            return d.equals("S") ? -lat : lat;
        }
        return 90.0;
    }

    private double _parseLongitude(String s, String d) {
        double _lon = StringTools.parseDouble(s, 99999.0);
        if (_lon < 99999.0) {
            double lon = (long)_lon / 100L;
            lon += (_lon - lon * 100.0) / 60.0;
            return d.equals("W") ? -lon : lon;
        }
        return 180.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleCommon(String modemID, long fixtime, int statusCode, HashSet<Integer> statCodeSet, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, double speedKPH, double headingDeg, double altitudeM, double odomKM, long gpioInput, double batteryV) {
        List<Device.GeozoneTransition> zone;
        Device device;
        boolean validGPS;
        if (geoPoint == null) {
            geoPoint = GeoPoint.INVALID_GEOPOINT;
            validGPS = false;
        } else {
            validGPS = geoPoint.isValid();
        }
        Print.logInfo("IMEI     : " + this.tkModemID, new Object[0]);
        Print.logInfo("Timestamp: " + fixtime + " [" + new DateTime(fixtime) + "]", new Object[0]);
        Print.logInfo("GPS      : " + geoPoint, new Object[0]);
        if (altitudeM != 0.0) {
            Print.logInfo("Altitude : " + StringTools.format(altitudeM, "#0.0") + " meters", new Object[0]);
        }
        Print.logInfo("Speed    : " + StringTools.format(speedKPH, "#0.0") + " kph " + headingDeg, new Object[0]);
        if (batteryV > 0.0) {
            Print.logInfo("Battery  : " + StringTools.format(batteryV, "#0.0") + " Volts", new Object[0]);
        }
        if ((device = DCServerConfig.loadDeviceUniqueID(Main.getServerConfig(), this.tkModemID)) == null) {
            return false;
        }
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        String uniqueID = device.getUniqueID();
        Print.logInfo("UniqueID  : " + uniqueID, new Object[0]);
        Print.logInfo("DeviceID  : " + accountID + "/" + deviceID, new Object[0]);
        DataTransport dataXPort = device.getDataTransport();
        if (this.hasIPAddress() && !dataXPort.isValidIPAddress(this.getIPAddress())) {
            DTIPAddrList validIPAddr = dataXPort.getIpAddressValid();
            Print.logError("Invalid IP Address from device: " + this.getIPAddress() + " [expecting " + validIPAddr + "]", new Object[0]);
            return false;
        }
        dataXPort.setIpAddressCurrent(this.getIPAddress());
        dataXPort.setRemotePortCurrent(this.getRemotePort());
        dataXPort.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
        if (!dataXPort.getDeviceCode().equalsIgnoreCase(Main.getServerName())) {
            dataXPort.setDeviceCode(Main.getServerName());
        }
        if (headingDeg < 0.0) {
            GeoPoint lastGP;
            headingDeg = 0.0;
            if (validGPS && speedKPH > 0.0 && GeoPoint.isValid(lastGP = device.getLastValidLocation())) {
                headingDeg = lastGP.headingToPoint(geoPoint);
            }
        }
        if ((odomKM = odomKM <= 0.0 ? (ESTIMATE_ODOMETER && validGPS ? device.getNextOdometerKM(geoPoint) : device.getLastOdometerKM()) : device.adjustOdometerKM(odomKM)) > 0.0) {
            Print.logInfo("OdometerKM: " + odomKM, new Object[0]);
        }
        if (SIMEVENT_GEOZONES && validGPS && (zone = device.checkGeozoneTransitions(fixtime, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                int zsc = z.getStatusCode();
                this.insertEventRecord(device, z.getTimestamp(), zsc, z.getGeozone(), geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
                Print.logInfo("Geozone    : " + z, new Object[0]);
            }
        }
        if (gpioInput >= 0L) {
            long chgMask;
            if (SIMEVENT_DIGITAL_INPUTS > 0L && (chgMask = (device.getLastInputState() ^ gpioInput) & SIMEVENT_DIGITAL_INPUTS) != 0L) {
                for (int b = 0; b <= 7; ++b) {
                    long m = 1L << b;
                    if ((chgMask & m) == 0L) continue;
                    long inpTime = fixtime;
                    int inpCode = (gpioInput & m) != 0L ? InputStatusCodes_ON[b] : InputStatusCodes_OFF[b];
                    Print.logInfo("GPIO input : " + StatusCodes.GetDescription(inpCode, null), new Object[0]);
                    this.insertEventRecord(device, inpTime, inpCode, null, geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
                }
            }
            device.setLastInputState(gpioInput & 0xFFFFL);
        }
        if (!ListTools.isEmpty(statCodeSet)) {
            for (Integer sci : statCodeSet) {
                int sc = sci;
                this.insertEventRecord(device, fixtime, sc, null, geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
                if (statusCode != sc) continue;
                statusCode = -1;
            }
            if (statusCode == 61472) {
                statusCode = -1;
            }
        }
        if (statusCode < 0) {
            Print.logDebug("Ignoring Event (per EventCodeMap)", new Object[0]);
        } else if (statusCode == -1) {
            Print.logDebug("Ignoring Event (per EventCodeMap)", new Object[0]);
        } else if (!this.hasSavedEvents() || statusCode != 61472 && statusCode != 0) {
            if (statusCode == 0) {
                int sc = speedKPH > 0.0 ? 61714 : 61472;
                this.insertEventRecord(device, fixtime, sc, null, geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
            } else if (statusCode != 61472) {
                this.insertEventRecord(device, fixtime, statusCode, null, geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
            } else if (XLATE_LOCATON_INMOTION && speedKPH > 0.0) {
                int sc = 61714;
                this.insertEventRecord(device, fixtime, sc, null, geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
            }
        }
        if (validGPS && !device.isNearLastValidLocation(geoPoint, MINIMUM_MOVED_METERS)) {
            this.insertEventRecord(device, fixtime, statusCode, null, geoPoint, gpsAge, HDOP, numSats, speedKPH, headingDeg, altitudeM, odomKM, gpioInput, batteryV);
        }
        if (!DEBUG_MODE) {
            try {
                device.updateChangedEventFields();
            }
            catch (DBException dbe) {
                Print.logException("Unable to update Device: " + accountID + "/" + deviceID, dbe);
            }
        }
        return true;
    }

    private EventData createEventRecord(Device device, long gpsTime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, double speedKPH, double heading, double altitudeM, double odomKM, long gpioInput, double batteryV) {
        String accountID = device.getAccountID();
        String deviceID = device.getDeviceID();
        EventData.Key evKey = new EventData.Key(accountID, deviceID, gpsTime, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setGeozone(geozone);
        evdb.setGeoPoint(geoPoint);
        evdb.setGpsAge(gpsAge);
        evdb.setHDOP(HDOP);
        evdb.setSatelliteCount(numSats);
        evdb.setSpeedKPH(speedKPH);
        evdb.setHeading(heading);
        evdb.setAltitude(altitudeM);
        evdb.setOdometerKM(odomKM);
        evdb.setInputMask(gpioInput);
        evdb.setBatteryVolts(batteryV);
        return evdb;
    }

    private void insertEventRecord(Device device, long gpsTime, int statusCode, Geozone geozone, GeoPoint geoPoint, long gpsAge, double HDOP, int numSats, double speedKPH, double heading, double altitudeM, double odomKM, long gpioInput, double batteryV) {
        EventData evdb = this.createEventRecord(device, gpsTime, statusCode, geozone, geoPoint, gpsAge, HDOP, numSats, speedKPH, heading, altitudeM, odomKM, gpioInput, batteryV);
        Print.logInfo("Event: [0x" + StringTools.toHexString(statusCode, 16) + "] " + StatusCodes.GetDescription(statusCode, null), new Object[0]);
        if (!DEBUG_MODE) {
            device.insertEventData(evdb);
            this.incrementSavedEventCount();
        }
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig();
        if (dcsc != null) {
            UNIQUEID_PREFIX = dcsc.getUniquePrefix();
            MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
            ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
            SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
            SIMEVENT_DIGITAL_INPUTS = dcsc.getSimulateDigitalInputs(SIMEVENT_DIGITAL_INPUTS) & 0xFFL;
            XLATE_LOCATON_INMOTION = dcsc.getStatusLocationInMotion(XLATE_LOCATON_INMOTION);
            MINIMUM_MOVED_METERS = dcsc.getMinimumMovedMeters(MINIMUM_MOVED_METERS);
            PACKET_LEN_END_OF_STREAM = dcsc.getBooleanProperty("tk10x.packetLenEndOfStream", PACKET_LEN_END_OF_STREAM);
        }
    }

    public static enum TKDeviceType {
        UNKNOWN(0, "Unknown"),
        TK102(1, "TK102"),
        TK103_1(2, "TK103-1"),
        TK103_2(3, "TK103-2"),
        TK103_3(4, "TK103-3"),
        TKnano_1(5, "TKnano-1"),
        TKnano_2(5, "TKnano-2");

        private int vv = 0;
        private String dd = null;

        private TKDeviceType(int v, String d) {
            this.vv = v;
            this.dd = d;
        }

        public String toString() {
            return this.dd;
        }

        public boolean isUnknown() {
            return this.equals((Object)UNKNOWN);
        }

        public boolean isTK102() {
            return this.equals((Object)TK102);
        }

        public boolean isTKnano() {
            return this.equals((Object)TKnano_1) || this.equals((Object)TKnano_2);
        }
    }
}

