/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.util;

import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;

public class GeoVector
implements Cloneable,
GeoPointProvider {
    private static double RADIANS = Math.PI / 180;
    private static double EPSILON = 1.0E-9;
    private double X = 0.0;
    private double Y = 0.0;
    private double Z = 0.0;
    private boolean isNaN = true;

    private static double SQ(double d) {
        return d * d;
    }

    public GeoVector() {
        this.isNaN = true;
    }

    public GeoVector(GeoPoint geoPoint) {
        if (geoPoint != null && geoPoint.isValid()) {
            double d = geoPoint.getLatitudeRadians();
            double d2 = geoPoint.getLongitudeRadians();
            this.X = Math.cos(d) * Math.cos(d2);
            this.Y = Math.cos(d) * Math.sin(d2);
            this.Z = Math.sin(d);
            this._checkIsNaN();
        } else {
            this.isNaN = true;
        }
    }

    public GeoVector(double d, double d2, double d3) {
        this.X = d;
        this.Y = d2;
        this.Z = d3;
        this._checkIsNaN();
    }

    public GeoVector(GeoVector geoVector) {
        if (geoVector != null) {
            this.X = geoVector.X;
            this.Y = geoVector.Y;
            this.Z = geoVector.Z;
            this._checkIsNaN();
        } else {
            this.isNaN = true;
        }
    }

    private boolean _checkIsNaN() {
        this.isNaN = Double.isNaN(this.X) || Double.isNaN(this.Y) || Double.isNaN(this.Z);
        return this.isNaN;
    }

    public boolean isNaN() {
        return this.isNaN;
    }

    public boolean isValid() {
        return !this.isNaN();
    }

    public double getX() {
        return this.X;
    }

    public double getY() {
        return this.Y;
    }

    public double getZ() {
        return this.Z;
    }

    public double getLength() {
        if (this.isNaN()) {
            return 0.0;
        }
        return Math.sqrt(GeoVector.SQ(this.X) + GeoVector.SQ(this.Y) + GeoVector.SQ(this.Z));
    }

    public GeoVector normalize() {
        double d = this.getLength();
        if (d != 0.0) {
            this.X /= d;
            this.Y /= d;
            this.Z /= d;
            this._checkIsNaN();
        }
        return this;
    }

    public GeoPoint getGeoPoint() {
        double d;
        double d2;
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = this.getZ();
        double d6 = this.getLength();
        if (d6 != 0.0) {
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
        }
        double d7 = Math.asin(d4 / (d2 = Math.cos(d = Math.asin(d5)))) < 0.0 ? -1.0 : 1.0;
        double d8 = Math.acos(d3 / d2) * d7;
        return new GeoPoint(d / RADIANS, d8 / RADIANS);
    }

    public double dotProduct(GeoVector geoVector) {
        GeoVector geoVector2 = this;
        if (geoVector2.isNaN() || geoVector == null || geoVector.isNaN()) {
            return 0.0;
        }
        double d = geoVector2.getX() * geoVector.getX() + geoVector2.getY() * geoVector.getY() + geoVector2.getZ() * geoVector.getZ();
        return Math.abs(d) >= EPSILON ? d : 0.0;
    }

    public GeoVector crossProduct(GeoVector geoVector) {
        GeoVector geoVector2 = this;
        if (geoVector2.isNaN() || geoVector == null || geoVector.isNaN()) {
            return new GeoVector();
        }
        double d = geoVector2.getY() * geoVector.getZ() - geoVector2.getZ() * geoVector.getY();
        double d2 = geoVector2.getZ() * geoVector.getX() - geoVector2.getX() * geoVector.getZ();
        double d3 = geoVector2.getX() * geoVector.getY() - geoVector2.getY() * geoVector.getX();
        return new GeoVector(d, d2, d3);
    }

    public GeoVector add(GeoVector geoVector) {
        GeoVector geoVector2 = this;
        if (geoVector2.isNaN() || geoVector == null || geoVector.isNaN()) {
            return new GeoVector();
        }
        double d = geoVector2.getX() + geoVector.getX();
        double d2 = geoVector2.getY() + geoVector.getY();
        double d3 = geoVector2.getZ() + geoVector.getZ();
        return new GeoVector(d, d2, d3);
    }

    public Object clone() {
        return new GeoVector(this);
    }
}

