/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.util;

import java.util.AbstractList;
import java.util.List;
import java.util.Vector;
import org.opengts.rule.util.GeoVector;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeozoneChecker;
import org.opengts.util.ListTools;

public class GeoSegment
implements Cloneable {
    private List<GeoPoint> geoPoints = null;
    private double radiusMeters = 0.0;
    private static GeozoneChecker geozoneCheck = null;

    private static double SQ(double d) {
        return d * d;
    }

    public GeoSegment() {
    }

    public GeoSegment(GeoPoint geoPoint, GeoPoint geoPoint2) {
        this(geoPoint, geoPoint2, 0.0);
    }

    public GeoSegment(GeoPoint geoPoint, GeoPoint geoPoint2, double d) {
        this();
        this.geoPoints = new Vector<GeoPoint>();
        this.geoPoints.add(geoPoint);
        this.geoPoints.add(geoPoint2);
        this.radiusMeters = d;
        this._validate();
    }

    public GeoSegment(GeoPoint[] geoPointArray, double d) {
        this();
        this.geoPoints = geoPointArray != null ? ListTools.toList((Object[])geoPointArray) : null;
        this.radiusMeters = d;
        this._validate();
    }

    public GeoSegment(List<GeoPoint> list, double d) {
        this();
        this.geoPoints = list != null ? new Vector<GeoPoint>(list) : null;
        this.radiusMeters = d;
        this._validate();
    }

    public GeoSegment(GeoSegment geoSegment) {
        this();
        this.geoPoints = new Vector<GeoPoint>(geoSegment.geoPoints);
        this.radiusMeters = geoSegment.radiusMeters;
        this._validate();
    }

    private void _validate() {
        if (this.geoPoints != null) {
            if (this.geoPoints.size() < 2) {
                this.geoPoints = null;
            } else {
                for (GeoPoint geoPoint : this.geoPoints) {
                    if (geoPoint != null && geoPoint.isValid()) continue;
                    this.geoPoints = null;
                    break;
                }
            }
        }
        if (this.radiusMeters < 0.0) {
            this.radiusMeters = 0.0;
        }
    }

    public boolean isValid() {
        return !ListTools.isEmpty(this.geoPoints);
    }

    public List<GeoPoint> getGeoPoints() {
        return this.geoPoints;
    }

    public int getPointCount() {
        return ListTools.size(this.getGeoPoints());
    }

    public int getSegmentCount() {
        int n = this.getPointCount();
        return n > 1 ? n - 1 : 0;
    }

    public void reverseGeoPoints() {
        if (ListTools.size(this.geoPoints) >= 2) {
            ListTools.reverseOrder(this.geoPoints);
        }
    }

    public GeoPoint getGeoPoint(int n) {
        return (GeoPoint)ListTools.itemAt(this.getGeoPoints(), (int)n, null);
    }

    public GeoVector getGeoVector(int n) {
        GeoPoint geoPoint = this.getGeoPoint(n);
        return geoPoint != null ? new GeoVector(geoPoint) : null;
    }

    public double getRadiusMeters() {
        return this.radiusMeters;
    }

    public double getRadiusKilometers() {
        return this.radiusMeters / 1000.0;
    }

    public double getLengthMeters() {
        return this.getLengthKilometers() * 1000.0;
    }

    public double getLengthKilometers() {
        return GeoSegment.getLengthKilometers(this.getGeoPoints(), -1);
    }

    public static double getLengthKilometers(List<GeoPoint> list, int n) {
        if (list == null) {
            return 0.0;
        }
        int n2 = n >= 0 && n < list.size() - 1 ? n : list.size() - 1;
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            GeoPoint geoPoint = list.get(i);
            GeoPoint geoPoint2 = list.get(i + 1);
            d += geoPoint.kilometersToPoint(geoPoint2);
        }
        return d;
    }

    public GeoPoint getMidPoint(double d) {
        if (d < 0.0 || d > 1.0) {
            return null;
        }
        if (this.getPointCount() <= 2) {
            GeoPoint geoPoint = this.getGeoPoint(0);
            GeoPoint geoPoint2 = this.getGeoPoint(1);
            if (geoPoint != null && geoPoint2 != null) {
                return this._getMidPoint(geoPoint, geoPoint2, d);
            }
            return null;
        }
        double d2 = this.getLengthKilometers();
        double d3 = d2 * d;
        List<GeoPoint> list = this.getGeoPoints();
        int n = list.size() - 1;
        for (int i = 0; i < n; ++i) {
            GeoPoint geoPoint;
            GeoPoint geoPoint3 = list.get(i);
            double d4 = geoPoint3.kilometersToPoint(geoPoint = list.get(i + 1));
            if (d3 > d4) {
                d3 -= d4;
                continue;
            }
            double d5 = d3 / d4;
            return this._getMidPoint(geoPoint3, geoPoint, d5);
        }
        return null;
    }

    private GeoPoint _getMidPoint(GeoPoint geoPoint, GeoPoint geoPoint2, double d) {
        double d2 = geoPoint.radiansToPoint(geoPoint2);
        double d3 = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
        double d4 = Math.sin((1.0 - d3) * d2) / Math.sin(d2);
        double d5 = Math.sin(d3 * d2) / Math.sin(d2);
        GeoVector geoVector = new GeoVector(geoPoint);
        GeoVector geoVector2 = new GeoVector(geoPoint2);
        double d6 = d4 * geoVector.getX() + d5 * geoVector2.getX();
        double d7 = d4 * geoVector.getY() + d5 * geoVector2.getY();
        double d8 = d4 * geoVector.getZ() + d5 * geoVector2.getZ();
        GeoPoint geoPoint3 = new GeoVector(d6, d7, d8).getGeoPoint();
        return geoPoint3;
    }

    public GeoPoint getClosestProjection(GeoPoint geoPoint) {
        return GeoSegment.getClosestProjection(geoPoint, this.getGeoPoints(), this.getRadiusKilometers());
    }

    public static GeoPoint getClosestProjection(GeoPoint geoPoint, List<GeoPoint> list, double d) {
        if (geoPoint == null || !geoPoint.isValid()) {
            return null;
        }
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            GeoPoint geoPoint2 = list.get(0);
            return geoPoint.kilometersToPoint(geoPoint2) <= d ? geoPoint2 : null;
        }
        GeoPoint geoPoint3 = null;
        double d2 = 40030.22888407185;
        int n = 0;
        GeoVector geoVector = new GeoVector(geoPoint);
        int n2 = list.size() - 1;
        for (int i = 0; i < n2; ++i) {
            GeoVector geoVector2;
            GeoVector geoVector3;
            GeoVector geoVector4;
            GeoVector geoVector5;
            GeoVector geoVector6;
            GeoPoint geoPoint4;
            double d3;
            GeoPoint geoPoint5;
            GeoPoint geoPoint6 = list.get(i);
            if (!GeoSegment._isNearby(geoPoint6, geoPoint5 = list.get(i + 1), geoPoint, d) || !((d3 = (geoPoint4 = (geoVector6 = (geoVector5 = (geoVector4 = (geoVector3 = new GeoVector(geoPoint6)).crossProduct(geoVector2 = new GeoVector(geoPoint5))).crossProduct(geoVector)).crossProduct(geoVector4)).getGeoPoint()).kilometersToPoint(geoPoint)) < d2)) continue;
            geoPoint3 = geoPoint4;
            d2 = d3;
            n = i;
        }
        return geoPoint3;
    }

    public double kilometersTravelledToPoint(GeoPoint geoPoint) {
        return GeoSegment.kilometersTravelledToPoint(geoPoint, this.getGeoPoints(), this.getRadiusKilometers());
    }

    public static double kilometersTravelledToPoint(GeoPoint geoPoint, List<GeoPoint> list, double d) {
        if (geoPoint == null || !geoPoint.isValid()) {
            return 0.0;
        }
        if (list == null || list.size() == 0) {
            return 0.0;
        }
        if (list.size() == 1) {
            return geoPoint.kilometersToPoint(list.get(0));
        }
        GeoPoint geoPoint2 = null;
        double d2 = 40030.22888407185;
        int n = 0;
        GeoVector geoVector = new GeoVector(geoPoint);
        int n2 = list.size() - 1;
        for (int i = 0; i < n2; ++i) {
            GeoVector geoVector2;
            GeoVector geoVector3;
            GeoVector geoVector4;
            GeoVector geoVector5;
            GeoVector geoVector6;
            GeoPoint geoPoint3;
            double d3;
            GeoPoint geoPoint4;
            GeoPoint geoPoint5 = list.get(i);
            if (!GeoSegment._isNearby(geoPoint5, geoPoint4 = list.get(i + 1), geoPoint, d) || !((d3 = (geoPoint3 = (geoVector6 = (geoVector5 = (geoVector4 = (geoVector3 = new GeoVector(geoPoint5)).crossProduct(geoVector2 = new GeoVector(geoPoint4))).crossProduct(geoVector)).crossProduct(geoVector4)).getGeoPoint()).kilometersToPoint(geoPoint)) < d2)) continue;
            geoPoint2 = geoPoint3;
            d2 = d3;
            n = i;
        }
        if (n >= 0) {
            double d4 = GeoSegment.getLengthKilometers(list, n);
            return d4 += list.get(n).kilometersToPoint(geoPoint2);
        }
        return 0.0;
    }

    public boolean isTravellingForward(GeoPoint geoPoint, double d) {
        return GeoSegment.getDirectionOfTravel(geoPoint, d, this.getGeoPoints(), this.getRadiusKilometers()) == 1;
    }

    public static boolean isTravellingForward(GeoPoint geoPoint, double d, List<GeoPoint> list, double d2) {
        return GeoSegment.getDirectionOfTravel(geoPoint, d, list, d2) == 1;
    }

    public static int getDirectionOfTravel(GeoPoint geoPoint, double d, List<GeoPoint> list, double d2) {
        if (list == null || geoPoint == null || !geoPoint.isValid()) {
            return -1;
        }
        int n = list.size() - 1;
        for (int i = 0; i < n; ++i) {
            double d3;
            double d4;
            GeoPoint geoPoint2;
            GeoPoint geoPoint3 = list.get(i);
            if (!GeoSegment._isNearby(geoPoint3, geoPoint2 = list.get(i + 1), geoPoint, d2)) continue;
            if (i + 1 < n && geoPoint.kilometersToPoint(geoPoint2) <= d2) {
                GeoPoint geoPoint4 = list.get(i + 2);
                double d5 = GeoSegment._radiansToGreatCircle(geoPoint3, geoPoint2, geoPoint);
                double d6 = GeoSegment._radiansToGreatCircle(geoPoint2, geoPoint4, geoPoint);
                if (d6 < d5) continue;
            }
            return Math.abs(d4 = (d3 = geoPoint3.headingToPoint(geoPoint2)) - d) <= 90.0 ? 1 : -1;
        }
        return 0;
    }

    public boolean containsPoint(GeoPoint geoPoint) {
        return this.containsPoint(geoPoint, this.getRadiusKilometers());
    }

    public boolean containsPoint(GeoPoint geoPoint, double d) {
        return GeoSegment.containsPoint(geoPoint, this.getGeoPoints(), d);
    }

    public static boolean containsPoint(GeoPoint geoPoint, List<GeoPoint> list, double d) {
        if (list == null || geoPoint == null || !geoPoint.isValid()) {
            return false;
        }
        int n = list.size() - 1;
        for (int i = 0; i < n; ++i) {
            GeoPoint geoPoint2;
            GeoPoint geoPoint3 = list.get(i);
            if (!GeoSegment._isNearby(geoPoint3, geoPoint2 = list.get(i + 1), geoPoint, d)) continue;
            return true;
        }
        return false;
    }

    private static boolean _isNearby(GeoPoint geoPoint, GeoPoint geoPoint2, GeoPoint geoPoint3, double d) {
        double d2 = geoPoint3.kilometersToPoint(geoPoint2);
        if (d2 <= d) {
            return true;
        }
        double d3 = geoPoint3.kilometersToPoint(geoPoint);
        if (d3 <= d) {
            return true;
        }
        double d4 = GeoSegment._radiansToGreatCircle(geoPoint, geoPoint2, geoPoint3);
        if (d4 < 0.0) {
            return false;
        }
        double d5 = d4 * 6371.0088;
        if (d5 > d) {
            return false;
        }
        double d6 = geoPoint.kilometersToPoint(geoPoint2);
        if (d3 <= d6 && d2 <= d6) {
            return true;
        }
        double d7 = d + d6;
        if (d3 > d7 || d2 > d7) {
            return false;
        }
        double d8 = Math.sqrt(GeoSegment.SQ(d) + GeoSegment.SQ(d6));
        return d3 <= d8 && d2 <= d8;
    }

    private static double _radiansToGreatCircle(GeoPoint geoPoint, GeoPoint geoPoint2, GeoPoint geoPoint3) {
        GeoVector geoVector = new GeoVector(geoPoint);
        GeoVector geoVector2 = new GeoVector(geoPoint2);
        GeoVector geoVector3 = new GeoVector(geoPoint3);
        GeoVector geoVector4 = geoVector.crossProduct(geoVector2).normalize();
        double d = geoVector3.dotProduct(geoVector4);
        return Math.abs(1.5707963267948966 - Math.acos(d));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        List<GeoPoint> list = this.getGeoPoints();
        if (list != null) {
            for (GeoPoint geoPoint : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(geoPoint);
            }
        } else {
            stringBuffer.append("<invalid>");
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        return new GeoSegment(this);
    }

    public static GeozoneChecker getGeozoneChecker() {
        if (geozoneCheck == null) {
            geozoneCheck = new GeozoneChecker(){

                public boolean containsPoint(GeoPoint geoPoint, GeoPoint[] geoPointArray, double d) {
                    AbstractList abstractList = ListTools.toListWrapper((Object[])geoPointArray);
                    return GeoSegment.containsPoint(geoPoint, abstractList, d);
                }
            };
        }
        return geozoneCheck;
    }
}

