/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.tables;

import java.util.Locale;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBProvider;
import org.opengts.rule.tables.Rule;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class RuleTrigger
extends DeviceRecord<RuleTrigger> {
    public static boolean CHECK_IS_ACTIVE = true;
    public static boolean ALLOW_CLEAR_ACTIVE = true;
    public static final String _TABLE_NAME = "RuleTrigger";
    public static final String FLD_ruleID = "ruleID";
    public static final String FLD_lastTriggerTime = "lastTriggerTime";
    public static final String FLD_actionMask = "actionMask";
    private static DBField[] FieldInfo = new DBField[]{AccountRecord.newField_accountID((boolean)true), DeviceRecord.newField_deviceID((boolean)true), new DBField("ruleID", String.class, DBField.TYPE_RULE_ID(), "Rule ID", "key=true"), new DBField("lastTriggerTime", Long.TYPE, "UINT32", "Last Trigger Time", "format=time"), new DBField("actionMask", Integer.TYPE, "UINT32", "Action Mask", "format=X2"), RuleTrigger.newField_isActive(), RuleTrigger.newField_lastUpdateTime(), RuleTrigger.newField_creationTime()};
    private static DBFactory<RuleTrigger> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_LIST = new String[]{"list"};

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<RuleTrigger> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)RuleTrigger.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, RuleTrigger.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
        }
        return factory;
    }

    public RuleTrigger() {
    }

    public RuleTrigger(Key key) {
        super((DeviceRecord.DeviceKey)key);
    }

    public static String getTableDescription(Locale locale) {
        I18N i18N = I18N.getI18N(RuleTrigger.class, (Locale)locale);
        return i18N.getString("RuleTrigger.description", "This table defines Device Trigger Rules.");
    }

    public String getRuleID() {
        String string = (String)this.getFieldValue(FLD_ruleID);
        return string != null ? string : "";
    }

    public long getLastTriggerTime() {
        Long l = (Long)this.getFieldValue(FLD_lastTriggerTime);
        return l != null ? l : 0L;
    }

    public void setLastTriggerTime(long l) {
        this.setFieldValue(FLD_lastTriggerTime, l >= 0L ? l : 0L);
    }

    public int getActionMask() {
        Integer n = (Integer)this.getFieldValue(FLD_actionMask);
        return n != null ? n : 0;
    }

    public void setActionMask(int n) {
        this.setFieldValue(FLD_actionMask, n >= 0 ? n : 0);
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getDeviceID() + "/" + this.getRuleID();
    }

    public void setCreationDefaultValues() {
        super.setRuntimeDefaultValues();
        this.setIsActive(false);
    }

    public static boolean exists(String string, String string2, String string3) throws DBException {
        if (string != null && string2 != null && string3 != null) {
            Key key = new Key(string, string2, string3);
            return key.exists();
        }
        return false;
    }

    public static RuleTrigger getRuleTrigger(String string, String string2, String string3) throws DBException {
        if (StringTools.isBlank((String)string)) {
            throw new DBException("AccountID is blank/null");
        }
        if (StringTools.isBlank((String)string2)) {
            throw new DBException("deviceID is blank/null");
        }
        if (StringTools.isBlank((String)string3)) {
            throw new DBException("RuleID is blank/null");
        }
        Key key = new Key(string, string2, string3);
        if (key.exists()) {
            return (RuleTrigger)key.getDBRecord(true);
        }
        return null;
    }

    public static RuleTrigger getRuleTrigger(Device device, String string) throws DBException {
        if (device == null) {
            throw new DBNotFoundException("Device not specified.");
        }
        String string2 = device.getAccountID();
        String string3 = device.getDeviceID();
        if (StringTools.isBlank((String)string)) {
            throw new DBException("RuleID is blank/null");
        }
        return RuleTrigger.getRuleTrigger(string2, string3, string);
    }

    public static long getLastRuleTriggerTime(Device device, String string) throws DBException {
        RuleTrigger ruleTrigger = RuleTrigger.getRuleTrigger(device, string);
        if (ruleTrigger == null) {
            return 0L;
        }
        if (CHECK_IS_ACTIVE && !ruleTrigger.isActive()) {
            return 0L;
        }
        return ruleTrigger.getLastTriggerTime();
    }

    public static RuleTrigger getRuleTrigger(Account account, String string) throws DBException {
        if (account == null) {
            throw new DBNotFoundException("Account not specified.");
        }
        String string2 = account.getAccountID();
        String string3 = "";
        if (StringTools.isBlank((String)string)) {
            throw new DBException("RuleID is blank/null");
        }
        return RuleTrigger.getRuleTrigger(string2, string3, string);
    }

    public static long getLastRuleTriggerTime(Account account, String string) throws DBException {
        RuleTrigger ruleTrigger = RuleTrigger.getRuleTrigger(account, string);
        if (ruleTrigger == null) {
            return 0L;
        }
        if (CHECK_IS_ACTIVE && !ruleTrigger.isActive()) {
            return 0L;
        }
        return ruleTrigger.getLastTriggerTime();
    }

    public static RuleTrigger setRuleTriggerTime(Device device, Rule rule, long l) {
        if (rule == null) {
            Print.logError((String)"Rule not specified.", (Object[])new Object[0]);
            return null;
        }
        String string = rule.getRuleID();
        if (device == null) {
            Print.logError((String)"Device not specified.", (Object[])new Object[0]);
            return null;
        }
        String string2 = device.getAccountID();
        String string3 = device.getDeviceID();
        if (StringTools.isBlank((String)string)) {
            Print.logError((String)"RuleID is blank.", (Object[])new Object[0]);
            return null;
        }
        RuleTrigger ruleTrigger = null;
        try {
            Key key = new Key(string2, string3, string);
            if (key.exists()) {
                ruleTrigger = (RuleTrigger)key.getDBRecord(true);
            } else {
                ruleTrigger = (RuleTrigger)key.getDBRecord();
                ruleTrigger.setDevice(device);
                ruleTrigger.setCreationDefaultValues();
            }
        }
        catch (DBException dBException) {
            Print.logError((String)("Error reading RuleTrigger: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return null;
        }
        ruleTrigger.setIsActive(true);
        ruleTrigger.setActionMask(rule.getActionMask());
        if (l > 0L) {
            ruleTrigger.setLastTriggerTime(l);
        } else {
            ruleTrigger.setLastTriggerTime(DateTime.getCurrentTimeSec());
        }
        try {
            ruleTrigger.save();
        }
        catch (DBException dBException) {
            Print.logError((String)("Error saving RuleTrigger: " + (Object)((Object)dBException)), (Object[])new Object[0]);
        }
        return ruleTrigger;
    }

    public static RuleTrigger setRuleTriggerTime(Account account, Rule rule, long l) {
        if (rule == null) {
            Print.logError((String)"Rule not specified.", (Object[])new Object[0]);
            return null;
        }
        String string = rule.getRuleID();
        if (account == null) {
            Print.logError((String)"Account not specified.", (Object[])new Object[0]);
            return null;
        }
        String string2 = account.getAccountID();
        String string3 = "";
        if (StringTools.isBlank((String)string)) {
            Print.logError((String)"RuleID is blank.", (Object[])new Object[0]);
            return null;
        }
        RuleTrigger ruleTrigger = null;
        try {
            Key key = new Key(string2, string3, string);
            if (key.exists()) {
                ruleTrigger = (RuleTrigger)key.getDBRecord(true);
            } else {
                ruleTrigger = (RuleTrigger)key.getDBRecord();
                ruleTrigger.setAccount(account);
                ruleTrigger.setCreationDefaultValues();
            }
        }
        catch (DBException dBException) {
            Print.logError((String)("Error reading RuleTrigger: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return null;
        }
        ruleTrigger.setIsActive(true);
        ruleTrigger.setActionMask(rule.getActionMask());
        if (l > 0L) {
            ruleTrigger.setLastTriggerTime(l);
        } else {
            ruleTrigger.setLastTriggerTime(DateTime.getCurrentTimeSec());
        }
        try {
            ruleTrigger.save();
        }
        catch (DBException dBException) {
            Print.logError((String)("Error saving RuleTrigger: " + (Object)((Object)dBException)), (Object[])new Object[0]);
        }
        return ruleTrigger;
    }

    public static boolean clearRuleTriggerTime(Device device, Rule rule) {
        if (!ALLOW_CLEAR_ACTIVE) {
            return false;
        }
        if (rule == null) {
            Print.logError((String)"Rule not specified.", (Object[])new Object[0]);
            return false;
        }
        String string = rule.getRuleID();
        if (device == null) {
            Print.logError((String)"Device not specified.", (Object[])new Object[0]);
            return false;
        }
        String string2 = device.getAccountID();
        String string3 = device.getDeviceID();
        if (StringTools.isBlank((String)string)) {
            Print.logError((String)"RuleID is blank.", (Object[])new Object[0]);
            return false;
        }
        Key key = null;
        try {
            key = new Key(string2, string3, string);
            if (!key.exists()) {
                return false;
            }
        }
        catch (DBException dBException) {
            Print.logError((String)("Error checking RuleTrigger existance: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return false;
        }
        try {
            RuleTrigger ruleTrigger = (RuleTrigger)key.getDBRecord(true);
            ruleTrigger.setIsActive(false);
            ruleTrigger.update(new String[]{"isActive"});
            return true;
        }
        catch (DBException dBException) {
            Print.logError((String)("Error saving cleared RuleTrigger" + (Object)((Object)dBException)), (Object[])new Object[0]);
            return false;
        }
    }

    public static boolean clearRuleTriggerTime(Account account, Rule rule) {
        if (!ALLOW_CLEAR_ACTIVE) {
            return false;
        }
        if (rule == null) {
            Print.logError((String)"Rule not specified.", (Object[])new Object[0]);
            return false;
        }
        String string = rule.getRuleID();
        if (account == null) {
            Print.logError((String)"Account not specified.", (Object[])new Object[0]);
            return false;
        }
        String string2 = account.getAccountID();
        String string3 = "";
        if (StringTools.isBlank((String)string)) {
            Print.logError((String)"RuleID is blank.", (Object[])new Object[0]);
            return false;
        }
        Key key = null;
        try {
            key = new Key(string2, string3, string);
            if (!key.exists()) {
                return false;
            }
        }
        catch (DBException dBException) {
            Print.logError((String)("Error checking RuleTrigger existance: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return false;
        }
        try {
            RuleTrigger ruleTrigger = (RuleTrigger)key.getDBRecord(true);
            ruleTrigger.setIsActive(false);
            ruleTrigger.update(new String[]{"isActive"});
            return true;
        }
        catch (DBException dBException) {
            Print.logError((String)("Error saving cleared RuleTrigger" + (Object)((Object)dBException)), (Object[])new Object[0]);
            return false;
        }
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + RuleTrigger.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>      Account ID to list", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<id>       Device ID to list", (Object[])new Object[0]);
        Print.logInfo((String)"  -list              List rule triggers", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        DBConfig.cmdLineInit((String[])stringArray, (boolean)true);
        String string = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String string2 = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        if (StringTools.isBlank((String)string)) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            RuleTrigger.usage();
        }
        if (StringTools.isBlank((String)string2)) {
            Print.logError((String)"Device-ID not specified.", (Object[])new Object[0]);
            RuleTrigger.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount((String)string);
            if (account == null) {
                Print.logError((String)("Account-ID does not exist: " + string), (Object[])new Object[0]);
                RuleTrigger.usage();
            }
        }
        catch (DBException dBException) {
            Print.logException((String)("Error loading Account: " + string), (Throwable)dBException);
            System.exit(99);
        }
        Device device = null;
        try {
            device = Device.getDevice((Account)account, (String)string2, (boolean)false);
            if (device == null) {
                Print.logError((String)("Device-ID does not exist: " + string2), (Object[])new Object[0]);
                RuleTrigger.usage();
            }
        }
        catch (DBException dBException) {
            Print.logError((String)("Error getting Device: " + string + "/" + string2), (Object[])new Object[0]);
            dBException.printException();
            System.exit(99);
        }
        int n = 0;
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            ++n;
            Print.logInfo((String)"'-list' not yet supported", (Object[])new Object[0]);
            System.exit(0);
        }
        if (n == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            RuleTrigger.usage();
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<RuleTrigger> {
        public Key() {
        }

        public Key(String string, String string2, String string3) {
            super.setKeyValue("accountID", (Object)(string != null ? string.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)(string2 != null ? string2.toLowerCase() : ""));
            super.setKeyValue(RuleTrigger.FLD_ruleID, (Object)(string3 != null ? string3.toLowerCase() : ""));
        }

        public DBFactory<RuleTrigger> getFactory() {
            return RuleTrigger.getFactory();
        }
    }
}

