/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.tables;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.GroupRecord;
import org.opengts.db.RuleFactory;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.DeviceGroup;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBDelete;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.rule.EventRuleFactory;
import org.opengts.rule.tables.Rule;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class RuleList
extends DeviceRecord<RuleList> {
    public static final int ALL_CODES = 0;
    public static final String ALL_DEVICES = "*";
    public static final String[] ALL_DEVICES_ARRAY = new String[]{"*"};
    public static final String NO_DEVICES = "-";
    public static final String ALL_GROUPS = "*";
    public static final String[] ALL_GROUPS_ARRAY = new String[]{"*"};
    public static final String NO_GROUPS = "-";
    private static int IncludeDeviceGroupRules = -1;
    public static final String _TABLE_NAME = "RuleList";
    public static final String FLD_statusCode = "statusCode";
    public static final String FLD_ruleID = "ruleID";
    public static final String FLD_groupID = "groupID";
    private static DBField[] FieldInfo = new DBField[]{AccountRecord.newField_accountID((boolean)true), DeviceRecord.newField_deviceID((boolean)true), GroupRecord.newField_groupID((boolean)true), new DBField("statusCode", Integer.TYPE, "UINT32", "Status Code", "key=true editor=statusCode dftval=0"), new DBField("ruleID", String.class, DBField.TYPE_RULE_ID(), "Rule ID", "key=true"), RuleList.newField_lastUpdateTime(), RuleList.newField_lastUpdateUser((boolean)true), RuleList.newField_creationTime()};
    private static DBFactory<RuleList> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_GROUP = new String[]{"group", "grp"};
    private static final String[] ARG_CODE = new String[]{"code"};
    private static final String[] ARG_RULE = new String[]{"rule"};
    private static final String[] ARG_ADD = new String[]{"add"};
    private static final String[] ARG_REMOVE = new String[]{"remove", "delete"};
    private static final String[] ARG_DEVRULES = new String[]{"devRules"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_EXISTS = new String[]{"exists"};
    private static final String[] ARG_CRON = new String[]{"cron"};

    public static boolean IncludeDeviceGroupRules() {
        if (IncludeDeviceGroupRules < 0) {
            boolean bl = RTConfig.getBoolean((String)"RuleList.includeGroupRules", (boolean)false);
            if (bl && !RuleList.getFactory().hasField(FLD_groupID)) {
                Print.logWarn((String)"\"RuleList.includeGroupRules=true\" specified, but 'RuleList' table does not have 'groupID' column enabled", (Object[])new Object[0]);
                bl = false;
            }
            IncludeDeviceGroupRules = bl ? 1 : 0;
        }
        return IncludeDeviceGroupRules == 1;
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<RuleList> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)RuleList.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, RuleList.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
            factory.addParentTable(Rule.TABLE_NAME());
            factory.setFieldDefaultValue("deviceID", (Object)"-");
            factory.setFieldDefaultValue(FLD_groupID, (Object)"-");
            factory.setFieldDefaultValue(FLD_statusCode, (Object)new Integer(0));
        }
        return factory;
    }

    public RuleList() {
    }

    public RuleList(Key key) {
        super((DeviceRecord.DeviceKey)key);
    }

    public static String getTableDescription(Locale locale) {
        I18N i18N = I18N.getI18N(RuleList.class, (Locale)locale);
        return i18N.getString("RuleList.description", "This table defines Device and StatusCode specific Rule associations.");
    }

    public void setDeviceID(String string) {
        super.setDeviceID(StringTools.isBlank((String)string) ? "-" : string);
    }

    public String getGroupID() {
        String string = (String)this.getFieldValue(FLD_groupID);
        return StringTools.trim((String)string);
    }

    public void setGroupID(String string) {
        this.setFieldValue(FLD_groupID, StringTools.isBlank((String)string) ? "-" : StringTools.trim((String)string));
    }

    public int getStatusCode() {
        Integer n = (Integer)this.getFieldValue(FLD_statusCode);
        return n != null ? n : 0;
    }

    public String getRuleID() {
        String string = (String)this.getFieldValue(FLD_ruleID);
        return string != null ? string : "";
    }

    public String toString() {
        String string = "/";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getAccountID());
        stringBuffer.append(string);
        stringBuffer.append(this.getDeviceID());
        stringBuffer.append(string);
        stringBuffer.append("0x").append(StringTools.toHexString((long)this.getStatusCode(), (int)16));
        stringBuffer.append(string);
        stringBuffer.append(this.getRuleID());
        return stringBuffer.toString();
    }

    public void setCreationDefaultValues() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection<RuleList> getRuleList(String string, String string2, long l) throws DBException {
        Statement statement;
        DBConnection dBConnection;
        Vector<RuleList> vector;
        block19: {
            if (StringTools.isBlank((String)string)) {
                return null;
            }
            vector = new Vector<RuleList>();
            dBConnection = null;
            statement = null;
            ResultSet resultSet = null;
            try {
                DBSelect dBSelect = new DBSelect(RuleList.getFactory());
                DBWhere dBWhere = dBSelect.createDBWhere();
                if (!StringTools.isBlank((String)string2)) {
                    dBSelect.setWhere(dBWhere.WHERE_(dBWhere.AND(dBWhere.EQ("accountID", (Object)string), dBWhere.EQ(FLD_ruleID, (Object)string2))));
                } else {
                    dBSelect.setWhere(dBWhere.WHERE_(dBWhere.EQ("accountID", (Object)string)));
                }
                dBSelect.setOrderByFields(new String[]{FLD_ruleID});
                dBSelect.setLimit(l);
                dBConnection = DBConnection.getDefaultConnection();
                statement = dBConnection.execute(dBSelect.toString());
                resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    String string3 = resultSet.getString("accountID");
                    String string4 = resultSet.getString("deviceID");
                    String string5 = resultSet.getString(FLD_groupID);
                    int n = resultSet.getInt(FLD_statusCode);
                    String string6 = resultSet.getString(FLD_ruleID);
                    RuleList ruleList = new RuleList(new Key(string3, string4, string5, n, string6));
                    ruleList.setAllFieldValues(resultSet);
                    vector.add(ruleList);
                }
                if (resultSet == null) break block19;
            }
            catch (SQLException sQLException) {
                try {
                    throw new DBException("Getting Account/Rule RuleList", (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dBConnection);
                    throw throwable;
                }
            }
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dBConnection);
        return vector;
    }

    public static Collection<String> getRulesForDevice(Device device, int n) throws DBException {
        if (device != null) {
            String string = device.getAccountID();
            String string2 = device.getDeviceID();
            return RuleList.getRulesForDevice(string, string2, false, n);
        }
        return null;
    }

    protected static Collection<String> getRulesForDevice(String string, String string2, boolean bl, int n) throws DBException {
        String string3;
        DBWhere dBWhere;
        Object object;
        if (StringTools.isBlank((String)string)) {
            return null;
        }
        if (StringTools.isBlank((String)string2)) {
            string2 = "*";
        }
        if (n <= 0 || n == 0) {
            n = 0;
        }
        HashSet<String> hashSet = new HashSet<String>();
        DBConnection dBConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            object = new DBSelect(RuleList.getFactory());
            object.setSelectedFields(new String[]{FLD_ruleID});
            dBWhere = object.createDBWhere();
            object.setWhere(dBWhere.WHERE_(dBWhere.AND(dBWhere.EQ("accountID", (Object)string), string2.equals("*") ? dBWhere.EQ("deviceID", (Object)"*") : dBWhere.OR(dBWhere.EQ("deviceID", (Object)"*"), dBWhere.EQ("deviceID", (Object)string2)), bl ? null : (n == 0 ? dBWhere.EQ(FLD_statusCode, 0) : dBWhere.OR(dBWhere.EQ(FLD_statusCode, 0), dBWhere.EQ(FLD_statusCode, n))))));
            object.setOrderByFields(new String[]{FLD_ruleID});
            dBConnection = DBConnection.getDefaultConnection();
            statement = dBConnection.execute(object.toString());
            resultSet = statement.getResultSet();
            while (resultSet.next()) {
                string3 = resultSet.getString(FLD_ruleID);
                hashSet.add(string3);
            }
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException("Getting Account/Device RuleList", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                DBConnection.release(dBConnection, statement, resultSet);
                throw throwable;
            }
        }
        DBConnection.release((DBConnection)dBConnection, (Statement)statement, (ResultSet)resultSet);
        if (RuleList.IncludeDeviceGroupRules() && !string2.equals("*")) {
            dBConnection = null;
            statement = null;
            resultSet = null;
            try {
                object = DeviceGroup.getDeviceGroupsForDevice((String)string, (String)string2);
                if (!ListTools.isEmpty((Collection)object)) {
                    dBWhere = new DBSelect(RuleList.getFactory());
                    dBWhere.setSelectedFields(new String[]{FLD_ruleID});
                    string3 = dBWhere.createDBWhere();
                    string3.append(string3.EQ("accountID", (Object)string));
                    string3.append(string3.AND_(string3.INLIST(FLD_groupID, (Iterable)object)));
                    if (!bl) {
                        string3.append(string3.AND_(n == 0 ? string3.EQ(FLD_statusCode, 0) : string3.OR(string3.EQ(FLD_statusCode, 0), string3.EQ(FLD_statusCode, n))));
                    }
                    dBWhere.setWhere(string3.WHERE_(string3.toString()));
                    dBWhere.setOrderByFields(new String[]{FLD_ruleID});
                    dBConnection = DBConnection.getDefaultConnection();
                    statement = dBConnection.execute(dBWhere.toString());
                    resultSet = statement.getResultSet();
                    while (resultSet.next()) {
                        String string4 = resultSet.getString(FLD_ruleID);
                        hashSet.add(string4);
                    }
                }
            }
            catch (SQLException sQLException) {
                throw new DBException("Getting Account/Device RuleList", (Throwable)sQLException);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Throwable throwable) {}
                }
                DBConnection.release((DBConnection)dBConnection);
            }
        }
        return hashSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] getStatusCodesForDeviceID(Rule rule, String string, boolean bl) throws DBException {
        Object object;
        Statement statement;
        DBConnection dBConnection;
        Vector<Integer> vector;
        block20: {
            if (rule == null) {
                Print.logWarn((String)"Specified Rule is null!", (Object[])new Object[0]);
                return null;
            }
            String string2 = rule.getAccountID();
            String string3 = rule.getRuleID();
            if (StringTools.isBlank((String)string)) {
                string = "*";
            }
            vector = new Vector<Integer>();
            dBConnection = null;
            statement = null;
            ResultSet resultSet = null;
            try {
                object = new DBSelect(RuleList.getFactory());
                object.setSelectedFields(new String[]{FLD_statusCode});
                DBWhere dBWhere = object.createDBWhere();
                object.setWhere(dBWhere.WHERE_(dBWhere.AND(dBWhere.EQ("accountID", (Object)string2), string.equals("*") || bl ? dBWhere.EQ("deviceID", (Object)string) : dBWhere.OR(dBWhere.EQ("deviceID", (Object)"*"), dBWhere.EQ("deviceID", (Object)string)), dBWhere.EQ(FLD_ruleID, (Object)string3))));
                object.setOrderByFields(new String[]{FLD_statusCode});
                dBConnection = DBConnection.getDefaultConnection();
                statement = dBConnection.execute(object.toString());
                resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    int n = resultSet.getInt(FLD_statusCode);
                    vector.add(new Integer(n));
                }
                if (resultSet == null) break block20;
            }
            catch (SQLException sQLException) {
                try {
                    throw new DBException("Getting Account/Device RuleList", (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dBConnection);
                    throw throwable;
                }
            }
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dBConnection);
        object = new int[vector.size()];
        int i = 0;
        while (i < vector.size()) {
            object[i] = (DBSelect)((Integer)vector.get(i));
            ++i;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getDeviceIDsForStatusCode(Rule rule, int n, boolean bl) throws DBException {
        Statement statement;
        DBConnection dBConnection;
        Vector<String> vector;
        boolean bl2;
        block20: {
            if (rule == null) {
                Print.logWarn((String)"Specified Rule is null!", (Object[])new Object[0]);
                return null;
            }
            String string = rule.getAccountID();
            String string2 = rule.getRuleID();
            if (n < 0) {
                n = 0;
            }
            bl2 = false;
            vector = new Vector<String>();
            dBConnection = null;
            statement = null;
            ResultSet resultSet = null;
            try {
                DBSelect dBSelect = new DBSelect(RuleList.getFactory());
                dBSelect.setSelectedFields(new String[]{FLD_statusCode});
                DBWhere dBWhere = dBSelect.createDBWhere();
                dBSelect.setWhere(dBWhere.WHERE_(dBWhere.AND(dBWhere.EQ("accountID", (Object)string), n == 0 || bl ? dBWhere.EQ(FLD_statusCode, n) : dBWhere.OR(dBWhere.EQ(FLD_statusCode, 0), dBWhere.EQ(FLD_statusCode, n)), dBWhere.EQ(FLD_ruleID, (Object)string2))));
                dBSelect.setOrderByFields(new String[]{"deviceID"});
                dBConnection = DBConnection.getDefaultConnection();
                statement = dBConnection.execute(dBSelect.toString());
                resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    String string3 = resultSet.getString("deviceID");
                    if ("*".equals(string3)) {
                        bl2 = true;
                        break;
                    }
                    vector.add(string3);
                }
                if (resultSet == null) break block20;
            }
            catch (SQLException sQLException) {
                try {
                    throw new DBException("Getting Account/StatusCode RuleList", (Throwable)sQLException);
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dBConnection);
                    throw throwable;
                }
            }
            try {
                resultSet.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dBConnection);
        if (!bl2) {
            return vector.toArray(new String[vector.size()]);
        }
        return ALL_DEVICES_ARRAY;
    }

    public static void deleteRules(String string, String string2, String string3, String string4, int n) throws DBException {
        DBConnection dBConnection = null;
        try {
            Key key = new Key();
            key.setFieldValue("accountID", string);
            key.setFieldValue(FLD_ruleID, string2);
            if (!StringTools.isBlank((String)string3)) {
                key.setFieldValue("deviceID", string3);
            }
            if (!StringTools.isBlank((String)string4)) {
                key.setFieldValue(FLD_groupID, string4);
            }
            if (n >= 0) {
                key.setFieldValue(FLD_statusCode, n);
            }
            if (!key.exists(DBWhere.KEY_PARTIAL_ALL)) {
                Print.logWarn((String)("RuleList Key does not exist: " + (Object)((Object)key) + " (attempting delete anyway)"), (Object[])new Object[0]);
            }
            DBDelete dBDelete = new DBDelete(RuleList.getFactory());
            dBDelete.setWhere(key.getWhereClause(DBWhere.KEY_PARTIAL_ALL));
            dBConnection = DBConnection.getDefaultConnection();
            dBConnection.executeUpdate(dBDelete.toString());
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException("Deleting Rules", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                DBConnection.release(dBConnection);
                throw throwable;
            }
        }
        DBConnection.release((DBConnection)dBConnection);
    }

    public static void deleteRules(String string, String string2) throws DBException {
        DBConnection dBConnection = null;
        try {
            Key key = new Key();
            key.setFieldValue("accountID", string);
            key.setFieldValue(FLD_ruleID, string2);
            DBDelete dBDelete = new DBDelete(RuleList.getFactory());
            dBDelete.setWhere(key.getWhereClause(DBWhere.KEY_PARTIAL_ALL));
            dBConnection = DBConnection.getDefaultConnection();
            dBConnection.executeUpdate(dBDelete.toString());
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException("Deleting Rules", (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                DBConnection.release(dBConnection);
                throw throwable;
            }
        }
        DBConnection.release((DBConnection)dBConnection);
    }

    public static boolean clearRuleListEntries(String string, String string2) {
        try {
            RuleList.deleteRules(string, string2);
            return true;
        }
        catch (DBException dBException) {
            Print.logException((String)"Error deleting existing Rule entries from the RuleList table", (Throwable)dBException);
            return false;
        }
    }

    public static boolean setSingleGroupRuleListEntry(String string, String string2, String string3, int n) {
        if (StringTools.isBlank((String)string3)) {
            string3 = "*";
        }
        if (n <= 0) {
            n = 0;
        }
        if (!RuleList.clearRuleListEntries(string, string2)) {
            return false;
        }
        if (!string3.equals("-")) {
            Key key = new Key(string, null, string3, n, string2);
            try {
                if (key.exists()) {
                    Print.logWarn((String)("RuleList entry already exists: " + (Object)((Object)key)), (Object[])new Object[0]);
                } else {
                    RuleList ruleList = (RuleList)key.getDBRecord();
                    ruleList.setCreationDefaultValues();
                    ruleList.save();
                }
                return true;
            }
            catch (DBException dBException) {
                Print.logException((String)("Error adding Group RuleList entry: " + (Object)((Object)key)), (Throwable)dBException);
                return false;
            }
        }
        return true;
    }

    public static boolean setSingleDeviceRuleListEntry(String string, String string2, String string3, int n) {
        if (StringTools.isBlank((String)string3)) {
            string3 = "*";
        }
        if (n <= 0) {
            n = 0;
        }
        if (!RuleList.clearRuleListEntries(string, string2)) {
            return false;
        }
        if (!string3.equals("-")) {
            Key key = new Key(string, string3, null, n, string2);
            try {
                if (key.exists()) {
                    Print.logWarn((String)("RuleList entry already exists: " + (Object)((Object)key)), (Object[])new Object[0]);
                } else {
                    RuleList ruleList = (RuleList)key.getDBRecord();
                    ruleList.setCreationDefaultValues();
                    ruleList.save();
                }
                return true;
            }
            catch (DBException dBException) {
                Print.logException((String)("Error adding Device RuleList entry: " + (Object)((Object)key)), (Throwable)dBException);
                return false;
            }
        }
        return true;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + RuleList.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>      Acount ID which owns RuleList", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<id>       Device ID which owns RuleList", (Object[])new Object[0]);
        Print.logInfo((String)"  -group=<id>        Group ID which owns RuleList", (Object[])new Object[0]);
        Print.logInfo((String)"  -code=<code>       Status Code", (Object[])new Object[0]);
        Print.logInfo((String)"  -rule=<id>         Rule ID", (Object[])new Object[0]);
        Print.logInfo((String)"  -add               Add specified Rule to RuleList", (Object[])new Object[0]);
        Print.logInfo((String)"  -remove            Remove specified Rule from RuleList", (Object[])new Object[0]);
        Print.logInfo((String)"  -devRules[=all]    List Device Rules", (Object[])new Object[0]);
        Print.logInfo((String)"  -list              List RuleList entries", (Object[])new Object[0]);
        Print.logInfo((String)"  -exists            Checks for existance of partially specified keys", (Object[])new Object[0]);
        Print.logInfo((String)"  -cron[=true|false] True to list cron rules, False for non-cron rules", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Collection<Object> collection;
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        Device device;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        DBConfig.cmdLineInit((String[])stringArray, (boolean)true);
        String string = RTConfig.getString((String[])ARG_ACCOUNT, null);
        String string2 = RTConfig.getString((String[])ARG_DEVICE, null);
        String string3 = RTConfig.getString((String[])ARG_GROUP, null);
        int n = RTConfig.getInt((String[])ARG_CODE, (int)-1);
        String string4 = RTConfig.getString((String[])ARG_RULE, null);
        int n2 = -1;
        String string5 = RTConfig.getString((String[])ARG_CRON, null);
        if (string5 != null) {
            if (string5.equals("") || string5.equalsIgnoreCase("true")) {
                n2 = 1;
                RuleFactory ruleFactory = Device.getRuleFactory();
                if (ruleFactory instanceof EventRuleFactory) {
                    ((EventRuleFactory)ruleFactory).setCronMode(true);
                }
            } else if (string5.equalsIgnoreCase("false")) {
                n2 = 0;
            } else if (string5.equalsIgnoreCase("all")) {
                n2 = -1;
            }
        }
        boolean bl5 = n2 == 1;
        int n3 = 0;
        if (string == null || string.equals("")) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            RuleList.usage();
        }
        boolean bl6 = bl4 = !StringTools.isBlank((String)string2);
        if (bl4 && string2.startsWith("/")) {
            string2 = "*";
        }
        boolean bl7 = bl3 = !StringTools.isBlank((String)string3);
        if (bl3 && string3.startsWith("/")) {
            string3 = "*";
        }
        if (bl4 && bl3) {
            Print.logError((String)"'device' and 'group' specifications are mutually exclusive", (Object[])new Object[0]);
            RuleList.usage();
        }
        if (!(RTConfig.hasProperty((String[])ARG_LIST) || bl4 || bl3)) {
            Print.logError((String)"One of 'device' or 'group' must be specified", (Object[])new Object[0]);
            RuleList.usage();
        }
        boolean bl8 = bl2 = n >= 0;
        if (n > 0 && !StatusCodes.IsValid((int)n, null)) {
            Print.logError((String)"Invalid Status Code specified.", (Object[])new Object[0]);
            RuleList.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount((String)string);
            if (account == null) {
                Print.logError((String)("Account-ID does not exist: " + string), (Object[])new Object[0]);
                RuleList.usage();
            }
        }
        catch (DBException dBException) {
            Print.logException((String)("Error loading Account: " + string), (Throwable)dBException);
            System.exit(99);
        }
        if (bl4 && !string2.equals("*")) {
            try {
                device = Device.getDevice((Account)account, (String)string2);
                if (device == null) {
                    Print.logError((String)("Device-ID does not exist: " + string + "/" + string2), (Object[])new Object[0]);
                    RuleList.usage();
                }
            }
            catch (DBException dBException) {
                Print.logException((String)("Error loading Device: " + string + "/" + string2), (Throwable)dBException);
                System.exit(99);
            }
        }
        if (bl3 && !string3.equals("*")) {
            try {
                device = DeviceGroup.getDeviceGroup((Account)account, (String)string3);
                if (device == null) {
                    Print.logError((String)("Group-ID does not exist: " + string + "/" + string3), (Object[])new Object[0]);
                    RuleList.usage();
                }
            }
            catch (DBException dBException) {
                Print.logException((String)("Error loading DeviceGroup: " + string + "/" + string3), (Throwable)dBException);
                System.exit(99);
            }
        }
        boolean bl9 = bl = !StringTools.isBlank((String)string4);
        if (bl) {
            try {
                object3 = Rule.getRule(account, string4);
                if (object3 == null) {
                    Print.logError((String)("Rule-ID does not exist: " + string + "/" + string4), (Object[])new Object[0]);
                    RuleList.usage();
                }
            }
            catch (DBException dBException) {
                Print.logException((String)("Error loading Rule: " + string + "/" + string4), (Throwable)dBException);
                System.exit(99);
            }
        }
        object3 = new StringBuffer();
        ((StringBuffer)object3).append(string);
        ((StringBuffer)object3).append("/");
        ((StringBuffer)object3).append(bl4 ? string2 : "-");
        ((StringBuffer)object3).append("/");
        ((StringBuffer)object3).append(bl3 ? string3 : "-");
        ((StringBuffer)object3).append("/");
        ((StringBuffer)object3).append(n > 0 ? StatusCodes.GetHex((int)n) + "[" + StatusCodes.GetName((int)n, null) + "]" : "*");
        if (bl) {
            ((StringBuffer)object3).append("/");
            ((StringBuffer)object3).append(string4);
        }
        if (RTConfig.getBoolean((String[])ARG_EXISTS, (boolean)false)) {
            ++n3;
            object2 = new StringBuffer();
            object = new Key();
            object.setFieldValue("accountID", (Object)string);
            ((StringBuffer)object2).append("Account=").append(string);
            if (!StringTools.isBlank((String)string2)) {
                ((StringBuffer)object2).append(", Device=").append(string2);
                object.setFieldValue("deviceID", (Object)string2);
            }
            if (!StringTools.isBlank((String)string3)) {
                ((StringBuffer)object2).append(", Group=").append(string3);
                object.setFieldValue(FLD_groupID, (Object)string3);
            }
            if (n >= 0) {
                ((StringBuffer)object2).append(", StatusCode=").append(n);
                object.setFieldValue(FLD_statusCode, n);
            }
            if (!StringTools.isBlank((String)string4)) {
                ((StringBuffer)object2).append(", RuleID=").append(string4);
                object.setFieldValue(FLD_ruleID, (Object)string4);
            }
            try {
                Print.sysPrintln((String)("Exists Key: " + object2), (Object[])new Object[0]);
                if (object.exists(DBWhere.KEY_PARTIAL_ALL)) {
                    Print.sysPrintln((String)("RuleList Key found: " + object), (Object[])new Object[0]);
                } else {
                    Print.sysPrintln((String)("RuleList Key not found: " + object), (Object[])new Object[0]);
                }
            }
            catch (DBException dBException) {
                Print.logError((String)("Error finding RuleList entry: " + object), (Object[])new Object[0]);
                dBException.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_REMOVE, (boolean)false)) {
            ++n3;
            if (!bl) {
                Print.logError((String)"Rule-ID not specified.", (Object[])new Object[0]);
                RuleList.usage();
            } else if (!bl2) {
                Print.logError((String)"Status Code not specified.", (Object[])new Object[0]);
                RuleList.usage();
            }
            try {
                RuleList.deleteRules(string, string4, bl4 ? string2 : null, bl3 ? string3 : null, n);
            }
            catch (DBException dBException) {
                Print.logError((String)("Error deleting RuleList entry: " + object3), (Object[])new Object[0]);
                dBException.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_ADD, (boolean)false)) {
            ++n3;
            if (!bl) {
                Print.logError((String)"Rule-ID not specified.", (Object[])new Object[0]);
                RuleList.usage();
            } else if (!bl2) {
                Print.logError((String)"Status Code not specified.", (Object[])new Object[0]);
                RuleList.usage();
            }
            try {
                object2 = new Key(string, bl4 ? string2 : null, bl3 ? string3 : null, n, string4);
                if (object2.exists()) {
                    Print.logWarn((String)("RuleList entry already exists: " + object3), (Object[])new Object[0]);
                } else {
                    object = (RuleList)object2.getDBRecord();
                    ((RuleList)((Object)object)).setCreationDefaultValues();
                    object.save();
                    Print.logInfo((String)("Added RuleList entry: " + object3), (Object[])new Object[0]);
                }
            }
            catch (DBException dBException) {
                Print.logError((String)("Error adding RuleList entry: " + object3), (Object[])new Object[0]);
                dBException.printException();
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_DEVRULES)) {
            object2 = RTConfig.getString((String[])ARG_DEVRULES, (String)"");
            boolean bl10 = ((String)object2).equalsIgnoreCase("all");
            ++n3;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            try {
                if (bl4) {
                    Print.sysPrintln((String)("Account/Device/StatusCode: " + string + "/" + string2 + "/" + n), (Object[])new Object[0]);
                    collection = RuleList.getRulesForDevice(string, string2, bl10, n);
                    int n4 = 0;
                    for (String string6 : collection) {
                        Rule.Key key = new Rule.Key(string, string6);
                        Rule rule = key.exists() ? (Rule)key.getDBRecord(true) : null;
                        if (rule == null || !rule.isActive() || n2 >= 0 && bl5 != rule.getIsCronRule()) continue;
                        Print.sysPrintln((StringBuffer)Rule.listRule(rule, 2, null), (Object[])new Object[0]);
                        ++n4;
                    }
                    if (n4 == 0) {
                        Print.sysPrintln((String)"  No Rules", (Object[])new Object[0]);
                    }
                } else {
                    Print.sysPrintln((String)("Account Rules: " + string), (Object[])new Object[0]);
                    Print.sysPrintln((StringBuffer)Rule.listRules(string, null, 2, null), (Object[])new Object[0]);
                }
            }
            catch (DBException dBException) {
                Print.logError((String)("Error list Rules: " + string + "/" + string2 + "/" + n), (Object[])new Object[0]);
                dBException.printException();
                System.exit(99);
            }
        }
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            object2 = RTConfig.getString((String[])ARG_LIST, (String)"");
            boolean bl11 = ((String)object2).equalsIgnoreCase("all");
            ++n3;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            try {
                Print.sysPrintln((String)("Account: " + string), (Object[])new Object[0]);
                collection = RuleList.getRuleList(string, string4, -1L);
                for (Object object4 : collection) {
                    Print.sysPrintln((String)"  -------------------------------------------", (Object[])new Object[0]);
                    Print.sysPrintln((String)("  DeviceID  : " + object4.getDeviceID()), (Object[])new Object[0]);
                    Print.sysPrintln((String)("  GroupID   : " + ((RuleList)((Object)object4)).getGroupID()), (Object[])new Object[0]);
                    Print.sysPrintln((String)("  StatusCode: " + ((RuleList)((Object)object4)).getStatusCode()), (Object[])new Object[0]);
                    Print.sysPrintln((String)("  RuleID    : " + ((RuleList)((Object)object4)).getRuleID()), (Object[])new Object[0]);
                }
            }
            catch (DBException dBException) {
                Print.logError((String)("Error list Rules: " + string + "/" + string2 + "/" + n), (Object[])new Object[0]);
                dBException.printException();
                System.exit(99);
            }
        }
        if (n3 == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            RuleList.usage();
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<RuleList> {
        public Key() {
        }

        public Key(String string, String string2, String string3, int n, String string4) {
            String string5 = string2 != null ? string2.toLowerCase() : "-";
            String string6 = string3 != null ? string3.toLowerCase() : "-";
            super.setKeyValue("accountID", (Object)(string != null ? string.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)string5);
            super.setKeyValue(RuleList.FLD_groupID, (Object)string6);
            super.setKeyValue(RuleList.FLD_statusCode, n);
            super.setKeyValue(RuleList.FLD_ruleID, (Object)(string4 != null ? string4.toLowerCase() : ""));
        }

        public DBFactory<RuleList> getFactory() {
            return RuleList.getFactory();
        }
    }
}

