/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.tables;

import java.util.Locale;
import java.util.Random;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.StatusCode;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.rule.EventRuleAction;
import org.opengts.rule.NotificationMessage;
import org.opengts.rule.tables.Rule;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class NotifyQueue
extends DeviceRecord<NotifyQueue>
implements NotificationMessage {
    private static Random random = new Random();
    public static final String _TABLE_NAME = "NotifyQueue";
    public static final String FLD_timestamp = "timestamp";
    public static final String FLD_statusCode = "statusCode";
    public static final String FLD_messageID = "messageID";
    public static final String FLD_ruleID = "ruleID";
    public static final String FLD_priority = "priority";
    public static final String FLD_sender = "sender";
    public static final String FLD_recipients = "recipients";
    public static final String FLD_subject = "subject";
    public static final String FLD_message = "message";
    private static DBField[] FieldInfo = new DBField[]{AccountRecord.newField_accountID((boolean)true), DeviceRecord.newField_deviceID((boolean)true), new DBField("ruleID", String.class, DBField.TYPE_RULE_ID(), "Rule ID", "key=true"), new DBField("timestamp", Long.TYPE, "UINT32", "Timestamp", "key=true"), new DBField("statusCode", Integer.TYPE, "UINT32", "Status_Code", "key=true format=X2 editor=statusCode"), new DBField("messageID", String.class, DBField.TYPE_STRING((int)24), "Message_ID", "altkey=true"), new DBField("priority", Integer.TYPE, "UINT32", "Priority", "edit=2"), new DBField("sender", String.class, DBField.TYPE_STRING((int)64), "Sender", "edit=2"), new DBField("recipients", String.class, DBField.TYPE_STRING((int)256), "Recipients", "edit=2"), new DBField("subject", String.class, "TEXT", "Subject", "edit=2 utf8=true"), new DBField("message", String.class, "TEXT", "Message", "edit=2 utf8=true"), NotifyQueue.newField_lastUpdateTime(), NotifyQueue.newField_creationTime()};
    private static DBFactory<NotifyQueue> factory = null;
    private Rule rule = null;

    private static String CreateMessageID(long l) {
        long l2 = (long)random.nextInt() & 0xFFFFFFFFL;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(StringTools.toHexString((long)l, (int)32));
        stringBuffer.append(StringTools.toHexString((long)l2, (int)32));
        return stringBuffer.toString();
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<NotifyQueue> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)NotifyQueue.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, NotifyQueue.class, Key.class, (boolean)false, (boolean)false);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
        }
        return factory;
    }

    public NotifyQueue() {
    }

    public NotifyQueue(Key key) {
        super((DeviceRecord.DeviceKey)key);
    }

    public static String getTableDescription(Locale locale) {
        I18N i18N = I18N.getI18N(NotifyQueue.class, (Locale)locale);
        return i18N.getString("NotifyQueue.description", "This table contains Device specific queued notification messages. Rule-based notification messages may be placed in this table as an alternative to sending an email.  The 'Notification' servlet provides access to the messages within this table.");
    }

    public String getRuleID() {
        String string = (String)this.getFieldValue(FLD_ruleID);
        return string != null ? string : "";
    }

    public void setRuleID(String string) {
        this.setFieldValue(FLD_ruleID, string != null ? string : "");
    }

    public void setRule(Rule rule) {
        if (rule != null) {
            if (StringTools.isBlank((String)this.getRuleID())) {
                this.rule = rule;
                this.setRuleID(rule.getRuleID());
            } else if (rule.getRuleID().equals(this.getRuleID())) {
                this.rule = rule;
            } else {
                Print.logError((String)("Refusing to set 'Rule' with incompatible RuleID (expected:" + this.getRuleID() + " ==> found:" + rule.getRuleID() + ")"), (Object[])new Object[0]);
            }
        } else {
            this.rule = null;
        }
    }

    public Rule getRule() throws DBException {
        if (this.rule != null) {
            return this.rule;
        }
        if (!StringTools.isBlank((String)this.getRuleID())) {
            return Rule.getRule(this.getAccountID(), this.getRuleID());
        }
        return null;
    }

    @Override
    public long getTimestamp() {
        Long l = (Long)this.getFieldValue(FLD_timestamp);
        return l != null ? l : 0L;
    }

    public void setTimestamp(long l) {
        this.setFieldValue(FLD_timestamp, l);
    }

    @Override
    public String getTimestampString() {
        Account account = this.getAccount();
        String string = account != null ? account.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
        String string2 = account != null ? account.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat();
        DateTime dateTime = new DateTime(this.getTimestamp());
        return dateTime.gmtFormat(string + " " + string2 + " z");
    }

    @Override
    public int getStatusCode() {
        Integer n = (Integer)this.getFieldValue(FLD_statusCode);
        return n != null ? n : 0;
    }

    public void setStatusCode(int n) {
        this.setFieldValue(FLD_statusCode, n);
    }

    @Override
    public String getStatusCodeDescription(BasicPrivateLabel basicPrivateLabel) {
        int n;
        Device device = this.getDevice();
        String string = StatusCode.getDescription((Device)device, (int)(n = this.getStatusCode()), (BasicPrivateLabel)basicPrivateLabel, null);
        if (StringTools.isBlank((String)string)) {
            Print.logError((String)("StatusCode description is empty! : 0x" + StringTools.toHexString((long)n, (int)16)), (Object[])new Object[0]);
        }
        return string;
    }

    @Override
    public String getMessageID() {
        String string = (String)this.getFieldValue(FLD_messageID);
        return string != null ? string : "";
    }

    public void setMessageID(String string) {
        this.setFieldValue(FLD_messageID, string != null ? string : "");
    }

    public void setMessageID(long l) {
        this.setMessageID(NotifyQueue.CreateMessageID(l));
    }

    @Override
    public int getPriority() {
        Integer n = (Integer)this.getFieldValue(FLD_priority);
        return n != null ? n : 0;
    }

    public void setPriority(int n) {
        this.setFieldValue(FLD_priority, n);
    }

    @Override
    public String getSender() {
        String string = (String)this.getFieldValue(FLD_sender);
        return string != null ? string : "";
    }

    public void setSender(String string) {
        this.setFieldValue(FLD_sender, string != null ? string : "");
    }

    @Override
    public String getRecipients() {
        String string = (String)this.getFieldValue(FLD_recipients);
        return string != null ? string : "";
    }

    public void setRecipients(String string) {
        this.setFieldValue(FLD_recipients, string != null ? string : "");
    }

    @Override
    public String getSubject() {
        String string = (String)this.getFieldValue(FLD_subject);
        return string != null ? string : "";
    }

    public void setSubject(String string) {
        this.setFieldValue(FLD_subject, string != null ? string : "");
    }

    public String getMessage() {
        String string = (String)this.getFieldValue(FLD_message);
        return string != null ? string : "";
    }

    public void setMessage(String string) {
        this.setFieldValue(FLD_message, string != null ? string : "");
    }

    @Override
    public String getBody() {
        return this.getMessage();
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getDeviceID() + "/" + this.getTimestamp();
    }

    public static void getRecordCallback(String string, String string2, long l, long l2, DBRecordHandler<NotifyQueue> dBRecordHandler) throws DBException {
        if (StringTools.isBlank((String)string) || StringTools.isBlank((String)string2)) {
            return;
        }
        if (dBRecordHandler == null) {
            return;
        }
        DBWhere dBWhere = new DBWhere(NotifyQueue.getFactory());
        dBWhere.append(dBWhere.AND(dBWhere.EQ("accountID", (Object)string), dBWhere.EQ("deviceID", (Object)string2)));
        if (l >= 0L) {
            dBWhere.append(dBWhere.AND_(dBWhere.GE(FLD_timestamp, l)));
        }
        if (l2 >= 0L && l2 >= l) {
            dBWhere.append(dBWhere.AND_(dBWhere.LE(FLD_timestamp, l2)));
        }
        DBSelect dBSelect = new DBSelect(NotifyQueue.getFactory());
        dBSelect.setWhere(dBWhere.WHERE(dBWhere.toString()));
        dBSelect.setOrderByFields(new String[]{FLD_timestamp});
        dBSelect.setOrderAscending(true);
        DBRecord.select((DBSelect)dBSelect, dBRecordHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NotificationMessage[] getNotificationMessages(String string, String string2, int n, int n2) {
        String string3;
        DBWhere dBWhere = new DBWhere(NotifyQueue.getFactory());
        if (string != null && !string.equals("") && !string.equals("*")) {
            dBWhere.append(dBWhere.EQ("accountID", (Object)string));
            if (string2 != null && !string2.equals("") && !string2.equals("*")) {
                dBWhere.append(dBWhere.AND_(dBWhere.EQ("deviceID", (Object)string2)));
            }
            if (n > 0) {
                dBWhere.append(dBWhere.AND_(dBWhere.EQ(FLD_priority, n)));
            }
        } else if (n > 0) {
            dBWhere.append(dBWhere.EQ(FLD_priority, n));
        }
        if ((string3 = dBWhere.toString()).equals("")) {
            Print.logInfo((String)"NotifyQueue WHERE: <retrieving all messages>", (Object[])new Object[0]);
        } else {
            Print.logInfo((String)("NotifyQueue WHERE: " + dBWhere.toString()), (Object[])new Object[0]);
        }
        NotifyQueue[] notifyQueueArray = null;
        try {
            DBProvider.lockTables((String[])new String[]{NotifyQueue.TABLE_NAME()}, null);
            notifyQueueArray = (NotifyQueue[])DBRecord.select(NotifyQueue.getFactory(), (String)string3, null, (String[])new String[]{FLD_messageID}, (boolean)true, (long)n2, (long)-1L, null);
        }
        catch (DBException dBException) {
            notifyQueueArray = null;
            Print.logException((String)"Retrieving NotifyQueue records", (Throwable)dBException);
        }
        finally {
            try {
                DBProvider.unlockTables();
            }
            catch (DBException dBException) {}
        }
        return notifyQueueArray;
    }

    public static boolean deleteMessageID(String string) {
        try {
            Key key = new Key(string);
            if (key.altIndexExists("altIndex")) {
                key.altIndexDelete("altIndex");
                return true;
            }
            Print.logError((String)("MessageID does not exist: " + string), (Object[])new Object[0]);
            return false;
        }
        catch (DBException dBException) {
            Print.logException((String)("Unable to delete MessageID: " + string), (Throwable)dBException);
            return false;
        }
    }

    public void setCreationDefaultValues() {
    }

    public static void main(String[] stringArray) {
        DBConfig.cmdLineInit((String[])stringArray, (boolean)true);
        String string = "opendmtp";
        String string2 = "mobile";
        EventRuleAction._debugSendNotification(string, string2, 61472);
    }

    public static class Key
    extends DeviceRecord.DeviceKey<NotifyQueue> {
        public Key() {
        }

        public Key(String string, String string2, String string3, long l, int n) {
            super.setKeyValue("accountID", (Object)(string != null ? string.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)(string2 != null ? string2.toLowerCase() : ""));
            super.setKeyValue(NotifyQueue.FLD_ruleID, (Object)(string3 != null ? string3.toLowerCase() : ""));
            super.setKeyValue(NotifyQueue.FLD_timestamp, l);
            super.setKeyValue(NotifyQueue.FLD_statusCode, n);
            super.setKeyValue(NotifyQueue.FLD_messageID, (Object)NotifyQueue.CreateMessageID(l));
        }

        public Key(String string) {
            String string2;
            String string3 = string2 = string != null ? string.toUpperCase().trim() : "";
            if (!string2.equals("")) {
                super.setFieldValue(NotifyQueue.FLD_messageID, (Object)string2);
            } else {
                Print.logStackTrace((String)"Invalid Alternate Key MessageID specified!");
            }
        }

        public DBFactory<NotifyQueue> getFactory() {
            return NotifyQueue.getFactory();
        }
    }
}

