/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.tables;

import java.util.Locale;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.FuelManager;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class FuelRegister
extends DeviceRecord<FuelRegister> {
    private static boolean DEBUG_MODE = false;
    public static final String FLD_timestamp = "timestamp";
    public static final String FLD_statusCode = "statusCode";
    public static final String FLD_latitude = "latitude";
    public static final String FLD_longitude = "longitude";
    public static final String FLD_fuelLevel = "fuelLevel";
    public static final String FLD_deltaFuelLevel = "deltaFuelLevel";
    public static final String FLD_isIncrease = "isIncrease";
    public static final String FLD_fuelTotal = "fuelTotal";
    public static final String FLD_odometerKM = "odometerKM";
    public static final String FLD_subdivision = "subdivision";
    public static final String FLD_address = "address";
    private static DBField[] FieldInfo = new DBField[]{FuelRegister.newField_accountID((boolean)true), FuelRegister.newField_deviceID((boolean)true), new DBField("timestamp", Long.TYPE, "UINT32", "Timestamp", "key=true"), new DBField("statusCode", Integer.TYPE, "UINT32", "Status Code", "editor=statusCode format=X2"), new DBField("latitude", Double.TYPE, "DOUBLE", "Latitude", "format=#0.00000"), new DBField("longitude", Double.TYPE, "DOUBLE", "Longitude", "format=#0.00000"), new DBField("fuelLevel", Double.TYPE, "DOUBLE", "Fuel Level", "format=#0.00"), new DBField("deltaFuelLevel", Double.TYPE, "DOUBLE", "Delta Fuel Level", "format=#0.00"), new DBField("isIncrease", Boolean.TYPE, "BOOLEAN", "Is Fuel Increase", ""), new DBField("fuelTotal", Double.TYPE, "DOUBLE", "Total Fuel Used", "format=#0.0 units=volume"), new DBField("odometerKM", Double.TYPE, "DOUBLE", "Odometer KM", "format=#0.0 units=distance"), new DBField("subdivision", String.class, DBField.TYPE_STRING((int)32), "Subdivision", "utf8=true"), new DBField("address", String.class, DBField.TYPE_ADDRESS(), "Address", "utf8=true"), FuelRegister.newField_creationTime()};
    private static DBFactory<FuelRegister> factory = null;
    private EventData _cacheEventData = null;
    private static FuelManager fuelManager = null;
    private static final String[] ARG_TEST = new String[]{"test"};

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)"FuelRegister");
    }

    public static DBFactory<FuelRegister> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)FuelRegister.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, FuelRegister.class, Key.class, (boolean)false, (boolean)false);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
            FuelRegister.initFuelManager();
        }
        return factory;
    }

    public FuelRegister() {
    }

    public FuelRegister(Key key) {
        super((DeviceRecord.DeviceKey)key);
    }

    public static String getTableDescription(Locale locale) {
        I18N i18N = I18N.getI18N(FuelRegister.class, (Locale)locale);
        return i18N.getString("FuelRegister.description", "This table defines Fuel regsiter information.");
    }

    public long getTimestamp() {
        return this.getFieldValue(FLD_timestamp, 0L);
    }

    public void setTimestamp(long l) {
        this.setFieldValue(FLD_timestamp, l);
    }

    public String getTimestampString() {
        Account account = this.getAccount();
        String string = account != null ? account.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
        String string2 = account != null ? account.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat();
        DateTime dateTime = new DateTime(this.getTimestamp());
        return dateTime.gmtFormat(string + " " + string2 + " z");
    }

    public int getStatusCode() {
        return this.getFieldValue(FLD_statusCode, 0);
    }

    public void setStatusCode(int n) {
        this.setFieldValue(FLD_statusCode, n);
    }

    public double getLatitude() {
        return this.getFieldValue(FLD_latitude, 0.0);
    }

    public void setLatitude(double d) {
        this.setFieldValue(FLD_latitude, d);
    }

    public GeoPoint getGeoPoint() {
        return new GeoPoint(this.getLatitude(), this.getLongitude());
    }

    public void setGeoPoint(double d, double d2) {
        this.setLatitude(d);
        this.setLongitude(d2);
    }

    public void setGeoPoint(GeoPoint geoPoint) {
        if (geoPoint != null && geoPoint.isValid()) {
            this.setLatitude(geoPoint.getLatitude());
            this.setLongitude(geoPoint.getLongitude());
        } else {
            Print.logInfo((String)("GeoPoint is invalid: " + geoPoint), (Object[])new Object[0]);
            this.setLatitude(0.0);
            this.setLongitude(0.0);
        }
    }

    public boolean isValidGeoPoint() {
        return GeoPoint.isValid((double)this.getLatitude(), (double)this.getLongitude());
    }

    public double getLongitude() {
        return this.getFieldValue(FLD_longitude, 0.0);
    }

    public void setLongitude(double d) {
        this.setFieldValue(FLD_longitude, d);
    }

    public double getFuelLevel() {
        return this.getFieldValue(FLD_fuelLevel, 0.0);
    }

    public void setFuelLevel(double d) {
        double d2 = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
        this.setFieldValue(FLD_fuelLevel, d2);
    }

    public double getDeltaFuelLevel() {
        return this.getFieldValue(FLD_deltaFuelLevel, 0.0);
    }

    public void setDeltaFuelLevel(double d) {
        double d2 = d < 0.0 ? 0.0 : (d > 1.0 ? 1.0 : d);
        this.setFieldValue(FLD_deltaFuelLevel, d2);
    }

    public boolean getIsIncrease() {
        Boolean bl = (Boolean)this.getFieldValue(FLD_isIncrease);
        return bl != null ? bl : false;
    }

    public void setIsIncrease(boolean bl) {
        this.setFieldValue(FLD_isIncrease, bl);
    }

    public double getLastFuelLevel() {
        double d = this.getFuelLevel();
        double d2 = this.getDeltaFuelLevel();
        boolean bl = this.getIsIncrease();
        return d - d2;
    }

    public double getFuelTotal() {
        return this.getFieldValue(FLD_fuelTotal, 0.0);
    }

    public void setFuelTotal(double d) {
        this.setFieldValue(FLD_fuelTotal, d);
    }

    public double getOdometerKM() {
        return this.getFieldValue(FLD_odometerKM, 0.0);
    }

    public void setOdometerKM(double d) {
        this.setFieldValue(FLD_odometerKM, d);
    }

    public String getEventSubdivision(boolean bl) {
        String string = this.getSubdivision();
        if (StringTools.isBlank((String)string)) {
            EventData eventData = this.getEventData();
            String string2 = string = eventData != null ? eventData.getSubdivision() : "";
            if (!StringTools.isBlank((String)string)) {
                this.setSubdivision(string);
                if (bl) {
                    try {
                        this.update(new String[]{FLD_subdivision});
                    }
                    catch (DBException dBException) {
                        Print.logError((String)"Unable to get EventData address", (Object[])new Object[]{dBException});
                    }
                }
            }
        }
        return string;
    }

    public String getSubdivision() {
        String string = (String)this.getFieldValue(FLD_subdivision);
        return StringTools.trim((String)string);
    }

    public void setSubdivision(String string) {
        this.setFieldValue(FLD_subdivision, StringTools.trim((String)string));
    }

    public String getEventAddress(boolean bl) {
        String string = this.getAddress();
        if (StringTools.isBlank((String)string)) {
            EventData eventData = this.getEventData();
            String string2 = string = eventData != null ? eventData.getAddress() : "";
            if (!StringTools.isBlank((String)string)) {
                this.setAddress(string);
                if (bl) {
                    try {
                        this.update(new String[]{FLD_address});
                    }
                    catch (DBException dBException) {
                        Print.logError((String)"Unable to get EventData address", (Object[])new Object[]{dBException});
                    }
                }
            }
        }
        return string;
    }

    public String getAddress() {
        String string = (String)this.getFieldValue(FLD_address);
        return StringTools.trim((String)string);
    }

    public void setAddress(String string) {
        this.setFieldValue(FLD_address, StringTools.trim((String)string));
    }

    private void _setEventDataFields(EventData eventData, double d, boolean bl) {
        if (eventData == null) {
            return;
        }
        this.setStatusCode(eventData.getStatusCode());
        this.setLatitude(eventData.getLatitude());
        this.setLongitude(eventData.getLongitude());
        this.setOdometerKM(eventData.getOdometerKM());
        this.setAddress(eventData.getAddress());
        this.setSubdivision(eventData.getSubdivision());
        this.setFuelTotal(eventData.getFuelTotal());
        this.setFuelLevel(eventData.getFuelLevel(true));
        this.setDeltaFuelLevel(d);
        this.setIsIncrease(bl);
    }

    public EventData getEventData() {
        if (this._cacheEventData == null) {
            try {
                String string = this.getAccountID();
                String string2 = this.getDeviceID();
                long l = this.getTimestamp();
                int n = this.getStatusCode();
                this._cacheEventData = EventData.getEventData((String)string, (String)string2, (long)l, (int)n);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return this._cacheEventData;
    }

    private static void initFuelManager() {
        boolean bl = RTConfig.getBoolean((String)"FuelRegister.installFuelManager", (boolean)false);
        if (bl && fuelManager == null) {
            Print.logDebug((String)"Initializing FuelManager ...", (Object[])new Object[0]);
            fuelManager = new FuelManager(){

                public FuelManager.LevelChangeType insertFuelLevelChange(EventData eventData) {
                    try {
                        return FuelRegister.insertFuelLevelChange(eventData);
                    }
                    catch (Throwable throwable) {
                        return FuelManager.LevelChangeType.UNKNOWN;
                    }
                }
            };
            Device.setFuelManager((FuelManager)fuelManager);
        }
    }

    public static boolean getIgnoreNegativeFuelLevels() {
        return RTConfig.getBoolean((String)"FuelRegister.ignoreNegativeFuelLevels", (boolean)true);
    }

    public static boolean getIgnoreZeroFuelLevels() {
        return RTConfig.getBoolean((String)"FuelRegister.ignoreZeroFuelLevels", (boolean)true);
    }

    public static boolean getIgnoreWhileMoving() {
        return RTConfig.getBoolean((String)"FuelRegister.ignoreWhileMoving", (boolean)false);
    }

    public static double getLevelIncreaseThreshold() {
        return RTConfig.getDouble((String)"FuelRegister.levelIncreaseThreshold", (double)0.5);
    }

    public static double getLevelDecreaseThreshold() {
        return RTConfig.getDouble((String)"FuelRegister.levelDecreaseThreshold", (double)0.3);
    }

    public static FuelManager.LevelChangeType insertFuelLevelChange(EventData eventData) {
        double d = FuelRegister.getLevelIncreaseThreshold();
        double d2 = FuelRegister.getLevelDecreaseThreshold();
        if (eventData == null) {
            return FuelManager.LevelChangeType.UNKNOWN;
        }
        Device device = eventData.getDevice();
        if (device == null) {
            return FuelManager.LevelChangeType.UNKNOWN;
        }
        String string = device.getAccountID();
        String string2 = device.getDeviceID();
        long l = eventData.getTimestamp();
        int n = eventData.getStatusCode();
        double d3 = eventData.getFuelLevel(true);
        double d4 = device.getLastFuelLevel();
        double d5 = d3 - d4;
        if (n == 63825) {
            try {
                FuelRegister fuelRegister = FuelRegister.getFuelRegister(string, string2, l, true);
                fuelRegister._setEventDataFields(eventData, d5, true);
                if (!DEBUG_MODE) {
                    fuelRegister.save();
                }
                Print.logInfo((String)"Explicit fuel increase (refill)", (Object[])new Object[0]);
                return FuelManager.LevelChangeType.INCREASE;
            }
            catch (DBException dBException) {
                Print.logError((String)("Error creating new FuelRegister: " + (Object)((Object)dBException)), (Object[])new Object[0]);
                return FuelManager.LevelChangeType.UNKNOWN;
            }
        }
        if (n == 63826) {
            try {
                FuelRegister fuelRegister = FuelRegister.getFuelRegister(string, string2, l, true);
                fuelRegister._setEventDataFields(eventData, d5, false);
                if (!DEBUG_MODE) {
                    fuelRegister.save();
                }
                Print.logInfo((String)"Explicit fuel decrease (theft)", (Object[])new Object[0]);
                return FuelManager.LevelChangeType.DECREASE;
            }
            catch (DBException dBException) {
                Print.logError((String)("Error creating new FuelRegister: " + (Object)((Object)dBException)), (Object[])new Object[0]);
                return FuelManager.LevelChangeType.UNKNOWN;
            }
        }
        if (d3 < 0.0 && FuelRegister.getIgnoreNegativeFuelLevels()) {
            Print.logDebug((String)"Fuel level % is < zero, ignoring fuel level checks", (Object[])new Object[0]);
            return FuelManager.LevelChangeType.UNKNOWN;
        }
        if (d3 == 0.0 && FuelRegister.getIgnoreZeroFuelLevels()) {
            Print.logDebug((String)"Fuel level % is zero, ignoring fuel level checks", (Object[])new Object[0]);
            return FuelManager.LevelChangeType.UNKNOWN;
        }
        if (eventData.getSpeedKPH() > 0.0 && FuelRegister.getIgnoreWhileMoving()) {
            Print.logDebug((String)"Vehicle moving, ignoring fuel level checks", (Object[])new Object[0]);
            return FuelManager.LevelChangeType.NONE;
        }
        if (d > 0.0 && d5 > d) {
            try {
                FuelRegister fuelRegister = FuelRegister.getFuelRegister(string, string2, l, true);
                fuelRegister._setEventDataFields(eventData, d5, true);
                if (!DEBUG_MODE) {
                    fuelRegister.save();
                }
                Print.logInfo((String)("[" + string + "/" + string2 + "] Detected fuel increase (refill):" + " old=" + StringTools.format((double)(d4 * 100.0), (String)"0.0") + "%" + " new=" + StringTools.format((double)(d3 * 100.0), (String)"0.0") + "%" + " delta=" + StringTools.format((double)(d5 * 100.0), (String)"0.0") + "%"), (Object[])new Object[0]);
                return FuelManager.LevelChangeType.INCREASE;
            }
            catch (DBException dBException) {
                Print.logError((String)("Error creating new FuelRegister: " + (Object)((Object)dBException)), (Object[])new Object[0]);
                return FuelManager.LevelChangeType.UNKNOWN;
            }
        }
        if (d2 > 0.0 && d5 < -d2) {
            try {
                FuelRegister fuelRegister = FuelRegister.getFuelRegister(string, string2, l, true);
                fuelRegister._setEventDataFields(eventData, d5, false);
                if (!DEBUG_MODE) {
                    fuelRegister.save();
                }
                Print.logInfo((String)("[" + string + "/" + string2 + "] Detected fuel decrease (theft):" + " old=" + StringTools.format((double)(d4 * 100.0), (String)"0.0") + "%" + " new=" + StringTools.format((double)(d3 * 100.0), (String)"0.0") + "%" + " delta=" + StringTools.format((double)(d5 * 100.0), (String)"0.0") + "%"), (Object[])new Object[0]);
                return FuelManager.LevelChangeType.DECREASE;
            }
            catch (DBException dBException) {
                Print.logError((String)("Error creating new FuelRegister: " + (Object)((Object)dBException)), (Object[])new Object[0]);
                return FuelManager.LevelChangeType.UNKNOWN;
            }
        }
        return FuelManager.LevelChangeType.NONE;
    }

    public void setCreationDefaultValues() {
        super.setRuntimeDefaultValues();
    }

    public static FuelRegister getFuelRegister(String string, String string2, long l) throws DBException {
        return FuelRegister.getFuelRegister(string, string2, l, false);
    }

    public static FuelRegister getFuelRegister(String string, String string2, long l, boolean bl) throws DBException {
        if (StringTools.isBlank((String)string) || StringTools.isBlank((String)string2)) {
            return null;
        }
        if (l <= 0L) {
            return null;
        }
        Key key = new Key(string, string2, l);
        if (key.exists()) {
            return (FuelRegister)key.getDBRecord(true);
        }
        if (bl) {
            FuelRegister fuelRegister = (FuelRegister)key.getDBRecord();
            fuelRegister.setCreationDefaultValues();
            return fuelRegister;
        }
        return null;
    }

    public static void getRecordCallback(String string, String string2, long l, long l2, DBRecordHandler<FuelRegister> dBRecordHandler) throws DBException {
        if (StringTools.isBlank((String)string) || StringTools.isBlank((String)string2)) {
            return;
        }
        if (dBRecordHandler == null) {
            return;
        }
        DBSelect dBSelect = new DBSelect(FuelRegister.getFactory());
        DBWhere dBWhere = new DBWhere(FuelRegister.getFactory());
        dBWhere.append(dBWhere.AND(dBWhere.EQ("accountID", (Object)string), dBWhere.EQ("deviceID", (Object)string2)));
        if (l >= 0L) {
            dBWhere.append(dBWhere.AND_(dBWhere.GE(FLD_timestamp, l)));
        }
        if (l2 >= 0L && l2 >= l) {
            dBWhere.append(dBWhere.AND_(dBWhere.LE(FLD_timestamp, l2)));
        }
        dBSelect.setWhere(dBWhere.WHERE(dBWhere.toString()));
        dBSelect.setOrderByFields(new String[]{FLD_timestamp});
        dBSelect.setOrderAscending(true);
        DBRecord.select((DBSelect)dBSelect, dBRecordHandler);
    }

    public static void main(String[] stringArray) {
        DBConfig.cmdLineInit((String[])stringArray, (boolean)true);
        DEBUG_MODE = true;
        String string = "demo";
        String string2 = "demo";
        if (!RTConfig.getBoolean((String[])ARG_TEST, (boolean)false)) {
            Print.sysPrintln((String)"Add '-test' option to run FuelRegister test", (Object[])new Object[0]);
            System.exit(0);
        }
        Account account = null;
        Device device = null;
        try {
            account = Account.getAccount((String)string);
            if (account == null) {
                Print.logError((String)("Account not found: " + string), (Object[])new Object[0]);
                System.exit(99);
            }
            if ((device = Device.getDevice((Account)account, (String)string2)) == null) {
                Print.logError((String)("Device not found: " + string2), (Object[])new Object[0]);
                System.exit(99);
            }
        }
        catch (DBException dBException) {
            Print.sysPrintln((String)"Unable to load Account/Device", (Object[])new Object[0]);
            Print.sysPrintln((String)("AccountID : " + string), (Object[])new Object[0]);
            Print.sysPrintln((String)("DeviceID  : " + string2), (Object[])new Object[0]);
            Print.sysPrintln((String)"-------------------------------------------------------------------------------", (Object[])new Object[0]);
            dBException.printStackTrace();
            Print.sysPrintln((String)"-------------------------------------------------------------------------------", (Object[])new Object[0]);
            System.exit(99);
        }
        long l = DateTime.getCurrentTimeSec();
        EventData.Key key = new EventData.Key(string, string2, l, 61472);
        EventData eventData = (EventData)key.getDBRecord();
        eventData.setDevice(device);
        eventData.setGeoPoint(37.784, -142.399);
        eventData.setFuelLevel(0.0);
        double d = 1.0;
        device.setLastFuelLevel(d);
        eventData.setFuelLevel(d);
        int n = 0;
        while (n < 10) {
            Print.sysPrintln((String)("Fuel-Level: " + StringTools.format((double)(d * 100.0), (String)"0.0") + "%"), (Object[])new Object[0]);
            eventData.setFuelLevel(d);
            FuelManager.LevelChangeType levelChangeType = FuelRegister.insertFuelLevelChange(eventData);
            device.setLastFuelLevel(d);
            if (!((d -= 0.01) < 0.05)) continue;
            d = 1.0;
            ++n;
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<FuelRegister> {
        public Key() {
        }

        public Key(String string, String string2, long l) {
            super.setKeyValue("accountID", (Object)(string != null ? string.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)(string2 != null ? string2.toLowerCase() : ""));
            super.setKeyValue(FuelRegister.FLD_timestamp, l);
        }

        public DBFactory<FuelRegister> getFactory() {
            return FuelRegister.getFactory();
        }
    }
}

