/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.selector;

import org.opengts.rule.selector.FunctionMap;
import org.opengts.rule.selector.FunctionMapFactory;
import org.opengts.rule.selector.IdentifierMap;
import org.opengts.rule.selector.IdentifierMapFactory;
import org.opengts.rule.selector.Parser;
import org.opengts.rule.selector.ParserException;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class Selector {
    public static final int MAX_RESURSION_LEVEL = 2;
    public static final Result RESULT_FALSE = new Result(new Long(0L), false);
    public static final Result RESULT_TRUE = new Result(new Long(1L), true);
    private FunctionMapFactory ftnFactory = null;
    private IdentifierMapFactory identFactory = null;

    public Selector() {
    }

    public Selector(FunctionMapFactory functionMapFactory, IdentifierMapFactory identifierMapFactory) {
        this.setFunctionMapFactory(functionMapFactory);
        this.setIdentifierMapFactory(identifierMapFactory);
    }

    protected void setFunctionMapFactory(FunctionMapFactory functionMapFactory) {
        this.ftnFactory = functionMapFactory;
    }

    protected FunctionMapFactory getFunctionMapFactory() {
        return this.ftnFactory;
    }

    public FunctionMap newFunctionMap(int n, Object object, boolean bl) {
        return new FunctionMap(this.getFunctionMapFactory(), n, object, bl);
    }

    public void setIdentifierMapFactory(IdentifierMapFactory identifierMapFactory) {
        this.identFactory = identifierMapFactory;
    }

    public IdentifierMapFactory getIdentifierMapFactory() {
        return this.identFactory;
    }

    public IdentifierMap newIdentifierMap(Object object) {
        return new IdentifierMap(this.getIdentifierMapFactory(), object);
    }

    public boolean checkSyntax(String string) {
        return this.checkSyntax(string, null);
    }

    public boolean checkSyntax(String string, Object object) {
        if (StringTools.isBlank((String)string)) {
            return true;
        }
        try {
            this._getResult(-1, string, object, true);
            return true;
        }
        catch (ParserException parserException) {
            return false;
        }
    }

    public Object getResultValue(String string, Object object) throws ParserException {
        Result result = this._getResult(0, string, object, false);
        return result != null ? result.getValue() : null;
    }

    public Result getResult(String string, Object object) throws ParserException {
        return this._getResult(0, string, object, false);
    }

    public Result getResult(int n, String string, Object object) throws ParserException {
        return this._getResult(n, string, object, false);
    }

    private Result _getResult(int n, String string, Object object, boolean bl) throws ParserException {
        if (n <= 2) {
            if (string != null && !string.equals("")) {
                try {
                    FunctionMap functionMap = this.newFunctionMap(n, object, bl);
                    IdentifierMap identifierMap = this.newIdentifierMap(object);
                    Parser parser = new Parser(string, functionMap, identifierMap);
                    parser.yyparse();
                    if (parser.hasError()) {
                        String string2 = parser.getErrorMessage() + " [loc=" + parser.getErrorIndex() + "]";
                        throw new ParserException(string2);
                    }
                    return new Result(parser.getResult(), parser.getBooleanResult());
                }
                catch (ParserException parserException) {
                    throw parserException;
                }
                catch (Throwable throwable) {
                    Print.logStackTrace((String)"Internal exception", (Throwable)throwable);
                    throw new ParserException("Internal Parser Exception", throwable);
                }
            }
            return RESULT_FALSE;
        }
        throw new ParserException("Excessive nested rules: " + n + " [" + string + "]");
    }

    public static class Result {
        private static Object resultValue = null;
        private static boolean resultMatch = false;

        public Result(Object object, boolean bl) {
            resultValue = object;
            resultMatch = bl;
        }

        public Object getValue() {
            return resultValue;
        }

        public boolean isMatch() {
            return resultMatch;
        }
    }
}

