/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.selector;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.opengts.rule.selector.FunctionHandler;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public abstract class FunctionMapFactory {
    private Map<String, FunctionHandler> functions = new HashMap<String, FunctionHandler>();

    public FunctionMapFactory() {
        this.initFunctions();
    }

    protected abstract void initFunctions();

    public int addFunction(FunctionHandler functionHandler) {
        int n = 0;
        if (functionHandler != null) {
            String[] stringArray = functionHandler.getNames();
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                String string2 = string = stringArray[i] != null ? stringArray[i].trim().toUpperCase() : "";
                if (string.equals("") || this.functions.containsKey(string)) continue;
                this.functions.put(string, functionHandler);
                ++n;
            }
        }
        return n;
    }

    public boolean addAlias(String string, String string2) {
        FunctionHandler functionHandler = this.getFunction(string);
        if (functionHandler == null) {
            Print.logWarn((String)("Existing function not found: " + string), (Object[])new Object[0]);
            return false;
        }
        if (StringTools.isBlank((String)string2) || !string2.startsWith("$")) {
            Print.logWarn((String)"The specified alias name is null/empty", (Object[])new Object[0]);
            return false;
        }
        if (this.getFunction(string2) != null) {
            Print.logWarn((String)"The specified alias name is already defined", (Object[])new Object[0]);
            return false;
        }
        this.functions.put(string2, functionHandler);
        return true;
    }

    public boolean hasFunction(String string) {
        return this.getFunction(string) != null;
    }

    public FunctionHandler getFunction(String string) {
        if (string != null) {
            String string2 = string.toUpperCase();
            return this.functions.get(string2);
        }
        return null;
    }

    public Collection<FunctionHandler> getFunctions() {
        return new HashSet<FunctionHandler>(this.functions.values());
    }
}

