/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.event;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.opengts.Version;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Resource;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.rule.EventRuleAction;
import org.opengts.rule.event.EventFunctionHandler;
import org.opengts.rule.event.EventFunctionMap;
import org.opengts.rule.event.EventFunctionMapFactory;
import org.opengts.rule.event.EventIdentifierHandler;
import org.opengts.rule.event.EventIdentifierMap;
import org.opengts.rule.event.EventIdentifierMapFactory;
import org.opengts.rule.selector.FunctionHandler;
import org.opengts.rule.selector.FunctionMap;
import org.opengts.rule.selector.FunctionMapFactory;
import org.opengts.rule.selector.IdentifierHandler;
import org.opengts.rule.selector.IdentifierMap;
import org.opengts.rule.selector.IdentifierMapFactory;
import org.opengts.rule.selector.ParserException;
import org.opengts.rule.selector.Selector;
import org.opengts.rule.tables.Rule;
import org.opengts.rule.tables.RuleTrigger;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class EventSelector
extends Selector {
    public static final String UTILITY_VERSION = "1.3.12";
    public static final String ENRE_VERSION = "1.2.11";
    private static long LIMIT_TEST = 0L;
    private static long VCHECK = 0L;
    private static long VCHECK_MSG = 0L;
    private static long VCHECK_MSGMOD = 21L;
    private static String VCHECK_ERROR = null;
    private static boolean SID_MATCH = true;
    private static boolean HASH_MATCH = true;
    private static boolean CronMode = false;
    private static EventSelector eventSelectorInstance = null;
    private EventData syntaxCheckEventData;
    private static final String[] ARG_HELP = new String[]{"help", "h"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct", "a"};
    private static final String[] ARG_USER = new String[]{"user", "usr", "u"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev", "d"};
    private static final String[] ARG_TIMESTAMP = new String[]{"timestamp", "time", "ts"};
    private static final String[] ARG_CODE = new String[]{"statusCode", "code", "sc"};
    private static final String[] ARG_GPS = new String[]{"geoPoint", "gps", "gp"};
    private static final String[] ARG_KPH = new String[]{"kph", "speed"};
    private static final String[] ARG_MPH = new String[]{"mph"};
    private static final String[] ARG_ODOM = new String[]{"odometer", "odom", "od"};
    private static final String[] ARG_THERMAL = new String[]{"thermo", "temp", "tp"};
    private static final String[] ARG_CRON = new String[]{"cron"};

    public static String getVersion() {
        return EventSelector.getVersion(true);
    }

    public static String getVersion(boolean bl) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ENRE_VERSION);
            boolean bl2 = false;
            if (!bl2) {
                stringBuffer.append("-");
                bl2 = true;
            }
            stringBuffer.append("L(").append(109L).append(")");
            return stringBuffer.toString();
        }
        return ENRE_VERSION;
    }

    public static String getJarAuthString(String string) {
        if (StringTools.isBlank((String)string)) {
            String string2;
            String string3;
            URL uRL;
            string = RTConfig.getString((String)"%mainJar", (String)"");
            Class<EventSelector> clazz = EventSelector.class;
            ClassLoader classLoader = clazz.getClassLoader();
            if ((classLoader != null || (classLoader = ClassLoader.getSystemClassLoader()) != null) && (uRL = classLoader.getResource(clazz.getName().replace('.', '/') + ".class")) != null && (string3 = uRL.getPath()) != null && (string2 = StringTools.trim((String)uRL.getProtocol())).equalsIgnoreCase("jar")) {
                int n = StringTools.startsWithIgnoreCase((String)string3, (String)"file:") ? "file:".length() : 0;
                int n2 = string3.indexOf("!");
                string = n2 >= 0 ? string3.substring(n, n2) : string3.substring(n, string3.length());
            }
        }
        long l = RTConfig.getLong((String)"RuleFactory.key", (long)188900966474565L) & 0xFFFFFFFFFFFFL;
        return "mutinda,ruledb,1381279040,110," + l + "," + string;
    }

    public static void SetCronMode(boolean bl) {
        CronMode = bl;
    }

    public static boolean GetCronMode() {
        return CronMode;
    }

    public static void initSingleton() {
        if (eventSelectorInstance == null) {
            eventSelectorInstance = new EventSelector();
        }
    }

    public static EventSelector getInstance() {
        EventSelector.initSingleton();
        if (VCHECK > 0L && VCHECK_MSG++ % VCHECK_MSGMOD == 0L) {
            Print._log((int)2, (int)-1, (String)("*** Internal error: EX2959-2-" + VCHECK_ERROR + " (contact service provider)"), (Object[])new Object[0]);
        }
        return eventSelectorInstance;
    }

    public static String getDCSJarFilePath(String string) {
        File file = RTConfig.getLoadedConfigDir();
        if (file == null) {
            return "";
        }
        File file2 = new File(file, "build/lib/" + string + ".jar");
        if (file2 == null) {
            return "";
        }
        if (!file2.isFile()) {
            return "";
        }
        return file2.toString();
    }

    private static String getMainJarFilePath(String string, Class clazz) {
        ClassLoader classLoader;
        if (clazz == null) {
            clazz = EventSelector.class;
        }
        if ((classLoader = clazz.getClassLoader()) == null && (classLoader = ClassLoader.getSystemClassLoader()) == null) {
            return ":loader";
        }
        URL uRL = classLoader.getResource(clazz.getName().replace('.', '/') + ".class");
        if (uRL == null) {
            return ":resource";
        }
        String string2 = uRL.getPath();
        if (string2 == null) {
            return ":path";
        }
        String string3 = StringTools.trim((String)uRL.getProtocol());
        if (!string3.equalsIgnoreCase("jar")) {
            if (!string3.equalsIgnoreCase("file")) {
                return ":proto";
            }
            if (string2.endsWith("TrackServer.class")) {
                return EventSelector.getDCSJarFilePath(string);
            }
            if (string2.endsWith("TrackClientPacketHandler.class")) {
                return EventSelector.getDCSJarFilePath(string);
            }
            Print.logInfo((String)("File: " + string2), (Object[])new Object[0]);
            return ":proto";
        }
        int n = StringTools.startsWithIgnoreCase((String)string2, (String)"file:") ? "file:".length() : 0;
        int n2 = string2.indexOf("!");
        if (n2 >= 0) {
            return string2.substring(n, n2);
        }
        return string2.substring(n, string2.length());
    }

    private static byte[] shuffle(byte[] byArray, Random random) {
        if (byArray != null && byArray.length > 1 && random != null) {
            for (int i = byArray.length - 1; i > 0; --i) {
                int n = random.nextInt(i + 1);
                if (i == n) continue;
                byte by = byArray[i];
                byArray[i] = byArray[n];
                byArray[n] = by;
            }
        }
        return byArray;
    }

    private static byte[] getRandomBytes(int n, Random random) {
        if (n > 0 && random != null) {
            byte[] byArray = new byte[n];
            random.nextBytes(byArray);
            return byArray;
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = FileTools.readStream((InputStream)fileInputStream);
            return byArray;
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private EventSelector() {
        Object object;
        String string;
        String string2;
        block52: {
            int n;
            block51: {
                this.syntaxCheckEventData = null;
                n = 0;
                string2 = "";
                long l = 1381279040L;
                long l2 = 110L;
                String string3 = "ruledb";
                String string4 = RTConfig.getString((String)"ServiceAccount.ID", (String)"");
                if (StringTools.isBlank((String)string3)) {
                    n = 101;
                    ++VCHECK;
                    string2 = string2 + (1000 + n) + ":";
                } else if (StringTools.isBlank((String)string4)) {
                    n = 200;
                    SID_MATCH = false;
                    ++VCHECK;
                    string2 = string2 + (1000 + n) + ":";
                } else if (!(string4.equals(RTConfig.getString((String)"ServiceAccount.ID", (String)"")) && string4.equals("mutinda") && string4.equals("mutinda"))) {
                    n = 201;
                    SID_MATCH = false;
                    ++VCHECK;
                    string2 = string2 + (1000 + n) + ":" + string4;
                } else {
                    string = EventSelector.getMainJarFilePath(string3, this.getClass());
                    if (StringTools.isBlank((String)string)) {
                        n = 120;
                        HASH_MATCH = false;
                        ++VCHECK;
                        string2 = string2 + (1000 + n) + ":";
                    } else if (string.startsWith(":")) {
                        n = 120;
                        HASH_MATCH = false;
                        ++VCHECK;
                        string2 = string2 + (1000 + n) + ":" + string;
                    } else if (!StringTools.endsWithIgnoreCase((String)string, (String)".jar")) {
                        n = 305;
                        HASH_MATCH = false;
                        ++VCHECK;
                        string2 = string2 + (1000 + n) + ":" + string;
                    } else if (!FileTools.isFile((String)string)) {
                        n = 310;
                        HASH_MATCH = false;
                        ++VCHECK;
                        string2 = string2 + (1000 + n) + ":" + string;
                    } else {
                        object = EventSelector.readFile(new File(string));
                        if (ListTools.isEmpty((byte[])object)) {
                            n = 320;
                            HASH_MATCH = false;
                            ++VCHECK;
                            string2 = string2 + (1000 + n) + ":" + string;
                        } else {
                            File file = RTConfig.getLoadedConfigFile();
                            File file2 = file != null ? new File(file.getParentFile(), "GTS_Enterprise") : null;
                            byte[] byArray = EventSelector.readFile(file2);
                            if (ListTools.isEmpty((byte[])byArray)) {
                                n = 210;
                                ++VCHECK;
                                string2 = string2 + (1000 + n) + ":";
                            } else {
                                boolean bl = false;
                                RTProperties rTProperties = new RTProperties((InputStream)new ByteArrayInputStream(byArray));
                                StringBuffer stringBuffer = new StringBuffer("GTS.");
                                String string5 = rTProperties.getString(stringBuffer + "Copyright", "");
                                String string6 = rTProperties.getString(stringBuffer + "ServiceID", "");
                                String string7 = rTProperties.getString(stringBuffer + "Version", "");
                                if (StringTools.isBlank((String)string5)) {
                                    n = 220;
                                    ++VCHECK;
                                    string2 = string2 + (1000 + n) + ":";
                                } else {
                                    File file3;
                                    Object object2;
                                    Object object3;
                                    int n2;
                                    Object object4;
                                    String string8 = "RuleFactory." + string3;
                                    String string9 = "gtsauth:rule." + string3;
                                    if (OSTools.hasGetCallerClass()) {
                                        object4 = null;
                                        n2 = 2;
                                        while ((object3 = OSTools.getCallerClass((int)n2)) != null) {
                                            object4 = object3;
                                            ++n2;
                                        }
                                        if (object4 != null) {
                                            try {
                                                MethodAction methodAction = new MethodAction(object4, "DCServerFactory_LoadName");
                                                object3 = (String)methodAction.invoke();
                                                object2 = "RuleFactory." + (String)object3 + "." + string3;
                                                if (RTConfig.hasProperty((String)object2)) {
                                                    Print.logInfo((String)("Changing DCS ruledb property to: " + (String)object2), (Object[])new Object[0]);
                                                    string8 = object2;
                                                    string9 = "gtsauth:rule." + (String)object3 + "." + string3;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (StringTools.isBlank((String)(object4 = StringTools.trim((String)RTConfig.getString((String)string8, (String)"")))) && (file3 = DBConfig.get_GTS_HOME()) != null) {
                                        object3 = new File(file3, DBConfig.AUTHKEY_DCS_CONF((String)string3));
                                        if (!((File)object3).isFile()) {
                                            object3 = new File(file3, "authkeys.conf");
                                        }
                                        if (((File)object3).isFile()) {
                                            object2 = new RTProperties((File)object3);
                                            object4 = StringTools.trim((String)object2.getString(string8, ""));
                                        }
                                    }
                                    n2 = 1;
                                    try {
                                        byte[] byArray2;
                                        String string10;
                                        byte[] byArray3;
                                        Object object5;
                                        long l3 = RTConfig.getLong((String)"RuleFactory.key", (long)188900966474565L) & 0xFFFFFFFFFFFFL;
                                        long l4 = BigInteger.valueOf(l3).xor(new BigInteger(string3.getBytes())).longValue();
                                        Random random = new Random(l4 & 0xFFFFFFFFFFFFL);
                                        Random random2 = new Random(l4 / 2L & 0xFFFFFFFFFFFFL);
                                        if (random.nextBoolean()) {
                                            object5 = MessageDigest.getInstance("MD5");
                                            ((MessageDigest)object5).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            ((MessageDigest)object5).update(String.valueOf(l2).getBytes());
                                            ((MessageDigest)object5).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            ((MessageDigest)object5).update(String.valueOf(l).getBytes());
                                            ((MessageDigest)object5).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            ((MessageDigest)object5).update(string3.getBytes());
                                            ((MessageDigest)object5).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            ((MessageDigest)object5).update(string4.getBytes());
                                            ((MessageDigest)object5).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            ((MessageDigest)object5).update(string5.getBytes());
                                            ((MessageDigest)object5).update(string6.getBytes());
                                            ((MessageDigest)object5).update(EventSelector.getRandomBytes(random.nextInt(8), random));
                                            byArray3 = ((MessageDigest)object5).digest();
                                        } else {
                                            object5 = new Payload();
                                            object5.writeBytes(EventSelector.getRandomBytes(4, random));
                                            object5.writeULong(l2, 4, false);
                                            object5.writeULong(l, 8);
                                            object5.writeString(string3, 20, true);
                                            object5.writeString(string4, 20, true);
                                            object5.writeString(string5, 80, true);
                                            object5.writeString(string6, 20, true);
                                            object5.writeBytes(EventSelector.getRandomBytes(160 - object5.getSize(), random));
                                            byArray3 = object5.getBytes();
                                        }
                                        object5 = Mac.getInstance("HmacSHA256");
                                        ((Mac)object5).init(new SecretKeySpec(EventSelector.shuffle(byArray3, random), ((Mac)object5).getAlgorithm()));
                                        if (bl) {
                                            ((Mac)object5).update(byArray);
                                        }
                                        if ((string10 = new BigInteger(1, byArray2 = EventSelector.shuffle(((Mac)object5).doFinal((byte[])object), random)).toString(16)).equalsIgnoreCase((String)object4) || ((String)object4).startsWith(string4 + "," + string3 + "," + l)) break block51;
                                        if (StringTools.isBlank((String)object4)) {
                                            n = 330;
                                            HASH_MATCH = false;
                                            ++VCHECK;
                                            string2 = string2 + (1000 + n) + ":" + "RuleFactory." + string3;
                                            Resource.setGlobalResourceValue((String)string9, (String)"binary", (String)"", (Object)EventSelector.shuffle(byArray2, random2));
                                            break block52;
                                        }
                                        n = 350;
                                        HASH_MATCH = false;
                                        ++VCHECK;
                                        string2 = string2 + (1000 + n) + ":" + string4 + "," + string3 + "," + l + "," + l2 + "," + l3 + "," + string;
                                        Resource.setGlobalResourceValue((String)string9, (String)"binary", (String)"", (Object)EventSelector.shuffle(byArray2, random2));
                                    }
                                    catch (Throwable throwable) {
                                        if (((String)object4).startsWith(string4 + "," + string3 + "," + l)) break block51;
                                        if (StringTools.isBlank((String)object4)) {
                                            n = 330;
                                            HASH_MATCH = false;
                                            ++VCHECK;
                                            string2 = string2 + (1000 + n) + ":" + "RuleFactory." + string3;
                                            break block52;
                                        }
                                        n = 390;
                                        HASH_MATCH = false;
                                        ++VCHECK;
                                        string2 = string2 + (1000 + n) + ":";
                                    }
                                }
                            }
                        }
                    }
                }
                break block52;
            }
            long l = DateTime.getCurrentTimeSec();
            boolean bl = false;
            if (bl) {
                n = 500;
                ++VCHECK;
                string2 = string2 + (1000 + n) + ":";
            } else {
                try {
                    long l5 = DBRecord.getRecordCount((DBFactory)Device.getFactory());
                    if (l5 > 118L) {
                        n = 400;
                        LIMIT_TEST = 1562587685504633840L;
                        ++VCHECK;
                        string2 = string2 + (1000 + n) + ":" + l5;
                    } else {
                        LIMIT_TEST = -1562587685504633841L;
                    }
                }
                catch (DBException dBException) {
                    n = 490;
                    ++VCHECK;
                    string2 = string2 + (1000 + n) + ":" + dBException.getMessage();
                }
            }
        }
        string = RTConfig.getString((String)"EventFunctionMapFactory.class");
        if (!StringTools.isBlank((String)string)) {
            try {
                object = new MethodAction((Object)string);
                this.setFunctionMapFactory((EventFunctionMapFactory)object.invoke());
            }
            catch (Throwable throwable) {
                Print.logException((String)("Unable to instantiate '" + string + "'"), (Throwable)throwable);
                this.setFunctionMapFactory(new EventFunctionMapFactory());
            }
        } else {
            this.setFunctionMapFactory(new EventFunctionMapFactory());
        }
        string = RTConfig.getString((String)"EventIdentifierMapFactory.class");
        if (!StringTools.isBlank((String)string)) {
            try {
                object = new MethodAction((Object)string);
                this.setIdentifierMapFactory((EventIdentifierMapFactory)object.invoke());
            }
            catch (Throwable throwable) {
                Print.logException((String)("Unable to instantiate '" + string + "'"), (Throwable)throwable);
                this.setIdentifierMapFactory(new EventIdentifierMapFactory());
            }
        } else {
            this.setIdentifierMapFactory(new EventIdentifierMapFactory());
        }
        this.syntaxCheckEventData = null;
        if (VCHECK > 0L) {
            VCHECK_ERROR = string2;
            VCHECK_MSG = VCHECK_MSGMOD - 2L;
        }
    }

    public String _getVersion() {
        String string = ENRE_VERSION;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (VCHECK > 0L) {
            stringBuffer.append("*");
        }
        stringBuffer.append(string);
        if (!HASH_MATCH) {
            int n;
            if (!bl) {
                stringBuffer.append("-");
                bl = true;
            }
            stringBuffer.append("H");
            int n2 = n = VCHECK_ERROR != null ? VCHECK_ERROR.indexOf(":") : -1;
            if (n > 0) {
                stringBuffer.append(VCHECK_ERROR.substring(0, n));
            }
        }
        if (!SID_MATCH) {
            if (!bl) {
                stringBuffer.append("-");
                bl = true;
            }
            stringBuffer.append("S");
        }
        if (!bl) {
            stringBuffer.append("-");
            bl = true;
        }
        stringBuffer.append("L(").append(109L).append(")");
        return stringBuffer.toString();
    }

    @Override
    public FunctionMap newFunctionMap(int n, Object object, boolean bl) {
        FunctionMapFactory functionMapFactory = this.getFunctionMapFactory();
        if (object instanceof EventData) {
            return new EventFunctionMap(functionMapFactory, n, (EventData)object, bl);
        }
        if (object instanceof Account) {
            return new EventFunctionMap(functionMapFactory, n, (Account)object, bl);
        }
        if (object instanceof Device) {
            return new EventFunctionMap(functionMapFactory, n, (Device)object, bl);
        }
        if (object == null) {
            return new EventFunctionMap(functionMapFactory, n, (EventData)null, bl);
        }
        Print.logError((String)("Object must be one of type EventData/Account/Device! [found " + StringTools.className((Object)object) + "]"), (Object[])new Object[0]);
        return null;
    }

    public List<String> getFunctionNames() {
        FunctionMapFactory functionMapFactory = this.getFunctionMapFactory();
        OrderedSet orderedSet = new OrderedSet(functionMapFactory.getFunctions(), true);
        Vector<String> vector = new Vector<String>();
        Iterator iterator = ListTools.sort((List)orderedSet, null).iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = ((FunctionHandler)iterator.next()).getNames();
            if (ListTools.isEmpty((Object[])objectArray)) continue;
            vector.add((String)objectArray[0]);
        }
        return vector;
    }

    public FunctionHandler getFunction(String string) {
        if (!StringTools.isBlank((String)string)) {
            FunctionMapFactory functionMapFactory = this.getFunctionMapFactory();
            return functionMapFactory.getFunction(string);
        }
        return null;
    }

    public int addFunction(EventFunctionHandler eventFunctionHandler) {
        return this.getFunctionMapFactory().addFunction(eventFunctionHandler);
    }

    @Override
    public IdentifierMap newIdentifierMap(Object object) {
        IdentifierMapFactory identifierMapFactory = this.getIdentifierMapFactory();
        if (object instanceof EventData) {
            return new EventIdentifierMap(identifierMapFactory, (EventData)object);
        }
        if (object instanceof Account) {
            return new EventIdentifierMap(identifierMapFactory, (Account)object);
        }
        if (object instanceof Device) {
            return new EventIdentifierMap(identifierMapFactory, (Device)object);
        }
        if (object == null) {
            return new EventIdentifierMap(identifierMapFactory, (EventData)null);
        }
        Print.logError((String)("Object must be one of type EventData/Account/Device! [found " + StringTools.className((Object)object) + "]"), (Object[])new Object[0]);
        return null;
    }

    public List<String> getIdentifierNames() {
        IdentifierMapFactory identifierMapFactory = this.getIdentifierMapFactory();
        OrderedSet orderedSet = new OrderedSet(identifierMapFactory.getIdentifiers(), true);
        Vector<String> vector = new Vector<String>();
        Iterator iterator = ListTools.sort((List)orderedSet, null).iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = ((IdentifierHandler)iterator.next()).getNames();
            if (ListTools.isEmpty((Object[])objectArray)) continue;
            vector.add((String)objectArray[0]);
        }
        return vector;
    }

    public IdentifierHandler getIdentifier(String string) {
        if (!StringTools.isBlank((String)string)) {
            IdentifierMapFactory identifierMapFactory = this.getIdentifierMapFactory();
            return identifierMapFactory.getIdentifier(string);
        }
        return null;
    }

    public int addIdentifier(EventIdentifierHandler eventIdentifierHandler) {
        return this.getIdentifierMapFactory().addIdentifier(eventIdentifierHandler);
    }

    @Override
    public boolean checkSyntax(String string) {
        Object object = this.getSyntaxCheckObject();
        boolean bl = super.checkSyntax(string, object);
        if (bl) {
            return true;
        }
        try {
            super.getResult(-1, string, object);
        }
        catch (ParserException parserException) {
            Print.logError((String)("Selector: " + parserException), (Object[])new Object[0]);
            Print.logException((String)("Selector: " + string), (Throwable)parserException);
        }
        return false;
    }

    private Object getSyntaxCheckObject() {
        return this.syntaxCheckEventData;
    }

    @Override
    public Object getResultValue(String string, Object object) throws ParserException {
        long l;
        if ((LIMIT_TEST ^ 0xFFFFFFFFFFFFFFFFL) != 1562587685504633840L) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(5017L);
            }
            catch (Throwable throwable) {
                return FunctionHandler.LONG_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return FunctionHandler.LONG_FALSE;
            }
        }
        if (!SID_MATCH || !HASH_MATCH) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(7187L);
            }
            catch (Throwable throwable) {
                return FunctionHandler.LONG_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return FunctionHandler.LONG_FALSE;
            }
        }
        return super.getResultValue(string, object);
    }

    @Override
    public Selector.Result getResult(String string, Object object) throws ParserException {
        long l;
        if ((LIMIT_TEST ^ 0xFFFFFFFFFFFFFFFFL) != 1562587685504633840L) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(5021L);
            }
            catch (Throwable throwable) {
                return Selector.RESULT_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return Selector.RESULT_FALSE;
            }
        }
        if (!SID_MATCH || !HASH_MATCH) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(7053L);
            }
            catch (Throwable throwable) {
                return Selector.RESULT_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return Selector.RESULT_FALSE;
            }
        }
        return super.getResult(string, object);
    }

    @Override
    public Selector.Result getResult(int n, String string, Object object) throws ParserException {
        long l;
        if ((LIMIT_TEST ^ 0xFFFFFFFFFFFFFFFFL) != 1562587685504633840L) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(5027L);
            }
            catch (Throwable throwable) {
                return Selector.RESULT_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return Selector.RESULT_FALSE;
            }
        }
        if (!SID_MATCH || !HASH_MATCH) {
            ++VCHECK;
            l = System.currentTimeMillis();
            try {
                Thread.sleep(6073L);
            }
            catch (Throwable throwable) {
                return Selector.RESULT_FALSE;
            }
            if (System.currentTimeMillis() - l < 5000L && VCHECK % 3L == 0L) {
                return Selector.RESULT_FALSE;
            }
        }
        return super.getResult(n, string, object);
    }

    public Selector.Result getAccountRuleResult(int n, Account account, String string, EventData eventData) throws ParserException, DBException {
        Rule rule = Rule.getRule(account, string);
        if (rule == null) {
            String string2 = account != null ? account.getAccountID() : "?";
            throw new ParserException("Rule not found: " + string);
        }
        if (!rule.isActive()) {
            String string3 = account != null ? account.getAccountID() : "?";
            Print.logWarn((String)("Rule not active: " + string3 + "/" + string), (Object[])new Object[0]);
            return RESULT_FALSE;
        }
        String string4 = rule.getSelector();
        EventData eventData2 = eventData != null ? eventData : account;
        return this.getResult(n, string4, eventData2);
    }

    public Selector.Result getSysAdminRuleResult(int n, String string, EventData eventData) throws ParserException, DBException {
        String string2 = AccountRecord.getSystemAdminAccountID();
        if (StringTools.isBlank((String)string2)) {
            throw new ParserException("No SystemAdmin account to retrieve Rule: " + string);
        }
        Rule rule = Rule.getRule(string2, string);
        if (rule == null) {
            throw new ParserException("Rule not found: " + string2 + "/" + string);
        }
        if (!rule.isActive()) {
            Print.logWarn((String)("Rule not active: " + string2 + "/" + string), (Object[])new Object[0]);
            return RESULT_FALSE;
        }
        String string3 = rule.getSelector();
        EventData eventData2 = eventData != null ? eventData : null;
        return this.getResult(n, string3, eventData2);
    }

    private static void usage() {
        String string = EventSelector.class.getName();
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + string + " -help"), (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + string + " -list"), (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + string + " {options}"), (Object[])new Object[0]);
        Print.sysPrintln((String)"Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -help               This help", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -list               List all available functions/identifiers", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -account=<id>       Acount ID which owns Device/Event", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -device=<id>        Device ID which owns Event", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -timestamp=<code>   Timestamp", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -code=<code>        Status Code ('0' to leave EventData null)", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -gps=<lat>/<lon>    GPS Location", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -mph=<speedMPH>     Speed in MPH", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -kph=<speedKPH>     Speed in KM/H", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -odom=<odometerKM>  Odometer in KM", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -temp=<C>,<C>,...   Comma separated list of temperatures", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -cron=<mode>        Set 'Cron' mode true/false [default true]", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        System.exit(1);
    }

    private static void listFunctions(EventSelector eventSelector, int n, String string, String string2) {
        Print.sysPrintln((String)"Functions:", (Object[])new Object[0]);
        OrderedSet orderedSet = new OrderedSet(eventSelector.getFunctionMapFactory().getFunctions(), true);
        for (FunctionHandler functionHandler : ListTools.sort((List)orderedSet, null)) {
            String[] stringArray = functionHandler.getNames();
            if (!StringTools.isBlank((String)string2) && !stringArray[0].startsWith(string2)) continue;
            String string3 = functionHandler.getUsage();
            String string4 = functionHandler.getDescription();
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!StringTools.isBlank((String)string3)) {
                stringBuffer.append(StringTools.leftAlign((String)string3, (int)n));
            } else {
                stringBuffer.append(StringTools.leftAlign((String)StringTools.join((String[])functionHandler.getNames(), (String)","), (int)n));
            }
            Print.sysPrintln((String)stringBuffer.toString(), (Object[])new Object[0]);
            Print.sysPrintln((String)(string + string + string4), (Object[])new Object[0]);
        }
    }

    private static void listIdentifiers(EventSelector eventSelector, int n, String string, String string2) {
        Print.sysPrintln((String)"Identifiers:", (Object[])new Object[0]);
        OrderedSet orderedSet = new OrderedSet(eventSelector.getIdentifierMapFactory().getIdentifiers(), true);
        for (IdentifierHandler identifierHandler : ListTools.sort((List)orderedSet, null)) {
            String[] stringArray = identifierHandler.getNames();
            if (!StringTools.isBlank((String)string2) && !stringArray[0].startsWith(string2)) continue;
            String string3 = identifierHandler.getDescription();
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(StringTools.leftAlign((String)StringTools.join((String[])stringArray, (String)","), (int)n));
            Print.sysPrintln((String)stringBuffer.toString(), (Object[])new Object[0]);
            Print.sysPrintln((String)(string + string + string3), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        Object object;
        GeoPoint geoPoint;
        String string;
        String string2;
        DBConfig.cmdLineInit((String[])stringArray, (boolean)true);
        RTConfig.setBoolean((String)"log.include.frame", (boolean)true);
        int n = 25;
        String string3 = "    ";
        VCHECK_MSGMOD = 2L;
        if (RTConfig.hasProperty((String[])ARG_HELP)) {
            EventSelector.usage();
        }
        EventSelector.SetCronMode(RTConfig.getBoolean((String[])ARG_CRON, (boolean)true));
        EventSelector eventSelector = EventSelector.getInstance();
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            Print.sysPrintln((String)"Function Usage Legend:", (Object[])new Object[0]);
            Print.sysPrintln((String)"    (...)  = Function argument list, '()' is optional if function has no arguments", (Object[])new Object[0]);
            Print.sysPrintln((String)"    [...]  = Optional specification", (Object[])new Object[0]);
            Print.sysPrintln((String)"    {...}  = Mandatory specification set (one of the items must be specified)", (Object[])new Object[0]);
            Print.sysPrintln((String)"    |      = Indicates alternative specifications", (Object[])new Object[0]);
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            EventSelector.listFunctions(eventSelector, n, string3, null);
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            EventSelector.listIdentifiers(eventSelector, n, string3, null);
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            System.exit(0);
        }
        if (StringTools.isBlank((String)(string2 = RTConfig.getString((String[])ARG_ACCOUNT, (String)"demo")))) {
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            Print.sysPrintln((String)"ERROR: Account-ID not specified.", (Object[])new Object[0]);
            EventSelector.usage();
        }
        try {
            if (!Account.exists((String)string2)) {
                Print.sysPrintln((String)"", (Object[])new Object[0]);
                Print.sysPrintln((String)("ERROR: Account-ID does not exist: " + string2), (Object[])new Object[0]);
                EventSelector.usage();
            }
        }
        catch (DBException dBException) {
            Print.logException((String)("Error checking Account existance: " + string2), (Throwable)dBException);
            System.exit(99);
        }
        String string4 = RTConfig.getString((String[])ARG_USER, (String)"");
        try {
            if (!StringTools.isBlank((String)string4) && !User.exists((String)string2, (String)string4)) {
                Print.sysPrintln((String)"", (Object[])new Object[0]);
                Print.sysPrintln((String)("ERROR: User-ID does not exist: " + string2 + "/" + string4), (Object[])new Object[0]);
                EventSelector.usage();
            }
        }
        catch (DBException dBException) {
            Print.logException((String)("Error checking User existance: " + string2 + "/" + string4), (Throwable)dBException);
            System.exit(99);
        }
        String string5 = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        if (StringTools.isBlank((String)string5) && string2.equals("demo")) {
            string5 = "demo";
        }
        if (string5.equals("NONE")) {
            string5 = "";
        } else if (!StringTools.isBlank((String)string5)) {
            try {
                if (StringTools.isBlank((String)string5)) {
                    Print.sysPrintln((String)"", (Object[])new Object[0]);
                    Print.sysPrintln((String)"ERROR: Device-ID not specified.", (Object[])new Object[0]);
                    EventSelector.usage();
                }
                if (!Device.exists((String)string2, (String)string5)) {
                    Print.sysPrintln((String)"", (Object[])new Object[0]);
                    Print.sysPrintln((String)("ERROR: Device-ID does not exist: " + string2 + "/" + string5), (Object[])new Object[0]);
                    EventSelector.usage();
                }
            }
            catch (DBException dBException) {
                Print.logException((String)("Error checking Device existance: " + string2 + "/" + string5), (Throwable)dBException);
                System.exit(99);
            }
        }
        long l = DateTime.getCurrentTimeSec();
        if (RTConfig.hasProperty((String[])ARG_TIMESTAMP)) {
            String string6 = RTConfig.getString((String[])ARG_TIMESTAMP, null);
            try {
                string = DateTime.parseArgumentDate((String)string6, null, (boolean)false);
                l = string.getTimeSec();
            }
            catch (DateTime.DateParseException dateParseException) {
                Print.sysPrintln((String)("Invalid Time format: " + string6), (Object[])new Object[0]);
            }
        }
        int n2 = RTConfig.getInt((String[])ARG_CODE, (int)61472);
        string = RTConfig.getString((String[])ARG_GPS, (String)"37.784/-142.399");
        GeoPoint geoPoint2 = new GeoPoint(string);
        if (!geoPoint2.isValid()) {
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            Print.sysPrintln((String)("ERROR: Specified GeoPoint is not valid: " + string), (Object[])new Object[0]);
            EventSelector.usage();
        }
        double d = 0.0;
        if (RTConfig.hasProperty((String[])ARG_KPH)) {
            d = RTConfig.getDouble((String[])ARG_KPH, (double)0.0);
        } else if (RTConfig.hasProperty((String[])ARG_MPH)) {
            d = RTConfig.getDouble((String[])ARG_MPH, (double)0.0) * 1.609344;
        }
        double d2 = RTConfig.getDouble((String[])ARG_ODOM, (double)0.0);
        double[] dArray = RTConfig.getDoubleArray((String[])ARG_THERMAL, null);
        long l2 = DateTime.getCurrentTimeSec();
        boolean bl = false;
        String string7 = new DateTime(1381279040L).toString();
        Print.sysPrintln((String)"-------------------------------------------------------------------------------", (Object[])new Object[0]);
        Print.sysPrintln((String)"Rule Evaluation Testing Utility", (Object[])new Object[0]);
        Print.sysPrintln((String)"Copyright 2007-2013, GeoTelematic Solutions, Inc.", (Object[])new Object[0]);
        Print.sysPrintln((String)"Service ID  : mutinda", (Object[])new Object[0]);
        Print.sysPrintln((String)("Tool Version: 1.3.12, 1381279040 [" + string7 + "]"), (Object[])new Object[0]);
        Print.sysPrintln((String)("ENRE Version: " + eventSelector._getVersion() + (VCHECK_ERROR != null ? " [" + VCHECK_ERROR + "]" : "")), (Object[])new Object[0]);
        Print.sysPrintln((String)("GTS  Version: " + Version.getVersion()), (Object[])new Object[0]);
        Print.sysPrintln((String)"(subject to licensing terms/conditions which accompany this software product)", (Object[])new Object[0]);
        Print.sysPrintln((String)"-------------------------------------------------------------------------------", (Object[])new Object[0]);
        Account account = null;
        User user = null;
        Device device = null;
        EventData eventData = null;
        TimeZone timeZone = null;
        boolean bl2 = true;
        boolean bl3 = true;
        try {
            account = Account.getAccount((String)string2);
            user = !StringTools.isBlank((String)string4) ? User.getUser((Account)account, (String)string4) : null;
            device = !StringTools.isBlank((String)string5) ? Device.getDevice((Account)account, (String)string5) : null;
            TimeZone timeZone2 = timeZone = account != null ? DateTime.getTimeZone((String)account.getTimeZone()) : DateTime.getGMTTimeZone();
            if (n2 == 0 || l <= 0L) {
                eventData = null;
            } else if (device != null) {
                long l3;
                long l4;
                geoPoint = new EventData.Key(string2, string5, l, n2);
                object = (EventData)geoPoint.getDBRecord();
                object.setGeoPoint(geoPoint2);
                object.setSpeedKPH(d);
                object.setOdometerKM(d2);
                object.setAccount(account);
                object.setDevice(device);
                if (d <= 0.0) {
                    l4 = 0L;
                    l3 = l - DateTime.MinuteSeconds((long)23L);
                    Print.logInfo((String)"Setting Device as STOPPED", (Object[])new Object[0]);
                    device.setLastStartTime(l4);
                    device.setLastStopTime(l3);
                } else {
                    l4 = l - DateTime.MinuteSeconds((long)56L);
                    l3 = 0L;
                    Print.logInfo((String)"Setting Device as MOVING", (Object[])new Object[0]);
                    device.setLastStartTime(l4);
                    device.setLastStopTime(l3);
                }
                if (!ListTools.isEmpty((double[])dArray)) {
                    for (int i = 0; i < dArray.length; ++i) {
                        object.setThermoAverage(i, dArray[i]);
                    }
                }
                object.setDriverMessage("Hello World");
                object.setDriverID("smith");
                eventData = object;
            } else {
                eventData = null;
            }
            account.setCurrentUser(user);
        }
        catch (DBException dBException) {
            Print.sysPrintln((String)"Unable to load Account/Device/EventData", (Object[])new Object[0]);
            Print.sysPrintln((String)("AccountID : " + string2), (Object[])new Object[0]);
            Print.sysPrintln((String)("DeviceID  : " + string5), (Object[])new Object[0]);
            Print.sysPrintln((String)"-------------------------------------------------------------------------------", (Object[])new Object[0]);
            dBException.printStackTrace();
            Print.sysPrintln((String)"-------------------------------------------------------------------------------", (Object[])new Object[0]);
            System.exit(99);
        }
        geoPoint = device != null ? device.getLastValidLocation() : GeoPoint.INVALID_GEOPOINT;
        Print.sysPrintln((String)"Default Attributes:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  CronMode  : " + EventSelector.GetCronMode()), (Object[])new Object[0]);
        Print.sysPrintln((String)("  Account   : " + account), (Object[])new Object[0]);
        Print.sysPrintln((String)("  User      : " + user), (Object[])new Object[0]);
        Print.sysPrintln((String)("  Device    : " + device), (Object[])new Object[0]);
        Print.sysPrintln((String)("  EventData : " + eventData), (Object[])new Object[0]);
        Print.sysPrintln((String)("  Timestamp : " + l + " [" + new DateTime(l, timeZone) + "]"), (Object[])new Object[0]);
        Print.sysPrintln((String)("  StatusCode: " + StatusCodes.GetHex((int)n2) + " [" + StatusCodes.GetDescription((int)n2, null) + "]"), (Object[])new Object[0]);
        Print.sysPrintln((String)("  GeoPoint  : " + geoPoint2), (Object[])new Object[0]);
        Print.sysPrintln((String)("  Prev GP   : " + geoPoint), (Object[])new Object[0]);
        Print.sysPrintln((String)("  Speed     : " + d + " km/h"), (Object[])new Object[0]);
        Print.sysPrintln((String)("  Odometer  : " + d2 + " km"), (Object[])new Object[0]);
        Print.sysPrintln((String)("  Temp C    : " + StringTools.join((double[])dArray, (String)",")), (Object[])new Object[0]);
        Print.sysPrintln((String)"-------------------------------------------------------------------------------", (Object[])new Object[0]);
        object = "Special commands: (prefixed with '/' character\n  exit                      Exit this command-line utility\n  /exit                     Exit this command-line utility\n  /list    [<partialID>]    List of identifiers beginning with partial name\n  /list    $[<partialFTN>]  List of functions beginning with partial name\n  /syntax  <selector>       syntax check specified selector\n  /rule    <ruleID>         execute selector for specified rule-id\n  /exerule <ruleID>         execute selector and action for specified rule-id\n  /message <text>           display message with replaced ${..} vars\n  /set     <field>=<value>  set EventData field to value\n  /help    <identifier>     <identifier> help information\n  /help    $<function>      $<function> help information";
        Print.sysPrintln((String)object, (Object[])new Object[0]);
        Print.sysPrintln((String)"------------------------------------------------------------------------------", (Object[])new Object[0]);
        String string8 = "/exit";
        String string9 = "/quit";
        String string10 = "/list";
        String string11 = "/help";
        String string12 = "/syntax";
        String string13 = "/ftncheck";
        String string14 = "/rule";
        String string15 = "/exerule";
        String string16 = "/message";
        String string17 = "/msg";
        String string18 = "/set";
        String string19 = "/get";
        String string20 = "/reload";
        String[] stringArray2 = new String[]{string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19, string20};
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                Print.sysPrint((String)"Expression> ", (Object[])new Object[0]);
                String string21 = "";
                try {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object7;
                    String string22 = bufferedReader.readLine();
                    if (string22 == null || (string21 = string22.trim()).equalsIgnoreCase("exit") || string21.equalsIgnoreCase(string8) || string21.equalsIgnoreCase("quit") || string21.equalsIgnoreCase(string9)) break;
                    if (StringTools.isBlank((String)string21)) continue;
                    if (device == null) {
                        Print.logWarn((String)"Device is null", (Object[])new Object[0]);
                    } else if (bl2) {
                        long l5 = device.getLastStartTime();
                        long l6 = device.getLastStopTime();
                        device.reload();
                        device.setLastStartTime(l5);
                        device.setLastStopTime(l6);
                    }
                    if (account == null) {
                        Print.logWarn((String)"Account is null", (Object[])new Object[0]);
                    } else if (bl3) {
                        account.reload();
                    }
                    if (string21.startsWith(string20)) {
                        boolean bl4;
                        object7 = string21.substring(string20.length()).trim();
                        bl2 = bl4 = StringTools.parseBoolean((String)object7, (boolean)bl2);
                        bl3 = bl4;
                        Print.sysPrintln((String)("Account/Device reload is " + (bl4 ? "ON" : "OFF")), (Object[])new Object[0]);
                        continue;
                    }
                    if (string21.startsWith(string18)) {
                        void var50_76;
                        object7 = string21.substring(string18.length()).trim();
                        int n3 = ((String)object7).indexOf("=");
                        if (n3 <= 0) {
                            Print.sysPrintln((String)"Invalid FIELD=VALUE specification.", (Object[])new Object[0]);
                            continue;
                        }
                        String string23 = "EventData";
                        String string6 = ((String)object7).substring(0, n3).trim();
                        object5 = ((String)object7).substring(n3 + 1).trim();
                        int n4 = string6.indexOf(".");
                        if (n4 >= 0) {
                            string23 = string6.substring(0, n4).trim();
                            String string24 = string6.substring(n4 + 1).trim();
                        }
                        EventData eventData2 = null;
                        if (string23.equalsIgnoreCase("EventData") || StringTools.isBlank((String)string23)) {
                            eventData2 = eventData;
                        } else if (string23.equalsIgnoreCase("Device")) {
                            eventData2 = device;
                        } else if (string23.equalsIgnoreCase("Account")) {
                            eventData2 = account;
                        } else {
                            Print.sysPrintln((String)("'/set' not supported for table: " + string23), (Object[])new Object[0]);
                            continue;
                        }
                        object4 = DBRecord.getFactory((DBRecord)eventData2);
                        Object object6 = object3 = object4 != null ? object4.getField((String)var50_76) : null;
                        if (object3 == null) {
                            Print.sysPrintln((String)("Field not found: " + string23 + "." + (String)var50_76), (Object[])new Object[0]);
                            continue;
                        }
                        if (object3.isPrimaryKey()) {
                            Print.sysPrintln((String)("'/set' cannot be used on a primary key field: " + string23 + "." + (String)var50_76), (Object[])new Object[0]);
                            continue;
                        }
                        object2 = object3.parseStringValue((String)object5);
                        eventData2.setValue((String)var50_76, object2);
                        Print.sysPrintln((String)("Set '" + string23 + "." + (String)var50_76 + "': " + eventData2.getValue((String)var50_76)), (Object[])new Object[0]);
                        continue;
                    }
                    if (string21.startsWith(string19)) {
                        void var50_79;
                        object7 = string21.substring(string19.length()).trim();
                        int n5 = ((String)object7).indexOf("=");
                        if (n5 >= 0) {
                            object7 = ((String)object7).substring(0, n5).trim();
                        }
                        String string24 = "EventData";
                        Object object8 = object7;
                        int n6 = ((String)object8).indexOf(".");
                        if (n6 >= 0) {
                            string24 = ((String)object8).substring(0, n6).trim();
                            String string25 = ((String)object8).substring(n6 + 1).trim();
                        }
                        EventData eventData3 = null;
                        if (string24.equalsIgnoreCase("EventData") || StringTools.isBlank((String)string24)) {
                            eventData3 = eventData;
                        } else if (string24.equalsIgnoreCase("Device")) {
                            eventData3 = device;
                        } else if (string24.equalsIgnoreCase("Account")) {
                            eventData3 = account;
                        } else {
                            Print.sysPrintln((String)("'/get' not supported for table: " + string24), (Object[])new Object[0]);
                            continue;
                        }
                        DBFactory dBFactory = DBRecord.getFactory((DBRecord)eventData3);
                        DBField dBField = object4 = dBFactory != null ? dBFactory.getField((String)var50_79) : null;
                        if (object4 == null) {
                            Print.sysPrintln((String)("Field not found: " + string24 + "." + (String)var50_79), (Object[])new Object[0]);
                            continue;
                        }
                        object3 = eventData3.getValue((String)var50_79);
                        Print.sysPrintln((String)("Get '" + string24 + "." + (String)var50_79 + "': " + object3), (Object[])new Object[0]);
                        continue;
                    }
                    if (string21.startsWith(string10)) {
                        object7 = string21.substring(string10.length()).trim();
                        Print.sysPrintln((String)"------------------------------------------------------------------------------", (Object[])new Object[0]);
                        if (((String)object7).startsWith("$")) {
                            EventSelector.listFunctions(eventSelector, n, string3, (String)object7);
                        } else {
                            EventSelector.listIdentifiers(eventSelector, n, string3, (String)object7);
                        }
                        Print.sysPrintln((String)"------------------------------------------------------------------------------", (Object[])new Object[0]);
                        Print.sysPrintln((String)"", (Object[])new Object[0]);
                        continue;
                    }
                    if (string21.startsWith(string11)) {
                        object7 = string21.substring(string11.length()).trim();
                        if (((String)object7).startsWith("$")) {
                            Print.sysPrintln((String)"------------------------------------------------------------------------------", (Object[])new Object[0]);
                            FunctionHandler functionHandler = eventSelector.getFunction((String)object7);
                            if (functionHandler != null) {
                                Print.sysPrintln((String)functionHandler.getUsage(), (Object[])new Object[0]);
                                Print.sysPrintln((String)functionHandler.getDescription(), (Object[])new Object[0]);
                            } else {
                                Print.sysPrintln((String)("Function not found: " + (String)object7), (Object[])new Object[0]);
                            }
                        } else if (!StringTools.isBlank((String)object7)) {
                            Print.sysPrintln((String)"------------------------------------------------------------------------------", (Object[])new Object[0]);
                            IdentifierHandler identifierHandler = eventSelector.getIdentifier((String)object7);
                            if (identifierHandler != null) {
                                Print.sysPrintln((String)identifierHandler.getDescription(), (Object[])new Object[0]);
                            } else {
                                Print.sysPrintln((String)("Identifier not found: " + (String)object7), (Object[])new Object[0]);
                            }
                        }
                        Print.sysPrintln((String)"------------------------------------------------------------------------------", (Object[])new Object[0]);
                        Print.sysPrintln((String)object, (Object[])new Object[0]);
                        Print.sysPrintln((String)"------------------------------------------------------------------------------", (Object[])new Object[0]);
                        Print.sysPrintln((String)"", (Object[])new Object[0]);
                        continue;
                    }
                    if (string21.startsWith(string12)) {
                        object7 = string21.substring(string12.length()).trim();
                        Print.sysPrintln((String)"------------------------------------------------------------------------------", (Object[])new Object[0]);
                        boolean bl5 = eventSelector.checkSyntax((String)object7, eventData != null ? eventData : account);
                        Print.sysPrintln((String)(" ==> syntax: " + (bl5 ? "Valid" : "Invalid")), (Object[])new Object[0]);
                        Print.sysPrintln((String)"------------------------------------------------------------------------------", (Object[])new Object[0]);
                        Print.sysPrintln((String)"", (Object[])new Object[0]);
                        continue;
                    }
                    if (string21.startsWith(string13)) {
                        object7 = eventData != null ? eventData : account;
                        Collection<FunctionHandler> collection = eventSelector.getFunctionMapFactory().getFunctions();
                        for (FunctionHandler functionHandler : collection) {
                            object5 = (EventFunctionHandler)functionHandler;
                            String[] stringArray3 = ((EventFunctionHandler)object5).getNames();
                            EventFunctionHandler.ArgCk argCk = ((EventFunctionHandler)object5).getArgCheck();
                            if (argCk == null) {
                                Print.sysPrintln((String)(stringArray3[0] + " : ArgCk is null ..."), (Object[])new Object[0]);
                                Print.sysPrintln((String)"", (Object[])new Object[0]);
                                continue;
                            }
                            object4 = argCk.getArgCounts();
                            object3 = argCk.getArgTypes();
                            object2 = stringArray3[0];
                            block21: for (int i = 0; i < ((DBField)object4).length; ++i) {
                                for (int j = 0; j < 2; ++j) {
                                    StringBuffer stringBuffer = new StringBuffer();
                                    stringBuffer.append((String)object2);
                                    stringBuffer.append("(");
                                    Object object9 = object4[i];
                                    for (int k = 0; k < object9; ++k) {
                                        Class clazz;
                                        if (k > 0) {
                                            stringBuffer.append(",");
                                        }
                                        if ((clazz = object3[k]).equals(String.class)) {
                                            stringBuffer.append("\"demo\"");
                                            continue;
                                        }
                                        if (clazz.equals(Object.class)) {
                                            stringBuffer.append(j == 0 ? "\"1\"" : "1");
                                            continue;
                                        }
                                        if (clazz.equals(Double.class)) {
                                            stringBuffer.append("0.0");
                                            continue;
                                        }
                                        if (clazz.equals(Long.class)) {
                                            stringBuffer.append("1");
                                            continue;
                                        }
                                        if (clazz.equals(Boolean.class)) {
                                            stringBuffer.append("1");
                                            continue;
                                        }
                                        Print.logError((String)("Unrecognized type: " + StringTools.className((Object)clazz)), (Object[])new Object[0]);
                                    }
                                    stringBuffer.append(")");
                                    String string26 = stringBuffer.toString();
                                    boolean bl4 = eventSelector.checkSyntax(string26, object7);
                                    String string27 = "   " + StringTools.leftAlign((String)string26, (int)22) + " ==> ";
                                    if (j > 0) {
                                        string27 = string27 + "(retry) ";
                                    }
                                    if (bl4) {
                                        try {
                                            Selector.Result result = EventSelector.getInstance().getResult(0, string26, object7);
                                            Print.sysPrintln((String)(string27 + "OK"), (Object[])new Object[0]);
                                            continue block21;
                                        }
                                        catch (ParserException parserException) {
                                            Print.sysPrintln((String)(string27 + parserException.getMessage()), (Object[])new Object[0]);
                                            continue;
                                        }
                                    }
                                    Print.sysPrintln((String)(string27 + "Invalid Syntax"), (Object[])new Object[0]);
                                }
                            }
                        }
                        Print.sysPrintln((String)"", (Object[])new Object[0]);
                        continue;
                    }
                    if (string21.startsWith(string16) || string21.startsWith(string17)) {
                        object7 = string21.startsWith(string16) ? string21.substring(string16.length()).trim() : string21.substring(string17.length()).trim();
                        EventRuleAction.EventDataText eventDataText = new EventRuleAction.EventDataText(account, device, eventData, null, null, null, null);
                        String string27 = eventDataText.toString((String)object7);
                        Print.sysPrintln((String)("Message: " + string27), (Object[])new Object[0]);
                        Print.sysPrintln((String)"", (Object[])new Object[0]);
                        continue;
                    }
                    object7 = null;
                    int n7 = 0;
                    if (string21.startsWith(string14) || string21.startsWith(string15)) {
                        block135: {
                            String string28;
                            if (account == null) {
                                Print.sysPrintln((String)"Account not specified (required for RuleID specification)", (Object[])new Object[0]);
                                Print.sysPrintln((String)"", (Object[])new Object[0]);
                                continue;
                            }
                            String[] stringArray4 = null;
                            if (string21.startsWith(string14)) {
                                stringArray4 = StringTools.split((String)string21.substring(string14.length()).trim(), (char)' ');
                            } else if (string21.startsWith(string15)) {
                                stringArray4 = StringTools.split((String)string21.substring(string15.length()).trim(), (char)' ');
                                n7 = 1;
                            }
                            String string29 = string28 = stringArray4.length >= 1 ? stringArray4[0] : null;
                            if (StringTools.isBlank((String)string28)) {
                                Print.sysPrintln((String)"RuleID not specified", (Object[])new Object[0]);
                                Print.sysPrintln((String)"", (Object[])new Object[0]);
                                continue;
                            }
                            object5 = stringArray4.length >= 2 ? stringArray4[1] : null;
                            try {
                                object7 = Rule.getRule(account, string28);
                                if (object7 == null) {
                                    Print.sysPrintln((String)("RuleID does not exist: " + string28), (Object[])new Object[0]);
                                    Print.sysPrintln((String)"", (Object[])new Object[0]);
                                    continue;
                                }
                                if (StringTools.isBlank((String)object5)) break block135;
                                ((Rule)((Object)object7)).setCannedActions((String)object5);
                            }
                            catch (DBException dBException) {
                                Print.sysPrintln((String)("Unable to retrieve Rule: " + (Object)((Object)dBException)), (Object[])new Object[0]);
                                Print.sysPrintln((String)"", (Object[])new Object[0]);
                                continue;
                            }
                        }
                        string21 = ((Rule)((Object)object7)).getSelector();
                    }
                    Object object11 = eventData != null ? eventData : (device != null ? device : (account != null ? account : null));
                    Selector.Result result = EventSelector.getInstance().getResult(0, string21, object11);
                    object5 = result.getValue();
                    String string30 = StringTools.className((Object)object5);
                    if (string30.startsWith("java.lang.")) {
                        string30 = string30.substring("java.lang.".length());
                    }
                    Print.sysPrintln((String)(" ==> object  : " + StringTools.className((Object)object11)), (Object[])new Object[0]);
                    Print.sysPrintln((String)(" ==> selector: " + string21), (Object[])new Object[0]);
                    Print.sysPrintln((String)(" ==> value   : " + object5), (Object[])new Object[0]);
                    Print.sysPrintln((String)(" ==> type    : " + string30), (Object[])new Object[0]);
                    Print.sysPrintln((String)(" ==> match   : " + result.isMatch()), (Object[])new Object[0]);
                    if (object7 != null) {
                        Print.sysPrintln((String)"", (Object[])new Object[0]);
                        if (result.isMatch()) {
                            boolean bl5 = true;
                            if (eventData != null) {
                                if (((Rule)((Object)object7)).elapsedMinimumNotifyAge(eventData.getDevice())) {
                                    Print.sysPrintln((String)"Updating RuleTrigger for Device/Rule ...", (Object[])new Object[0]);
                                    RuleTrigger.setRuleTriggerTime(eventData.getDevice(), (Rule)((Object)object7), -1L);
                                } else {
                                    Print.sysPrintln((String)"Skipping rule actions due to recent trigger ...\n", (Object[])new Object[0]);
                                    bl5 = false;
                                }
                            } else if (device != null) {
                                if (((Rule)((Object)object7)).elapsedMinimumNotifyAge(device)) {
                                    Print.sysPrintln((String)"Updating RuleTrigger for Device/Rule ...", (Object[])new Object[0]);
                                    RuleTrigger.setRuleTriggerTime(device, (Rule)((Object)object7), -1L);
                                } else {
                                    Print.sysPrintln((String)"Skipping rule actions due to recent trigger ...\n", (Object[])new Object[0]);
                                    bl5 = false;
                                }
                            } else if (account != null) {
                                if (((Rule)((Object)object7)).elapsedMinimumNotifyAge(account)) {
                                    Print.sysPrintln((String)"Updating RuleTrigger for Account/Rule ...", (Object[])new Object[0]);
                                    RuleTrigger.setRuleTriggerTime(account, (Rule)((Object)object7), -1L);
                                } else {
                                    Print.sysPrintln((String)"Skipping rule actions due to recent trigger ...\n", (Object[])new Object[0]);
                                    bl5 = false;
                                }
                            } else {
                                Print.sysPrintln((String)"Skipping rule actions due to unknown object type ...\n", (Object[])new Object[0]);
                                bl5 = false;
                            }
                            if (bl5 && n7 != 0) {
                                if (eventData != null) {
                                    object4 = StringTools.trim((String)((Rule)((Object)object7)).getCannedActions());
                                    if (object7 != null) {
                                        int n8 = ((Rule)((Object)object7)).getActionMask();
                                        object3 = "[0x" + StringTools.toHexString((long)n8, (int)24) + "] " + EventRuleAction.GetActionMaskDescription(n8);
                                    } else {
                                        object3 = "default";
                                    }
                                    Print.sysPrintln((String)"-----------------------------------------------------", (Object[])new Object[0]);
                                    if (!StringTools.isBlank((String)object4)) {
                                        Print.sysPrintln((String)("Executing Rule Actions: actionMask=" + (String)object3 + " [CRA " + (String)object4 + "]"), (Object[])new Object[0]);
                                    } else {
                                        Print.sysPrintln((String)("Executing Rule Actions: actionMask=" + (String)object3), (Object[])new Object[0]);
                                    }
                                    EventRuleAction._debugSendNotification(eventData, (Rule)((Object)object7));
                                    if (device != null) {
                                        device.updateOtherChangedEventFields();
                                    }
                                } else {
                                    Print.sysPrintln((String)"Unable to execute Rule Action: event is null", (Object[])new Object[0]);
                                }
                            }
                        } else if (eventData != null) {
                            Print.sysPrintln((String)"Clearing RuleTrigger for Device/Rule ...\n", (Object[])new Object[0]);
                            RuleTrigger.clearRuleTriggerTime(eventData.getDevice(), (Rule)((Object)object7));
                        } else if (device != null) {
                            Print.sysPrintln((String)"Clearing RuleTrigger for Device/Rule ...\n", (Object[])new Object[0]);
                            RuleTrigger.clearRuleTriggerTime(device, (Rule)((Object)object7));
                        } else if (account != null) {
                            Print.sysPrintln((String)"Clearing RuleTrigger for Account/Rule ...\n", (Object[])new Object[0]);
                            RuleTrigger.clearRuleTriggerTime(account, (Rule)((Object)object7));
                        }
                    }
                    Print.sysPrintln((String)"", (Object[])new Object[0]);
                }
                catch (ParserException parserException) {
                    Print.sysPrintln((String)(" ERROR: " + parserException.getMessage()), (Object[])new Object[0]);
                    for (String string31 : stringArray2) {
                        if (string21.indexOf(string31.substring(1)) < 0) continue;
                        Print.sysPrintln((String)" -- Missing prefixing '/'?", (Object[])new Object[0]);
                        break;
                    }
                    Print.sysPrintln((String)"", (Object[])new Object[0]);
                }
            }
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            Print.sysPrintln((String)"... exit ...", (Object[])new Object[0]);
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

