/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.event;

import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Driver;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.rule.selector.IdentifierMap;
import org.opengts.rule.selector.IdentifierMapFactory;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class EventIdentifierMap
extends IdentifierMap {
    protected static final Long LONG_TRUE = new Long(1L);
    protected static final Long LONG_FALSE = new Long(0L);
    protected static final Long LONG_ZERO = new Long(0L);

    public EventIdentifierMap(IdentifierMapFactory identifierMapFactory) {
        super(identifierMapFactory);
    }

    public EventIdentifierMap(IdentifierMapFactory identifierMapFactory, EventData eventData) {
        super(identifierMapFactory, eventData);
    }

    public EventIdentifierMap(IdentifierMapFactory identifierMapFactory, Account account) {
        super(identifierMapFactory, account);
    }

    public EventIdentifierMap(IdentifierMapFactory identifierMapFactory, Device device) {
        super(identifierMapFactory, device);
    }

    public EventData getEventData() {
        Object object = super.getObject();
        if (object instanceof EventData) {
            return (EventData)object;
        }
        if (object instanceof Account) {
            return null;
        }
        if (object instanceof Device) {
            return null;
        }
        return null;
    }

    public Account getAccount() {
        Object object = super.getObject();
        if (object instanceof EventData) {
            return ((EventData)object).getAccount();
        }
        if (object instanceof Account) {
            return (Account)object;
        }
        if (object instanceof Device) {
            return ((Device)object).getAccount();
        }
        return null;
    }

    public String getAccountID() {
        Account account = this.getAccount();
        return account != null ? account.getAccountID() : "";
    }

    public Device getDevice() {
        Object object = super.getObject();
        if (object instanceof EventData) {
            return ((EventData)object).getDevice();
        }
        if (object instanceof Account) {
            return null;
        }
        if (object instanceof Device) {
            return (Device)object;
        }
        return null;
    }

    public String getDeviceID() {
        Device device = this.getDevice();
        return device != null ? device.getDeviceID() : "";
    }

    public String getDriverID() {
        String string;
        Object object = super.getObject();
        if (object instanceof EventData && !StringTools.isBlank((String)(string = ((EventData)object).getDriverID()))) {
            return string;
        }
        if (object instanceof Device && !StringTools.isBlank((String)(string = ((Device)object).getDriverID()))) {
            return string;
        }
        return null;
    }

    public Driver getDriver() {
        String string = this.getDriverID();
        if (StringTools.isBlank((String)string)) {
            return null;
        }
        try {
            Account account = this.getAccount();
            Driver driver = Driver.getDriver((Account)account, (String)string);
            if (driver == null) {
                Print.logWarn((String)("Driver does not exist: " + string), (Object[])new Object[0]);
            }
            return driver;
        }
        catch (DBException dBException) {
            Print.logWarn((String)("Error reading Driver: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return null;
        }
    }

    @Override
    public Object getUndefinedIdentifierValue(String string) {
        EventData eventData = this.getEventData();
        if (eventData == null) {
            return null;
        }
        Object object = eventData.getValue(string);
        if (object == null) {
            return null;
        }
        Print.logInfo((String)("Returning EventData field value: " + string), (Object[])new Object[0]);
        if (object instanceof Double || object instanceof Long || object instanceof String) {
            return object;
        }
        if (object instanceof Float) {
            return new Double(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? LONG_TRUE : LONG_FALSE;
        }
        if (object instanceof Number) {
            return new Long(((Number)object).longValue());
        }
        return object.toString();
    }
}

