/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule.event;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TimeZone;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Driver;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.rule.event.EventFunctionHandler;
import org.opengts.rule.event.EventSelector;
import org.opengts.rule.selector.FunctionMap;
import org.opengts.rule.selector.FunctionMapFactory;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class EventFunctionMap
extends FunctionMap {
    private static final Object[] EMPTY_ARGS = new Object[0];

    private EventFunctionMap(FunctionMapFactory functionMapFactory) {
        super(functionMapFactory);
    }

    public EventFunctionMap(FunctionMapFactory functionMapFactory, int n, EventData eventData, boolean bl) {
        super(functionMapFactory, n, eventData, bl);
    }

    public EventFunctionMap(FunctionMapFactory functionMapFactory, int n, Account account, boolean bl) {
        super(functionMapFactory, n, account, bl);
    }

    public EventFunctionMap(FunctionMapFactory functionMapFactory, int n, User user, boolean bl) {
        super(functionMapFactory, n, user, bl);
    }

    public EventFunctionMap(FunctionMapFactory functionMapFactory, int n, Device device, boolean bl) {
        super(functionMapFactory, n, device, bl);
    }

    @Override
    public Object invoke(String string, Object[] objectArray) {
        EventFunctionHandler eventFunctionHandler = (EventFunctionHandler)this.getFunction(string);
        if (eventFunctionHandler != null) {
            if (this.syntaxCheckOnly()) {
                if (eventFunctionHandler.checkArgs(objectArray)) {
                    return eventFunctionHandler.getDefaultValue();
                }
                return null;
            }
            if (eventFunctionHandler.isSystemAdminOnly() && !AccountRecord.isSystemAdmin((Account)this.getAccount())) {
                Print.logWarn((String)("SystemAdmin Only Function: " + string), (Object[])new Object[0]);
                return eventFunctionHandler.getDefaultValue();
            }
            if (eventFunctionHandler.isCronOnly() && !EventSelector.GetCronMode()) {
                Print.logWarn((String)("CronMode Only Function: " + string), (Object[])new Object[0]);
                return eventFunctionHandler.getDefaultValue();
            }
            try {
                return eventFunctionHandler.invokeFunction(this, objectArray != null ? objectArray : EMPTY_ARGS);
            }
            catch (NullPointerException nullPointerException) {
                Print.logException((String)"Null pointer", (Throwable)nullPointerException);
                return null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Print.logException((String)"Array out of bounds", (Throwable)arrayIndexOutOfBoundsException);
                return null;
            }
            catch (Throwable throwable) {
                Print.logError((String)("Function invocation error: " + throwable), (Object[])new Object[0]);
                return null;
            }
        }
        return null;
    }

    public EventData getEventData() {
        Object object = super.getObject();
        if (object instanceof EventData) {
            return (EventData)object;
        }
        return null;
    }

    public EventData getPreviousEventData() {
        return this.getPreviousEventData(null, true);
    }

    public EventData getPreviousEventData(boolean bl) {
        return this.getPreviousEventData(null, bl);
    }

    public EventData getPreviousEventData(int[] nArray, boolean bl) {
        EventData eventData = this.getEventData();
        if (eventData != null) {
            try {
                EventData eventData2 = eventData.getPreviousEventData(nArray, bl);
                if (eventData2 != null) {
                    return eventData2;
                }
            }
            catch (DBException dBException) {
                Print.logError((String)("DBException: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            }
        }
        return null;
    }

    public Account getAccount() {
        Object object = super.getObject();
        if (object instanceof EventData) {
            return ((EventData)object).getAccount();
        }
        if (object instanceof Account) {
            return (Account)object;
        }
        if (object instanceof User) {
            return ((User)object).getAccount();
        }
        if (object instanceof Device) {
            return ((Device)object).getAccount();
        }
        return null;
    }

    public String getAccountID() {
        Account account = this.getAccount();
        return account != null ? account.getAccountID() : "";
    }

    public BasicPrivateLabel getPrivateLabel() {
        Account account = this.getAccount();
        return account != null ? account.getPrivateLabel() : null;
    }

    public User getUser() {
        Object object = super.getObject();
        if (object instanceof Account) {
            return ((Account)object).getCurrentUser();
        }
        if (object instanceof User) {
            return (User)object;
        }
        return null;
    }

    public String getUserID() {
        User user = this.getUser();
        return user != null ? user.getUserID() : "";
    }

    public Device getDevice() {
        Object object = super.getObject();
        if (object instanceof EventData) {
            return ((EventData)object).getDevice();
        }
        if (object instanceof Device) {
            return (Device)object;
        }
        return null;
    }

    public String getDeviceID() {
        Device device = this.getDevice();
        return device != null ? device.getDeviceID() : "";
    }

    public String getDriverID() {
        Object object = super.getObject();
        if (object instanceof EventData) {
            return ((EventData)object).getDriverID();
        }
        if (object instanceof Device) {
            return ((Device)object).getDriverID();
        }
        return null;
    }

    public Driver getDriver(String string) {
        String string2;
        String string3 = string2 = !StringTools.isBlank((String)string) ? string : this.getDriverID();
        if (StringTools.isBlank((String)string2)) {
            return null;
        }
        try {
            Account account = this.getAccount();
            Driver driver = Driver.getDriver((Account)account, (String)string2);
            return driver;
        }
        catch (DBException dBException) {
            Print.logWarn((String)("Error reading Driver [" + string2 + "]: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return null;
        }
    }

    public long getTimestamp(long l) {
        EventData eventData = this.getEventData();
        return eventData != null ? eventData.getTimestamp() : l;
    }

    public long getTimestamp() {
        return this.getTimestamp(DateTime.getCurrentTimeSec());
    }

    public TimeZone getTimeZone() {
        return this.getTimeZone(null);
    }

    public TimeZone getTimeZone(String string) {
        Object object;
        if (!StringTools.isBlank((String)string) && (object = DateTime.getTimeZone((String)string, null)) != null) {
            return object;
        }
        object = this.getAccount();
        if (object != null) {
            return DateTime.getTimeZone((String)object.getTimeZone());
        }
        return DateTime.getGMTTimeZone();
    }

    public int getStatusCode() {
        EventData eventData = this.getEventData();
        return eventData != null ? eventData.getStatusCode() : 0;
    }

    public double getLatitude() {
        EventData eventData = this.getEventData();
        return eventData != null ? eventData.getLatitude() : 0.0;
    }

    public double getLongitude() {
        EventData eventData = this.getEventData();
        return eventData != null ? eventData.getLongitude() : 0.0;
    }

    public GeoPoint getGeoPoint() {
        EventData eventData = this.getEventData();
        return eventData != null ? eventData.getGeoPoint() : new GeoPoint();
    }

    public GeoPoint getPreviousGeoPoint() {
        EventData eventData;
        EventData eventData2 = this.getEventData();
        if (eventData2 == null) {
            return null;
        }
        Device device = eventData2.getDevice();
        if (device != null && device.getLastGPSTimestamp() != eventData2.getTimestamp() && (eventData = device.getLastValidLocation()) != null) {
            return eventData;
        }
        try {
            eventData = eventData2.getPreviousEventData(true);
            if (eventData != null) {
                return eventData.getGeoPoint();
            }
        }
        catch (DBException dBException) {
            Print.logError((String)("DBException: " + (Object)((Object)dBException)), (Object[])new Object[0]);
        }
        return null;
    }

    public long getLastEventTime(boolean bl) {
        Device device = this.getDevice();
        if (device == null) {
            return 0L;
        }
        try {
            Object[] objectArray = device.getLatestEvents(1L, bl);
            if (!ListTools.isEmpty((Object[])objectArray)) {
                return objectArray[0].getTimestamp();
            }
            return 0L;
        }
        catch (DBException dBException) {
            Print.logError((String)("Unable to obtain last Device event: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return 0L;
        }
    }

    public static long getLastDCSActivity(String string) {
        return EventFunctionMap.getLastDCSActivity(string, null);
    }

    public static long getLastDCSActivity(String string, String string2) {
        try {
            return EventFunctionMap._getLastDCSActivity(string, string2);
        }
        catch (DBException dBException) {
            Print.logException((String)"Getting Last DCS Activity", (Throwable)dBException);
            return DateTime.getCurrentTimeSec();
        }
    }

    protected static long _getLastDCSActivity(String string, String string2) throws DBException {
        DBSelect dBSelect = new DBSelect(Device.getFactory());
        DBWhere dBWhere = dBSelect.createDBWhere();
        if (!StringTools.isBlank((String)string)) {
            if (!StringTools.isBlank((String)string2)) {
                dBSelect.setWhere(dBWhere.WHERE_(dBWhere.AND(dBWhere.EQ("accountID", (Object)string2), dBWhere.EQ("deviceCode", (Object)string))));
            } else {
                dBSelect.setWhere(dBWhere.WHERE_(dBWhere.EQ("deviceCode", (Object)string)));
            }
        }
        dBSelect.setOrderByFields(new String[]{"lastTotalConnectTime"});
        dBSelect.setOrderAscending(false);
        dBSelect.setLimit(1L);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        long l = -1L;
        DBConnection dBConnection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            dBConnection = DBConnection.getDefaultConnection();
            statement = dBConnection.execute(dBSelect.toString());
            resultSet = statement.getResultSet();
            if (resultSet.next()) {
                string3 = resultSet.getString("accountID");
                string4 = resultSet.getString("deviceID");
                string5 = resultSet.getString("deviceCode");
                l = resultSet.getLong("lastTotalConnectTime");
            }
        }
        catch (SQLException sQLException) {
            throw new DBException("Getting Device lastTotalConnectTime", (Throwable)sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {}
            }
            DBConnection.release((DBConnection)dBConnection);
        }
        if (RTConfig.isDebugMode() && !StringTools.isBlank((String)string3)) {
            Print.logDebug((String)("Last Connect: account=" + string3 + " device=" + string4 + " code=" + string5 + " time=" + new DateTime(l)), (Object[])new Object[0]);
        }
        return l;
    }
}

