/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule;

import java.util.Collection;
import java.util.Set;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.rule.EventRuleAction;
import org.opengts.rule.EventRuleFactory;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;

public class RuleCron {
    private static EventRuleFactory evRuleFact = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_RULE = new String[]{"rule", "ruleID"};
    private static final String[] ARG_TAG = new String[]{"tag", "ruleTag"};
    private static final String[] ARG_SELECTOR = new String[]{"selector"};
    private static final String[] ARG_NOEMAIL = new String[]{"noemail", "debug"};
    private static final String[] ARG_EMAIL_SUBJ = new String[]{"emailSubj", "emailSubject"};
    private static final String[] ARG_EMAIL_BODY = new String[]{"emailBody"};
    private static final String[] ARG_SMS_TEXT = new String[]{"smsText", "textMessage"};

    private static EventRuleFactory GetEventRuleFactory() {
        if (evRuleFact == null) {
            evRuleFact = new EventRuleFactory(new EventRuleAction(), true);
            Print.logInfo((String)("EventRuleFactory Cron Mode = " + evRuleFact.getCronMode()), (Object[])new Object[0]);
        }
        return evRuleFact;
    }

    private static int _executeCronRules(Account account, Set<String> set, String string, String string2, String string3, String string4, String string5, String string6) {
        int n = 0;
        if (account == null) {
            Print.logError((String)"Account not specified!", (Object[])new Object[0]);
            n = 99;
            return n;
        }
        String string7 = account.getAccountID();
        EventRuleFactory eventRuleFactory = RuleCron.GetEventRuleFactory();
        if (StringTools.isBlank((String)string)) {
            if (!StringTools.isBlank((String)string2)) {
                string = "ALL";
                string3 = null;
            } else if (StringTools.isBlank((String)string3)) {
                string = "ALL";
                string3 = null;
            } else {
                string = null;
                string2 = null;
            }
        } else if (string.equals("ALL")) {
            string3 = null;
        } else {
            String string8 = eventRuleFactory.getRuleSelector(account, string);
            if (string8 != null) {
                string2 = null;
                string3 = null;
            } else if (!StringTools.isBlank((String)string3)) {
                string = null;
                string2 = null;
            } else {
                Print.logError((String)("No cron ruleID/selector to execute: " + string7), (Object[])new Object[0]);
                n = 99;
                return n;
            }
        }
        if (!ListTools.isEmpty(set)) {
            for (String string9 : set) {
                try {
                    Device device = Device.getDevice((Account)account, (String)string9);
                    if (device != null) {
                        int n2;
                        RTProperties rTProperties;
                        EventData eventData = device.getLastEvent(-1L, false);
                        if (eventData != null) {
                            if (!StringTools.isBlank((String)string3)) {
                                rTProperties = eventData.getTemporaryProperties();
                                rTProperties.setString(EventRuleAction.PROP_emailSubj[0], string4);
                                rTProperties.setString(EventRuleAction.PROP_emailBody[0], string5);
                                rTProperties.setString(EventRuleAction.PROP_smsText[0], string6);
                                n2 = eventRuleFactory.executeSelector(string3, eventData);
                            } else if (string.equals("ALL")) {
                                Print.logDebug((String)("Checking all rules (tag '" + string2 + "') for Device: " + string7 + "/" + string9), (Object[])new Object[0]);
                                n2 = eventRuleFactory.executeRules(eventData, string2);
                            } else {
                                Print.logDebug((String)("Checking ruleID: " + string + " (Device " + string7 + "/" + string9 + ")"), (Object[])new Object[0]);
                                n2 = eventRuleFactory.executeRule(eventData, string);
                            }
                        } else if (!StringTools.isBlank((String)string3)) {
                            rTProperties = device.getTemporaryProperties();
                            rTProperties.setString(EventRuleAction.PROP_emailSubj[0], string4);
                            rTProperties.setString(EventRuleAction.PROP_emailBody[0], string5);
                            rTProperties.setString(EventRuleAction.PROP_smsText[0], string6);
                            n2 = eventRuleFactory.executeSelector(string3, device);
                        } else if (string.equals("ALL")) {
                            Print.logDebug((String)("Checking all rules (tag '" + string2 + "') for Device: " + string7 + "/" + string9), (Object[])new Object[0]);
                            n2 = eventRuleFactory.executeRules(device, string2);
                        } else {
                            Print.logDebug((String)("Checking ruleID: " + string + " (Device " + string7 + "/" + string9 + ")"), (Object[])new Object[0]);
                            n2 = eventRuleFactory.executeRule(device, string);
                        }
                        device.updateOtherChangedEventFields();
                        continue;
                    }
                    Print.logError((String)("Device-ID does not exist: " + string7 + "/" + string9), (Object[])new Object[0]);
                    n = 99;
                }
                catch (DBException dBException) {
                    Print.logException((String)("Error processing rule for Device: " + string9), (Throwable)dBException);
                    n = 99;
                }
            }
        } else if (!StringTools.isBlank((String)string3)) {
            RTProperties rTProperties = account.getTemporaryProperties();
            rTProperties.setString(EventRuleAction.PROP_emailSubj[0], string4);
            rTProperties.setString(EventRuleAction.PROP_emailBody[0], string5);
            rTProperties.setString(EventRuleAction.PROP_smsText[0], string6);
            int n3 = eventRuleFactory.executeSelector(string3, account);
        } else if (string.equals("ALL")) {
            Print.logDebug((String)"Specific rule not specified, ignoring check for all rules ...", (Object[])new Object[0]);
            boolean bl = false;
        } else {
            Print.logDebug((String)("Checking ruleID: " + string), (Object[])new Object[0]);
            int n4 = eventRuleFactory.executeRule(account, string);
        }
        return n;
    }

    private static int _executeCronRules(Account account, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        OrderedSet orderedSet;
        block7: {
            String string8 = account != null ? account.getAccountID() : "NONE";
            orderedSet = null;
            if (string8.equals("NONE") || StringTools.isBlank((String)string) || string.equals("NONE")) {
                orderedSet = null;
            } else {
                if (string.equals("ALL")) {
                    try {
                        orderedSet = Device.getDeviceIDsForAccount((String)string8, null, (boolean)false);
                        if (ListTools.isEmpty((Collection)orderedSet)) {
                            return 0;
                        }
                        break block7;
                    }
                    catch (DBException dBException) {
                        Print.logException((String)("Error loading device names for account: " + string8), (Throwable)dBException);
                        return 99;
                    }
                }
                orderedSet = new OrderedSet((Object[])StringTools.split((String)string, (char)','));
                if (ListTools.isEmpty((Collection)orderedSet)) {
                    Print.logError((String)("No Devices specified: " + string8), (Object[])new Object[0]);
                    return 99;
                }
            }
        }
        return RuleCron._executeCronRules(account, orderedSet, string2, string3, string4, string5, string6, string7);
    }

    protected static int executeCronRules(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Account account = null;
        if (StringTools.isBlank((String)string) || string.equals("NONE")) {
            string = "NONE";
            string2 = "NONE";
        } else {
            try {
                account = Account.getAccount((String)string);
                if (account == null) {
                    Print.logError((String)("Account-ID does not exist: " + string), (Object[])new Object[0]);
                    return 1;
                }
                if (account.isSystemAdmin()) {
                    string2 = "NONE";
                }
            }
            catch (DBException dBException) {
                Print.logException((String)("Error loading Account: " + string), (Throwable)dBException);
                return 99;
            }
        }
        return RuleCron._executeCronRules(account, string2, string3, string4, string5, string6, string7, string8);
    }

    public static int cron(String[] stringArray) {
        RTConfig.setCommandLineArgs((String[])stringArray);
        Print.setLogLevel((int)6);
        Print.setLogHeaderLevel((int)6);
        if (RTConfig.getBoolean((String[])ARG_NOEMAIL, (boolean)false)) {
            SendMail.SetThreadModel((String)"none");
        } else {
            SendMail.SetThreadModel((String)"current");
        }
        String string = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String string2 = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        String string3 = RTConfig.getString((String[])ARG_RULE, null);
        String string4 = RTConfig.getString((String[])ARG_TAG, null);
        String string5 = RTConfig.getString((String[])ARG_SELECTOR, null);
        String string6 = RTConfig.getString((String[])ARG_EMAIL_SUBJ, null);
        String string7 = RTConfig.getString((String[])ARG_EMAIL_BODY, null);
        String string8 = RTConfig.getString((String[])ARG_SMS_TEXT, null);
        if (!StringTools.isBlank((String)string3)) {
            Print.logDebug((String)("RuleID: " + string3 + (!StringTools.isBlank((String)string4) ? " [" + string4 + "]" : "")), (Object[])new Object[0]);
        }
        if (!StringTools.isBlank((String)string5)) {
            Print.logDebug((String)("Selector: " + string5), (Object[])new Object[0]);
        }
        if (StringTools.isBlank((String)string)) {
            Print.logWarn((String)"Missing Account-ID specification", (Object[])new Object[0]);
            return 1;
        }
        Collection collection = null;
        if (string.equals("ALL")) {
            try {
                collection = Account.getAllAccounts();
            }
            catch (DBException dBException) {
                Print.logException((String)"Error getting list of Accounts", (Throwable)dBException);
                return 99;
            }
            if (!string2.equals("NONE")) {
                string2 = "ALL";
            }
        } else {
            collection = ListTools.toList((Object[])StringTools.split((String)string, (char)','));
            string2 = StringTools.blankDefault((String)string2, (String)"ALL");
        }
        int n = 0;
        if (!ListTools.isEmpty((Collection)collection)) {
            for (String string9 : collection) {
                Print.logInfo((String)"=============================", (Object[])new Object[0]);
                if (!StringTools.isBlank((String)string9)) {
                    Print.logInfo((String)("Checking cron-rules for " + string9 + "/" + string2 + " [" + string3 + "]"), (Object[])new Object[0]);
                    int n2 = RuleCron.executeCronRules(string9, string2, string3, string4, string5, string6, string7, string8);
                    if (n2 == 0) continue;
                    n = n2;
                    continue;
                }
                Print.logWarn((String)"Skipping blank account-ID specification", (Object[])new Object[0]);
            }
        } else {
            String string10 = "NONE";
            string2 = "NONE";
            Print.logInfo((String)"=============================", (Object[])new Object[0]);
            Print.logInfo((String)("Checking cron-rules for " + string10 + "/" + string2 + " [" + string3 + "]"), (Object[])new Object[0]);
            int n3 = RuleCron.executeCronRules(string10, string2, string3, string4, string5, string6, string7, string8);
            if (n3 != 0) {
                n = n3;
            }
        }
        return n;
    }

    private static void usage(int n) {
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("  java ... " + RuleCron.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.sysPrintln((String)"Specific Device:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -account=<id>[,<id>]    Acount ID", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -device=<id>            Device ID", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -rule=<rule>            Rule ID", (Object[])new Object[0]);
        Print.sysPrintln((String)"All Devices in an Account:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -account=<id>           Account ID", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -device=ALL             All devices", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -rule=<rule>            Rule ID", (Object[])new Object[0]);
        Print.sysPrintln((String)"All Devices in ALL Accounts:", (Object[])new Object[0]);
        Print.sysPrintln((String)"  -account=ALL", (Object[])new Object[0]);
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        DBConfig.cmdLineInit((String[])stringArray, (boolean)true);
        int n = RuleCron.cron(stringArray);
        if (n == 1) {
            RuleCron.usage(n);
        }
        System.exit(n);
    }
}

