/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule;

import java.io.IOException;
import java.util.Vector;
import org.opengts.util.HTMLTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NotificationQuery {
    public static final String TAG_NotificationQuery = "NotificationQuery";
    public static final String TAG_NotificationAck = "NotificationAck";
    public static final String TAG_MessageAck = "MessageAck";
    public static final String TAG_NotificationRequest = "NotificationRequest";
    public static final String TAG_Account = "Account";
    public static final String TAG_Device = "Device";
    public static final String TAG_Priority = "Priority";
    public static final String TAG_Limit = "Limit";
    public static final String ATTR_user = "user";
    public static final String ATTR_password = "password";
    public static final String ATTR_id = "id";
    public static final String ALL = "*";
    private boolean parseOK = false;
    private String adminUser = null;
    private String adminPass = null;
    private boolean hasAcks = false;
    private String[] messageAcks = null;
    private boolean hasRequest = false;
    private int priority = -1;
    private String accountId = null;
    private String deviceId = null;
    private int limit = -1;
    private static final String[] ARG_HELP = new String[]{"help", "h"};
    private static final String[] ARG_ACK = new String[]{"ackList", "ack"};
    private static final String[] ARG_PRIORITY = new String[]{"priority", "pri"};
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_LIMIT = new String[]{"limit", "lim"};
    private static final String[] ARG_HOSTPORT = new String[]{"hostport", "hp"};
    private static final String[] ARG_URL = new String[]{"url"};

    private NotificationQuery() {
    }

    public NotificationQuery(Document document) {
        this();
        this._parse(document);
    }

    public boolean isValid() {
        return this.parseOK;
    }

    private boolean _parse(Document document) {
        String string;
        Node node;
        int n;
        NodeList nodeList;
        Element element;
        int n2;
        Object object;
        this.parseOK = false;
        if (document == null) {
            return false;
        }
        Element element2 = document.getDocumentElement();
        if (!element2.getTagName().equalsIgnoreCase(TAG_NotificationQuery)) {
            Print.logError((String)"'NotificationQuery' not found in XML", (Object[])new Object[0]);
            return false;
        }
        this.adminUser = element2.getAttribute(ATTR_user);
        this.adminPass = element2.getAttribute(ATTR_password);
        this.hasAcks = false;
        this.messageAcks = null;
        NodeList nodeList2 = XMLTools.getChildElements((Node)element2, (String)TAG_NotificationAck);
        if (nodeList2.getLength() > 0) {
            this.hasAcks = true;
            object = new Vector();
            for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                element = (Element)nodeList2.item(n2);
                nodeList = XMLTools.getChildElements((Node)element, (String)TAG_MessageAck);
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = (Element)nodeList.item(n);
                    string = node.getAttribute(ATTR_id);
                    if (string == null || string.equals("")) {
                        string = XMLTools.getNodeText((Node)node, (String)" ");
                    }
                    if (string == null || string.equals("")) continue;
                    object.add(string);
                }
            }
            if (!object.isEmpty()) {
                this.messageAcks = object.toArray(new String[object.size()]);
            }
        }
        this.hasRequest = false;
        this.priority = -1;
        this.accountId = null;
        this.deviceId = null;
        this.limit = -1;
        object = XMLTools.getChildElements((Node)element2, (String)TAG_NotificationRequest);
        if (object.getLength() > 0) {
            this.hasRequest = true;
            for (n2 = 0; n2 < object.getLength(); ++n2) {
                element = (Element)object.item(n2);
                nodeList = element.getChildNodes();
                for (n = 0; n < nodeList.getLength(); ++n) {
                    String string2;
                    node = nodeList.item(n);
                    if (!(node instanceof Element)) continue;
                    string = node.getNodeName();
                    Element element3 = (Element)node;
                    if (string.equalsIgnoreCase(TAG_Priority)) {
                        string2 = XMLTools.getNodeText((Node)element3, (String)" ");
                        if (string2 == null || string2.equals("") || string2.equals(ALL)) {
                            this.priority = -1;
                            continue;
                        }
                        this.priority = StringTools.parseInt((String)string2, (int)-1);
                        continue;
                    }
                    if (string.equalsIgnoreCase(TAG_Account)) {
                        this.accountId = element3.getAttribute(ATTR_id);
                        if (this.accountId == null || this.accountId.equals("")) {
                            this.accountId = XMLTools.getNodeText((Node)element3, (String)" ");
                        }
                        if (this.accountId == null || !this.accountId.equals("") && !this.accountId.equals(ALL)) continue;
                        this.accountId = null;
                        continue;
                    }
                    if (string.equalsIgnoreCase(TAG_Device)) {
                        this.deviceId = element3.getAttribute(ATTR_id);
                        if (this.deviceId == null || this.deviceId.equals(" ")) {
                            this.deviceId = XMLTools.getNodeText((Node)element3, (String)"");
                        }
                        if (this.deviceId == null || !this.deviceId.equals("") && !this.deviceId.equals(ALL)) continue;
                        this.deviceId = null;
                        continue;
                    }
                    if (string.equalsIgnoreCase(TAG_Limit)) {
                        string2 = XMLTools.getNodeText((Node)element3, (String)" ");
                        if (string2 == null || string2.equals("") || string2.equals(ALL)) {
                            this.limit = -1;
                            continue;
                        }
                        this.limit = StringTools.parseInt((String)string2, (int)-1);
                        continue;
                    }
                    Print.logWarn((String)("Unrecognized tag: " + string), (Object[])new Object[0]);
                }
            }
        }
        this.parseOK = true;
        return true;
    }

    public String getUser() {
        return this.adminUser;
    }

    public String getPassword() {
        return this.adminPass;
    }

    public boolean hasNotificationAck() {
        return this.messageAcks != null && this.messageAcks.length > 0;
    }

    public String[] getMessageAcks() {
        return this.messageAcks;
    }

    public boolean hasNotificationRequest() {
        return this.hasRequest;
    }

    public boolean hasRequsetPriority() {
        return this.priority > 0;
    }

    public int getRequestPriority() {
        return this.priority;
    }

    public boolean hasRequsetAccountID() {
        return this.accountId != null && !this.accountId.equals("");
    }

    public String getRequestAccountID() {
        return this.accountId;
    }

    public boolean hasRequsetDeviceID() {
        return this.deviceId != null && !this.deviceId.equals("");
    }

    public String getRequestDeviceID() {
        return this.deviceId;
    }

    public boolean hasRequestLimit() {
        return this.limit > 0;
    }

    public int getRequestLimit() {
        return this.limit;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + NotificationQuery.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -ack=<id>,<id>  Acknowledged messages (default: none)", (Object[])new Object[0]);
        Print.logInfo((String)"  -priority=<pri> Message priority selection (default: all)", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>   Message Account ID selection (default: all)", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<id>    Message Device ID selection (default: all)", (Object[])new Object[0]);
        Print.logInfo((String)"  -limit=<limit>  Maximum number of messages to return (default: approx 100)", (Object[])new Object[0]);
        Print.logInfo((String)"  -url=<url>      'Request' URL (default: 'http://localhost:8080/notification/Messages'", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Object object;
        RTConfig.setCommandLineArgs((String[])stringArray);
        if (RTConfig.getBoolean((String[])ARG_HELP, (boolean)false)) {
            NotificationQuery.usage();
        }
        String string = RTConfig.getString((String[])ARG_ACK, null);
        String string2 = RTConfig.getString((String[])ARG_PRIORITY, null);
        String string3 = RTConfig.getString((String[])ARG_ACCOUNT, null);
        String string4 = RTConfig.getString((String[])ARG_DEVICE, null);
        String string5 = RTConfig.getString((String[])ARG_LIMIT, null);
        String string6 = RTConfig.getString((String[])ARG_HOSTPORT, null);
        String string7 = RTConfig.getString((String[])ARG_URL, null);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<NotificationQuery>\n");
        if (string != null && !string.equals("")) {
            object = StringTools.split((String)string, (char)',');
            stringBuffer.append("  <NotificationAck>\n");
            for (int i = 0; i < ((String[])object).length; ++i) {
                stringBuffer.append("     <MessageAck id=\"" + object[i] + "\"/>\n");
            }
            stringBuffer.append("  </NotificationAck>\n");
        }
        stringBuffer.append("  <NotificationRequest>\n");
        if (string2 != null && !string2.equals("")) {
            stringBuffer.append("     <Priority>" + string2 + "</Priority>\n");
        }
        if (string3 != null && !string3.equals("")) {
            stringBuffer.append("     <Account id=\"" + string3 + "\"/>\n");
        }
        if (string4 != null && !string4.equals("")) {
            stringBuffer.append("     <Device id=\"" + string4 + "\"/>\n");
        }
        if (string5 != null && !string5.equals("")) {
            stringBuffer.append("     <Limit>" + string5 + "</Limit>\n");
        }
        stringBuffer.append("  </NotificationRequest>\n");
        stringBuffer.append("</NotificationQuery>\n");
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Query:", (Object[])new Object[0]);
        Print.sysPrintln((String)stringBuffer.toString(), (Object[])new Object[0]);
        object = null;
        object = string7 != null && !string7.equals("") ? string7 : (string6 != null && !string6.equals("") ? "http://" + string6 + "/notification/Messages" : "http://localhost:8080/notification/Messages");
        String string8 = null;
        try {
            int n = -1;
            byte[] byArray = StringTools.getBytes((String)stringBuffer.toString());
            byte[] byArray2 = HTMLTools.readPage_POST((String)object, (String)HTMLTools.MIME_XML(), (byte[])byArray, (int)n);
            string8 = StringTools.toStringValue((byte[])byArray2);
        }
        catch (IOException iOException) {
            Print.logException((String)"NotificationQuery error", (Throwable)iOException);
            System.exit(99);
        }
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Response:", (Object[])new Object[0]);
        Print.sysPrintln((String)string8, (Object[])new Object[0]);
    }
}

