/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule;

import java.util.Collection;
import java.util.List;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.PredefinedRuleAction;
import org.opengts.db.RuleFactoryAdapter;
import org.opengts.db.RuleParseException;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.rule.EventRuleAction;
import org.opengts.rule.RuleAction;
import org.opengts.rule.event.EventFunctionHandler;
import org.opengts.rule.event.EventIdentifierHandler;
import org.opengts.rule.event.EventSelector;
import org.opengts.rule.selector.FunctionHandler;
import org.opengts.rule.selector.IdentifierHandler;
import org.opengts.rule.selector.ParserException;
import org.opengts.rule.selector.Selector;
import org.opengts.rule.tables.GeoCorridor;
import org.opengts.rule.tables.Rule;
import org.opengts.rule.tables.RuleList;
import org.opengts.rule.tables.RuleTrigger;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;

public class EventRuleFactory
extends RuleFactoryAdapter {
    private int _checkRuntime = -1;
    private boolean cronMode = false;
    private RuleAction ruleAction = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_CODE = new String[]{"code"};
    private static final String[] ARG_GP = new String[]{"gp", "pt"};
    private static final String[] ARG_EMAIL = new String[]{"email"};

    public EventRuleFactory(RuleAction ruleAction) {
        this(ruleAction, false);
    }

    public EventRuleFactory(RuleAction ruleAction, boolean bl) {
        this.ruleAction = ruleAction;
        this.setCronMode(bl);
        EventSelector.initSingleton();
    }

    public String getName() {
        return "GTSRulesEngine";
    }

    public String getVersion() {
        return EventSelector.getInstance()._getVersion();
    }

    public long getCompileTime() {
        return 1381279040L;
    }

    public boolean checkRuntime() {
        if (this._checkRuntime < 0) {
            String string = this.getVersion();
            this._checkRuntime = !string.startsWith("*") ? 1 : 0;
        }
        return this._checkRuntime == 1;
    }

    public void setCronMode(boolean bl) {
        this.cronMode = bl;
        EventSelector.SetCronMode(bl);
    }

    public boolean getCronMode() {
        return this.cronMode;
    }

    public PredefinedRuleAction[] getPredefinedRuleActions(BasicPrivateLabel basicPrivateLabel) {
        if (basicPrivateLabel == null) {
            return EventRuleAction.PredefinedRuleActionList;
        }
        Object[] objectArray = basicPrivateLabel.getPredefinedRulesActions();
        return !ListTools.isEmpty((Object[])objectArray) ? objectArray : EventRuleAction.PredefinedRuleActionList;
    }

    public List<String> getIdentifierNames() {
        return EventSelector.getInstance().getIdentifierNames();
    }

    public String getIdentifierDescription(String string) {
        IdentifierHandler identifierHandler = EventSelector.getInstance().getIdentifier(string);
        return identifierHandler != null ? identifierHandler.getDescription() : null;
    }

    public int addIdentifier(EventIdentifierHandler eventIdentifierHandler) {
        return EventSelector.getInstance().addIdentifier(eventIdentifierHandler);
    }

    public List<String> getFunctionNames() {
        return EventSelector.getInstance().getFunctionNames();
    }

    public String getFunctionUsage(String string) {
        FunctionHandler functionHandler = EventSelector.getInstance().getFunction(string);
        return functionHandler != null ? functionHandler.getUsage() : null;
    }

    public String getFunctionDescription(String string) {
        FunctionHandler functionHandler = EventSelector.getInstance().getFunction(string);
        return functionHandler != null ? functionHandler.getDescription() : null;
    }

    public int addFunction(EventFunctionHandler eventFunctionHandler) {
        return EventSelector.getInstance().addFunction(eventFunctionHandler);
    }

    public boolean checkSelectorSyntax(String string) {
        return Rule.checkSelectorSyntax(string);
    }

    public boolean isSelectorMatch(String string, EventData eventData) {
        if (eventData != null && !StringTools.isBlank((String)string)) {
            try {
                return Rule.isSelectorMatch(string, eventData);
            }
            catch (ParserException parserException) {
                Print.logWarn((String)("Rule selector invalid: " + string), (Object[])new Object[0]);
                Print.logWarn((String)("Rule selector parser error: " + parserException), (Object[])new Object[0]);
                return false;
            }
        }
        return false;
    }

    public boolean isSelectorMatch(String string, Device device) {
        if (device != null && !StringTools.isBlank((String)string)) {
            try {
                return Rule.isSelectorMatch(string, device);
            }
            catch (ParserException parserException) {
                Print.logWarn((String)("Rule selector invalid: " + string), (Object[])new Object[0]);
                Print.logWarn((String)("Rule selector parser error: " + parserException), (Object[])new Object[0]);
                return false;
            }
        }
        return false;
    }

    public boolean isSelectorMatch(String string, Account account) {
        if (account != null && !StringTools.isBlank((String)string)) {
            try {
                return Rule.isSelectorMatch(string, account);
            }
            catch (ParserException parserException) {
                Print.logWarn((String)("Rule selector invalid: " + string), (Object[])new Object[0]);
                Print.logWarn((String)("Rule selector parser error: " + parserException), (Object[])new Object[0]);
                return false;
            }
        }
        return false;
    }

    public Object evaluateSelector(String string, EventData eventData) throws RuleParseException {
        if (eventData != null && !StringTools.isBlank((String)string)) {
            try {
                Selector.Result result = Rule.getSelectorResult(string, eventData);
                return result != null ? result.getValue() : null;
            }
            catch (ParserException parserException) {
                throw new RuleParseException(parserException.getMessage(), (Throwable)parserException);
            }
        }
        return null;
    }

    public Object evaluateSelector(String string, Account account) throws RuleParseException {
        if (account != null && !StringTools.isBlank((String)string)) {
            try {
                Selector.Result result = Rule.getSelectorResult(string, account);
                return result != null ? result.getValue() : null;
            }
            catch (ParserException parserException) {
                throw new RuleParseException(parserException.getMessage(), (Throwable)parserException);
            }
        }
        return null;
    }

    public int executeSelector(Rule rule, EventData eventData) {
        if (rule == null) {
            Print.logError((String)"Rule not specified", (Object[])new Object[0]);
            return -1;
        }
        if (this.ruleAction == null) {
            Print.logDebug((String)("No RuleAction for rule: " + rule.getSelector()), (Object[])new Object[0]);
            return -1;
        }
        if (eventData == null) {
            Print.logDebug((String)("EventData is null for rule: " + rule.getRuleID()), (Object[])new Object[0]);
            return -1;
        }
        Account account = eventData.getAccount();
        Device device = eventData.getDevice();
        String string = rule.getSelector();
        if (this.isSelectorMatch(string, eventData)) {
            if (rule.elapsedMinimumNotifyAge(eventData)) {
                Print.logInfo((String)("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true" + " [" + eventData.getAccountID() + "/" + eventData.getDeviceID() + "]: " + string + " [cron=" + rule.getIsCronRule() + ", action=0x" + StringTools.toHexString((long)rule.getActionMask(), (int)32) + "]" + ""), (Object[])new Object[0]);
                int n = this.ruleAction.performRuleAction(account, device, eventData, this.getCronMode(), string, rule);
                RuleTrigger.setRuleTriggerTime(device, rule, -1L);
                return n;
            }
            Print.logInfo((String)("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true" + " [" + eventData.getAccountID() + "/" + eventData.getDeviceID() + "]: " + " skipping action due to previous trigger"), (Object[])new Object[0]);
            return -1;
        }
        RuleTrigger.clearRuleTriggerTime(device, rule);
        return -1;
    }

    public int executeSelector(String string, EventData eventData) {
        if (this.ruleAction == null) {
            Print.logDebug((String)("No RuleAction for rule selector: " + string), (Object[])new Object[0]);
            return -1;
        }
        if (eventData == null) {
            Print.logDebug((String)("EventData is null for rule selector: " + string), (Object[])new Object[0]);
            return -1;
        }
        if (this.isSelectorMatch(string, eventData)) {
            Account account = eventData.getAccount();
            Device device = eventData.getDevice();
            Print.logInfo((String)("Rule Selector ==> true [" + eventData.getAccountID() + "/" + eventData.getDeviceID() + "]: " + string), (Object[])new Object[0]);
            int n = this.ruleAction.performRuleAction(account, device, eventData, this.getCronMode(), string, null);
            return n;
        }
        return -1;
    }

    public int executeSelector(Rule rule, Account account) {
        if (rule == null) {
            Print.logError((String)"Rule not specified", (Object[])new Object[0]);
            return -1;
        }
        if (this.ruleAction == null) {
            Print.logDebug((String)("No RuleAction for rule: " + rule.getSelector()), (Object[])new Object[0]);
            return -1;
        }
        if (account == null) {
            Print.logDebug((String)("Account is null for rule: " + rule.getRuleID()), (Object[])new Object[0]);
            return -1;
        }
        String string = rule.getSelector();
        if (this.isSelectorMatch(string, account)) {
            if (rule.elapsedMinimumNotifyAge(account)) {
                Print.logInfo((String)("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true " + " [" + account.getAccountID() + "]: " + string + " [cron=" + rule.getIsCronRule() + ", action=0x" + StringTools.toHexString((long)rule.getActionMask(), (int)32) + "]" + ""), (Object[])new Object[0]);
                int n = this.ruleAction.performRuleAction(account, null, null, this.getCronMode(), string, rule);
                RuleTrigger.setRuleTriggerTime(account, rule, -1L);
                return n;
            }
            Print.logInfo((String)("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true" + " [" + account.getAccountID() + "]: " + " skipping action due to previous trigger"), (Object[])new Object[0]);
            return -1;
        }
        RuleTrigger.clearRuleTriggerTime(account, rule);
        return -1;
    }

    public int executeSelector(String string, Account account) {
        if (this.ruleAction == null) {
            Print.logDebug((String)("No RuleAction for rule selector: " + string), (Object[])new Object[0]);
            return -1;
        }
        if (account == null) {
            Print.logDebug((String)("Account is null for rule selector: " + string), (Object[])new Object[0]);
            return -1;
        }
        if (this.isSelectorMatch(string, account)) {
            Print.logInfo((String)("Rule Selector ==> true [" + account.getAccountID() + "]: " + string), (Object[])new Object[0]);
            int n = this.ruleAction.performRuleAction(account, null, null, this.getCronMode(), string, null);
            return n;
        }
        return -1;
    }

    public int executeSelector(Rule rule, Device device) {
        if (rule == null) {
            Print.logError((String)"Rule not specified", (Object[])new Object[0]);
            return -1;
        }
        if (this.ruleAction == null) {
            Print.logDebug((String)("No RuleAction for rule: " + rule.getSelector()), (Object[])new Object[0]);
            return -1;
        }
        if (device == null) {
            Print.logDebug((String)("Device is null for rule: " + rule.getRuleID()), (Object[])new Object[0]);
            return -1;
        }
        Account account = device.getAccount();
        String string = rule.getSelector();
        if (this.isSelectorMatch(string, device)) {
            if (rule.elapsedMinimumNotifyAge(device)) {
                Print.logInfo((String)("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true" + " [" + device.getAccountID() + "/" + device.getDeviceID() + "]: " + string + " [cron=" + rule.getIsCronRule() + ", action=0x" + StringTools.toHexString((long)rule.getActionMask(), (int)32) + "]" + ""), (Object[])new Object[0]);
                int n = this.ruleAction.performRuleAction(account, device, null, this.getCronMode(), string, rule);
                RuleTrigger.setRuleTriggerTime(device, rule, -1L);
                return n;
            }
            Print.logInfo((String)("Rule '" + rule.getAccountID() + "/" + rule.getRuleID() + "' ==> true" + " [" + device.getAccountID() + "/" + device.getDeviceID() + "]: " + " skipping action due to previous trigger"), (Object[])new Object[0]);
            return -1;
        }
        RuleTrigger.clearRuleTriggerTime(device, rule);
        return -1;
    }

    public int executeSelector(String string, Device device) {
        if (this.ruleAction == null) {
            Print.logDebug((String)("No RuleAction for rule selector: " + string), (Object[])new Object[0]);
            return -1;
        }
        if (device == null) {
            Print.logDebug((String)("Device is null for rule selector: " + string), (Object[])new Object[0]);
            return -1;
        }
        if (this.isSelectorMatch(string, device)) {
            Account account = device.getAccount();
            Print.logInfo((String)("Rule Selector ==> true [" + device.getAccountID() + "/" + device.getDeviceID() + "]: " + string), (Object[])new Object[0]);
            int n = this.ruleAction.performRuleAction(account, device, null, this.getCronMode(), string, null);
            return n;
        }
        return -1;
    }

    public String getRuleSelector(Account account, String string) {
        if (account == null) {
            return null;
        }
        if (StringTools.isBlank((String)string)) {
            return null;
        }
        try {
            String string2;
            Rule rule = Rule.getRule(account, string);
            if (rule == null && (rule = Rule.getRule(string2 = Account.getSystemAdminAccountID(), string)) == null) {
                Print.logError((String)("Rule not found: " + account.getAccountID() + "/" + string), (Object[])new Object[0]);
                return null;
            }
            rule.setSystemRuleSettings();
            if (!rule.isActive()) {
                Print.logWarn((String)("Rule not active: " + rule.getAccountID() + "/" + string), (Object[])new Object[0]);
                return null;
            }
            return rule.getSelector();
        }
        catch (DBException dBException) {
            Print.logError((String)("Returning Rule Selector: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return null;
        }
    }

    public String[] getRuleIDs(Account account) {
        if (account == null) {
            return null;
        }
        try {
            Collection<String> collection = Rule.getRuleIDs(account.getAccountID(), false, true, false);
            return collection.toArray(new String[collection.size()]);
        }
        catch (DBException dBException) {
            Print.logError((String)("Returning Rule IDs: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return null;
        }
    }

    public String getRuleNotifyEmail(Account account, String string) {
        if (account == null) {
            return null;
        }
        if (StringTools.isBlank((String)string)) {
            return null;
        }
        try {
            String string2;
            Rule rule = Rule.getRule(account, string);
            if (rule == null && (rule = Rule.getRule(string2 = Account.getSystemAdminAccountID(), string)) == null) {
                Print.logError((String)("Rule not found: " + account.getAccountID() + "/" + string), (Object[])new Object[0]);
                return null;
            }
            rule.setSystemRuleSettings();
            if (!rule.isActive()) {
                Print.logWarn((String)("Rule not active: " + rule.getAccountID() + "/" + string), (Object[])new Object[0]);
            }
            return rule.getNotifyEmail();
        }
        catch (DBException dBException) {
            Print.logError((String)("Returning Rule Notify Email: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return null;
        }
    }

    public int executeRule(Account account, String string) {
        if (account == null) {
            return -1;
        }
        String string2 = account.getAccountID();
        if (StringTools.isBlank((String)string)) {
            return -1;
        }
        int n = 0;
        try {
            String string3;
            Rule rule = Rule.getRule(account, string);
            if (rule == null && (rule = Rule.getRule(string3 = Account.getSystemAdminAccountID(), string)) == null) {
                Print.logError((String)("Rule not found: " + string2 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            rule.setSystemRuleSettings();
            string3 = rule.getAccountID();
            if (!rule.isActive()) {
                Print.logWarn((String)("Rule not active: " + string3 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            if (this.cronMode != rule.getIsCronRule()) {
                if (this.cronMode) {
                    Print.logError((String)("[CronMode] Invalid NonCronMode rule specified: " + string3 + "/" + string), (Object[])new Object[0]);
                } else {
                    Print.logError((String)("[NonCronMode] Invalid CronMode rule specified: " + string3 + "/" + string), (Object[])new Object[0]);
                }
                return -1;
            }
            if (!rule.hasSelector()) {
                Print.logError((String)("Rule has no selector: " + string3 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            int n2 = this.executeSelector(rule, account);
            if (n2 >= 0 && n2 != 0) {
                Print.logDebug((String)("Rule Action: " + string + " ==> 0x" + StringTools.toHexString((long)n2, (int)32)), (Object[])new Object[0]);
                n |= n2;
            } else {
                Print.logDebug((String)("Rule Action: " + string + " ==> (action ignored)"), (Object[])new Object[0]);
            }
            return n != 0 ? n : -1;
        }
        catch (DBException dBException) {
            Print.logError((String)("Executing Rule: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return -1;
        }
    }

    public int executeRule(Device device, String string) {
        Account account;
        Account account2 = account = device != null ? device.getAccount() : null;
        if (account == null) {
            return -1;
        }
        String string2 = device.getAccountID();
        String string3 = device.getDeviceID();
        if (StringTools.isBlank((String)string)) {
            return -1;
        }
        int n = 0;
        try {
            String string4;
            Rule rule = Rule.getRule(account, string);
            if (rule == null && (rule = Rule.getRule(string4 = Account.getSystemAdminAccountID(), string)) == null) {
                Print.logError((String)("Rule not found: " + string2 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            rule.setSystemRuleSettings();
            string4 = rule.getAccountID();
            if (!rule.isActive()) {
                Print.logWarn((String)("Rule not active: " + string4 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            if (this.cronMode != rule.getIsCronRule()) {
                if (this.cronMode) {
                    Print.logError((String)("[CronMode] Invalid NonCronMode rule specified: " + string4 + "/" + string), (Object[])new Object[0]);
                } else {
                    Print.logError((String)("[NonCronMode] Invalid CronMode rule specified: " + string4 + "/" + string), (Object[])new Object[0]);
                }
                return -1;
            }
            if (!rule.hasSelector()) {
                Print.logError((String)("Rule has no selector: " + string4 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            int n2 = this.executeSelector(rule, device);
            if (n2 >= 0 && n2 != 0) {
                Print.logDebug((String)("Rule Action: " + string + " ==> 0x" + StringTools.toHexString((long)n2, (int)32)), (Object[])new Object[0]);
                n |= n2;
            } else {
                Print.logDebug((String)("Rule Action: " + string + " ==> (action ignored)"), (Object[])new Object[0]);
            }
            return n != 0 ? n : -1;
        }
        catch (DBException dBException) {
            Print.logError((String)("Executing Rule: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return -1;
        }
    }

    public int executeRule(EventData eventData, String string) {
        if (eventData == null) {
            return -1;
        }
        if (StringTools.isBlank((String)string)) {
            return -1;
        }
        String string2 = eventData.getAccountID();
        Account account = eventData.getAccount();
        Device device = eventData.getDevice();
        if (account == null || device == null) {
            Print.logError((String)("EventData Account/Device not found: " + string2 + "/" + eventData.getDeviceID()), (Object[])new Object[0]);
            return -1;
        }
        int n = 0;
        try {
            String string3;
            Rule rule = Rule.getRule(account, string);
            if (rule == null && (rule = Rule.getRule(string3 = Account.getSystemAdminAccountID(), string)) == null) {
                Print.logError((String)("Rule not found: " + string2 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            rule.setSystemRuleSettings();
            string3 = rule.getAccountID();
            if (!rule.isActive()) {
                Print.logWarn((String)("Rule not active: " + string3 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            if (this.cronMode != rule.getIsCronRule()) {
                if (this.cronMode) {
                    Print.logError((String)("[CronMode] Invalid NonCronMode rule specified: " + string3 + "/" + string), (Object[])new Object[0]);
                } else {
                    Print.logError((String)("[NonCronMode] Invalid CronMode rule specified: " + string3 + "/" + string), (Object[])new Object[0]);
                }
                return -1;
            }
            if (!rule.hasSelector()) {
                Print.logError((String)("Rule has no selector: " + string3 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            int n2 = this.executeSelector(rule, eventData);
            if (n2 >= 0 && n2 != 0) {
                Print.logDebug((String)("Rule Action: " + string + " ==> 0x" + StringTools.toHexString((long)n2, (int)32)), (Object[])new Object[0]);
                n |= n2;
            } else {
                Print.logDebug((String)("Rule Action: " + string + " ==> (action ignored)"), (Object[])new Object[0]);
            }
            return n != 0 ? n : -1;
        }
        catch (DBException dBException) {
            Print.logError((String)("Executing Rule: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return -1;
        }
    }

    public int executeRules(Account account) {
        return this.executeRules(account, null);
    }

    public int executeRules(Account account, String string) {
        if (!this.getCronMode()) {
            return -1;
        }
        if (account == null) {
            return -1;
        }
        String string2 = account.getAccountID();
        int n = 0;
        int n2 = 0;
        boolean bl = !StringTools.isBlank((String)string);
        try {
            Collection<String> collection = Rule.getAllRuleIDs(string2, true);
            if (ListTools.isEmpty(collection)) {
                return -1;
            }
            for (String string3 : collection) {
                Rule rule = Rule.getRule(account, string3);
                if (rule == null) {
                    Print.logDebug((String)("Account] Rule not found: " + string2 + "/" + string3), (Object[])new Object[0]);
                    continue;
                }
                rule.setSystemRuleSettings();
                if (!rule.isActive() || !rule.getIsCronRule() || bl && !string.equalsIgnoreCase(rule.getRuleTag())) continue;
                Print.logDebug((String)("Account] Checking rule: " + string2 + "/" + string3 + " [tag '" + string + "']"), (Object[])new Object[0]);
                if (!rule.hasSelector()) continue;
                int n3 = this.executeSelector(rule, account);
                if (n3 >= 0 && n3 != 0) {
                    Print.logDebug((String)("Rule Action: " + string3 + " ==> 0x" + StringTools.toHexString((long)n3, (int)32)), (Object[])new Object[0]);
                    n2 |= n3;
                    ++n;
                    continue;
                }
                Print.logDebug((String)("Rule Action: " + string3 + " ==> (action ignored)"), (Object[])new Object[0]);
            }
        }
        catch (DBException dBException) {
            Print.logError((String)("Executing Account 'Cron' Rules: " + (Object)((Object)dBException)), (Object[])new Object[0]);
        }
        return n > 0 ? n2 : -1;
    }

    public int executeRule(String string, Account account) {
        return -1;
    }

    public int executeRules(Device device) {
        return this.executeRules(device, null);
    }

    public int executeRules(Device device, String string) {
        if (!this.getCronMode()) {
            return -1;
        }
        if (device == null) {
            return -1;
        }
        Account account = device.getAccount();
        String string2 = device.getAccountID();
        String string3 = device.getDeviceID();
        int n = 0;
        int n2 = 0;
        boolean bl = !StringTools.isBlank((String)string);
        try {
            Collection<String> collection = Rule.getAllRuleIDs(string2, true);
            if (ListTools.isEmpty(collection)) {
                return -1;
            }
            for (String string4 : collection) {
                Rule rule = Rule.getRule(account, string4);
                if (rule == null) {
                    Print.logDebug((String)("Device] Rule not found: " + string2 + "/" + string4), (Object[])new Object[0]);
                    continue;
                }
                rule.setSystemRuleSettings();
                if (!rule.isActive() || !rule.getIsCronRule() || bl && !string.equalsIgnoreCase(rule.getRuleTag())) continue;
                Print.logDebug((String)("Device] Checking rule: " + string2 + "/" + string4 + " [tag '" + string + "']: " + string3), (Object[])new Object[0]);
                if (!rule.hasSelector()) {
                    Print.logDebug((String)("Rule has no selector: " + string2 + "/" + string4), (Object[])new Object[0]);
                    continue;
                }
                int n3 = this.executeSelector(rule, device);
                if (n3 >= 0 && n3 != 0) {
                    Print.logDebug((String)("Rule Action: " + string4 + " ==> 0x" + StringTools.toHexString((long)n3, (int)32)), (Object[])new Object[0]);
                    n2 |= n3;
                    ++n;
                    continue;
                }
                Print.logDebug((String)("Rule Action: " + string4 + " ==> (action ignored)"), (Object[])new Object[0]);
            }
        }
        catch (DBException dBException) {
            Print.logError((String)("Executing Device Rules: " + (Object)((Object)dBException)), (Object[])new Object[0]);
        }
        return n > 0 ? n2 : -1;
    }

    public int executeRule(String string, Device device) {
        return -1;
    }

    public int executeRules(EventData eventData) {
        return this.executeRules(eventData, null);
    }

    public int executeRules(EventData eventData, String string) {
        if (eventData == null) {
            return -1;
        }
        String string2 = eventData.getAccountID();
        Device device = eventData.getDevice();
        if (device == null) {
            Print.logError((String)("EventData Device not found: " + string2 + "/" + eventData.getDeviceID()), (Object[])new Object[0]);
            return -1;
        }
        String string3 = device.getDeviceID();
        int n = 0;
        int n2 = 0;
        boolean bl = !StringTools.isBlank((String)string);
        try {
            Collection<String> collection = RuleList.getRulesForDevice(device, eventData.getStatusCode());
            if (!ListTools.isEmpty(collection)) {
                Account account = eventData.getAccount();
                for (String string4 : collection) {
                    Rule rule = Rule.getRule(account, string4);
                    if (rule == null) {
                        Print.logDebug((String)("Event] Rule not found: " + string2 + "/" + string4), (Object[])new Object[0]);
                        continue;
                    }
                    rule.setSystemRuleSettings();
                    if (!rule.isActive() || this.cronMode && !rule.getIsCronRule() || !this.cronMode && rule.getIsCronRule() || bl && !string.equalsIgnoreCase(rule.getRuleTag())) continue;
                    Print.logDebug((String)("Event] Checking rule: " + string2 + "/" + string4 + " [tag '" + string + "']: " + string3), (Object[])new Object[0]);
                    if (!rule.hasSelector()) {
                        Print.logDebug((String)("Rule has no selector: " + string2 + "/" + string4), (Object[])new Object[0]);
                        continue;
                    }
                    int n3 = this.executeSelector(rule, eventData);
                    if (n3 >= 0 && n3 != 0) {
                        Print.logDebug((String)("Rule Action: " + string4 + " ==> 0x" + StringTools.toHexString((long)n3, (int)32)), (Object[])new Object[0]);
                        n2 |= n3;
                        ++n;
                        continue;
                    }
                    Print.logDebug((String)("Rule Action: " + string4 + " ==> (action ignored)"), (Object[])new Object[0]);
                }
            }
            return n > 0 ? n2 : -1;
        }
        catch (DBException dBException) {
            Print.logError((String)("Executing EventData Rules: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return n > 0 ? n2 : -1;
        }
    }

    public int executeRule(String string, EventData eventData) {
        if (eventData == null) {
            return -1;
        }
        String string2 = eventData.getAccountID();
        Account account = eventData.getAccount();
        Device device = eventData.getDevice();
        int n = 0;
        int n2 = 0;
        try {
            Rule rule = Rule.getRule(account, string);
            if (rule == null) {
                Print.logWarn((String)("Rule not found: " + string2 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            rule.setSystemRuleSettings();
            if (!rule.isActive()) {
                Print.logWarn((String)("Rule not active: " + string2 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            if (this.cronMode && !rule.getIsCronRule()) {
                Print.logInfo((String)("Skipping non-CronMode rule: " + string2 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            if (!this.cronMode && rule.getIsCronRule()) {
                Print.logInfo((String)("Skipping CronMode rule: " + string2 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            if (!rule.hasSelector()) {
                Print.logWarn((String)("Rule has no selector: " + string2 + "/" + string), (Object[])new Object[0]);
                return -1;
            }
            int n3 = this.executeSelector(rule, eventData);
            if (n3 >= 0 && n3 != 0) {
                Print.logDebug((String)("Rule Action: " + string + " ==> 0x" + StringTools.toHexString((long)n3, (int)32)), (Object[])new Object[0]);
                n2 |= n3;
                ++n;
            } else {
                Print.logDebug((String)("Rule Action: " + string + " ==> (action ignored)"), (Object[])new Object[0]);
            }
            return n > 0 ? n2 : -1;
        }
        catch (DBException dBException) {
            Print.logError((String)("Executing EventData Rule: " + (Object)((Object)dBException)), (Object[])new Object[0]);
            return n > 0 ? n2 : -1;
        }
    }

    public String getGeoCorridorDescription(Account account, String string) {
        try {
            GeoCorridor geoCorridor = GeoCorridor.getGeoCorridor(account, string);
            return geoCorridor != null ? geoCorridor.getDescription() : "";
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        DBConfig.cmdLineInit((String[])stringArray, (boolean)true);
        SendMail.SetThreadModel((String)"current");
        EventRuleAction.DebugSetSendNotification(RTConfig.getBoolean((String[])ARG_EMAIL, (boolean)false));
        String string = RTConfig.getString((String[])ARG_ACCOUNT, (String)"demo");
        String string2 = RTConfig.getString((String[])ARG_DEVICE, (String)"demo");
        int n = RTConfig.getInt((String[])ARG_CODE, (int)61968);
        GeoPoint geoPoint = new GeoPoint(RTConfig.getString((String[])ARG_GP, (String)"35.12345/-142.12345"));
        Print.sysPrintln((String)("Account : " + string), (Object[])new Object[0]);
        Print.sysPrintln((String)("Device  : " + string2), (Object[])new Object[0]);
        Print.sysPrintln((String)("Code    : " + StatusCodes.GetHex((int)n) + " - " + StatusCodes.GetName((int)n, null)), (Object[])new Object[0]);
        Print.sysPrintln((String)("GeoPoint: " + geoPoint), (Object[])new Object[0]);
        Geozone geozone = Geozone.getGeozone((String)string, null, (GeoPoint)geoPoint, (boolean)true);
        EventData.Key key = new EventData.Key(string, string2, DateTime.getCurrentTimeSec(), n);
        EventData eventData = (EventData)key.getDBRecord();
        eventData.setAddress(geozone != null ? geozone.getDescription() : "");
        eventData.setGeozoneID(geozone != null ? geozone.getGeozoneID() : "");
        eventData.setGeoPoint(geoPoint);
        eventData.setSpeedKPH(45.0);
        eventData.setHeading(123.0);
        eventData.setAltitude(457.0);
        eventData.setOdometerKM(123456.0);
        eventData.setDistanceKM(3456.0);
        EventRuleFactory eventRuleFactory = new EventRuleFactory(new EventRuleAction());
        int n2 = eventRuleFactory.executeRules(eventData);
        if (n2 < 0) {
            Print.sysPrintln((String)"ExecuteRules: none", (Object[])new Object[0]);
        } else {
            Print.sysPrintln((String)("ExecuteRules: 0x" + StringTools.toHexString((long)n2, (int)32)), (Object[])new Object[0]);
        }
    }
}

