/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.Audit;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.BasicPrivateLabelLoader;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.PredefinedRuleAction;
import org.opengts.db.RuleFactoryAdapter;
import org.opengts.db.SMSOutboundGateway;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtypes.DTOBDFault;
import org.opengts.rule.PredefinedActionListener;
import org.opengts.rule.RuleAction;
import org.opengts.rule.RuleListener;
import org.opengts.rule.tables.NotifyQueue;
import org.opengts.rule.tables.Rule;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTKey;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;
import org.opengts.util.ThreadPool;

public class EventRuleAction
implements RuleAction {
    public static final int DEFAULT_PRIORITY = 1;
    public static final String[] PROP_emailSubj;
    public static final String[] PROP_emailBody;
    public static final String[] PROP_smsText;
    private static final String[] KEY_SUBJECT;
    private static final String[] KEY_MESSAGE;
    private static final String[] KEY_SMSTEXT;
    private static final String[] KEY_PRIOR_GEOZONE;
    private static final String[] KEY_PRIOR_ADDRESS;
    private static final String[] KEY_MAP_URL;
    private static final String[] KEY_REPORT_URL;
    public static final String[] CRA_resetMaint;
    public static final String[] CRA_resetReminder;
    public static final String[] CRA_save;
    public static final String[] CRA_setCorridor;
    public static final String[] CRA_clearCorridor;
    public static final String[] CRA_sendCommand;
    public static final String[] CRA_clearEMail;
    public static final String[] CRA_addEvent;
    public static final String[] CRA_sendMQ;
    public static final String[] CRA_emailReport;
    public static final String[] CRA_resetCommands;
    public static final String[] CRA_park;
    public static final String[] CRA_unpark;
    public static final String[] CRA_setvar;
    public static final PredefinedRuleAction[] PredefinedRuleActionList;
    private static boolean SEND_NOTIFICATION;
    private static List<RuleListener> RuleListenerList;
    private static PredefinedActionListener CustomCRAListener;
    private static final RTKey PROP_ThreadPool_EventRuleAction_;
    private static ThreadPool ThreadPool_EventRuleAction;
    private int dftActionMask = 263;
    private long notifyDelayMS = 0L;

    public static String GetActionMaskDescription(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((long)(n & 0x100) != 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("EMail(");
            int n2 = 0;
            if ((long)(n & 1) != 0L) {
                if (n2++ > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("Account");
            }
            if ((long)(n & 2) != 0L) {
                if (n2++ > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("Device");
            }
            if ((long)(n & 4) != 0L) {
                if (n2++ > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("Rule");
            }
            stringBuffer.append(")");
        }
        if ((long)(n & 0x200) != 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("Queue");
        }
        if ((long)(n & 0x400) != 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("Listener");
        }
        if ((long)(n & 0x10000) != 0L) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append("SaveLast");
        }
        if (stringBuffer.length() == 0) {
            if (n == 0) {
                stringBuffer.append("None");
            } else {
                stringBuffer.append("?0x").append(StringTools.toHexString((long)n, (int)24));
            }
        }
        return stringBuffer.toString();
    }

    public static boolean CRAMatch(String[] stringArray, String string) {
        return ListTools.containsIgnoreCase((String[])stringArray, (String)string);
    }

    public static void DebugSetSendNotification(boolean bl) {
        SEND_NOTIFICATION = bl;
    }

    public static RuleListener getRuleListenerByName(String string) {
        if (RuleListenerList == null) {
            return null;
        }
        if (string == null) {
            return null;
        }
        for (RuleListener ruleListener : RuleListenerList) {
            String string2;
            try {
                MethodAction methodAction = new MethodAction((Object)ruleListener, "getName");
                string2 = StringTools.trim((Object)methodAction.invoke());
            }
            catch (Throwable throwable) {
                string2 = ruleListener.toString();
            }
            if (!string.equalsIgnoreCase(string2)) continue;
            return ruleListener;
        }
        return null;
    }

    public static boolean hasRuleListener(String string) {
        RuleListener ruleListener = EventRuleAction.getRuleListenerByName(string);
        return ruleListener != null;
    }

    public static void addRuleListener(RuleListener ruleListener) {
        if (ruleListener != null) {
            if (RuleListenerList == null) {
                RuleListenerList = new Vector<RuleListener>();
            }
            RuleListenerList.add(ruleListener);
        }
    }

    private static void fireRuleListeners(Account account, Device device, EventData eventData, boolean bl, String string, Rule rule) {
        if (RuleListenerList != null) {
            Device device2;
            EventData eventData2 = eventData;
            Object object = device != null ? device : (device2 = eventData2 != null ? eventData2.getDevice() : null);
            Account account2 = account != null ? account : (eventData2 != null ? eventData2.getAccount() : (device2 != null ? device2.getAccount() : null));
            Rule rule2 = rule;
            String string2 = StringTools.trim((String)(rule2 != null ? rule2.getSelector() : string));
            for (RuleListener ruleListener : RuleListenerList) {
                ruleListener.handleRuleNotification(account2, device2, eventData2, bl, string2, rule2);
            }
        }
    }

    public EventRuleAction() {
        this(263);
    }

    public EventRuleAction(int n) {
        this.dftActionMask = RuleFactoryAdapter.ValidateActionMask((int)n);
        this.notifyDelayMS = RTConfig.getLong((String)"rule.waitForEventAddressMS", (long)0L);
        if (this.notifyDelayMS > 0L) {
            // empty if block
        }
    }

    private static Account GetAccount(Account account, Device device, EventData eventData) {
        if (account != null) {
            return account;
        }
        if (eventData != null) {
            return eventData.getAccount();
        }
        if (device != null) {
            return device.getAccount();
        }
        return null;
    }

    private static Device GetDevice(Device device, EventData eventData) {
        if (device != null) {
            return device;
        }
        if (eventData != null) {
            return eventData.getDevice();
        }
        return null;
    }

    @Override
    public int performRuleAction(Account account, Device device, EventData eventData, boolean bl, String string, Rule rule) {
        Account account2 = EventRuleAction.GetAccount(account, device, eventData);
        Device device2 = EventRuleAction.GetDevice(device, eventData);
        int n = -1;
        n = rule != null ? rule.getActionMask() : (device2 != null ? device2.getNotifyAction() : -1);
        if (n < 0 || n == 0) {
            if (this.dftActionMask < 0 || this.dftActionMask == 0) {
                return -1;
            }
            n = this.dftActionMask;
        }
        n = RuleFactoryAdapter.ValidateActionMask((int)n);
        int n2 = -1;
        n2 = rule != null ? rule.getPriority() : (device2 != null ? device2.getNotifyPriority() : -1);
        if (n2 <= 0) {
            n2 = 1;
        }
        if (eventData != null && !eventData.hasAddress() && this.notifyDelayMS > 0L) {
            final Account account3 = account2;
            final Device device3 = device2;
            final EventData eventData2 = eventData;
            final boolean bl2 = bl;
            final int n3 = n;
            final int n4 = n2;
            final String string2 = string;
            final Rule rule2 = rule;
            final long l = DateTime.getCurrentTimeMillis() + this.notifyDelayMS;
            ThreadPool_EventRuleAction.run(new Runnable(){

                @Override
                public void run() {
                    long l3 = DateTime.getCurrentTimeMillis();
                    if (l3 < l) {
                        long l2 = l - l3;
                        Print.logInfo((String)("Waiting for EventData address: " + l2 + " ms"), (Object[])new Object[0]);
                        if (l2 > 0L) {
                            OSTools.sleepMS((long)l2);
                        }
                    }
                    Print.logInfo((String)"Updating EventData address ...", (Object[])new Object[0]);
                    eventData2.reloadAddress();
                    Print.logInfo((String)("... Updated EventData address: " + eventData2.getAddress()), (Object[])new Object[0]);
                    boolean bl = EventRuleAction._sendNotification(true, account3, device3, eventData2, bl2, n3, n4, string2, rule2);
                }
            });
        } else {
            boolean bl3 = EventRuleAction._sendNotification(false, account2, device2, eventData, bl, n, n2, string, rule);
        }
        return n;
    }

    protected static String _getNotificationRecipients(Account account, Device device, Rule rule, int n) {
        Object[] objectArray;
        HashSet hashSet = new HashSet();
        if (account != null && (n & 1) != 0 && !ListTools.isEmpty((Object[])(objectArray = StringTools.split((String)account.getNotifyEmail(), (char)',')))) {
            ListTools.toSet(hashSet, (Object[])objectArray);
        }
        if (device != null && (n & 2) != 0 && !ListTools.isEmpty((Object[])(objectArray = StringTools.split((String)device.getNotifyEmail(false, true), (char)',')))) {
            ListTools.toSet(hashSet, (Object[])objectArray);
        }
        if (rule != null && (n & 4) != 0 && !ListTools.isEmpty((Object[])(objectArray = StringTools.split((String)rule.getNotifyEmail(), (char)',')))) {
            ListTools.toSet(hashSet, (Object[])objectArray);
        }
        if (ListTools.isEmpty(hashSet)) {
            return null;
        }
        objectArray = new StringBuffer();
        for (String string : hashSet) {
            if (StringTools.isBlank((String)string)) continue;
            if (objectArray.length() > 0) {
                objectArray.append(",");
            }
            objectArray.append(string);
        }
        return objectArray.toString();
    }

    protected static String _getNotificationSender(Account account, Rule rule, int n) {
        BasicPrivateLabel basicPrivateLabel;
        BasicPrivateLabel basicPrivateLabel2 = basicPrivateLabel = account != null ? account.getPrivateLabel() : null;
        if (basicPrivateLabel != null) {
            String string = basicPrivateLabel.getEventNotificationFrom();
            if (!SendMail.IsBlankEmailAddress((String)string)) {
                return string;
            }
            string = basicPrivateLabel.getEMailAddress("notify");
            if (!SendMail.IsBlankEmailAddress((String)string)) {
                return string;
            }
            string = basicPrivateLabel.getSmtpProperties().getUserEmail();
            if (!SendMail.IsBlankEmailAddress((String)string)) {
                return string;
            }
        }
        return SendMail.getDefaultUserEmail(null);
    }

    protected static String[] _getNotificationMessage(Account account, Device device, EventData eventData, Rule rule, int n) {
        String string;
        String string2;
        String string3;
        BasicPrivateLabel basicPrivateLabel;
        Account account2 = EventRuleAction.GetAccount(account, device, eventData);
        Device device2 = EventRuleAction.GetDevice(device, eventData);
        BasicPrivateLabel basicPrivateLabel2 = basicPrivateLabel = account2 != null ? account2.getPrivateLabel() : null;
        if (basicPrivateLabel == null) {
            Print.logWarn((String)"No PrivateLabel found for Account", (Object[])new Object[0]);
        }
        boolean bl = basicPrivateLabel != null && basicPrivateLabel.hasEventNotificationEMail();
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (rule != null) {
            string3 = rule.getEmailSubject();
            string4 = !StringTools.isBlank((String)string3) ? string3 : rule.getDescription();
            string2 = rule.getEmailText();
            string5 = !StringTools.isBlank((String)string2) ? string2 : rule.getDescription();
            bl = bl && rule.getUseEmailWrapper();
            string = rule.getDefaultSmsText(false);
            string6 = !StringTools.isBlank((String)string) ? string : null;
        } else if (device2 != null) {
            string3 = device2.getNotifySubject();
            string4 = !StringTools.isBlank((String)string3) ? string3 : device2.getNotifyDescription();
            string2 = device2.getNotifyText();
            string5 = !StringTools.isBlank((String)string2) ? string2 : device2.getNotifyDescription();
            bl = bl && device2.getNotifyUseWrapper();
            string = Rule.CreateDefaultSmsText(string3, string2, null);
            string6 = !StringTools.isBlank((String)string) ? string : null;
        } else {
            string4 = null;
            string5 = null;
            string6 = null;
        }
        if (eventData != null && eventData.hasTemporaryProperties()) {
            string3 = eventData.getTemporaryProperties();
            if (StringTools.isBlank((String)string4) && StringTools.isBlank((String)string5)) {
                string4 = string3.getString(PROP_emailSubj, string4);
                string5 = string3.getString(PROP_emailBody, string5);
            }
            if (StringTools.isBlank(string6)) {
                string6 = string3.getString(PROP_smsText, string6);
            }
        }
        if (device2 != null && device2.hasTemporaryProperties()) {
            string3 = device2.getTemporaryProperties();
            if (StringTools.isBlank((String)string4) && StringTools.isBlank((String)string5)) {
                string4 = string3.getString(PROP_emailSubj, string4);
                string5 = string3.getString(PROP_emailBody, string5);
            }
            if (StringTools.isBlank(string6)) {
                string6 = string3.getString(PROP_smsText, string6);
            }
        }
        if (account2 != null && account2.hasTemporaryProperties()) {
            string3 = account2.getTemporaryProperties();
            if (StringTools.isBlank((String)string4) && StringTools.isBlank((String)string5)) {
                string4 = string3.getString(PROP_emailSubj, string4);
                string5 = string3.getString(PROP_emailBody, string5);
            }
            if (StringTools.isBlank(string6)) {
                string6 = string3.getString(PROP_smsText, string6);
            }
        }
        string3 = null;
        string2 = null;
        string = null;
        if (bl) {
            if (basicPrivateLabel != null) {
                string3 = basicPrivateLabel.getEventNotificationSubject();
                string2 = basicPrivateLabel.getEventNotificationBody();
                string = null;
            }
            if (StringTools.isBlank((String)string3)) {
                string3 = "Vehicle ${device}: ${subject}";
            }
            if (StringTools.isBlank((String)string2)) {
                string2 = "Account   : [${accountid}] ${account}\nVehicle   : [${deviceid}] ${device}\nDate/Time : ${datetime}\nStatus    : [${statuscode}] ${status}\nLocation  : ${geopoint}\nSpeed     : ${speed}  ${direction}\nAltitude  : ${altitude}\nOdometer  : ${odometer}\n\n";
            }
            if (StringTools.isBlank((String)string)) {
                string = "";
            }
        } else {
            string3 = "${" + KEY_SUBJECT[0] + "}";
            string2 = "${" + KEY_MESSAGE[0] + "}";
            string = "${" + KEY_SMSTEXT[0] + "}";
        }
        Locale locale = basicPrivateLabel != null ? basicPrivateLabel.getLocale() : null;
        EventDataText eventDataText = new EventDataText(account2, device2, eventData, string4, string5, string6, basicPrivateLabel);
        String string7 = eventDataText.toString(string3);
        String string8 = eventDataText.toString(string2);
        String string9 = eventDataText.toString(string);
        return new String[]{string7, string8, string9};
    }

    protected static boolean _sendNotification(boolean bl, Account account, Device device, EventData eventData, boolean bl2, int n, int n2, String string, Rule rule) {
        int n3;
        Object object2;
        CharSequence charSequence;
        String string222;
        Object object3;
        SendMail.SmtpProperties smtpProperties;
        Account account2 = EventRuleAction.GetAccount(account, device, eventData);
        Device device2 = EventRuleAction.GetDevice(device, eventData);
        if (account2 == null && device2 != null && (account2 = device2.getAccount()) == null) {
            Print.logError((String)("*** Device does not have a valid Account: " + device2.getDeviceID()), (Object[])new Object[0]);
            device2 = null;
        }
        String string3 = account2 != null ? account2.getAccountID() : "?";
        String string4 = device2 != null ? device2.getDeviceID() : "?";
        BasicPrivateLabel basicPrivateLabel = account2 != null ? account2.getPrivateLabel() : null;
        SendMail.SmtpProperties smtpProperties2 = smtpProperties = basicPrivateLabel != null ? basicPrivateLabel.getSmtpProperties() : null;
        if (rule != null && account2 != null && !rule.hasAccount() && rule.getAccountID().equals(string3)) {
            rule.setAccount(account2);
        }
        String string5 = "";
        String string6 = StringTools.trim((String)EventRuleAction._getNotificationRecipients(account2, device2, rule, n));
        if (!StringTools.isBlank((String)string6)) {
            for (String string222 : object3 = StringTools.parseStringArray((String)string6, (char)',')) {
                if (!SMSOutboundGateway.StartsWithSMS((String)string222)) continue;
                StringBuffer stringBuffer = new StringBuffer();
                charSequence = new StringBuffer();
                object2 = object3;
                int n4 = ((String[])object2).length;
                for (n3 = 0; n3 < n4; ++n3) {
                    String object4 = object2[n3];
                    if (StringTools.isBlank((String)object4)) continue;
                    if (SMSOutboundGateway.StartsWithSMS((String)object4)) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(object4.substring("SMS:".length()));
                        continue;
                    }
                    if (((StringBuffer)charSequence).length() > 0) {
                        ((StringBuffer)charSequence).append(",");
                    }
                    ((StringBuffer)charSequence).append(object4);
                }
                string5 = stringBuffer.toString();
                string6 = ((StringBuffer)charSequence).toString();
                break;
            }
        }
        object3 = StringTools.trim((String)EventRuleAction._getNotificationSender(account2, rule, n));
        String[] stringArray = EventRuleAction._getNotificationMessage(account2, device2, eventData, rule, n);
        String string7 = stringArray[0];
        String string8 = stringArray[1];
        string222 = stringArray[2];
        if ((n & 0x200) != 0 || (n & 0x100) != 0) {
            Print.logInfo((String)("From: " + (String)object3), (Object[])new Object[0]);
            Print.logInfo((String)("To (email): " + string6), (Object[])new Object[0]);
            Print.logInfo((String)("To (SMS)  : " + string5), (Object[])new Object[0]);
            Print.logInfo((String)("Subject   : " + string7), (Object[])new Object[0]);
            Print.logInfo((String)("Body      :\n" + string8), (Object[])new Object[0]);
            if (!StringTools.isBlank((String)string222)) {
                Print.logInfo((String)("SMS       : " + string222), (Object[])new Object[0]);
            }
        }
        if (!SEND_NOTIFICATION) {
            Print.logWarn((String)"Notification disabled ...", (Object[])new Object[0]);
            return true;
        }
        boolean bl3 = true;
        if ((n & 0x100) != 0) {
            if (StringTools.isBlank((String)string6) && StringTools.isBlank((String)string5)) {
                Print.logWarn((String)"EMail requested, but no recipients specified", (Object[])new Object[0]);
                bl3 = false;
            } else {
                if (!StringTools.isBlank((String)string6)) {
                    if (StringTools.isBlank((String)object3)) {
                        Print.logStackTrace((String)"Cannot determine 'From' email address!!!");
                        bl3 = false;
                    } else {
                        try {
                            Print.logInfo((String)"Sending rule notification email ...", (Object[])new Object[0]);
                            SendMail.send((String)object3, (String)string6, null, null, (String)string7, (String)string8, null, (SendMail.SmtpProperties)smtpProperties);
                            Audit.ruleNotification((String)string3, (String)string4, (String)string6, (String)string7, (String)string8);
                        }
                        catch (Throwable throwable) {
                            Print.logWarn((String)("SendMail error: " + throwable), (Object[])new Object[0]);
                            bl3 = false;
                        }
                    }
                }
                if (!StringTools.isBlank((String)string5)) {
                    if (account2 != null && account2.getSmsEnabled()) {
                        SMSOutboundGateway sMSOutboundGateway;
                        charSequence = Rule.CreateDefaultSmsText(string7, string8, string222);
                        if (((String)charSequence).length() > SMSOutboundGateway.getMaximumTextMessageLength()) {
                            charSequence = ((String)charSequence).substring(0, SMSOutboundGateway.getMaximumTextMessageLength()).trim();
                        }
                        if ((sMSOutboundGateway = SMSOutboundGateway.GetSMSGateway((String)(object2 = SMSOutboundGateway.GetDefaultGatewayName()))) != null) {
                            String[] stringArray2;
                            Print.logInfo((String)("Sending SMS via gateway: " + (String)object2), (Object[])new Object[0]);
                            for (String string2 : stringArray2 = StringTools.split((String)string5, (char)',')) {
                                if (SMSOutboundGateway.StartsWithSMS((String)string2)) {
                                    string2 = string2.substring("SMS:".length());
                                }
                                if (StringTools.isBlank((String)string2)) continue;
                                Print.logInfo((String)("SMS: " + string2 + " --> " + (String)charSequence), (Object[])new Object[0]);
                                DCServerFactory.ResultCode resultCode = sMSOutboundGateway.sendSMSMessage(account2, (String)charSequence, string2);
                                if (resultCode.isSuccess()) continue;
                                Print.logWarn((String)("SMS error: " + resultCode), (Object[])new Object[0]);
                                bl3 = false;
                            }
                        } else {
                            Print.logWarn((String)("SMS Gateway not found: " + (String)object2), (Object[])new Object[0]);
                        }
                    } else {
                        Print.logWarn((String)("SMS notification disabled for account: " + string3), (Object[])new Object[0]);
                    }
                }
            }
        }
        if ((n & 0x200) != 0) {
            try {
                charSequence = rule != null ? rule.getRuleID() : null;
                long l = eventData != null ? eventData.getTimestamp() : 0L;
                n3 = eventData != null ? eventData.getStatusCode() : 0;
                NotifyQueue.Key key = new NotifyQueue.Key(string3, string4, (String)charSequence, l, n3);
                NotifyQueue notifyQueue = (NotifyQueue)key.getDBRecord();
                notifyQueue.setAccount(account2);
                notifyQueue.setDevice(device2);
                notifyQueue.setRule(rule);
                notifyQueue.setPriority(n2);
                notifyQueue.setSender((String)object3);
                notifyQueue.setRecipients(string6);
                notifyQueue.setSubject(string7);
                notifyQueue.setMessage(string8);
                notifyQueue.save();
            }
            catch (DBException dBException) {
                Print.logException((String)"NotifyQueue error", (Throwable)dBException);
                bl3 = false;
            }
        }
        if ((n & 0x400) != 0) {
            EventRuleAction.fireRuleListeners(account2, device2, eventData, bl2, string, rule);
        }
        if ((n & 0x10000) != 0 && device2 != null) {
            try {
                String string10;
                boolean bl4 = bl;
                String string9 = string10 = rule != null ? rule.getRuleID() : "";
                if (eventData != null) {
                    device2.setLastNotifyEvent(eventData, string10, bl4);
                } else {
                    device2.setLastNotifyEvent(DateTime.getCurrentTimeSec(), string10, bl4);
                }
            }
            catch (DBException dBException) {
                Print.logError((String)("CRA: Unable to save Device notify time/code - " + (Object)((Object)dBException)), (Object[])new Object[0]);
            }
        }
        if (rule != null && rule.hasCannedActions()) {
            String[] stringArray3;
            for (String string10 : stringArray3 = StringTools.parseStringArray((String)rule.getCannedActions(), (String)";|")) {
                Object object;
                boolean bl4;
                String string2;
                Object[] objectArray = StringTools.parseStringArray((String)string10, (String)":,");
                if (ListTools.size((Object[])objectArray) <= 0) continue;
                Object object4 = objectArray[0];
                if (StringTools.isBlank((String)object4)) {
                    Print.logWarn((String)("CRA: Blank command: " + string10), (Object[])new Object[0]);
                    continue;
                }
                string2 = objectArray.length > 1 ? objectArray[1] : "";
                char c = ((String)object4).charAt(0);
                if (c == '%' || c == '@') continue;
                if (!Character.isLetter(c)) {
                    Print.logWarn((String)("CRA: Invalid command: " + string10), (Object[])new Object[0]);
                    continue;
                }
                if (CustomCRAListener != null && (bl4 = CustomCRAListener.handlePredefinedAction(rule, (String)object4, string2, account2, device2, eventData))) {
                    String string11 = string3 + "/" + string4;
                    Print.logInfo((String)("CRA: [" + string11 + "] Custom Predefined Action: " + (String)object4 + ":" + string2), (Object[])new Object[0]);
                    continue;
                }
                bl4 = false;
                if (account2 != null && device2 != null) {
                    bl4 = true;
                    String string12 = string3 + "/" + string4;
                    if (EventRuleAction.CRAMatch(CRA_resetMaint, (String)object4)) {
                        int string19 = StringTools.parseInt((String)string2, (int)0);
                        String string21 = device2.getMaintDescriptionKM(string19);
                        device2.resetMaintOdometerKM(string19);
                        Print.logInfo((String)("CRA: [" + string12 + "] Resetting Device maintenance: [" + string19 + "] " + string21), (Object[])new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_resetReminder, (String)object4)) {
                        int bl7 = StringTools.parseInt((String)string2, (int)0);
                        device2.resetReminder();
                        Print.logInfo((String)("CRA: [" + string12 + "] Resetting Device reminder"), (Object[])new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_save, (String)object4)) {
                        if ((n & 0x10000) != 0) continue;
                        try {
                            String n7;
                            boolean bl10 = bl;
                            Print.logInfo((String)("CRA: [" + string12 + "] Saving Device notify time/code"), (Object[])new Object[0]);
                            String string13 = n7 = rule != null ? rule.getRuleID() : "";
                            if (eventData != null) {
                                device2.setLastNotifyEvent(eventData, n7, bl10);
                                continue;
                            }
                            device2.setLastNotifyEvent(DateTime.getCurrentTimeSec(), n7, bl10);
                        }
                        catch (DBException dBException) {
                            Print.logError((String)("CRA: Unable to save Device notify time/code - " + (Object)((Object)dBException)), (Object[])new Object[0]);
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_setCorridor, (String)object4)) {
                        String dCServerConfig = string2;
                        if (!StringTools.isBlank((String)dCServerConfig)) {
                            Print.logInfo((String)("CRA: [" + string12 + "] Setting active corridor - " + dCServerConfig), (Object[])new Object[0]);
                            device2.setActiveCorridor(dCServerConfig);
                            if (bl) {
                                try {
                                    device2.update(new String[]{"activeCorridor"});
                                }
                                catch (DBException bl11) {
                                    Print.logError((String)("CRA: [" + string12 + "] Unable to update Device - " + (Object)((Object)bl11)), (Object[])new Object[0]);
                                }
                                continue;
                            }
                            device2.addOtherChangedFieldNames(new String[]{"activeCorridor"});
                            continue;
                        }
                        Print.logWarn((String)("CRA: [" + string12 + "] Invalid GeoCorridor ID specified: " + dCServerConfig), (Object[])new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_clearCorridor, (String)object4)) {
                        String n8 = device2.getActiveCorridor();
                        Print.logInfo((String)("CRA: [" + string12 + "] Clearing active corridor - " + n8), (Object[])new Object[0]);
                        device2.setActiveCorridor("");
                        if (bl) {
                            try {
                                device2.update(new String[]{"activeCorridor"});
                            }
                            catch (DBException string25) {
                                Print.logError((String)("CRA: [" + string12 + "] Unable to update Device - " + (Object)((Object)string25)), (Object[])new Object[0]);
                            }
                            continue;
                        }
                        device2.addOtherChangedFieldNames(new String[]{"activeCorridor"});
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_clearEMail, (String)object4)) {
                        String string23 = device2.getNotifyEmail();
                        Print.logInfo((String)("CRA: [" + string12 + "] Clearing Device notify-email - " + string23), (Object[])new Object[0]);
                        device2.setNotifyEmail("");
                        if (bl) {
                            try {
                                device2.update(new String[]{"notifyEmail"});
                            }
                            catch (DBException bl14) {
                                Print.logError((String)("CRA: [" + string12 + "] Unable to update Device - " + (Object)((Object)bl14)), (Object[])new Object[0]);
                            }
                            continue;
                        }
                        device2.addOtherChangedFieldNames(new String[]{"notifyEmail"});
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_park, (String)object4)) {
                        boolean n10 = false;
                        GeoPoint string30 = null;
                        String string29 = "Unspecified";
                        double d = 200.0;
                        if (eventData != null && eventData.isValidGeoPoint()) {
                            string30 = eventData.getGeoPoint();
                            string29 = "Event";
                            d = 200.0;
                        } else if (n10 && eventData != null && eventData.hasCellLocation()) {
                            string30 = eventData.getCellGeoPoint();
                            string29 = "CellTower";
                            d = 500.0;
                        } else if (device2.hasLastValidLocation()) {
                            string30 = device2.getLastValidLocation();
                            string29 = "LastKnown";
                            d = 200.0;
                        } else {
                            string30 = null;
                            string29 = "None";
                        }
                        try {
                            boolean bl5;
                            boolean bl6 = bl5 = bl;
                            if (GeoPoint.isValid((GeoPoint)string30)) {
                                double d2 = StringTools.parseDouble((String)string2, (double)0.0);
                                if (d2 <= 0.0) {
                                    d2 = d;
                                } else if (d2 < 5.0) {
                                    d2 = 5.0;
                                }
                                Print.logInfo((String)("CRA: [" + string12 + "] Setting Device park - (" + string29 + ") " + string30 + " radM=" + d2), (Object[])new Object[0]);
                                device2.setParkedLocation(string30, d2, bl5);
                                continue;
                            }
                            Print.logInfo((String)("CRA: [" + string12 + "] Unable to park Device (no valid GeoPoint)"), (Object[])new Object[0]);
                            device2.setParkedLocation(null, 0.0, bl5);
                        }
                        catch (DBException dBException) {
                            Print.logError((String)("CRA: [" + string12 + "] Unable to save Device park attributes - " + (Object)((Object)dBException)), (Object[])new Object[0]);
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_unpark, (String)object4)) {
                        try {
                            boolean string27 = bl;
                            Print.logInfo((String)("CRA: [" + string12 + "] Clearing Device park"), (Object[])new Object[0]);
                            device2.setParkedLocation(null, 0.0, string27);
                        }
                        catch (DBException string28) {
                            Print.logError((String)("CRA: [" + string12 + "] Unable to save Device park attributes - " + (Object)((Object)string28)), (Object[])new Object[0]);
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_sendCommand, (String)object4)) {
                        DCServerConfig n12 = device2.getDCServerConfig();
                        if (n12 != null) {
                            String string14 = "config";
                            String string15 = string2;
                            String[] stringArray2 = (String[])ListTools.toArray((Object[])objectArray, (int)2, (int)-1);
                            object = DCServerFactory.sendServerCommand((Device)device2, (String)string14, (String)string15, (String[])stringArray2);
                            if (object != null) {
                                Print.logWarn((String)("CRA: [" + string12 + "] 'sendCommand' response: " + object), (Object[])new Object[0]);
                                continue;
                            }
                            Print.logWarn((String)("CRA: [" + string12 + "] 'sendCommand' failed"), (Object[])new Object[0]);
                            continue;
                        }
                        Print.logWarn((String)("CRA: [" + string12 + "] Device DCServerConfig not found - " + device2.getDeviceCode()), (Object[])new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_addEvent, (String)object4)) {
                        EventData eventData2;
                        int n4;
                        int n5 = StringTools.parseInt((String)string2, (int)-1);
                        if (eventData == null) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Unable to add event - no EventData instance available"), (Object[])new Object[0]);
                            continue;
                        }
                        if (eventData.getIsSynthesizedEvent()) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Skipping recursive add event - already a rule triggered event"), (Object[])new Object[0]);
                            continue;
                        }
                        if (n5 < 0) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Unable to add event - no StatusCode specified"), (Object[])new Object[0]);
                            continue;
                        }
                        if (n5 == eventData.getStatusCode()) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Unable to add event - StatusCode already matches current event"), (Object[])new Object[0]);
                            continue;
                        }
                        int n6 = n4 = n5 <= 15 ? 0xFF00 | n5 : n5;
                        if (bl && !eventData.hasAddress()) {
                            eventData.reloadAddress();
                        }
                        if (device2.insertEventData(eventData2 = EventData.copySynthesizedEvent((EventData)eventData, (int)n4))) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Added new EventData - " + eventData2), (Object[])new Object[0]);
                            continue;
                        }
                        Print.logError((String)("CRA: [" + string12 + "] New EventData failed!"), (Object[])new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_resetCommands, (String)object4)) {
                        String string16 = string2;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        if (string16.equalsIgnoreCase("both") || StringTools.isBlank((String)string16)) {
                            bl7 = true;
                            bl8 = true;
                        } else if (string16.equalsIgnoreCase("account") || string16.equalsIgnoreCase("a")) {
                            bl7 = true;
                        } else if (string16.equalsIgnoreCase("device") || string16.equalsIgnoreCase("d")) {
                            bl8 = true;
                        }
                        if (bl8) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Clearing Device 'totalPingCount'"), (Object[])new Object[0]);
                            device2.setTotalPingCount(0);
                            if (bl) {
                                try {
                                    device2.update(new String[]{"totalPingCount"});
                                }
                                catch (DBException dBException) {
                                    Print.logError((String)("CRA: [" + string12 + "] Unable to update Device - " + (Object)((Object)dBException)), (Object[])new Object[0]);
                                }
                            } else {
                                device2.addOtherChangedFieldNames(new String[]{"totalPingCount"});
                            }
                        }
                        if (!bl7) continue;
                        account2.setTotalPingCount(0);
                        try {
                            account2.update(new String[]{"totalPingCount"});
                            Print.logWarn((String)("CRA: [" + string12 + "] Cleared Account 'totalPingCount'"), (Object[])new Object[0]);
                        }
                        catch (DBException dBException) {
                            Print.logException((String)("CRA: [" + string12 + "] Unable to update Account"), (Throwable)dBException);
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_setvar, (String)object4)) {
                        String string17;
                        int n7 = string2.indexOf("=");
                        String string18 = n7 >= 0 ? string2.substring(0, n7) : "";
                        String string19 = string17 = n7 >= 0 ? string2.substring(n7 + 1) : "";
                        if (StringTools.isBlank((String)string18)) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Setvar fieldName not specified"), (Object[])new Object[0]);
                            continue;
                        }
                        int n8 = -1;
                        object = "";
                        DBField dBField = null;
                        if (StringTools.startsWithIgnoreCase((String)string18, (String)"Account.")) {
                            string18 = string18.substring("Account.".length());
                            dBField = Account.getFactory().getField(string18);
                            n8 = 0;
                            object = "Account";
                        } else if (StringTools.startsWithIgnoreCase((String)string18, (String)"Device.")) {
                            string18 = string18.substring("Device.".length());
                            dBField = Device.getFactory().getField(string18);
                            n8 = 1;
                            object = "Device";
                        } else {
                            Print.logWarn((String)("CRA: [" + string12 + "] Setvar fieldName does not start with 'Account.' or 'Device.'"), (Object[])new Object[0]);
                            continue;
                        }
                        if (dBField == null) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Setvar fieldName does not exist: (" + (String)object + ") " + string18), (Object[])new Object[0]);
                            continue;
                        }
                        if (dBField.getFactory() == null) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Setvar fieldName DBFactory is null (" + (String)object + ")"), (Object[])new Object[0]);
                            continue;
                        }
                        if (dBField.isPrimaryKey()) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Setvar fieldName specifies a primary key field: (" + (String)object + ") " + string18), (Object[])new Object[0]);
                            continue;
                        }
                        Object object5 = dBField.parseStringValue(string17);
                        if (object5 == null) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Setvar fieldValue is invalid for field type: (" + (String)object + ") " + string18), (Object[])new Object[0]);
                            continue;
                        }
                        switch (n8) {
                            case 0: {
                                Print.logWarn((String)("CRA: [" + string12 + "] Setting Account Field '" + string18 + "' to value - " + object5), (Object[])new Object[0]);
                                account2.setFieldValue(string18, object5);
                                try {
                                    account2.update(new String[]{string18});
                                }
                                catch (DBException dBException) {
                                    Print.logError((String)("CRA: [" + string12 + "] Unable to update Account - " + (Object)((Object)dBException)), (Object[])new Object[0]);
                                }
                                break;
                            }
                            case 1: {
                                Print.logWarn((String)("CRA: [" + string12 + "] Setting Device Field '" + string18 + "' to value - " + object5), (Object[])new Object[0]);
                                device2.setFieldValue(string18, object5);
                                if (bl) {
                                    try {
                                        device2.update(new String[]{string18});
                                    }
                                    catch (DBException dBException) {
                                        Print.logError((String)("CRA: [" + string12 + "] Unable to update Device '" + string4 + "' " + (Object)((Object)dBException)), (Object[])new Object[0]);
                                    }
                                    break;
                                }
                                device2.addOtherChangedFieldNames(new String[]{string18});
                                break;
                            }
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_sendMQ, (String)object4)) {
                        if (eventData == null) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Unable to add event - no EventData instance available"), (Object[])new Object[0]);
                            continue;
                        }
                        Print.logWarn((String)("CRA: [" + string12 + "] Sending Event record via JMS/MQ not yet supported."), (Object[])new Object[0]);
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_emailReport, (String)object4)) {
                        String string20 = string2;
                        if (StringTools.isBlank((String)string20)) {
                            Print.logWarn((String)("CRA: [" + string12 + "] Report not specified"), (Object[])new Object[0]);
                            continue;
                        }
                        Print.logWarn((String)("CRA: [" + string12 + "] Emailing report not yet supported."), (Object[])new Object[0]);
                        continue;
                    }
                }
                boolean bl9 = false;
                if (account2 != null) {
                    bl9 = true;
                    if (EventRuleAction.CRAMatch(CRA_resetCommands, (String)object4)) {
                        String string21 = string2;
                        boolean bl10 = false;
                        if (string21.equalsIgnoreCase("both") || StringTools.isBlank((String)string21)) {
                            bl10 = true;
                        } else if (string21.equalsIgnoreCase("account") || string21.equalsIgnoreCase("a")) {
                            bl10 = true;
                        }
                        if (!bl10) continue;
                        account2.setTotalPingCount(0);
                        try {
                            account2.update(new String[]{"totalPingCount"});
                            Print.logWarn((String)("CRA: [" + string3 + "] Cleared Account 'totalPingCount'"), (Object[])new Object[0]);
                        }
                        catch (DBException dBException) {
                            Print.logException((String)("CRA: [" + string3 + "] Unable to update Account"), (Throwable)dBException);
                        }
                        continue;
                    }
                    if (EventRuleAction.CRAMatch(CRA_setvar, (String)object4)) {
                        String string23;
                        int n9 = string2.indexOf("=");
                        String string24 = n9 >= 0 ? string2.substring(0, n9) : "";
                        String string25 = string23 = n9 >= 0 ? string2.substring(n9 + 1) : "";
                        if (StringTools.isBlank((String)string24)) {
                            Print.logWarn((String)("CRA: [" + string3 + "] Setvar fieldName not specified"), (Object[])new Object[0]);
                            continue;
                        }
                        int n10 = -1;
                        object = null;
                        if (!string24.startsWith("Account.")) {
                            Print.logWarn((String)("CRA: [" + string3 + "] Setvar fieldName does not start with Account"), (Object[])new Object[0]);
                            continue;
                        }
                        string24 = string24.substring("Account.".length());
                        object = Account.getFactory().getField(string24);
                        n10 = 0;
                        if (object == null) {
                            Print.logWarn((String)("CRA: [" + string3 + "] Setvar fieldName does not exist"), (Object[])new Object[0]);
                            continue;
                        }
                        if (object.getFactory() == null) {
                            Print.logWarn((String)("CRA: [" + string3 + "] Setvar fieldName DBFactory is null"), (Object[])new Object[0]);
                            continue;
                        }
                        if (object.isPrimaryKey()) {
                            Print.logWarn((String)("CRA: [" + string3 + "] Setvar fieldName specifies a primary key field"), (Object[])new Object[0]);
                            continue;
                        }
                        Object object6 = object.parseStringValue(string23);
                        if (object6 == null) {
                            Print.logWarn((String)("CRA: [" + string3 + "] Setvar fieldValue is invalid"), (Object[])new Object[0]);
                            continue;
                        }
                        switch (n10) {
                            case 0: {
                                account2.setFieldValue(string24, object6);
                                try {
                                    account2.update(new String[]{string24});
                                    Print.logWarn((String)("CRA: [" + string3 + "] Set Account Field '" + string24 + "' to value: " + object6), (Object[])new Object[0]);
                                }
                                catch (DBException dBException) {
                                    Print.logException((String)("CRA: [" + string3 + "] Unable to update Account"), (Throwable)dBException);
                                }
                                break;
                            }
                        }
                        continue;
                    }
                }
                if (!bl4 && !bl9) {
                    Print.logWarn((String)("CRA: Account is null - " + string10), (Object[])new Object[0]);
                    continue;
                }
                Print.logWarn((String)("CRA: Command not found - " + string10), (Object[])new Object[0]);
            }
        }
        return bl3;
    }

    public static boolean _debugSendNotification(String string, String string2, int n) {
        EventData.Key key = new EventData.Key(string, string2, DateTime.getCurrentTimeSec(), n);
        EventData eventData = (EventData)key.getDBRecord();
        eventData.setAddress("1234 Somewhere Ln, Somewhere CA, 98765");
        eventData.setGeoPoint(new GeoPoint(35.12345, -142.12345));
        eventData.setSpeedKPH(105.0);
        eventData.setHeading(123.0);
        eventData.setAltitude(457.0);
        eventData.setOdometerKM(123456.0);
        eventData.setDistanceKM(3456.0);
        int n2 = 519;
        boolean bl = EventRuleAction._sendNotification(false, eventData.getAccount(), eventData.getDevice(), eventData, true, n2, 1, "(true)", null);
        Print.logInfo((String)("Notification saved: " + bl), (Object[])new Object[0]);
        return bl;
    }

    public static boolean _debugSendNotification(EventData eventData, Rule rule) {
        if (eventData == null) {
            Print.logError((String)"EventData is null", (Object[])new Object[0]);
            return false;
        }
        Account account = eventData.getAccount();
        Device device = eventData.getDevice();
        int n = rule != null ? rule.getActionMask() : 775;
        boolean bl = rule != null ? rule.getIsCronRule() : true;
        int n2 = rule != null ? rule.getPriority() : 1;
        String string = rule != null ? rule.getSelector() : "(true)";
        boolean bl2 = EventRuleAction._sendNotification(false, account, device, eventData, bl, n, n2, string, rule);
        Print.logInfo((String)("Notification result: " + bl2), (Object[])new Object[0]);
        return bl2;
    }

    public static void main(String[] stringArray) {
        DBConfig.cmdLineInit((String[])stringArray, (boolean)true);
        SendMail.SetThreadModel((String)"debug");
        BasicPrivateLabelLoader.loadPrivateLabelXML();
        EventRuleAction.DebugSetSendNotification(RTConfig.getBoolean((String)"send", (boolean)false));
        String string = RTConfig.getString((String)"account", (String)"opendmtp");
        String string2 = RTConfig.getString((String)"device", (String)"mobile");
        long l = DateTime.getCurrentTimeSec();
        Account account = null;
        Device device = null;
        try {
            account = Account.getAccount((String)string);
            device = Device.getDevice((Account)account, (String)string2);
            if (device == null) {
                Print.logError((String)("Device not found: " + string + "/" + string2), (Object[])new Object[0]);
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            Print.logException((String)"Account/Device error", (Throwable)throwable);
            System.exit(2);
        }
        long l2 = l - DateTime.MinuteSeconds((long)10L);
        EventData.Key key = new EventData.Key(string, string2, l2, 61472);
        EventData eventData = (EventData)key.getDBRecord();
        eventData.setDevice(device);
        eventData.setAddress("1234 Somewhere Else, Somewhere CA, 98765");
        eventData.setGeoPoint(new GeoPoint(35.12345, -142.12345));
        eventData.setSpeedKPH(27.0);
        eventData.setHeading(241.0);
        eventData.setAltitude(402.0);
        eventData.setOdometerKM(123412.0);
        eventData.setDistanceKM(3412.0);
        EventData.Key key2 = new EventData.Key(string, string2, l, 63761);
        EventData eventData2 = (EventData)key2.getDBRecord();
        eventData2.setDevice(device);
        eventData2.setAddress("4321 Somewhere Ln, Somewhere CA, 98764");
        eventData2.setGeoPoint(new GeoPoint(35.13456, -142.13456));
        eventData2.setSpeedKPH(45.0);
        eventData2.setHeading(123.0);
        eventData2.setAltitude(457.0);
        eventData2.setOdometerKM(123456.0);
        eventData2.setDistanceKM(3456.0);
        eventData2.setFieldValue("j1708Fault", DTOBDFault.EncodeFault_J1708((int)128, (boolean)true, (int)235, (int)3, (int)0, (boolean)true));
        eventData2.setPreviousEventData(eventData);
        String string3 = EventRuleAction._getNotificationRecipients(account, device, null, -1);
        Print.sysPrintln((String)("Email Recipients: " + string3), (Object[])new Object[0]);
        boolean bl = EventRuleAction._sendNotification(false, eventData2.getAccount(), eventData2.getDevice(), eventData2, true, 263, 1, "(true)", null);
        if (bl) {
            Print.logInfo((String)"EMail/SMS sent successfully", (Object[])new Object[0]);
        } else {
            Print.logInfo((String)"EMail/SMS not sent", (Object[])new Object[0]);
        }
    }

    static {
        Object object;
        Object object2;
        PROP_emailSubj = new String[]{"emailSubject", "emailSubj"};
        PROP_emailBody = new String[]{"emailBody"};
        PROP_smsText = new String[]{"smsText", "textMessage"};
        KEY_SUBJECT = new String[]{"subject", "ruleSubject"};
        KEY_MESSAGE = new String[]{"message", "ruleMessage"};
        KEY_SMSTEXT = new String[]{"smsText", "ruleSmsText"};
        KEY_PRIOR_GEOZONE = new String[]{"priorGeozone", "priorGeozoneID"};
        KEY_PRIOR_ADDRESS = new String[]{"priorAddress", "priorFullAddress"};
        KEY_MAP_URL = new String[]{"mapURL"};
        KEY_REPORT_URL = new String[]{"reportURL"};
        CRA_resetMaint = new String[]{"resetMaint"};
        CRA_resetReminder = new String[]{"resetReminder", "resetRemind"};
        CRA_save = new String[]{"saveAlert", "save"};
        CRA_setCorridor = new String[]{"setCorridor"};
        CRA_clearCorridor = new String[]{"clearCorridor"};
        CRA_sendCommand = new String[]{"sendCommand"};
        CRA_clearEMail = new String[]{"clearEMail"};
        CRA_addEvent = new String[]{"addEvent", "event"};
        CRA_sendMQ = new String[]{"sendMQ", "sendJMS"};
        CRA_emailReport = new String[]{"emailReport"};
        CRA_resetCommands = new String[]{"resetCommands", "resetPingCount"};
        CRA_park = new String[]{"park"};
        CRA_unpark = new String[]{"unpark"};
        CRA_setvar = new String[]{"setvar", "setfield"};
        PredefinedRuleActionList = new PredefinedRuleAction[]{new PredefinedRuleAction(CRA_resetMaint[0], "0", I18N.getString(EventRuleAction.class, (String)"PredefinedRuleAction.resetMaint_0", (String)"Reset Maintenance #0")), new PredefinedRuleAction(CRA_resetMaint[0], "1", I18N.getString(EventRuleAction.class, (String)"PredefinedRuleAction.resetMaint_1", (String)"Reset Maintenance #1")), new PredefinedRuleAction(CRA_resetReminder[0], "", I18N.getString(EventRuleAction.class, (String)"PredefinedRuleAction.resetReminder", (String)"Reset Reminder")), new PredefinedRuleAction(CRA_resetCommands[0], "", I18N.getString(EventRuleAction.class, (String)"PredefinedRuleAction.resetCommands", (String)"Reset Max Commands")), new PredefinedRuleAction(CRA_park[0], "100", I18N.getString(EventRuleAction.class, (String)"PredefinedRuleAction.park_100", (String)"Park with 100 meter radius")), new PredefinedRuleAction(CRA_unpark[0], "", I18N.getString(EventRuleAction.class, (String)"PredefinedRuleAction.unpark", (String)"Unpark"))};
        SEND_NOTIFICATION = true;
        RuleListenerList = null;
        CustomCRAListener = null;
        String string = RTConfig.getString((String)"rule.ruleListenerClass");
        if (!StringTools.isBlank((String)string)) {
            try {
                object2 = Class.forName(string);
                object = (RuleListener)((Class)object2).newInstance();
                EventRuleAction.addRuleListener((RuleListener)object);
            }
            catch (Throwable throwable) {
                Print.logException((String)"Invalid RuleListener class (property rule.ruleListenerClass)", (Throwable)throwable);
            }
        }
        if (!StringTools.isBlank((String)(object2 = RTConfig.getString((String)"rule.predefinedActionClass")))) {
            try {
                PredefinedActionListener predefinedActionListener;
                object = Class.forName((String)object2);
                CustomCRAListener = predefinedActionListener = (PredefinedActionListener)((Class)object).newInstance();
            }
            catch (Throwable throwable) {
                Print.logException((String)"Invalid PredefinedActionListener class (property rule.predefinedActionClass)", (Throwable)throwable);
            }
        }
        PROP_ThreadPool_EventRuleAction_ = RTKey.valueOf((String)"Rule.ThreadPool.EventRuleAction.");
        ThreadPool_EventRuleAction = new ThreadPool("EventRuleAction", PROP_ThreadPool_EventRuleAction_, 20, 0, 0);
    }

    public static class EventDataText
    implements StringTools.KeyValueMap {
        private Account account = null;
        private Device device = null;
        private EventData event = null;
        private BasicPrivateLabel privLabel = null;
        private String messageSubj = null;
        private String messageBody = null;
        private String messageSmsM = null;

        public EventDataText(Account account, Device device, EventData eventData, String string, String string2, String string3, BasicPrivateLabel basicPrivateLabel) {
            String string4;
            this.account = account;
            this.device = device;
            this.event = eventData;
            this.privLabel = basicPrivateLabel;
            this.messageSubj = !StringTools.isBlank((String)string) ? StringTools.insertKeyValues((String)string, (String)"${", (String)"}", (String)"=", (StringTools.KeyValueMap)this) : null;
            if (!StringTools.isBlank((String)string2)) {
                string4 = StringTools.insertKeyValues((String)string2, (String)"${", (String)"}", (String)"=", (StringTools.KeyValueMap)this);
                this.messageBody = StringTools.replace((String)string4, (String)"\\n", (String)"\n");
            } else {
                this.messageBody = null;
            }
            if (!StringTools.isBlank((String)string3)) {
                string4 = StringTools.insertKeyValues((String)string3, (String)"${", (String)"}", (String)"=", (StringTools.KeyValueMap)this);
                this.messageSmsM = StringTools.replace((String)string4, (String)"\\n", (String)"\n");
            } else {
                this.messageSmsM = null;
            }
        }

        public String toString(String string) {
            return StringTools.insertKeyValues((String)string, (String)"${", (String)"}", (String)"=", (StringTools.KeyValueMap)this);
        }

        public String toString() {
            return this.toString("Account   : [${accountid}] ${account}\nVehicle   : [${deviceid}] ${device}\nDate/Time : ${datetime}\nStatus    : [${statuscode}] ${status}\nLocation  : ${geopoint}\nSpeed     : ${speed}  ${direction}\nAltitude  : ${altitude}\nOdometer  : ${odometer}\n\n");
        }

        public String getKeyValue(String string, String string2, String string3) {
            if (ListTools.containsIgnoreCase((String[])KEY_SUBJECT, (String)string)) {
                return this.messageSubj != null ? this.messageSubj : string3;
            }
            if (ListTools.containsIgnoreCase((String[])KEY_MESSAGE, (String)string)) {
                return this.messageBody != null ? this.messageBody : string3;
            }
            if (ListTools.containsIgnoreCase((String[])KEY_SMSTEXT, (String)string)) {
                return this.messageSmsM != null ? this.messageSmsM : string3;
            }
            if (ListTools.containsIgnoreCase((String[])KEY_MAP_URL, (String)string)) {
                return string3;
            }
            if (ListTools.containsIgnoreCase((String[])KEY_REPORT_URL, (String)string)) {
                return string3;
            }
            if (ListTools.containsIgnoreCase((String[])KEY_PRIOR_ADDRESS, (String)string)) {
                if (this.event != null) {
                    try {
                        EventData eventData = this.event.getPreviousEventData(true);
                        return eventData != null ? eventData.getAddress() : string3;
                    }
                    catch (DBException dBException) {
                        return "(" + string + "!)";
                    }
                }
                return string3;
            }
            if (ListTools.containsIgnoreCase((String[])KEY_PRIOR_GEOZONE, (String)string)) {
                if (this.event != null) {
                    try {
                        EventData eventData = this.event.getPreviousEventData(true);
                        return eventData != null ? eventData.getGeozoneID() : string3;
                    }
                    catch (DBException dBException) {
                        return "(" + string + "!)";
                    }
                }
                return string3;
            }
            if (string.startsWith("#")) {
                if (this.event != null) {
                    try {
                        EventData eventData = this.event.getPreviousEventData(true);
                        if (eventData != null) {
                            String string4 = string.substring(1);
                            String string5 = eventData.getKeyFieldValue(string4, string2, this.privLabel);
                            return string5 != null ? string5 : string3;
                        }
                        return string3;
                    }
                    catch (DBException dBException) {
                        return "(" + string + "!)";
                    }
                }
                return string3;
            }
            if (this.event != null) {
                String string6 = this.event.getKeyFieldValue(string, string2, this.privLabel);
                return string6 != null ? string6 : "(" + string + ")";
            }
            if (this.device != null) {
                String string7 = this.device.getKeyFieldValue(string, string2, this.privLabel);
                return string7 != null ? string7 : "(" + string + ")";
            }
            if (this.account != null) {
                String string8 = this.account.getKeyFieldValue(string, string2, this.privLabel);
                return string8 != null ? string8 : "(" + string + ")";
            }
            return "(" + string + ")";
        }
    }
}

