/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.rule;

import java.util.TimeZone;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.StatusCode;
import org.opengts.dbtools.DBException;
import org.opengts.rule.NotificationMessage;
import org.opengts.rule.tables.Rule;
import org.opengts.util.DateTime;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public abstract class DefaultNotificationMessage
implements NotificationMessage {
    private int priority = 0;
    private Account account = null;
    private String accountID = null;
    private String accountDesc = null;
    private Device device = null;
    private String deviceID = null;
    private String deviceDesc = null;
    private Rule rule = null;
    private String ruleID = null;
    private String ruleDesc = null;
    private long timestamp = 0L;
    private int statusCode = 0;
    private String sender = null;
    private String recipients = null;
    private String subject = null;
    private String body = null;

    public DefaultNotificationMessage(int n, String string, String string2, String string3, long l, int n2, String string4, String string5, String string6, String string7) {
        this.setPriority(n);
        this.setAccountID(string, null);
        this.setDeviceID(string2, null);
        this.setRuleID(string3, null);
        this.setTimestamp(l);
        this.setStatusCode(n2);
        this.setSender(string4);
        this.setRecipients(string5);
        this.setSubject(string6);
        this.setBody(string7);
    }

    public DefaultNotificationMessage(int n, EventData eventData, String string, String string2, String string3, String string4) {
        this.setPriority(n);
        if (eventData != null) {
            this.setDevice(eventData.getDevice());
            this.setTimestamp(eventData.getTimestamp());
            this.setStatusCode(eventData.getStatusCode());
        }
        this.setSender(string);
        this.setRecipients(string2);
        this.setSubject(string3);
        this.setBody(string4);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public void setAccountID(String string, String string2) {
        this.account = null;
        this.accountID = string;
        this.accountDesc = string2;
    }

    @Override
    public String getAccountID() {
        return this.accountID != null ? this.accountID : "";
    }

    @Override
    public String getAccountDescription() {
        Account account;
        if (this.accountDesc == null && (account = this.getAccount()) != null) {
            this.accountDesc = account.getDescription();
        }
        return this.accountDesc != null ? this.accountDesc : "";
    }

    public void setAccount(Account account) {
        this.account = account;
        if (this.account != null) {
            this.accountID = this.account.getAccountID();
            this.accountDesc = this.account.getDescription();
        } else {
            this.accountID = null;
            this.accountDesc = null;
        }
        this.device = null;
        this.deviceID = null;
        this.deviceDesc = null;
    }

    public Account getAccount() {
        if (this.account == null) {
            try {
                this.account = Account.getAccount((String)this.getAccountID());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return this.account;
    }

    public void setDeviceID(String string, String string2) {
        this.device = null;
        this.deviceID = string;
        this.deviceDesc = string2;
    }

    @Override
    public String getDeviceID() {
        return this.deviceID != null ? this.deviceID : "";
    }

    @Override
    public String getDeviceDescription() {
        Device device;
        if (this.deviceDesc == null && (device = this.getDevice()) != null) {
            this.deviceDesc = device.getDescription();
        }
        return this.deviceDesc != null ? this.deviceDesc : "";
    }

    public void setDevice(Device device) {
        this.device = device;
        if (this.device != null) {
            this.account = this.device.getAccount();
            this.accountID = this.device.getAccountID();
            this.accountDesc = this.account != null ? this.account.getDescription() : null;
            this.deviceID = this.device.getDeviceID();
            this.deviceDesc = this.device.getDescription();
        } else {
            this.deviceID = null;
            this.deviceDesc = null;
        }
    }

    public Device getDevice() {
        if (this.device == null) {
            try {
                this.device = Device.getDevice((Account)this.getAccount(), (String)this.getDeviceID());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return this.device;
    }

    public void setRuleID(String string, String string2) {
        this.rule = null;
        this.ruleID = string;
        this.ruleDesc = string2;
    }

    public String getRuleID() {
        return this.ruleID != null ? this.ruleID : "";
    }

    public String getRuleDescription() {
        Rule rule;
        if (this.ruleDesc == null && (rule = this.getRule()) != null) {
            this.ruleDesc = rule.getDescription();
        }
        return this.ruleDesc != null ? this.ruleDesc : "";
    }

    public void setRule(Rule rule) {
        this.rule = rule;
        if (this.rule != null) {
            this.ruleID = this.rule.getRuleID();
            this.ruleDesc = this.rule.getDescription();
            if (this.account == null) {
                this.account = this.rule.getAccount();
                this.accountID = this.rule.getAccountID();
                this.accountDesc = this.account != null ? this.account.getDescription() : null;
            }
        } else {
            this.ruleID = null;
            this.ruleDesc = null;
        }
    }

    public Rule getRule() {
        if (this.rule == null && !StringTools.isBlank((String)this.getRuleID())) {
            try {
                this.rule = Rule.getRule(this.getAccountID(), this.getRuleID());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return this.rule;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    @Override
    public String getTimestampString() {
        Account account = this.getAccount();
        String string = account != null ? account.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
        String string2 = account != null ? account.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat();
        TimeZone timeZone = account != null ? account.getTimeZone(null) : DateTime.getGMTTimeZone();
        DateTime dateTime = new DateTime(this.getTimestamp(), timeZone);
        return dateTime.format(string + " " + string2 + " z");
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Override
    public String getStatusCodeDescription(BasicPrivateLabel basicPrivateLabel) {
        int n;
        Device device = this.getDevice();
        String string = StatusCode.getDescription((Device)device, (int)(n = this.getStatusCode()), (BasicPrivateLabel)basicPrivateLabel, null);
        if (StringTools.isBlank((String)string)) {
            Print.logError((String)("StatusCode description is empty! : 0x" + StringTools.toHexString((long)n, (int)16)), (Object[])new Object[0]);
        }
        return string;
    }

    @Override
    public String getSender() {
        return this.sender;
    }

    public void setSender(String string) {
        this.sender = string;
    }

    @Override
    public String getRecipients() {
        return this.recipients;
    }

    public void setRecipients(String string) {
        this.recipients = string;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }
}

