/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.gtsdmtp;

import java.io.File;
import org.opendmtp.server.base.AccountID;
import org.opendmtp.server.base.DMTPServer;
import org.opendmtp.server.base.DeviceID;
import org.opendmtp.server.base.Event;
import org.opendmtp.server.base.Packet;
import org.opendmtp.server.base.PacketParseException;
import org.opengts.db.DBConfig;
import org.opengts.dbtools.DBAdmin;
import org.opengts.servers.gtsdmtp.DMTPDBFactory;
import org.opengts.util.FileTools;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class ParseFile {
    private static String[] ARG_ACCOUNT = new String[]{"account", "acct", "a"};
    private static String[] ARG_DEVICE = new String[]{"device", "dev", "d"};
    private static String[] ARG_FILE = new String[]{"file", "f"};

    private static void usage() {
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + ParseFile.class.getName() + " {options}", new Object[0]);
        Print.logInfo("Common Options:", new Object[0]);
        Print.logInfo("  -account=<id>   Acount ID which owns Device", new Object[0]);
        Print.logInfo("  -device=<id>    Device ID to which parsed events will be inserted", new Object[0]);
        Print.logInfo("  -file=<file>    The OpenDMTP event file to parse", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        int len;
        DBConfig.cmdLineInit(argv, true);
        DMTPServer.setDBFactory((DMTPServer.DBFactory)new DMTPDBFactory());
        String accountID = RTConfig.getString(ARG_ACCOUNT, null);
        String deviceID = RTConfig.getString(ARG_DEVICE, null);
        File evFile = RTConfig.getFile(ARG_FILE, null);
        if (StringTools.isBlank(accountID) || StringTools.isBlank(deviceID) || evFile == null) {
            ParseFile.usage();
        }
        if (!evFile.isFile()) {
            Print.sysPrintln("ERROR: File does not exist - " + evFile, new Object[0]);
            System.exit(99);
        }
        if (!DBAdmin.verifyTablesExist()) {
            Print.sysPrintln("ERROR: MySQL database has not yet been properly initialized", new Object[0]);
            System.exit(99);
        }
        AccountID account = null;
        DeviceID device = null;
        try {
            account = AccountID.loadAccountID((String)accountID);
            if (account == null) {
                Print.sysPrintln("ERROR: Unable to load Account - " + accountID, new Object[0]);
                System.exit(99);
            }
            if ((device = DeviceID.loadDeviceID((AccountID)account, (String)deviceID)) == null) {
                Print.sysPrintln("ERROR: Unable to load Device - " + accountID + "/" + deviceID, new Object[0]);
                System.exit(99);
            }
        }
        catch (PacketParseException ppe) {
            Print.logException("Unable to load DeviceID: " + accountID + "/" + deviceID, ppe);
            System.exit(99);
        }
        byte[] pktData = FileTools.readFile(evFile);
        if (ListTools.isEmpty(pktData)) {
            Print.sysPrintln("ERROR: Unable to read packet file: " + evFile, new Object[0]);
            System.exit(99);
        }
        for (int pktOfs = 0; pktOfs < pktData.length; pktOfs += len) {
            len = Packet.getPacketLength((byte[])pktData, (int)pktOfs);
            if (len < 0) {
                Print.sysPrintln("ERROR: Found invalid packet at offset " + pktOfs, new Object[0]);
                System.exit(99);
            }
            byte[] pkt = new byte[len];
            System.arraycopy(pktData, pktOfs, pkt, 0, len);
            try {
                Packet packet = new Packet(device, true, pkt);
                if (!packet.isEventType()) continue;
                Event evData = new Event(null, packet);
                int err = device.saveEvent(evData);
                if (err != 0) {
                    Print.sysPrintln("ERROR: Event insertion error: " + err, new Object[0]);
                    continue;
                }
                if (!RTConfig.isDebugMode()) continue;
                Print.sysPrintln("Saved event: " + evData, new Object[0]);
                continue;
            }
            catch (PacketParseException ppe) {
                Print.logException("Unable to parse packet", ppe);
                System.exit(1);
            }
        }
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("... Done.", new Object[0]);
    }
}

