/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.gtsdmtp;

import java.util.Vector;
import org.opendmtp.server.base.DMTPClientPacketHandler;
import org.opendmtp.server.base.DMTPServer;
import org.opengts.Version;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Transport;
import org.opengts.dbtools.DBAdmin;
import org.opengts.servers.gtsdmtp.DMTPDBFactory;
import org.opengts.servers.gtsdmtp.DeviceDBImpl;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTKey;

public class Main {
    public static final String[] ARG_HELP = new String[]{"h", "help"};
    public static final String[] ARG_PORT = new String[]{"p", "port"};
    public static final String[] ARG_START = new String[]{"start"};
    public static final String COPYRIGHT = "Copyright 2007-2013, GeoTelematic Solutions, Inc.";
    public static final String VERSION = "1.2.3";
    public static final String DEVICE_CODE = "gtsdmtp";
    public static final String CFG_firstSessionNegotiation = "gtsdmtp.firstSessionNegotiation";
    public static final String CFG_udpReturnResponse = "gtsdmtp.udpReturnResponse";
    private static DCServerConfig dcServerCfg = null;

    public static String DCServerFactory_LoadName() {
        return Main.getServerContextName();
    }

    public static String getServerName() {
        return DEVICE_CODE;
    }

    public static String getServerContextName() {
        return RTConfig.getContextName(Main.getServerName());
    }

    public static DCServerConfig getServerConfig() {
        if (dcServerCfg == null) {
            dcServerCfg = DCServerFactory.getServerConfig(Main.getServerContextName());
            DCServerConfig.startRemoteLogging(dcServerCfg);
        }
        return dcServerCfg;
    }

    public static int[] getTcpPorts() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            return dcs.getTcpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int[] getUdpPorts() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            return dcs.getUdpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int[] getListenPorts() {
        Vector<Integer> portList = new Vector<Integer>();
        int[] tcpPorts = Main.getTcpPorts();
        for (int t = 0; t < tcpPorts.length; ++t) {
            Integer tcp = new Integer(tcpPorts[t]);
            portList.add(tcp);
        }
        int[] udpPorts = Main.getUdpPorts();
        for (int u = 0; u < udpPorts.length; ++u) {
            Integer udp = new Integer(udpPorts[u]);
            if (portList.contains(udp)) continue;
            portList.add(udp);
        }
        int[] ports = new int[portList.size()];
        for (int p = 0; p < portList.size(); ++p) {
            ports[p] = (Integer)portList.get(p);
        }
        return ports;
    }

    private static void usage(String msg) {
        if (msg != null) {
            Print.logInfo(msg, new Object[0]);
        }
        Print.logInfo("", new Object[0]);
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + Main.class.getName() + " {options}", new Object[0]);
        Print.logInfo("Options:", new Object[0]);
        Print.logInfo("  [-h[elp]]         Print this help", new Object[0]);
        Print.logInfo("  [-port=<p>[,<p>]] Server port(s) to listen on", new Object[0]);
        Print.logInfo("  -start            Start server on the specified port", new Object[0]);
        Print.logInfo("", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        long udpSessTimeout;
        long udpPcktTimeout;
        long udpIdleTimeout;
        long tcpSessTimeout;
        long tcpPcktTimeout;
        RTKey.addRuntimeEntry(new RTKey.Entry(CFG_firstSessionNegotiation, true, "DMTP allow 1st session custom event negotiation"));
        RTKey.addRuntimeEntry(new RTKey.Entry(CFG_udpReturnResponse, true, "DMTP return UDP response/ack"));
        DBConfig.cmdLineInit(argv, false);
        DMTPServer.setDBFactory((DMTPServer.DBFactory)new DMTPDBFactory());
        Print.logInfo("----------------------------------------------------------------", new Object[0]);
        Print.logInfo("OpenDMTP (GTS) Java Server", new Object[0]);
        Print.logInfo(COPYRIGHT, new Object[0]);
        Print.logInfo("DMTP Version     : " + org.opendmtp.server.Version.getVersion(), new Object[0]);
        Print.logInfo("GTSDMTP Version  : 1.2.3", new Object[0]);
        Print.logInfo("GTS  Version     : " + Version.getVersion(), new Object[0]);
        Print.logInfo("SQL Database Name: " + RTConfig.getString("db.sql.dbname"), new Object[0]);
        Print.logInfo("Transport Enabled: " + Transport.isTransportQueryEnabled(), new Object[0]);
        Print.logInfo("Message Log Level: " + Print.getLogLevelString(Print.getLogLevel()), new Object[0]);
        Print.logInfo("----------------------------------------------------------------", new Object[0]);
        if (RTConfig.getBoolean(ARG_HELP, false)) {
            Main.usage("Help ...");
        }
        int[] listenPorts = Main.getListenPorts();
        if (!DBAdmin.verifyTablesExist()) {
            Print.logFatal("MySQL database has not yet been properly initialized", new Object[0]);
            System.exit(1);
        }
        DCServerConfig dcs = Main.getServerConfig();
        if (RTConfig.hasProperty(CFG_firstSessionNegotiation)) {
            if (RTConfig.getBoolean(CFG_firstSessionNegotiation, true)) {
                DMTPServer.setAllowFirstSessionNegotiation((boolean)true);
            } else {
                Print.logInfo("First session custom event packet negotiation DISABLED ...", new Object[0]);
                DMTPServer.setAllowFirstSessionNegotiation((boolean)false);
            }
        } else if (dcs.getBooleanProperty(CFG_firstSessionNegotiation, true)) {
            DMTPServer.setAllowFirstSessionNegotiation((boolean)true);
        } else {
            Print.logInfo("First session custom event packet negotiation DISABLED ...", new Object[0]);
            DMTPServer.setAllowFirstSessionNegotiation((boolean)false);
        }
        if (RTConfig.hasProperty(CFG_udpReturnResponse)) {
            if (RTConfig.getBoolean(CFG_udpReturnResponse, true)) {
                Print.logInfo("UDP responses/acks will be returned to UDP packets ...", new Object[0]);
                DMTPClientPacketHandler.setUdpReturnResponse((boolean)true);
            } else {
                Print.logInfo("No UDP responses will be returned ...", new Object[0]);
                DMTPClientPacketHandler.setUdpReturnResponse((boolean)false);
            }
        } else if (dcs.getBooleanProperty(CFG_udpReturnResponse, true)) {
            Print.logInfo("UDP responses/acks will be returned to UDP packets ...", new Object[0]);
            DMTPClientPacketHandler.setUdpReturnResponse((boolean)true);
        } else {
            Print.logInfo("No UDP responses will be returned ...", new Object[0]);
            DMTPClientPacketHandler.setUdpReturnResponse((boolean)false);
        }
        DeviceDBImpl.configInit();
        String dcsName = dcs.getName();
        long tcpIdleTimeout = dcs.getTcpIdleTimeoutMS(-1L);
        if (tcpIdleTimeout > 0L) {
            DMTPServer.setTcpIdleTimeout((long)tcpIdleTimeout);
        }
        if ((tcpPcktTimeout = dcs.getTcpPacketTimeoutMS(-1L)) > 0L) {
            DMTPServer.setTcpPacketTimeout((long)tcpPcktTimeout);
        }
        if ((tcpSessTimeout = dcs.getTcpSessionTimeoutMS(-1L)) > 0L) {
            DMTPServer.setTcpSessionTimeout((long)tcpSessTimeout);
        }
        if ((udpIdleTimeout = dcs.getUdpIdleTimeoutMS(-1L)) > 0L) {
            DMTPServer.setUdpIdleTimeout((long)udpIdleTimeout);
        }
        if ((udpPcktTimeout = dcs.getUdpPacketTimeoutMS(-1L)) > 0L) {
            DMTPServer.setUdpPacketTimeout((long)udpPcktTimeout);
        }
        if ((udpSessTimeout = dcs.getUdpSessionTimeoutMS(-1L)) > 0L) {
            DMTPServer.setUdpSessionTimeout((long)udpSessTimeout);
        }
        if (RTConfig.getBoolean(ARG_START, false)) {
            try {
                DMTPServer.createTrackSocketHandler((int[])listenPorts);
            }
            catch (Throwable t) {
                Print.logError("Error: " + t, new Object[0]);
            }
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(3600000L);
                    }
                }
                catch (Throwable t) {
                    continue;
                }
                break;
            }
        }
        Main.usage("Please specify an option ...");
    }
}

