/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.gtsdmtp;

import java.util.HashSet;
import java.util.Set;
import org.opendmtp.server.base.DMTPGeoEvent;
import org.opendmtp.server.base.Packet;
import org.opendmtp.server.base.PacketList;
import org.opendmtp.server.base.PacketParseException;
import org.opendmtp.server.db.DeviceDB;
import org.opendmtp.server.db.PayloadTemplate;
import org.opengts.cellid.CellTower;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.DataTransport;
import org.opengts.db.dmtp.Diagnostic;
import org.opengts.db.dmtp.EventTemplate;
import org.opengts.db.dmtp.PendingPacket;
import org.opengts.db.dmtp.Property;
import org.opengts.db.dmtp.PropertyKey;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.dbtypes.DTProfileMask;
import org.opengts.servers.gtsdmtp.Main;
import org.opengts.util.GeoPoint;
import org.opengts.util.ListTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class DeviceDBImpl
implements DeviceDB {
    public static final String DEVICE_CODE = "gtsdmtp";
    public static boolean ESTIMATE_ODOMETER = false;
    public static boolean SIMEVENT_GEOZONES = false;
    private Device device = null;
    private DataTransport dataXPort = null;
    private Set<String> devFields = null;

    public static void configInit() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            ESTIMATE_ODOMETER = dcs.getEstimateOdometer(ESTIMATE_ODOMETER);
            SIMEVENT_GEOZONES = dcs.getSimulateGeozones(SIMEVENT_GEOZONES);
        }
        Print.logInfo("Estimate Odometer  : " + ESTIMATE_ODOMETER, new Object[0]);
        Print.logInfo("Simulated Geozones : " + SIMEVENT_GEOZONES, new Object[0]);
    }

    public DeviceDBImpl(Device dev) {
        this.device = dev;
        this.dataXPort = this.device.getDataTransport();
        if (!this.dataXPort.getSupportsDMTP()) {
            this.dataXPort.setSupportsDMTP(true);
            this._addUpdateField("supportsDMTP");
        }
        if (!this.dataXPort.getDeviceCode().equalsIgnoreCase(DEVICE_CODE)) {
            this.dataXPort.setDeviceCode(DEVICE_CODE);
            this._addUpdateField("deviceCode");
        }
    }

    private void _addUpdateField(String fldName) {
        if (this.devFields == null) {
            this.devFields = new HashSet<String>();
        }
        this.devFields.add(fldName);
    }

    public Device getDevice() {
        return this.device;
    }

    public Account getAccount() {
        return this.getDevice().getAccount();
    }

    public String getAccountName() {
        return this.device.getAccountID();
    }

    public String getDeviceName() {
        return this.device.getDeviceID();
    }

    public String getDescription() {
        return this.device.getDescription();
    }

    public boolean isActive() {
        return this.device.getIsActive();
    }

    public boolean isValidIpAddress(String ipAddr) {
        if (this.dataXPort.isValidIPAddress(ipAddr)) {
            this.dataXPort.setIpAddressCurrent(ipAddr);
            this._addUpdateField("ipAddressCurrent");
            return true;
        }
        return false;
    }

    public int getMaxAllowedEvents() {
        return this.dataXPort.getMaxAllowedEvents();
    }

    public long getEventCount(long timeStart, long timeEnd) {
        try {
            return this.device.getEventCount(timeStart, timeEnd);
        }
        catch (DBException dbe) {
            dbe.printException();
            return -1L;
        }
    }

    public int getLimitTimeIntervalMinutes() {
        return this.dataXPort.getUnitLimitInterval();
    }

    public int getMaxTotalConnections() {
        return this.dataXPort.getTotalMaxConn();
    }

    public int getMaxTotalConnectionsPerMinute() {
        return this.dataXPort.getTotalMaxConnPerMin();
    }

    public byte[] getTotalConnectionProfile() {
        DTProfileMask v = this.dataXPort.getTotalProfileMask();
        return v != null ? v.getByteMask() : new byte[]{};
    }

    public void setTotalConnectionProfile(byte[] profile) {
        DTProfileMask mask = new DTProfileMask(profile);
        mask.setLimitTimeInterval(this.getLimitTimeIntervalMinutes());
        this.dataXPort.setTotalProfileMask(mask);
        this._addUpdateField("totalProfileMask");
    }

    public long getLastTotalConnectionTime() {
        return this.dataXPort.getLastTotalConnectTime();
    }

    public void setLastTotalConnectionTime(long time) {
        this.dataXPort.setLastTotalConnectTime(time);
        this._addUpdateField("lastTotalConnectTime");
    }

    public int getMaxDuplexConnections() {
        return this.dataXPort.getDuplexMaxConn();
    }

    public int getMaxDuplexConnectionsPerMinute() {
        return this.dataXPort.getDuplexMaxConnPerMin();
    }

    public byte[] getDuplexConnectionProfile() {
        DTProfileMask v = this.dataXPort.getDuplexProfileMask();
        return v != null ? v.getByteMask() : new byte[]{};
    }

    public void setDuplexConnectionProfile(byte[] profile) {
        DTProfileMask mask = new DTProfileMask(profile);
        mask.setLimitTimeInterval(this.getLimitTimeIntervalMinutes());
        this.dataXPort.setDuplexProfileMask(mask);
        this._addUpdateField("duplexProfileMask");
    }

    public long getLastDuplexConnectionTime() {
        return this.dataXPort.getLastDuplexConnectTime();
    }

    public void setLastDuplexConnectionTime(long time) {
        this.dataXPort.setLastDuplexConnectTime(time);
        this._addUpdateField("lastDuplexConnectTime");
    }

    public boolean supportsEncoding(int encoding) {
        int vi = this.dataXPort.getSupportedEncodings();
        return (vi & encoding) != 0;
    }

    public void removeEncoding(int encoding) {
        int vi = this.dataXPort.getSupportedEncodings();
        if ((vi & encoding) != 0) {
            this.dataXPort.setSupportedEncodings(vi &= ~encoding);
            this._addUpdateField("supportedEncodings");
        }
    }

    public boolean addClientPayloadTemplate(PayloadTemplate template) {
        return EventTemplate.SetPayloadTemplate(this.getAccountName(), this.getDeviceName(), template);
    }

    public PayloadTemplate getClientPayloadTemplate(int custType) {
        return EventTemplate.GetPayloadTemplate(this.getAccountName(), this.getDeviceName(), custType);
    }

    public CellTower ParseCellTower(int[] CT) {
        if (!ListTools.isEmpty(CT)) {
            int MCC = CT.length > 0 ? CT[0] : -1;
            int MNC = CT.length > 1 ? CT[1] : -1;
            int LAC = CT.length > 2 ? CT[2] : -1;
            int CID = CT.length > 3 ? CT[3] : -1;
            int TAV = CT.length > 4 ? CT[4] : -1;
            int RXL = CT.length > 5 ? CT[5] : -1;
            int ARF = CT.length > 6 ? CT[6] : -1;
            int RAT = CT.length > 7 ? CT[7] : -1;
            return new CellTower(RAT, MCC, MNC, TAV, CID, LAC, ARF, RXL);
        }
        return null;
    }

    public int insertEvent(DMTPGeoEvent geoEvent) {
        boolean didInsert;
        long timestamp = geoEvent.getTimestamp();
        int statusCode = geoEvent.getStatusCode();
        String accountID = this.getAccountName();
        String deviceID = this.getDeviceName();
        Device device = this.getDevice();
        EventData.Key evKey = new EventData.Key(accountID, deviceID, timestamp, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setFieldValue("dataSource", geoEvent.getDataSource());
        evdb.setFieldValue("rawData", geoEvent.getRawData());
        evdb.setFieldValue("latitude", geoEvent.getLatitude(0));
        evdb.setFieldValue("longitude", geoEvent.getLongitude(0));
        evdb.setFieldValue("gpsAge", geoEvent.getGpsAge());
        evdb.setFieldValue("horzAccuracy", geoEvent.getHorizontalAccuracy());
        evdb.setFieldValue("speedKPH", geoEvent.getSpeed());
        evdb.setFieldValue("heading", geoEvent.getHeading());
        evdb.setFieldValue("altitude", geoEvent.getAltitude());
        evdb.setFieldValue("geozoneIndex", geoEvent.getGeofence(0));
        double distanceKM = geoEvent.getDistance();
        double odometerKM = geoEvent.getOdometer();
        if (device != null) {
            if (odometerKM <= 0.0) {
                GeoPoint gp = geoEvent.getGeoPoint(0);
                odometerKM = ESTIMATE_ODOMETER && GeoPoint.isValid(gp) ? device.getNextOdometerKM(gp) : device.getLastOdometerKM();
            } else {
                odometerKM = device.adjustOdometerKM(odometerKM);
            }
        }
        double odomKM = odometerKM > 0.0 ? odometerKM : distanceKM;
        evdb.setFieldValue("distanceKM", distanceKM);
        evdb.setFieldValue("odometerKM", odomKM);
        evdb.setFieldValue("driverID", geoEvent.getEntity(1));
        evdb.setFieldValue("entityID", geoEvent.getEntity(0));
        evdb.setFieldValue("sensorLow", geoEvent.getSensorLow(0));
        evdb.setFieldValue("sensorHigh", geoEvent.getSensorHigh(0));
        evdb.setFieldValue("brakeGForce", geoEvent.getBrakeGForce());
        evdb.setFieldValue("thermoAverage0", geoEvent.getTemeratureAverage(0));
        evdb.setFieldValue("thermoAverage1", geoEvent.getTemeratureAverage(1));
        evdb.setFieldValue("thermoAverage2", geoEvent.getTemeratureAverage(2));
        evdb.setFieldValue("thermoAverage3", geoEvent.getTemeratureAverage(3));
        evdb.setFieldValue("thermoAverage4", geoEvent.getTemeratureAverage(4));
        evdb.setFieldValue("thermoAverage5", geoEvent.getTemeratureAverage(5));
        evdb.setFieldValue("thermoAverage6", geoEvent.getTemeratureAverage(6));
        evdb.setFieldValue("thermoAverage7", geoEvent.getTemeratureAverage(7));
        evdb.setFieldValue("fuelLevel", geoEvent.getObcFuelLevel());
        evdb.setFieldValue("fuelEconomy", geoEvent.getObcFuelEconomy());
        evdb.setFieldValue("fuelTotal", geoEvent.getObcFuelTotal());
        evdb.setFieldValue("fuelIdle", geoEvent.getObcFuelIdle());
        evdb.setFieldValue("engineRpm", geoEvent.getObcEngineRPM());
        evdb.setFieldValue("coolantLevel", geoEvent.getObcCoolantLevel());
        evdb.setFieldValue("coolantTemp", geoEvent.getObcCoolantTemperature());
        evdb.setFieldValue("oilPressure", geoEvent.getObcOilPressure());
        evdb.setFieldValue("j1708Fault", geoEvent.getObcJ1708Fault(0));
        CellTower cellTower_0 = this.ParseCellTower(geoEvent.getCellTower_0());
        if (cellTower_0 != null) {
            evdb.setServingCellTower(cellTower_0);
            evdb.setNeighborCellTower(0, this.ParseCellTower(geoEvent.getCellTower_1()));
            evdb.setNeighborCellTower(1, this.ParseCellTower(geoEvent.getCellTower_2()));
            evdb.setNeighborCellTower(2, this.ParseCellTower(geoEvent.getCellTower_3()));
        }
        if (!(didInsert = device.insertEventData(evdb))) {
            return 62529;
        }
        if (SIMEVENT_GEOZONES && evdb.isValidGeoPoint() && statusCode != 61968 && statusCode != 62000) {
            EventData prevEv = DCServerFactory.getPreviousEventData(device, timestamp);
            GeoPoint prevGP = prevEv != null && prevEv.isValidGeoPoint() ? prevEv.getGeoPoint() : null;
            Geozone prevZone = prevGP != null ? Geozone.getGeozone(accountID, null, prevGP, false) : null;
            GeoPoint thisGP = evdb.getGeoPoint();
            Geozone thisZone = Geozone.getGeozone(accountID, null, thisGP, false);
            long zoneFixtime = timestamp - 1L;
            if (prevZone == null && thisZone != null) {
                evdb.setTimestamp(zoneFixtime);
                evdb.setStatusCode(61968);
                device.insertEventData(evdb);
            } else if (prevZone != null && thisZone == null) {
                evdb.setTimestamp(zoneFixtime);
                evdb.setStatusCode(62000);
                device.insertEventData(evdb);
            }
        }
        this.saveChanges();
        return 0;
    }

    public void sessionStatistics(long startTime, String ipAddr, boolean isDuplex, long bytesRead, long bytesWritten, long evtsRecv) {
        this.getDevice().insertSessionStatistic(startTime, ipAddr, isDuplex, bytesRead, bytesWritten, evtsRecv);
    }

    public PacketList getPendingPackets() {
        return this.getPendingPackets(true);
    }

    public PacketList getPendingPackets(boolean allowAutoDelete) {
        long limit = 1L;
        try {
            String acctId = this.getAccountName();
            String devId = this.getDeviceName();
            PendingPacket[] pp = PendingPacket.getPendingPackets(acctId, devId, limit);
            if (pp != null && pp.length > 0) {
                try {
                    Packet[] p;
                    if (allowAutoDelete) {
                        for (int i = 0; i < pp.length; ++i) {
                            if (!pp[i].isAutoDelete()) continue;
                        }
                    }
                    if ((p = PendingPacket.extractPackets(pp)) != null && p.length > 0) {
                        long lastQueueTime = pp[pp.length - 1].getQueueTime();
                        PacketList plist = new PacketList(acctId, devId, p, lastQueueTime);
                        return plist;
                    }
                    return null;
                }
                catch (PacketParseException ppe) {
                    Print.logException("Unable to parse pending packets", ppe);
                    return null;
                }
            }
            return null;
        }
        catch (DBException dbe) {
            Print.logError("PendingPacket retrieval: " + dbe, new Object[0]);
            return null;
        }
    }

    public void clearPendingPackets(PacketList pktList) {
        if (pktList != null) {
            try {
                String accountID = pktList.getAccountName();
                String deviceID = pktList.getDeviceName();
                long lastQueueTime = pktList.getTimestamp();
                PendingPacket.deletePendingPackets(accountID, deviceID, lastQueueTime);
            }
            catch (DBException dbe) {
                Print.logError("PendingPacket delete: " + dbe, new Object[0]);
            }
        }
    }

    public int saveChanges() {
        try {
            if (this.devFields != null) {
                if (this.dataXPort == this.device) {
                    this.device.updateChangedEventFields(this.devFields);
                } else {
                    this.dataXPort.update(this.devFields);
                    this.device.updateChangedEventFields();
                }
            } else {
                this.device.updateChangedEventFields();
            }
            return 0;
        }
        catch (DBException dbe) {
            return 61491;
        }
    }

    public void handleError(int errCode, byte[] errData) {
        String ec = StringTools.toHexString(errCode, 16);
        String ed = StringTools.toHexString(errData);
        if (errCode == 62225) {
            Print.logError("Client Command Unsupported: 0x" + ec + " - " + ed, new Object[0]);
        } else if (errCode == 62241) {
            Payload ped = new Payload(errData);
            long propKey = ped.readULong(2, -1L);
            long cmdErr = ped.readULong(2, -1L);
            if (cmdErr == 0L) {
                Print.logError("Client Command OK: 0x" + ec + " - " + ed, new Object[0]);
            } else if (cmdErr == 1L) {
                Print.logError("Client Command ACK: 0x" + ec + " - " + ed, new Object[0]);
            } else {
                Print.logError("Client Command Error: 0x" + ec + " - " + ed, new Object[0]);
            }
        } else {
            Print.logError("Client Error: 0x" + ec + " - " + ed, new Object[0]);
        }
        try {
            Diagnostic.saveError(this.device, errCode, errData);
        }
        catch (DBException dbe) {
            Print.logException("Saving Property value", dbe);
        }
    }

    public void handleDiagnostic(int diagCode, byte[] diagData) {
        String dc = StringTools.toHexString(diagCode, 16);
        String dd = StringTools.toHexString(diagData);
        Print.logWarn("Client Diagnostic: 0x" + dc + " - " + dd, new Object[0]);
        try {
            Diagnostic.saveDiagnostic(this.device, diagCode, diagData);
        }
        catch (DBException dbe) {
            Print.logException("Saving Property value", dbe);
        }
    }

    public void handleProperty(int propKey, byte[] propVal) {
        PropertyKey pk = PropertyKey.GetPropertyKey(propKey);
        if (pk != null) {
            Print.logInfo("Client Property: " + pk.toString(propVal), new Object[0]);
        } else {
            String pkx = StringTools.toHexString(propKey, 16);
            String pvx = StringTools.toHexString(propVal);
            Print.logInfo("Client Property: 0x" + pkx + " - " + pvx, new Object[0]);
        }
        try {
            Property.saveProperty(this.device, propKey, propVal);
        }
        catch (DBException dbe) {
            Print.logException("Saving Property value", dbe);
        }
    }

    public String toString() {
        return this.device != null ? this.device.toString() : "";
    }
}

