/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.gtsdmtp;

import org.opendmtp.server.base.DMTPServer;
import org.opendmtp.server.db.AccountDB;
import org.opendmtp.server.db.DeviceDB;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Transport;
import org.opengts.dbtools.DBException;
import org.opengts.servers.gtsdmtp.AccountDBImpl;
import org.opengts.servers.gtsdmtp.DeviceDBImpl;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class DMTPDBFactory
implements DMTPServer.DBFactory {
    public static final String DEFAULT_UNIQUE_PREFIX = "gtc";

    public AccountDB getAccountDB(String acctName) {
        if (acctName != null) {
            try {
                Account acct = Account.getAccount(acctName);
                if (acct != null) {
                    return new AccountDBImpl(acct);
                }
                return new AccountDBImpl(acctName);
            }
            catch (DBException dbe) {
                dbe.printException();
            }
        }
        return null;
    }

    public DeviceDB getDeviceDB(AccountDB acctDB, String devName) {
        if (acctDB == null || StringTools.isBlank(devName)) {
            return null;
        }
        AccountDBImpl acctDBImpl = (AccountDBImpl)acctDB;
        Account account = acctDBImpl.getAccount();
        try {
            if (account != null) {
                Device dev = Transport.loadDeviceByTransportID(account, devName);
                if (dev != null) {
                    return new DeviceDBImpl(dev);
                }
                Print.logError("DeviceID not found: " + devName, new Object[0]);
                DCServerFactory.addUnassignedDevice("gtsdmtp", devName, null);
            } else {
                String prefixID = StringTools.blankDefault(acctDBImpl.getPrefixID(), DEFAULT_UNIQUE_PREFIX);
                String uniqueID = prefixID + "_" + devName;
                Device dev = Transport.loadDeviceByUniqueID(uniqueID);
                if (dev != null) {
                    acctDBImpl.setAccountName(dev.getAccountID());
                    return new DeviceDBImpl(dev);
                }
                Print.logError("UniqueID not found: " + uniqueID, new Object[0]);
                DCServerFactory.addUnassignedDevice("gtsdmtp", uniqueID, null);
            }
        }
        catch (DBException dbe) {
            dbe.printException();
        }
        return null;
    }

    public DeviceDB getDeviceDB(byte[] uniqId) {
        try {
            Device dev = Transport.loadDeviceByUniqueID(uniqId);
            if (dev != null) {
                return new DeviceDBImpl(dev);
            }
            String uniqueID = "0x" + StringTools.toHexString(uniqId);
            Print.logError("UniqueID not found: " + uniqueID, new Object[0]);
            DCServerFactory.addUnassignedDevice("gtsdmtp", uniqueID, null);
        }
        catch (DBException dbe) {
            dbe.printException();
        }
        return null;
    }
}

