/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.geocoder.tinygeocoder;

import org.opengts.geocoder.GeocodeProvider;
import org.opengts.geocoder.ReverseGeocode;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.geocoder.ReverseGeocodeProviderAdapter;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;

public class TinyGeocoder
extends ReverseGeocodeProviderAdapter
implements ReverseGeocodeProvider,
GeocodeProvider {
    protected static String HOST_PRIMARY = "tinygeocoder.com";
    protected static final String PROP_hostName = "host";
    protected static final int TIMEOUT_ReverseGeocode = 2500;
    protected static final int TIMEOUT_Geocode = 5000;
    protected static final String ENCODING_UTF8 = "UTF-8";

    private static String _getPageResponse(String url, int timeoutMS) {
        String response = null;
        try {
            Print.logInfo((String)("URL: " + url), (Object[])new Object[0]);
            byte[] respB = HTMLTools.readPage_GET((String)url, (int)timeoutMS);
            if (respB != null && respB.length > 0) {
                response = StringTools.toStringValue((byte[])respB).trim();
                Print.logInfo((String)("Response: " + response), (Object[])new Object[0]);
                if (StringTools.isBlank((String)response)) {
                    response = null;
                } else if (response.startsWith("620 :")) {
                    response = null;
                }
            }
        }
        catch (Throwable th) {
            response = null;
        }
        return response;
    }

    public TinyGeocoder(String name, String key, RTProperties rtProps) {
        super(name, null, rtProps);
    }

    @Override
    public boolean isFastOperation() {
        String host = this.getHostname();
        if (host.startsWith("localhost") || host.startsWith("127.0.0.1")) {
            return true;
        }
        return super.isFastOperation();
    }

    protected String getHostname() {
        RTProperties rtp = this.getProperties();
        String host = rtp.getString(PROP_hostName, HOST_PRIMARY);
        if (StringTools.isBlank((String)host) || host.equalsIgnoreCase("default")) {
            return HOST_PRIMARY;
        }
        return host;
    }

    protected int getReverseGeocodeTimeout() {
        return 2500;
    }

    @Override
    public ReverseGeocode getReverseGeocode(GeoPoint gp, String localStr, boolean cache) {
        if (gp == null) {
            return null;
        }
        String address = this._getReverseGeocode(gp, this.getReverseGeocodeTimeout());
        if (!StringTools.isBlank((String)address)) {
            ReverseGeocode rg = new ReverseGeocode();
            rg.setFullAddress(address);
            return rg;
        }
        return null;
    }

    private String _getReverseGeocodeURL(GeoPoint gp) {
        if (gp != null && gp.isValid()) {
            StringBuffer url = new StringBuffer();
            url.append("http://").append(this.getHostname()).append("/create-api.php?");
            url.append("g=").append(gp.toString(','));
            return url.toString();
        }
        return null;
    }

    private String _getReverseGeocode(GeoPoint gp, int timeoutMS) {
        String url = this._getReverseGeocodeURL(gp);
        if (StringTools.isBlank((String)url)) {
            return null;
        }
        String result = TinyGeocoder._getPageResponse(url, timeoutMS);
        if (StringTools.isBlank((String)result)) {
            return "";
        }
        return result.trim();
    }

    protected int getGeocodeTimeout() {
        return 5000;
    }

    @Override
    public GeoPoint getGeocode(String address, String country) {
        if (StringTools.isBlank((String)address)) {
            return null;
        }
        return this._getGeocode(address, this.getGeocodeTimeout());
    }

    private String _getGeocodeURL(String address) {
        if (!StringTools.isBlank((String)address)) {
            StringBuffer url = new StringBuffer();
            url.append("http://").append(this.getHostname()).append("/create-api.php?");
            url.append("q=");
            URIArg.encodeArg((StringBuffer)url, (String)address);
            return url.toString();
        }
        return null;
    }

    private GeoPoint _getGeocode(String address, int timeoutMS) {
        String url = this._getGeocodeURL(address);
        if (StringTools.isBlank((String)url)) {
            return null;
        }
        String result = TinyGeocoder._getPageResponse(url, timeoutMS);
        if (StringTools.isBlank((String)result)) {
            return null;
        }
        GeoPoint gp = new GeoPoint(result.trim(), ',');
        return gp.isValid() ? gp : null;
    }

    public static void main(String[] argv) {
        String host;
        GeoPoint gp;
        RTConfig.setCommandLineArgs((String[])argv);
        Print.setAllOutputToStdout((boolean)true);
        Print.setEncoding((String)ENCODING_UTF8);
        TinyGeocoder tg = new TinyGeocoder("tinygeocoder", null, RTConfig.getCommandLineProperties());
        if (RTConfig.hasProperty((String)"geocode")) {
            String address = RTConfig.getString((String)"geocode", null);
            gp = tg.getGeocode(address, "US");
            Print.sysPrintln((String)("Location " + gp), (Object[])new Object[0]);
            System.exit(0);
        }
        if (!StringTools.isBlank((String)(host = RTConfig.getString((String)PROP_hostName, null)))) {
            HOST_PRIMARY = host;
        }
        if (!(gp = new GeoPoint(RTConfig.getString((String)"gp", null))).isValid()) {
            Print.logInfo((String)"Invalid GeoPoint specified", (Object[])new Object[0]);
            System.exit(1);
        }
        Print.logInfo((String)("Reverse-Geocoding GeoPoint: " + gp), (Object[])new Object[0]);
        Print.sysPrintln((String)("RevGeocode = " + tg.getReverseGeocode(gp, null, false)), (Object[])new Object[0]);
    }
}

