/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.geocoder.nominatim;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengts.geocoder.ReverseGeocode;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.geocoder.ReverseGeocodeProviderAdapter;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Nominatim
extends ReverseGeocodeProviderAdapter
implements ReverseGeocodeProvider {
    protected static final String TAG_reversegeocode = "reversegeocode";
    protected static final String TAG_result = "result";
    protected static final String TAG_addressparts = "addressparts";
    protected static final String TAG_house = "house";
    protected static final String TAG_tram = "tram";
    protected static final String TAG_road = "road";
    protected static final String TAG_residential = "residential";
    protected static final String TAG_village = "village";
    protected static final String TAG_town = "town";
    protected static final String TAG_city = "city";
    protected static final String TAG_county = "county";
    protected static final String TAG_postcode = "postcode";
    protected static final String TAG_hamlet = "hamlet";
    protected static final String TAG_suburb = "suburb";
    protected static final String TAG_state = "state";
    protected static final String TAG_state_district = "state_district";
    protected static final String TAG_country = "country";
    protected static final String TAG_country_code = "country_code";
    protected static final String ATTR_osm_type = "osm_type";
    protected static final String PROP_reverseURL = "reverseURL";
    protected static final String PROP_hostName = "host";
    protected static final String PROP_zoom = "zoom";
    protected static final String PROP_addressdetails = "addressdetails";
    protected static final String PROP_email = "email";
    protected static String HOST_OPENSTREETMAP = "nominatim.openstreetmap.org";
    protected static String HOST_MAPQUEST;
    protected static String HOST_PRIMARY;
    protected static final String ENCODING_UTF8 = "UTF-8";

    public Nominatim(String name, String key, RTProperties rtProps) {
        super(name, key, rtProps);
    }

    @Override
    public boolean isFastOperation() {
        return super.isFastOperation();
    }

    @Override
    public ReverseGeocode getReverseGeocode(GeoPoint gp, String localeStr, boolean cache) {
        ReverseGeocode rg = this.getAddressReverseGeocode(gp, localeStr, cache);
        return rg;
    }

    public String getSubdivision(GeoPoint gp) {
        throw new UnsupportedOperationException("Not supported");
    }

    private ReverseGeocode getAddressReverseGeocode(GeoPoint gp, String localeStr, boolean cache) {
        NodeList addresspartsList;
        int a;
        String url = this.getAddressReverseGeocodeURL(gp, localeStr);
        Print.logInfo((String)("Address URL: " + url), (Object[])new Object[0]);
        Document xmlDoc = this.GetXMLDocument(url);
        if (xmlDoc == null) {
            return null;
        }
        Element reversegeocode = xmlDoc.getDocumentElement();
        if (!reversegeocode.getTagName().equalsIgnoreCase(TAG_reversegeocode)) {
            return null;
        }
        String address_val = null;
        String house_val = null;
        String road_val = null;
        String city_val = null;
        String county_val = null;
        String suburb_val = null;
        String state_val = null;
        String postcode_val = null;
        String hamlet_val = null;
        String country_name_val = null;
        String country_code_val = null;
        int r = 0;
        NodeList resultList = XMLTools.getChildElements((Node)reversegeocode, (String)TAG_result);
        if (r < resultList.getLength()) {
            Element result = (Element)resultList.item(r);
            address_val = XMLTools.getNodeText((Node)result, (String)" ", (boolean)false);
        }
        if ((a = 0) < (addresspartsList = XMLTools.getChildElements((Node)reversegeocode, (String)TAG_addressparts)).getLength()) {
            Element addressparts = (Element)addresspartsList.item(a);
            NodeList addresspartsChildren = addressparts.getChildNodes();
            for (int ac = 0; ac < addresspartsChildren.getLength(); ++ac) {
                Node child = addresspartsChildren.item(ac);
                if (!(child instanceof Element)) continue;
                Element elem = (Element)child;
                String elemName = elem.getNodeName();
                if (elemName.equalsIgnoreCase(TAG_house)) {
                    house_val = XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false);
                    continue;
                }
                if (elemName.equalsIgnoreCase(TAG_tram)) continue;
                if (elemName.equalsIgnoreCase(TAG_road)) {
                    road_val = XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false);
                    continue;
                }
                if (elemName.equalsIgnoreCase(TAG_residential) || elemName.equalsIgnoreCase(TAG_village)) continue;
                if (elemName.equalsIgnoreCase(TAG_town)) {
                    if (!StringTools.isBlank(city_val)) continue;
                    city_val = XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false);
                    continue;
                }
                if (elemName.equalsIgnoreCase(TAG_city)) {
                    city_val = XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false);
                    continue;
                }
                if (elemName.equalsIgnoreCase(TAG_county)) {
                    county_val = XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false);
                    continue;
                }
                if (elemName.equalsIgnoreCase(TAG_postcode)) {
                    postcode_val = XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false);
                    continue;
                }
                if (elemName.equalsIgnoreCase(TAG_hamlet)) {
                    hamlet_val = XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false);
                    continue;
                }
                if (elemName.equalsIgnoreCase(TAG_suburb)) {
                    suburb_val = XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false);
                    continue;
                }
                if (elemName.equalsIgnoreCase(TAG_state)) {
                    state_val = XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false);
                    continue;
                }
                if (elemName.equalsIgnoreCase(TAG_country)) {
                    country_name_val = XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false);
                    continue;
                }
                if (!elemName.equalsIgnoreCase(TAG_country_code)) continue;
                country_code_val = StringTools.trim((String)XMLTools.getNodeText((Node)elem, (String)" ", (boolean)false)).toUpperCase();
            }
        }
        ReverseGeocode rg = new ReverseGeocode();
        StringBuffer addr = new StringBuffer();
        if (!StringTools.isBlank(house_val)) {
            addr.append(house_val);
            if (!StringTools.isBlank(road_val)) {
                addr.append(" ");
                addr.append(road_val);
                rg.setStreetAddress(house_val + " " + road_val);
            } else {
                rg.setStreetAddress(house_val);
            }
        } else if (!StringTools.isBlank(road_val)) {
            addr.append(road_val);
            rg.setStreetAddress(road_val);
        }
        if (!StringTools.isBlank(suburb_val)) {
            if (addr.length() > 0) {
                addr.append(", ");
            }
            addr.append(suburb_val);
        }
        if (!StringTools.isBlank(city_val)) {
            if (addr.length() > 0) {
                addr.append(", ");
            }
            addr.append(city_val);
            rg.setCity(city_val);
        }
        if (!StringTools.isBlank(county_val) && StringTools.isBlank(city_val)) {
            if (addr.length() > 0) {
                addr.append(", ");
            }
            addr.append("[").append(county_val).append("]");
        }
        if (!StringTools.isBlank(state_val)) {
            if (addr.length() > 0) {
                addr.append(", ");
            }
            addr.append(state_val);
            rg.setStateProvince(state_val);
            if (!StringTools.isBlank(postcode_val)) {
                addr.append(" ").append(postcode_val);
                rg.setPostalCode(postcode_val);
            }
        } else if (!StringTools.isBlank(postcode_val)) {
            if (addr.length() > 0) {
                addr.append(", ");
            }
            addr.append(postcode_val);
            rg.setPostalCode(postcode_val);
        }
        if (!StringTools.isBlank(country_code_val)) {
            if (!country_code_val.equalsIgnoreCase("US")) {
                if (!StringTools.isBlank(country_name_val)) {
                    if (addr.length() > 0) {
                        addr.append(", ");
                    }
                    addr.append(country_name_val);
                } else {
                    if (addr.length() > 0) {
                        addr.append(", ");
                    }
                    addr.append(country_code_val);
                }
            }
            rg.setCountryCode(country_code_val);
        }
        rg.setFullAddress(addr.toString());
        return rg;
    }

    private String getEmail() {
        return this.getProperties().getString(PROP_email, null);
    }

    private String getAddressReverseGeocodeURL(GeoPoint gp, String localeStr) {
        StringBuffer sb = new StringBuffer();
        RTProperties rtp = this.getProperties();
        String url = rtp.getString(PROP_reverseURL, null);
        if (!StringTools.isBlank((String)url)) {
            sb.append(url);
        } else {
            String host = rtp.getString(PROP_hostName, HOST_PRIMARY);
            sb.append("http://");
            sb.append(host);
            if (host.indexOf("mapquest") >= 0) {
                sb.append("/nominatim/v1/reverse?");
            } else {
                sb.append("/reverse?");
            }
        }
        sb.append("format=xml&");
        sb.append("limit=1&");
        if (!StringTools.isBlank((String)localeStr)) {
            sb.append("accept-language=").append(localeStr).append("&");
        }
        sb.append("addressdetails=").append(rtp.getString(PROP_addressdetails, "1")).append("&");
        sb.append("zoom=").append(rtp.getString(PROP_zoom, "18")).append("&");
        sb.append("email=").append(this.getEmail()).append("&");
        sb.append("lat=").append(gp.getLatitudeString("5", null)).append("&");
        sb.append("lon=").append(gp.getLongitudeString("5", null));
        return sb.toString();
    }

    private Document GetXMLDocument(String url) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            HTMLTools.HttpBufferedInputStream input = HTMLTools.inputStream_GET((String)url, (int)5000);
            InputStreamReader reader = new InputStreamReader((InputStream)input, ENCODING_UTF8);
            InputSource inSrc = new InputSource(reader);
            inSrc.setEncoding(ENCODING_UTF8);
            return db.parse(inSrc);
        }
        catch (ParserConfigurationException pce) {
            Print.logError((String)("Parse error: " + pce), (Object[])new Object[0]);
            return null;
        }
        catch (SAXException se) {
            Print.logError((String)("Parse error: " + se), (Object[])new Object[0]);
            return null;
        }
        catch (IOException ioe) {
            Print.logError((String)("IO error: " + ioe), (Object[])new Object[0]);
            return null;
        }
    }

    public static void main(String[] argv) {
        GeoPoint gp;
        RTConfig.setCommandLineArgs((String[])argv);
        Print.setAllOutputToStdout((boolean)true);
        Print.setEncoding((String)ENCODING_UTF8);
        String host = RTConfig.getString((String)PROP_hostName, null);
        if (!StringTools.isBlank((String)host)) {
            HOST_PRIMARY = host;
        }
        if (!(gp = new GeoPoint(RTConfig.getString((String)"gp", null))).isValid()) {
            Print.logInfo((String)"Invalid GeoPoint specified", (Object[])new Object[0]);
            System.exit(1);
        }
        Print.logInfo((String)("Reverse-Geocoding GeoPoint: " + gp), (Object[])new Object[0]);
        Nominatim gn = new Nominatim("nominatim", null, RTConfig.getCommandLineProperties());
        Print.sysPrintln((String)("RevGeocode = " + gn.getReverseGeocode(gp, null, false)), (Object[])new Object[0]);
    }

    static {
        HOST_PRIMARY = HOST_MAPQUEST = "open.mapquestapi.com";
    }
}

