/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.geocoder.google;

import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.opengts.util.Base64;
import org.opengts.util.MACProvider;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class GoogleSig {
    private static final String ARG_SIGNATURE_ = "&signature=";
    private static final String HMACSHA1 = "HmacSHA1";
    private static MACProvider macProvider = null;
    private Object keyMac = null;

    public static void SetMACProvider(MACProvider mp) {
        macProvider = mp;
    }

    public GoogleSig(String keyStr) {
        if (!StringTools.isBlank((String)keyStr)) {
            if (macProvider != null) {
                this.keyMac = macProvider.getMAC(keyStr, HMACSHA1);
            } else {
                try {
                    BigInteger seed = null;
                    byte[] kb = Base64.decode((String)keyStr.replace('-', '+').replace('_', '/'), seed);
                    Mac mac = Mac.getInstance(HMACSHA1);
                    mac.init(new SecretKeySpec(kb, HMACSHA1));
                    this.keyMac = mac;
                }
                catch (NoSuchAlgorithmException nsae) {
                    this.keyMac = null;
                }
                catch (InvalidKeyException ike) {
                    this.keyMac = null;
                }
                catch (Throwable th) {
                    this.keyMac = null;
                }
            }
        }
    }

    public String signURL(String urlStr) {
        String sigURL = urlStr;
        if (this.keyMac != null) {
            Mac mac = (Mac)this.keyMac;
            try {
                URL url = new URL(sigURL);
                String urlS = url.getPath() + "?" + url.getQuery();
                byte[] pqb = mac.doFinal(urlS.getBytes());
                String sig = Base64.encode((byte[])pqb, (char[])Base64.Base64HttpAlpha);
                sigURL = sigURL + ARG_SIGNATURE_ + sig;
            }
            catch (MalformedURLException mue) {
                sigURL = null;
            }
            catch (Throwable th) {
                sigURL = null;
            }
        }
        return sigURL;
    }

    public boolean validateURL(String urlStr) {
        if (urlStr == null) {
            Print.logError((String)"URL is null", (Object[])new Object[0]);
        } else if (this.keyMac == null) {
            Print.logError((String)"Mac is null", (Object[])new Object[0]);
        } else {
            int sigP;
            Mac mac = (Mac)this.keyMac;
            int ss = urlStr.indexOf("//");
            int pathP = ss >= 0 ? urlStr.indexOf("/", ss + 2) : -1;
            String pathS = pathP > 0 ? urlStr.substring(pathP) : null;
            int n = sigP = pathS != null ? pathS.indexOf(ARG_SIGNATURE_) : -1;
            if (sigP > 0) {
                String urlSigS = pathS.substring(sigP + ARG_SIGNATURE_.length());
                pathS = pathS.substring(0, sigP);
                try {
                    byte[] actSigB = mac.doFinal(pathS.getBytes());
                    String actSigS = Base64.encode((byte[])actSigB, (char[])Base64.Base64HttpAlpha);
                    if (actSigS.equals(urlSigS)) {
                        return true;
                    }
                    Print.logInfo((String)("Expected Sig: " + actSigS), (Object[])new Object[0]);
                    return false;
                }
                catch (Throwable th) {
                    Print.logError((String)("Unexpected Error: " + th), (Object[])new Object[0]);
                }
            } else {
                Print.logError((String)("'&signature=' not found" + urlStr), (Object[])new Object[0]);
            }
        }
        return false;
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        if (RTConfig.hasProperty((String)"url")) {
            String urlStr = RTConfig.getString((String)"url", null);
            String keyStr = RTConfig.getString((String)"key", null);
            if (StringTools.isBlank((String)urlStr) || StringTools.isBlank((String)keyStr)) {
                Print.sysPrintln((String)"ERROR: Missing url or key", (Object[])new Object[0]);
                System.exit(99);
            }
            GoogleSig gs = new GoogleSig(keyStr);
            String sigURL = gs.signURL(urlStr);
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            Print.sysPrintln((String)sigURL, (Object[])new Object[0]);
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            Print.sysPrintln((String)("Validated: " + gs.validateURL(sigURL)), (Object[])new Object[0]);
            System.exit(0);
        }
    }
}

