/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.geocoder.google;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.opengts.db.DBConfig;
import org.opengts.geocoder.GeocodeProvider;
import org.opengts.geocoder.ReverseGeocode;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.geocoder.ReverseGeocodeProviderAdapter;
import org.opengts.geocoder.google.GoogleSig;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.JSON;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;

public class GoogleGeocodeV3
extends ReverseGeocodeProviderAdapter
implements ReverseGeocodeProvider,
GeocodeProvider {
    protected static final String TAG_results = "results";
    protected static final String TAG_status = "status";
    protected static final String TAG_address_components = "address_components";
    protected static final String TAG_long_name = "long_name";
    protected static final String TAG_short_name = "short_name";
    protected static final String TAG_types = "types";
    protected static final String TAG_formatted_address = "formatted_address";
    protected static final String TAG_geometry = "geometry";
    protected static final String TAG_bounds = "bounds";
    protected static final String TAG_northeast = "northeast";
    protected static final String TAG_southwest = "southwest";
    protected static final String TAG_lat = "lat";
    protected static final String TAG_lng = "lng";
    protected static final String TAG_location = "location";
    protected static final String TAG_location_type = "location_type";
    protected static final String TAG_viewport = "viewport";
    protected static final String URL_ReverseGeocode_ = "http://maps.googleapis.com/maps/api/geocode/json?";
    protected static final String URL_Geocode_ = "http://maps.googleapis.com/maps/api/geocode/json?";
    protected static final String PROP_reverseGeocodeURL = "reverseGeocodeURL";
    protected static final String PROP_geocodeURL = "geocodeURL";
    protected static final String PROP_sensor = "sensor";
    protected static final String PROP_channel = "channel";
    protected static final String PROP_countryCodeBias = "countryCodeBias";
    protected static final String PROP_signatureKey = "signatureKey";
    protected static final int TIMEOUT_ReverseGeocode = 2500;
    protected static final int TIMEOUT_Geocode = 5000;
    protected static final String DEFAULT_COUNTRY = "US";
    protected static final String CLIENT_ID_PREFIX = "gme-";
    protected static final String EMPTY_ADDRESS = "?";
    protected static final String STATUS_OK = "OK";
    protected static final String STATUS_ZERO_RESULTS = "ZERO_RESULTS";
    protected static final String STATUS_OVER_QUERY_LIMIT = "OVER_QUERY_LIMIT";
    protected static final String STATUS_LIMIT_EXCEEDED = "620";
    protected static final String STATUS_REQUEST_DENIED = "REQUEST_DENIED";
    protected static final String STATUS_INVALID_REQUEST = "INVALID_REQUEST";
    protected static final String STATUS_FORBIDDEN_403 = "403";
    protected static final String STATUS_NOT_FOUND_404 = "404";
    protected static final JSON JSON_LIMIT_EXCEEDED = GoogleGeocodeV3.JSONStatus("620");
    protected static final JSON JSON_FORBIDDEN_403 = GoogleGeocodeV3.JSONStatus("403");
    protected static final JSON JSON_NOT_FOUND_404 = GoogleGeocodeV3.JSONStatus("404");
    protected static final boolean FAILOVER_DEBUG = false;
    protected static final double MAX_ADDRESS_DISTANCE_KM = 1.1;
    protected static final String ENCODING_UTF8 = "UTF-8";
    private boolean signature_init = false;
    private GoogleSig signature = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "a"};
    private static final String[] ARG_GEOCODE = new String[]{"geocode", "gc"};
    private static final String[] ARG_REVGEOCODE = new String[]{"revgeo", "rg"};

    private static JSON JSONStatus(String status) {
        StringBuffer J = new StringBuffer();
        J.append("{ ");
        J.append("\"").append(TAG_status).append("\" : \"").append(status).append("\"");
        J.append(" }");
        String j = J.toString();
        try {
            return new JSON(j);
        }
        catch (JSON.JSONParsingException jpe) {
            Print.logError((String)("Invalid JSON: " + J), (Object[])new Object[0]);
            return null;
        }
    }

    public GoogleGeocodeV3(String name, String key, RTProperties rtProps) {
        super(name, key, rtProps);
    }

    @Override
    public boolean isFastOperation() {
        return super.isFastOperation();
    }

    public GoogleSig getSignature() {
        if (!this.signature_init) {
            this.signature_init = true;
            String key = this.getAuthorization();
            if (!StringTools.isBlank((String)key) && key.startsWith(CLIENT_ID_PREFIX)) {
                String sigKey = this.getProperties().getString(PROP_signatureKey, "");
                if (!StringTools.isBlank((String)sigKey)) {
                    this.signature = new GoogleSig(sigKey);
                } else {
                    Print.logWarn((String)"No signatureKey ...", (Object[])new Object[0]);
                }
            }
        }
        return this.signature;
    }

    protected int getGeocodeTimeout() {
        return 5000;
    }

    protected int getReverseGeocodeTimeout() {
        return 2500;
    }

    @Override
    public ReverseGeocode getReverseGeocode(GeoPoint gp, String localeStr, boolean cache) {
        ReverseGeocode rg = this.getAddressReverseGeocode(gp, localeStr, cache);
        return rg;
    }

    protected String getAddressReverseGeocodeURI() {
        return "http://maps.googleapis.com/maps/api/geocode/json?";
    }

    protected String getAddressReverseGeocodeURL(GeoPoint gp, String localeStr) {
        String sensor;
        StringBuffer sb = new StringBuffer();
        GoogleSig sig = this.getSignature();
        String rgURL = this.getProperties().getString(PROP_reverseGeocodeURL, null);
        if (!StringTools.isBlank((String)rgURL)) {
            sb.append(rgURL);
            sb.append("&latlng=");
            if (gp != null) {
                sb.append(gp.getLatitudeString("5", null)).append(",").append(gp.getLongitudeString("5", null));
            }
            String defURL = sb.toString();
            if (sig == null) {
                return defURL;
            }
            String urlStr = sig.signURL(defURL);
            return urlStr != null ? urlStr : defURL;
        }
        sb.append(this.getAddressReverseGeocodeURI());
        sb.append("oe=utf8");
        sb.append("&latlng=");
        if (gp != null) {
            sb.append(gp.getLatitudeString("5", null)).append(",").append(gp.getLongitudeString("5", null));
        }
        if (!StringTools.isBlank((String)(sensor = this.getProperties().getString(PROP_sensor, null)))) {
            sb.append("&sensor=").append(sensor);
        }
        String channel = this.getProperties().getString(PROP_channel, null);
        String auth = this.getAuthorization();
        if (!StringTools.isBlank((String)auth) && !auth.startsWith("*")) {
            if (auth.startsWith(CLIENT_ID_PREFIX)) {
                sb.append("&client=").append(auth);
                if (StringTools.isBlank((String)channel)) {
                    channel = DBConfig.getServiceAccountID(null);
                }
            } else {
                sb.append("&key=").append(auth);
            }
        }
        if (!StringTools.isBlank((String)channel)) {
            sb.append("&channel=").append(channel);
        }
        if (!StringTools.isBlank((String)localeStr)) {
            sb.append("&language=").append(localeStr);
        }
        String defURL = sb.toString();
        if (sig == null) {
            return defURL;
        }
        String urlStr = sig.signURL(defURL);
        return urlStr != null ? urlStr : defURL;
    }

    public ReverseGeocode getAddressReverseGeocode(GeoPoint gp, String localeStr, boolean cache) {
        ReverseGeocode rg;
        if (this.isReverseGeocodeFailoverMode()) {
            ReverseGeocodeProvider frgp = this.getFailoverReverseGeocodeProvider();
            return frgp.getReverseGeocode(gp, localeStr, cache);
        }
        String url = this.getAddressReverseGeocodeURL(gp, localeStr);
        Print.logInfo((String)("Google RG URL: " + url), (Object[])new Object[0]);
        JSON jsonDoc = null;
        JSON._Object jsonObj = null;
        try {
            jsonDoc = GoogleGeocodeV3.GetJSONDocument(url, this.getReverseGeocodeTimeout());
            JSON._Object _Object2 = jsonObj = jsonDoc != null ? jsonDoc.getObject() : null;
            if (jsonObj == null) {
                return null;
            }
        }
        catch (Throwable th) {
            Print.logException((String)"Error", (Throwable)th);
        }
        String status = jsonObj.getStringForName(TAG_status, "");
        if (!status.equalsIgnoreCase(STATUS_OK) && !status.equalsIgnoreCase(STATUS_ZERO_RESULTS)) {
            Print.logDebug((String)("Status : " + status), (Object[])new Object[0]);
        }
        String address = null;
        JSON._Array results = jsonObj.getArrayForName(TAG_results, null);
        if (!ListTools.isEmpty((Collection)results)) {
            JSON._Object addr;
            JSON._Value val0 = results.getValueAt(0);
            JSON._Object _Object3 = addr = val0 != null ? val0.getObjectValue(null) : null;
            if (addr != null) {
                address = addr.getStringForName(TAG_formatted_address, null);
                Print.logDebug((String)("Address: " + address), (Object[])new Object[0]);
            }
        } else if (status.equalsIgnoreCase(STATUS_ZERO_RESULTS)) {
            Print.logInfo((String)"No address available", (Object[])new Object[0]);
        }
        if (!StringTools.isBlank(address)) {
            rg = new ReverseGeocode();
            rg.setFullAddress(address);
            return rg;
        }
        if (status.equalsIgnoreCase(STATUS_OK) || status.equalsIgnoreCase(STATUS_ZERO_RESULTS)) {
            rg = new ReverseGeocode();
            rg.setFullAddress(EMPTY_ADDRESS);
            return rg;
        }
        boolean failover = false;
        long failoverTimeoutSec = -1L;
        if (status.equals(STATUS_OVER_QUERY_LIMIT)) {
            Print.logError((String)("Google Reverse-Geocode Over Query Limit! [" + status + "]"), (Object[])new Object[0]);
            failover = true;
            failoverTimeoutSec = 5L;
        } else if (status.equals(STATUS_LIMIT_EXCEEDED)) {
            Print.logError((String)("Google Reverse-Geocode Limit Exceeded! [" + status + "]"), (Object[])new Object[0]);
            failover = true;
            failoverTimeoutSec = -1L;
        } else if (status.equals(STATUS_REQUEST_DENIED)) {
            Print.logError((String)("Google Reverse-Geocode Request Denied! [" + status + "]"), (Object[])new Object[0]);
            failover = true;
            failoverTimeoutSec = -1L;
        } else if (status.equals(STATUS_INVALID_REQUEST)) {
            Print.logError((String)("Google Reverse-Geocode Invalid Request! [" + status + "]"), (Object[])new Object[0]);
            failover = true;
            failoverTimeoutSec = -1L;
        } else {
            Print.logError((String)("Google Reverse-Geocode Error! [" + status + "]"), (Object[])new Object[0]);
            failover = true;
            failoverTimeoutSec = -1L;
        }
        if (failover && this.hasFailoverReverseGeocodeProvider()) {
            this.startReverseGeocodeFailoverMode(failoverTimeoutSec);
            ReverseGeocodeProvider frgp = this.getFailoverReverseGeocodeProvider();
            Print.logWarn((String)("Failing over to '" + frgp.getName() + "'"), (Object[])new Object[0]);
            return frgp.getReverseGeocode(gp, localeStr, cache);
        }
        return null;
    }

    protected String getGeoPointGeocodeURI() {
        return "http://maps.googleapis.com/maps/api/geocode/json?";
    }

    protected String getGeoPointGeocodeURL(String address, String country) {
        String auth;
        String channel;
        String sensor;
        String gcURL;
        StringBuffer sb = new StringBuffer();
        GoogleSig sig = this.getSignature();
        if (StringTools.isBlank((String)country)) {
            country = this.getProperties().getString(PROP_countryCodeBias, DEFAULT_COUNTRY);
        }
        if (!StringTools.isBlank((String)(gcURL = this.getProperties().getString(PROP_geocodeURL, null)))) {
            sb.append(gcURL);
            sb.append("&address=").append(URIArg.encodeArg((String)address));
            if (!StringTools.isBlank((String)country)) {
                sb.append("&region=").append(country);
            }
            String defURL = sb.toString();
            if (sig == null) {
                return defURL;
            }
            String urlStr = sig.signURL(defURL);
            return urlStr != null ? urlStr : defURL;
        }
        sb.append(this.getGeoPointGeocodeURI());
        sb.append("oe=utf8");
        sb.append("&address=").append(URIArg.encodeArg((String)address));
        if (!StringTools.isBlank((String)country)) {
            sb.append("&region=").append(country);
        }
        if (!StringTools.isBlank((String)(sensor = this.getProperties().getString(PROP_sensor, null)))) {
            sb.append("&sensor=").append(sensor);
        }
        if (!StringTools.isBlank((String)(channel = this.getProperties().getString(PROP_channel, null)))) {
            sb.append("&channel=").append(channel);
        }
        if (!StringTools.isBlank((String)(auth = this.getAuthorization())) && !auth.startsWith("*")) {
            if (auth.startsWith(CLIENT_ID_PREFIX)) {
                sb.append("&client=").append(auth);
            } else {
                sb.append("&key=").append(auth);
            }
        }
        String defURL = sb.toString();
        if (sig == null) {
            return defURL;
        }
        String urlStr = sig.signURL(defURL);
        return urlStr != null ? urlStr : defURL;
    }

    @Override
    public GeoPoint getGeocode(String address, String country) {
        JSON._Object jsonObj;
        String url = this.getGeoPointGeocodeURL(address, country);
        Print.logDebug((String)("Google GC URL: " + url), (Object[])new Object[0]);
        JSON jsonDoc = GoogleGeocodeV3.GetJSONDocument(url, this.getReverseGeocodeTimeout());
        JSON._Object _Object2 = jsonObj = jsonDoc != null ? jsonDoc.getObject() : null;
        if (jsonObj == null) {
            return null;
        }
        String status = jsonObj.getStringForName(TAG_status, null);
        Print.logInfo((String)("Status : " + status), (Object[])new Object[0]);
        GeoPoint geoPoint = null;
        JSON._Array results = jsonObj.getArrayForName(TAG_results, null);
        if (!ListTools.isEmpty((Collection)results)) {
            double lng;
            double lat;
            JSON._Object location;
            JSON._Value val0 = results.getValueAt(0);
            JSON._Object obj0 = val0.getObjectValue(null);
            JSON._Object geometry = obj0.getObjectForName(TAG_geometry, null);
            JSON._Object _Object3 = location = geometry != null ? geometry.getObjectForName(TAG_location, null) : null;
            if (location != null && GeoPoint.isValid((double)(lat = location.getDoubleForName(TAG_lat, 0.0)), (double)(lng = location.getDoubleForName(TAG_lng, 0.0)))) {
                geoPoint = new GeoPoint(lat, lng);
                Print.logInfo((String)("GeoPoint: " + geoPoint), (Object[])new Object[0]);
            }
        } else {
            Print.logInfo((String)"No location found: null", (Object[])new Object[0]);
        }
        if (geoPoint != null) {
            return geoPoint;
        }
        if (status != null && status.equals(STATUS_LIMIT_EXCEEDED)) {
            Print.logError((String)"!!!! Google Reverse-Geocode Limit Exceeded !!!!", (Object[])new Object[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JSON GetJSONDocument(String url, int timeoutMS) {
        JSON jsonDoc = null;
        HTMLTools.HttpBufferedInputStream input = null;
        try {
            input = HTMLTools.inputStream_GET((String)url, (int)timeoutMS);
            jsonDoc = new JSON((InputStream)input);
        }
        catch (JSON.JSONParsingException jpe) {
            Print.logError((String)("JSON parse error: " + (Object)((Object)jpe)), (Object[])new Object[0]);
        }
        catch (HTMLTools.HttpIOException hioe) {
            int rc = hioe.getResponseCode();
            String rm = hioe.getResponseMessage();
            Print.logError((String)("HttpIOException [" + rc + "-" + rm + "]: " + hioe.getMessage()), (Object[])new Object[0]);
            if (rc == 403) {
                jsonDoc = JSON_FORBIDDEN_403;
            } else if (rc == 404) {
                jsonDoc = JSON_NOT_FOUND_404;
            }
        }
        catch (IOException ioe) {
            Print.logError((String)("IOException: " + ioe.getMessage()), (Object[])new Object[0]);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable th) {}
            }
        }
        return jsonDoc;
    }

    private static String FilterID(String id) {
        if (id == null) {
            return null;
        }
        StringBuffer newID = new StringBuffer();
        boolean st = false;
        for (int i = 0; i < id.length(); ++i) {
            char ch = Character.toLowerCase(id.charAt(i));
            if (Character.isLetterOrDigit(ch)) {
                newID.append(ch);
                st = true;
                continue;
            }
            if (!st) continue;
            newID.append("_");
            st = false;
        }
        while (newID.length() > 0 && newID.charAt(newID.length() - 1) == '_') {
            newID.setLength(newID.length() - 1);
        }
        return newID.toString();
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        Print.setAllOutputToStdout((boolean)true);
        Print.setEncoding((String)ENCODING_UTF8);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"demo");
        GoogleGeocodeV3 gn = new GoogleGeocodeV3("googleV3", null, null);
        if (RTConfig.hasProperty((String[])ARG_GEOCODE)) {
            String address = RTConfig.getString((String[])ARG_GEOCODE, null);
            if (FileTools.isFile((String)address)) {
                StringBuffer sb = new StringBuffer();
                sb.append("\"accountID\",");
                sb.append("\"geozoneID\",");
                sb.append("\"sortID\",");
                sb.append("\"description\",");
                sb.append("\"radius\",");
                sb.append("\"latitude1\",");
                sb.append("\"longitude1\"");
                Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
                String[] aList = StringTools.split((String)StringTools.toStringValue((byte[])FileTools.readFile((String)address)), (char)'\n');
                int zoneCnt = 0;
                char[] stipChars = new char[]{'\"'};
                for (String a : aList) {
                    GeoPoint gp;
                    String dftzoneID;
                    String geozoneID = dftzoneID = "zone_" + ++zoneCnt;
                    int sortID = 0;
                    String descr = "";
                    int radiusM = 200;
                    String addr = "";
                    Object[] f = StringTools.split((String)a, (char)'|');
                    if (ListTools.size((Object[])f) == 1) {
                        geozoneID = dftzoneID;
                        descr = StringTools.stripChars((String)StringTools.trim((String)f[0]), (char[])stipChars);
                        addr = StringTools.stripChars((String)StringTools.trim((String)f[0]), (char[])stipChars);
                    } else if (ListTools.size((Object[])f) >= 3) {
                        geozoneID = StringTools.blankDefault((String)GoogleGeocodeV3.FilterID((String)f[0]), (String)dftzoneID);
                        descr = StringTools.stripChars((String)StringTools.trim((String)f[0]), (char[])stipChars);
                        sortID = 0;
                        radiusM = StringTools.parseInt((String)f[1], (int)200);
                        addr = StringTools.stripChars((String)StringTools.trim((String)f[2]), (char[])stipChars);
                    }
                    if (StringTools.isBlank((String)addr)) continue;
                    int maxLen_geozoneID = 32;
                    if (geozoneID.length() > maxLen_geozoneID && (geozoneID = geozoneID.substring(0, maxLen_geozoneID)).endsWith("_")) {
                        geozoneID = geozoneID.substring(0, geozoneID.length() - 1);
                    }
                    if ((gp = gn.getGeocode(addr, DEFAULT_COUNTRY)) != null && gp.isValid()) {
                        sb.setLength(0);
                        sb.append("\"").append(accountID).append("\",");
                        sb.append("\"").append(geozoneID).append("\",");
                        sb.append("").append(sortID).append(",");
                        sb.append("\"").append(descr).append("\",");
                        sb.append("").append(radiusM).append(",");
                        sb.append("").append(gp.getLatitude()).append(",");
                        sb.append("").append(gp.getLongitude()).append("");
                        Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
                        continue;
                    }
                    Print.sysPrintln((String)("// GPS location not found for address: " + addr), (Object[])new Object[0]);
                }
            } else {
                GeoPoint gp = gn.getGeocode(address, DEFAULT_COUNTRY);
                Print.sysPrintln((String)("Location " + gp), (Object[])new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_REVGEOCODE)) {
            GeoPoint gp = new GeoPoint(RTConfig.getString((String[])ARG_REVGEOCODE, null));
            if (!gp.isValid()) {
                Print.logInfo((String)"Invalid GeoPoint specified", (Object[])new Object[0]);
                System.exit(1);
            }
            Print.logInfo((String)("Reverse-Geocoding GeoPoint: " + gp), (Object[])new Object[0]);
            Print.sysPrintln((String)("RevGeocode = " + gn.getReverseGeocode(gp, null, false)), (Object[])new Object[0]);
            System.exit(0);
        }
        Print.sysPrintln((String)"No options specified", (Object[])new Object[0]);
        System.exit(1);
    }
}

