/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.geocoder.google;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengts.db.DBConfig;
import org.opengts.geocoder.GeocodeProvider;
import org.opengts.geocoder.ReverseGeocode;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.geocoder.ReverseGeocodeProviderAdapter;
import org.opengts.geocoder.google.GoogleSig;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GoogleGeocodeV2
extends ReverseGeocodeProviderAdapter
implements ReverseGeocodeProvider,
GeocodeProvider {
    protected static final String TAG_kml = "kml";
    protected static final String TAG_Response = "Response";
    protected static final String TAG_name = "name";
    protected static final String TAG_Status = "Status";
    protected static final String TAG_code = "code";
    protected static final String TAG_request = "request";
    protected static final String TAG_Placemark = "Placemark";
    protected static final String TAG_address = "address";
    protected static final String TAG_AddressDetails = "AddressDetails";
    protected static final String TAG_Country = "Country";
    protected static final String TAG_CountryNameCode = "CountryNameCode";
    protected static final String TAG_CountryName = "CountryName";
    protected static final String TAG_AdministrativeArea = "AdministrativeArea";
    protected static final String TAG_AdministrativeAreaName = "AdministrativeAreaName";
    protected static final String TAG_Locality = "Locality";
    protected static final String TAG_LocalityName = "LocalityName";
    protected static final String TAG_PostalCode = "PostalCode";
    protected static final String TAG_PostalCodeNumber = "PostalCodeNumber";
    protected static final String TAG_Point = "Point";
    protected static final String TAG_coordinates = "coordinates";
    protected static final String ATTR_id = "id";
    protected static final String ATTR_Accuracy = "Accuracy";
    protected static final String URL_ReverseGeocode_ = "http://maps.google.com/maps/geo?";
    protected static final String URL_Geocode_ = "http://maps.google.com/maps/geo?";
    protected static final String PROP_reverseGeocodeURL = "reverseGeocodeURL";
    protected static final String PROP_geocodeURL = "geocodeURL";
    protected static final String PROP_sensor = "sensor";
    protected static final String PROP_channel = "channel";
    protected static final String PROP_countryCodeBias = "countryCodeBias";
    protected static final String PROP_signatureKey = "signatureKey";
    protected static final int TIMEOUT_ReverseGeocode = 2500;
    protected static final int TIMEOUT_Geocode = 5000;
    protected static final String DEFAULT_COUNTRY = "US";
    protected static final String CLIENT_ID_PREFIX = "gme-";
    protected static final boolean FAILOVER_DEBUG = false;
    protected static final double MAX_ADDRESS_DISTANCE_KM = 1.1;
    protected static final String ENCODING_UTF8 = "UTF-8";
    private boolean signature_init = false;
    private GoogleSig signature = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "a"};
    private static final String[] ARG_GEOCODE = new String[]{"geocode", "gc"};
    private static final String[] ARG_REVGEOCODE = new String[]{"revgeo", "rg"};

    public GoogleGeocodeV2(String name, String key, RTProperties rtProps) {
        super(name, key, rtProps);
    }

    @Override
    public boolean isFastOperation() {
        return super.isFastOperation();
    }

    public GoogleSig getSignature() {
        if (!this.signature_init) {
            this.signature_init = true;
            String key = this.getAuthorization();
            if (!StringTools.isBlank((String)key) && key.startsWith(CLIENT_ID_PREFIX)) {
                String sigKey = this.getProperties().getString(PROP_signatureKey, "");
                if (!StringTools.isBlank((String)sigKey)) {
                    Print.logWarn((String)("Setting SignatureKey: " + sigKey), (Object[])new Object[0]);
                    this.signature = new GoogleSig(sigKey);
                } else {
                    Print.logWarn((String)"No signatureKey ...", (Object[])new Object[0]);
                }
            }
        }
        return this.signature;
    }

    protected int getGeocodeTimeout() {
        return 5000;
    }

    protected int getReverseGeocodeTimeout() {
        return 2500;
    }

    @Override
    public ReverseGeocode getReverseGeocode(GeoPoint gp, String localeStr, boolean cache) {
        ReverseGeocode rg = this.getAddressReverseGeocode(gp, localeStr, cache);
        return rg;
    }

    protected String getAddressReverseGeocodeURI() {
        return "http://maps.google.com/maps/geo?";
    }

    protected String getAddressReverseGeocodeURL(GeoPoint gp, String localStr) {
        StringBuffer sb = new StringBuffer();
        GoogleSig sig = this.getSignature();
        String rgURL = this.getProperties().getString(PROP_reverseGeocodeURL, null);
        if (!StringTools.isBlank((String)rgURL)) {
            sb.append(rgURL);
            sb.append("&ll=").append(gp.getLatitudeString("5", null)).append(",").append(gp.getLongitudeString("5", null));
            String defURL = sb.toString();
            if (sig == null) {
                return defURL;
            }
            String urlStr = sig.signURL(defURL);
            return urlStr != null ? urlStr : defURL;
        }
        sb.append(this.getAddressReverseGeocodeURI());
        sb.append("output=xml");
        sb.append("&oe=utf8");
        sb.append("&ll=").append(gp.getLatitudeString("5", null)).append(",").append(gp.getLongitudeString("5", null));
        String sensor = this.getProperties().getString(PROP_sensor, null);
        if (!StringTools.isBlank((String)sensor)) {
            sb.append("&sensor=").append(sensor);
        }
        String channel = this.getProperties().getString(PROP_channel, null);
        String auth = this.getAuthorization();
        if (!StringTools.isBlank((String)auth) && !auth.startsWith("*")) {
            if (auth.startsWith(CLIENT_ID_PREFIX)) {
                sb.append("&client=").append(auth);
                if (StringTools.isBlank((String)channel)) {
                    channel = DBConfig.getServiceAccountID(null);
                }
            } else {
                sb.append("&key=").append(auth);
            }
        }
        if (!StringTools.isBlank((String)channel)) {
            sb.append("&channel=").append(channel);
        }
        if (!StringTools.isBlank((String)localStr)) {
            sb.append("&hl=").append(localStr);
        }
        String defURL = sb.toString();
        if (sig == null) {
            return defURL;
        }
        String urlStr = sig.signURL(defURL);
        return urlStr != null ? urlStr : defURL;
    }

    public ReverseGeocode getAddressReverseGeocode(GeoPoint gp, String localeStr, boolean cache) {
        if (this.isReverseGeocodeFailoverMode()) {
            ReverseGeocodeProvider frgp = this.getFailoverReverseGeocodeProvider();
            return frgp.getReverseGeocode(gp, localeStr, cache);
        }
        String url = this.getAddressReverseGeocodeURL(gp, localeStr);
        Print.logDebug((String)("Google RG URL: " + url), (Object[])new Object[0]);
        Document xmlDoc = GoogleGeocodeV2.GetXMLDocument(url, this.getReverseGeocodeTimeout());
        if (xmlDoc == null) {
            return null;
        }
        String errCode = null;
        String address = null;
        Element kml = xmlDoc.getDocumentElement();
        if (kml.getTagName().equalsIgnoreCase(TAG_kml)) {
            NodeList ResponseList = XMLTools.getChildElements((Node)kml, (String)TAG_Response);
            for (int g = 0; g < ResponseList.getLength(); ++g) {
                Element response = (Element)ResponseList.item(g);
                NodeList responseNodes = response.getChildNodes();
                block1: for (int n = 0; n < responseNodes.getLength(); ++n) {
                    String id;
                    Element responseElem;
                    String responseNodeName;
                    Node responseNode = responseNodes.item(n);
                    if (!(responseNode instanceof Element) || (responseNodeName = (responseElem = (Element)responseNode).getNodeName()).equalsIgnoreCase(TAG_name)) continue;
                    if (responseNodeName.equalsIgnoreCase(TAG_Status)) {
                        NodeList statusNodes = responseElem.getChildNodes();
                        for (int st = 0; st < statusNodes.getLength(); ++st) {
                            Element statusElem;
                            String statusNodeName;
                            Node statusNode = statusNodes.item(st);
                            if (!(statusNode instanceof Element) || !(statusNodeName = (statusElem = (Element)statusNode).getNodeName()).equalsIgnoreCase(TAG_code)) continue;
                            errCode = StringTools.trim((String)GoogleGeocodeV2.GetNodeText(statusElem));
                            continue block1;
                        }
                        continue;
                    }
                    if (!responseNodeName.equalsIgnoreCase(TAG_Placemark) || (id = responseElem.getAttribute(ATTR_id)) == null || !id.equals("p1")) continue;
                    NodeList placemarkNodes = responseElem.getChildNodes();
                    for (int pm = 0; pm < placemarkNodes.getLength(); ++pm) {
                        Element placemarkElem;
                        String placemarkNodeName;
                        Node placemarkNode = placemarkNodes.item(pm);
                        if (!(placemarkNode instanceof Element) || !(placemarkNodeName = (placemarkElem = (Element)placemarkNode).getNodeName()).equalsIgnoreCase(TAG_address)) continue;
                        address = GoogleGeocodeV2.GetNodeText(placemarkElem);
                        continue block1;
                    }
                }
            }
        }
        if (!StringTools.isBlank(address)) {
            ReverseGeocode rg = new ReverseGeocode();
            rg.setFullAddress(address);
            return rg;
        }
        if (errCode != null && errCode.equals("620")) {
            Print.logError((String)"!!!! Google Reverse-Geocode Limit Exceeded [Error 620] !!!!", (Object[])new Object[0]);
            if (this.hasFailoverReverseGeocodeProvider()) {
                this.startReverseGeocodeFailoverMode();
                ReverseGeocodeProvider frgp = this.getFailoverReverseGeocodeProvider();
                Print.logWarn((String)("Failing over to '" + frgp.getName() + "'"), (Object[])new Object[0]);
                return frgp.getReverseGeocode(gp, localeStr, cache);
            }
        }
        return null;
    }

    protected String getGeoPointGeocodeURI() {
        return "http://maps.google.com/maps/geo?";
    }

    protected String getGeoPointGeocodeURL(String address, String country) {
        String auth;
        String channel;
        String sensor;
        String gcURL;
        StringBuffer sb = new StringBuffer();
        GoogleSig sig = this.getSignature();
        if (StringTools.isBlank((String)country)) {
            country = this.getProperties().getString(PROP_countryCodeBias, DEFAULT_COUNTRY);
        }
        if (!StringTools.isBlank((String)(gcURL = this.getProperties().getString(PROP_geocodeURL, null)))) {
            sb.append(gcURL);
            sb.append("&q=").append(URIArg.encodeArg((String)address));
            if (!StringTools.isBlank((String)country)) {
                sb.append("&gl=").append(country);
            }
            return sb.toString();
        }
        sb.append(this.getGeoPointGeocodeURI());
        sb.append("output=xml");
        sb.append("&oe=utf8");
        sb.append("&q=").append(URIArg.encodeArg((String)address));
        if (!StringTools.isBlank((String)country)) {
            sb.append("&gl=").append(country);
        }
        if (!StringTools.isBlank((String)(sensor = this.getProperties().getString(PROP_sensor, null)))) {
            sb.append("&sensor=").append(sensor);
        }
        if (!StringTools.isBlank((String)(channel = this.getProperties().getString(PROP_channel, null)))) {
            sb.append("&channel=").append(channel);
        }
        if (!StringTools.isBlank((String)(auth = this.getAuthorization())) && !auth.startsWith("*")) {
            if (auth.startsWith(CLIENT_ID_PREFIX)) {
                sb.append("&client=").append(auth);
            } else {
                sb.append("&key=").append(auth);
            }
        }
        String defURL = sb.toString();
        if (sig == null) {
            return defURL;
        }
        String urlStr = sig.signURL(defURL);
        return urlStr != null ? urlStr : defURL;
    }

    @Override
    public GeoPoint getGeocode(String address, String country) {
        String url = this.getGeoPointGeocodeURL(address, country);
        Print.logDebug((String)("Google GC URL: " + url), (Object[])new Object[0]);
        Document xmlDoc = GoogleGeocodeV2.GetXMLDocument(url, this.getGeocodeTimeout());
        if (xmlDoc == null) {
            return null;
        }
        String errCode = null;
        GeoPoint geoPoint = null;
        Element kml = xmlDoc.getDocumentElement();
        if (kml.getTagName().equalsIgnoreCase(TAG_kml)) {
            NodeList ResponseList = XMLTools.getChildElements((Node)kml, (String)TAG_Response);
            for (int g = 0; g < ResponseList.getLength(); ++g) {
                Element response = (Element)ResponseList.item(g);
                NodeList responseNodes = response.getChildNodes();
                block1: for (int n = 0; n < responseNodes.getLength(); ++n) {
                    String id;
                    Element responseElem;
                    String responseNodeName;
                    Node responseNode = responseNodes.item(n);
                    if (!(responseNode instanceof Element) || (responseNodeName = (responseElem = (Element)responseNode).getNodeName()).equalsIgnoreCase(TAG_name)) continue;
                    if (responseNodeName.equalsIgnoreCase(TAG_Status)) {
                        NodeList statusNodes = responseElem.getChildNodes();
                        for (int st = 0; st < statusNodes.getLength(); ++st) {
                            Element statusElem;
                            String statusNodeName;
                            Node statusNode = statusNodes.item(st);
                            if (!(statusNode instanceof Element) || !(statusNodeName = (statusElem = (Element)statusNode).getNodeName()).equalsIgnoreCase(TAG_code)) continue;
                            errCode = StringTools.trim((String)GoogleGeocodeV2.GetNodeText(statusElem));
                            continue block1;
                        }
                        continue;
                    }
                    if (!responseNodeName.equalsIgnoreCase(TAG_Placemark) || (id = responseElem.getAttribute(ATTR_id)) == null || !id.equals("p1")) continue;
                    NodeList placemarkNodes = responseElem.getChildNodes();
                    block3: for (int pm = 0; geoPoint == null && pm < placemarkNodes.getLength(); ++pm) {
                        Element placemarkElem;
                        String placemarkNodeName;
                        Node placemarkNode = placemarkNodes.item(pm);
                        if (!(placemarkNode instanceof Element) || !(placemarkNodeName = (placemarkElem = (Element)placemarkNode).getNodeName()).equalsIgnoreCase(TAG_Point)) continue;
                        NodeList pointNodes = placemarkElem.getChildNodes();
                        for (int ptn = 0; geoPoint == null && ptn < pointNodes.getLength(); ++ptn) {
                            String[] ll;
                            Element pointElem;
                            String pointNodeName;
                            Node pointNode = pointNodes.item(ptn);
                            if (!(pointNode instanceof Element) || !(pointNodeName = (pointElem = (Element)pointNode).getNodeName()).equalsIgnoreCase(TAG_coordinates) || (ll = StringTools.split((String)GoogleGeocodeV2.GetNodeText(pointElem), (char)',')).length < 2) continue;
                            double lon = StringTools.parseDouble((String)ll[0], (double)0.0);
                            double lat = StringTools.parseDouble((String)ll[1], (double)0.0);
                            if (!GeoPoint.isValid((double)lat, (double)lon)) continue;
                            geoPoint = new GeoPoint(lat, lon);
                            continue block3;
                        }
                    }
                }
            }
        }
        if (geoPoint != null) {
            return geoPoint;
        }
        if (errCode != null && errCode.equals("620")) {
            Print.logError((String)"!!!! Google Reverse-Geocode Limit Exceeded [Error 620] !!!!", (Object[])new Object[0]);
        }
        return null;
    }

    protected static Document GetXMLDocument(String url, int timeoutMS) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            HTMLTools.HttpBufferedInputStream input = HTMLTools.inputStream_GET((String)url, (int)timeoutMS);
            InputStreamReader reader = new InputStreamReader((InputStream)input, ENCODING_UTF8);
            InputSource inSrc = new InputSource(reader);
            inSrc.setEncoding(ENCODING_UTF8);
            return db.parse(inSrc);
        }
        catch (ParserConfigurationException pce) {
            Print.logError((String)("Parse error: " + pce), (Object[])new Object[0]);
            return null;
        }
        catch (SAXException se) {
            Print.logError((String)("Parse error: " + se), (Object[])new Object[0]);
            return null;
        }
        catch (IOException ioe) {
            Print.logError((String)("IO error: " + ioe), (Object[])new Object[0]);
            return null;
        }
    }

    protected static String GetNodeText(Node root) {
        StringBuffer sb = new StringBuffer();
        if (root != null) {
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() == 4) {
                    sb.append(n.getNodeValue());
                    continue;
                }
                if (n.getNodeType() != 3) continue;
                sb.append(n.getNodeValue());
            }
        }
        return sb.toString();
    }

    private static String FilterID(String id) {
        if (id == null) {
            return null;
        }
        StringBuffer newID = new StringBuffer();
        boolean st = false;
        for (int i = 0; i < id.length(); ++i) {
            char ch = Character.toLowerCase(id.charAt(i));
            if (Character.isLetterOrDigit(ch)) {
                newID.append(ch);
                st = true;
                continue;
            }
            if (!st) continue;
            newID.append("_");
            st = false;
        }
        while (newID.length() > 0 && newID.charAt(newID.length() - 1) == '_') {
            newID.setLength(newID.length() - 1);
        }
        return newID.toString();
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        Print.setAllOutputToStdout((boolean)true);
        Print.setEncoding((String)ENCODING_UTF8);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"demo");
        GoogleGeocodeV2 gn = new GoogleGeocodeV2("google", null, null);
        if (RTConfig.hasProperty((String[])ARG_GEOCODE)) {
            String address = RTConfig.getString((String[])ARG_GEOCODE, null);
            if (FileTools.isFile((String)address)) {
                StringBuffer sb = new StringBuffer();
                sb.append("\"accountID\",");
                sb.append("\"geozoneID\",");
                sb.append("\"sortID\",");
                sb.append("\"description\",");
                sb.append("\"radius\",");
                sb.append("\"latitude1\",");
                sb.append("\"longitude1\"");
                Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
                String[] aList = StringTools.split((String)StringTools.toStringValue((byte[])FileTools.readFile((String)address)), (char)'\n');
                int zoneCnt = 0;
                char[] stipChars = new char[]{'\"'};
                for (String a : aList) {
                    GeoPoint gp;
                    String dftzoneID;
                    String geozoneID = dftzoneID = "zone_" + ++zoneCnt;
                    int sortID = 0;
                    String descr = "";
                    int radiusM = 200;
                    String addr = "";
                    Object[] f = StringTools.split((String)a, (char)'|');
                    if (ListTools.size((Object[])f) == 1) {
                        geozoneID = dftzoneID;
                        descr = StringTools.stripChars((String)StringTools.trim((String)f[0]), (char[])stipChars);
                        addr = StringTools.stripChars((String)StringTools.trim((String)f[0]), (char[])stipChars);
                    } else if (ListTools.size((Object[])f) >= 3) {
                        geozoneID = StringTools.blankDefault((String)GoogleGeocodeV2.FilterID((String)f[0]), (String)dftzoneID);
                        descr = StringTools.stripChars((String)StringTools.trim((String)f[0]), (char[])stipChars);
                        sortID = 0;
                        radiusM = StringTools.parseInt((String)f[1], (int)200);
                        addr = StringTools.stripChars((String)StringTools.trim((String)f[2]), (char[])stipChars);
                    }
                    if (StringTools.isBlank((String)addr)) continue;
                    int maxLen_geozoneID = 32;
                    if (geozoneID.length() > maxLen_geozoneID && (geozoneID = geozoneID.substring(0, maxLen_geozoneID)).endsWith("_")) {
                        geozoneID = geozoneID.substring(0, geozoneID.length() - 1);
                    }
                    if ((gp = gn.getGeocode(addr, DEFAULT_COUNTRY)) != null && gp.isValid()) {
                        sb.setLength(0);
                        sb.append("\"").append(accountID).append("\",");
                        sb.append("\"").append(geozoneID).append("\",");
                        sb.append("").append(sortID).append(",");
                        sb.append("\"").append(descr).append("\",");
                        sb.append("").append(radiusM).append(",");
                        sb.append("").append(gp.getLatitude()).append(",");
                        sb.append("").append(gp.getLongitude()).append("");
                        Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
                        continue;
                    }
                    Print.sysPrintln((String)("// GPS location not found for address: " + addr), (Object[])new Object[0]);
                }
            } else {
                GeoPoint gp = gn.getGeocode(address, DEFAULT_COUNTRY);
                Print.sysPrintln((String)("Location " + gp), (Object[])new Object[0]);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_REVGEOCODE)) {
            GeoPoint gp = new GeoPoint(RTConfig.getString((String[])ARG_REVGEOCODE, null));
            if (!gp.isValid()) {
                Print.logInfo((String)"Invalid GeoPoint specified", (Object[])new Object[0]);
                System.exit(1);
            }
            Print.logInfo((String)("Reverse-Geocoding GeoPoint: " + gp), (Object[])new Object[0]);
            Print.sysPrintln((String)("RevGeocode = " + gn.getReverseGeocode(gp, null, false)), (Object[])new Object[0]);
            System.exit(0);
        }
        Print.sysPrintln((String)"No options specified", (Object[])new Object[0]);
        System.exit(1);
    }
}

