/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.geocoder.gisgraphy;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengts.geocoder.ReverseGeocode;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.geocoder.ReverseGeocodeProviderAdapter;
import org.opengts.geocoder.SubdivisionProvider;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GisGraphy
extends ReverseGeocodeProviderAdapter
implements ReverseGeocodeProvider,
SubdivisionProvider {
    protected static final String TAG_results = "results";
    protected static final String TAG_result = "result";
    protected static final String TAG_QTime = "QTime";
    protected static final String TAG_name = "name";
    protected static final String TAG_adm1Code = "adm1Code";
    protected static final String TAG_adm1Name = "adm1Name";
    protected static final String TAG_countryCode = "countryCode";
    protected static final String PROP_streetURL = "streetURL";
    protected static final String PROP_geolocURL = "geolocURL";
    protected static final String PROP_hostName = "host";
    protected static final String PROP_failoverHost = "failoverHost";
    protected static final String PROP_radiusKM = "radiusKM";
    protected static String HOST_PRIMARY = "localhost";
    protected static String HOST_FAILOVER = "";
    protected static int SERVICE_TIMEOUT_MS = 5000;
    protected static final double MAX_ADDRESS_DISTANCE_KM = 10.0;
    protected static final String ENCODING_UTF8 = "UTF-8";

    public GisGraphy(String name, String key, RTProperties rtProps) {
        super(name, key, rtProps);
    }

    @Override
    public boolean isFastOperation() {
        String h;
        String host = this.getHostname(true);
        int p = host.indexOf(":");
        String string = h = p >= 0 ? host.substring(0, p) : host;
        if (h.equalsIgnoreCase("localhost") || h.equals("127.0.0.1")) {
            return true;
        }
        return super.isFastOperation();
    }

    @Override
    public ReverseGeocode getReverseGeocode(GeoPoint gp, String localeStr, boolean cache) {
        ReverseGeocode rg = this.getAddressReverseGeocode(gp, localeStr, cache);
        return rg;
    }

    @Override
    public String getSubdivision(GeoPoint gp) {
        throw new UnsupportedOperationException("Not supported");
    }

    private String getHostname(boolean primary) {
        RTProperties rtp = this.getProperties();
        String host = primary ? rtp.getString(PROP_hostName, HOST_PRIMARY) : rtp.getString(PROP_failoverHost, HOST_FAILOVER);
        return host;
    }

    private ReverseGeocode getAddressReverseGeocode(GeoPoint gp, String localeStr, boolean cache) {
        Element geo_results;
        Element responseElem;
        String responseNodeName;
        Node responseNode;
        int n;
        NodeList responseNodes;
        int g;
        Element results;
        String geoloc_url = this.getGeolocReverseGeocodeURL(gp);
        Print.logInfo((String)("Geoloc URL: " + geoloc_url), (Object[])new Object[0]);
        Document geoloc_xmlDoc = this.GetXMLDocument(geoloc_url);
        if (geoloc_xmlDoc == null) {
            return null;
        }
        ReverseGeocode rg = new ReverseGeocode();
        String street_url = this.getStreetReverseGeocodeURL(gp);
        Print.logInfo((String)("Street URL: " + street_url), (Object[])new Object[0]);
        Document street_xmlDoc = this.GetXMLDocument(street_url);
        if (street_xmlDoc != null && (results = street_xmlDoc.getDocumentElement()).getTagName().equalsIgnoreCase(TAG_results)) {
            NodeList ResultList = results.getElementsByTagName(TAG_result);
            for (g = 0; g < ResultList.getLength(); ++g) {
                Element response = (Element)ResultList.item(g);
                responseNodes = response.getChildNodes();
                for (n = 0; n < responseNodes.getLength(); ++n) {
                    responseNode = responseNodes.item(n);
                    if (!(responseNode instanceof Element) || !(responseNodeName = (responseElem = (Element)responseNode).getNodeName()).equalsIgnoreCase(TAG_name)) continue;
                    rg.setStreetAddress(GisGraphy.GetNodeText(responseElem));
                }
            }
        }
        if ((geo_results = geoloc_xmlDoc.getDocumentElement()).getTagName().equalsIgnoreCase(TAG_results)) {
            NodeList geo_ResultList = geo_results.getElementsByTagName(TAG_result);
            for (g = 0; g < geo_ResultList.getLength(); ++g) {
                Element geo_response = (Element)geo_ResultList.item(g);
                responseNodes = geo_response.getChildNodes();
                for (n = 0; n < responseNodes.getLength(); ++n) {
                    responseNode = responseNodes.item(n);
                    if (!(responseNode instanceof Element)) continue;
                    responseElem = (Element)responseNode;
                    responseNodeName = responseElem.getNodeName();
                    if (responseNodeName.equalsIgnoreCase(TAG_name)) {
                        rg.setCity(GisGraphy.GetNodeText(responseElem));
                        continue;
                    }
                    if (responseNodeName.equalsIgnoreCase(TAG_adm1Name)) {
                        rg.setStateProvince(GisGraphy.GetNodeText(responseElem));
                        continue;
                    }
                    if (!responseNodeName.equalsIgnoreCase(TAG_countryCode)) continue;
                    rg.setCountryCode(GisGraphy.GetNodeText(responseElem));
                }
            }
        }
        String address = this.createFullAddress(rg);
        rg.setFullAddress(address);
        return rg;
    }

    private String getStreetReverseGeocodeURL(GeoPoint gp) {
        StringBuffer sb = new StringBuffer();
        RTProperties rtp = this.getProperties();
        String url = rtp.getString(PROP_streetURL, null);
        if (!StringTools.isBlank((String)url)) {
            sb.append(url);
            if (!url.endsWith("?")) {
                sb.append("?");
            }
        } else {
            sb.append("http://");
            sb.append(this.getHostname(true));
            sb.append("/street/streetsearch?");
        }
        sb.append("lat=").append(gp.getLatitudeString("5", null)).append("&lng=").append(gp.getLongitudeString("5", null));
        double radiusM = this.getProperties().getDouble(PROP_radiusKM, 10.0) * 1000.0;
        sb.append("&radius=").append(radiusM).append("&from=1&to=1&format=xml&placetype=city&indent=true");
        return sb.toString();
    }

    private String getGeolocReverseGeocodeURL(GeoPoint gp) {
        StringBuffer sb = new StringBuffer();
        RTProperties rtp = this.getProperties();
        String url = rtp.getString(PROP_geolocURL, null);
        if (!StringTools.isBlank((String)url)) {
            sb.append(url);
            if (!url.endsWith("?")) {
                sb.append("?");
            }
        } else {
            sb.append("http://");
            sb.append(this.getHostname(true));
            sb.append("/geoloc/findnearbylocation?");
        }
        sb.append("lat=").append(gp.getLatitudeString("5", null)).append("&lng=").append(gp.getLongitudeString("5", null));
        double radiusM = this.getProperties().getDouble(PROP_radiusKM, 10.0) * 1000.0;
        sb.append("&radius=").append(radiusM).append("&from=1&to=1&format=xml&placetype=GisFeature&indent=true");
        return sb.toString();
    }

    private Document GetXMLDocument(String url) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            HTMLTools.HttpBufferedInputStream input = HTMLTools.inputStream_GET((String)url, (int)SERVICE_TIMEOUT_MS);
            InputStreamReader reader = new InputStreamReader((InputStream)input, ENCODING_UTF8);
            InputSource inSrc = new InputSource(reader);
            inSrc.setEncoding(ENCODING_UTF8);
            return db.parse(inSrc);
        }
        catch (ParserConfigurationException pce) {
            Print.logError((String)("Parse error: " + pce), (Object[])new Object[0]);
            return null;
        }
        catch (SAXException se) {
            Print.logError((String)("Parse error: " + se), (Object[])new Object[0]);
            return null;
        }
        catch (IOException ioe) {
            Print.logError((String)("IO error: " + ioe), (Object[])new Object[0]);
            return null;
        }
    }

    protected static String GetNodeText(Node root) {
        StringBuffer sb = new StringBuffer();
        if (root != null) {
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() == 4) {
                    sb.append(n.getNodeValue());
                    continue;
                }
                if (n.getNodeType() != 3) continue;
                sb.append(n.getNodeValue());
            }
        }
        return sb.toString();
    }

    private String createFullAddress(ReverseGeocode rg) {
        StringBuffer sb = new StringBuffer();
        if (!StringTools.isBlank((String)rg.getStreetAddress())) {
            sb.append(rg.getStreetAddress());
        }
        if (!StringTools.isBlank((String)rg.getCity())) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(rg.getCity());
        }
        if (!StringTools.isBlank((String)rg.getStateProvince())) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(rg.getStateProvince());
        }
        if (!StringTools.isBlank((String)rg.getCountryCode())) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(rg.getCountryCode());
        }
        return sb.toString();
    }

    public static void main(String[] argv) {
        GeoPoint gp;
        String failover;
        RTConfig.setCommandLineArgs((String[])argv);
        Print.setAllOutputToStdout((boolean)true);
        Print.setEncoding((String)ENCODING_UTF8);
        String host = RTConfig.getString((String)PROP_hostName, null);
        if (!StringTools.isBlank((String)host)) {
            HOST_PRIMARY = host;
        }
        if (!StringTools.isBlank((String)(failover = RTConfig.getString((String)PROP_failoverHost, null)))) {
            HOST_FAILOVER = failover;
        }
        if (!(gp = new GeoPoint(RTConfig.getString((String)"gp", null))).isValid()) {
            Print.logInfo((String)"Invalid GeoPoint specified", (Object[])new Object[0]);
            System.exit(1);
        }
        Print.logInfo((String)("Reverse-Geocoding GeoPoint: " + gp), (Object[])new Object[0]);
        GisGraphy gn = new GisGraphy("gisgraphy", null, RTConfig.getCommandLineProperties());
        Print.sysPrintln((String)("RevGeocode = " + gn.getReverseGeocode(gp, null, false)), (Object[])new Object[0]);
    }
}

