/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.geocoder.geonames;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengts.db.USState;
import org.opengts.geocoder.GeocodeProvider;
import org.opengts.geocoder.ReverseGeocode;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.geocoder.ReverseGeocodeProviderAdapter;
import org.opengts.geocoder.SubdivisionProvider;
import org.opengts.util.GeoPoint;
import org.opengts.util.HTMLTools;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.URIArg;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GeoNames
extends ReverseGeocodeProviderAdapter
implements ReverseGeocodeProvider,
SubdivisionProvider,
GeocodeProvider {
    protected static final String TAG_geonames = "geonames";
    protected static final String TAG_geoname = "geoname";
    protected static final String TAG_streetSegment = "streetSegment";
    protected static final String TAG_address = "address";
    protected static final String TAG_code = "code";
    protected static final String TAG_countrySubdivision = "countrySubdivision";
    protected static final String TAG_street = "street";
    protected static final String TAG_streetNumber = "streetNumber";
    protected static final String TAG_lat = "lat";
    protected static final String TAG_lng = "lng";
    protected static final String TAG_distance = "distance";
    protected static final String TAG_postalcode = "postalcode";
    protected static final String TAG_postalCode = "postalCode";
    protected static final String TAG_name = "name";
    protected static final String TAG_placename = "placename";
    protected static final String TAG_cityName = "cityName";
    protected static final String TAG_adminName2 = "adminName2";
    protected static final String TAG_adminCode1 = "adminCode1";
    protected static final String TAG_adminName1 = "adminName1";
    protected static final String TAG_countryCode = "countryCode";
    protected static final String TAG_countryName = "countryName";
    protected static final String TAG_speedCategory = "speedCategory";
    protected static final String TAG_speedRestriction = "speedRestriction";
    protected static final String TAG_isTollRoad = "isTollRoad";
    protected static final String TAG_status = "status";
    protected static final String ATTR_message = "message";
    protected static final String PROP_radiusKM = "radiusKM";
    protected static final String PROP_hostName = "host";
    protected static final String PROP_failoverHostName = "failoverHost";
    protected static final String PROP_primaryService = "primaryService";
    protected static final String PROP_addressFailover = "addressFailover";
    protected static final String PROP_postalFailover = "postalFailover";
    protected static final String PROP_streetFailover = "streetFailover";
    protected static final String PROP_placeFailover = "placeFailover";
    protected static final String PROP_username = "username";
    protected static final String PROP_token = "token";
    protected static final String PROP_service_ = "service.";
    protected static String HOST_PRIMARY = "ws.geonames.org";
    protected static String HOST_PRIMARY2 = "ws.geonames.net";
    protected static String HOST_FAILOVER = null;
    protected static final String SERVICE_findNearestAddress = "findNearestAddress";
    protected static final String SERVICE_findNearbyPlaceName = "findNearbyPlaceName";
    protected static final String SERVICE_countrySubdivision = "countrySubdivision";
    protected static final String SERVICE_findNearbyPostalCodes = "findNearbyPostalCodes";
    protected static final String SERVICE_findNearbyStreetsOSM = "findNearbyStreetsOSM";
    protected static final int TIMEOUT_ReverseGeocode = 2500;
    protected static final int TIMEOUT_Geocode = 5000;
    protected static final double MAX_ADDRESS_DISTANCE_KM = 1.0;
    protected static final String ENCODING_UTF8 = "UTF-8";
    private static double[] speedCategoryMap = new double[]{999.0, 999.0, 129.37, 101.5, 88.45, 67.18, 49.14, 31.09, 9.02};
    private static double[][] speedCategoryMapUS = new double[][]{{999.0, 999.0}, {999.0, 999.0}, {130.0, 128.74752}, {100.0, 104.60736}, {90.0, 88.51392000000001}, {70.0, 64.37376}, {50.0, 48.28032}, {30.0, 32.18688}, {10.0, 8.04672}};
    private GeonamesXML xmlDoc_findNearbyPlaceName = null;
    private GeonamesXML xmlDoc_findNearestAddress = null;
    private GeonamesXML xmlDoc_findNearbyStreetsOSM = null;
    private GeonamesXML xmlDoc_findNearbyPostalCodes = null;
    private GeonamesXML xmlDoc_countrySubdivision = null;

    private static double getSpeedCategoryKPH(int n, boolean isUS) {
        int x;
        int n2 = x = isUS ? 1 : 0;
        if (n <= 0) {
            return speedCategoryMapUS[0][x];
        }
        if (n >= 8) {
            return speedCategoryMapUS[8][x];
        }
        return speedCategoryMapUS[n][x];
    }

    private static boolean IsUSCountry(String country) {
        return country == null || country.equalsIgnoreCase("US");
    }

    private static String getPostalCodeGeocodeURL(String postalCode, String country) {
        if (!StringTools.isBlank((String)postalCode)) {
            StringBuffer url = new StringBuffer();
            url.append("http://ws.geonames.org/postalCodeSearch?");
            url.append("postalcode=").append(postalCode);
            if (!StringTools.isBlank((String)country)) {
                url.append("&country=").append(country);
            }
            url.append("&style=long");
            url.append("&maxRows=5");
            return url.toString();
        }
        return null;
    }

    public static GeoPoint getPostalCodeLocation(String postalCode, String country, int timeoutMS) {
        String url = GeoNames.getPostalCodeGeocodeURL(postalCode, country);
        if (StringTools.isBlank((String)url)) {
            return null;
        }
        Document xmlDoc = GeoNames.GetXMLDocument(url, timeoutMS);
        if (xmlDoc == null) {
            return null;
        }
        Element geonames = xmlDoc.getDocumentElement();
        if (geonames.getTagName().equalsIgnoreCase(TAG_geonames)) {
            NodeList codeList = XMLTools.getChildElements((Node)geonames, (String)TAG_code);
            for (int a = 0; a < codeList.getLength(); ++a) {
                double lon;
                Element code = (Element)codeList.item(a);
                Map<String, String> codeProps = GeoNames.GetElementValueMap(code);
                double lat = StringTools.parseDouble((String)codeProps.get(TAG_lat), (double)-999.0);
                if (!GeoPoint.isValid((double)lat, (double)(lon = StringTools.parseDouble((String)codeProps.get(TAG_lng), (double)-999.0)))) continue;
                return new GeoPoint(lat, lon);
            }
            NodeList statusList = XMLTools.getChildElements((Node)geonames, (String)TAG_status);
            for (int s = 0; s < statusList.getLength(); ++s) {
                Element status = (Element)statusList.item(s);
                String message = XMLTools.getAttribute((Element)status, (String)ATTR_message, null, (boolean)false);
                if (StringTools.isBlank((String)message)) continue;
                Print.logWarn((String)("Geonames Status: " + message), (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static String getPostalCodeLocation_xml(String postalCode, String country, int timeoutMS) {
        String url = GeoNames.getPostalCodeGeocodeURL(postalCode, country);
        if (StringTools.isBlank((String)url)) {
            return null;
        }
        try {
            byte[] xml = HTMLTools.readPage_GET((String)url.toString(), (int)timeoutMS);
            return StringTools.toStringValue((byte[])xml);
        }
        catch (Throwable th) {
            Print.logError((String)("GeoNames URL: " + url), (Object[])new Object[0]);
            Print.logError((String)("GeoName postalCode retrieval error: " + th), (Object[])new Object[0]);
            return null;
        }
    }

    private static String getCityGeocodeURL(String city, String state, String country) {
        if (!StringTools.isBlank((String)city)) {
            StringBuffer url = new StringBuffer();
            url.append("http://ws.geonames.org/search?");
            url.append("name=").append(URIArg.encodeArg((String)city));
            if (!StringTools.isBlank((String)state)) {
                url.append("&adminCode1=").append(state);
            }
            if (!StringTools.isBlank((String)country)) {
                url.append("&country=").append(country);
            }
            url.append("&type=xml");
            url.append("&style=full");
            url.append("&maxRows=3");
            url.append("&featureCode=PPL");
            url.append("&featureCode=PPLA");
            url.append("&featureCode=PPLC");
            url.append("&featureCode=PPLG");
            url.append("&featureCode=PPLG");
            url.append("&featureCode=PPLL");
            url.append("&featureCode=PPLS");
            return url.toString();
        }
        return null;
    }

    public static GeoPoint getCityLocation(String address, String state, String country, int timeoutMS) {
        String url = GeoNames.getCityGeocodeURL(address, state, country);
        if (StringTools.isBlank((String)url)) {
            return null;
        }
        Document xmlDoc = GeoNames.GetXMLDocument(url, timeoutMS);
        if (xmlDoc == null) {
            return null;
        }
        Element geonames = xmlDoc.getDocumentElement();
        if (geonames.getTagName().equalsIgnoreCase(TAG_geonames)) {
            NodeList codeList = XMLTools.getChildElements((Node)geonames, (String)TAG_code);
            for (int a = 0; a < codeList.getLength(); ++a) {
                double lon;
                Element code = (Element)codeList.item(a);
                Map<String, String> codeProps = GeoNames.GetElementValueMap(code);
                double lat = StringTools.parseDouble((String)codeProps.get(TAG_lat), (double)-999.0);
                if (!GeoPoint.isValid((double)lat, (double)(lon = StringTools.parseDouble((String)codeProps.get(TAG_lng), (double)-999.0)))) continue;
                return new GeoPoint(lat, lon);
            }
        }
        NodeList statusList = XMLTools.getChildElements((Node)geonames, (String)TAG_status);
        for (int s = 0; s < statusList.getLength(); ++s) {
            Element status = (Element)statusList.item(s);
            String message = XMLTools.getAttribute((Element)status, (String)ATTR_message, null, (boolean)false);
            if (StringTools.isBlank((String)message)) continue;
            Print.logWarn((String)("Geonames Status: " + message), (Object[])new Object[0]);
        }
        return null;
    }

    public static String getCityLocation_xml(String city, String state, String country, int timeoutMS) {
        String url = GeoNames.getCityGeocodeURL(city, state, country);
        if (StringTools.isBlank((String)url)) {
            return null;
        }
        try {
            byte[] xml = HTMLTools.readPage_GET((String)url.toString(), (int)timeoutMS);
            String xmlStr = StringTools.toStringValue((byte[])xml);
            return xmlStr;
        }
        catch (Throwable th) {
            Print.logError((String)("GeoNames URL: " + url), (Object[])new Object[0]);
            Print.logError((String)("GeoName city retrieval error: " + th), (Object[])new Object[0]);
            return null;
        }
    }

    private static String _createAuthKey(RTProperties rtProps) {
        if (rtProps != null) {
            String username = rtProps.getString(PROP_username, "");
            String token = rtProps.getString(PROP_token, "");
            if (StringTools.isBlank((String)token)) {
                return username;
            }
            return username + ":" + token;
        }
        return "";
    }

    public GeoNames(String name, String key, RTProperties rtProps) {
        super(name, null, rtProps);
        this.init_findNearbyPlaceName();
        this.init_findNearestAddress();
        this.init_findNearbyPostalCodes();
        this.init_findNearbyStreetsOSM();
        this.init_countrySubdivision();
        if (!(StringTools.isBlank((String)key) || key.startsWith("***") || this.hasUsername())) {
            int p = key.indexOf(":");
            this.getProperties().setString(PROP_username, p >= 0 ? key.substring(0, p) : key);
            this.getProperties().setString(PROP_token, p >= 0 ? key.substring(p + 1) : "");
        }
        super.setAuthorization(GeoNames._createAuthKey(rtProps));
    }

    @Override
    public boolean isFastOperation() {
        String host = this.getHostname(true);
        if (host.startsWith("localhost") || host.startsWith("127.0.0.1")) {
            return true;
        }
        return super.isFastOperation();
    }

    protected int getGeocodeTimeout() {
        return 5000;
    }

    protected int getReverseGeocodeTimeout() {
        return 2500;
    }

    public boolean hasUsername() {
        String userName = this.getProperties().getString(PROP_username, null);
        return StringTools.isBlank((String)userName);
    }

    @Override
    public ReverseGeocode getReverseGeocode(GeoPoint gp, String localeStr, boolean cache) {
        RTProperties rtProp = this.getProperties();
        ReverseGeocode rg = null;
        String primaryService = rtProp.getString(PROP_primaryService, null);
        rg = StringTools.isBlank((String)primaryService) || primaryService.equalsIgnoreCase(SERVICE_findNearestAddress) ? this.getAddressReverseGeocode(gp, localeStr) : (primaryService.equalsIgnoreCase(SERVICE_findNearbyPostalCodes) ? this.getPostalReverseGeocode(gp) : (primaryService.equalsIgnoreCase(SERVICE_findNearbyStreetsOSM) ? this.getNearbyStreetNameReverseGeocode(gp) : (primaryService.equalsIgnoreCase(SERVICE_findNearbyPlaceName) ? this.getPlaceNameReverseGeocode(gp) : this.getAddressReverseGeocode(gp, localeStr))));
        if (rg != null) {
            return rg;
        }
        String addressFailover = rtProp.getString(PROP_addressFailover, "false");
        if (StringTools.parseBoolean((String)addressFailover, (boolean)false) && (rg = this.getAddressReverseGeocode(gp, localeStr)) != null) {
            return rg;
        }
        String postalFailover = rtProp.getString(PROP_postalFailover, "false");
        if (StringTools.parseBoolean((String)postalFailover, (boolean)false) && (rg = this.getPostalReverseGeocode(gp)) != null) {
            return rg;
        }
        String streetFailover = rtProp.getString(PROP_streetFailover, "false");
        if (StringTools.parseBoolean((String)streetFailover, (boolean)false) && (rg = this.getNearbyStreetNameReverseGeocode(gp)) != null) {
            return rg;
        }
        String placeFailover = rtProp.getString(PROP_placeFailover, "false");
        if (StringTools.parseBoolean((String)placeFailover, (boolean)false) && (rg = this.getPlaceNameReverseGeocode(gp)) != null) {
            return rg;
        }
        return null;
    }

    @Override
    public GeoPoint getGeocode(String address, String country) {
        if (StringTools.isBlank((String)address)) {
            return null;
        }
        if (StringTools.isBlank((String)country)) {
            country = "US";
        }
        String gpXML = "";
        if (StringTools.isNumeric((String)address)) {
            String zip = address;
            gpXML = GeoNames.getPostalCodeLocation_xml(zip, country, this.getGeocodeTimeout());
        } else {
            Object city;
            Object state;
            Object[] a = StringTools.split((String)address, (char)',');
            if (ListTools.isEmpty((Object[])a)) {
                gpXML = "";
            } else if (a.length >= 2) {
                state = a[a.length - 1];
                city = a[a.length - 2];
                gpXML = GeoNames.getCityLocation_xml((String)city, (String)state, country, this.getGeocodeTimeout());
            } else {
                state = "";
                city = a[0];
                gpXML = GeoNames.getCityLocation_xml((String)city, (String)state, country, this.getGeocodeTimeout());
            }
        }
        if (StringTools.isBlank((String)gpXML)) {
            return null;
        }
        Document xmlDoc = XMLTools.getDocument((String)gpXML);
        if (xmlDoc == null) {
            return null;
        }
        Element geonames = xmlDoc.getDocumentElement();
        if (!geonames.getTagName().equalsIgnoreCase(TAG_geonames)) {
            Print.logWarn((String)("Invalid Geonames tag found: " + geonames.getTagName()), (Object[])new Object[0]);
            return null;
        }
        NodeList codeList = XMLTools.getChildElements((Node)geonames, (String)TAG_code);
        if (!(codeList != null && codeList.getLength() != 0 || (codeList = XMLTools.getChildElements((Node)geonames, (String)TAG_geoname)) != null && codeList.getLength() != 0)) {
            Print.logWarn((String)"Geonames code/geoname sub-tag not found", (Object[])new Object[0]);
            return null;
        }
        double lat = 0.0;
        double lng = 0.0;
        NodeList latLngList = codeList.item(0).getChildNodes();
        for (int n = 0; n < latLngList.getLength(); ++n) {
            String name;
            Node node = latLngList.item(n);
            if (!(node instanceof Element) || StringTools.isBlank((String)(name = node.getNodeName()))) continue;
            if (name.equals(TAG_lat)) {
                lat = StringTools.parseDouble((String)GeoNames.GetNodeText((Element)node), (double)-999.0);
                continue;
            }
            if (!name.equals(TAG_lng)) continue;
            lng = StringTools.parseDouble((String)GeoNames.GetNodeText((Element)node), (double)-999.0);
        }
        if (GeoPoint.isValid((double)lat, (double)lng)) {
            return new GeoPoint(lat, lng);
        }
        return null;
    }

    protected String getHostname(boolean primary) {
        String host;
        RTProperties rtp = this.getProperties();
        String string = host = primary ? rtp.getString(PROP_hostName, HOST_PRIMARY) : rtp.getString(PROP_failoverHostName, HOST_FAILOVER);
        if (StringTools.isBlank((String)host) || host.equalsIgnoreCase("default")) {
            return this.hasUsername() ? HOST_PRIMARY2 : HOST_PRIMARY;
        }
        return host;
    }

    protected StringBuffer getGeonamesURL(boolean primary, String service, GeoPoint gp) {
        String host = this.getHostname(primary);
        if (!StringTools.isBlank((String)host) && !StringTools.isBlank((String)service)) {
            String username;
            RTProperties rtp = this.getProperties();
            StringBuffer sb = new StringBuffer();
            sb.append("http://").append(host).append("/").append(service);
            if (!service.endsWith("?") && !service.endsWith("&")) {
                if (service.indexOf("?") < 0) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
            }
            if (!StringTools.isBlank((String)(username = rtp.getString(PROP_username, null)))) {
                sb.append("username=").append(username).append("&");
                String token = rtp.getString(PROP_token, null);
                if (!StringTools.isBlank((String)token)) {
                    sb.append("token=").append(token).append("&");
                }
            }
            sb.append("lat=").append(gp.getLatitudeString("5", null));
            sb.append("&lng=").append(gp.getLongitudeString("5", null));
            return sb;
        }
        return null;
    }

    protected void init_findNearbyPlaceName() {
        this.xmlDoc_findNearbyPlaceName = new GeonamesXML(SERVICE_findNearbyPlaceName){

            @Override
            public String getURL(boolean primary, GeoPoint gp) {
                StringBuffer sb = GeoNames.this.getGeonamesURL(primary, this.getServiceName(), gp);
                if (sb != null) {
                    sb.append("&style=").append("FULL");
                    return sb.toString();
                }
                return null;
            }
        };
    }

    public ReverseGeocode getPlaceNameReverseGeocode(GeoPoint gp) {
        Document xmlDoc = this.xmlDoc_findNearbyPlaceName.getXMLDocument(gp, this.getReverseGeocodeTimeout());
        if (xmlDoc == null) {
            return null;
        }
        Element geonames = xmlDoc.getDocumentElement();
        if (geonames.getTagName().equalsIgnoreCase(TAG_geonames)) {
            NodeList placeList = XMLTools.getChildElements((Node)geonames, (String)TAG_geoname);
            for (int a = 0; a < placeList.getLength(); ++a) {
                Element place = (Element)placeList.item(a);
                Map<String, String> placeProps = GeoNames.GetElementValueMap(place);
                ReverseGeocode rg = this.createPlaceName(placeProps);
                if (rg == null) continue;
                return rg;
            }
            NodeList statusList = XMLTools.getChildElements((Node)geonames, (String)TAG_status);
            for (int s = 0; s < statusList.getLength(); ++s) {
                Element status = (Element)statusList.item(s);
                String message = XMLTools.getAttribute((Element)status, (String)ATTR_message, null, (boolean)false);
                if (StringTools.isBlank((String)message)) continue;
                Print.logWarn((String)("Geonames Status: " + message), (Object[])new Object[0]);
            }
        }
        return null;
    }

    private ReverseGeocode createPlaceName(Map<String, String> placeProps) {
        StringBuffer sb = new StringBuffer();
        int maxNameLen = 40;
        String place = placeProps.get(TAG_name);
        if (!StringTools.isBlank((String)place)) {
            if (place.length() > maxNameLen) {
                int p = place.indexOf("(");
                int t = p > 0 && p < maxNameLen ? p : maxNameLen;
                place = place.substring(0, t).trim();
            }
            sb.append(place);
        }
        String countryCode = placeProps.get(TAG_countryCode);
        String countryName = placeProps.get(TAG_countryName);
        boolean isUS = GeoNames.IsUSCountry(countryCode);
        if (isUS) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("USA");
        } else if (countryName != null && !countryName.equals("")) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(countryName);
        } else if (countryCode != null && !countryCode.equals("")) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(countryCode);
        }
        String addr = sb.toString().trim();
        if (!addr.equals("")) {
            ReverseGeocode rg = new ReverseGeocode();
            rg.setFullAddress(addr);
            rg.setCountryCode(countryCode);
            return rg;
        }
        return null;
    }

    protected void init_findNearestAddress() {
        this.xmlDoc_findNearestAddress = new GeonamesXML(SERVICE_findNearestAddress){

            @Override
            public String getURL(boolean primary, GeoPoint gp) {
                StringBuffer sb = GeoNames.this.getGeonamesURL(primary, this.getServiceName(), gp);
                if (sb != null) {
                    sb.append("&style=").append("FULL");
                    sb.append("&radius=").append(GeoNames.this.getMaximumSearchRadius());
                    return sb.toString();
                }
                return null;
            }
        };
    }

    protected double getMaximumSearchRadius() {
        double radKM = this.getProperties().getDouble(PROP_radiusKM, 1.0);
        return radKM < 1.0 ? 1.0 : (radKM > 5.0 ? 5.0 : radKM);
    }

    public ReverseGeocode getAddressReverseGeocode(GeoPoint gp, String localeStr) {
        Document xmlDoc = this.xmlDoc_findNearestAddress.getXMLDocument(gp, this.getReverseGeocodeTimeout());
        if (xmlDoc == null) {
            return null;
        }
        Element geonames = xmlDoc.getDocumentElement();
        if (geonames.getTagName().equalsIgnoreCase(TAG_geonames)) {
            double radiusKM = this.getMaximumSearchRadius();
            NodeList addressList = XMLTools.getChildElements((Node)geonames, (String)TAG_address);
            for (int a = 0; a < addressList.getLength(); ++a) {
                Element address = (Element)addressList.item(a);
                Map<String, String> addrProps = GeoNames.GetElementValueMap(address);
                ReverseGeocode rg = this.createAddress(addrProps, radiusKM);
                if (rg == null) continue;
                return rg;
            }
            NodeList statusList = XMLTools.getChildElements((Node)geonames, (String)TAG_status);
            for (int s = 0; s < statusList.getLength(); ++s) {
                Element status = (Element)statusList.item(s);
                String message = XMLTools.getAttribute((Element)status, (String)ATTR_message, null, (boolean)false);
                if (StringTools.isBlank((String)message)) continue;
                Print.logWarn((String)("Geonames Status: " + message), (Object[])new Object[0]);
            }
        }
        return null;
    }

    private ReverseGeocode createAddress(Map<String, String> addrProps, double maxAddressDistanceKM) {
        Object p = null;
        StringBuffer sb = new StringBuffer();
        String country = addrProps.get(TAG_countryCode);
        boolean isUS = GeoNames.IsUSCountry(country);
        double distanceKM = StringTools.parseDouble((String)addrProps.get(TAG_distance), (double)-1.0);
        if (distanceKM <= maxAddressDistanceKM) {
            this.appendAddressKey(sb, addrProps, TAG_streetNumber, false);
            this.appendAddressKey(sb, addrProps, TAG_street, true);
        }
        String streetAddr = sb.toString();
        String cityTag = addrProps.containsKey(TAG_cityName) ? TAG_cityName : TAG_placename;
        String city = this.appendAddressKey(sb, addrProps, cityTag, true);
        String stateTag = addrProps.containsKey(TAG_adminCode1) ? TAG_adminCode1 : TAG_adminName1;
        String state = StringTools.trim((String)addrProps.get(stateTag));
        if (isUS && state.length() > 2) {
            String stateAbbr = USState.getStateCode(state);
            state = !StringTools.isBlank((String)stateAbbr) ? stateAbbr.toUpperCase() : StringTools.setFirstUpperCase((String)state);
        }
        this.appendAddressValue(sb, state, false, false);
        String postalTag = addrProps.containsKey(TAG_postalCode) ? TAG_postalCode : TAG_postalcode;
        String postalCode = addrProps.get(postalTag);
        if (isUS && postalCode != null && postalCode.length() < 5) {
            postalCode = null;
        }
        if (!StringTools.isBlank((String)postalCode)) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(postalCode);
        }
        if (!isUS && !StringTools.isBlank((String)country)) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(country);
        }
        double speedCat = GeoNames.getSpeedCategoryKPH(StringTools.parseInt((String)addrProps.get(TAG_speedCategory), (int)0), isUS);
        double speedLimit = StringTools.parseDouble((String)addrProps.get(TAG_speedRestriction), (double)0.0);
        if (isUS) {
            speedLimit *= 1.609344;
        }
        boolean isTollRoad = StringTools.parseBoolean((String)addrProps.get(TAG_isTollRoad), (boolean)false);
        String addr = sb.toString().trim();
        if (!addr.equals("")) {
            ReverseGeocode rg = new ReverseGeocode();
            rg.setFullAddress(addr);
            rg.setStreetAddress(streetAddr);
            rg.setCity(city);
            rg.setStateProvince(state);
            rg.setPostalCode(postalCode);
            rg.setCountryCode(country);
            if (isUS && !StringTools.isBlank((String)state)) {
                rg.setSubdivision("US/" + state);
            }
            if (speedLimit > 0.0) {
                rg.setSpeedLimitKPH(speedLimit);
            } else {
                rg.setSpeedLimitKPH(speedCat);
            }
            rg.setIsTollRoad(isTollRoad);
            return rg;
        }
        return null;
    }

    private String appendAddressKey(StringBuffer sb, Map addrProps, String key, boolean suffixComma) {
        String elem = (String)addrProps.get(key);
        return this.appendAddressValue(sb, elem, true, suffixComma);
    }

    private String appendAddressValue(StringBuffer sb, String elem, boolean upshiftFirstOnly, boolean suffixComma) {
        if (!StringTools.isBlank((String)elem)) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            if (upshiftFirstOnly) {
                elem = StringTools.setFirstUpperCase((String)elem);
            }
            sb.append(elem);
            if (suffixComma && sb.length() > 0 && sb.charAt(sb.length() - 1) != ',') {
                sb.append(",");
            }
        }
        return elem;
    }

    protected void init_findNearbyStreetsOSM() {
        this.xmlDoc_findNearbyStreetsOSM = new GeonamesXML(SERVICE_findNearbyStreetsOSM){

            @Override
            public String getURL(boolean primary, GeoPoint gp) {
                StringBuffer sb = GeoNames.this.getGeonamesURL(primary, this.getServiceName(), gp);
                if (sb != null) {
                    sb.append("&style=").append("FULL");
                    sb.append("&maxRows=").append("1");
                    return sb.toString();
                }
                return null;
            }
        };
    }

    public ReverseGeocode getNearbyStreetNameReverseGeocode(GeoPoint gp) {
        Document xmlDoc = this.xmlDoc_findNearbyStreetsOSM.getXMLDocument(gp, this.getReverseGeocodeTimeout());
        if (xmlDoc == null) {
            return null;
        }
        Element geonames = xmlDoc.getDocumentElement();
        if (geonames.getTagName().equalsIgnoreCase(TAG_geonames)) {
            NodeList streetList = XMLTools.getChildElements((Node)geonames, (String)TAG_streetSegment);
            for (int a = 0; a < streetList.getLength(); ++a) {
                Element street = (Element)streetList.item(a);
                Map<String, String> streetProps = GeoNames.GetElementValueMap(street);
                ReverseGeocode rg = this.createStreetName(streetProps);
                if (rg == null) continue;
                return rg;
            }
            NodeList statusList = XMLTools.getChildElements((Node)geonames, (String)TAG_status);
            for (int s = 0; s < statusList.getLength(); ++s) {
                Element status = (Element)statusList.item(s);
                String message = XMLTools.getAttribute((Element)status, (String)ATTR_message, null, (boolean)false);
                if (StringTools.isBlank((String)message)) continue;
                Print.logWarn((String)("Geonames Status: " + message), (Object[])new Object[0]);
            }
        }
        return null;
    }

    private ReverseGeocode createStreetName(Map<String, String> codeProps) {
        StringBuffer sb = new StringBuffer();
        String streetName = codeProps.get(TAG_name);
        if (!streetName.equals("")) {
            ReverseGeocode rg = new ReverseGeocode();
            rg.setFullAddress(streetName);
            rg.setStreetAddress(streetName);
            return rg;
        }
        return null;
    }

    protected void init_findNearbyPostalCodes() {
        this.xmlDoc_findNearbyPostalCodes = new GeonamesXML(SERVICE_findNearbyPostalCodes){

            @Override
            public String getURL(boolean primary, GeoPoint gp) {
                StringBuffer sb = GeoNames.this.getGeonamesURL(primary, this.getServiceName(), gp);
                if (sb != null) {
                    sb.append("&style=").append("FULL");
                    sb.append("&maxRows=").append("1");
                    return sb.toString();
                }
                return null;
            }
        };
    }

    public ReverseGeocode getPostalReverseGeocode(GeoPoint gp) {
        Document xmlDoc = this.xmlDoc_findNearbyPostalCodes.getXMLDocument(gp, this.getReverseGeocodeTimeout());
        if (xmlDoc == null) {
            return null;
        }
        Element geonames = xmlDoc.getDocumentElement();
        if (geonames.getTagName().equalsIgnoreCase(TAG_geonames)) {
            NodeList codeList = XMLTools.getChildElements((Node)geonames, (String)TAG_code);
            for (int a = 0; a < codeList.getLength(); ++a) {
                Element code = (Element)codeList.item(a);
                Map<String, String> codeProps = GeoNames.GetElementValueMap(code);
                ReverseGeocode rg = this.createPostalCode(codeProps);
                if (rg == null) continue;
                return rg;
            }
            NodeList statusList = XMLTools.getChildElements((Node)geonames, (String)TAG_status);
            for (int s = 0; s < statusList.getLength(); ++s) {
                Element status = (Element)statusList.item(s);
                String message = XMLTools.getAttribute((Element)status, (String)ATTR_message, null, (boolean)false);
                if (StringTools.isBlank((String)message)) continue;
                Print.logWarn((String)("Geonames Status: " + message), (Object[])new Object[0]);
            }
        }
        return null;
    }

    private ReverseGeocode createPostalCode(Map<String, String> codeProps) {
        String addr;
        Object p = null;
        StringBuffer sb = new StringBuffer();
        String country = codeProps.get(TAG_countryCode);
        boolean isUS = GeoNames.IsUSCountry(country);
        String streetAddr = null;
        String city = this.appendPostalCodeElement(sb, codeProps, TAG_name, 40, true);
        String state = this.appendPostalCodeElement(sb, codeProps, TAG_adminCode1, -1, false);
        String postalTag = codeProps.containsKey(TAG_postalCode) ? TAG_postalCode : TAG_postalcode;
        String postalCode = codeProps.get(postalTag);
        if (isUS && postalCode != null && postalCode.length() < 5) {
            postalCode = null;
        }
        if (postalCode != null && !postalCode.equals("")) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(postalCode);
        }
        if (!isUS && !StringTools.isBlank((String)country)) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(country);
        }
        if (!(addr = sb.toString().trim()).equals("")) {
            ReverseGeocode rg = new ReverseGeocode();
            rg.setFullAddress(addr);
            rg.setStreetAddress(streetAddr);
            rg.setCity(city);
            rg.setStateProvince(state);
            rg.setPostalCode(postalCode);
            rg.setCountryCode(country);
            if (isUS && !StringTools.isBlank((String)state)) {
                rg.setSubdivision("US/" + state);
            }
            return rg;
        }
        return null;
    }

    private String appendPostalCodeElement(StringBuffer sb, Map codeProps, String key, int maxLen, boolean suffixComma) {
        String elem = (String)codeProps.get(key);
        if (!StringTools.isBlank((String)elem)) {
            int elemLen = elem.length();
            if (maxLen > 0 && elemLen > maxLen) {
                int p = elem.indexOf("(");
                int t = p > 0 && p < maxLen ? p : maxLen;
                elem = elem.substring(0, t).trim();
                elemLen = elem.length();
            }
            if (elemLen > 0) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(elem);
                if (suffixComma && sb.length() > 0 && sb.charAt(sb.length() - 1) != ',') {
                    sb.append(",");
                }
            }
        }
        return elem;
    }

    protected void init_countrySubdivision() {
        this.xmlDoc_countrySubdivision = new GeonamesXML("countrySubdivision"){

            @Override
            public String getURL(boolean primary, GeoPoint gp) {
                StringBuffer sb = GeoNames.this.getGeonamesURL(primary, this.getServiceName(), gp);
                if (sb != null) {
                    return sb.toString();
                }
                return null;
            }
        };
    }

    @Override
    public String getSubdivision(GeoPoint gp) {
        Document xmlDoc = this.xmlDoc_countrySubdivision.getXMLDocument(gp, this.getReverseGeocodeTimeout());
        if (xmlDoc == null) {
            return null;
        }
        Element geonames = xmlDoc.getDocumentElement();
        if (geonames.getTagName().equalsIgnoreCase(TAG_geonames)) {
            String subDivTAG = "countrySubdivision";
            NodeList subdivList = XMLTools.getChildElements((Node)geonames, (String)subDivTAG);
            if (subdivList != null) {
                for (int a = 0; a < subdivList.getLength(); ++a) {
                    Element subdivElem = (Element)subdivList.item(a);
                    Map<String, String> subdivMap = GeoNames.GetElementValueMap(subdivElem);
                    String country = subdivMap.get(TAG_countryCode);
                    String subdiv = subdivMap.get(TAG_adminCode1);
                    if (country == null || subdiv == null) continue;
                    String state = country + "/" + subdiv;
                    return state.toUpperCase();
                }
            } else {
                Print.logError((String)("Geonames SubDivision Tag not found: " + subDivTAG), (Object[])new Object[0]);
            }
            NodeList statusList = XMLTools.getChildElements((Node)geonames, (String)TAG_status);
            for (int s = 0; s < statusList.getLength(); ++s) {
                Element status = (Element)statusList.item(s);
                String message = XMLTools.getAttribute((Element)status, (String)ATTR_message, null, (boolean)false);
                if (StringTools.isBlank((String)message)) continue;
                Print.logWarn((String)("Geonames Status: " + message), (Object[])new Object[0]);
            }
        }
        return null;
    }

    protected static Document GetXMLDocument(String url, int timeoutMS) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            HTMLTools.HttpBufferedInputStream input = HTMLTools.inputStream_GET((String)url, (int)timeoutMS);
            InputStreamReader reader = new InputStreamReader((InputStream)input, ENCODING_UTF8);
            InputSource inSrc = new InputSource(reader);
            inSrc.setEncoding(ENCODING_UTF8);
            return db.parse(inSrc);
        }
        catch (ParserConfigurationException pce) {
            Print.logError((String)("Parse error: " + pce), (Object[])new Object[0]);
            return null;
        }
        catch (SAXException se) {
            Print.logError((String)("Parse error: " + se), (Object[])new Object[0]);
            return null;
        }
        catch (IOException ioe) {
            Print.logError((String)("IO error: " + ioe), (Object[])new Object[0]);
            return null;
        }
    }

    protected static Map<String, String> GetElementValueMap(Element elem) {
        HashMap<String, String> elemMap = new HashMap<String, String>();
        NodeList attrNodes = elem.getChildNodes();
        for (int n = 0; n < attrNodes.getLength(); ++n) {
            Node node = attrNodes.item(n);
            if (!(node instanceof Element)) continue;
            String name = node.getNodeName();
            String text = GeoNames.GetNodeText((Element)node);
            if (StringTools.isBlank((String)name) || StringTools.isBlank((String)text)) continue;
            elemMap.put(name, text);
        }
        return elemMap;
    }

    protected static String GetNodeText(Node root) {
        StringBuffer sb = new StringBuffer();
        if (root != null) {
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() == 4) {
                    sb.append(StringTools.trim((String)n.getNodeValue()));
                    continue;
                }
                if (n.getNodeType() != 3) continue;
                sb.append(StringTools.trim((String)n.getNodeValue()));
            }
        }
        return sb.toString();
    }

    public static void main(String[] argv) {
        GeoPoint gp;
        String failover;
        String host;
        GeoPoint gp2;
        RTConfig.setCommandLineArgs((String[])argv);
        Print.setAllOutputToStdout((boolean)true);
        Print.setEncoding((String)ENCODING_UTF8);
        GeoNames gn = new GeoNames(TAG_geonames, null, RTConfig.getCommandLineProperties());
        if (RTConfig.hasProperty((String)"geocode")) {
            String address = RTConfig.getString((String)"geocode", null);
            gp2 = gn.getGeocode(address, "US");
            Print.sysPrintln((String)("Location " + gp2), (Object[])new Object[0]);
            System.exit(0);
        }
        if (RTConfig.hasProperty((String)"zip")) {
            String zipCode = RTConfig.getString((String)"zip", null);
            gp2 = GeoNames.getPostalCodeLocation(zipCode, "US", gn.getGeocodeTimeout());
            Print.sysPrintln((String)("Location " + gp2), (Object[])new Object[0]);
            System.exit(0);
        }
        if (!StringTools.isBlank((String)(host = RTConfig.getString((String)PROP_hostName, null)))) {
            HOST_PRIMARY = host;
        }
        if (!StringTools.isBlank((String)(failover = RTConfig.getString((String)"failover", null)))) {
            HOST_FAILOVER = failover;
        }
        if (!(gp = new GeoPoint(RTConfig.getString((String)"gp", null))).isValid()) {
            Print.logInfo((String)"Invalid GeoPoint specified", (Object[])new Object[0]);
            System.exit(1);
        }
        Print.logInfo((String)("Reverse-Geocoding GeoPoint: " + gp), (Object[])new Object[0]);
        Print.sysPrintln((String)("RevGeocode = " + gn.getReverseGeocode(gp, null, false)), (Object[])new Object[0]);
        Print.sysPrintln((String)("Address    = " + gn.getAddressReverseGeocode(gp, null)), (Object[])new Object[0]);
        Print.sysPrintln((String)("PostalCode = " + gn.getPostalReverseGeocode(gp)), (Object[])new Object[0]);
        Print.sysPrintln((String)("StreetName = " + gn.getNearbyStreetNameReverseGeocode(gp)), (Object[])new Object[0]);
        Print.sysPrintln((String)("PlaceName  = " + gn.getPlaceNameReverseGeocode(gp)), (Object[])new Object[0]);
    }

    private abstract class GeonamesXML {
        private String serviceName;

        public GeonamesXML(String serviceName) {
            RTProperties rtp = GeoNames.this.getProperties();
            this.serviceName = rtp.getString(GeoNames.PROP_service_ + serviceName, serviceName);
        }

        protected String getServiceName() {
            return this.serviceName;
        }

        protected abstract String getURL(boolean var1, GeoPoint var2);

        public Document getXMLDocument(GeoPoint gp, int timeoutMS) {
            Document xmlDoc = null;
            String url = this.getURL(true, gp);
            if (url != null) {
                Print.logInfo((String)("Primary URL: " + url), (Object[])new Object[0]);
                xmlDoc = GeoNames.GetXMLDocument(url, timeoutMS);
                if (xmlDoc == null && (url = this.getURL(false, gp)) != null) {
                    Print.logInfo((String)("Failover URL: " + url), (Object[])new Object[0]);
                    xmlDoc = GeoNames.GetXMLDocument(url, timeoutMS);
                }
            }
            return xmlDoc;
        }
    }
}

