/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.geocoder;

import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.BasicPrivateLabelLoader;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBException;
import org.opengts.geocoder.GeocodeProviderAdapter;
import org.opengts.geocoder.ReverseGeocode;
import org.opengts.geocoder.ReverseGeocodeProvider;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.TriState;

public abstract class ReverseGeocodeProviderAdapter
implements ReverseGeocodeProvider {
    public static final String PROP_ReverseGeocodeProvider_ = "ReverseGeocodeProvider.";
    public static final String _PROP_isEnabled = ".isEnabled";
    public static final String[] PROP_alwaysFast = new String[]{"alwaysFast", "forceAlwaysFast"};
    public static final String[] PROP_maxFailoverSeconds = new String[]{"maxFailoverSeconds"};
    public static long DEFAULT_MAX_FAILOVER_SECONDS = DateTime.HourSeconds((long)1L);
    public static long MIN_FAILOVER_SECONDS = DateTime.MinuteSeconds((long)10L);
    private String name = null;
    private TriState isEnabled = TriState.UNKNOWN;
    private String accessKey = null;
    private RTProperties properties = null;
    private ReverseGeocodeProvider rgFailoverRGP = null;
    private Object rgFailoverLock = new Object();
    private long rgFailoverTime = 0L;
    private long rgFailoverTimeoutSec = 0L;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_PLN = new String[]{"privateLabelName", "pln", "pl"};
    private static final String[] ARG_GEOPOINT = new String[]{"geoPoint", "gp"};
    private static final String[] ARG_ADDRESS = new String[]{"address", "addr", "a"};
    private static final String[] ARG_COUNTRY = new String[]{"country", "c"};
    private static final String[] ARG_CACHE = new String[]{"cache", "save"};

    public ReverseGeocodeProviderAdapter(String name, String key, RTProperties rtProps) {
        this.setName(name);
        this.setAuthorization(key);
        this.setProperties(rtProps);
    }

    public void setName(String name) {
        this.name = name != null ? name : "";
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : "";
    }

    public void setAuthorization(String key) {
        this.accessKey = key;
    }

    public String getAuthorization() {
        return this.accessKey;
    }

    @Override
    public void setFailoverReverseGeocodeProvider(ReverseGeocodeProvider rgp) {
        this.rgFailoverRGP = rgp;
    }

    @Override
    public ReverseGeocodeProvider getFailoverReverseGeocodeProvider() {
        return this.rgFailoverRGP;
    }

    public boolean hasFailoverReverseGeocodeProvider() {
        return this.rgFailoverRGP != null;
    }

    protected void startReverseGeocodeFailoverMode() {
        this.startReverseGeocodeFailoverMode(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startReverseGeocodeFailoverMode(long failoverTimeoutSec) {
        Object object = this.rgFailoverLock;
        synchronized (object) {
            this.rgFailoverTime = DateTime.getCurrentTimeSec();
            this.rgFailoverTimeoutSec = failoverTimeoutSec > 0L ? failoverTimeoutSec : this.getMaximumFailoverElapsedSec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isReverseGeocodeFailoverMode() {
        if (this.hasFailoverReverseGeocodeProvider()) {
            boolean rtn;
            Object object = this.rgFailoverLock;
            synchronized (object) {
                if (this.rgFailoverTime <= 0L) {
                    rtn = false;
                } else {
                    long deltaSec = DateTime.getCurrentTimeSec() - this.rgFailoverTime;
                    long maxFailoverSec = this.rgFailoverTimeoutSec > 0L ? this.rgFailoverTimeoutSec : this.getMaximumFailoverElapsedSec();
                    boolean bl = rtn = deltaSec < maxFailoverSec;
                    if (!rtn) {
                        this.rgFailoverTime = 0L;
                        this.rgFailoverTimeoutSec = 0L;
                    }
                }
            }
            return rtn;
        }
        return false;
    }

    protected String[] _getUserPass() {
        String username = null;
        String password = null;
        String key = this.getAuthorization();
        if (key != null && !key.equals("")) {
            int p = key.indexOf(":");
            if (p >= 0) {
                username = key.substring(0, p);
                password = key.substring(p + 1);
            } else {
                username = key;
                password = "";
            }
        } else {
            username = null;
            password = null;
        }
        return new String[]{username, password};
    }

    protected String getUsername() {
        return this._getUserPass()[0];
    }

    protected String getPassword() {
        return this._getUserPass()[1];
    }

    public void setProperties(RTProperties rtProps) {
        this.properties = rtProps;
    }

    public RTProperties getProperties() {
        if (this.properties == null) {
            this.properties = new RTProperties();
        }
        return this.properties;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        String auth = this.getAuthorization();
        if (!StringTools.isBlank((String)auth)) {
            sb.append(" [");
            sb.append(auth);
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public boolean isEnabled() {
        if (this.isEnabled.isUnknown()) {
            String key = PROP_ReverseGeocodeProvider_ + this.getName() + _PROP_isEnabled;
            if (RTConfig.getBoolean((String)key, (boolean)true)) {
                this.isEnabled = TriState.TRUE;
            } else {
                this.isEnabled = TriState.FALSE;
                Print.logWarn((String)("ReverseGeocodeProvider disabled: " + this.getName()), (Object[])new Object[0]);
            }
        }
        return this.isEnabled.isTrue();
    }

    @Override
    public boolean isFastOperation() {
        RTProperties rtp = this.getProperties();
        return rtp.getBoolean(PROP_alwaysFast, false);
    }

    public long getMaximumFailoverElapsedSec() {
        RTProperties rtp = this.getProperties();
        long sec = rtp.getLong(PROP_maxFailoverSeconds, DEFAULT_MAX_FAILOVER_SECONDS);
        return sec > MIN_FAILOVER_SECONDS ? sec : MIN_FAILOVER_SECONDS;
    }

    @Override
    public abstract ReverseGeocode getReverseGeocode(GeoPoint var1, String var2, boolean var3);

    private static void usage() {
        String n = ReverseGeocodeProviderAdapter.class.getName();
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Description:", (Object[])new Object[0]);
        Print.sysPrintln((String)"   Reverse-Geocode Testing Tool ...", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("   java ... " + n + " -geoPoint=<gp> -account=<id>"), (Object[])new Object[0]);
        Print.sysPrintln((String)" or", (Object[])new Object[0]);
        Print.sysPrintln((String)("   java ... " + n + " -geoPoint=<gp> -pln=<name>"), (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Common Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -account=<id>   Acount ID from which to obtain the ReverseGeocodeProvider", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -pln=<name>     PrivateLabel name/host", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -geoPoint=<gp>  GeoPoint in the form <latitude>/<longitude>", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -addr=<addr>    Address to Geocode", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _main() {
        GeoPoint gp = new GeoPoint(RTConfig.getString((String[])ARG_GEOPOINT, null));
        if (!gp.isValid()) {
            Print.sysPrintln((String)"ERROR: No GeoPoint specified", (Object[])new Object[0]);
            ReverseGeocodeProviderAdapter.usage();
        }
        BasicPrivateLabel privLabel = null;
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        if (!StringTools.isBlank((String)accountID)) {
            Account acct = null;
            try {
                acct = Account.getAccount(accountID);
                if (acct == null) {
                    Print.sysPrintln((String)("ERROR: Account-ID does not exist: " + accountID), (Object[])new Object[0]);
                    ReverseGeocodeProviderAdapter.usage();
                }
                privLabel = acct.getPrivateLabel();
            }
            catch (DBException dbe) {
                Print.logException((String)("Error loading Account: " + accountID), (Throwable)dbe);
                System.exit(99);
            }
        } else {
            String pln = RTConfig.getString((String[])ARG_PLN, (String)"default");
            if (StringTools.isBlank((String)pln)) {
                Print.sysPrintln((String)"ERROR: Must specify '-account=<Account>'", (Object[])new Object[0]);
                ReverseGeocodeProviderAdapter.usage();
            } else {
                privLabel = BasicPrivateLabelLoader.getPrivateLabel(pln);
                if (privLabel == null) {
                    Print.sysPrintln((String)"ERROR: PrivateLabel name not found: %s", (Object[])new Object[]{pln});
                    ReverseGeocodeProviderAdapter.usage();
                }
            }
        }
        ReverseGeocodeProvider rgp = privLabel.getReverseGeocodeProvider();
        if (rgp == null) {
            Print.sysPrintln((String)"ERROR: No ReverseGeocodeProvider for PrivateLabel: %s", (Object[])new Object[]{privLabel.getName()});
            System.exit(99);
        } else if (!rgp.isEnabled()) {
            Print.sysPrintln((String)("WARNING: ReverseGeocodeProvider disabled: " + rgp.getName()), (Object[])new Object[0]);
            System.exit(0);
        }
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)(rgp.getName() + "] ReverseGeocode: " + gp), (Object[])new Object[0]);
        try {
            privLabel.pushRTProperties();
            boolean cache = RTConfig.getBoolean((String[])ARG_CACHE, (boolean)false);
            ReverseGeocode rg = rgp.getReverseGeocode(gp, privLabel.getLocaleString(), cache);
            if (rg != null) {
                Print.sysPrintln((String)rg.toString(), (Object[])new Object[0]);
            } else {
                Print.sysPrintln((String)"Unable to reverse-geocode specified point", (Object[])new Object[0]);
            }
        }
        catch (Throwable th) {
        }
        finally {
            privLabel.popRTProperties();
        }
        Print.sysPrintln((String)"", (Object[])new Object[0]);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        if (RTConfig.hasProperty((String[])ARG_ADDRESS)) {
            GeocodeProviderAdapter._main();
        } else {
            ReverseGeocodeProviderAdapter._main();
        }
    }
}

