/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.geocoder;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.opengts.geocoder.ReverseGeocode;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;

public class ReverseGeocodeCache {
    private static final long DEFAULT_MAX_AGE_SEC = DateTime.MinuteSeconds((long)60L);
    private static final int DEFAULT_MAX_SIZE = 1000;
    private static final String GEOPOINT_DECIMAL = "4";
    private static boolean DEBUG = false;
    private Map<String, RGItem> rgCacheMap = new HashMap<String, RGItem>();
    private int maxCacheSize = 1000;
    private long maxAgeSec = DEFAULT_MAX_AGE_SEC;
    private Object mapLock = new Object();
    private int readLockCount = 0;
    private int writeLockCount = 0;

    private static String formatGeoPoint(GeoPoint gp) {
        StringBuffer sb = new StringBuffer();
        String fmt = GEOPOINT_DECIMAL;
        sb.append(GeoPoint.formatLatitude((double)gp.getLatitude(), (String)fmt, null));
        sb.append("/");
        sb.append(GeoPoint.formatLongitude((double)gp.getLongitude(), (String)fmt, null));
        return sb.toString();
    }

    private static long currentTimeSec() {
        if (DEBUG) {
            return System.currentTimeMillis();
        }
        return System.currentTimeMillis() / 1000L;
    }

    public ReverseGeocodeCache() {
        this(1000, DEFAULT_MAX_AGE_SEC);
    }

    public ReverseGeocodeCache(int maxSize, long maxAge) {
        this.setMaxSize(maxSize);
        this.setMaxAgeSec(maxAge);
    }

    public void setMaxSize(int maxSize) {
        this.maxCacheSize = maxSize <= 0 ? 1000 : (maxSize < 100 ? 100 : maxSize);
    }

    public int getMaxSize() {
        return this.maxCacheSize;
    }

    public void setMaxAgeSec(long maxAge) {
        this.maxAgeSec = maxAge > 0L ? maxAge : DEFAULT_MAX_AGE_SEC;
    }

    public long getMaxAgeSec() {
        return this.maxAgeSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getReadLock() {
        boolean rtn = false;
        Object object = this.mapLock;
        synchronized (object) {
            if (this.writeLockCount == 0) {
                ++this.readLockCount;
                rtn = true;
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean releaseReadLock() {
        boolean rtn = false;
        Object object = this.mapLock;
        synchronized (object) {
            if (this.readLockCount > 0) {
                --this.readLockCount;
                rtn = true;
            } else {
                Print.logStackTrace((String)"Read lock released, with no active lock");
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReverseGeocode getReverseGeocode(GeoPoint gp) {
        ReverseGeocode rg = null;
        if (gp != null && gp.isValid()) {
            boolean readLocked = false;
            try {
                RGItem rgi;
                readLocked = this.getReadLock();
                if (readLocked && (rgi = this.rgCacheMap.get(ReverseGeocodeCache.formatGeoPoint(gp))) != null) {
                    rgi.updateTimestamp();
                    rg = rgi.getReverseGeocode();
                }
            }
            finally {
                if (readLocked) {
                    this.releaseReadLock();
                }
            }
        }
        return rg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getWriteLock() {
        boolean rtn = false;
        Object object = this.mapLock;
        synchronized (object) {
            if (this.writeLockCount == 0 && this.readLockCount == 0) {
                ++this.writeLockCount;
                rtn = true;
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean releaseWriteLock() {
        boolean rtn = false;
        Object object = this.mapLock;
        synchronized (object) {
            if (this.writeLockCount > 0) {
                --this.writeLockCount;
                rtn = true;
            } else {
                Print.logStackTrace((String)"Write lock released, with no active lock");
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addReverseGeocode(GeoPoint gp, ReverseGeocode rg) {
        boolean rtn = false;
        if (gp != null && gp.isValid() && rg != null) {
            boolean writeLocked = false;
            try {
                writeLocked = this.getWriteLock();
                if (writeLocked) {
                    this.rgCacheMap.put(ReverseGeocodeCache.formatGeoPoint(gp), new RGItem(rg));
                    rtn = true;
                    int rgSize = this.rgCacheMap.size();
                    if (rgSize > this.maxCacheSize) {
                        if (DEBUG) {
                            Print.logInfo((String)"\n\nTrimming cache ...", (Object[])new Object[0]);
                        }
                        long maxTime = ReverseGeocodeCache.currentTimeSec() - this.maxAgeSec;
                        Iterator<String> i = this.rgCacheMap.keySet().iterator();
                        while (i.hasNext()) {
                            String key = i.next();
                            RGItem rgi = this.rgCacheMap.get(key);
                            if (rgi.getTimestamp() > maxTime) continue;
                            i.remove();
                        }
                        if (DEBUG) {
                            Print.logInfo((String)("Old size=" + rgSize + " New size=" + this.rgCacheMap.size()), (Object[])new Object[0]);
                        }
                        if (this.rgCacheMap.size() > this.maxCacheSize) {
                            Print.logWarn((String)("Unable to trim ReverseGeocodeCache entries: " + this.rgCacheMap.size()), (Object[])new Object[0]);
                            long minSec = DateTime.MinuteSeconds((long)15L);
                            this.maxAgeSec = this.maxAgeSec > 2L * minSec ? (this.maxAgeSec -= minSec) : (this.maxAgeSec /= 2L);
                        }
                    }
                } else {
                    Print.logInfo((String)"Unable to obtain write lock", (Object[])new Object[0]);
                }
            }
            finally {
                if (writeLocked) {
                    this.releaseWriteLock();
                }
            }
        }
        return rtn;
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        ReverseGeocodeCache rgc = new ReverseGeocodeCache();
        DEBUG = true;
        double baseLat = 39.0;
        double baseLon = -142.0;
        Random rand = new Random();
        while (true) {
            double lon;
            double lat;
            GeoPoint gp;
            ReverseGeocode rg;
            if ((rg = rgc.getReverseGeocode(gp = new GeoPoint(lat = baseLat + (double)rand.nextInt(100) / 100.0, lon = baseLon + (double)rand.nextInt(100) / 100.0))) != null) {
                Print.sysPrintln((String)("Found RG: " + gp), (Object[])new Object[0]);
                continue;
            }
            rgc.addReverseGeocode(gp, new ReverseGeocode());
        }
    }

    public static class RGItem {
        private long timestamp = 0L;
        private ReverseGeocode revGeocode = null;

        public RGItem(ReverseGeocode rg) {
            this.revGeocode = rg;
            this.updateTimestamp();
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void updateTimestamp() {
            this.timestamp = ReverseGeocodeCache.currentTimeSec();
        }

        public ReverseGeocode getReverseGeocode() {
            return this.revGeocode;
        }
    }
}

