/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.geocoder;

import org.opengts.util.StringTools;

public class ReverseGeocode {
    public static final String COUNTRY_US = "US";
    public static final String SUBDIVISION_SEPARATOR = "/";
    public static final String COUNTRY_US_ = "US/";
    private String fullAddress = null;
    private String streetAddr = null;
    private String city = null;
    private String stateProvince = null;
    private String postalCode = null;
    private String countryCode = null;
    private String subdivision = null;
    private double speedLimitKPH = 0.0;
    private int isTollRoad = -1;

    public void setFullAddress(String address) {
        this.fullAddress = address != null ? address.trim() : null;
    }

    public String getFullAddress() {
        return this.fullAddress;
    }

    public boolean hasFullAddress() {
        return !StringTools.isBlank((String)this.fullAddress);
    }

    public void setStreetAddress(String address) {
        this.streetAddr = address != null ? address.trim() : null;
    }

    public String getStreetAddress() {
        return this.streetAddr;
    }

    public boolean hasStreetAddress() {
        return !StringTools.isBlank((String)this.streetAddr);
    }

    public void setCity(String city) {
        this.city = city != null ? city.trim() : null;
    }

    public String getCity() {
        return this.city;
    }

    public boolean hasCity() {
        return !StringTools.isBlank((String)this.city);
    }

    public void setStateProvince(String state) {
        this.stateProvince = state != null ? state.trim() : null;
    }

    public String getStateProvince() {
        return this.stateProvince;
    }

    public boolean hasStateProvince() {
        return !StringTools.isBlank((String)this.stateProvince);
    }

    public void setPostalCode(String zip) {
        this.postalCode = zip != null ? zip.trim() : null;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public boolean hasPostalCode() {
        return !StringTools.isBlank((String)this.postalCode);
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode != null ? countryCode.trim() : null;
    }

    public String getCountryCode() {
        return this.hasCountryCode() ? this.countryCode : null;
    }

    public boolean hasCountryCode() {
        return !StringTools.isBlank((String)this.countryCode);
    }

    public void setSubdivision(String subdiv) {
        this.subdivision = subdiv != null ? subdiv.trim() : null;
    }

    public String getSubdivision() {
        return this.hasSubdivision() ? this.subdivision : null;
    }

    public boolean hasSubdivision() {
        return !StringTools.isBlank((String)this.subdivision);
    }

    public void setSpeedLimitKPH(double limitKPH) {
        this.speedLimitKPH = limitKPH;
    }

    public double getSpeedLimitKPH() {
        return this.speedLimitKPH;
    }

    public boolean hasSpeedLimitKPH() {
        return this.speedLimitKPH > 0.0;
    }

    public void setIsTollRoad(boolean tollRoad) {
        this.isTollRoad = tollRoad ? 1 : 0;
    }

    public boolean getIsTollRoad() {
        return this.isTollRoad == 1;
    }

    public boolean hasIsTollRoad() {
        return this.isTollRoad >= 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.hasFullAddress()) {
            sb.append(this.getFullAddress());
        }
        if (this.hasSubdivision()) {
            if (sb.length() > 0) {
                sb.append(" [");
                sb.append(this.getSubdivision());
                sb.append("]");
            } else {
                sb.append(this.getSubdivision());
            }
        }
        if (this.hasSpeedLimitKPH()) {
            double limitKPH = this.getSpeedLimitKPH();
            if (limitKPH >= 900.0) {
                sb.append(" (unlimited speed)");
            } else {
                sb.append(" (limit ");
                sb.append(StringTools.format((double)limitKPH, (String)"0.0"));
                sb.append(" km/h, ");
                sb.append(StringTools.format((double)(limitKPH * 0.621371192237334), (String)"0.0"));
                sb.append(" mph)");
            }
        }
        return sb.toString();
    }
}

