/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.geocoder;

import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.BasicPrivateLabelLoader;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.dbtools.DBException;
import org.opengts.geocoder.GeocodeProvider;
import org.opengts.geocoder.ReverseGeocodeProviderAdapter;
import org.opengts.util.GeoPoint;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.TriState;

public abstract class GeocodeProviderAdapter
implements GeocodeProvider {
    public static final String PROP_GeocodeProvider_ = "GeocodeProvider.";
    public static final String _PROP_isEnabled = ".isEnabled";
    private String name = null;
    private TriState isEnabled = TriState.UNKNOWN;
    private String accessKey = null;
    private RTProperties properties = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_PLN = new String[]{"privateLabelName", "pln", "pl"};
    private static final String[] ARG_ADDRESS = new String[]{"address", "addr", "a"};
    private static final String[] ARG_COUNTRY = new String[]{"country", "c"};

    public GeocodeProviderAdapter(String name, String key, RTProperties rtProps) {
        this.setName(name);
        this.setAuthorization(key);
        this.setProperties(rtProps);
    }

    public void setName(String name) {
        this.name = name != null ? name : "";
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : "";
    }

    public void setAuthorization(String key) {
        this.accessKey = key;
    }

    public String getAuthorization() {
        return this.accessKey;
    }

    protected String[] _getUserPass() {
        String username = null;
        String password = null;
        String key = this.getAuthorization();
        if (key != null && !key.equals("")) {
            int p = key.indexOf(":");
            if (p >= 0) {
                username = key.substring(0, p);
                password = key.substring(p + 1);
            } else {
                username = key;
                password = "";
            }
        } else {
            username = null;
            password = null;
        }
        return new String[]{username, password};
    }

    protected String getUsername() {
        return this._getUserPass()[0];
    }

    protected String getPassword() {
        return this._getUserPass()[1];
    }

    public void setProperties(RTProperties rtProps) {
        this.properties = rtProps;
    }

    public RTProperties getProperties() {
        if (this.properties == null) {
            this.properties = new RTProperties();
        }
        return this.properties;
    }

    @Override
    public boolean isEnabled() {
        if (this.isEnabled.isUnknown()) {
            String key = PROP_GeocodeProvider_ + this.getName() + _PROP_isEnabled;
            if (RTConfig.getBoolean((String)key, (boolean)true)) {
                this.isEnabled = TriState.TRUE;
            } else {
                this.isEnabled = TriState.FALSE;
                Print.logWarn((String)("GeocodeProvider disabled: " + this.getName()), (Object[])new Object[0]);
            }
        }
        return this.isEnabled.isTrue();
    }

    @Override
    public abstract boolean isFastOperation();

    @Override
    public abstract GeoPoint getGeocode(String var1, String var2);

    private static void usage() {
        String n = ReverseGeocodeProviderAdapter.class.getName();
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Description:", (Object[])new Object[0]);
        Print.sysPrintln((String)"   Geocode Testing Tool ...", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Usage:", (Object[])new Object[0]);
        Print.sysPrintln((String)("   java ... " + n + " -address=<addr> -account=<id>"), (Object[])new Object[0]);
        Print.sysPrintln((String)" or", (Object[])new Object[0]);
        Print.sysPrintln((String)("   java ... " + n + " -address=<addr> -pln=<name>"), (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        Print.sysPrintln((String)"Common Options:", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -address=<addr>    Address to Geocode", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -country=<country> Country to Geocode", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -account=<id>      Acount ID from which to obtain the GeocodeProvider", (Object[])new Object[0]);
        Print.sysPrintln((String)"   -pln=<name>        PrivateLabel name/host", (Object[])new Object[0]);
        Print.sysPrintln((String)"", (Object[])new Object[0]);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _main() {
        String country = RTConfig.getString((String[])ARG_COUNTRY, (String)"").replace('_', ' ');
        String addr = RTConfig.getString((String[])ARG_ADDRESS, (String)"").replace('_', ' ');
        if (StringTools.isBlank((String)addr)) {
            Print.sysPrintln((String)"ERROR: No Address specified", (Object[])new Object[0]);
            GeocodeProviderAdapter.usage();
        }
        Print.logInfo((String)("Address = " + addr), (Object[])new Object[0]);
        Print.logInfo((String)("Country = " + country), (Object[])new Object[0]);
        BasicPrivateLabel privLabel = null;
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        if (!StringTools.isBlank((String)accountID)) {
            Account acct = null;
            try {
                acct = Account.getAccount(accountID);
                if (acct == null) {
                    Print.sysPrintln((String)("ERROR: Account-ID does not exist: " + accountID), (Object[])new Object[0]);
                    GeocodeProviderAdapter.usage();
                }
                privLabel = acct.getPrivateLabel();
            }
            catch (DBException dbe) {
                Print.logException((String)("Error loading Account: " + accountID), (Throwable)dbe);
                System.exit(99);
            }
        } else {
            String pln = RTConfig.getString((String[])ARG_PLN, (String)"default");
            if (StringTools.isBlank((String)pln)) {
                Print.sysPrintln((String)"ERROR: Must specify '-account=<Account>'", (Object[])new Object[0]);
                GeocodeProviderAdapter.usage();
            } else {
                privLabel = BasicPrivateLabelLoader.getPrivateLabel(pln);
                if (privLabel == null) {
                    Print.sysPrintln((String)"ERROR: PrivateLabel name not found: %s", (Object[])new Object[]{pln});
                    GeocodeProviderAdapter.usage();
                }
            }
        }
        GeocodeProvider rgp = privLabel.getGeocodeProvider();
        if (rgp == null) {
            Print.sysPrintln((String)"ERROR: No GeocodeProvider for PrivateLabel: %s", (Object[])new Object[]{privLabel.getName()});
            System.exit(99);
        } else if (!rgp.isEnabled()) {
            Print.sysPrintln((String)("WARNING: GeocodeProvider disabled: " + rgp.getName()), (Object[])new Object[0]);
            System.exit(0);
        }
        try {
            privLabel.pushRTProperties();
            GeoPoint geop = rgp.getGeocode(addr, country);
            if (geop != null) {
                Print.sysPrintln((String)"", (Object[])new Object[0]);
                Print.sysPrintln((String)"Geocode:", (Object[])new Object[0]);
                Print.sysPrintln((String)geop.toString(), (Object[])new Object[0]);
                Print.sysPrintln((String)"", (Object[])new Object[0]);
            } else {
                Print.sysPrintln((String)("ERROR: Unable to obtain Geocode for specified address: " + addr), (Object[])new Object[0]);
            }
        }
        catch (Throwable th) {
        }
        finally {
            privLabel.popRTProperties();
        }
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        GeocodeProviderAdapter._main();
    }
}

