/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.tables;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Locale;
import java.util.Vector;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Transport;
import org.opengts.db.tables.UserAcl;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtypes.DTIPAddress;
import org.opengts.util.AccumulatorLong;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class UnassignedDevices
extends DBRecord<UnassignedDevices> {
    public static final long MAX_AGE_SEC = DateTime.DaySeconds((long)60L);
    public static final String ACCOUNT_DEVICE_SEP = ",";
    public static int MobileIDColumnLength = -1;
    public static final String _TABLE_NAME = "UnassignedDevices";
    public static final String FLD_serverID = "serverID";
    public static final String FLD_mobileID = "mobileID";
    public static final String FLD_timestamp = "timestamp";
    public static final String FLD_ipAddress = "ipAddress";
    public static final String FLD_isDuplex = "isDuplex";
    public static final String FLD_latitude = "latitude";
    public static final String FLD_longitude = "longitude";
    public static final String FLD_data = "data";
    private static DBField[] FieldInfo = new DBField[]{new DBField("serverID", String.class, DBField.TYPE_ID(), "Server ID", "key=true"), new DBField("mobileID", String.class, DBField.TYPE_STRING((int)32), "Mobile ID", "key=true"), new DBField("timestamp", Long.TYPE, "UINT32", "Timestamp", ""), new DBField("ipAddress", DTIPAddress.class, DBField.TYPE_STRING((int)32), "IP Address", ""), new DBField("isDuplex", Boolean.TYPE, "BOOLEAN", "Is Duplex", ""), new DBField("latitude", Double.TYPE, "DOUBLE", "Latitude", "format=#0.00000"), new DBField("longitude", Double.TYPE, "DOUBLE", "Longitude", "format=#0.00000"), new DBField("data", String.class, DBField.TYPE_STRING((int)255), "Data", ""), UnassignedDevices.newField_creationTime()};
    private static DBFactory<UnassignedDevices> factory = null;
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_UPDATE = new String[]{"update"};

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<UnassignedDevices> getFactory() {
        if (factory == null && (MobileIDColumnLength = (factory = DBFactory.createDBFactory((String)UnassignedDevices.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, UnassignedDevices.class, Key.class, (boolean)true, (boolean)true)).getFieldStringLength(FLD_mobileID)) <= 0) {
            Print.logWarn((String)"Could not find field: mobileID", (Object[])new Object[0]);
        }
        return factory;
    }

    public UnassignedDevices() {
    }

    public UnassignedDevices(Key key) {
        super((DBRecordKey)key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(UnassignedDevices.class, (Locale)loc);
        return i18n.getString("UnassignedDevices.description", "This table contains Mobile IDs for which no Device record was found.");
    }

    public String getServerID() {
        String v = (String)this.getFieldValue(FLD_serverID);
        return StringTools.trim((String)v);
    }

    public void seServerID(String v) {
        this.setFieldValue(FLD_serverID, StringTools.trim((String)v));
    }

    public String getMobileID() {
        String v = (String)this.getFieldValue(FLD_mobileID);
        return StringTools.trim((String)v);
    }

    public void setMobileID(String v) {
        String mid = DBRecord.adjustStringLength((String)v, (int)MobileIDColumnLength);
        this.setFieldValue(FLD_mobileID, mid);
    }

    public long getTimestamp() {
        Long v = (Long)this.getFieldValue(FLD_timestamp);
        return v != null ? v : 0L;
    }

    public void setTimestamp(long v) {
        this.setFieldValue(FLD_timestamp, v);
    }

    public DTIPAddress getIpAddress() {
        DTIPAddress v = (DTIPAddress)((Object)this.getFieldValue(FLD_ipAddress));
        return v;
    }

    public String getIpAddressString() {
        return StringTools.trim((Object)((Object)this.getIpAddress()));
    }

    public void setIpAddress(DTIPAddress v) {
        this.setFieldValue(FLD_ipAddress, (Object)v);
    }

    public void setIpAddress(String v) {
        this.setIpAddress(v != null ? new DTIPAddress(v) : null);
    }

    public boolean getIsDuplex() {
        Boolean v = (Boolean)this.getFieldValue(FLD_isDuplex);
        return v != null ? v : false;
    }

    public void setIsDuplex(boolean v) {
        this.setFieldValue(FLD_isDuplex, v);
    }

    public boolean isDuplex() {
        return this.getIsDuplex();
    }

    public double getLatitude() {
        return this.getFieldValue(FLD_latitude, 0.0);
    }

    public void setLatitude(double v) {
        this.setFieldValue(FLD_latitude, v);
    }

    public double getLongitude() {
        return this.getFieldValue(FLD_longitude, 0.0);
    }

    public void setLongitude(double v) {
        this.setFieldValue(FLD_longitude, v);
    }

    public GeoPoint getGeoPoint() {
        return new GeoPoint(this.getLatitude(), this.getLongitude());
    }

    public String getData() {
        String v = (String)this.getFieldValue(FLD_data);
        return StringTools.trim((String)v);
    }

    public void setData(String v) {
        this.setFieldValue(FLD_data, StringTools.truncate((String)v, (int)255));
    }

    public String toString() {
        return this.getServerID() + "/" + this.getMobileID();
    }

    public void setCreationDefaultValues() {
    }

    public static void add(String serverID, String mobileID) {
        UnassignedDevices.add(serverID, mobileID, 0L, null, false, 0.0, 0.0, null);
    }

    public static void add(String serverID, String mobileID, double latitude, double longitude) {
        UnassignedDevices.add(serverID, mobileID, 0L, null, false, latitude, longitude, null);
    }

    public static void add(String serverID, String mobileID, String ipAddress, boolean isDuplex, double latitude, double longitude) {
        UnassignedDevices.add(serverID, mobileID, 0L, ipAddress, isDuplex, latitude, longitude, null);
    }

    public static void add(String serverID, String mobileID, String ipAddress, boolean isDuplex, double latitude, double longitude, String data) {
        UnassignedDevices.add(serverID, mobileID, 0L, ipAddress, isDuplex, latitude, longitude, data);
    }

    public static void add(String serverID, String mobileID, long timestamp, String ipAddress, boolean isDuplex, double latitude, double longitude, String data) {
        try {
            Key rcdKey = new Key(serverID, mobileID);
            long ts = timestamp > 0L ? timestamp : DateTime.getCurrentTimeSec();
            boolean exists = rcdKey.exists();
            if (exists) {
                UnassignedDevices rcd = (UnassignedDevices)rcdKey.getDBRecord(true);
                rcd.setTimestamp(ts);
                rcd.setIpAddress(ipAddress);
                rcd.setIsDuplex(isDuplex);
                rcd.setLatitude(latitude);
                rcd.setLongitude(longitude);
                rcd.setData(data);
                rcd.update();
            } else {
                UnassignedDevices rcd = (UnassignedDevices)rcdKey.getDBRecord();
                rcd.setCreationDefaultValues();
                rcd.setTimestamp(ts);
                rcd.setIpAddress(ipAddress);
                rcd.setIsDuplex(isDuplex);
                rcd.setLatitude(latitude);
                rcd.setLongitude(longitude);
                rcd.setData(data);
                rcd.insert();
            }
        }
        catch (Throwable th) {
            Print.logException((String)"Unable to add UnknownDevice", (Throwable)th);
        }
    }

    public static void getRecordCallback(DBRecordHandler<UnassignedDevices> rcdHandler) throws DBException {
        DBSelect dsel = new DBSelect(UnassignedDevices.getFactory());
        DBRecord.select((DBSelect)dsel, rcdHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _iterate(DBRecordHandler<UnassignedDevices> rcdHandler) throws DBException {
        if (rcdHandler == null) {
            throw new DBException("Missing DBRecordHandler");
        }
        DBSelect dsel = new DBSelect(UnassignedDevices.getFactory());
        dsel.setOrderByFields(new String[]{FLD_serverID, FLD_mobileID});
        Statement stmt = null;
        ResultSet rs = null;
        try {
            DBRecord.select((DBSelect)dsel, rcdHandler);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    public static String GetMobileIDDevice(DCServerConfig dcsc, String mobileID) {
        block6: {
            Device device;
            if (StringTools.isBlank((String)mobileID)) {
                return null;
            }
            int p = mobileID.indexOf(ACCOUNT_DEVICE_SEP);
            if (p >= 0) {
                String accountID = mobileID.substring(0, p);
                String deviceID = mobileID.substring(p + ACCOUNT_DEVICE_SEP.length());
                try {
                    if (Transport.exists(accountID, deviceID)) {
                        return accountID + ACCOUNT_DEVICE_SEP + deviceID;
                    }
                    break block6;
                }
                catch (DBException dbe) {
                    Print.logException((String)"Transport 'exists' error", (Throwable)dbe);
                    return null;
                }
            }
            if (dcsc != null && (device = DCServerConfig.loadDeviceUniqueID(dcsc, mobileID)) != null) {
                return device.getAccountID() + ACCOUNT_DEVICE_SEP + device.getDeviceID() + "[" + device.getUniqueID() + "]";
            }
        }
        return null;
    }

    public static long udList() {
        final AccumulatorLong counter = new AccumulatorLong(0L);
        DBRecordHandler<UnassignedDevices> rcdHandler = new DBRecordHandler<UnassignedDevices>(){

            public int handleDBRecord(UnassignedDevices rcd) throws DBException {
                UnassignedDevices ud = rcd;
                String serverID = ud.getServerID();
                String mobileID = ud.getMobileID();
                long now = DateTime.getCurrentTimeSec();
                long time = ud.getTimestamp();
                String ipAddr = StringTools.trim((Object)((Object)ud.getIpAddress()));
                GeoPoint gp = ud.getGeoPoint();
                DCServerConfig dcsc = DCServerFactory._getServerConfig(serverID);
                long ageSec = now - time;
                String devStr = UnassignedDevices.GetMobileIDDevice(dcsc, mobileID);
                String exists = StringTools.blankDefault((String)devStr, (String)"false");
                StringBuffer sb = new StringBuffer();
                sb.append("ServerID=").append(serverID);
                sb.append(" MobileID=").append(mobileID);
                sb.append(" Time=").append(time);
                sb.append(" Age=").append(ageSec);
                if (!StringTools.isBlank((String)ipAddr)) {
                    sb.append(" IP=").append(ipAddr);
                }
                sb.append(" GPS=").append(gp.toString());
                sb.append(" Exists=").append(exists);
                Print.sysPrintln((String)sb.toString(), (Object[])new Object[0]);
                counter.increment();
                return 1;
            }
        };
        try {
            UnassignedDevices._iterate(rcdHandler);
        }
        catch (DBException dbe) {
            Print.logException((String)"Listing UnassignedDevices", (Throwable)dbe);
        }
        return counter.get();
    }

    public static void udUpdate(final boolean okDelete) {
        final Vector deleteList = new Vector();
        DBRecordHandler<UnassignedDevices> rcdHandler = new DBRecordHandler<UnassignedDevices>(){

            public int handleDBRecord(UnassignedDevices rcd) throws DBException {
                UnassignedDevices ud = rcd;
                String serverID = ud.getServerID();
                String mobileID = ud.getMobileID();
                DCServerConfig dcsc = DCServerFactory._getServerConfig(serverID);
                long ageSec = DateTime.getCurrentTimeSec() - ud.getTimestamp();
                if (MAX_AGE_SEC > 0L && ageSec > MAX_AGE_SEC) {
                    Print.logInfo((String)"Record exceeds maximum age: [%s] %s", (Object[])new Object[]{serverID, mobileID});
                    if (okDelete) {
                        deleteList.add(ud);
                    }
                    return 1;
                }
                String devStr = UnassignedDevices.GetMobileIDDevice(dcsc, mobileID);
                if (!StringTools.isBlank((String)devStr)) {
                    Print.logInfo((String)"Record is now defined: [%s] %s", (Object[])new Object[]{serverID, devStr});
                    if (okDelete) {
                        deleteList.add(ud);
                    }
                }
                return 1;
            }
        };
        try {
            UnassignedDevices._iterate(rcdHandler);
        }
        catch (DBException dbe) {
            Print.logException((String)"Listing UnassignedDevices", (Throwable)dbe);
        }
        if (!okDelete || !ListTools.isEmpty(deleteList)) {
            // empty if block
        }
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + UserAcl.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -list        List table contents", (Object[])new Object[0]);
        Print.logInfo((String)"  -update      Update unassigned devices", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        if (RTConfig.getBoolean((String[])ARG_LIST, (boolean)false)) {
            UnassignedDevices.udList();
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_UPDATE)) {
            boolean delete = RTConfig.getString((String[])ARG_UPDATE, (String)"").equals("delete");
            UnassignedDevices.udUpdate(delete);
            System.exit(0);
        }
        Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
        UnassignedDevices.usage();
    }

    public static class Key
    extends DBRecordKey<UnassignedDevices> {
        public Key() {
        }

        public Key(String serverId, String mobileId) {
            String sid = serverId != null ? serverId.toLowerCase() : "";
            String mid = DBRecord.adjustStringLength((String)mobileId, (int)MobileIDColumnLength).toLowerCase();
            super.setKeyValue(UnassignedDevices.FLD_serverID, (Object)sid);
            super.setKeyValue(UnassignedDevices.FLD_mobileID, (Object)mid);
        }

        public DBFactory<UnassignedDevices> getFactory() {
            return UnassignedDevices.getFactory();
        }
    }
}

