/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.tables;

import java.util.Locale;
import org.opengts.db.AccountRecord;
import org.opengts.db.Audit;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.dbtypes.DTIPAddress;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class SystemAudit
extends AccountRecord<SystemAudit> {
    private static Audit.AuditHandler auditHandler = null;
    public static final String _TABLE_NAME = "SystemAudit";
    public static final String FLD_auditTime = "auditTime";
    public static final String FLD_auditCode = "auditCode";
    public static final String FLD_userID = "userID";
    public static final String FLD_deviceID = "deviceID";
    public static final String FLD_ipAddress = "ipAddress";
    public static final String FLD_privateLabelName = "privateLabelName";
    private static DBField[] FieldInfo = new DBField[]{SystemAudit.newField_accountID(true), new DBField("auditTime", Long.TYPE, "INT32", "Audit timestamp", "key=true"), new DBField("auditCode", Integer.TYPE, "UINT16", "Audit Reason", "key=true"), new DBField("userID", String.class, DBField.TYPE_USER_ID(), "User ID", ""), new DBField("deviceID", String.class, DBField.TYPE_DEV_ID(), "Device ID", ""), new DBField("ipAddress", DTIPAddress.class, DBField.TYPE_STRING((int)32), "IP Address", ""), new DBField("privateLabelName", String.class, DBField.TYPE_STRING((int)32), "PrivateLabel Name", ""), SystemAudit.newField_description(), SystemAudit.newField_notes(), SystemAudit.newField_creationTime()};
    private static DBFactory<SystemAudit> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_ADD = new String[]{"add"};
    private static final String[] ARG_DELETE = new String[]{"delete"};

    private static void initAuditHandler() {
        if (auditHandler == null) {
            Print.logDebug((String)"Initializing AuditHandler ...", (Object[])new Object[0]);
            auditHandler = new Audit.AuditHandler(){

                @Override
                public void addAuditEntry(String accountID, long auditTime, int auditCode, String userID, String deviceID, String ipAddress, String privateLabelName, String notes) {
                    SystemAudit.AddAudit(accountID, auditTime, auditCode, userID, deviceID, ipAddress, privateLabelName, notes);
                }
            };
            Audit.SetAuditHandler(auditHandler);
        }
    }

    public static void AddAudit(String accountID, long auditTime, int auditCode, String userID, String deviceID, String ipAddress, String privateLabelName, String notes) {
        long timeSec;
        long l = timeSec = auditTime > 0L ? auditTime : DateTime.getCurrentTimeSec();
        if (StringTools.isBlank((String)userID)) {
            userID = DBRecord.GetCurrentUser();
        }
        Key key = new Key(accountID, timeSec, auditCode);
        SystemAudit audit = (SystemAudit)key.getDBRecord();
        audit.setCreationDefaultValues();
        audit.setUserID(userID);
        audit.setDeviceID(deviceID);
        audit.setIpAddress(ipAddress);
        audit.setPrivateLabelName(privateLabelName);
        try {
            audit.save();
        }
        catch (DBException dbe) {
            Print.logError((String)("Error saving SystemAudit record: " + (Object)((Object)dbe)), (Object[])new Object[0]);
        }
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<SystemAudit> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)SystemAudit.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, SystemAudit.class, Key.class, (boolean)false, (boolean)true);
            SystemAudit.initAuditHandler();
        }
        return factory;
    }

    public SystemAudit() {
    }

    public SystemAudit(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(SystemAudit.class, (Locale)loc);
        return i18n.getString("SystemAudit.description", "This table contains GTS System Audit information");
    }

    public long getAuditTime() {
        Long v = (Long)this.getFieldValue(FLD_auditTime);
        return v != null ? v : 0L;
    }

    public void setAuditTime(long v) {
        this.setFieldValue(FLD_auditTime, v);
    }

    public int getAuditCode() {
        Integer v = (Integer)this.getFieldValue(FLD_auditCode);
        return v != null ? v : 0;
    }

    public void setAuditCode(int v) {
        this.setFieldValue(FLD_auditCode, v);
    }

    public String getUserID() {
        String v = (String)this.getFieldValue(FLD_userID);
        return v != null ? v : "";
    }

    private void setUserID(String v) {
        this.setFieldValue(FLD_userID, v != null ? v : "");
    }

    public final String getDeviceID() {
        String v = (String)this.getFieldValue(FLD_deviceID);
        return v != null ? v : "";
    }

    public void setDeviceID(String v) {
        this.setFieldValue(FLD_deviceID, v != null ? v : "");
    }

    public DTIPAddress getIpAddress() {
        DTIPAddress v = (DTIPAddress)((Object)this.getFieldValue(FLD_ipAddress));
        return v;
    }

    public void setIpAddress(DTIPAddress v) {
        this.setFieldValue(FLD_ipAddress, (Object)v);
    }

    public void setIpAddress(String v) {
        this.setIpAddress(v != null ? new DTIPAddress(v) : null);
    }

    public String getPrivateLabelName() {
        String v = (String)this.getFieldValue(FLD_privateLabelName);
        return StringTools.trim((String)v);
    }

    public void setPrivateLabelName(String v) {
        this.setFieldValue(FLD_privateLabelName, StringTools.trim((String)v));
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getAuditTime() + "/" + this.getAuditCode();
    }

    public static void getRecordCallback(DBRecordHandler<SystemAudit> rcdHandler, String accountID, int auditCode, long startTime, long endTime, long limit) throws DBException {
        if (startTime > 0L && endTime > 0L && startTime > endTime) {
            return;
        }
        DBSelect dsel = new DBSelect(SystemAudit.getFactory());
        dsel.setOrderByFields(new String[]{FLD_auditTime});
        dsel.setOrderAscending(true);
        dsel.setLimit(limit);
        DBWhere dwh = new DBWhere(SystemAudit.getFactory());
        dwh.append(dwh.AND(dwh.EQ("accountID", (Object)StringTools.trim((String)accountID)), dwh.EQ(FLD_auditCode, auditCode)));
        if (startTime >= 0L) {
            dwh.append(dwh.AND_(dwh.GE(FLD_auditTime, startTime)));
        }
        if (endTime >= 0L && endTime >= startTime) {
            dwh.append(dwh.AND_(dwh.LE(FLD_auditTime, endTime)));
        }
        dsel.setWhere(dwh.toString());
        DBRecord.select((DBSelect)dsel, rcdHandler);
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + SystemAudit.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>           Acount ID which owns the specified Device", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<id>            Device ID to apply pending commands", (Object[])new Object[0]);
        Print.logInfo((String)"  -list                   List all pending commands for Device", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete=<time>          Delete pending commands for Device", (Object[])new Object[0]);
        Print.logInfo((String)"  -add=<cmd>              Add pending command for Device", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String devID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        if (StringTools.isBlank((String)acctID)) {
            Print.sysPrintln((String)"ERROR: Account-ID not specified.", (Object[])new Object[0]);
            SystemAudit.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(acctID);
            if (account == null) {
                Print.sysPrintln((String)("ERROR: Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                SystemAudit.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        if (StringTools.isBlank((String)devID)) {
            Print.sysPrintln((String)"ERROR: Device-ID not specified.", (Object[])new Object[0]);
            SystemAudit.usage();
        }
        Device device = null;
        try {
            device = Device.getDevice(account, devID, false);
            if (device == null) {
                Print.sysPrintln((String)("ERROR: Device-ID does not exist: " + devID), (Object[])new Object[0]);
                SystemAudit.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Device: " + devID), (Throwable)dbe);
            System.exit(99);
        }
        boolean opts = false;
        if (!opts) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            SystemAudit.usage();
        }
    }

    public static class Key
    extends AccountRecord.AccountKey<SystemAudit> {
        public Key() {
        }

        public Key(String accountID, long auditTime, int auditCode) {
            super.setKeyValue("accountID", (Object)accountID);
            super.setKeyValue(SystemAudit.FLD_auditTime, auditTime);
            super.setKeyValue(SystemAudit.FLD_auditCode, auditCode);
        }

        public DBFactory<SystemAudit> getFactory() {
            return SystemAudit.getFactory();
        }
    }
}

