/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.tables;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.SessionStatsFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.UserAcl;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBDelete;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.dbtypes.DTIPAddress;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class SessionStats
extends DeviceRecord<SessionStats> {
    public static long UDP_OVERHEAD = 28L;
    public static long TCP_OVERHEAD = 44L;
    public static long TCP_SESSION_OVERHEAD = 240L;
    private static SessionStatsFactory statsFactory = null;
    public static final String _TABLE_NAME = "SessionStats";
    public static final String FLD_timestamp = "timestamp";
    public static final String FLD_ipAddress = "ipAddress";
    public static final String FLD_isDuplex = "isDuplex";
    public static final String FLD_bytesRead = "bytesRead";
    public static final String FLD_bytesWritten = "bytesWritten";
    public static final String FLD_bytesOverhead = "bytesOverhead";
    public static final String FLD_bytesRounded = "bytesRounded";
    public static final String FLD_eventsReceived = "eventsReceived";
    private static DBField[] FieldInfo = new DBField[]{AccountRecord.newField_accountID(true), DeviceRecord.newField_deviceID(true), new DBField("timestamp", Long.TYPE, "UINT32", "Timestamp", "key=true"), new DBField("ipAddress", DTIPAddress.class, DBField.TYPE_STRING((int)32), "IP Address", null), new DBField("isDuplex", Boolean.TYPE, "BOOLEAN", "Is Duplex", null), new DBField("bytesRead", Long.TYPE, "UINT32", "Bytes Read", null), new DBField("bytesWritten", Long.TYPE, "UINT32", "Bytes Written", null), new DBField("bytesOverhead", Long.TYPE, "UINT32", "Bytes Overhead", null), new DBField("bytesRounded", Long.TYPE, "UINT32", "Bytes Rounded", null), new DBField("eventsReceived", Long.TYPE, "UINT32", "Events Received", null), SessionStats.newField_creationTime()};
    private static DBFactory<SessionStats> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_COUNT = new String[]{"count"};
    private static final String[] ARG_TRIM = new String[]{"trim"};
    private static final String[] ARG_CALC = new String[]{"calc"};

    private static void initSessionStatsFactory() {
        if (statsFactory == null) {
            Print.logDebug((String)"Initializing SessionStatsFactory ...", (Object[])new Object[0]);
            statsFactory = new SessionStatsFactory(){

                @Override
                public void addSessionStatistic(Device device, long timestamp, String ipAddr, boolean isDuplex, long bytesRead, long bytesWritten, long eventsRecv) throws DBException {
                    SessionStats.addStatistic(device, timestamp, ipAddr, isDuplex, bytesRead, bytesWritten, eventsRecv);
                }

                @Override
                public long[] getByteCounts(Device device, long timeStart, long timeEnd) throws DBException {
                    return SessionStats.getByteCounts(device, timeStart, timeEnd);
                }

                @Override
                public long[] getConnectionCounts(Device device, long timeStart, long timeEnd) throws DBException {
                    return SessionStats.getConnectionCounts(device, timeStart, timeEnd);
                }
            };
            Device.setSessionStatsFactory(statsFactory);
        }
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<SessionStats> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)SessionStats.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, SessionStats.class, Key.class, (boolean)false, (boolean)false);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
            SessionStats.initSessionStatsFactory();
        }
        return factory;
    }

    public SessionStats() {
    }

    public SessionStats(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(SessionStats.class, (Locale)loc);
        return i18n.getString("SessionStats.description", "This table contains Device specific session connection statistics.");
    }

    public long getTimestamp() {
        Long v = (Long)this.getFieldValue(FLD_timestamp);
        return v != null ? v : 0L;
    }

    public void setTimestamp(long v) {
        this.setFieldValue(FLD_timestamp, v);
    }

    public DTIPAddress getIpAddress() {
        DTIPAddress v = (DTIPAddress)((Object)this.getFieldValue(FLD_ipAddress));
        return v;
    }

    public void setIpAddress(DTIPAddress v) {
        this.setFieldValue(FLD_ipAddress, (Object)v);
    }

    public void setIpAddress(String v) {
        this.setIpAddress(v != null ? new DTIPAddress(v) : null);
    }

    public boolean getIsDuplex() {
        Boolean v = (Boolean)this.getFieldValue(FLD_isDuplex);
        return v != null ? v : false;
    }

    public void setIsDuplex(boolean v) {
        this.setFieldValue(FLD_isDuplex, v);
    }

    public boolean isDuplex() {
        return this.getIsDuplex();
    }

    public long getBytesRead() {
        Long v = (Long)this.getFieldValue(FLD_bytesRead);
        return v != null ? v : 0L;
    }

    public void setBytesRead(long v) {
        this.setFieldValue(FLD_bytesRead, v);
    }

    public long getBytesWritten() {
        Long v = (Long)this.getFieldValue(FLD_bytesWritten);
        return v != null ? v : 0L;
    }

    public void setBytesWritten(long v) {
        this.setFieldValue(FLD_bytesWritten, v);
    }

    public long getBytesOverhead() {
        Long v = (Long)this.getFieldValue(FLD_bytesOverhead);
        return v != null ? v : 0L;
    }

    public void setBytesOverhead(long v) {
        this.setFieldValue(FLD_bytesOverhead, v);
    }

    public long getBytesRounded() {
        Long v = (Long)this.getFieldValue(FLD_bytesRounded);
        return v != null ? v : 0L;
    }

    public void setBytesRounded(long v) {
        this.setFieldValue(FLD_bytesRounded, v);
    }

    public long getEventsReceived() {
        Long v = (Long)this.getFieldValue(FLD_eventsReceived);
        return v != null ? v : 0L;
    }

    public void setEventsReceived(long v) {
        this.setFieldValue(FLD_eventsReceived, v);
    }

    public static void addStatistic(Device device, long timestamp, String ipAddr, boolean isDuplex, long bytesRead, long bytesWritten, long eventsRecv) throws DBException {
        if (device != null) {
            String a = device.getAccountID();
            String d = device.getDeviceID();
            SessionStats.addStatistic(a, d, timestamp, ipAddr, isDuplex, bytesRead, bytesWritten, eventsRecv);
        }
    }

    public static void addStatistic(String acctID, String devID, long timestamp, String ipAddr, boolean isDuplex, long bytesRead, long bytesWritten, long eventsRecv) throws DBException {
        Key connKey = new Key(acctID, devID, timestamp);
        SessionStats conn = (SessionStats)connKey.getDBRecord();
        conn.setIpAddress(ipAddr);
        conn.setIsDuplex(isDuplex);
        conn.setBytesRead(bytesRead);
        conn.setBytesWritten(bytesWritten);
        conn.setEventsReceived(eventsRecv);
        long overhead = isDuplex ? TCP_OVERHEAD * 2L + TCP_SESSION_OVERHEAD : UDP_OVERHEAD;
        conn.setBytesOverhead(overhead);
        long rounded = (bytesRead + bytesWritten + overhead + 1023L) / 1024L * 1024L;
        conn.setBytesRounded(rounded);
        conn.save();
    }

    public static long[] getConnectionCounts(Device dev, long timeStart, long timeEnd) {
        if (dev == null) {
            return null;
        }
        String acctID = dev.getAccountID();
        String devID = dev.getDeviceID();
        if (timeStart <= 0L) {
            timeStart = 1L;
        }
        if (timeEnd <= 0L) {
            timeEnd = Long.MAX_VALUE;
        }
        if (timeEnd < timeStart) {
            return null;
        }
        long[] count = new long[]{-1L, -1L};
        DBWhere dwhTCP = new DBWhere(SessionStats.getFactory());
        dwhTCP.append(dwhTCP.AND(dwhTCP.EQ("accountID", (Object)acctID), dwhTCP.EQ("deviceID", (Object)devID), dwhTCP.EQ(FLD_isDuplex, true), dwhTCP.GE(FLD_timestamp, timeStart), dwhTCP.LE(FLD_timestamp, timeEnd)));
        try {
            count[0] = DBRecord.getRecordCount(SessionStats.getFactory(), (String)dwhTCP.WHERE(dwhTCP.toString()));
        }
        catch (DBException dbe) {
            Print.logException((String)"Counting TCP Connections", (Throwable)dbe);
        }
        DBWhere dwhUDP = new DBWhere(SessionStats.getFactory());
        dwhUDP.append(dwhUDP.AND(dwhUDP.EQ("accountID", (Object)acctID), dwhUDP.EQ("deviceID", (Object)devID), dwhUDP.EQ(FLD_isDuplex, false), dwhUDP.GE(FLD_timestamp, timeStart), dwhUDP.LE(FLD_timestamp, timeEnd)));
        try {
            count[1] = DBRecord.getRecordCount(SessionStats.getFactory(), (String)dwhUDP.WHERE(dwhUDP.toString()));
        }
        catch (DBException dbe) {
            Print.logException((String)"Counting UDP Connections", (Throwable)dbe);
        }
        return count;
    }

    public static long[] getByteCounts(Device dev, long timeStart, long timeEnd) throws DBException {
        if (dev == null) {
            return null;
        }
        String acctID = dev.getAccountID();
        String devID = dev.getDeviceID();
        return SessionStats.getByteCounts(acctID, devID, timeStart, timeEnd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long[] getByteCounts(String acctID, String devID, long timeStart, long timeEnd) throws DBException {
        Statement stmt;
        DBConnection dbc;
        long[] byteCount;
        block20: {
            if (acctID == null) return null;
            if (devID == null) {
                return null;
            }
            if (timeStart <= 0L) {
                timeStart = 1L;
            }
            if (timeEnd <= 0L) {
                timeEnd = Long.MAX_VALUE;
            }
            if (timeEnd < timeStart) {
                return null;
            }
            String SUM_bytesRead = DBProvider.FLD_SUM((String)FLD_bytesRead);
            String SUM_bytesWritten = DBProvider.FLD_SUM((String)FLD_bytesWritten);
            String SUM_bytesOverhead = DBProvider.FLD_SUM((String)FLD_bytesOverhead);
            String SUM_bytesRounded = DBProvider.FLD_SUM((String)FLD_bytesRounded);
            byteCount = null;
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(SessionStats.getFactory());
                dsel.setSelectedFields(new String[]{SUM_bytesRead, SUM_bytesWritten, SUM_bytesOverhead, SUM_bytesRounded});
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctID), dwh.EQ("deviceID", (Object)devID), dwh.GE(FLD_timestamp, timeStart), dwh.LE(FLD_timestamp, timeEnd))));
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                if (rs.next()) {
                    long sumBytesRead = rs.getLong(SUM_bytesRead);
                    long sumBytesWritten = rs.getLong(SUM_bytesWritten);
                    long sumBytesOverhead = rs.getLong(SUM_bytesOverhead);
                    long sumBytesRounded = rs.getLong(SUM_bytesRounded);
                    byteCount = new long[]{sumBytesRead, sumBytesWritten, sumBytesOverhead, sumBytesRounded};
                }
                if (rs == null) break block20;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Get Byte Count", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return byteCount;
    }

    public static void deleteRange(Device device, long timeStart, long timeEnd) throws DBException {
        if (device == null) {
            return;
        }
        String acctID = device.getAccountID();
        String devID = device.getDeviceID();
        SessionStats.deleteRange(acctID, devID, timeStart, timeEnd);
    }

    public static void deleteRange(String acctID, String devID, long timeStart, long timeEnd) throws DBException {
        if (acctID == null || devID == null) {
            return;
        }
        if (timeStart <= 0L) {
            timeStart = 1L;
        }
        if (timeEnd <= 0L) {
            timeEnd = Long.MAX_VALUE;
        }
        if (timeEnd < timeStart) {
            return;
        }
        DBDelete ddel = new DBDelete(SessionStats.getFactory());
        DBWhere dwh = ddel.createDBWhere();
        ddel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctID), dwh.EQ("deviceID", (Object)devID), dwh.GE(FLD_timestamp, timeStart), dwh.LE(FLD_timestamp, timeEnd))));
        DBConnection dbc = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            dbc.executeUpdate(ddel.toString());
        }
        catch (SQLException sqe) {
            throw new DBException("Deleting SessionStats range", (Throwable)sqe);
        }
        finally {
            DBConnection.release((DBConnection)dbc);
        }
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getDeviceID() + "/" + this.getTimestamp();
    }

    public void setCreationDefaultValues() {
    }

    protected void recordWillInsert() {
    }

    protected void recordDidInsert() {
    }

    protected void recordWillUpdate() {
    }

    protected void recordDidUpdate() {
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + UserAcl.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>      Acount ID which owns SessionStats", (Object[])new Object[0]);
        Print.logInfo((String)"  -count[=<deltaMo>] Return byte counts for current month", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        int d;
        int deltaMo;
        String acctID;
        DBConfig.cmdLineInit(args, true);
        if (RTConfig.hasProperty((String[])ARG_CALC)) {
            String[] calc = StringTools.parseArray((String)RTConfig.getString((String[])ARG_CALC, (String)""), (char)',');
            if (calc.length < 3) {
                Print.logError((String)"Missing 'calc' arguments: udp|tcp,eventsPerSession,inMotionInterval", (Object[])new Object[0]);
                System.exit(1);
            }
            String tcpUdp = calc[0];
            long eventsPerSession = StringTools.parseLong((String)calc[1], (long)1L);
            long inMotionInterval = StringTools.parseLong((String)calc[2], (long)DateTime.MinuteSeconds((long)3L));
            long pdpRounding = 1024L;
            long dmtpOverhead = 26L;
            long dmtpEventSize = 60L;
            long inMotionDuration = DateTime.HourSeconds((long)12L);
            long dormantInterval = DateTime.MinuteSeconds((long)60L);
            long dormantCount = 2L;
            long stopsPerDay = 6L;
            long extraEventsPerDay = 0L;
            long daysPerMonth = 23L;
            long eventsPerDay = 0L;
            eventsPerDay += inMotionDuration / inMotionInterval;
            if (dormantCount >= 0L) {
                eventsPerDay += dormantCount;
            } else {
                long dormantDuration = DateTime.DaySeconds((long)1L) - inMotionDuration;
                eventsPerDay += dormantDuration / dormantInterval;
            }
            eventsPerDay += stopsPerDay * 4L;
            eventsPerDay += extraEventsPerDay;
            Print.sysPrintln((String)("InMotion interval : " + inMotionInterval), (Object[])new Object[0]);
            Print.sysPrintln((String)("InMotion duration : " + inMotionDuration), (Object[])new Object[0]);
            Print.sysPrintln((String)("Dormant interval  : " + dormantInterval), (Object[])new Object[0]);
            Print.sysPrintln((String)("Dormant count     : " + dormantCount), (Object[])new Object[0]);
            Print.sysPrintln((String)("Stops per day     : " + stopsPerDay), (Object[])new Object[0]);
            Print.sysPrintln((String)("Events per day    : " + eventsPerDay), (Object[])new Object[0]);
            if (calc[0].equalsIgnoreCase("udp")) {
                long udpEventsPerSession = eventsPerSession;
                long udpSessionsPerDay = eventsPerDay / udpEventsPerSession;
                long udpSessionOverhead = UDP_OVERHEAD;
                long udpSessionSize = udpSessionOverhead + dmtpOverhead + udpEventsPerSession * dmtpEventSize;
                long udpRoundedSize = (udpSessionSize + (pdpRounding - 1L)) / pdpRounding * pdpRounding;
                Print.sysPrintln((String)("Sessions per day  : " + udpSessionsPerDay), (Object[])new Object[0]);
                Print.sysPrintln((String)("Events per session: " + udpEventsPerSession), (Object[])new Object[0]);
                Print.sysPrintln((String)("UDP bytes per day : " + udpRoundedSize * udpSessionsPerDay), (Object[])new Object[0]);
                Print.sysPrintln((String)("UDP bytes per mon : " + udpRoundedSize * udpSessionsPerDay * daysPerMonth), (Object[])new Object[0]);
            } else if (calc[0].equalsIgnoreCase("tcp")) {
                long tcpEventsPerSession = eventsPerSession;
                long tcpSessionsPerDay = eventsPerDay / tcpEventsPerSession;
                long tcpSessionOverhead = TCP_OVERHEAD * 2L + TCP_SESSION_OVERHEAD;
                long tcpSessionSize = tcpSessionOverhead + dmtpOverhead + tcpEventsPerSession * dmtpEventSize;
                long tcpRoundedSize = (tcpSessionSize + (pdpRounding - 1L)) / pdpRounding * pdpRounding;
                Print.sysPrintln((String)("Sessions per day  : " + tcpSessionsPerDay), (Object[])new Object[0]);
                Print.sysPrintln((String)("Events per session: " + tcpEventsPerSession), (Object[])new Object[0]);
                Print.sysPrintln((String)("TCP bytes per day : " + tcpRoundedSize * tcpSessionsPerDay), (Object[])new Object[0]);
                Print.sysPrintln((String)("TCP bytes per mon : " + tcpRoundedSize * tcpSessionsPerDay * daysPerMonth), (Object[])new Object[0]);
            } else {
                Print.logError((String)("Invalid 'calc' arguments: " + RTConfig.getString((String[])ARG_CALC, (String)"")), (Object[])new Object[0]);
            }
            System.exit(0);
        }
        if ((acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"")) == null || acctID.equals("")) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            SessionStats.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(acctID);
            if (account == null) {
                Print.logError((String)("Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                SessionStats.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        OrderedSet<String> devList = null;
        try {
            devList = Device.getDeviceIDsForAccount(acctID, null, true);
        }
        catch (DBException dbe) {
            Print.logException((String)"Unable to obtain Device list for Account", (Throwable)dbe);
            System.exit(99);
        }
        int opts = 0;
        if (RTConfig.getBoolean((String[])ARG_COUNT, (boolean)false)) {
            ++opts;
            DateTime nowDate = account.getCurrentDateTime();
            deltaMo = RTConfig.getInt((String[])ARG_TRIM, (int)0);
            if (deltaMo > 0) {
                deltaMo = 0;
            }
            DateTime fromDate = new DateTime(nowDate.getMonthStart(deltaMo));
            for (d = 0; d < devList.size(); ++d) {
                String devID = (String)devList.get(0);
                try {
                    long[] bc = SessionStats.getByteCounts(acctID, devID, fromDate.getTimeSec(), -1L);
                    if (bc != null) {
                        String ds = StringTools.leftAlign((String)devID, (int)16);
                        Print.logInfo((String)("Device: " + ds + " => R=" + bc[0] + ", W=" + bc[1] + ", O=" + bc[2] + ", R=" + bc[3]), (Object[])new Object[0]);
                        continue;
                    }
                    Print.logError((String)"Error retrieving counts", (Object[])new Object[0]);
                    System.exit(2);
                    continue;
                }
                catch (DBException dbe) {
                    Print.logException((String)"Error obtaining SessionStats byte count", (Throwable)dbe);
                    System.exit(1);
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_TRIM)) {
            ++opts;
            DateTime nowDate = account.getCurrentDateTime();
            deltaMo = RTConfig.getInt((String[])ARG_TRIM, (int)-2);
            if (deltaMo > 0) {
                deltaMo = 0;
            }
            DateTime upToDate = new DateTime(nowDate.getMonthEnd(deltaMo - 1));
            Print.logInfo((String)("Deleting SessionStats records up to " + upToDate), (Object[])new Object[0]);
            for (d = 0; d < devList.size(); ++d) {
                String devID = (String)devList.get(0);
                Print.logInfo((String)("  => Trimming '" + devID + "' ..."), (Object[])new Object[0]);
                try {
                    SessionStats.deleteRange(acctID, devID, -1L, upToDate.getTimeSec());
                    continue;
                }
                catch (DBException dbe) {
                    Print.logException((String)"Unable to delete SessionStats records", (Throwable)dbe);
                    System.exit(1);
                }
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            SessionStats.usage();
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<SessionStats> {
        public Key() {
        }

        public Key(String acctId, String devId, long timestamp) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)(devId != null ? devId.toLowerCase() : ""));
            super.setKeyValue(SessionStats.FLD_timestamp, timestamp);
        }

        public DBFactory<SessionStats> getFactory() {
            return SessionStats.getFactory();
        }
    }
}

