/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.tables;

import java.io.EOFException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.opengts.db.AccountRecord;
import org.opengts.db.DBConfig;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.User;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.extra.service.GTSServiceRequest;
import org.opengts.extra.service.ServiceMessage;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.SendMail;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ReportJob
extends AccountRecord<ReportJob> {
    public static final String CRONTAG_NONE = "none";
    public static final String CRONTAG_DAILY = "daily";
    public static final String CRONTAG_WEEKLY = "weekly";
    private static Map<String, IntervalTag> _IntervalTagMap = new OrderedMap();
    public static final String _TABLE_NAME = "ReportJob";
    public static final String FLD_reportJobID = "reportJobID";
    public static final String FLD_reportName = "reportName";
    public static final String FLD_reportOption = "reportOption";
    public static final String FLD_deviceID = "deviceID";
    public static final String FLD_groupID = "groupID";
    public static final String FLD_reportTimeFrom = "reportTimeFrom";
    public static final String FLD_reportTimeTo = "reportTimeTo";
    public static final String FLD_reportFormat = "reportFormat";
    public static final String FLD_recipients = "recipients";
    public static final String FLD_intervalTag = "intervalTag";
    public static final String FLD_lastReportTime = "lastReportTime";
    private static DBField[] FieldInfo;
    private static DBFactory<ReportJob> factory;
    private static final String SELECT_ALL = "ALL";
    private static final String SELECT_NONE = "NONE";
    private static final String[] ARG_URL;
    private static final String[] ARG_VERSBOSE;
    private static final String[] ARG_QUIET;
    private static final String[] ARG_ACCOUNT;
    private static final String[] ARG_TAG;
    private static final String[] ARG_NOEMAIL;
    private static final String[] ARG_ERROR_EMAIL;
    private static final String[] ARG_REPORTJOB;
    private static final String[] ARG_DELETE;
    private static final String[] ARG_CREATE;
    private static final String[] ARG_EDIT;
    private static final String[] ARG_EDITALL;
    private static final String[] ARG_LIST_TAGS;
    private static final String[] ARG_LIST;
    private static final String[] ARG_CRON;

    public static Map<String, IntervalTag> GetIntervalTagMap() {
        return _IntervalTagMap;
    }

    public static boolean HasIntervalTagID(String tagID) {
        return _IntervalTagMap.containsKey(tagID);
    }

    public static void AddIntervalTag(IntervalTag tagInt) {
        String tagID;
        String string = tagID = tagInt != null ? tagInt.getTagID() : null;
        if (!StringTools.isBlank((String)tagID)) {
            _IntervalTagMap.put(tagID, tagInt);
        }
    }

    public static void AddIntervalTag(String tagID, I18N.Text desc, String frTime, String toTime) {
        if (!StringTools.isBlank((String)tagID)) {
            ReportJob.AddIntervalTag(new IntervalTag(tagID, desc, frTime, toTime));
        }
    }

    public static void AddIntervalTag(String tagID, String desc, String frTime, String toTime) {
        ReportJob.AddIntervalTag(tagID, new I18N.Text(desc), frTime, toTime);
    }

    public static String GetIntervalTagDescription(String tagID, Locale locale) {
        IntervalTag rit = ReportJob.GetIntervalTagMap().get(tagID);
        return rit != null ? rit.toString(locale) : tagID;
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<ReportJob> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)ReportJob.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, ReportJob.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
        }
        return factory;
    }

    public ReportJob() {
    }

    public ReportJob(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(ReportJob.class, (Locale)loc);
        return i18n.getString("ReportJob.description", "This table contains Account specific 'ReportJob' (ie. periodic reports) information.");
    }

    public String getReportJobID() {
        String v = (String)this.getFieldValue(FLD_reportJobID);
        return v != null ? v : "";
    }

    public void setReportJobID(String v) {
        this.setFieldValue(FLD_reportJobID, v != null ? v : "");
    }

    public String getReportName() {
        String v = (String)this.getFieldValue(FLD_reportName);
        return v != null ? v : "";
    }

    public void setReportName(String v) {
        this.setFieldValue(FLD_reportName, v != null ? v : "");
    }

    public boolean hasReportName() {
        return !StringTools.isBlank((String)this.getReportName());
    }

    public String getReportOption() {
        String v = (String)this.getFieldValue(FLD_reportOption);
        return v != null ? v : "";
    }

    public void setReportOption(String v) {
        this.setFieldValue(FLD_reportOption, v != null ? v : "");
    }

    public String getDeviceID() {
        String v = (String)this.getFieldValue(FLD_deviceID);
        return v != null ? v : "";
    }

    public void setDeviceID(String v) {
        this.setFieldValue(FLD_deviceID, v != null ? v : "");
    }

    public String getGroupID() {
        String v = (String)this.getFieldValue(FLD_groupID);
        return v != null ? v : "";
    }

    public void setGroupID(String v) {
        this.setFieldValue(FLD_groupID, v != null ? v : "");
    }

    public String getReportTimeFrom() {
        String v = (String)this.getFieldValue(FLD_reportTimeFrom);
        return v != null ? v : "";
    }

    public void setReportTimeFrom(String v) {
        this.setFieldValue(FLD_reportTimeFrom, v != null ? v : "");
    }

    public String getReportTimeTo() {
        String v = (String)this.getFieldValue(FLD_reportTimeTo);
        return v != null ? v : "";
    }

    public void setReportTimeTo(String v) {
        this.setFieldValue(FLD_reportTimeTo, v != null ? v : "");
    }

    public String getReportFormat() {
        String v = (String)this.getFieldValue(FLD_reportFormat);
        return v != null ? v : "";
    }

    public String getReportFormat(String dft) {
        String fmt = this.getReportFormat();
        return !StringTools.isBlank((String)fmt) ? fmt : dft;
    }

    public void setReportFormat(String v) {
        this.setFieldValue(FLD_reportFormat, v != null ? v : "");
    }

    public String getRecipients() {
        String v = (String)this.getFieldValue(FLD_recipients);
        return v != null ? v : "";
    }

    public void setRecipients(String v) {
        this.setFieldValue(FLD_recipients, v != null ? v : "");
    }

    public String getIntervalTag() {
        String v = (String)this.getFieldValue(FLD_intervalTag);
        return v != null ? v : "";
    }

    public void setIntervalTag(String v) {
        this.setFieldValue(FLD_intervalTag, v != null ? v : "");
    }

    public long getLastReportTime() {
        Long v = (Long)this.getFieldValue(FLD_lastReportTime);
        return v != null ? v : 0L;
    }

    public void setLastReportTime(long v) {
        this.setFieldValue(FLD_lastReportTime, v);
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getReportJobID();
    }

    public void setCreationDefaultValues() {
        super.setRuntimeDefaultValues();
        this.setIntervalTag(CRONTAG_NONE);
        this.setIsActive(false);
        this.setDescription("");
        this.setReportFormat("email");
    }

    public static ReportJob[] getReportJobsForAccount(String accountID) throws DBException {
        return ReportJob.getReportJobsForAccount(accountID, -1L, null);
    }

    public static ReportJob[] getReportJobsForAccount(String accountID, long limit, DBRecordHandler<ReportJob> handler) throws DBException {
        DBSelect jsel = new DBSelect(ReportJob.getFactory());
        DBWhere jwh = jsel.createDBWhere();
        jsel.setWhere(jwh.WHERE(jwh.EQ("accountID", (Object)accountID)));
        jsel.setOrderByFields(new String[]{FLD_reportJobID});
        if (limit > 0L) {
            jsel.setLimit(limit);
        }
        return (ReportJob[])DBRecord.select((DBSelect)jsel, handler);
    }

    public static OrderedSet<String> getReportJobIDsForAccount(String accountID, boolean activeOnly) throws DBException {
        return ReportJob.getReportJobIDsForAccount(accountID, null, activeOnly, -1L, null);
    }

    public static OrderedSet<String> getReportJobIDsForAccount(String accountID, String tagID, boolean activeOnly) throws DBException {
        return ReportJob.getReportJobIDsForAccount(accountID, tagID, activeOnly, -1L, null);
    }

    public static OrderedSet<String> getReportJobIDsForAccount(String accountID, String tagID, boolean activeOnly, long limit) throws DBException {
        return ReportJob.getReportJobIDsForAccount(accountID, tagID, activeOnly, limit, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OrderedSet<String> getReportJobIDsForAccount(String accountID, String tagIDs, boolean activeOnly, long limit, DBRecordHandler<ReportJob> handler) throws DBException {
        Statement stmt;
        DBConnection dbc;
        OrderedSet rjList;
        block22: {
            if (StringTools.isBlank((String)accountID)) {
                Print.logError((String)"Account not specified!", (Object[])new Object[0]);
                return new OrderedSet();
            }
            Object[] tagID = null;
            if (!StringTools.isBlank((String)tagIDs)) {
                if (tagIDs.indexOf(",") >= 0) {
                    Vector<String> idList = new Vector<String>();
                    for (String id : StringTools.split((String)tagIDs, (char)',')) {
                        if (StringTools.isBlank((String)id)) continue;
                        idList.add(id);
                    }
                    if (ListTools.isEmpty(idList)) {
                        Print.logError((String)("Invalid tag specification: " + tagIDs), (Object[])new Object[0]);
                        return new OrderedSet();
                    }
                    tagID = idList.toArray(new String[idList.size()]);
                } else {
                    tagID = new String[]{tagIDs};
                }
            }
            rjList = new OrderedSet();
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect jsel = new DBSelect(ReportJob.getFactory());
                jsel.setSelectedFields(new String[]{"accountID", FLD_reportJobID, "isActive", FLD_intervalTag});
                DBWhere jwh = jsel.createDBWhere();
                jsel.setWhere(jwh.WHERE(jwh.AND(jwh.EQ("accountID", (Object)accountID), tagID != null ? jwh.INLIST(FLD_intervalTag, tagID) : null, activeOnly ? jwh.EQ("isActive", true) : null, activeOnly ? jwh.NE(FLD_reportName, (Object)"") : null)));
                jsel.setOrderByFields(new String[]{FLD_reportJobID});
                jsel.setLimit(limit);
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(jsel.toString());
                rs = stmt.getResultSet();
                while (rs.next()) {
                    String rjId = rs.getString(FLD_reportJobID);
                    rjList.add((Object)rjId);
                }
                if (rs == null) break block22;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Getting Account ReportJob List", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return rjList;
    }

    public static boolean exists(String accountID, String reportJobID) throws DBException {
        if (accountID != null && reportJobID != null) {
            Key rjKey = new Key(accountID, reportJobID);
            return rjKey.exists();
        }
        return false;
    }

    public static ReportJob getReportJob(Account account, String reportJobID, boolean createOK) throws DBException {
        if (account == null) {
            throw new DBException("Account not specified.");
        }
        if (StringTools.isBlank((String)reportJobID)) {
            throw new DBException("Device ReportJob-ID not specified.");
        }
        Key rjKey = new Key(account.getAccountID(), reportJobID);
        if (rjKey.exists()) {
            ReportJob rj = (ReportJob)rjKey.getDBRecord(true);
            rj.setAccount(account);
            return rj;
        }
        if (createOK) {
            ReportJob rj = (ReportJob)rjKey.getDBRecord();
            rj.setAccount(account);
            rj.setCreationDefaultValues();
            return rj;
        }
        return null;
    }

    public static ReportJob getReportJob(Account account, String reportJobID) throws DBException {
        if (account != null && !StringTools.isBlank((String)reportJobID)) {
            return ReportJob.getReportJob(account, reportJobID, false);
        }
        return null;
    }

    public static ReportJob createNewReportJob(Account account, String reportJobID) throws DBException {
        if (account != null && !StringTools.isBlank((String)reportJobID)) {
            ReportJob rj = ReportJob.getReportJob(account, reportJobID, true);
            rj.save();
            return rj;
        }
        throw new DBException("Invalid Account/ReportJobID specified");
    }

    public String createGTSRequest_Report(Account A, User U) {
        String usrID;
        String accID = A != null ? A.getAccountID() : "";
        String string = usrID = U != null ? U.getUserID() : "";
        String passwd = U != null ? U.getPassword() : (A != null ? A.getPassword() : "");
        String rptID = this.getReportJobID();
        String rptName = this.getReportName();
        String rptOptn = this.getReportOption();
        String rptFmt = this.getReportFormat("email");
        String devID = this.getDeviceID();
        String grpID = this.getGroupID();
        String timeFrm = this.getReportTimeFrom();
        String timeTo = this.getReportTimeTo();
        String emailAd = this.getRecipients();
        StringBuffer sb = new StringBuffer();
        sb.append("<GTSRequest command=\"report\">\n");
        sb.append("  <Authorization account=\"" + accID + "\" user=\"" + usrID + "\" password=\"" + passwd + "\"/>\n");
        sb.append("  <Report name=\"" + rptName + "\" option=\"" + rptOptn + "\" format=\"" + rptFmt + "\">\n");
        sb.append("     <Device>" + devID + "</Device>\n");
        sb.append("     <DeviceGroup>" + grpID + "</DeviceGroup>\n");
        sb.append("     <TimeFrom>" + timeFrm + "</TimeFrom>\n");
        sb.append("     <TimeTo>" + timeTo + "</TimeTo>\n");
        sb.append("     <EmailAddress>" + emailAd + "</EmailAddress>\n");
        sb.append("  </Report>\n");
        sb.append("</GTSRequest>\n");
        return sb.toString();
    }

    public static String createGTSRequest_Report(Account A, User U, String cronTags) {
        String usrID;
        String accID = A != null ? A.getAccountID() : "";
        String string = usrID = U != null ? U.getUserID() : "";
        String passwd = U != null ? U.getPassword() : (A != null ? A.getPassword() : "");
        StringBuffer sb = new StringBuffer();
        sb.append("<GTSRequest command=\"report\">\n");
        sb.append("  <Authorization account=\"" + accID + "\" user=\"" + usrID + "\" password=\"" + passwd + "\"/>\n");
        sb.append("  <ReportJob reportGroupTag=\"" + cronTags + "\">\n");
        sb.append("</GTSRequest>\n");
        return sb.toString();
    }

    public static String createGTSRequest_Report(Account A, User U, Collection<String> rptJobIDs) {
        String usrID;
        String accID = A != null ? A.getAccountID() : "";
        String string = usrID = U != null ? U.getUserID() : "";
        String passwd = U != null ? U.getPassword() : (A != null ? A.getPassword() : "");
        StringBuffer sb = new StringBuffer();
        sb.append("<GTSRequest command=\"report\">\n");
        sb.append("  <Authorization account=\"" + accID + "\" user=\"" + usrID + "\" password=\"" + passwd + "\"/>\n");
        for (String jobID : rptJobIDs) {
            sb.append("  <Report reportJobID=\"" + jobID + "\">\n");
        }
        sb.append("</GTSRequest>\n");
        return sb.toString();
    }

    public static int cron(String[] argv) {
        RTConfig.setCommandLineArgs((String[])argv);
        Print.setLogHeaderLevel((int)6);
        boolean verbose = false;
        if (RTConfig.hasProperty((String[])ARG_VERSBOSE)) {
            verbose = RTConfig.getBoolean((String[])ARG_VERSBOSE, (boolean)true);
        } else if (RTConfig.hasProperty((String[])ARG_QUIET)) {
            boolean bl = verbose = !RTConfig.getBoolean((String[])ARG_QUIET, (boolean)false);
        }
        if (RTConfig.getBoolean((String[])ARG_NOEMAIL, (boolean)false)) {
            SendMail.SetThreadModel((String)CRONTAG_NONE);
        } else {
            SendMail.SetThreadModel((String)"current");
        }
        String cronTags = RTConfig.getString((String[])ARG_TAG, (String)"");
        if (StringTools.isBlank((String)cronTags)) {
            Print.logWarn((String)"Missing CronTag value", (Object[])new Object[0]);
            return 1;
        }
        Print.logInfo((String)("ReportJob cron tag = " + cronTags), (Object[])new Object[0]);
        Object[] cronTag = StringTools.split((String)cronTags, (char)',');
        if (ListTools.isEmpty((Object[])cronTag)) {
            Print.logWarn((String)"CronTag list is empty!", (Object[])new Object[0]);
            return 1;
        }
        String accountIDs = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        if (StringTools.isBlank((String)accountIDs)) {
            Print.logWarn((String)"Missing Account-ID specification", (Object[])new Object[0]);
            return 1;
        }
        List accountList = null;
        if (accountIDs.equals(SELECT_ALL)) {
            try {
                accountList = Account.getAllAccounts();
            }
            catch (DBException dbe) {
                Print.logException((String)"Error getting list of Account IDs", (Throwable)dbe);
                return 99;
            }
        } else {
            accountList = ListTools.toList((Object[])StringTools.split((String)accountIDs, (char)','));
        }
        if (ListTools.isEmpty((Collection)accountList)) {
            Print.logWarn((String)"No matching Account found", (Object[])new Object[0]);
            return 1;
        }
        String urlStr = RTConfig.getString((String[])ARG_URL, null);
        if (StringTools.isBlank((String)urlStr)) {
            Print.logError((String)"GTSRequest URL not specified", (Object[])new Object[0]);
            return 1;
        }
        int rtnStat = 0;
        for (String accountID : accountList) {
            String toAddr;
            String msgCode;
            ServiceMessage srvMsg;
            Account account;
            block34: {
                if (StringTools.isBlank((String)accountID)) continue;
                account = null;
                try {
                    account = Account.getAccount(accountID);
                    if (account == null) {
                        Print.logInfo((String)"====================================================", (Object[])new Object[0]);
                        Print.logError((String)("Account-ID does not exist: " + accountID), (Object[])new Object[0]);
                        continue;
                    }
                }
                catch (DBException dbe) {
                    Print.logInfo((String)"====================================================", (Object[])new Object[0]);
                    Print.logException((String)("Reading Account: " + accountID), (Throwable)dbe);
                    return 99;
                }
                DBFactory<ReportJob> rjFact = ReportJob.getFactory();
                try {
                    if (!rjFact.tableExists()) {
                        return 99;
                    }
                }
                catch (DBException dbe) {
                    Print.logInfo((String)"====================================================", (Object[])new Object[0]);
                    Print.logException((String)("Checking '" + ReportJob.TABLE_NAME() + "' table existence"), (Throwable)dbe);
                    return 99;
                }
                try {
                    boolean foundRJ = false;
                    for (Object ct : cronTag) {
                        OrderedSet<String> rjList = ReportJob.getReportJobIDsForAccount(accountID, (String)ct, true, 1L);
                        if (ListTools.isEmpty(rjList)) continue;
                        foundRJ = true;
                        break;
                    }
                    if (!foundRJ) {
                    }
                    break block34;
                }
                catch (DBException dbe) {
                    Print.logInfo((String)"====================================================", (Object[])new Object[0]);
                    Print.logException((String)"Unable to get ReportJob list", (Throwable)dbe);
                }
                continue;
            }
            String userID = User.getAdminUserID();
            User user = null;
            try {
                user = User.getUser(account, userID);
            }
            catch (DBException dbe) {
                user = null;
            }
            String password = user != null ? user.getPassword() : (account != null ? account.getPassword() : "");
            Print.logInfo((String)"====================================================", (Object[])new Object[0]);
            Print.logInfo((String)("Account=" + accountID + ", User=" + userID), (Object[])new Object[0]);
            GTSServiceRequest servReq = null;
            try {
                servReq = new GTSServiceRequest(urlStr);
                servReq.setAuthorization(accountID, userID, password);
            }
            catch (MalformedURLException mue) {
                Print.logException((String)"Error", (Throwable)mue);
                return 1;
            }
            Document gtsResp = null;
            try {
                gtsResp = servReq.getReportJob_Document(cronTags);
                if (gtsResp == null) {
                    Print.logError((String)"Request error ...", (Object[])new Object[0]);
                    return 99;
                }
                if (verbose) {
                    Print.logInfo((String)"Response:", (Object[])new Object[0]);
                    Print.logInfo((String)XMLTools.nodeToString((Node)gtsResp), (Object[])new Object[0]);
                }
            }
            catch (IOException ioe) {
                Print.logException((String)"Error", (Throwable)ioe);
                return 99;
            }
            if (!GTSServiceRequest.isGTSResponseError(gtsResp) || (srvMsg = ServiceMessage.getMessageForCode(msgCode = GTSServiceRequest.getGTSResponse_Message_code(gtsResp))) == null || !srvMsg.equals(ServiceMessage.MSG_REQUEST_DISABLED)) continue;
            Print.logError((String)srvMsg.getMessage(urlStr), (Object[])new Object[0]);
            String errorNotifyEmail = RTConfig.getString((String[])ARG_ERROR_EMAIL, null);
            if (StringTools.isBlank((String)errorNotifyEmail)) break;
            String subj = "ReportJob web-service is not enabled!";
            String body = "A periodic ReportJob was requested, but the ReportJob web-service is not enabled\nURL: " + urlStr;
            SendMail.SmtpProperties smtpProps = new SendMail.SmtpProperties();
            String fromAddr = smtpProps.getUserEmail();
            if (SendMail.send((String)fromAddr, (String)(toAddr = errorNotifyEmail), (String)subj, (String)body, (SendMail.SmtpProperties)smtpProps)) {
                Print.logInfo((String)("Error notification email sent: " + toAddr), (Object[])new Object[0]);
                break;
            }
            Print.logError((String)"Una le to send error notification", (Object[])new Object[0]);
            break;
        }
        return rtnStat;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + ReportJob.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -cron=true      Run in 'Cron' test mode", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>   Account ID owning ReportJob", (Object[])new Object[0]);
        Print.logInfo((String)"  -reportJob=<id> ReportJob ID to delete/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -create         Create a new ReportJob", (Object[])new Object[0]);
        Print.logInfo((String)"  -edit           To edit an existing ReportJob", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete         Delete specified ReportJob", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        if (RTConfig.getBoolean((String[])ARG_CRON, (boolean)false)) {
            int rtn = ReportJob.cron(argv);
            System.exit(rtn);
        }
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String reportJobID = RTConfig.getString((String[])ARG_REPORTJOB, (String)"");
        if (StringTools.isBlank((String)accountID)) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            ReportJob.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(accountID);
            if (account == null) {
                Print.logError((String)("Account-ID does not exist: " + accountID), (Object[])new Object[0]);
                ReportJob.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + accountID), (Throwable)dbe);
            System.exit(99);
        }
        boolean reportJobSpecified = !StringTools.isBlank((String)reportJobID);
        boolean reportJobExists = false;
        if (reportJobSpecified) {
            try {
                reportJobExists = ReportJob.exists(accountID, reportJobID);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error determining if ReportJob exists: " + accountID + "/" + reportJobID), (Object[])new Object[0]);
                System.exit(99);
            }
        }
        int opts = 0;
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false)) {
            ++opts;
            if (!reportJobSpecified) {
                Print.logWarn((String)"ReportJob name not specified ...", (Object[])new Object[0]);
                ReportJob.usage();
            } else if (!reportJobExists) {
                Print.logWarn((String)("ReportJob does not exist: " + accountID + "/" + reportJobID), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key rjKey = new Key(accountID, reportJobID);
                rjKey.delete(true);
                Print.logInfo((String)("ReportJob deleted: " + accountID + "/" + reportJobID), (Object[])new Object[0]);
                reportJobExists = false;
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting ReportJob: " + accountID + "/" + reportJobID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (!reportJobSpecified) {
                Print.logWarn((String)"ReportJob name not specified ...", (Object[])new Object[0]);
                ReportJob.usage();
            } else if (reportJobExists) {
                Print.logWarn((String)("ReportJob already exists: " + accountID + "/" + reportJobID), (Object[])new Object[0]);
            } else {
                try {
                    ReportJob.createNewReportJob(account, reportJobID);
                    Print.logInfo((String)("Created ReportJob: " + accountID + "/" + reportJobID), (Object[])new Object[0]);
                    reportJobExists = true;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating ReportJob: " + accountID + "/" + reportJobID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false) || RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false)) {
            ++opts;
            if (!reportJobSpecified) {
                Print.logWarn((String)"ReportJob name not specified ...", (Object[])new Object[0]);
                ReportJob.usage();
            } else if (!reportJobExists) {
                Print.logError((String)("ReportJob does not exist: " + accountID + "/" + reportJobID), (Object[])new Object[0]);
            } else {
                try {
                    boolean allFlds = RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false);
                    ReportJob rptJob = ReportJob.getReportJob(account, reportJobID, false);
                    DBEdit editor = new DBEdit((DBRecord)rptJob);
                    editor.edit(allFlds);
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing ReportJob: " + accountID + "/" + reportJobID), (Object[])new Object[0]);
                    dbe.printException();
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_LIST_TAGS)) {
            String tagIDs = RTConfig.getString((String[])ARG_LIST_TAGS, (String)"");
            ++opts;
            try {
                OrderedSet<String> idList = ReportJob.getReportJobIDsForAccount(accountID, tagIDs, false);
                if (!ListTools.isEmpty(idList)) {
                    for (String rji : idList) {
                        ReportJob rj = ReportJob.getReportJob(account, rji, false);
                        String acctID = rj.getAccountID();
                        String rjID = rj.getReportJobID();
                        String rjDesc = rj.getDescription();
                        String rjTag = rj.getIntervalTag();
                        Print.logInfo((String)("  ReportJob   : " + acctID + "/" + rjID + " [" + rj.getDescription() + "] Tag=" + rjTag), (Object[])new Object[0]);
                    }
                } else {
                    Print.sysPrintln((String)"(no ReportsJobs found)", (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logError((String)("Error listing ReportJob IDs: " + accountID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_LIST, (boolean)false)) {
            ++opts;
            try {
                ReportJob[] rjList = ReportJob.getReportJobsForAccount(accountID);
                for (int i = 0; i < rjList.length; ++i) {
                    ReportJob rj = rjList[i];
                    String acctID = rj.getAccountID();
                    String rjID = rj.getReportJobID();
                    String rjDesc = rj.getDescription();
                    String rjTag = rj.getIntervalTag();
                    boolean active = rj.isActive();
                    Print.logInfo((String)("  ReportJob   : " + acctID + "/" + rjID + " [" + rj.getDescription() + "] Tag=" + rjTag + (active ? "" : " (inactive)")), (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logError((String)("Error listing ReportJobs: " + accountID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            ReportJob.usage();
        }
    }

    static {
        ReportJob.AddIntervalTag(CRONTAG_NONE, I18N.getString(ReportJob.class, (String)"ReportJob.intervalTag.none", (String)"None"), "", "");
        FieldInfo = new DBField[]{AccountRecord.newField_accountID(true), new DBField(FLD_reportJobID, String.class, DBField.TYPE_STRING((int)40), "Report Job ID", "key=true"), new DBField(FLD_reportName, String.class, DBField.TYPE_STRING((int)64), "Report Name", "edit=2"), new DBField(FLD_reportOption, String.class, DBField.TYPE_STRING((int)24), "Report Option", "edit=2"), new DBField(FLD_deviceID, String.class, DBField.TYPE_GROUP_ID(), "Selected Device ID", "edit=2"), new DBField(FLD_groupID, String.class, DBField.TYPE_GROUP_ID(), "Selected Group ID", "edit=2"), new DBField(FLD_reportTimeFrom, String.class, DBField.TYPE_STRING((int)24), "Report 'From' Time", "edit=2"), new DBField(FLD_reportTimeTo, String.class, DBField.TYPE_STRING((int)24), "Report 'To' Time", "edit=2"), new DBField(FLD_reportFormat, String.class, DBField.TYPE_STRING((int)16), "Report Format", "edit=2"), new DBField(FLD_recipients, String.class, DBField.TYPE_STRING((int)200), "Recipients", "edit=2"), new DBField(FLD_intervalTag, String.class, DBField.TYPE_STRING((int)16), "Cron Interval Tag", "edit=2"), new DBField(FLD_lastReportTime, Long.class, "UINT32", "Last Report Time", "edit=2"), ReportJob.newField_isActive(), ReportJob.newField_description(), ReportJob.newField_lastUpdateTime(), ReportJob.newField_creationTime()};
        factory = null;
        ARG_URL = new String[]{"url", "GTSRequest.url", "SERVICE_URL"};
        ARG_VERSBOSE = new String[]{"verbose", "v"};
        ARG_QUIET = new String[]{"quiet", "q"};
        ARG_ACCOUNT = new String[]{"account", "acct"};
        ARG_TAG = new String[]{"tag", "reportGroupTag"};
        ARG_NOEMAIL = new String[]{"noemail", "debug"};
        ARG_ERROR_EMAIL = new String[]{"onErrorEmail", "errorNotify"};
        ARG_REPORTJOB = new String[]{"reportJob", "jobID", "rj"};
        ARG_DELETE = new String[]{"delete"};
        ARG_CREATE = new String[]{"create"};
        ARG_EDIT = new String[]{"edit", "ed"};
        ARG_EDITALL = new String[]{"editall", "eda"};
        ARG_LIST_TAGS = new String[]{"listTags", "listTag"};
        ARG_LIST = new String[]{"list"};
        ARG_CRON = new String[]{"cron"};
    }

    public static class Key
    extends AccountRecord.AccountKey<ReportJob> {
        public Key() {
        }

        public Key(String accountId, String reportJobId) {
            super.setKeyValue("accountID", (Object)(accountId != null ? accountId.toLowerCase() : ""));
            super.setKeyValue(ReportJob.FLD_reportJobID, (Object)(reportJobId != null ? reportJobId.toLowerCase() : ""));
        }

        public DBFactory<ReportJob> getFactory() {
            return ReportJob.getFactory();
        }
    }

    public static class IntervalTag {
        private String tagID = "";
        private I18N.Text tagDesc = null;
        private String fromTime = null;
        private String toTime = null;

        public IntervalTag(String id, I18N.Text desc, String frTime, String toTime) {
            this.tagID = id;
            this.tagDesc = desc;
            this.fromTime = frTime;
            this.toTime = toTime;
        }

        public String getTagID() {
            return this.tagID;
        }

        public I18N.Text getTagDescription() {
            return this.tagDesc;
        }

        public String getFromTime() {
            return this.fromTime;
        }

        public String getToTime() {
            return this.toTime;
        }

        public String toString(Locale locale) {
            return this.tagDesc.toString(locale);
        }
    }
}

