/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.tables;

import java.sql.SQLException;
import java.util.Locale;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.DeviceRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBDelete;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class PendingCommands
extends DeviceRecord<PendingCommands> {
    public static final int SENDSTATE_PENDING = 0;
    public static final int SENDSTATE_SUCCESS = 1;
    public static final int SENDSTATE_FAILED = 99;
    public static final int DELAFTER_NEVER = 0;
    public static final int DELAFTER_SUCCESS = 1;
    public static final int DELAFTER_FAILURE = 2;
    public static final int DELAFTER_ACK = 4;
    public static final int ACKRESP_WAITING = 0;
    public static final int ACKRESP_SUCCESS = 10;
    public static final int ACKRESP_FAILED = 20;
    public static final String _TABLE_NAME = "PendingCommands";
    public static final String FLD_queueTime = "queueTime";
    public static final String FLD_sendState = "sendState";
    public static final String FLD_commandType = "commandType";
    public static final String FLD_commandID = "commandID";
    public static final String FLD_commandArgs = "commandArgs";
    public static final String FLD_sendTime = "sendTime";
    public static final String FLD_deleteAfter = "deleteAfter";
    public static final String FLD_ackTime = "ackTime";
    public static final String FLD_ackResponse = "ackResponse";
    private static DBField[] FieldInfo = new DBField[]{PendingCommands.newField_accountID(true), PendingCommands.newField_deviceID(true), new DBField("queueTime", Long.TYPE, "UINT32", "Queue Time", "key=true"), new DBField("commandType", String.class, DBField.TYPE_STRING((int)32), "Command Type", "key=true"), new DBField("commandID", String.class, DBField.TYPE_STRING((int)32), "Command ID", "key=true"), new DBField("sendState", Integer.TYPE, "UINT16", "Send State", PendingCommands._sendState_attr()), new DBField("commandArgs", String.class, DBField.TYPE_STRING((int)256), "Command Args", "edit=2"), new DBField("sendTime", Long.TYPE, "UINT32", "Send Time", "edit=2"), new DBField("deleteAfter", Integer.TYPE, "UINT16", "Delete after condition", "edit=2"), new DBField("ackTime", Long.TYPE, "UINT32", "ACK Time", "edit=2"), new DBField("ackResponse", Integer.TYPE, "UINT16", "ACK Response", "edit=2"), PendingCommands.newField_lastUpdateTime(), PendingCommands.newField_creationTime()};
    private static DBFactory<PendingCommands> factory = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_DEVICE = new String[]{"device", "dev"};
    private static final String[] ARG_LIST = new String[]{"list"};
    private static final String[] ARG_ADD = new String[]{"add"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_SEND = new String[]{"send"};

    private static String _sendState_attr() {
        if (!RTConfig.getBoolean((String)"PendingCommands.keyedSendState", (boolean)true)) {
            return "edit=2";
        }
        if (!DBField.AllowUpdateKeyFields()) {
            return "key=true";
        }
        return "key=true update";
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<PendingCommands> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)PendingCommands.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, PendingCommands.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
        }
        return factory;
    }

    public PendingCommands() {
    }

    public PendingCommands(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(PendingCommands.class, (Locale)loc);
        return i18n.getString("PendingCommands.description", "This table contains commands which are to be sent to the client device the next time it 'checks-in' with the server.");
    }

    public long getQueueTime() {
        Long v = (Long)this.getFieldValue(FLD_queueTime);
        return v != null ? v : 0L;
    }

    public void setQueueTime(long v) {
        this.setFieldValue(FLD_queueTime, v);
    }

    public int getSendState() {
        Integer v = (Integer)this.getFieldValue(FLD_sendState);
        return v != null ? v : 0;
    }

    public void setSendState(int v) {
        this.setFieldValue(FLD_sendState, v);
    }

    public boolean isSendStatePending() {
        return this.getSendState() == 0;
    }

    public String getCommandType() {
        String v = (String)this.getFieldValue(FLD_commandType);
        return StringTools.trim((String)v);
    }

    public void setCommandType(String v) {
        this.setFieldValue(FLD_commandType, StringTools.trim((String)v));
    }

    public String getCommandID() {
        String v = (String)this.getFieldValue(FLD_commandID);
        return StringTools.trim((String)v);
    }

    public void setCommandID(String v) {
        this.setFieldValue(FLD_commandID, StringTools.trim((String)v));
    }

    public String getCommandArgs() {
        String v = (String)this.getFieldValue(FLD_commandArgs);
        return StringTools.trim((String)v);
    }

    public void setCommandArgs(String v) {
        this.setFieldValue(FLD_commandArgs, StringTools.trim((String)v));
    }

    public String[] getCommandArgs_array() {
        String argStr = this.getCommandArgs();
        return StringTools.parseArray((String)argStr, (char)'|');
    }

    public void setCommandArgs_array(String[] v) {
        if (ListTools.size((Object[])v) > 0) {
            this.setCommandArgs(StringTools.encodeArray((Object[])v, (char)'|', (boolean)false));
        } else {
            this.setCommandArgs("");
        }
    }

    public long getSendTime() {
        Long v = (Long)this.getFieldValue(FLD_sendTime);
        return v != null ? v : 0L;
    }

    public void setSendTime(long v) {
        this.setFieldValue(FLD_sendTime, v);
    }

    public int getDeleteAfter() {
        Integer v = (Integer)this.getFieldValue(FLD_deleteAfter);
        return v != null ? v : 0;
    }

    public void setDeleteAfter(int v) {
        this.setFieldValue(FLD_deleteAfter, v);
    }

    public boolean isNeverDelete() {
        return this.getDeleteAfter() == 0;
    }

    public boolean isDeleteAfterSendSuccess() {
        return (this.getDeleteAfter() & 1) != 0;
    }

    public boolean isDeleteAfterSendFailure() {
        return (this.getDeleteAfter() & 2) != 0;
    }

    public boolean isDeleteAfterAck() {
        return (this.getDeleteAfter() & 4) != 0;
    }

    public boolean deletePendingCommand() {
        try {
            DBRecordKey pcKey = this.getRecordKey();
            pcKey.delete(true);
            return true;
        }
        catch (DBException dbe) {
            Print.logException((String)"Unable to delete PendingCommand", (Throwable)dbe);
            return false;
        }
    }

    public long getAckTime() {
        Long v = (Long)this.getFieldValue(FLD_ackTime);
        return v != null ? v : 0L;
    }

    public void setAckTime(long v) {
        this.setFieldValue(FLD_ackTime, v);
    }

    public int getAckResponse() {
        Integer v = (Integer)this.getFieldValue(FLD_ackResponse);
        return v != null ? v : 0;
    }

    public void setAckResponse(int v) {
        this.setFieldValue(FLD_ackResponse, v);
    }

    public boolean setCommandSent(boolean success, long sendTime) {
        this.setSendState(success ? 1 : 99);
        this.setSendTime(sendTime > 0L ? sendTime : DateTime.getCurrentTimeSec());
        if (success && this.isDeleteAfterSendSuccess()) {
            return this.deletePendingCommand();
        }
        if (!success && this.isDeleteAfterSendFailure()) {
            return this.deletePendingCommand();
        }
        try {
            this.update(new String[]{FLD_sendState, FLD_sendTime});
        }
        catch (DBException dbe) {
            Print.logException((String)"Unable to save 'sendTime'", (Throwable)dbe);
        }
        return false;
    }

    public boolean sendCommand() {
        Device device = this.getDevice();
        if (device == null) {
            return false;
        }
        String cmdType = this.getCommandType();
        String cmdID = this.getCommandID();
        String[] cmdArgs = this.getCommandArgs_array();
        RTProperties resp = DCServerFactory.sendServerCommand(device, cmdType, cmdID, cmdArgs);
        boolean success = DCServerFactory.isCommandResultOK(resp);
        boolean deleted = false;
        if (success) {
            Print.logError((String)("Command succeeded: " + resp), (Object[])new Object[0]);
            deleted = this.setCommandSent(true, -1L);
        } else {
            Print.logError((String)("Command failed: " + resp), (Object[])new Object[0]);
            deleted = this.setCommandSent(false, -1L);
        }
        return success;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getAccountID());
        sb.append("/");
        sb.append(this.getDeviceID());
        sb.append("/");
        sb.append(this.getQueueTime());
        sb.append("/");
        sb.append(this.getSendState());
        sb.append("/");
        sb.append(this.getCommandType());
        sb.append("/");
        sb.append(this.getCommandID());
        return sb.toString();
    }

    public static boolean deletePendingCommands(String acctId, String devId, int sendState) throws DBException {
        return PendingCommands.deletePendingCommands(acctId, devId, sendState, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deletePendingCommands(String acctId, String devId, int sendState, long queueTime) throws DBException {
        if (StringTools.isBlank((String)acctId)) {
            return false;
        }
        if (StringTools.isBlank((String)devId)) {
            return false;
        }
        try {
            DBDelete ddel = new DBDelete(PendingCommands.getFactory());
            DBWhere dwh = ddel.createDBWhere();
            ddel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ("deviceID", (Object)devId), queueTime > 0L ? dwh.LE(FLD_queueTime, queueTime) : null, sendState >= 0 ? dwh.EQ(FLD_sendState, sendState) : dwh.NE(FLD_sendState, 0))));
            DBConnection dbc = null;
            try {
                dbc = DBConnection.getDefaultConnection();
                dbc.executeUpdate(ddel.toString());
            }
            finally {
                DBConnection.release((DBConnection)dbc);
            }
            return true;
        }
        catch (SQLException sqe) {
            throw new DBException("PendingCommands deletion", (Throwable)sqe);
        }
    }

    public static PendingCommands[] getPendingCommands(Device dev) throws DBException {
        if (dev == null) {
            return null;
        }
        return PendingCommands.getPendingCommands(dev.getAccountID(), dev.getDeviceID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PendingCommands[] getPendingCommands(String acctId, String devId) throws DBException {
        if (StringTools.isBlank((String)acctId)) {
            return null;
        }
        if (StringTools.isBlank((String)devId)) {
            return null;
        }
        DBSelect dsel = new DBSelect(PendingCommands.getFactory());
        DBWhere dwh = dsel.createDBWhere();
        dsel.setWhere(dwh.WHERE_(dwh.AND(dwh.EQ("accountID", (Object)acctId), dwh.EQ("deviceID", (Object)devId), dwh.EQ(FLD_sendState, 0))));
        dsel.setOrderByFields(new String[]{FLD_queueTime});
        PendingCommands[] pc = null;
        try {
            DBProvider.lockTables((String[])new String[]{PendingCommands.TABLE_NAME()}, null);
            pc = (PendingCommands[])DBRecord.select((DBSelect)dsel);
        }
        finally {
            DBProvider.unlockTables();
        }
        if (pc == null) {
            return null;
        }
        return pc;
    }

    public static boolean insertCommand(Device dev, String cmdType, String cmdID, String[] cmdArgs) throws DBException {
        if (dev == null) {
            return false;
        }
        return PendingCommands.insertCommand(dev.getAccountID(), dev.getDeviceID(), cmdType, cmdID, cmdArgs);
    }

    protected static boolean insertCommand(String acctId, String devId, String cmdType, String cmdID, String[] cmdArgs) throws DBException {
        if (StringTools.isBlank((String)acctId) || StringTools.isBlank((String)devId)) {
            return false;
        }
        if (StringTools.isBlank((String)cmdType) || StringTools.isBlank((String)cmdID)) {
            return false;
        }
        long nowTime = DateTime.getCurrentTimeSec();
        Key key = new Key(acctId, devId, nowTime, 0, cmdType, cmdID);
        if (key.exists()) {
            return false;
        }
        PendingCommands pc = (PendingCommands)key.getDBRecord();
        pc.setCommandArgs_array(cmdArgs);
        pc.save();
        return true;
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + PendingCommands.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Common Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>           Acount ID which owns the specified Device", (Object[])new Object[0]);
        Print.logInfo((String)"  -device=<id>            Device ID to apply pending commands", (Object[])new Object[0]);
        Print.logInfo((String)"  -list                   List all pending commands for Device", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete=<time>          Delete pending commands for Device", (Object[])new Object[0]);
        Print.logInfo((String)"  -add=<cmd>              Add pending command for Device", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] args) {
        PendingCommands[] pc;
        DBConfig.cmdLineInit(args, true);
        String acctID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String devID = RTConfig.getString((String[])ARG_DEVICE, (String)"");
        Print.setIncludeStackFrame((int)1);
        if (StringTools.isBlank((String)acctID)) {
            Print.sysPrintln((String)"ERROR: Account-ID not specified.", (Object[])new Object[0]);
            PendingCommands.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(acctID);
            if (account == null) {
                Print.sysPrintln((String)("ERROR: Account-ID does not exist: " + acctID), (Object[])new Object[0]);
                PendingCommands.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + acctID), (Throwable)dbe);
            System.exit(99);
        }
        if (StringTools.isBlank((String)devID)) {
            Print.sysPrintln((String)"ERROR: Device-ID not specified.", (Object[])new Object[0]);
            PendingCommands.usage();
        }
        Device device = null;
        try {
            device = Device.getDevice(account, devID, false);
            if (device == null) {
                Print.sysPrintln((String)("ERROR: Device-ID does not exist: " + devID), (Object[])new Object[0]);
                PendingCommands.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Device: " + devID), (Throwable)dbe);
            System.exit(99);
        }
        int opts = 0;
        if (RTConfig.hasProperty((String[])ARG_ADD)) {
            block34: {
                ++opts;
                Print.sysPrintln((String)"", (Object[])new Object[0]);
                String cmd = RTConfig.getString((String[])ARG_ADD, null);
                if (!StringTools.isBlank((String)cmd)) {
                    String[] C = StringTools.split((String)cmd, (char)'/');
                    String cmdType = C.length > 0 ? C[0] : "";
                    String cmdID = C.length > 1 ? C[1] : "";
                    String[] cmdArgs = C.length > 2 ? StringTools.split((String)C[2], (char)',') : null;
                    try {
                        if (PendingCommands.insertCommand(device, cmdType, cmdID, cmdArgs)) {
                            Print.sysPrintln((String)("Command inserted: " + cmdType + "/" + cmdID), (Object[])new Object[0]);
                            break block34;
                        }
                        Print.sysPrintln((String)("Error inserting command: " + cmdType + "/" + cmdID), (Object[])new Object[0]);
                    }
                    catch (DBException dbe) {
                        Print.logException((String)("Error inserting command: " + cmdType + "/" + cmdID), (Throwable)dbe);
                        System.exit(99);
                    }
                } else {
                    Print.sysPrintln((String)"ERROR: Missing 'command' ...", (Object[])new Object[0]);
                    PendingCommands.usage();
                }
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_SEND)) {
            ++opts;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            try {
                pc = PendingCommands.getPendingCommands(acctID, devID);
                if (!ListTools.isEmpty((Object[])pc)) {
                    for (int i = 0; i < pc.length; ++i) {
                        Print.sysPrintln((String)(i + ") PC: " + (Object)((Object)pc[i])), (Object[])new Object[0]);
                        boolean ok = pc[i].sendCommand();
                        Print.sysPrintln((String)("   SendCommand " + (ok ? "success" : "failed")), (Object[])new Object[0]);
                    }
                } else {
                    Print.sysPrintln((String)"No pending commands for this account/device", (Object[])new Object[0]);
                }
            }
            catch (Throwable th) {
                Print.logException((String)"Error getting commands for account/device", (Throwable)th);
                System.exit(1);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_LIST)) {
            ++opts;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            try {
                pc = PendingCommands.getPendingCommands(acctID, devID);
                if (!ListTools.isEmpty((Object[])pc)) {
                    for (int i = 0; i < pc.length; ++i) {
                        Print.sysPrintln((String)(i + ") PC: " + (Object)((Object)pc[i])), (Object[])new Object[0]);
                    }
                } else {
                    Print.sysPrintln((String)"No pending commands for this account/device", (Object[])new Object[0]);
                }
            }
            catch (Throwable th) {
                Print.logException((String)"Error getting commands for account/device", (Throwable)th);
                System.exit(1);
            }
            System.exit(0);
        }
        if (RTConfig.hasProperty((String[])ARG_DELETE)) {
            ++opts;
            Print.sysPrintln((String)"", (Object[])new Object[0]);
            long queTime = RTConfig.getLong((String[])ARG_DELETE, (long)-2L);
            if (queTime == -1L || queTime > 0L) {
                try {
                    PendingCommands.deletePendingCommands(acctID, devID, -1, queTime);
                    if (queTime == -1L) {
                        Print.sysPrintln((String)"Deleted all sent commands", (Object[])new Object[0]);
                    } else {
                        Print.sysPrintln((String)("Deleted sent commands up to, and including " + queTime), (Object[])new Object[0]);
                    }
                }
                catch (Throwable th) {
                    Print.logException((String)"Error while deleting commands for account/device", (Throwable)th);
                    System.exit(1);
                }
                System.exit(0);
            } else {
                Print.sysPrintln((String)("ERROR: Invalid time specified: " + RTConfig.getString((String[])ARG_DELETE, (String)"")), (Object[])new Object[0]);
                PendingCommands.usage();
            }
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            PendingCommands.usage();
        }
    }

    public static class Key
    extends DeviceRecord.DeviceKey<PendingCommands> {
        public Key() {
        }

        public Key(String acctId, String devId, long queueTime, int sendState, String cmdType, String cmdID) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)(devId != null ? devId.toLowerCase() : ""));
            super.setKeyValue(PendingCommands.FLD_queueTime, queueTime);
            super.setKeyValue(PendingCommands.FLD_sendState, sendState);
            super.setKeyValue(PendingCommands.FLD_commandType, (Object)cmdType);
            super.setKeyValue(PendingCommands.FLD_commandID, (Object)cmdID);
        }

        public DBFactory<PendingCommands> getFactory() {
            return PendingCommands.getFactory();
        }
    }
}

