/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.tables;

import java.io.EOFException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Set;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DBConfig;
import org.opengts.db.DeviceRecord;
import org.opengts.db.EntityManager;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBEdit;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.EnumTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Entity
extends AccountRecord<Entity> {
    public static final double MAX_ENTITY_ODOM_KM = 16093.44;
    public static int AddressColumnLength = -1;
    public static final String _TABLE_NAME = "Entity";
    public static final String FLD_entityID = "entityID";
    public static final String FLD_entityType = "entityType";
    public static final String FLD_timestamp = "timestamp";
    public static final String FLD_statusCode = "statusCode";
    public static final String FLD_isAttached = "isAttached";
    public static final String FLD_deviceID = "deviceID";
    public static final String FLD_deviceOdomKM = "deviceOdomKM";
    public static final String FLD_latitude = "latitude";
    public static final String FLD_longitude = "longitude";
    public static final String FLD_altitude = "altitude";
    public static final String FLD_address = "address";
    public static final String FLD_odometerKM = "odometerKM";
    private static DBField[] FieldInfo = new DBField[]{AccountRecord.newField_accountID(true), new DBField("entityID", String.class, DBField.TYPE_ENTITY_ID(), "Entity ID", "key=true"), new DBField("entityType", Long.TYPE, "UINT32", "Entity Type", "key=true"), new DBField("timestamp", Long.TYPE, "UINT32", "Timestamp", null), new DBField("statusCode", Integer.TYPE, "UINT32", "Status Code", "format=X2"), new DBField("isAttached", Boolean.TYPE, "BOOLEAN", "Is Attached", "edit=2"), DeviceRecord.newField_deviceID(false, null, "Attached_Device/Asset_ID"), new DBField("deviceOdomKM", Double.TYPE, "DOUBLE", "Asset Odometer KM", "edit=2 format=#0.0"), new DBField("latitude", Double.TYPE, "DOUBLE", "Latitude", "edit=2 format=#0.00000"), new DBField("longitude", Double.TYPE, "DOUBLE", "Longitude", "edit=2 format=#0.00000"), new DBField("altitude", Double.TYPE, "DOUBLE", "Altitude Meters", "edit=2 format=#0.0"), new DBField("address", String.class, DBField.TYPE_ADDRESS(), "Address", "edit=2 utf8=true"), new DBField("odometerKM", Double.TYPE, "DOUBLE", "Odometer KM", "edit=2 format=#0.0"), Entity.newField_description(), Entity.newField_lastUpdateTime(), Entity.newField_creationTime()};
    private static DBFactory<Entity> factory = null;
    private static EntityManager entityManager = null;
    private static final String[] ARG_ACCOUNT = new String[]{"account", "acct"};
    private static final String[] ARG_ENTITY = new String[]{"entity", "id"};
    private static final String[] ARG_TYPE = new String[]{"type", "ty"};
    private static final String[] ARG_DELETE = new String[]{"delete"};
    private static final String[] ARG_CREATE = new String[]{"create"};
    private static final String[] ARG_EDIT = new String[]{"edit", "ed"};
    private static final String[] ARG_EDITALL = new String[]{"editall", "eda"};
    private static final String[] ARG_LIST = new String[]{"list"};

    public static String[] GetTitles(Locale loc) {
        I18N i18n = I18N.getI18N(Entity.class, (Locale)loc);
        return new String[]{i18n.getString("Entity.title.singular", "Trailer"), i18n.getString("Entity.title.plural", "Trailers")};
    }

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<Entity> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)Entity.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, Entity.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            Entity.initEntityManager();
            DBField addrFld = factory.getField(FLD_address);
            AddressColumnLength = addrFld != null ? addrFld.getStringLength() : 0;
        }
        return factory;
    }

    public Entity() {
    }

    public Entity(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(Entity.class, (Locale)loc);
        return i18n.getString("Entity.description", "This table contains Account specific 'Entity' (ie. trailer drop/hook, etc) information.");
    }

    public String getEntityID() {
        String v = (String)this.getFieldValue(FLD_entityID);
        return v != null ? v : "";
    }

    private void setEntityID(String v) {
        this.setFieldValue(FLD_entityID, v != null ? v : "");
    }

    public long getEntityType() {
        Long v = (Long)this.getFieldValue(FLD_entityType);
        return v != null ? v : (long)((EntityManager.EntityType)EnumTools.getDefault(EntityManager.EntityType.class)).getIntValue();
    }

    public void setEntityType(long v) {
        int vi = (int)v;
        this.setFieldValue(FLD_entityType, ((EntityManager.EntityType)EnumTools.getValueOf(EntityManager.EntityType.class, (int)vi)).getIntValue());
    }

    public void setEntityType(EntityManager.EntityType v) {
        this.setFieldValue(FLD_entityType, ((EntityManager.EntityType)EnumTools.getValueOf(EntityManager.EntityType.class, (Enum)v)).getIntValue());
    }

    public void setEntityType(String v, Locale locale) {
        this.setFieldValue(FLD_entityType, ((EntityManager.EntityType)EnumTools.getValueOf(EntityManager.EntityType.class, (String)v, (Locale)locale)).getIntValue());
    }

    public long getTimestamp() {
        Long v = (Long)this.getFieldValue(FLD_timestamp);
        return v != null ? v : 0L;
    }

    public void setTimestamp(long v) {
        this.setFieldValue(FLD_timestamp, v);
    }

    public String getTimestampString() {
        Account a = this.getAccount();
        String dateFmt = a != null ? a.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
        String timeFmt = a != null ? a.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat();
        DateTime dt = new DateTime(this.getTimestamp());
        return dt.gmtFormat(dateFmt + " " + timeFmt + " z");
    }

    public int getStatusCode() {
        return this.getFieldValue(FLD_statusCode, 0);
    }

    public void setStatusCode(int v) {
        this.setFieldValue(FLD_statusCode, v);
    }

    public boolean getIsAttached() {
        Boolean v = (Boolean)this.getFieldValue(FLD_isAttached);
        return v != null ? v : false;
    }

    public void setIsAttached(boolean v) {
        this.setFieldValue(FLD_isAttached, v);
    }

    public boolean isAttached() {
        return this.getIsAttached();
    }

    public String getDeviceID() {
        String v = (String)this.getFieldValue(FLD_deviceID);
        return v != null ? v : "";
    }

    private void setDeviceID(String v) {
        this.setFieldValue(FLD_deviceID, v != null ? v : "");
    }

    public double getLatitude() {
        Double v = (Double)this.getFieldValue(FLD_latitude);
        return v != null ? v : 0.0;
    }

    public void setLatitude(double v) {
        this.setFieldValue(FLD_latitude, v);
    }

    public double getLongitude() {
        Double v = (Double)this.getFieldValue(FLD_longitude);
        return v != null ? v : 0.0;
    }

    public void setLongitude(double v) {
        this.setFieldValue(FLD_longitude, v);
    }

    public GeoPoint getGeoPoint() {
        return new GeoPoint(this.getLatitude(), this.getLongitude());
    }

    public void setGeoPoint(double lat, double lng) {
        this.setLatitude(lat);
        this.setLongitude(lng);
    }

    public void setGeoPoint(GeoPoint gp) {
        if (gp != null) {
            this.setLatitude(gp.getLatitude());
            this.setLongitude(gp.getLongitude());
        } else {
            this.setLatitude(0.0);
            this.setLongitude(0.0);
        }
    }

    public double getAltitude() {
        return this.getFieldValue(FLD_altitude, 0.0);
    }

    public void setAltitude(double v) {
        this.setFieldValue(FLD_altitude, v);
    }

    public String getAddress() {
        String v = (String)this.getFieldValue(FLD_address);
        if (v == null || v.equals("")) {
            v = "";
        }
        return v;
    }

    public void setAddress(String v) {
        String addr = StringTools.trim((String)v);
        if (AddressColumnLength > 0 && addr.length() >= AddressColumnLength) {
            int newLen = AddressColumnLength - 1;
            addr = addr.substring(0, newLen).trim();
        }
        this.setFieldValue(FLD_address, addr);
    }

    public double getDeviceOdomKM() {
        Double v = (Double)this.getFieldValue(FLD_deviceOdomKM);
        return v != null ? v : 0.0;
    }

    public void setDeviceOdomKM(double v) {
        this.setFieldValue(FLD_deviceOdomKM, v);
    }

    public double getOdometerKM() {
        Double v = (Double)this.getFieldValue(FLD_odometerKM);
        return v != null ? v : 0.0;
    }

    public void setOdometerKM(double v) {
        this.setFieldValue(FLD_odometerKM, v);
    }

    public void addDeltaOdometerKM(double deltaKM) {
        if (deltaKM > 0.0) {
            double accumKM = this.getOdometerKM() + deltaKM;
            this.setOdometerKM(accumKM);
        }
    }

    public String toString() {
        return this.getAccountID() + "/" + this.getEntityID();
    }

    public void setCreationDefaultValues() {
        this.setDescription("");
        super.setRuntimeDefaultValues();
    }

    private static void initEntityManager() {
        if (entityManager == null) {
            entityManager = new EntityManager(){

                @Override
                public boolean insertEntityChange(EventData event) {
                    try {
                        return Entity.insertEntityChange(event);
                    }
                    catch (Throwable th) {
                        Print.logError((String)("Error inserting entity change: " + th), (Object[])new Object[0]);
                        return false;
                    }
                }

                @Override
                public String[] getAttachedEntityIDs(String accountID, String deviceID, long entityType) throws DBException {
                    return Entity.getAttachedEntityIDs(accountID, deviceID, entityType);
                }

                @Override
                public String[] getAttachedEntityDescriptions(String accountID, String deviceID, long entityType) throws DBException {
                    return Entity.getAttachedEntityDescriptions(accountID, deviceID, entityType);
                }

                @Override
                public String getEntityDescription(String accountID, String entityID, long entityType) {
                    return Entity.getEntityDescription(accountID, entityID, entityType);
                }

                @Override
                public boolean isEntityAttached(String accountID, String deviceID, String entityID, long entityType) {
                    return Entity.isEntityAttached(accountID, deviceID, entityID, entityType);
                }
            };
            Device.setEntityManager(entityManager);
        }
    }

    public static String[] getAttachedEntityIDs(String accountID, String deviceID, long entityType) throws DBException {
        Entity[] e = Entity.getAttachedEntities(accountID, deviceID, entityType, null);
        if (ListTools.isEmpty((Object[])e)) {
            return new String[0];
        }
        String[] id = new String[e.length];
        for (int i = 0; i < e.length; ++i) {
            id[i] = e[i].getEntityID();
        }
        return id;
    }

    public static String[] getAttachedEntityDescriptions(String accountID, String deviceID, long entityType) throws DBException {
        Entity[] e = Entity.getAttachedEntities(accountID, deviceID, entityType, null);
        if (ListTools.isEmpty((Object[])e)) {
            return new String[0];
        }
        String[] desc = new String[e.length];
        for (int i = 0; i < e.length; ++i) {
            String d = e[i].getDescription();
            desc[i] = d != null && !d.equals("") ? d : e[i].getEntityID();
        }
        return desc;
    }

    public static Entity[] getAttachedEntities(String accountID, String deviceID, long entityType) throws DBException {
        return Entity.getAttachedEntities(accountID, deviceID, entityType, null);
    }

    public static Entity[] getAttachedEntities(String accountID, String deviceID, long entityType, DBRecordHandler<Entity> handler) throws DBException {
        DBSelect esel = new DBSelect(Entity.getFactory());
        DBWhere ewh = esel.createDBWhere();
        esel.setWhere(ewh.WHERE(ewh.AND(ewh.EQ("accountID", (Object)accountID), ewh.EQ(FLD_isAttached, true), ewh.EQ(FLD_deviceID, (Object)deviceID), ewh.EQ(FLD_entityType, entityType))));
        esel.setOrderByFields(new String[]{FLD_entityID});
        esel.setLimit(50L);
        return (Entity[])DBRecord.select((DBSelect)esel, handler);
    }

    public static boolean insertEntityChange(EventData event) {
        if (event == null) {
            return false;
        }
        int statusCode = event.getStatusCode();
        Account account = event.getAccount();
        if (statusCode == 63529) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.RFID_00);
            String rfidTag = event.getRfidTag();
            if (entityType.isRFID()) {
                String[] entIDs = event.getEntityIDList(rfidTag);
                return Entity._attach(account, entIDs, entityType, event);
            }
            if (!StringTools.isBlank((String)rfidTag)) {
                Print.logWarn((String)("Expected RFID Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
                String[] entIDs = new String[]{rfidTag};
                return Entity._attach(account, entIDs, EntityManager.EntityType.RFID_00, event);
            }
            Print.logError((String)("Expected RFID Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
            return false;
        }
        if (statusCode == 63530) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.RFID_00);
            String rfidTag = event.getRfidTag();
            if (entityType.isRFID()) {
                String[] entIDs = event.getEntityIDList(rfidTag);
                return Entity._detach(account, entIDs, entityType, event);
            }
            if (!StringTools.isBlank((String)rfidTag)) {
                Print.logWarn((String)("Expected RFID Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
                String[] entIDs = new String[]{rfidTag};
                return Entity._detach(account, entIDs, EntityManager.EntityType.RFID_00, event);
            }
            Print.logError((String)("Expected RFID Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
            return false;
        }
        if (statusCode == 63531) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.RFID_00);
            String rfidTag = event.getRfidTag();
            if (entityType.isRFID()) {
                String[] entIDs = event.getEntityIDList(rfidTag);
                return Entity._inventory(account, entIDs, entityType, event);
            }
            if (!StringTools.isBlank((String)rfidTag)) {
                Print.logWarn((String)("Expected RFID Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
                String[] entIDs = new String[]{rfidTag};
                return Entity._inventory(account, entIDs, EntityManager.EntityType.RFID_00, event);
            }
            Print.logError((String)("Expected RFID Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
            return false;
        }
        if (statusCode == 63525) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.TRAILER);
            String rfidTag = event.getRfidTag();
            if (entityType.isTrailer()) {
                String[] entIDs = event.getEntityIDList(rfidTag);
                return Entity._attach(account, entIDs, entityType, event);
            }
            if (!StringTools.isBlank((String)rfidTag)) {
                Print.logWarn((String)("Expected TRAILER Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
                String[] entIDs = new String[]{rfidTag};
                return Entity._attach(account, entIDs, EntityManager.EntityType.TRAILER, event);
            }
            Print.logError((String)("Expected TRAILER Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
            return false;
        }
        if (statusCode == 63526) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.TRAILER);
            String rfidTag = event.getRfidTag();
            if (entityType.isTrailer()) {
                String[] entIDs = event.getEntityIDList(rfidTag);
                return Entity._detach(account, entIDs, entityType, event);
            }
            if (!StringTools.isBlank((String)rfidTag)) {
                Print.logWarn((String)("Expected TRAILER Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
                String[] entIDs = new String[]{rfidTag};
                return Entity._detach(account, entIDs, EntityManager.EntityType.TRAILER, event);
            }
            Print.logError((String)("Expected TRAILER Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
            return false;
        }
        if (statusCode == 63527) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.TRAILER);
            String rfidTag = event.getRfidTag();
            if (entityType.isTrailer()) {
                String[] entIDs = event.getEntityIDList(rfidTag);
                return Entity._inventory(account, entIDs, entityType, event);
            }
            if (!StringTools.isBlank((String)rfidTag)) {
                Print.logWarn((String)("Expected TRAILER Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
                String[] entIDs = new String[]{rfidTag};
                return Entity._inventory(account, entIDs, EntityManager.EntityType.TRAILER, event);
            }
            Print.logError((String)("Expected TRAILER Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
            return false;
        }
        if (statusCode == 63532) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.PERSON);
            String rfidTag = event.getRfidTag();
            if (entityType.isPerson()) {
                String[] entIDs = event.getEntityIDList(rfidTag);
                return Entity._attach(account, entIDs, entityType, event);
            }
            if (!StringTools.isBlank((String)rfidTag)) {
                Print.logWarn((String)("Expected PERSON Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
                String[] entIDs = new String[]{rfidTag};
                return Entity._attach(account, entIDs, EntityManager.EntityType.PERSON, event);
            }
            Print.logError((String)("Expected PERSON Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
            return false;
        }
        if (statusCode == 63533) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.PERSON);
            String rfidTag = event.getRfidTag();
            if (entityType.isPerson()) {
                String[] entIDs = event.getEntityIDList(rfidTag);
                return Entity._detach(account, entIDs, entityType, event);
            }
            if (!StringTools.isBlank((String)rfidTag)) {
                Print.logWarn((String)("Expected PERSON Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
                String[] entIDs = new String[]{rfidTag};
                return Entity._detach(account, entIDs, EntityManager.EntityType.PERSON, event);
            }
            Print.logError((String)("Expected PERSON Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
            return false;
        }
        if (statusCode == 63534) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.PERSON);
            String rfidTag = event.getRfidTag();
            if (entityType.isPerson()) {
                String[] entIDs = event.getEntityIDList(rfidTag);
                return Entity._inventory(account, entIDs, entityType, event);
            }
            if (!StringTools.isBlank((String)rfidTag)) {
                Print.logWarn((String)("Expected PERSON Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
                String[] entIDs = new String[]{rfidTag};
                return Entity._inventory(account, entIDs, EntityManager.EntityType.PERSON, event);
            }
            Print.logError((String)("Expected PERSON Entity type for status code: " + (Object)((Object)entityType)), (Object[])new Object[0]);
            return false;
        }
        if (statusCode == 63521) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.GENERAL);
            String rfidTag = event.getRfidTag();
            String[] entIDs = event.getEntityIDList(rfidTag);
            return Entity._attach(account, entIDs, entityType, event);
        }
        if (statusCode == 63522) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.GENERAL);
            String rfidTag = event.getRfidTag();
            String[] entIDs = event.getEntityIDList(rfidTag);
            return Entity._detach(account, entIDs, entityType, event);
        }
        if (statusCode == 63523) {
            EntityManager.EntityType entityType = event._getEntityType(EntityManager.EntityType.GENERAL);
            String rfidTag = event.getRfidTag();
            String[] entIDs = event.getEntityIDList(rfidTag);
            return Entity._inventory(account, entIDs, entityType, event);
        }
        if (statusCode == 63505) {
            EntityManager.EntityType entityType = EntityManager.EntityType.DRIVER;
            String[] entIDs = new String[]{event.getDriverID()};
            return Entity._attach(account, entIDs, entityType, event);
        }
        if (statusCode == 63506) {
            EntityManager.EntityType entityType = EntityManager.EntityType.DRIVER;
            String[] entIDs = new String[]{event.getDriverID()};
            return Entity._detach(account, entIDs, entityType, event);
        }
        return false;
    }

    private static boolean _attach(Account account, String[] entIDList, EntityManager.EntityType entityType, EventData evdb) {
        if (account == null) {
            Print.logWarn((String)"Skipping Entity attach due to null Account", (Object[])new Object[0]);
            return false;
        }
        if (evdb == null) {
            Print.logWarn((String)"Skipping Entity attach due to null EventData", (Object[])new Object[0]);
            return false;
        }
        if (ListTools.isEmpty((Object[])entIDList)) {
            Print.logWarn((String)"Skipping Entity attach due to empty EntityID list", (Object[])new Object[0]);
            return false;
        }
        if (entityType == null) {
            Print.logWarn((String)"Skipping Entity detach due to null EntityType", (Object[])new Object[0]);
            return false;
        }
        String evAcctID = account.getAccountID();
        String evDevID = evdb.getDeviceID();
        String devName = evAcctID + "/" + evDevID;
        for (String entityID : entIDList) {
            if (StringTools.isBlank((String)entityID)) continue;
            String entName = evAcctID + "/" + entityID + "/" + (Object)((Object)entityType);
            try {
                Entity entity = Entity.getEntity(account, entityID, entityType.getIntValue(), true);
                String entDevID = entity.getDeviceID();
                if (entity.getIsAttached()) {
                    Print.logWarn((String)("Missing last 'detach' for entity: " + entName + " [attached to " + entDevID + "]"), (Object[])new Object[0]);
                }
                entity.setIsAttached(true);
                entity.setTimestamp(evdb.getTimestamp());
                entity.setStatusCode(evdb.getStatusCode());
                entity.setDeviceID(evDevID);
                entity.setDeviceOdomKM(evdb.getOdometerKM());
                entity.setLatitude(evdb.getLatitude());
                entity.setLongitude(evdb.getLongitude());
                entity.setAltitude(evdb.getAltitude());
                entity.setAddress(evdb.getAddress());
                entity.save();
                Print.logInfo((String)("Entity attached to device '" + devName + "': " + entName), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logException((String)("Unable to attach Entity " + entName), (Throwable)dbe);
                return false;
            }
        }
        return true;
    }

    private static boolean _detach(Account account, String[] entIDList, EntityManager.EntityType entityType, EventData evdb) {
        if (account == null) {
            Print.logWarn((String)"Skipping Entity detach due to null Account", (Object[])new Object[0]);
            return false;
        }
        if (evdb == null) {
            Print.logWarn((String)"Skipping Entity detach due to null EventData", (Object[])new Object[0]);
            return false;
        }
        if (ListTools.isEmpty((Object[])entIDList)) {
            Print.logWarn((String)"Skipping Entity detach due to empty EntityID list", (Object[])new Object[0]);
            return false;
        }
        if (entityType == null) {
            Print.logWarn((String)"Skipping Entity detach due to null EntityType", (Object[])new Object[0]);
            return false;
        }
        String evAcctID = account.getAccountID();
        String evDevID = evdb.getDeviceID();
        String devName = evAcctID + "/" + evDevID;
        for (String entityID : entIDList) {
            if (StringTools.isBlank((String)entityID)) continue;
            String entName = evAcctID + "/" + entityID + "/" + (Object)((Object)entityType);
            try {
                Entity entity = Entity.getEntity(account, entityID, entityType.getIntValue(), true);
                String entDevID = entity.getDeviceID();
                if (!entDevID.equals(evDevID)) {
                    Print.logWarn((String)("Last 'attach' Device[" + entDevID + "] does not match this 'detach' Device[" + devName + "]"), (Object[])new Object[0]);
                } else if (!entity.getIsAttached()) {
                    Print.logWarn((String)("Missing last 'attach' for entity: " + entName), (Object[])new Object[0]);
                } else {
                    double devOdomKM = entity.getDeviceOdomKM();
                    double evtOdomKM = evdb.getOdometerKM();
                    if (devOdomKM > 0.0 && evtOdomKM > devOdomKM) {
                        double deltaKM = evtOdomKM - devOdomKM;
                        if (deltaKM <= 16093.44) {
                            entity.addDeltaOdometerKM(deltaKM);
                        } else {
                            Print.logWarn((String)("Unreasonable trailer delta odometer: " + deltaKM + " [ignored]"), (Object[])new Object[0]);
                        }
                    }
                }
                entity.setIsAttached(false);
                entity.setTimestamp(evdb.getTimestamp());
                entity.setStatusCode(evdb.getStatusCode());
                entity.setDeviceID(evDevID);
                entity.setDeviceOdomKM(evdb.getOdometerKM());
                entity.setLatitude(evdb.getLatitude());
                entity.setLongitude(evdb.getLongitude());
                entity.setAltitude(evdb.getAltitude());
                entity.setAddress(evdb.getAddress());
                entity.save();
                Print.logInfo((String)("Entity detached from device '" + devName + "': " + entName), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logException((String)("Unable to detach Entity " + entName), (Throwable)dbe);
                return false;
            }
        }
        return true;
    }

    private static boolean _inventory(Account account, String[] entIDList, EntityManager.EntityType entityType, EventData evdb) {
        if (account == null) {
            Print.logWarn((String)"Skipping Entity inventory due to null Account", (Object[])new Object[0]);
            return false;
        }
        if (evdb == null) {
            Print.logWarn((String)"Skipping Entity inventory due to null EventData", (Object[])new Object[0]);
            return false;
        }
        if (ListTools.isEmpty((Object[])entIDList)) {
            Print.logWarn((String)"Skipping Entity inventory due to empty EntityID list", (Object[])new Object[0]);
            return false;
        }
        if (entityType == null) {
            Print.logWarn((String)"Skipping Entity inventory due to null EntityType", (Object[])new Object[0]);
            return false;
        }
        Device device = evdb.getDevice();
        if (device == null) {
            Print.logWarn((String)"Skipping Entity inventory due to null Device", (Object[])new Object[0]);
            return false;
        }
        String evAcctID = account.getAccountID();
        String evDevID = evdb.getDeviceID();
        String devName = evAcctID + "/" + evDevID;
        Set attEntIDs = ListTools.toSet((Object[])device.getAttachedEntityIDs(entityType));
        for (String entityID : entIDList) {
            if (StringTools.isBlank((String)entityID)) continue;
            if (attEntIDs.contains(entityID)) {
                attEntIDs.remove(entityID);
                continue;
            }
            String entName = evAcctID + "/" + entityID + "/" + (Object)((Object)entityType);
            try {
                Entity entity = Entity.getEntity(account, entityID, entityType.getIntValue(), true);
                String entDevID = entity.getDeviceID();
                if (entity.getIsAttached()) continue;
                entity.setIsAttached(true);
                entity.setTimestamp(evdb.getTimestamp());
                entity.setStatusCode(evdb.getStatusCode());
                entity.setDeviceID(evDevID);
                entity.setDeviceOdomKM(evdb.getOdometerKM());
                entity.setLatitude(evdb.getLatitude());
                entity.setLongitude(evdb.getLongitude());
                entity.setAltitude(evdb.getAltitude());
                entity.setAddress(evdb.getAddress());
                entity.save();
                Print.logInfo((String)("Entity attached to device '" + devName + "': " + entName), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logException((String)("Unable to attach Entity " + entName), (Throwable)dbe);
                return false;
            }
        }
        for (String entityID : attEntIDs) {
            if (StringTools.isBlank((String)entityID)) continue;
            String entName = evAcctID + "/" + entityID + "/" + (Object)((Object)entityType);
            try {
                Entity entity = Entity.getEntity(account, entityID, entityType.getIntValue(), false);
                if (entity == null || !entity.getIsAttached()) continue;
                String entDevID = entity.getDeviceID();
                if (!entDevID.equals(evDevID)) {
                    Print.logWarn((String)("Entity [" + entDevID + "] not attached to this Device[" + devName + "]"), (Object[])new Object[0]);
                    continue;
                }
                double devOdomKM = entity.getDeviceOdomKM();
                double evtOdomKM = evdb.getOdometerKM();
                if (devOdomKM > 0.0 && evtOdomKM > devOdomKM) {
                    double deltaKM = evtOdomKM - devOdomKM;
                    if (deltaKM <= 16093.44) {
                        entity.addDeltaOdometerKM(deltaKM);
                    } else {
                        Print.logWarn((String)("Unreasonable trailer delta odometer: " + deltaKM + " [ignored]"), (Object[])new Object[0]);
                    }
                }
                entity.setIsAttached(false);
                entity.setTimestamp(evdb.getTimestamp());
                entity.setStatusCode(evdb.getStatusCode());
                entity.setDeviceID(evDevID);
                entity.setDeviceOdomKM(evdb.getOdometerKM());
                entity.setLatitude(evdb.getLatitude());
                entity.setLongitude(evdb.getLongitude());
                entity.setAltitude(evdb.getAltitude());
                entity.setAddress(evdb.getAddress());
                entity.save();
                Print.logInfo((String)("Entity detached from device '" + devName + "': " + entName), (Object[])new Object[0]);
            }
            catch (DBException dbe) {
                Print.logException((String)("Unable to detach Entity " + entName), (Throwable)dbe);
                return false;
            }
        }
        return true;
    }

    public static String getEntityDescription(String accountID, String entityID, long entityType) {
        if (entityID == null) {
            return "";
        }
        if (accountID == null) {
            return entityID;
        }
        try {
            Entity e = Entity.getEntity(accountID, entityID, entityType);
            String d = e != null ? e.getDescription() : "";
            return d != null && !d.equals("") ? d : entityID;
        }
        catch (DBException dbe) {
            Print.logException((String)"Retrieving Entity description", (Throwable)dbe);
            return entityID;
        }
    }

    public static boolean isEntityAttached(String accountID, String deviceID, String entityID, long entityType) {
        if (entityID == null) {
            return false;
        }
        if (accountID == null) {
            return false;
        }
        try {
            Entity e = Entity.getEntity(accountID, entityID, entityType);
            if (e == null) {
                return false;
            }
            if (!e.getIsAttached()) {
                return false;
            }
            return deviceID == null || deviceID.equalsIgnoreCase(e.getDeviceID());
        }
        catch (DBException dbe) {
            Print.logException((String)"Retrieving Entity", (Throwable)dbe);
            return false;
        }
    }

    public static Entity getEntity(String accountID, String entityID, long entityType) throws DBException {
        return Entity._getEntity(accountID, null, entityID, entityType, false);
    }

    public static Entity getEntity(Account account, String entityID, long entityType) throws DBException {
        return Entity._getEntity(null, account, entityID, entityType, false);
    }

    public static Entity getEntity(Account account, String entityID, long entityType, boolean createOK) throws DBException {
        return Entity._getEntity(null, account, entityID, entityType, createOK);
    }

    private static Entity _getEntity(String accountID, Account account, String entityID, long entityType, boolean createOK) throws DBException {
        if (accountID == null) {
            if (account == null) {
                throw new DBException("Account not specified.");
            }
            accountID = account.getAccountID();
        } else if (account != null && !account.getAccountID().equals(accountID)) {
            throw new DBException("Account does not match specified AccountID.");
        }
        if (StringTools.isBlank((String)entityID)) {
            throw new DBException("Entity-ID not specified.");
        }
        Key entityKey = new Key(accountID, entityID, entityType);
        if (entityKey.exists()) {
            Entity entity = (Entity)entityKey.getDBRecord(true);
            if (account != null) {
                entity.setAccount(account);
            }
            return entity;
        }
        if (createOK) {
            Entity entity = (Entity)entityKey.getDBRecord();
            if (account != null) {
                entity.setAccount(account);
            }
            entity.setCreationDefaultValues();
            return entity;
        }
        return null;
    }

    public static Entity[] getEntitiesForAccount(String accountID) throws DBException {
        return Entity.getEntitiesForAccount(accountID, -1L, null);
    }

    public static Entity[] getEntitiesForAccount(String accountID, long limit) throws DBException {
        return Entity.getEntitiesForAccount(accountID, limit, null);
    }

    public static Entity[] getEntitiesForAccount(String accountID, long limit, DBRecordHandler<Entity> handler) throws DBException {
        DBSelect esel = new DBSelect(Entity.getFactory());
        DBWhere ewh = esel.createDBWhere();
        esel.setWhere(ewh.WHERE(ewh.EQ("accountID", (Object)accountID)));
        esel.setOrderByFields(new String[]{FLD_entityID});
        if (limit > 0L) {
            esel.setLimit(limit);
        }
        return (Entity[])DBRecord.select((DBSelect)esel, handler);
    }

    public static OrderedSet<String> getEntityIDsForAccount(String accountID) throws DBException {
        return Entity.getEntityIDsForAccount(accountID, -1L, null);
    }

    public static OrderedSet<String> getEntityIDsForAccount(String accountID, long limit) throws DBException {
        return Entity.getEntityIDsForAccount(accountID, limit, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static OrderedSet<String> getEntityIDsForAccount(String accountID, long limit, DBRecordHandler<Entity> handler) throws DBException {
        Statement stmt;
        DBConnection dbc;
        OrderedSet entList;
        block17: {
            if (StringTools.isBlank((String)accountID)) {
                Print.logError((String)"Account not specified!", (Object[])new Object[0]);
                return new OrderedSet();
            }
            entList = new OrderedSet();
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(Entity.getFactory());
                dsel.setSelectedFields(new String[]{"accountID", FLD_entityID});
                DBWhere dwh = dsel.createDBWhere();
                dsel.setWhere(dwh.WHERE(dwh.EQ("accountID", (Object)accountID)));
                dsel.setOrderByFields(new String[]{FLD_entityID});
                dsel.setLimit(limit);
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                while (rs.next()) {
                    String entId = rs.getString(FLD_entityID);
                    entList.add((Object)entId);
                }
                if (rs == null) break block17;
            }
            catch (SQLException sqe) {
                try {
                    throw new DBException("Getting Account Entity List", (Throwable)sqe);
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release((DBConnection)dbc);
        return entList;
    }

    public static boolean exists(String accountID, String entityID, long entityType) throws DBException {
        if (accountID != null && entityID != null) {
            Key entKey = new Key(accountID, entityID, entityType);
            return entKey.exists();
        }
        return false;
    }

    public static Entity createNewEntity(Account account, String entityID, long entityType, String description) throws DBException {
        if (account != null && entityID != null && !entityID.equals("")) {
            Entity entity = Entity.getEntity(account, entityID, entityType, true);
            if (description != null && !description.equals("")) {
                entity.setDescription(description);
            }
            entity.save();
            return entity;
        }
        throw new DBException("Invalid Account/EntityID specified");
    }

    private static void usage() {
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + Entity.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  -account=<id>   Account ID owning Entity", (Object[])new Object[0]);
        Print.logInfo((String)"  -entity=<id>    Entity ID to delete/edit", (Object[])new Object[0]);
        Print.logInfo((String)"  -create         Create a new Entity", (Object[])new Object[0]);
        Print.logInfo((String)"  -edit           To edit an existing Entity", (Object[])new Object[0]);
        Print.logInfo((String)"  -delete         Delete specified Entity", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        String accountID = RTConfig.getString((String[])ARG_ACCOUNT, (String)"");
        String entityID = RTConfig.getString((String[])ARG_ENTITY, (String)"");
        long entityType = RTConfig.getLong((String[])ARG_TYPE, (long)0L);
        if (accountID == null || accountID.equals("")) {
            Print.logError((String)"Account-ID not specified.", (Object[])new Object[0]);
            Entity.usage();
        }
        Account account = null;
        try {
            account = Account.getAccount(accountID);
            if (account == null) {
                Print.logError((String)("Account-ID does not exist: " + accountID), (Object[])new Object[0]);
                Entity.usage();
            }
        }
        catch (DBException dbe) {
            Print.logException((String)("Error loading Account: " + accountID), (Throwable)dbe);
            System.exit(99);
        }
        boolean entitySpecified = entityID != null && !entityID.equals("");
        boolean entityExists = false;
        if (entitySpecified) {
            try {
                entityExists = Entity.exists(accountID, entityID, entityType);
            }
            catch (DBException dbe) {
                Print.logError((String)("Error determining if Entity exists: " + accountID + "/" + entityID + "/" + entityType), (Object[])new Object[0]);
                System.exit(99);
            }
        }
        int opts = 0;
        if (RTConfig.getBoolean((String[])ARG_DELETE, (boolean)false)) {
            ++opts;
            if (!entitySpecified) {
                Print.logWarn((String)"Entity name not specified ...", (Object[])new Object[0]);
                Entity.usage();
            } else if (!entityExists) {
                Print.logWarn((String)("Entity does not exist: " + accountID + "/" + entityID + "/" + entityType), (Object[])new Object[0]);
                Print.logWarn((String)"Continuing with delete process ...", (Object[])new Object[0]);
            }
            try {
                Key entKey = new Key(accountID, entityID, entityType);
                entKey.delete(true);
                Print.logInfo((String)("Entity deleted: " + accountID + "/" + entityID), (Object[])new Object[0]);
                entityExists = false;
            }
            catch (DBException dbe) {
                Print.logError((String)("Error deleting Entity: " + accountID + "/" + entityID + "/" + entityType), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_CREATE, (boolean)false)) {
            ++opts;
            if (!entitySpecified) {
                Print.logWarn((String)"Entity name not specified ...", (Object[])new Object[0]);
                Entity.usage();
            } else if (entityExists) {
                Print.logWarn((String)("Entity already exists: " + accountID + "/" + entityID + "/" + entityType), (Object[])new Object[0]);
            } else {
                try {
                    Entity.createNewEntity(account, entityID, entityType, null);
                    Print.logInfo((String)("Created Entity: " + accountID + "/" + entityID), (Object[])new Object[0]);
                    entityExists = true;
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error creating Entity: " + accountID + "/" + entityID), (Object[])new Object[0]);
                    dbe.printException();
                    System.exit(99);
                }
            }
        }
        if (RTConfig.getBoolean((String[])ARG_EDIT, (boolean)false) || RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false)) {
            ++opts;
            if (!entitySpecified) {
                Print.logWarn((String)"Entity name not specified ...", (Object[])new Object[0]);
                Entity.usage();
            } else if (!entityExists) {
                Print.logError((String)("Entity does not exist: " + accountID + "/" + entityID + "/" + entityType), (Object[])new Object[0]);
            } else {
                try {
                    boolean allFlds = RTConfig.getBoolean((String[])ARG_EDITALL, (boolean)false);
                    Entity entity = Entity.getEntity(account, entityID, entityType, false);
                    DBEdit editor = new DBEdit((DBRecord)entity);
                    editor.edit(allFlds);
                }
                catch (IOException ioe) {
                    if (ioe instanceof EOFException) {
                        Print.logError((String)"End of input", (Object[])new Object[0]);
                    } else {
                        Print.logError((String)"IO Error", (Object[])new Object[0]);
                    }
                }
                catch (DBException dbe) {
                    Print.logError((String)("Error editing Entity: " + accountID + "/" + entityID + "/" + entityType), (Object[])new Object[0]);
                    dbe.printException();
                }
            }
            System.exit(0);
        }
        if (RTConfig.getBoolean((String[])ARG_LIST, (boolean)false)) {
            ++opts;
            try {
                Entity[] entityList = Entity.getEntitiesForAccount(accountID);
                for (int i = 0; i < entityList.length; ++i) {
                    Entity e = entityList[i];
                    Print.logInfo((String)("  Entity      : " + e.getAccountID() + "/" + e.getEntityID() + "/" + e.getEntityType() + " [" + e.getDescription() + "]"), (Object[])new Object[0]);
                    Print.logInfo((String)("    isAttached: " + e.getIsAttached() + " [" + e.getDeviceID() + "]"), (Object[])new Object[0]);
                    Print.logInfo((String)("    GeoPoint  : " + e.getGeoPoint()), (Object[])new Object[0]);
                    Print.logInfo((String)("    Address   : " + e.getAddress()), (Object[])new Object[0]);
                    Print.logInfo((String)("    OdometerKM: " + e.getOdometerKM() + " [" + e.getOdometerKM() * 0.621371192237334 + " miles]"), (Object[])new Object[0]);
                }
            }
            catch (DBException dbe) {
                Print.logError((String)("Error listing Entities: " + accountID), (Object[])new Object[0]);
                dbe.printException();
                System.exit(99);
            }
            System.exit(0);
        }
        if (opts == 0) {
            Print.logWarn((String)"Missing options ...", (Object[])new Object[0]);
            Entity.usage();
        }
    }

    public static class Key
    extends AccountRecord.AccountKey<Entity> {
        public Key() {
        }

        public Key(String accountId, String entityId, long entityType) {
            super.setKeyValue("accountID", (Object)(accountId != null ? accountId.toLowerCase() : ""));
            super.setKeyValue(Entity.FLD_entityID, (Object)(entityId != null ? entityId.toLowerCase() : ""));
            super.setKeyValue(Entity.FLD_entityType, entityType);
        }

        public DBFactory<Entity> getFactory() {
            return Entity.getFactory();
        }
    }
}

