/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.tables;

import java.util.Locale;
import org.opengts.db.AccountRecord;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.DeviceRecord;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.I18N;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class Antx
extends DeviceRecord<Antx> {
    public static final int TYPE_VALUE = 0;
    public static final int TYPE_MINMAX = 1;
    public static final int TYPE_BIN = 2;
    public static final String _TABLE_NAME = "Antx";
    public static final String FLD_timestamp = "timestamp";
    public static final String FLD_fieldID = "fieldID";
    public static final String FLD_channelID = "channelID";
    public static final String FLD_type = "type";
    public static final String FLD_data0 = "data0";
    public static final String FLD_data1 = "data1";
    public static final String FLD_data2 = "data2";
    public static final String FLD_data3 = "data3";
    public static final String FLD_data4 = "data4";
    private static DBField[] FieldInfo = new DBField[]{AccountRecord.newField_accountID(true), DeviceRecord.newField_deviceID(true), new DBField("timestamp", Long.TYPE, "UINT32", "Timestamp", "key=true"), new DBField("fieldID", Integer.TYPE, "INT32", "Field Number", "key=true"), new DBField("channelID", Integer.TYPE, "INT32", "Channel Number", "key=true"), new DBField("type", Integer.TYPE, "INT16", "Type", ""), new DBField("data0", Double.TYPE, "DOUBLE", "Data 0", "format=#0.0"), new DBField("data1", Double.TYPE, "DOUBLE", "Data 1", "format=#0.0"), new DBField("data2", Double.TYPE, "DOUBLE", "Data 2", "format=#0.0"), new DBField("data3", Double.TYPE, "DOUBLE", "Data 3", "format=#0.0"), new DBField("data4", Double.TYPE, "DOUBLE", "Data 4", "format=#0.0"), Antx.newField_creationTime()};
    private static DBFactory<Antx> factory = null;

    public static String TABLE_NAME() {
        return DBProvider._translateTableName((String)_TABLE_NAME);
    }

    public static DBFactory<Antx> getFactory() {
        if (factory == null) {
            factory = DBFactory.createDBFactory((String)Antx.TABLE_NAME(), (DBField[])FieldInfo, (DBFactory.KeyType)DBFactory.KeyType.PRIMARY, Antx.class, Key.class, (boolean)true, (boolean)true);
            factory.addParentTable(Account.TABLE_NAME());
            factory.addParentTable(Device.TABLE_NAME());
        }
        return factory;
    }

    public Antx() {
    }

    public Antx(Key key) {
        super(key);
    }

    public static String getTableDescription(Locale loc) {
        I18N i18n = I18N.getI18N(Antx.class, (Locale)loc);
        return i18n.getString("Antx.description", "This table contains Antx Messenger information.");
    }

    public long getTimestamp() {
        Long v = (Long)this.getFieldValue(FLD_timestamp);
        return v != null ? v : 0L;
    }

    public void setTimestamp(long v) {
        this.setFieldValue(FLD_timestamp, v);
    }

    public String getTimestampString() {
        Account a = this.getAccount();
        String dateFmt = a != null ? a.getDateFormat() : BasicPrivateLabel.getDefaultDateFormat();
        String timeFmt = a != null ? a.getTimeFormat() : BasicPrivateLabel.getDefaultTimeFormat();
        DateTime dt = new DateTime(this.getTimestamp());
        return dt.gmtFormat(dateFmt + " " + timeFmt + " z");
    }

    public int getFieldID() {
        Integer v = (Integer)this.getFieldValue(FLD_fieldID);
        return v != null ? v : 0;
    }

    public void setFieldID(int v) {
        this.setFieldValue(FLD_fieldID, v);
    }

    public int getChannelID() {
        Integer v = (Integer)this.getFieldValue(FLD_channelID);
        return v != null ? v : 0;
    }

    public void setChannelID(int v) {
        this.setFieldValue(FLD_channelID, v);
    }

    public int getType() {
        Integer v = (Integer)this.getFieldValue(FLD_type);
        return v != null ? v : 0;
    }

    public void setType(int v) {
        this.setFieldValue(FLD_type, v);
    }

    public double getData0() {
        Double v = (Double)this.getFieldValue(FLD_data0);
        return v != null ? v : 0.0;
    }

    public void setData0(double v) {
        this.setFieldValue(FLD_data0, v);
    }

    public double getData1() {
        Double v = (Double)this.getFieldValue(FLD_data1);
        return v != null ? v : 0.0;
    }

    public void setData1(double v) {
        this.setFieldValue(FLD_data1, v);
    }

    public double getData2() {
        Double v = (Double)this.getFieldValue(FLD_data2);
        return v != null ? v : 0.0;
    }

    public void setData2(double v) {
        this.setFieldValue(FLD_data2, v);
    }

    public double getData3() {
        Double v = (Double)this.getFieldValue(FLD_data3);
        return v != null ? v : 0.0;
    }

    public void setData3(double v) {
        this.setFieldValue(FLD_data3, v);
    }

    public double getData4() {
        Double v = (Double)this.getFieldValue(FLD_data4);
        return v != null ? v : 0.0;
    }

    public void setData4(double v) {
        this.setFieldValue(FLD_data4, v);
    }

    private static Key createKey(Device device, long timestamp, int field, int channel) {
        if (device != null) {
            String acctID = device.getAccountID();
            String devID = device.getDeviceID();
            Key key = new Key(acctID, devID, timestamp, field, channel);
            return key;
        }
        return null;
    }

    public static boolean addEvent(Device device, long timestamp, int field, int channel, double value) {
        return Antx.addEvent(device, timestamp, field, channel, 0, value, 0.0, 0.0, 0.0, 0.0);
    }

    public static boolean addEvent(Device device, long timestamp, int field, int channel, double minValue, double maxValue) {
        return Antx.addEvent(device, timestamp, field, channel, 1, minValue, maxValue, 0.0, 0.0, 0.0);
    }

    public static boolean addEvent(Device device, long timestamp, int field, int channel, double data0, double data1, double data2, double data3, double data4) {
        return Antx.addEvent(device, timestamp, field, channel, 2, data0, data1, data2, data3, data4);
    }

    public static boolean addEvent(Device device, long timestamp, int field, int channel, int type, double data0, double data1, double data2, double data3, double data4) {
        Key key = Antx.createKey(device, timestamp, field, channel);
        if (key != null) {
            Antx rcd = (Antx)key.getDBRecord();
            rcd.setType(type);
            rcd.setData0(data0);
            rcd.setData1(data1);
            rcd.setData2(data2);
            rcd.setData3(data3);
            rcd.setData4(data4);
            try {
                rcd.save();
                return true;
            }
            catch (DBException dbe) {
                Print.logError((String)("Unable to save Antx record: " + (Object)((Object)dbe)), (Object[])new Object[0]);
                return false;
            }
        }
        return false;
    }

    public static void getRecordCallback(DBRecordHandler<Antx> rcdHandler, String accountID, String deviceID, long startTime, long endTime, long limit) throws DBException {
        if (startTime > 0L && endTime > 0L && startTime > endTime) {
            return;
        }
        DBSelect dsel = new DBSelect(Antx.getFactory());
        dsel.setOrderByFields(new String[]{"accountID", "deviceID", FLD_timestamp});
        dsel.setOrderAscending(true);
        dsel.setLimit(limit);
        DBWhere dwh = new DBWhere(Antx.getFactory());
        dwh.append(dwh.AND(dwh.EQ("accountID", (Object)StringTools.trim((String)accountID)), dwh.EQ("deviceID", (Object)StringTools.trim((String)deviceID))));
        if (startTime >= 0L) {
            dwh.append(dwh.AND_(dwh.GE(FLD_timestamp, startTime)));
        }
        if (endTime >= 0L && endTime >= startTime) {
            dwh.append(dwh.AND_(dwh.LE(FLD_timestamp, endTime)));
        }
        dsel.setWhere(dwh.toString());
        Print.logInfo((String)("Where: " + dwh), (Object[])new Object[0]);
        DBRecord.select((DBSelect)dsel, rcdHandler);
    }

    public static class Key
    extends DeviceRecord.DeviceKey<Antx> {
        public Key() {
        }

        public Key(String acctId, String devId, long timestamp, int field, int channel) {
            super.setKeyValue("accountID", (Object)(acctId != null ? acctId.toLowerCase() : ""));
            super.setKeyValue("deviceID", (Object)(devId != null ? devId.toLowerCase() : ""));
            super.setKeyValue(Antx.FLD_timestamp, timestamp);
            super.setKeyValue(Antx.FLD_fieldID, field);
            super.setKeyValue(Antx.FLD_channelID, channel);
        }

        public DBFactory<Antx> getFactory() {
            return Antx.getFactory();
        }
    }
}

