/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.service;

import java.util.Map;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class ServiceMessage {
    private static Map<String, ServiceMessage> MessageMap = new OrderedMap();
    public static final ServiceMessage MSG_SUCCESSFUL = ServiceMessage.okMsg("OK0000", "Successful");
    public static final ServiceMessage MSG_COMMAND_MISSING = ServiceMessage.errMsg("CM0010", "Command invalid");
    public static final ServiceMessage MSG_COMMAND_UNSUPPORTED = ServiceMessage.errMsg("CM0011", "Command not supported");
    public static final ServiceMessage MSG_COMMAND_DISABLED = ServiceMessage.errMsg("CM0015", "Command disabled");
    public static final ServiceMessage MSG_COMMAND_NOTAUTH = ServiceMessage.errMsg("CM0020", "Command not authorized");
    public static final ServiceMessage MSG_AUTH_FAILED;
    public static final ServiceMessage MSG_ACCOUNT_INVALID;
    public static final ServiceMessage MSG_ACCOUNT_INACTIVE;
    public static final ServiceMessage MSG_ACCOUNT_EXPIRED;
    public static final ServiceMessage MSG_ACCOUNT_HOST;
    public static final ServiceMessage MSG_ACCOUNT_COMMAND;
    public static final ServiceMessage MSG_USER_INVALID;
    public static final ServiceMessage MSG_USER_INACTIVE;
    public static final ServiceMessage MSG_DEVICE_INVALID;
    public static final ServiceMessage MSG_GROUP_INVALID;
    public static final ServiceMessage MSG_DATETIME;
    public static final ServiceMessage MSG_PRIVATE_XML_SYNTAX;
    public static final ServiceMessage MSG_PRIVATE_XML_CONFIG;
    public static final ServiceMessage MSG_URL_NOT_ALLOWED;
    public static final ServiceMessage MSG_REQUEST_DISABLED;
    public static final ServiceMessage MSG_REQUEST_POST_REQUIRED;
    public static final ServiceMessage MSG_REQUEST_XML_SYNTAX;
    public static final ServiceMessage MSG_REQUEST_SOAP_XML_SYNTAX;
    public static final ServiceMessage MSG_REQUEST_XML_INVALID;
    public static final ServiceMessage MSG_REQUEST_NOT_SUPPORTED;
    public static final ServiceMessage MSG_BAD_TABLE;
    public static final ServiceMessage MSG_BAD_RECORD_KEY;
    public static final ServiceMessage MSG_BAD_RECORD;
    public static final ServiceMessage MSG_NOT_FOUND;
    public static final ServiceMessage MSG_ALREADY_EXISTS;
    public static final ServiceMessage MSG_READ_FAILED;
    public static final ServiceMessage MSG_UPDATE_FAILED;
    public static final ServiceMessage MSG_INSERT_FAILED;
    public static final ServiceMessage MSG_DELETE_FAILED;
    public static final ServiceMessage MSG_PROP_BAD_KEY;
    public static final ServiceMessage MSG_NO_REPORT_SPECIFIED;
    public static final ServiceMessage MSG_REPORT_NOT_FOUND;
    public static final ServiceMessage MSG_REPORT_INVALID_NAME;
    public static final ServiceMessage MSG_REPORT_DEVICE;
    public static final ServiceMessage MSG_REPORT_CREATE;
    public static final ServiceMessage MSG_REPORT_GENERAL_ERROR;
    public static final ServiceMessage MSG_REPORT_UNEXPECTED;
    public static final ServiceMessage MSG_MAP_NOT_FOUND;
    public static final ServiceMessage MSG_CUSTOM_NOT_SUPPORTED;
    public static final ServiceMessage MSG_CUSTOM_TYPE_INVALID;
    private boolean isError = false;
    private String code = null;
    private String message = null;

    private static ServiceMessage errMsg(String c, String m) {
        return new ServiceMessage(true, c, m);
    }

    private static ServiceMessage okMsg(String c, String m) {
        return new ServiceMessage(false, c, m);
    }

    public static Map<String, ServiceMessage> getMessageMap() {
        return MessageMap;
    }

    public static ServiceMessage getMessageForCode(String code) {
        if (StringTools.isBlank((String)code)) {
            return null;
        }
        return MessageMap.get(code);
    }

    public ServiceMessage(boolean isError, String code, String msg) {
        this.isError = isError;
        this.code = code;
        this.message = msg;
        if (MessageMap.containsKey(code)) {
            Print.logWarn((String)("Message code already defined: " + code), (Object[])new Object[0]);
        }
        MessageMap.put(code, this);
    }

    public boolean isError() {
        return this.isError;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessage(String text) {
        if (StringTools.isBlank((String)text)) {
            return this.message;
        }
        return this.message + " [" + text + "]";
    }

    public boolean isServiceDisabledError() {
        return this.equals(MSG_REQUEST_DISABLED);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getCode());
        sb.append(": ");
        sb.append(this.getMessage());
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof ServiceMessage) {
            return ((ServiceMessage)other).getCode().equals(this.getCode());
        }
        return false;
    }

    static {
        MSG_ACCOUNT_INVALID = MSG_AUTH_FAILED = ServiceMessage.errMsg("AU0010", "Authorization failed");
        MSG_ACCOUNT_INACTIVE = ServiceMessage.errMsg("AC0020", "Account inactive");
        MSG_ACCOUNT_EXPIRED = ServiceMessage.errMsg("AC0030", "Account expired");
        MSG_ACCOUNT_HOST = ServiceMessage.errMsg("AC0040", "Account not authorized for host");
        MSG_ACCOUNT_COMMAND = ServiceMessage.errMsg("AC0042", "Account not authorized for command");
        MSG_USER_INVALID = MSG_AUTH_FAILED;
        MSG_USER_INACTIVE = ServiceMessage.errMsg("US0020", "User inactive");
        MSG_DEVICE_INVALID = ServiceMessage.errMsg("DV0010", "DeviceID invalid");
        MSG_GROUP_INVALID = ServiceMessage.errMsg("GR0010", "DeviceGroup ID invalid");
        MSG_DATETIME = ServiceMessage.errMsg("DT0010", "from/to date invalid");
        MSG_PRIVATE_XML_SYNTAX = ServiceMessage.errMsg("PL0010", "'private.xml' syntax/parsing errors");
        MSG_PRIVATE_XML_CONFIG = ServiceMessage.errMsg("PL0020", "'private.xml' configuration errors");
        MSG_URL_NOT_ALLOWED = ServiceMessage.errMsg("PL0030", "Specified URL not allowed");
        MSG_REQUEST_DISABLED = ServiceMessage.errMsg("RQ0010", "Service Request disabled");
        MSG_REQUEST_POST_REQUIRED = ServiceMessage.errMsg("RQ0020", "Request XML requires 'POST'");
        MSG_REQUEST_XML_SYNTAX = ServiceMessage.errMsg("RQ0030", "Request XML syntax errors");
        MSG_REQUEST_SOAP_XML_SYNTAX = ServiceMessage.errMsg("RQ0031", "SOAP XML syntax error");
        MSG_REQUEST_XML_INVALID = ServiceMessage.errMsg("RQ0040", "Request XML is invalid");
        MSG_REQUEST_NOT_SUPPORTED = ServiceMessage.errMsg("RQ0050", "Request not supported");
        MSG_BAD_TABLE = ServiceMessage.errMsg("DB0010", "Invalid table name");
        MSG_BAD_RECORD_KEY = ServiceMessage.errMsg("DB0020", "Invalid DBRecordKey");
        MSG_BAD_RECORD = ServiceMessage.errMsg("DB0030", "Invalid DBRecord");
        MSG_NOT_FOUND = ServiceMessage.errMsg("DB0040", "Record not found");
        MSG_ALREADY_EXISTS = ServiceMessage.errMsg("DB0045", "Record already exists");
        MSG_READ_FAILED = ServiceMessage.errMsg("DB0050", "Record read failed");
        MSG_UPDATE_FAILED = ServiceMessage.errMsg("DB0060", "Record update failed");
        MSG_INSERT_FAILED = ServiceMessage.errMsg("DB0065", "Record insert failed");
        MSG_DELETE_FAILED = ServiceMessage.errMsg("DB0070", "Record delete failed");
        MSG_PROP_BAD_KEY = ServiceMessage.errMsg("PR0010", "Invalid property key");
        MSG_NO_REPORT_SPECIFIED = ServiceMessage.errMsg("RP0007", "No Report specified");
        MSG_REPORT_NOT_FOUND = ServiceMessage.errMsg("RP0010", "Report not found");
        MSG_REPORT_INVALID_NAME = ServiceMessage.errMsg("RP0015", "Invalid report name");
        MSG_REPORT_DEVICE = ServiceMessage.errMsg("RP0030", "Report missing Device/Group");
        MSG_REPORT_CREATE = ServiceMessage.errMsg("RP0040", "Unable to create report");
        MSG_REPORT_GENERAL_ERROR = ServiceMessage.errMsg("RP0800", "Reporting Error occurred");
        MSG_REPORT_UNEXPECTED = ServiceMessage.errMsg("RP0999", "Unexpected Reporting Error");
        MSG_MAP_NOT_FOUND = ServiceMessage.errMsg("MP0010", "MapProvider not found");
        MSG_CUSTOM_NOT_SUPPORTED = ServiceMessage.errMsg("CU0010", "Custom command not supported");
        MSG_CUSTOM_TYPE_INVALID = ServiceMessage.errMsg("CU0020", "Custom type invalid");
    }
}

